// functions to handle widgets

GtkWidget	*FindWidget (GtkWidget *StartWidget, const char *WidgetName);

int			Opened (GtkWidget *CheckWidget);

int			GetOptionMenuIndex (GtkWidget *ParentWidget, const char *OptionMenuName);
void		SetOptionMenuIndex (GtkWidget *ParentWidget, const char *OptionMenuName, int OptionMenuIndex);

int			GetSpinButtonInt (GtkWidget *ParentWidget, const char *SpinButtonName);
float		GetSpinButtonFloat (GtkWidget *ParentWidget, const char *SpinButtonName);
void		SetSpinButtonValue (GtkWidget *ParentWidget, const char *SpinButtonName, float SpinButtonValue);

void		SetEntry (GtkWidget *ParentWidget, const char *EntryName, const char *EntryText);
G_CONST_RETURN
gchar		*GetEntry (GtkWidget *ParentWidget, const char *EntryName);

void		SetGnomeFileEntry (GtkWidget *ParentWidget, const char *FileEntryName, const char *DefaultPath);
void		GetGnomeFileEntry (GtkWidget *ParentWidget, const char *FileEntryName, char *ResultString);

void		SetCheckBox (GtkWidget *ParentWidget, const char *CheckBoxName, int CheckButtonStatus);
int			GetCheckBox (GtkWidget *ParentWidget, const char *CheckBoxName);

void		SetDateTime (GtkWidget *ParentWidget, const char *DateTimeName, time_t DateTimeValue);
time_t		GetDateTime (GtkWidget *ParentWidget, const char *DateTimeName);

char		*ConvertTime (const time_t DateTimeValue);
char		*ConvertShortDate (const time_t DateTimeValue);

void		ActivateWidget (GtkWidget *ParentWidget, const char *ActWidgetName, int WidgetStatus);
void		HideWidget (GtkWidget *ParentWidget, const char *HideWidgetName);
void		ShowWidget (GtkWidget *ParentWidget, const char *ShowWidgetName);

int			GetPrivatDataInt (GtkWidget *TargetWidget, const char *PrivatDataName);
void		SetPrivatDataInt (GtkWidget *TargetWidget, const char *PrivatDataName, int PrivatData);

void		*GetPrivatDataPointer (GtkWidget *TargetWidget, const char *PrivatDataName);
void		SetPrivatDataPointer (GtkWidget *TargetWidget, const char *PrivatDataName, void *PrivatData);

GtkWidget	*get_toplevel_of_menuitem (GtkWidget *widget);

// Own dialogs

void		on_ErrorFilenameCloseButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void		create_FilenameErrorDialog (GtkWidget *CallerWindow, char *MessageText, char *TitleText);
