// functions to handle widgets

extern GtkWidget *FindWidget (GtkWidget *StartWidget, const char *WidgetName) {
GtkWidget	*TempWidget;
  TempWidget = lookup_widget (StartWidget, WidgetName);
  return TempWidget;
} // FindWidget

extern int
Opened (GtkWidget *CheckWidget) {
int		AlreadyOpened;

	AlreadyOpened = TRUE;
	if (CheckWidget == NULL) AlreadyOpened = FALSE;

	return AlreadyOpened;
} // Opened

extern int
GetOptionMenuIndex (GtkWidget *ParentWidget, const char *OptionMenuName) {
GtkWidget *GetWidget;

gint GetIndex;

	GetWidget=lookup_widget(ParentWidget, OptionMenuName);
	GetIndex = gtk_option_menu_get_history (GTK_OPTION_MENU (GetWidget));
	if (GetIndex < 0) GetIndex = 0;

	return GetIndex;
} // GetOptionMenuIndex

extern void
SetOptionMenuIndex (GtkWidget *ParentWidget, const char *OptionMenuName, int OptionMenuIndex) {
GtkWidget *SetWidget;

	SetWidget=lookup_widget(ParentWidget, OptionMenuName);
	gtk_option_menu_set_history(GTK_OPTION_MENU(SetWidget), OptionMenuIndex);
} // GetOptionMenuIndex

extern int
GetSpinButtonInt (GtkWidget *ParentWidget, const char *SpinButtonName) {
GtkWidget	*GetWidget;
int			GSI;

	GetWidget=lookup_widget(ParentWidget, SpinButtonName);
	GSI = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(GetWidget));
	return GSI;
} // GetSpinButtonInt

extern float
GetSpinButtonFloat (GtkWidget *ParentWidget, const char *SpinButtonName) {
GtkWidget	*GetWidget;
float		GSF;

	GetWidget=lookup_widget(ParentWidget, SpinButtonName);
	GSF = gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON(GetWidget));
	return GSF;
} // GetSpinButtonFloat

extern void
SetSpinButtonValue (GtkWidget *ParentWidget, const char *SpinButtonName, float SpinButtonValue) {
GtkWidget *SetWidget;

	SetWidget=lookup_widget(ParentWidget, SpinButtonName);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(SetWidget), SpinButtonValue);
} // SetSpinButtonValue

extern void
SetEntry (GtkWidget *ParentWidget, const char *EntryName, const char *EntryText) {
GtkWidget *SetWidget;

	SetWidget=lookup_widget(ParentWidget, EntryName);
	gtk_entry_set_text (GTK_ENTRY(SetWidget), EntryText);
} // SetEntry

extern G_CONST_RETURN gchar
*GetEntry (GtkWidget *ParentWidget, const char *EntryName) {
GtkWidget	*GetWidget;
G_CONST_RETURN
gchar		*EText;

	GetWidget=lookup_widget(ParentWidget, EntryName);
	EText = gtk_entry_get_text (GTK_ENTRY(GetWidget));
	return EText;
} // GetEntry

extern void
SetGnomeFileEntry (GtkWidget *ParentWidget, const char *FileEntryName, const char *DefaultPath) {
GtkWidget *SetWidget;

	SetWidget=lookup_widget(ParentWidget, FileEntryName);
	gnome_file_entry_set_default_path (GNOME_FILE_ENTRY(SetWidget), DefaultPath);
	gtk_entry_set_text (GTK_ENTRY (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY(SetWidget))), DefaultPath);
} // SetGnomeFileEntry

extern void
GetGnomeFileEntry (GtkWidget *ParentWidget, const char *FileEntryName, char *ResultString) {
GtkWidget	*GetWidget;
char		*EText;

  GetWidget=lookup_widget(ParentWidget, FileEntryName);
  EText = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY (GetWidget), FALSE);
  if (EText != NULL) strcpy (ResultString, EText);
  g_free (EText);
} // GetGnomeFileEntry

extern void
SetCheckBox (GtkWidget *ParentWidget, const char *CheckBoxName, int CheckButtonStatus) {
GtkWidget	*SetWidget;

	SetWidget=lookup_widget(ParentWidget, CheckBoxName);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(SetWidget), CheckButtonStatus);
} // SetCheckBox

extern int
GetCheckBox (GtkWidget *ParentWidget, const char *CheckBoxName) {
GtkWidget	*GetWidget;
int			CheckBoxRetVal;

	GetWidget = lookup_widget(ParentWidget, CheckBoxName);
	CheckBoxRetVal = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(GetWidget));
	return CheckBoxRetVal;
} // GetCheckBox

extern void
SetDateTime (GtkWidget *ParentWidget, const char *DateTimeName, time_t DateTimeValue) {
GtkWidget	*SetWidget;

	SetWidget = lookup_widget (ParentWidget, DateTimeName);
	gnome_date_edit_set_time (GNOME_DATE_EDIT (SetWidget), DateTimeValue);
} // SetDateTime

extern time_t
GetDateTime (GtkWidget *ParentWidget, const char *DateTimeName) {
GtkWidget	*GetWidget;
time_t		RetDateTime;

	GetWidget = lookup_widget (ParentWidget, DateTimeName);
	RetDateTime = gnome_date_edit_get_time (GNOME_DATE_EDIT (GetWidget));
	return RetDateTime;
} // GetDateTime

extern char
*ConvertTime (const time_t DateTimeValue) {
char	*TempTime;

	TempTime = ctime (&DateTimeValue);
	strcpy (ASCIITime, TempTime);
	ASCIITime[strlen (ASCIITime)-1] = '\0';
	free (TempTime);
	return (ASCIITime);
} // ConvertTime

extern char
*ConvertShortDate (const time_t DateTimeValue) {
time_t	curtime;
struct	tm *loctime;
char	TimeFormat[10];

	curtime = DateTimeValue;
	loctime = localtime (&curtime);
	strcpy (TimeFormat, " %F");
	strftime (ASCIITime, 100, TimeFormat, loctime);

//	ASCIITime[strlen (ASCIITime)-1] = '\0';
	return (ASCIITime);
} // ConvertShortDate

extern void
ActivateWidget (GtkWidget *ParentWidget, const char *ActWidgetName, int WidgetStatus) {
GtkWidget	*ActWidget;

	ActWidget = lookup_widget(ParentWidget, ActWidgetName);
	gtk_widget_set_sensitive (ActWidget, WidgetStatus);
} // ActivateWidget

extern void
HideWidget (GtkWidget *ParentWidget, const char *HideWidgetName) {
GtkWidget	*HidWidget;

	HidWidget = lookup_widget(ParentWidget, HideWidgetName);
	gtk_widget_hide (HidWidget);
} // HideWidget

extern void
ShowWidget (GtkWidget *ParentWidget, const char *ShowWidgetName) {
GtkWidget	*ShoWidget;

	ShoWidget = lookup_widget(ParentWidget, ShowWidgetName);
	gtk_widget_show (ShoWidget);
} // ShowWidget

extern int
GetPrivatDataInt (GtkWidget *TargetWidget, const char *PrivatDataName) {
  return GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (TargetWidget), PrivatDataName));
} // GetPrivatDataInt

extern void
SetPrivatDataInt (GtkWidget *TargetWidget, const char *PrivatDataName, int PrivatData) {
  gtk_object_set_data (GTK_OBJECT (TargetWidget), PrivatDataName, GINT_TO_POINTER (PrivatData));
} // SetPrivatDataInt

extern void
*GetPrivatDataPointer (GtkWidget *TargetWidget, const char *PrivatDataName) {
  return gtk_object_get_data (GTK_OBJECT (TargetWidget), PrivatDataName);
} // GetPrivatDataPointer

extern void
SetPrivatDataPointer (GtkWidget *TargetWidget, const char *PrivatDataName, void *PrivatData) {
  gtk_object_set_data (GTK_OBJECT (TargetWidget), PrivatDataName, PrivatData);
} // SetPrivatDataPointer

extern GtkWidget
*get_toplevel_of_menuitem (GtkWidget *widget)
{
  GtkWidget *parent;

  for (;;)
  {
    if (GTK_IS_MENU (widget))
      parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
    else
      parent = widget->parent;
    if (parent == NULL)
      break;
    widget = parent;
  }
  return (widget);
} // get_toplevel_of_menuitem

extern void
on_ErrorFilenameCloseButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
} // on_ErrorFilenameCloseButton_clicked

extern void
create_FilenameErrorDialog (GtkWidget *CallerWindow, char *MessageText, char *TitleText)
{
  GtkWidget *FilenameErrorDialog;
  GtkWidget *FilenameErrorVBox;
  GtkWidget *ErrorFilenameHButtonBox;
  GtkWidget *ErrorFilenameCloseButton;

  FilenameErrorDialog = gnome_message_box_new (MessageText,
                              GNOME_MESSAGE_BOX_ERROR, NULL);
  gtk_window_set_title (GTK_WINDOW (FilenameErrorDialog), TitleText);
  gtk_window_set_resizable (GTK_WINDOW (FilenameErrorDialog), FALSE);

  FilenameErrorVBox = GNOME_DIALOG (FilenameErrorDialog)->vbox;
  gtk_widget_show (FilenameErrorVBox);

  ErrorFilenameHButtonBox = GNOME_DIALOG (FilenameErrorDialog)->action_area;
  gtk_widget_show (ErrorFilenameHButtonBox);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (ErrorFilenameHButtonBox), GTK_BUTTONBOX_END);

  gnome_dialog_append_button (GNOME_DIALOG (FilenameErrorDialog), "gtk-close");
  ErrorFilenameCloseButton = GTK_WIDGET (g_list_last (GNOME_DIALOG (FilenameErrorDialog)->buttons)->data);
  gtk_widget_show (ErrorFilenameCloseButton);
  GTK_WIDGET_SET_FLAGS (ErrorFilenameCloseButton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) ErrorFilenameCloseButton, "clicked",
                    G_CALLBACK (on_ErrorFilenameCloseButton_clicked),
                    NULL);

  gtk_window_set_modal (GTK_WINDOW (FilenameErrorDialog), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (FilenameErrorDialog), GTK_WINDOW (CallerWindow));
  gtk_widget_show (FilenameErrorDialog);
} // FilenameErrorDialog
