GladeXML *NetCDFxml;

// System variables

pid_t			PIDTable[MaxInstruments + 1];
int				InstrumentPIDStatusChanged;
gint			CentralTimeoutID;

pthread_mutex_t	bug_report_mutex;

int				ActualInstrument;										// LC2

struct			SoftwareStruct LC2;

struct			InstrumentStruct WorkInstruments;
struct			InstrumentParamStruct WorkInstrument[MaxInstrument];
struct			ADParametersStruct WorkAD;

gboolean		MainThreadLock;

// Measure

pthread_t		measure_thread;
pthread_t		convert_threads[MaxInstrument];
int				convert_i[MaxInstrument];
int				convert_done[MaxInstrument];
pthread_t		prepare_next_threads[MaxInstrument];
int				prepare_next_i[MaxInstrument];
int				prepare_next_done[MaxInstrument];
pthread_mutex_t	measure_data_mutex;
pthread_mutex_t	measure_parameter_mutex;
pthread_mutex_t	measure_command_mutex;
int				ThreadExit;						// Exit from thread command
int				ThreadExitOk;					// Exited from thread
int				ThreadStatus[MaxInstrument];	// Idle, Run, etc...
int				ThreadCmdChannel;				// Main Channel to receive the command
int				ThreadCommand;					// Start, stop, cancel, etc.
int				ThreadCommandOk;				// Ack signal, command executed
int				ThreadCommandError;				// Command not received in time limit, etc.
int				ThreadIsRunning;				// Main thread loop started
int				ThreadMeasureFinished;			// Measure finished
int				ThreadMeasureOk;				// Measure finished on it's way
int				ThreadMeasureError;				// Measure detected an error
int				ThreadMeasureErrorFlag;			// If MeasureError handled or not
gboolean		ThreadStopFlag[MaxInstrument];
gboolean		ThreadBreakFlag[MaxInstrument];
gboolean		ThreadFinishFlag[MaxInstrument];
gboolean		ThreadSuspendFlag[MaxInstrument];

gint			oneSecondTagMeasure;

// Connected to physical AD channels
int				ADRawValue[MaxMainChannels][MaxSubChannels];
int				ADRawResponse[MaxMainChannels];
int				ADRawFreshData[MaxMainChannels];
int				ADRawINPort[MaxMainChannels];
int				ADRawOUTPort[MaxMainChannels];
int				ADFreshOUTFlag[MaxMainChannels];
int				ADFreshDAFlag[MaxMainChannels];
int				ADRawTimeOut[MaxMainChannels];
double			ADRawGradRatio[MaxMainChannels][MaxGradRatio];

// Related to logical channels as described in detector matrix
// Workstaiton = DSInstrument[0]
int				MeasureFreshDataFlag[MaxInstrument];
int				MeasureDataValue[MaxInstrument][MaxDetectors];
double			MeasureScaleValue[MaxInstrument][MaxDetectors];
int				MeasureResponseValue[MaxInstrument];
int				MeasureErrorFlag[MaxInstrument];

double			MeasureGradRatio[MaxMainChannels][MaxGradRatio];
double			MeasureGradFlow[MaxMainChannels];
double			MeasureGradMaxFlow[MaxMainChannels];

gboolean		NewGradValue[MaxInstrument];
gboolean		NewGradCheck[MaxInstrument];
int				GradCounter[MaxInstrument];

int				MeasureDataCounter[MaxInstrument];
int				MeasureTickCounter[MaxInstrument];

// AD Trace variables

int				ADTraceChannel;

gboolean		ADTraceHeartBeat;
gboolean		ADTraceResponse;
gboolean		ADTraceFreshData;
gboolean		ADTraceData;
gboolean		ADTraceInput;
gboolean		ADTraceOutput;
gboolean		ADTraceGradient;

int				ADTraceStatus;
gboolean		ADTraceStatusGetNow;
char			ADTraceString[ADTraceStringLength];

pthread_mutex_t	ad_trace_mutex;

// Options

struct			OptionsStruct Options[MaxChromData];
struct			CentralOptionsStruct CentralOptions;
gboolean		MainWindowShrink;
gboolean		MainWindowKeepOnTop;
gboolean		MainWindowShrinked;
gboolean		OverrideMainWindowShrink;

// Common variables for each instrument

char			LabChromID[IdLength];					// = "WFOBXXGCABDM74980";
char			LabChromText[IdLength];					// = "LabChrom - Chemotron Inc. from 1991";

struct			ChromStruct Chrom[MaxChromData];

// Generic variables

// Name

char			*ConfigInternalName;
char			*ConfigInternalFieldName;
char			*ASCIITime;

char			*SpectraName;

// Directories

char			*BugTraceDir;
char			*BugTraceCentralDir;

// Last files

char			*LastChromDir;
char			*LastMainOpenDir;

// Reprocess

int				ReprocessOverlayChromNum;
int				ReprocessOverlaySelected;
int				ReprocessOverlayCListSelected;
int				ReprocessOverlayDrawMode;
int				ReprocessOverlayFunction;
double			ReprocessOverlayShift[MaxOverlayedChrom];
double			ReprocessOverlayZoom[MaxOverlayedChrom];
gboolean		ReprocessOverlayShow[MaxOverlayedChrom];
gboolean		ReprocessOverlayEnable[MaxOverlayedChrom];

// Integrate

int				EventList[EventNumbers];
char			*EventNames[EventNumbers];
char			*EventName;

// Import function default variables

char		*ImportFileName;
char		*ImportLastDir;
char		*ImportComment;
int			ImportChannels;
int			ImportChannelsOf;
double		ImportXResolution;
int			ImportXAxisMenuIndex;
int			ImportDecimation;
int			ImportRevert;
double		ImportScaleFactor;
char		*ImportScaleDim;
int			ImportResolution;
int			ImportResolutionMenuIndex;
int			ImportResolutionUser;
int			ImportStoreSettings;

// Generic measure variables

struct SpectraStruct Spectra;

/*
	Drawing globals
*/

gboolean		MainDrawingAreaNeedRedraw;
gint			MainTimeOutID;

char			*DrawString;
GdkFont			*DrawFont;
GdkFont			*AxisFont;
GdkFont			*PeakFont;
GdkFont			*CalibrNumberFont;
GdkFont			*CalibrAxisFont;
GdkColormap		*DrawColormap;

GdkPixbuf		*InputPixbuf;
GdkPixbuf		*OutputPixbuf;
GdkPixbuf		*LedOnPixbuf;
GdkPixbuf		*LedOffPixbuf;
GdkPixbuf		*EventFlagPixbuf;

GdkCursor		*DemoCursor;

GdkCursor		*NormalCursor;
GdkCursor		*ZoomCursor;
GdkCursor		*PeakAddCursor;
GdkCursor		*BaselineMoveCursor;
GdkCursor		*BaselineTypeChangeCursor;

// Generic chromatogram line draw color
GdkColor		DrawColor;
GdkColor		BackgroundColor;
GdkColor		BackgroundIOColor;
GdkColor		Background2IOColor;
GdkColor		DetectorColors[MaxInstrument][MaxDetectors];
GdkColor		ReprocessDetectorColors[MaxDetectors];
GdkColor		LayerBackgroundColor;
GdkColor		LayerTrackColor;
GdkColor		LayerRulerColor;
GdkColor		LayerShortColor;
GdkColor		LayerNormColor;
GdkColor		LayerXRangeColor;
GdkColor		LayerYRangeColor;
GdkColor		LayerTrackUpSideColor;
GdkColor		LayerTrackDownSideColor;

// Gradient colors
GdkColor		GradientColors[MaxGradRatio];
GdkColor		GradientConfigColors[MaxGradRatio];

// Measure draw
GdkColor		MeasureGridlineColor;
GdkColor		MeasureGridlineStrongColor;
GdkColor		RetColor;
GdkColor		MQListLockedFGColor;
GdkColor		MQListLockedBGColor;
GdkColor		MQListRunningFGColor;
GdkColor		MQListRunningBGColor;

// Reprocess colors
GdkColor		BaselineColor;
GdkColor		PeakNumberColor;
GdkColor		SelectionColor;
GdkColor		ReprocessGridlineColor;
GdkColor		ReprocessGridlineStrongColor;
GdkColor		LockColor;
GdkColor		EventColor;
GdkColor		CursorLineColor;
GdkColor		PeakAddColor;
GdkColor		BaselineMoveColor;
GdkColor		ZoomColor;
GdkColor		SelectedPeakColor;
GdkColor		OverlayColor[MaxOverlayedChrom];

// Calibration colors
GdkColor		CalibrationGridlineColor;
GdkColor		CalibrationGridlineStrongColor;
GdkColor		CalibrationBaseColor;
GdkColor		CalibrationBackgroundColor;
GdkColor		CalibrationNumberColor;
GdkColor		CalibrationSelectionColor;

int			ReprocessShowLists;
int			ReprocessShowQueue;
int			ReprocessShowOverlay;
int			ReprocessShowListsReady;

gboolean	ReprocessShowInitStatus;
int			ReprocessShowTickMarks;
int			ReprocessShowBaselines;
int			ReprocessShowFillPeaks;
int			ReprocessShowPeakNumbers;
int			ReprocessShowRetention;
int			ReprocessShowName;
int			ReprocessShowComment;
int			ReprocessShowTime;

int			ReprocessDrawingAreaNeedRedraw;
int			MeasureDrawingAreaNeedRedraw;
int			MeasureIOAreaNeedRedraw;
int			MeasureLayerDrawingAreaNeedRedraw;

int			MeasureQueueListNeedRefresh[MaxInstrument];

int			ReprocessDrawingAreaHeight;
int			ReprocessDrawingAreaWidth;
int			PeakInfoDrawingAreaHeight;
int			PeakInfoDrawingAreaWidth;
int			MeasureDrawingAreaHeight;
int			MeasureDrawingAreaWidth;
int			MeasureIODrawingAreaHeight;
int			MeasureIODrawingAreaWidth;
int			ServiceDrawingAreaHeight;
int			ServiceDrawingAreaWidth;
int			SpectraDrawingAreaHeight;
int			SpectraDrawingAreaWidth;

int			LayerDrawingAreaHeight;
int			LayerDrawingAreaWidth;
int			LayerTrackDrawingAreaHeight;
int			LayerTrackDrawingAreaWidth;
int			LayerColorDrawingAreaHeight;
int			LayerColorDrawingAreaWidth;
int			LayerColorDistributionDrawingAreaHeight;
int			LayerColorDistributionDrawingAreaWidth;


struct		ZoomStruct *Zoom;
struct		ZoomStruct DrawZoom;
struct		DrawStruct DrawData;

int			SelectedPeak;
int			MouseMode;

int			ZoomStart;
int			ZoomInProgress;
int			ZoomRectangleStarted;
GdkCursor	*ZoomCursor;
int			ZoomOrigX0;
int			ZoomOrigY0;
int			ZoomRectangleX;
int			ZoomRectangleY;
int			ZoomRectangleX0;
int			ZoomRectangleY0;
int			ReprocessAxisX;
int			ReprocessAxisY;
int			ReprocessAxisX0;
int			ReprocessAxisY0;

int			DrawCursorX;
int			DrawCursorY;
int			DrawCursorX0;
int			DrawCursorY0;

int			CursorPosition;
int			CursorLinePosition;
int			CursorLinePrevPosition;
double		CursorRetention;
double		CursorValue;
char		CursorDim[IdLength];
int			CursorPeak;
int			CursorStatus;				// Boolean for On/Off
int			StoreCursorPosition;
double		StoreCursorRetention;
double		StoreCursorValue;
int			StoreCursorPeak;

int			PeakAddStart;
int			PeakAddInProgress;
GdkCursor	*PeakAddCursor;
int			PeakAddOrigX0;
int			PeakAddOrigY0;
int			PeakAddX0;
int			PeakAddY0;
int			PeakAddX;
int			PeakAddY;

int			BaselineMovePeak;
int			BaselineMoveStart;
int			BaselineMoveInProgress;
GdkCursor	*BaselineMoveCursor;
int			BaselineMoveOrigX0;
int			BaselineMoveOrigY0;
int			BaselineMoveX0;
int			BaselineMoveY0;
int			BaselineMoveX;
int			BaselineMoveY;

gboolean	BaselineTypeChangeStart;
gboolean	BaselineTypeChangeInProgress;

int			RetMoveStart;
int			RetMoveInProgress;
GdkCursor	*RetMoveCursor;
int			RetMoveX;
int			RetMoveY;

int			EventAddStart;
int			EventAddInProgress;
GdkCursor	*EventAddCursor;
int			EventAddX;
int			EventAddY;

int			EventDelStart;
int			EventDelInProgress;
GdkCursor	*EventDelCursor;
int			EventDelX;
int			EventDelY;
