// System structures

struct ADParametersStruct {
int			ADDeviceId;
char		ADDeviceName[IdLength];
int			ADIOPortMenuIndex;
char		ADIOPortName[IdLength];
gboolean	ADNoHWCommunication;
int			ADMainChannelNum;
int			ADSubChannelNum;
int			ADChannelMode;
double		ADFullScale;  // From zero point, in mV
int			ADResolution;
int			ADZeroPoint;
double		ADBaseSamplingTime;
int			ADBaseSamplingFrequencyInHz;
int			ADSamplingSelection;
double		ADSamplingTimeTable[MaxADSamplingArray];
int			ADSamplingFrequencyTable[MaxADSamplingArray];
int			ADSamplingAccumulationTable[MaxADSamplingArray];
}; // ADParametersStruct

struct ControlSignalStruct {
int				Value;
gboolean		ActiveLevel;
}; // ControlSignalStruct

struct DetectorStruct {
char			Name[IdLength];
char			Ext[IdLength];
int				BindMainChannel;
int				BindSubChannel;
double			ScaleValue;
char			ScaleUnit[IdLength];
}; // DetectorStruct

struct InstrumentParamStruct {
char			InstrumentName[IdLength];
int				ChromatographType;
int				SamplingMode;
int				NumDetectors;
char			IconForInstrument[FilenameLength];
struct			DetectorStruct Detectors[MaxDetectors];
struct			ControlSignalStruct ControlSignals[ControlSignalMaxIdx];
}; // InstrumentParamStruct			WorkInstrument

struct InstrumentStruct {
int				InstrumentType;
int				NumOfInstrument;
int				AutoStart;
struct			ADParametersStruct ADParameters;
struct			InstrumentParamStruct Instrument[MaxInstrument];
}; // InstrumentStruct					WorkInstruments

struct SoftwareStruct {
int				NumberOfInstruments;
struct			InstrumentStruct Instruments[MaxInstruments + 1];
}; // SoftwareStruct					LC2

// Generic structures

struct OptionsStruct {
// Settings from Preferences Window
// Measure TAB
int			DataAcqMode;
// Common
char		MeasureMethod[FilenameLength];
char		MeasureDataDir[FilenameLength];
char		MeasureRawDir[FilenameLength];
gboolean	GenerateWorkDir;
char		MeasureRawName[FilenameLength];
char		MeasureBaseName[FilenameLength];
char		MeasureFilename[FilenameLength];
char		MeasureLastName[FilenameLength];
// Unique
gboolean	RegisterInQueue;
// Queue mode
char		QueueName[FilenameLength];
gboolean	StoreDefaults;
// Continous mode
gboolean	ContinousFreshMeasure;
gboolean	ContinousBrokenMeasure;
gboolean	LimitedNumber;
int			LimitedNumOfChrom;
int			RestartMode;
int			RestartChrom;
time_t		RestartTime;
gboolean	UseTemplateQueue;
char		TemplateQueueName[FilenameLength];
gboolean	AutoGenerateDir;
// Directories
char		DefaultDataRootDir[FilenameLength];
char		ActiveDataDir[FilenameLength];
char		MethodDir[FilenameLength];
char		CalibrDir[FilenameLength];
char		SpecificDir[FilenameLength];
char		ImportDir[FilenameLength];
char		ExportDir[FilenameLength];
// Other optional settings
char		LastName[FilenameLength];
char		LastDataDir[FilenameLength];
char		LastMethod[FilenameLength];
char		LastCalibr[FilenameLength];
// Measure parameters
int			MeasureAttenuator[MaxDetectors];
double		MeasureShift[MaxDetectors];
double		MeasureAxisTime;
double		MeasureAxisValue;
int			ShowMeasureFilenames;
int			ShowAllDetectors;
guint		red[MaxDetectors];
guint		green[MaxDetectors];
guint		blue[MaxDetectors];
// Drawing options
int			ZoomPermanent;
// Overlay draw
gboolean	OverlayEnabled;
int			OverlaySelectedChrom;
gboolean	OverlayHiddenChrom[MaxOverlayedChrom];
gboolean	OverlayFitZoom;
guint		Overlay_red[MaxOverlayedChrom];
guint		Overlay_green[MaxOverlayedChrom];
guint		Overlay_blue[MaxOverlayedChrom];
double		OverlayShift[MaxOverlayedChrom];
double		OverlayMagnify[MaxOverlayedChrom];
int			OverlayDrawMode;
int			OverlayFunction;
gboolean	OverlaySelectedChange;
// Print options for brief print in reprocess
int			PrintFrame;
int			PrintTickMarks;
int			PrintBaselines;
int			PrintXAxisTicks;
int			PrintXAxisValues;
int			PrintPeakName;
int			PrintPeakNumber;
int			PrintPeakRetention;
int			PrintPeakConcentration;
char		PrintTemplate[FilenameLength];
// Export result list options in Reprocess
int			ExportMode;
gboolean	ExportDOSLineFeed;
gboolean	ExportExtendedHeader;
gboolean	ExportQuantitativeData;
gboolean	ExportSampleInformation;
gboolean	ExportInstrumentParams;
int			ExportDataInTable;
gboolean	ExportSignatures;
//gboolean	Export
//gboolean	Export
char		ExportTemplate[FilenameLength];
char		ExportInternalTemplate[ExportInternalTemplateLength];
int			ExportInputEnc;
char		ExportInputEncOther[80];
int			ExportOutputEnc;
char		ExportOutputEncOther[80];
// General options
}; // OptionsStruct

struct CentralOptionsStruct {
int			PrintfMode;
int			CentralWindowClose;
int			CentralWindowIconify;
// Print options
double		PrintMarginLeft;
double		PrintMarginRight;
double		PrintMarginTop;
double		PrintMarginBottom;
gchar		PrintFontDefaultName[FontNameLength];
gchar		PrintFontTestName[FontNameLength];
gchar		PrintFontChromPeakDataName[FontNameLength];
gchar		PrintFontPeakListName[FontNameLength];
gchar		PrintFontAxisName[FontNameLength];
}; // CentralOptionsStruct

// Data structures

struct FileIdentifierStruct {
int			FileID;									// ChrFlag, MetFlag, etc...
int			MainVersion;
int			SubVersion;
int			ServiceVersion;
int			CreationDate;
int			OriginalCreationDate;
int			LastModificationDate;
int			InstrumentType;						// Generic, Sh930, etc....
int			ChromatographType;				// HPLC, GC, TLC, etc...
// Spare FileID-s
int			FileID1;
int			FileID2;
int			FileID3;
int			FileID4;
int			FileID5;
int			FileID6;
char		LabChromID[IdLength];
char		LabChromText[IdLength];
}; // FileIdentifierStruct

// Instrument specific structures

struct HP3396AHeadStruct {
}; // HP3396AHeadStruct

struct TR540Struct {
// filter settings
int			TR540SelectedFilter;
double		TR540Filters[7];					// List of installed filters [nm]
// measure mode settings
int			TR540HalfSizeScan;				// TRUE/FALSE 10cm scanning
int			TR540TrackWidth;
}; // TR540Struct

struct SH930Struct {
// slit settings
int			SH930SlitWidthIdx;
int			SH930SlitHeightIdx;
// measure mode settings
int			SH930ScanGeometry;				// Linear, ZigZag, ViewScan
gboolean	SH930ScanHighResol;				// High Res - Boolean
int			SH930ViewScanType;				// No, #1,#2
//unsigned char	TR930DAByte;
//int			TR930SpectraRawData[TR930SpectraLength];
//gboolean	TR930ReflTransmSet;					// Boolean
}; // SH930Struct

struct SpectraStruct {
int			SpectraClosed;
int			UVSampleStatus;
int			UVRefStatus;
int			VISSampleStatus;
int			VISRefStatus;
int			UVRefWaveLength;
int			VISRefWaveLength;
int			UVRefHiVoltValue;
int			VISRefHiVoltValue;
int			SampleXPosition;
int			SampleYPosition;
int			RefXPosition;
int			RefYPosition;
int			Automatic;
int			Calculation;
double		RefMinData;
double		RefMaxData;
double		SampleMinData;
double		SampleMaxData;
double		ResultMinData;
double		ResultMaxData;
// TR-930 specific data
int			TR930SpectraRefData[TR930SpectraLength];
int			TR930SpectraSampleData[TR930SpectraLength];
double		TR930SpectraEvaluatedData[TR930SpectraLength];
}; // SpectraStruct

// Instrument structures

struct InstrumentDataStruct {
// Instrument description
// Common
char		Instrument[IdLength];
char		InstrumentSerNo[IdLength];
char		Autosampler[IdLength];
char		AutosamplerSerNo[IdLength];
char		SystemController[IdLength];
char		SystemControllerSerNo[IdLength];
char		Detector[IdLength];
char		DetectorSerNo[IdLength];
char		DetectorSettings[IdLength];
char		Temperature[IdLength];
// GC
char		CarrierGas[IdLength];
// HPLC
char		Eluent[IdLength];
char		Pump[IdLength];
char		PumpSerNo[IdLength];
char		GradientMixer[IdLength];
char		GradMixSerNo[IdLength];
char		FractionCollector[IdLength];
char		FractCollSerNo[IdLength];
// TLC scanner
char		Sampler[IdLength];
char		SamplerSerNo[IdLength];
char		DeveloperDevice[IdLength];
char		DeveloperSerNo[IdLength];
char		DeveloperSettings[IdLength];
// Validation
char		LastVerified[IdLength];
time_t		LastVerifiedDate;
char		VerificationValid[IdLength];
time_t		VerificationValidDate;
char		VerificationId[IdLength];
// User description
char		Operator[IdLength];
char		Labor[IdLength];
// Free
char		Free1QI[IdLength];
char		Free1AI[IdLength];
char		Free2QI[IdLength];
char		Free2AI[IdLength];
char		Free3QI[IdLength];
char		Free3AI[IdLength];
char		Free4QI[IdLength];
char		Free4AI[IdLength];
// Column / layer parameters
// Common
char		Description[IdLength];
char		Manufacturer[IdLength];
char		Product[IdLength];
char		Serial[IdLength];
char		Batch[IdLength];
// Column
char		Diameter[IdLength];
char		Particle[IdLength];
char		Length[IdLength];
// Layer
char		Size[IdLength];
char		Thickness[IdLength];
char		Fluorescent[IdLength];
char		Base[IdLength];
// Free form
char		Free1Q[IdLength];
char		Free1A[IdLength];
char		Free2Q[IdLength];
char		Free2A[IdLength];
char		Free3Q[IdLength];
char		Free3A[IdLength];
char		Free4Q[IdLength];
char		Free4A[IdLength];
}; // InstrumentDataStruct

struct SampleDataStruct {
// Sample information
char		SamplingLocation[CommentLength];
char		SamplingPlace[CommentLength];
char		SamplingPoint[CommentLength];
char		SamplingDevice[CommentLength];
char		SamplingID[CommentLength];
char		SamplingOperator[CommentLength];
time_t		SamplingDate;
time_t		ArrivalDate;
// User defined
char		UserDefQ1[IdLength];
char		UserDefA1[CommentLength];
char		UserDefQ2[IdLength];
char		UserDefA2[CommentLength];
char		UserDefQ3[IdLength];
char		UserDefA3[CommentLength];
char		UserDefQ4[IdLength];
char		UserDefA4[CommentLength];
char		UserDefQ5[IdLength];
char		UserDefA5[CommentLength];
char		UserDefQ6[IdLength];
char		UserDefA6[CommentLength];
char		UserDefQDate1[IdLength];
time_t		UserDefDate1;
char		UserDefQDate2[IdLength];
time_t		UserDefDate2;
// Instrument specific
gboolean	InstrSpecTabEnable;
int			InstrSpecQANum;
int			InstrSpecDateNum;
char		InstrSpecQ1[IdLength];
char		InstrSpecA1[CommentLength];
char		InstrSpecQ2[IdLength];
char		InstrSpecA2[CommentLength];
char		InstrSpecQ3[IdLength];
char		InstrSpecA3[CommentLength];
char		InstrSpecQ4[IdLength];
char		InstrSpecA4[CommentLength];
char		InstrSpecQ5[IdLength];
char		InstrSpecA5[CommentLength];
char		InstrSpecQ6[IdLength];
char		InstrSpecA6[CommentLength];
char		InstrSpecQDate1[IdLength];
time_t		InstrSpecDate1;
char		InstrSpecQDate2[IdLength];
time_t		InstrSpecDate2;
// Text information
char		Info1[InfoLength];
char		Info2[InfoLength];
}; // SampleDataStruct

struct MeasureEventStruct{
int			DefaultPulseWidth;
int			DefaultTimeOut;
// Start, Run, Stop control events
gboolean	SRSControlEnable[SRSNum];
int			SRSEventNum[SRSNum];
int			SRSEventFunc[SRSNum][MaxAllControlEvents];
int			SRSEventCode[SRSNum][MaxAllControlEvents];
int			SRSEventMode[SRSNum][MaxAllControlEvents];
int			SRSEventData[SRSNum][MaxAllControlEvents];
int			SRSEventTime[SRSNum][MaxAllControlEvents];
int			SRSEventPulse[SRSNum][MaxAllControlEvents];
// Gradient events 
	// First, last, etc. values?
gboolean	GradientEnable;
int			GradientEventNum;
int			GradientComponentNum;
double		GradientFlowRate;										// Generic flow rate
double		GradientMaxFlowRate;									// Maximal flow rate of the pump - full scale
double		GradientTime[MaxInstrumentEvents];
double		GradientFlow[MaxInstrumentEvents];
double		GradientRatio[MaxInstrumentEvents][MaxGradRatio];
// Temperature program 
gboolean	TemperatureProgamEnable;
int			TemperatureProgramNum;
double		TemperatureProgramTime[MaxInstrumentEvents];
double		TemperatureProgramTemp[MaxInstrumentEvents];
double		TemperatureProgramSpeed[MaxInstrumentEvents];
// Digital IO
gboolean	DigitalIOEnable;
int			DigitalIONum;
double		DigitalIOTime[MaxInstrumentEvents];
int			DigitalIOCommand[MaxInstrumentEvents];
int			DigitalIOInputAValue[MaxInstrumentEvents];
int			DigitalIOInputBValue[MaxInstrumentEvents];
int			DigitalIOInputCValue[MaxInstrumentEvents];
int			DigitalIOInputDValue[MaxInstrumentEvents];
int			DigitalIOOutputAValue[MaxInstrumentEvents];
int			DigitalIOOutputBValue[MaxInstrumentEvents];
int			DigitalIOOutputCValue[MaxInstrumentEvents];
int			DigitalIOOutputDValue[MaxInstrumentEvents];
}; // MeasureEventStruct

struct PostRunOptionsStruct {
gboolean	PostRunAnalyze;
gboolean	AutoPrint;
gboolean	ExportResult;
gboolean	ExportResultOnName;
char		ExportResultName[BaseFilenameLength];
gboolean	ExportResultToFolder;
char		ExportResultFolder[FilenameLength];
gboolean	ExecuteCommand;
char		CommandToCall[BaseFilenameLength];
int			CommandParameter;
char		PostRunSpareName1[FilenameLength];
char		PostRunSpareName2[FilenameLength];
int			PostRunSpareInt1;
int			PostRunSpareInt2;
gboolean	PostRunSpareBool1;
gboolean	PostRunSpareBool2;
}; // PostRunOptionsStruct

struct MeasureParametersStruct {
gboolean	ImportFlag;
// Identifiers, comments
char		SampleComment[CommentLength];
char		SampleId[IdLength];
int			SampleIdNum;
// File names
char		ChromName[FilenameLength];
char		ChromBaseName[BaseFilenameLength];
char		ChromExt[IdLength];
int			ChromExtIdx;
int			ChromExtNumSize;
gboolean	ApplyExtension;
char		OrigChromName[FilenameLength];
char		MethodName[FilenameLength];
char		QueueName[FilenameLength];
char		CalibrationName[FilenameLength];
// Post-convert options
struct PostRunOptionsStruct PostRunOptions[MaxSampleType];
// Scripts, under development
char		PreStartScriptName[FilenameLength];
char		PostStartScriptName[FilenameLength];
char		PreRunScriptName[FilenameLength];
char		RunScriptName[FilenameLength];
char		PostRunScriptName[FilenameLength];
char		PreStopScriptName[FilenameLength];
char		PostStopScriptName[FilenameLength];
char		PreConvertScriptName[FilenameLength];
char		PostConvertScriptName[FilenameLength];
char		PreNextRunScriptName[FilenameLength];
char		PostNextRunScriptName[FilenameLength];
// Time parameters
time_t		StartTime;
time_t		StopTime;
time_t		ImportTime;
time_t		LastIntegratedTime;
time_t		LastAnalyzedTime;
time_t		Res1Time;
time_t		Res2Time;
// Name settings
char		NamePrefix[BaseFilenameLength];
char		NameSuffix[BaseFilenameLength];
int			NameDateMode;
int			NameIndexMode;
gboolean	NameSettingsUse;
// Sample type
int			SampleType; // SampleTypeSample, SampleTypeStandard, etc.
gboolean	StandardAutoCalibrate;
int			StandardLevel;
int			StandardMode;
gboolean	StandardFlagDet[MaxDetectors];
int			StandardLevelDet[MaxDetectors];
int			StandardModeDet[MaxDetectors]; // Clear, append, update, etc.
int			RetControlMode;
// Sample parameters
double		Volume;
double		Amount;
double		Factor;
double		Pressure;
double		Temperature;
double		IstConc;
double		ScaleFactor;
// Injection parameters
double		InjectedVolume;
// Dimensions
char		VolumeDim[DimLength];
char		AmountDim[DimLength];
char		FactorDim[DimLength];
char		PressureDim[DimLength];
char		TemperatureDim[DimLength];
char		IstConcDim[DimLength];
char		ScaleFactorDim[DimLength];
char		InjectedVolumeDim[DimLength];
// Conc calculation
int			ConcentrationCalculationMethod;
double		ISTRetention;
double		ISTRetentionLimit;
int			ISTPeak;
gboolean	UseSamplingParameters;
gboolean	UseGasParameters;
gboolean	UseISTParameters;
// Detector parameters
int			ActiveDetector;				// Which detector's values are valid in that block
int			DetectorSignalNum;			// Number of virtual detectors, depends on "MultidetectorMode"
double		DetSetting;					// Full scale value
double		DetMinVal;
double		DetMaxVal;
char		DetUnit[DimLength];
char		DetMask[DimLength];
double		WaveLength[MaxDetectors];
double		MainRange;
double		Range;
int			Attenuator;
// Acquisition parameters
int			Nmp;
int			NmpOrig;						// In case of import
gboolean	ForcedStop;
double		ForcedStopTime;
int			ForcedStopTick;					// Forced stop time in (data) tick
gboolean	AutoFinish;
char		ScaleXDim[DimLength];
double		SamplingRate;					// Known as DeltaT
double		SamplingRateFreq;
int			SamplingRateFreqInt;
int			SamplingRateIdx;				// Idx - Item order in list of A/D's sampling settings
int			Cycle;							// How many cycles based on the fastest setting of A/D
int			Accumulation;
int			DigitalResolution;
// Measure-time parameters
gboolean	ApplyMedianFilter;
int			SmoothMethodMeasureTime;
int			SmoothFactor1MeasureTime;
int			SmoothFactor2MeasureTime;
double		SmoothParameterMeasureTime;
gboolean	RevertPolarity;
// PostMeasure filtering, transferred to Parameters
// [MaxDetectors] !!!
int			SmoothMethod;
int			SmoothFactor1;
int			SmoothFactor2;
double		SmoothParameter;
// Control parameters, Start-Stop control events are derived from these settings
// Mode - IN, OUT, GET (data) SET (data)
int			DefaultPulseWidth;
int			DefaultTimeOut;
gboolean	StartControlEnable;
int			StartEventNum;
gboolean	StartEventEnabled[MaxStartControlEvents];
int			StartEventFunc[MaxStartControlEvents];
int			StartEventCode[MaxStartControlEvents];
int			StartEventMode[MaxStartControlEvents];
int			StartEventData[MaxStartControlEvents];
int			StartEventTime[MaxStartControlEvents];
gboolean	RunControlEnable;
int			RunEventNum;
gboolean	RunEventEnabled[MaxRunControlEvents];
int			RunEventFunc[MaxRunControlEvents];
int			RunEventCode[MaxRunControlEvents];
int			RunEventMode[MaxRunControlEvents];
int			RunEventData[MaxRunControlEvents];
int			RunEventTime[MaxRunControlEvents];
gboolean	StopControlEnable;
int			StopEventNum;
gboolean	StopEventEnabled[MaxStopControlEvents];
int			StopEventFunc[MaxStopControlEvents];
int			StopEventCode[MaxStopControlEvents];
int			StopEventMode[MaxStopControlEvents];
int			StopEventData[MaxStopControlEvents];
int			StopEventTime[MaxStopControlEvents];
// Other runtime controls
gboolean	TempControlEnable;
gboolean	GradControlEnable;
gboolean	DigiControlEnable;
// Generic densitometer
// Normalization
int			NormX;
int			NormY;
int			NormRange;
gboolean	NormFindInRange;
gboolean	NormPreset;
int			NormValue;
double		NormVoltage;
// Measure mode
int			MeasureMode;					// Reflection, Fluorescent, Transmission
int			FluorescentCutFilterIdx;		// # of the cutting filter
double		FluorescentCutFilter;			// Wavelength of the cutting filter
// Layer display color settings
GdkColor	ViewMinColor;
GdkColor	ViewMaxColor;
double		ViewMin;						// Color coding Low/Up limits
double		ViewMax;
// Slit settings
double		SlitWidth;
double		SlitHeight;
double		SlitWidthVirtual;
double		SlitHeightVirtual;
int			SlitWidthVirtualSteps;			// In motor steps
int			SlitHeightVirtualSteps;
// Data processing
int			ReflectanceDataTransform;		// R%, KM, etc...
int			TransmittanceDataTransform;		// T%, A, etc...
gboolean	InverzeLayer;
gboolean	NegativeGel;
// ViewScan limit settings
int			ViewScanXStart;					// Scan limits on each side
int			ViewScanXStop;
int			ViewScanYStart;
int			ViewScanYStop;
double		ViewScanXResol;
double		ViewScanYresol;
int			ViewScanXStep;
int			ViewScanYStep;
// Scan parameters
int			ScanStartX;
int			ScanStopX;
int			ScanLength;
int			ScanLengthSteps;				// Raw Nmp
int			DecimatedNmp;					// Number of data points after decimation
double		ScanResol;						// Sampling rate!
// Common smooth params
int			Decimation;						// How many raw data points collated
int			PreSmooth;						// Smooth method
int			PreSmoothPar1;					// Smooth before decimation parameter #1
int			PreSmoothPar2;					// Smooth before decimation parameter #2
double		PreSmoothPar3;					// Smooth before decimation parameter #3
int			PostSmooth;						// Smooth method after decimation
int			PostSmoothPar1;					// Smooth after decimation parameter #1
int			PostSmoothPar2;					// Smooth after decimation parameter #2
double		PostSmoothPar3;					// Smooth after decimation parameter #3
// Densitometer in data station mode
double		ScanSpeed;
int			SpeedMode;
char		SpeedDim[DimLength];
// Special parameters
int			OverFlowValue;
double		OverFlowScaleValue;
// Runtime event flags
int			OverflowCounter;				// Overflow signal detected/counted
int			OverflowToDo;					// What to do in run time in that case
time_t		OverflowTime;					// If not stopped, the last event registered;
int			WarningCounter;
int			WarningToDo;
time_t		WarningTime;
int			ErrorCounter;
int			ErrorToDo;
time_t		ErrorTime;
gboolean	StopSignalReceived;
time_t		StopSignalTime;
}; // MeasureParametersStruct

// Report structures

struct ReportStruct {
	// Header
	int    HeaderNum;
	int    HeaderList[MaxReportHeadItems];
	int    HeaderFF;                       // FormFeed after header
	char   HeadCust[CommentLength];        // Customized report header
	int    HeadName;                       // Chrom name on title
	int    ReportFF;                       // FormFeed after report
	// Graphic
	int    PortLand;                       // Portrait / Landscape
	int    UseReportParameters;            // Using ChromHeader report parameters?
	int    xAxisScale;                     // X Axis scaling
	float  xAxisValue;                     // X Axis value
	int    xAxisSLegend;                   // Legends on scale
    float  xAxisSLV;                       // Legends division
	int    yAxisScale;                     // Y Axis scaling
	float  yAxisValue;                     // Y Axis value
	int    yAxisSLegend;                   // Legends on scale
	float  yAxisSLV;                       // Legends division
	// For landscape
	float  AxisDiv;                        // cm/min, inch/min
	int    AxisDivM;                       // Speed unit   -- "" --
	int    Attn;                           // Attenuator
	int    ShiftAuto;                      // Automatic zero shift
	float  ShiftVal;                       // Zero shift value
	// For portrait
	int    GraphSize;                      // Single,Double,Triple,Quadruple
	float  AxisSize;                       // Axis length
	int    AxisCheck;                      // Check axis values before print
	int    NormPeak;                       // normalize to ? peak
	int    FirstLast;                      // From 1st peak to last peak
	// Peak legends
	int    DrawNum;                        // Peak number
	int    DrawName;                       // Name
	int    DrawRet;                        // Retention
	int    DrawConc;                       // Concentration
	int    DrawBase;                       // BaseLine
	int    DrawSymm;                       // Symmetry
	int    DrawSLock;                      // Start lock
	int    DrawLock;                       // Lock off window
	int    DrawEvent;                      // Events
	int    TxtRotate;                      // Text direction
	// Lista
	int    LayCol;                         // Column/0, Layer/1
	int    PrintDim;                       // Print dimension
	int    PrGrPeaks;                      // Print only graphical selected peaks
	int    RepNum;                         // Number of report columns
	int    ColData[MaxReportColumns];      // Mit tartalmaz az oszlop
	char   DataMask[MaxReportColumns][10]; // Nyomtatsi maszk
	int    SumNeed[MaxReportColumns];      // sszegzs kell-e
	}; // ReportStruct

// Method related structures

struct IntegrationParametersStruct {
// Peak detection parameters
int			DetectionMode;				// 1st deriv, 2nd deriv, etc.
double		PozSlope;
double		Poz2Slope;
double		Poz2Level;
double		NegSlope;
double		Neg2Slope;
double		Neg2Level;
double		SolventSlope;
double		SolventHeight;
double		SolventArea;
double		SolventWidth;
double		MinLevel;
double		MinArea;
double		MinWidth;
int			DetSmooth;
int			FollowUp;
int			FollowAx;
int			FollowDn;
// Advanced detection parameters
double		BaseLineDrift;
double		NoiseLevel;
// Spare ADVANCED parameters
double		AdvFloat1;
double		AdvFloat2;
double		AdvFloat3;
double		AdvFloat4;
double		AdvFloat5;
double		AdvFloat6;
int			AdvInt1;
int			AdvInt2;
int			AdvInt3;
int			AdvInt4;
int			AdvInt5;
// Lock window parameters
double		LockWait;
int			LockNum;
gboolean	LockDropPeaks;
double		LockWindOn[MaxIntegrationLock];
double		LockWindOff[MaxIntegrationLock];
// Merge parameters
double		HeightF;
gboolean	HeightFApply;
double		TimeF;
gboolean	TimeFApply;
double		CloseF;
gboolean	CloseFApply;
double		TangentF;
gboolean	TangentFApply;
// Spare MERGE parameters
double		Merge1F;
gboolean	Merge1FApply;
double		Merge2F;
gboolean	Merge2FApply;
double		Merge3F;
gboolean	Merge3FApply;
double		Merge4F;
gboolean	Merge4FApply;
double		Merge5F;
gboolean	Merge5FApply;
double		Merge6F;
gboolean	Merge6FApply;
// Timed events
int			EventNum;
int			EventType[MaxIntegrationEventNum];
double		EventTime[MaxIntegrationEventNum];
int			EventFactor[MaxIntegrationEventNum];
double		EventParameter[MaxIntegrationEventNum];
double		EventActiveTime[MaxIntegrationEventNum];
}; // IntegrationParametersStruct

struct MethodStruct {
gboolean	MethodValid;
struct		ADParametersStruct ADParameters;
struct		InstrumentParamStruct Instrument;
struct		InstrumentDataStruct InstrumentData;
struct		SampleDataStruct SampleData;
struct		TR540Struct TR540Parameters;
struct		SH930Struct SH930Parameters;
struct		HP3396AHeadStruct HP3396AHead;
struct		MeasureEventStruct MeasureEvents;
struct		MeasureParametersStruct MeasureParameters; 
struct		IntegrationParametersStruct IntegrationParameters[MaxDetectors];
struct		ReportStruct Report;
}; // MethodStruct

// Queue structures

struct LayerQueueHeadStruct {
time_t		StartTime;
time_t		LastModTime;
time_t		SpareTime2;
time_t		SpareTime1;
// Data fields
int			QueueMode;						// 0 -> Simple, log only mode
int			QueueType;						// Workstation, TR541, etc.
int			RawType;
int			RawSize;
struct		MethodStruct LQMethod;
char		MethodName[FilenameLength];
char		BaseName[FilenameLength];
char		Directory[FilenameLength];
char		WorkDirectory[FilenameLength];	// For reprocess, in case of move
gboolean	AddSubfolder;
char		Calibration[FilenameLength];
gboolean	CalibrationTemplate;
gboolean	CalibrationLocalCopy;
char		Comment[CommentLength];
char		OperatorName[IdLength];
int			MeasureTime;
int			SamplerPosition;
int			NumberOfChroms;
int			StartExt;
gboolean	Append;
double		StartPoint;
double		Difference;
int			NumberOfTracks;
int			LastMeasureTime;				// in list
gboolean	ManualStepForwardDefault;
int			QueueItemNum;
int			QueueItemClosed;				// Finished measure
int			QueueItemLocked;
int			QueueSpare3;
int			QueueSpare2;
int			QueueSpare1;
double		QueueSpareD3;
double		QueueSpareD2;
double		QueueSpareD1;
// Collecting queue data
gboolean	FormFeedBeforeList;
int			CompListNum;
int			CompSpare2;
int			CompSpare1;
char		ComponentIdTableName[FilenameLength];	// Practically a calibr table
int			ComponentIdList[MaxQueueCollectItems];	// Internal, calibr table id!
int			ComponentDetectorList[MaxQueueCollectItems];
char		ComponentNameList[MaxQueueCollectItems][IdLength];
int			CompListSpare[MaxQueueCollectItems];
}; // LayerQueueHeadStruct

struct QueueItemStruct {
gboolean	QueueItemLocked;				// Measure started
gboolean	QueueItemMeasured;				// Measure finished
int			QueueItemStatus;				// Finished, cancelled, ignored, etc.
int			QueueItemRepeated;				// 0 means no repetition
int			QueueItemRepeatOrigin;			// Original item for repetition
int			QueueItemSpare3;
int			QueueItemSpare2;
int			QueueItemSpare1;
time_t		StartTime;
time_t		StopTime;
time_t		SpareTime2;
time_t		SpareTime1;
// Measure data
int			SamplerPosition;				// in case of autosampler
int			TrackPosition;					// in case of TLC scanner
double		MeasureTime;					// Forced Stop time
gboolean	ManualStepForward;
int			MeasSpareInt;
double		MeasSpareDouble;
// Identifiers
char		BaseFileName[FilenameLength];
char		BaseExtName[BaseFilenameLength];
int			ExtIdx;
char		Comment[CommentLength];
char		Id[IdLength];
char		FinalFilename[FilenameLength];
// Sample type
int			SampleType; // SampleTypeSample, SampleTypeStandard, etc.
gboolean	StandardAutoCalibrate;
int			StandardLevel;
int			StandardMode;
gboolean	StandardFlagDet[MaxDetectors];
int			StandardLevelDet[MaxDetectors];
int			StandardModeDet[MaxDetectors]; // Clear, append, update, etc.
int			RetControlMode;
// Quantitative data
double		Volume;
double		Amount;
double		Factor;
double		Pressure;
double		Temperature;
double		IstConc;
double		ScaleFactor;
double		InjectedVolume;
double		SpareParam4;
double		SpareParam3;
double		SpareParam2;
double		SpareParam1;
// Track data
gboolean	TrackIsCurve;
int			TrackCurvePointNum;
int			TrackCurvePointsX[MaxTrackCurvePoints];
int			TrackCurvePointsY[MaxTrackCurvePoints];
double		TrackCurveDataX[MaxTrackCurvePoints];
double		TrackCurveDataY[MaxTrackCurvePoints];
int			TrackCurveMode; // 0 linear
char		TrackCurveSpare[200];
}; // QueueItemStruct

// Peak structures

struct PeakHeadStruct {
int			PeakNum[MaxDetectors];
int			PeakNumUpper;
double		AreaSum[MaxDetectors];
double		HeightSum[MaxDetectors];
double		ConcSum[MaxDetectors];
time_t		LastMod;
gboolean	Integrated;
gboolean	Analysed;
double		SelPeakForAlfa;
}; // PeakHeadStruct

struct PeakStruct {
//  Names
char		PeakName[IdLength];
int			PeakId;
char		PeakIdStr[IdLength];
gboolean	PeakIdentified;
char		ConcDim[DimLength];
int			PeakComponentNum;				// From calibr table
//  Special information
int			PeakOverFlow;					// Bool, any overflow int the peak
int			PeakRetentionMode;
int			PeakSolvent;
int			PeakNegative;
gboolean	PeakManualSet;					// Peak was set by hand
gboolean	PeakSpareBool1;
gboolean	PeakSpareBool2;
int			PeakSpareInt1;
double		PeakSpareDouble1;
double		PeakSpareDouble2;
//  Peak data
double		PeakRetention;
double		PeakRf;
double		PeakRelativeRetention;
double		PeakBegin;
double		PeakEnd;
double		Peak10B;
double		Peak10E;
double		Peak50B;
double		Peak50E;
double		PeakArea;
double		PeakHeight;
double		PeakAreaR;
double		PeakHeightR;
double		PeakAperH;
double		PeakConc;
double		PeakConcPercent;
double		PeakConcFactor;                 // Factor from calibration
double		PeakConcLowerLimit;
double		PeakConcUpperLimit;
double		PeakConcExpectedValue;
//  Internal standard identifiers
int			PeakIsIst;
int			AssignedToIst;
//  Baseline data
double		BlTimeBegin;
double		BlTimeEnd;
double		BlValueBegin;
double		BlValueEnd;
int			BlTypeBegin;
int			BlTypeEnd;
//  Component Id
int			PeakComponent;
//  Detected peak type data
int			DetTypeBeg;
int			DetTypeEnd;
//  Idx
int			PeakRetentionIdx;
int			PeakBeginIdx;
int			PeakEndIdx;
int			BlTimeBeginIdx;
int			BlTimeEndIdx;
//  Performance data
double		PeakW10;					// Width at 10% height
double		PeakW50;					// Width at half height
double		PeakWBL;					// Width at baseline
double		PeakN10;					// Efficiency by Width at 10%
double		PeakN50;					// Efficiency by Width at 50%
double		PeakNBL;					// Efficiency by Width at baseline
double		PeakNIH;					// Efficiency by Area/Height
double		PeakK;						// Partition factor
double		PeakAlfa;					// Selectivity to prev. peak
double		PeakAlfaS;					// Selectivity to selected peak
double		PeakR;						// Resolution
double		PeakN;						// Theoretical plates
double		PeakSym10;					// Symmetry at 10%
double		PeakSym50;					// Symmetry at 50%
double		PeakSymBL;					// Symmetry at BaseLine
double		PeakSymA;					// Symmetry by area
double		PeakM1;						// 1st moment
double		PeakM2;						// 2nd moment
double		PeakM3;						// 3rd moment
double		PeakM4;						// 4th moment
//  System information
int			SelectForDel;
int			CompIdentResult;			// 0 = OK, 1 = More peak as 1 component, 2 = 1 peak as more component, etc.
int			SelectForBLR;				// Selected for Baseline recalc
int			PeakSystemSpareInt;
double		PeakSystemSpareDouble;
}; // PeakStruct

// Calibration structures

struct CalibrHeadStruct{
// Calibration descriptor
gboolean	CalibrNew;
time_t		CalibrDate;                     // DateTime
time_t		CalibrLastModified;             // DateTime
int			CalibrType;
gboolean	CalculateByMainComponent;
int			MainComponentSelect;
int			CalibrIdentificationMode;
// Defaults
int			AreaHeightBase;					// Means default only
int			CurveType;						// Means default only
gboolean	ZeroOption;						// Means default only
// Default search windows - retention limits for peak search
double		LimitStatic;
double		LimitDynamic;
int			IdentifyMorePeaks;
int			MorePeakFactor2;
int			MorePeakFactor1;
double		MorePeakParam1;
// Calculation settings
gboolean	ForcedSingleLevelMode;
gboolean	UseParameters;
gboolean	CalculateWithInjectedVolume;
gboolean	CalculateWithSampleParameters;
gboolean	CalculateWithGasParameters;
// Default dimensions
char		TDim[DimLength];                // Time  (x) axis
char		VDim[DimLength];                // Value (y) axis
char		QDim[DimLength];                // Quantity
char		CDim[DimLength];                // Concentration
// Group descriptor - not applied yet
int			NumberOfGroups;
int			GroupIdMode;
// GPC parameters - not applied yet
gboolean	CalibrGPC;
char		GPCChromName[FilenameLength];
double		GPCaPar;
double		GPCbPar;
// Data numbers in full table
int			ComponentInternalNum; // Auto incremented ID, for unique identification of a component
int			ComponentNum;
int			LevelInternalNum;
int			LevelNum;
int			ChromInternalNum;
int			ChromNum;
int			CellNum;
int			ConcNum;
int			IstNum;
// File names
char		RetentiontemplateName[FilenameLength];
gboolean	RetentionTemplateLoaded;
// File options
gboolean	SaveCalibrAfterMod;
// Spare
double		HeadSpare1;
int			ParamSpare1;
int			ParamSpare2;
}; // CalibrHeadStruct

struct CalibrLevelStruct {
gboolean	Existing;
int			LevelInternalNum;
char		LevelName[IdLength];
int			ChromNum;                       // Number of chrom's in a level
// Level parameters, derived from Chrom
double		InjectedVolume;
double		Volume;
double		Amount;
double		Factor;
double		Pressure;
double		Temperature;
double		IstConc;
// Spare
double		LevelSpare1;
double		LevelSpare2;
int			ParamSpare1;
int			ParamSpare2;
int			ParamSpare3;
int			ParamSpare4;
}; // CalibrLevelStruct

struct CalibrChromStruct {
gboolean	Existing;                       // Temporary flag
int			LevelInternalNum;               // Attached to this level
int			ChromInternalNum;               // Id (line) number
char		ChromName[FilenameLength];
char		Comment[CommentLength];         // ChromHead.Met.MeasPar.SampleComment
int			SampleId;
// Parameters
double		InjectedVolume;
double		Volume;
double		Amount;
double		Factor;
double		Pressure;
double		Temperature;
double		IstConc;
// Spare
double		ChromSpare1;
double		ChromSpare2;
int			ParamSpare1;
int			ParamSpare2;
int			ParamSpare3;
int			ParamSpare4;
}; // CalibrChromStruct

struct CalibrComponentStruct {
gboolean	Existing;
int			ComponentInternalNum;		// ChromHead.ComponentInternalNum
gboolean	ComponentMain;
gboolean	IstFlag;					// Means: IstIdNum > 0
int			IstIdNum;					// 0 means: it is not Ist
int			AssignIst;					// 0 means: not assigned
	// Identification data
char		ComponentName[IdLength];
int			ComponentIdNum;
char		ComponentIdString[IdLength];
int			ComponentDetector;
char		ComponentDetectorName[IdLength];
// Base data
double		AmtPerArea;					// Scale factor
double		CalFactor;					// Response factor for AreaNorm
double		PeakRet;
double		PeakRelRet;
double		PeakRetFactor;
// Calculation
int			AreaHeightBase;
int			CurveType;
gboolean	ZeroOption;
double		LimitStatic;
double		LimitDynamic;
int			IdentifyMorePeaks;
int			MorePeakFactor;
double		MorePeakParam1;
double		MorePeakParam2;
// Parameters
double		AParam;                         // a
double		BParam;                         // b / n
double		CParam;                         // c
double		RParam;                         // Corr.Coeff.
// Limits
double		ComponentLowerLimit;
double		ComponentUpperLimit;
double		ComponentExpectedValue;          // Expected value
// Spare
double		CompSpare1;
double		CompSpare2;
int			ParamSpare1;
int			ParamSpare2;
int			ParamSpare3;
int			ParamSpare4;
}; // CalibrComponentStruct

struct CalibrCellStruct {
gboolean	Existing;
int			LevelInternalNum;
int			ChromInternalNum;
int			CompInternalNum;
gboolean	Filled;
double		RetTime;
double		RelRet;
double		RetFactor;
double		Height;
double		Integral;
double		MolWeight;
double		WorkValue;                      // Integral/Height
double		WorkConc;                       // Concent w/factors
double		CellSpare1;
double		CellSpare2;
int			ParamSpare1;
int			ParamSpare2;
int			ParamSpare3;
int			ParamSpare4;
}; // CalibrCellStruct

struct CalibrConcStruct {
gboolean	Existing;
int			LevelInternalNum;
int			CompInternalNum;
gboolean	Filled;
double		Concentration;					// Set by the user
double		AreaMean;						// Mean value of areas
double		HeightMean;						// Mean value of heights
double		WorkValue;						// Area / Height depends on setting
double		ParameterEndResult;				// Volume, amount, etc
int			N;
double		SumX;
double		SumX2;
double		StdDev;
double		ConcSpare1;
double		ConcSpare2;
int			ParamSpare1;
int			ParamSpare2;
int			ParamSpare3;
int			ParamSpare4;
}; // CalibrConcStruct

// Chromatogram structures

struct BlankStruct {
gboolean	BlankAttach;
gboolean	BlankApply;
gboolean	BlankEnable;
char		BlankName[FilenameLength];
}; // BlankStruct

struct LogHeadStruct {
int			LogNum;
int			LogError;                       // Bool
int			LogErrorDate;                   // DateTime
}; // LogHeadStruct

struct ParameterStruct {
// Smooth parameters
int			SmoothMethod;				// 0 - Triangle, others: reserved
int			SmoothFactor1;				// Triangle:0,1,2,3
int			SmoothFactor2;				// Triangle:0,1,2,3
double		SmoothParameter;			// Reserved, i.e.FFT smooth, SG smooth
// Min-Max values
double		ChrMin;
double		ChrMax;
double		ChrMinSmoothed;
double		ChrMaxSmoothed;
double		Der1Min;
double		Der1Max;
double		Der2Min;
double		Der2Max;
// Relative retention reference points
double		RelRet0;
double		RelRetRef;
// Retention correction
double		RetCorr;
// Values for performance calculation
double		RetT0;
// Values for Rf calculation
double		RetSamplingLine;
double		RetFrontLine;
// Values for report printing
double		RepMin;
double		RepMax;
int			RepBeg;
int			RepEnd;
}; // ParameterStruct

struct ChromHeadStruct {
// Structures
struct		BlankStruct Blank;
struct		LogHeadStruct LogHead;
struct		ParameterStruct Parameter[MaxDetectors];
struct		MethodStruct Method;
struct		PeakHeadStruct PeakHead;
struct		CalibrHeadStruct CalibrHead;
}; // ChromHeadStruct

// Other structures

// Gauss typedef

typedef double TNvector[TNarraySize];
typedef TNvector TNmatrix[TNarraySize];

struct RegrParamStruct {
double		RegrAParam;
double		RegrBParam;
double		RegrCParam;
double		RegrRParam;

gboolean	RegrOk;

int			RegrN;
double		RegrSumX;
double		RegrSumX2;
double		RegrSumY;
double		RegrSumY2;
double		RegrSumXY;

double		RegrCorrX;
double		RegrCorrY;

int			RegrParams;

int			GaussDim;
TNmatrix	GaussCoeff;
TNvector	GaussConst;
TNvector	GaussSolut;
gboolean	GaussError;
}; // RegrParamStruct

// MAIN Chrom structure
struct ChromStruct {
gboolean	FreshMeasure;
int			FileLoaded[FlagMax];
int			FileSaved[FlagMax];
int			FileError;
char		Filename[FilenameLength];
char		ChrName[FilenameLength];
char		ChromExtNow[IdLength];
int			ChromExtNowNum;
char		MetName[FilenameLength];
char		InfoName[FilenameLength];
char		LastName[FilenameLength];
struct		MethodStruct Method;
struct		ChromHeadStruct *ChromHead;
int			ChromDataArrayActualSize;
int			*ChromDataArrays[MaxDetectors];
struct		PeakStruct *Peak;
struct		PeakStruct *IstPeak;
int			PeakArrayActualSize;
struct		PeakStruct *PeakArray[MaxDetectors];
char		LayerQueueName[FilenameLength];
int			LayerQueueActualSize;
struct		LayerQueueHeadStruct QueueHead;
struct		QueueItemStruct QueueItem;
struct		QueueItemStruct *QueueItemArray;
gboolean	QueueOrSeriesActive;
int			TR541RawDataArray[200][1000];
int			TR541RawDataArrayRows;
int			TR541RawDataArrayBeg;
int			TR541ADValue;
int			TR541DAValue;
int			TR541ByteValue;
int			ActualDetector;
int			ActualExtension;									// Saved in Config!
char		CalName[FilenameLength];
struct		CalibrHeadStruct *CalibrHead;
int			CalibrComponentActualSize;
struct		CalibrComponentStruct *CalibrComponent;
struct		CalibrComponentStruct *CalibrComponentArray;
int			CalibrLevelActualSize;
struct		CalibrLevelStruct *CalibrLevel;
struct		CalibrLevelStruct *CalibrLevelArray;
int			CalibrChromActualSize;
struct		CalibrChromStruct *CalibrChrom;
struct		CalibrChromStruct *CalibrChromArray;
int			CalibrCellActualSize;
struct		CalibrCellStruct *CalibrCell;
struct		CalibrCellStruct *CalibrIstCell;
struct		CalibrCellStruct *CalibrCellArray;
int			CalibrConcActualSize;
struct		CalibrConcStruct *CalibrConc;
struct		CalibrConcStruct *CalibrConcArray;
int			CalibrTemplateActualDetector;
char		CalibrTemplateChromName[FilenameLength];
struct		ChromHeadStruct *CalibrTemplateChromHead;
int			CalibrTemplateChromDataArrayActualSize;
int			*CalibrTemplateChromDataArrays[MaxDetectors];
struct		PeakStruct *CalibrTemplatePeak;
int			CalibrTemplatePeakArrayActualSize;
struct		PeakStruct *CalibrTemplatePeakArray[MaxDetectors];
int			CalibrActualDetector;
char		CalibrChromName[FilenameLength];
struct		ChromHeadStruct *CalibrChromHead;
int			CalibrChromDataArrayActualSize;
int			*CalibrChromDataArrays[MaxDetectors];
struct		PeakStruct *CalibrPeak;
int			CalibrPeakArrayActualSize;
struct		PeakStruct *CalibrPeakArray[MaxDetectors];
struct		RegrParamStruct RegrParam;
}; // ChromStruct

// Export mode params structure
struct ExportModeStruct {
int			AddExtension;
char		Extension[11];
int			ParameterMode;
char		ParamExtension[11];
}; // ExportModeStruct

// Print / Draw structures 

struct AxisTickStruct {
double		AxisMin;
double		AxisMax;
int			SmallTickNum;
int			BigTickNum;
double		SmallTickDiff;
double		BigTickDiff;
double		SmallTickStartValue;
double		BigTickStartValue;
int			DiffMultiplikator;
}; // AxisTickStruct

struct ZoomStruct {
double		ZoomMin;
double		ZoomMax;
int			ZoomBeg;
int			ZoomEnd;
struct		ZoomStruct *PrevZoom;
struct		ZoomStruct *NextZoom;
}; // ZoomStruct

struct DrawStruct {
int			x1;
int			y1;
int			x2;
int			y2;
}; // DrawStruct

struct PrintStruct {
// Calling parameters
int						PrintMode;
void					*UserParams1;
void					*UserParams2;
// GnomePrint variables
GnomePrintJob			*PrintJob;
GnomePrintContext		*PrintContext;
GnomePrintConfig		*PrintConfig;
// Fonts
GnomeFont				*PrintFontDefault;
GnomeFont				*PrintFontTest;
GnomeFont				*PrintFontChromPeakData;
GnomeFont				*PrintFontPeakList;
GnomeFont				*PrintFontAxis;
GnomeFont				*PrintFontTGA1;
// Print configuration
double					PaperWidth;
double					PaperHeight;
double					LayoutWidth;
double					LayoutHeight;
double					PaperMarginLeft;
double					PaperMarginRight;
double					PaperMarginTop;
double					PaperMarginBottom;
double					PageMarginLeft;
double					PageMarginRight;
double					PageMarginTop;
double					PageMarginBottom;
// Line print declarations
int						NumPrintLines;
int						Page0Lines;
int						PrintLineCounter;
double					LineFeedValue;
double					ActualLinePos;
double					PrintXLeft;
double					PrintYFromUp;
// Privat declarations
int						PageNumber;
double					PageRatio;
double					MarginRatio;
double					LCMarginLeft;
double					LCMarginRight;
double					LCMarginTop;
double					LCMarginBottom;
int						PrintJustification;
int						PrintJustificationPosition;
int						PrintLocalWidth;
int						PrintLocalHeight;
GnomeFont				*ActualPrintFont;
}; // PrintStruct
