extern int
tty_init (char *serial_port_name) {
int result = 0;

  serial_port_error = FALSE;
  serial_printout = FALSE;
  if (serial_no_communicate == TRUE) printf ("serial_no_communicate is TRUE\n");

  printf ("Trying to open port...\n");
  serial_port = open (serial_port_name, O_RDWR | O_NOCTTY);
  if (serial_port < 0)
	  {
	  serial_port_error = TRUE;
	  perror ("serial_port_error = TRUE");
	  perror (serial_port_name);
	  return -1;
	  } // if (port < 0)
  printf ("open port done\n");

  result = tcgetattr (serial_port, &old_port_params);
  if (result != 0)
	  {
	  perror ("Error initializing device");
	  return -1;
	  }
  printf ("getattr done\n");

  new_port_params.c_cflag = B9600 | CS8 | CLOCAL | CREAD | CSTOPB;
  new_port_params.c_iflag = IGNPAR;
  new_port_params.c_oflag = 0;
  new_port_params.c_lflag = 0;

  result = tcflush (serial_port, TCIFLUSH);
  if (result != 0)
	  {
	  perror("Error flushing device");
	  }
  printf("flush done\n");

  result = tcsetattr (serial_port, TCSANOW, &new_port_params);
  if (result != 0)
	  {
	  perror("Error initializing device");
	  return -1;
	  }
  printf("setattr done\n");

  tty_FILE = fdopen (serial_port, "a+");
  setvbuf (tty_FILE, NULL, _IONBF, 0);
  timeout_flag=FALSE;
  default_timeout_value = 250;
  timeout_value = default_timeout_value;
  return 0;
} // ttyinit

extern int
tty_close (void) {
  if (serial_port_error == TRUE) 
	  return -1;

  return 0;
} // tty_close

extern int
tty_flush (void) {
  int result = 0;

  if (serial_port_error == TRUE) 
	  return -1;

  result = tcflush (serial_port, TCIFLUSH);
  if (result != 0)
    {
	  perror("Error flushing device");
  }
  printf("flush done\n");

  return 0;
} // tty_flush


extern int
tty_reset (void) {
int result = 0;

  if (serial_port_error == TRUE) 
	  return -1;

  result = tcflush (serial_port, TCIFLUSH);
  if (result != 0)
	  perror("Error flushing device");

  result = tcsetattr (serial_port, TCSANOW, &old_port_params);
  if (result != 0) {
	  perror("Error initializing device");
	  return -1;
  }
  printf ("reset done\n");

  return 0;
} // tty_reset


extern unsigned char
readbyte (void) {
struct pollfd pfd;
int poll_ret_val;
unsigned char ret_val;

  if (serial_port_error == TRUE) 
	  return 0; // Special case

  timeout_flag=FALSE;
  if (serial_no_communicate == TRUE) return 0;

  pfd.fd = fileno(tty_FILE);
  pfd.events = POLLIN;
  poll_ret_val = TEMP_FAILURE_RETRY(poll (&pfd, 1, timeout_value));
  timeout_value = default_timeout_value;
  if (poll_ret_val == 0)
	  {
	  printf ("\n@@@ Timeout!\n\n");
	  timeout_flag = TRUE;
	  return 0;
	  }
  else if (poll_ret_val == -1)
	  {
	  printf ("\n@@@ Error #%d in poll! Error: %s\n\n", errno, strerror(errno));
	  timeout_flag = TRUE;
	  return 0;
	  }
  else {
  	  ret_val = (unsigned char)fgetc (tty_FILE);
	  if (serial_printout) printf ("GET: %.2X\n", ret_val);
	  return ret_val;
	  }
} // readbyte


extern int
dputc (unsigned char databyte) {
  if (serial_port_error == TRUE) 
	  return -1;

  if (serial_no_communicate == TRUE) return 0;
  fputc (databyte, tty_FILE);
  if (serial_printout)  printf ("PUT: %.2X\n", databyte);
  usleep (5000);
  return 0;
} // dputc
