// Print sample queue

void
PrintSampleQueue (struct PrintStruct *PS) {
char *PrintString;
char *TempString;
int PageCounter, RowCounter;
int DataSource;
int i;

  PrintString = alloca (10000);
  TempString = alloca (10000);
  PageCounter = 0;
  RowCounter = 0;

  DataSource = GPOINTER_TO_INT(PS->UserParams1);

  // Draws a frame
  DrawPrintFrame (PS, 0.4, 0, 1, 1, 0);


  // Assemble the page content
  //****************************

  // Prints file name
  SetPrintFont (PS, PS->PrintFontDefault);
  sprintf (PrintString, "File name: %s", Chrom[DataSource].LayerQueueName);
  printf ("File name: %s\n", PrintString);
  PrintText (PS, 10, PS->PrintLocalHeight + 10, PrintString);

  sprintf (PrintString, "File base name: %s", Chrom[DataSource].QueueHead.BaseName);
  PrintText (PS, 10, PS->PrintLocalHeight - 10, PrintString);

	SetPrintFont (PS, PS->PrintFontPeakList);
	sprintf (PrintString, "# ");
	PrintText (PS, 10, PS->PrintLocalHeight - 52, PrintString);
	sprintf (PrintString, "--------------------------------------------------------------------------");
	PrintText (PS, 10, PS->PrintLocalHeight - 52 - 14, PrintString);

	for (i = 0; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
	  GetQueueItem (DataSource, i);
	
	  sprintf (PrintString, "%d",i+1);
	  PrintText (PS, 10, PS->PrintLocalHeight - 52 - (i + 2)*14, PrintString);
	

	  RowCounter++;
	  if (PageCounter == 0) {
		  if (RowCounter == 25) {
			  PrintFormFeed (PS);
			  RowCounter = 0;
			  PageCounter++;
		  }
	  } else {
		  if (RowCounter == 50) {
			  PrintFormFeed (PS);
			  RowCounter = 0;
			  PageCounter++;
		  }
	  } // if PageCounter
  } // for i

} // PrintSampleQueue
