void
PrintChrom (struct PrintStruct *PS) {
int		DataSource;
int		ActualDSI;
char	*PrintString;
char	*TempString;
double	AxisX0,AxisY0;
double	AxisLength,AxisHeight;
double	x1,x2,y1,y2,yV;
int		i, j, jRow, jCount, jPage, jDiff;
int		PrintPeakNum;
struct PeakStruct PrintPeak;
struct AxisTickStruct AxisTickLegend;

double	ChrMin;
double	ChrMax;
double	ChrDiff;
int		ChrBeg;
int		ChrEnd;
int		RetDiff;
double	ChrBegD;
double	ChrEndD;
double	RetDiffD;
int		RetIdx;

int		TickTemp;
char	LocalFormat[20];

gsize			bytes_read;
gsize			bytes_written;
struct tm *ConvLocalTime;

  ConvLocalTime = alloca (sizeof(struct tm));

  DataSource = GPOINTER_TO_INT(PS->UserParams1);
  ActualDSI = GPOINTER_TO_INT(PS->UserParams2);

  if (!Chrom[DataSource].FileLoaded[ChrFlag]) return;

  PrintString = alloca (10000);
  TempString = alloca (10000);

	// Draws a frame
  if (Options[ActualDSI].PrintFrame)
	  DrawPrintFrame (PS, 0.4, 0, 1, 1, 0);
  else
	  DrawPrintFrame (PS, 0, 0, 1, 1, 0);


  // Assemble the page content
  //****************************

  // Draw chrom curve
  if (Options[ActualDSI].PrintFrame)
	  DrawPrintFrame (PS, 0.4, 0, 1, 1, 0.7);
  else
	  DrawPrintFrame (PS, 0, 0, 1, 1, 0.7);

  AxisX0 = 40;
  AxisY0 = 15;
  AxisLength = PS->PrintLocalWidth - 50;
  AxisHeight = PS->PrintLocalHeight - 55;

  ChrBeg = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepBeg;
  ChrEnd = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepEnd;
  ChrMin = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepMin;
  ChrMax = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepMax;
  ChrDiff = ChrMax - ChrMin;
  RetDiff = ChrEnd - ChrBeg;
  ChrBegD = CPTR (ChrBeg, DataSource);
  ChrEndD = CPTR (ChrEnd, DataSource);
  RetDiffD = CPTR (RetDiff, DataSource);

  // Prints file name
	SetPrintFont (PS, PS->PrintFontDefault);
	sprintf (PrintString, "File name: %s", g_locale_from_utf8 (Chrom[DataSource].ChrName, -1, &bytes_read, &bytes_written, NULL));
	PrintText (PS, AxisX0, AxisY0 + AxisHeight + 32, PrintString);
	sprintf (PrintString, "Method name: %s", g_locale_from_utf8 (Chrom[DataSource].ChromHead->Method.MeasureParameters.MethodName, -1, &bytes_read, &bytes_written, NULL));
	PrintText (PS, AxisX0, AxisY0 + AxisHeight + 22, PrintString);
	sprintf (PrintString, "Calibration name: %s", g_locale_from_utf8 (Chrom[DataSource].ChromHead->Method.MeasureParameters.CalibrationName, -1, &bytes_read, &bytes_written, NULL));
	PrintText (PS, AxisX0, AxisY0 + AxisHeight + 12, PrintString);
	sprintf (PrintString, "Comment: %s", Chrom[DataSource].ChromHead->Method.MeasureParameters.SampleComment);
	PrintText (PS, AxisX0, AxisY0 + AxisHeight + 2, PrintString);

  // Draws the axis
  gnome_print_setlinewidth (PS->PrintContext, 0.2);
  gnome_print_newpath (PS->PrintContext);
  gnome_print_moveto(PS->PrintContext, AxisX0, AxisY0 + AxisHeight);
  gnome_print_lineto(PS->PrintContext, AxisX0, AxisY0);
  gnome_print_lineto(PS->PrintContext, AxisX0 + AxisLength, AxisY0);
  gnome_print_moveto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_closepath (PS->PrintContext);
  gnome_print_stroke (PS->PrintContext);
  gnome_print_setlinewidth (PS->PrintContext, 1.0);

  // Print axis tick marks
  SetPrintFont (PS, PS->PrintFontAxis);
  //Options[ActualDSI].PrintTickMarks = TRUE;
  printf ("PrintTickMarks = %d,   ActualDSI = %d\n", Options[ActualDSI].PrintTickMarks, ActualDSI);
  if (Options[ActualDSI].PrintTickMarks) {
	// Value axis
	AxisTickLegend.AxisMin = ChrMin;
	AxisTickLegend.AxisMax = ChrMax;
	AxisTickCalculate (&AxisTickLegend, 1);
	printf ("AxisMin = %.3f \n", AxisTickLegend.AxisMin);
	printf ("AxisMax = %.3f \n", AxisTickLegend.AxisMax);
	printf ("SmallTickNum = %d \n", AxisTickLegend.SmallTickNum);
	printf ("BigTickNum = %d \n", AxisTickLegend.BigTickNum);
	printf ("SmallTickStartValue = %.3f \n", AxisTickLegend.SmallTickStartValue);
	printf ("BigTickStartValue = %.3f \n", AxisTickLegend.BigTickStartValue);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
	for (i = 0; i < AxisTickLegend.BigTickNum; i++) {
		if (ChrDiff > 0) {
			y1 = (AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 - 4, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			sprintf (PrintString, "%.1f", AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, AxisX0 - 5, AxisY0 + y1, PrintString);
			SetPrintJustify (PS, PrintLeftJustify, 0);
		} // if (ChrDiff > 0)
	} // for i

	// Retention axis
	AxisTickLegend.AxisMin = ChrBegD;
	AxisTickLegend.AxisMax = ChrEndD;
	AxisTickCalculate (&AxisTickLegend, 1);
	printf ("AxisMin = %.3f \n", AxisTickLegend.AxisMin);
	printf ("AxisMax = %.3f \n", AxisTickLegend.AxisMax);
	printf ("SmallTickNum = %d \n", AxisTickLegend.SmallTickNum);
	printf ("BigTickNum = %d \n", AxisTickLegend.BigTickNum);
	printf ("SmallTickStartValue = %.3f \n", AxisTickLegend.SmallTickStartValue);
	printf ("BigTickStartValue = %.3f \n", AxisTickLegend.BigTickStartValue);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
	for (i = 0; i < AxisTickLegend.BigTickNum; i++) {
		if (RetDiffD > 0) {
			x1 = (AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff - ChrBegD) / RetDiffD * AxisLength;
			if (x1 < 0) x1 = 0.0;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 - 4);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 - 4);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			sprintf (PrintString, "%.1f", AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, AxisX0 + x1, AxisY0 -10, PrintString);
			SetPrintJustify (PS, PrintLeftJustify, 0);
		} // if (ChrDiff > 0)
	} // for i
	printf ("PrintTickMarks OK.\n");
  } // PrintTickMarks

// Draws the chromatogram
	if (ChrDiff > 0)
	{
		gnome_print_setlinewidth (PS->PrintContext, 0.2);
		for (i=ChrBeg+1; i<ChrEnd; i++)
		{
			x1 = (double)(i - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
			x2 = (double)(i - ChrBeg - 1) / (double)(ChrEnd - ChrBeg) * AxisLength;
			y1 = (ChromData (i, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			y2 = (ChromData (i - 1, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			if (y2 < 0) y2 = 0.0;
			if (y1 > AxisHeight) y1 = AxisHeight;
			if (y2 > AxisHeight) y2 = AxisHeight;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
		} // for i
		PRINTF ("ChromPrint OK.\n", 0);
		for (j = 0; j < ReprocessOverlayChromNum; j++) {
			for (i=ChrBeg+1; i<ChrEnd; i++)
			{
				if (i <= Chrom[OverlayedChromBase + j].ChromHead->Method.MeasureParameters.Nmp) {
					x1 = (double)(i - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
					x2 = (double)(i - ChrBeg - 1) / (double)(ChrEnd - ChrBeg) * AxisLength;
					y1 = (ChromData (i, OverlayedChromBase + j) - ChrMin) / ChrDiff * AxisHeight;
					y2 = (ChromData (i - 1, OverlayedChromBase + j) - ChrMin) / ChrDiff * AxisHeight;
					if (y1 < 0) y1 = 0.0;
					if (y2 < 0) y2 = 0.0;
					if (y1 > AxisHeight) y1 = AxisHeight;
					if (y2 > AxisHeight) y2 = AxisHeight;
					gnome_print_newpath (PS->PrintContext);
					gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
					gnome_print_closepath (PS->PrintContext);
					gnome_print_stroke (PS->PrintContext);
				} // if i
			} // for i
		} // j - OverlayNum
		PRINTF ("Overlay ChromPrint OK.\n", 0);

// Draws retention & baseline
	gnome_print_setlinewidth (PS->PrintContext, 0.4);
	SetPrintFont (PS, PS->PrintFontChromPeakData);
	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
		GetPeak (i, DataSource);
		RetIdx = CRTP (Chrom[DataSource].Peak->PeakRetention, DataSource);
		if ((RetIdx > ChrBeg) && (RetIdx < ChrEnd)) {
			// Print retention
			x1 = (double)(RetIdx - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
			y1 = (ChromData (RetIdx, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			if (x1 < 0) x1 = 0.0;
			if (x1 > AxisLength) x1 = AxisLength;
			if (y1 < 0) y1 = 0.0;
			if (y1 > AxisHeight) y1 = AxisHeight;
			if ((Options[ActualDSI].PrintBaselines) || (Options[ActualDSI].PrintPeakNumber)) {
				gnome_print_newpath (PS->PrintContext);
				gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 2);
				gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 + 2);
				gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 2);
				gnome_print_closepath (PS->PrintContext);
				gnome_print_stroke (PS->PrintContext);
			}
			strcpy (PrintString, "");
			strcpy (TempString, "");
			if (Options[ActualDSI].PrintPeakNumber)
				sprintf (PrintString,"%d ",i+1);
			if (Options[ActualDSI].PrintPeakRetention) {
				sprintf (TempString,"Ret:%.2f ",Chrom[DataSource].Peak->PeakRetention);
				strcat (PrintString, TempString);
			} // if PrintPeakRetention
			if (Options[ActualDSI].PrintPeakConcentration) {
				sprintf (TempString,"Conc:%.3f ",Chrom[DataSource].Peak->PeakConc);
				strcat (PrintString, TempString);
			} // if PrintPeakConcentration
			if (Options[ActualDSI].PrintPeakName) {
				sprintf (TempString,"Name:%s",Chrom[DataSource].Peak->PeakName);
				strcat (PrintString, TempString);
			} // if PrintPeakName
			if (y1 > AxisHeight - 6) y1 = AxisHeight - 6;
			PrintText (PS, AxisX0 + x1 - 1, AxisY0 + y1 + 2, PrintString);
			// Draws baseline
			// BL Tick begin
			if (Options[ActualDSI].PrintBaselines) {
				RetIdx = CRTP (Chrom[DataSource].Peak->BlTimeBegin, DataSource);
				x1 = (float)(RetIdx - ChrBeg) / (float)(ChrEnd - ChrBeg) * AxisLength;
				if (x1 < 0) x1 = 0.0;
				if (x1 > AxisLength) x1 = AxisLength;
				y1 = (Chrom[DataSource].Peak->BlValueBegin - ChrMin) / ChrDiff * AxisHeight;
				if (y1 < 0) y1 = 0.0;
				if (y1 > AxisHeight) y1 = AxisHeight;
				yV = (ChromData(RetIdx, DataSource) - ChrMin) / ChrDiff * AxisHeight;
				if (yV < 0) yV = 0.0;
				if (yV > AxisHeight) yV = AxisHeight;
				gnome_print_newpath (PS->PrintContext);
				if (Chrom[DataSource].Peak->BlTypeBegin == BP_VALLEY) {
					gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + yV);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
				} else {
					gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
				}
				gnome_print_closepath (PS->PrintContext);
				gnome_print_stroke (PS->PrintContext);
				// BL Tick end
				RetIdx = CRTP (Chrom[DataSource].Peak->BlTimeEnd, DataSource);
				x2 = (float)(RetIdx - ChrBeg) / (float)(ChrEnd - ChrBeg) * AxisLength;
				if (x2 < 0) x2 = 0.0;
				if (x2 > AxisLength) x2 = AxisLength;
				y2 = (Chrom[DataSource].Peak->BlValueEnd - ChrMin) / ChrDiff * AxisHeight;
				if (y2 < 0) y2 = 0.0;
				if (y2 > AxisHeight) y2 = AxisHeight;
				yV = (ChromData(RetIdx, DataSource) - ChrMin) / ChrDiff * AxisHeight;
				if (yV < 0) yV = 0.0;
				if (yV > AxisHeight) yV = AxisHeight;
				gnome_print_newpath (PS->PrintContext);
				if (Chrom[DataSource].Peak->BlTypeEnd == BP_VALLEY) {
					gnome_print_moveto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + yV);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
				} else {
					gnome_print_moveto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2 + 4);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
					gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2 + 4);
				}
				gnome_print_closepath (PS->PrintContext);
				gnome_print_stroke (PS->PrintContext);
				// BL
				gnome_print_newpath (PS->PrintContext);
				gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
				gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
				gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
				gnome_print_closepath (PS->PrintContext);
				gnome_print_stroke (PS->PrintContext);
		} // if PrintBaselines
		} // if RetIdx
	} // for i
	PRINTF ("RetentionPrint OK.\n", 0);
	PRINTF ("\n", 0);
	} // if ChrDiff > 0

	// Prints peak list table
  if (Options[ActualDSI].PrintFrame)
		DrawPrintFrame (PS, 0.1, 0, 1, 0.7, 0.0);
  else
		DrawPrintFrame (PS, 0, 0, 1, 0.7, 0.0);
	PRINTF ("\nTableFrame OK.\n", 0);

	SetPrintFont (PS, PS->PrintFontPeakList);
	SetPrintJustify (PS, PrintRightJustify, 0);
	sprintf (PrintString, "#");
	PrintText (PS, 20, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Ret.");
	PrintText (PS, 64, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Area");
	PrintText (PS, 135, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Area%%");
	PrintText (PS, 175, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Height");
	PrintText (PS, 240, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Height%%");
	PrintText (PS, 290, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Conc");
	PrintText (PS, 350, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "Name");
	SetPrintJustify (PS, PrintLeftJustify, 0);
	PrintText (PS, 370, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "----------------------------------------------------------------------------------");
	PrintText (PS, 2, PS->PrintLocalHeight - 12 - 14, PrintString);

  jRow = 0;
  jCount = 0;
  jPage = 1;
  jDiff = 2;
  LinePrintCounterInit (PS, 25);
  for (j = 0; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++) {
	  Chrom[DataSource].ActualDetector = j;
	  for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
		GetPeak (i, DataSource);
		SetPrintJustify (PS, PrintRightJustify, 0);

		sprintf (PrintString, "%d", jCount+1);
		PrintText (PS, 20, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%.2f",Chrom[DataSource].Peak->PeakRetention);
		PrintText (PS, 64, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%.0f",Chrom[DataSource].Peak->PeakArea);
		PrintText (PS, 135, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%.1f",100 * Chrom[DataSource].Peak->PeakAreaR);
		PrintText (PS, 175, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%.0f",Chrom[DataSource].Peak->PeakHeight);
		PrintText (PS, 240, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%.1f",100 * Chrom[DataSource].Peak->PeakHeightR);
		PrintText (PS, 290, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		strcpy (LocalFormat, "");
		FormatFloat (Chrom[DataSource].Peak->PeakConc, 8, 3, LocalFormat);
		sprintf (PrintString, "%.3f",Chrom[DataSource].Peak->PeakConc);
		PrintText (PS, 350, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

		sprintf (PrintString, "%s",Chrom[DataSource].Peak->PeakName);
		SetPrintJustify (PS, PrintLeftJustify, 0);
		PrintText (PS, 370, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);

	  jCount++;
	  LinePrintCounter (PS);
	  jRow = PS->PrintLineCounter;
	  if (jRow == 0) {
		DrawPrintFrame (PS, 0.1, 0, 1, 1, 0.0);
		jDiff = 0;
		jPage++;
	  } // jRow == 0
	  } // for i
  } // j
  LinePrintCounterDone (PS);
  
  jRow++;

  localtime_r (&Chrom[DataSource].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);
  sprintf (PrintString, "Measure start date and time : %d.%.2d.%.2d   %.2d:%.2d:%.2d",  \
	  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
	  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec); // Timestamp of start
  PrintText (PS, 2, PS->PrintLocalHeight - 12 - (jRow + jPage)*14, PrintString);
  jRow++;
  jRow++;
  jRow++;

  sprintf (PrintString, "%s","..........                ........");
  PrintText (PS, 120, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);
  jRow++;

  sprintf (PrintString, "%s","Laboratory                Operator");
  PrintText (PS, 120, PS->PrintLocalHeight - 12 - (jRow + jDiff)*14, PrintString);
  jRow++;

	Chrom[DataSource].ActualDetector = 0;
} // PrintChrom

void
PrintControlList (struct PrintStruct *PS) {
char	*PrintString;
char	*TempString;
double	AxisX0,AxisY0;
double	AxisLength,AxisHeight;
double	x1,x2,y1,y2;
int		i,j,jRow;
int		PrintPeakNum;
struct PeakStruct PrintPeak;
struct AxisTickStruct AxisTickLegend;

double	ChrMin;
double	ChrMax;
double	ChrDiff;
int		ChrBeg;
int		ChrEnd;
int		RetIdx;

int		TickTemp;
int		DataSource;
int		ActualDSI;

  DataSource = GPOINTER_TO_INT(PS->UserParams1);
  if (!Chrom[DataSource].FileLoaded[ChrFlag]) return;
  ActualDSI = GPOINTER_TO_INT(PS->UserParams2);

  PrintString = alloca (10000);
  TempString = alloca (10000);

  Chrom[DataSource].ActualDetector = 0;

	// Draws a frame
	DrawPrintFrame (PS, 0.4, 0, 1, 1, 0);


  // Assemble the page content
  //****************************

  // Draw chrom curve
  DrawPrintFrame (PS, 0.4, 0, 1, 1, 0.7);

  AxisX0 = 40;
  AxisY0 = 15;
  AxisLength = PS->PrintLocalWidth - 50;
  AxisHeight = PS->PrintLocalHeight - 35;

  ChrBeg = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepBeg;
  ChrEnd = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepEnd;
  ChrMin = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepMin;
  ChrMax = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RepMax;
  ChrDiff = ChrMax - ChrMin;

  // Prints file name
  printf ("SetPrintFont\n");
	SetPrintFont (PS, PS->PrintFontDefault);
  printf ("SetPrintFont\n");
	sprintf (PrintString, "File name: %s", Chrom[DataSource].ChrName);
  printf ("File name: %s\n", PrintString);
	PrintText (PS, AxisX0, AxisY0 + AxisHeight + 10, PrintString);
  printf ("PrintText\n");

  // Draws the axis
  gnome_print_setlinewidth (PS->PrintContext, 0.2);
  gnome_print_newpath (PS->PrintContext);
  gnome_print_moveto(PS->PrintContext, AxisX0, AxisY0 + AxisHeight);
  gnome_print_lineto(PS->PrintContext, AxisX0, AxisY0);
  gnome_print_lineto(PS->PrintContext, AxisX0 + AxisLength, AxisY0);
  gnome_print_moveto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_closepath (PS->PrintContext);
  gnome_print_stroke (PS->PrintContext);
  gnome_print_setlinewidth (PS->PrintContext, 1.0);
  printf ("Draws the axis OK.\n");

	// Print axis tick marks
	SetPrintFont (PS, PS->PrintFontAxis);
	Options[DataSource].PrintTickMarks = FALSE;
	if (Options[DataSource].PrintTickMarks) {
	for (i = ChrBeg; i < ChrEnd; i++)
	{
		// Tick
		TickTemp = (int)((CPTR (i, DataSource) + 0.001) / Options[0].PrintXAxisTicks + 0.5);
		if (i == CRTP (TickTemp * Options[0].PrintXAxisTicks, DataSource))
		{
		gnome_print_newpath (PS->PrintContext);
		x1 = (double)(i - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
		gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0);
		gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 - 3);
		gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0);
		gnome_print_closepath (PS->PrintContext);
		gnome_print_stroke (PS->PrintContext);
		} // if i
		// Retention
		TickTemp = (int)((CPTR (i, DataSource) + 0.001) / Options[0].PrintXAxisValues + 0.5);
		if (i == CRTP (TickTemp * Options[0].PrintXAxisValues, DataSource))
		{
		gnome_print_newpath (PS->PrintContext);
		x1 = (double)(i - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
		gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0);
		gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 - 5);
		gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0);
		gnome_print_closepath (PS->PrintContext);
		gnome_print_stroke (PS->PrintContext);
		sprintf (PrintString, "%.0f", CPTR (i, DataSource));
		PrintText (PS, AxisX0 + x1, AxisY0 - 11, PrintString);
		} // if i
	} // for i
	// Value axis
	AxisTickLegend.AxisMin = ChrMin;
	AxisTickLegend.AxisMax = ChrMax;
	AxisTickCalculate (&AxisTickLegend, 1);
	printf ("AxisMin = %.3f \n", AxisTickLegend.AxisMin);
	printf ("AxisMax = %.3f \n", AxisTickLegend.AxisMax);
	printf ("SmallTickNum = %d \n", AxisTickLegend.SmallTickNum);
	printf ("BigTickNum = %d \n", AxisTickLegend.BigTickNum);
	printf ("SmallTickStartValue = %.3f \n", AxisTickLegend.SmallTickStartValue);
	printf ("BigTickStartValue = %.3f \n", AxisTickLegend.BigTickStartValue);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
//	printf (" = % \n", AxisTickLegend.);
	for (i = 0; i < AxisTickLegend.BigTickNum; i++) {
		if (ChrDiff > 0) {
			y1 = (AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 - 4, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			sprintf (PrintString, "%.1f", AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, AxisX0 - 5, AxisY0 + y1, PrintString);
			SetPrintJustify (PS, PrintLeftJustify, 0);
		} // if (ChrDiff > 0)
	} // for i
	printf ("PrintTickMarks OK.\n");
  } // PrintTickMarks

// Draws the chromatogram
  if (ChrDiff > 0) {
		gnome_print_setlinewidth (PS->PrintContext, 0.2);
		for (i=ChrBeg+1; i<ChrEnd; i++)
		{
			x1 = (double)(i - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
			x2 = (double)(i - ChrBeg - 1) / (double)(ChrEnd - ChrBeg) * AxisLength;
			y1 = (ChromData (i, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			y2 = (ChromData (i - 1, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			if (y2 < 0) y2 = 0.0;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
		} // for i
  printf ("ChromPrint OK.\n");

// Draws retention & baseline
	gnome_print_setlinewidth (PS->PrintContext, 0.4);
	SetPrintFont (PS, PS->PrintFontChromPeakData);
	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
		GetPeak (i, DataSource);
		RetIdx = CRTP (Chrom[DataSource].Peak->PeakRetention, DataSource);
		if ((RetIdx > ChrBeg) && (RetIdx < ChrEnd)) {
			// Print retention
			x1 = (double)(RetIdx - ChrBeg) / (double)(ChrEnd - ChrBeg) * AxisLength;
			y1 = (ChromData (RetIdx, DataSource) - ChrMin) / ChrDiff * AxisHeight;
			if (x1 < 0) x1 = 0.0;
			if (x1 > AxisLength) x1 = AxisLength;
			if (y1 < 0) y1 = 0.0;
			if (y1 > AxisHeight) y1 = AxisHeight;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			strcpy (PrintString, "");
			strcpy (TempString, "");
//			if (PrintPeakNumber)
				sprintf (PrintString,"%d ",i+1);
//			if (PrintPeakRetention)
			{
			sprintf (TempString,"Ret:%.2f ",Chrom[DataSource].Peak->PeakRetention);
			strcat (PrintString, TempString);
			} // if PrintPeakRetention
//			if (PrintPeakConcentration)
			{
			sprintf (TempString,"Conc:%.3f ",Chrom[DataSource].Peak->PeakConc);
			strcat (PrintString, TempString);
			} // if PrintPeakConcentration
//			if (PrintPeakName)
			{
			sprintf (TempString,"Name:%s",Chrom[DataSource].Peak->PeakName);
			strcat (PrintString, TempString);
			} // if PrintPeakName
			PrintText (PS, AxisX0 + x1 + 4, AxisY0 + y1 - 4, PrintString);
			// Draws baseline
			// BL Tick begin
			RetIdx = CRTP (Chrom[DataSource].Peak->BlTimeBegin, DataSource);
			x1 = (float)(RetIdx - ChrBeg) / (float)(ChrEnd - ChrBeg) * AxisLength;
			if (x1 < 0) x1 = 0.0;
			if (x1 > AxisLength) x1 = AxisLength;
			y1 = (Chrom[DataSource].Peak->BlValueBegin - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			if (y1 > AxisHeight) y1 = AxisHeight;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1 - 4);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			// BL Tick end
			RetIdx = CRTP (Chrom[DataSource].Peak->BlTimeEnd, DataSource);
			x2 = (float)(RetIdx - ChrBeg) / (float)(ChrEnd - ChrBeg) * AxisLength;
			if (x2 < 0) x2 = 0.0;
			if (x2 > AxisLength) x2 = AxisLength;
			y2 = (Chrom[DataSource].Peak->BlValueEnd - ChrMin) / ChrDiff * AxisHeight;
			if (y2 < 0) y2 = 0.0;
			if (y2 > AxisHeight) y2 = AxisHeight;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2 + 4);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2 + 4);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
			// BL
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
		} // if RetIdx
	} // for i
	PRINTF ("RetentionPrint OK.\n", 0);
	PRINTF ("\n", 0);
  } // if ChrDiff > 0

	// Prints peak list table
	DrawPrintFrame (PS, 0.1, 0, 1, 0.7, 0.0);
	PRINTF ("\nTableFrame OK.\n", 0);

	SetPrintFont (PS, PS->PrintFontPeakList);
	sprintf (PrintString, "#    Ret.      Area       Low limit   High limit   Expected   Conc   Name");
	PrintText (PS, 0, PS->PrintLocalHeight - 12, PrintString);
	sprintf (PrintString, "-------------------------------------------------------------------------------------");
	PrintText (PS, 0, PS->PrintLocalHeight - 12 - 14, PrintString);

  jRow = 0;
  for (j = 0; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++) {
	  Chrom[DataSource].ActualDetector = j;
	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[j]; i++) {
		GetPeak (i, DataSource);
	
		if (Chrom[DataSource].Peak->PeakIdentified) {
			sprintf (PrintString, "%d",jRow+1);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, 20, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.3f",Chrom[DataSource].Peak->PeakRetention);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, 40, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.0f",Chrom[DataSource].Peak->PeakArea);
			SetPrintJustify (PS, PrintRightJustify, 0);
			PrintText (PS, 90, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.3f",100 * Chrom[DataSource].Peak->PeakConcLowerLimit);
			PrintText (PS, 156, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.3f",Chrom[DataSource].Peak->PeakConcUpperLimit);
			PrintText (PS, 230, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.3f",100 * Chrom[DataSource].Peak->PeakConcExpectedValue);
			PrintText (PS, 306, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%.3f",Chrom[DataSource].Peak->PeakConc);
			PrintText (PS, 372, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
		
			sprintf (PrintString, "%s",Chrom[DataSource].Peak->PeakName);
			PrintText (PS, 414, PS->PrintLocalHeight - 12 - (jRow + 2)*14, PrintString);
			jRow++;
	} // Identified
	} // for i
  } // j

	Chrom[DataSource].ActualDetector = 0;
} // PrintControlList
