// Measure functions for TR930

extern void
TR930InitFunction (void) {
} // TR930InitFunction

extern void
TR30DoneFunction (void) {
} // TR930DoneFunction

extern void
TR930ExecFunction (void) {
static int				ActualTrack;
static int				ActualDataPoint;
static int				TrackStatus;
static FILE			*RawFileTrack;
static int				RawFileTrackError;
char						*RawFileNameTrack;

  switch (ThreadStatus[0]) {
	  case ThreadStatusIdle :
		break; // ThreadStatusIdle
	  case ThreadStatusStart :
		  RawFileNameTrack = alloca (FilenameLength);
		  RawFileTrackError = FALSE;
		  pthread_mutex_lock (&measure_data_mutex);
		  MeasureDataCounter[0] = 0;
		  MeasureTickCounter[0] = 0;
		  pthread_mutex_unlock (&measure_data_mutex);
		  pthread_mutex_lock (&measure_parameter_mutex);
		  strcpy (RawFileNameTrack, Options[0].MeasureFilename);
		  pthread_mutex_unlock (&measure_parameter_mutex);
		  strcat (RawFileNameTrack, ".raw.");
		  RawFileTrack = fopen (RawFileNameTrack, "w");
		  if (RawFileTrack == NULL) RawFileTrackError = TRUE;
		  ThreadStatus[0] = ThreadStatusRun;
		  ThreadCommandOk = TRUE;
		  break; // ThreadStatusStart
	  case ThreadStatusRun :
		  pthread_mutex_lock (&measure_data_mutex);
		  pthread_mutex_unlock (&measure_data_mutex);
		  break; // ThreadStatusRun
	  case ThreadStatusStop :
		  pthread_mutex_lock (&measure_data_mutex);
		  pthread_mutex_unlock (&measure_data_mutex);
		  if (!RawFileTrackError) fclose (RawFileTrack);
		  ThreadMeasureFinished = TRUE;
		  ThreadStatus[0] = ThreadStatusWait;
		  ThreadCommandOk = TRUE;
		  break; // ThreadStatusStop
	  case ThreadStatusWait :
		  break; // ThreadStatusWait
	  case ThreadStatusFinish :
		  ThreadMeasureOk = TRUE;
		  ThreadStatus[0] = ThreadStatusIdle;
		  ThreadCommandOk = TRUE;
		  break; // ThreadStatusFinish
	  case ThreadStatusSuspended :
		  break; // ThreadStatusSuspended
	  case ThreadStatusCancelled :
		  ThreadStatus[0] = ThreadStatusIdle;
		  ThreadCommandOk = TRUE;
		  break; // ThreadStatusCancelled
  } // switch 

} // TR930ExecFunction

// Sh930 measure functions

/*
00 - Reset

10 - Status

20 - Lamp ON

30 - AD977 Reset (c - channel set)
31 - AD977 accum counter set (c - n)
32 - AD977 2 byte lekerdezes *****
33 - AD977 3 byte lekerdezes *****

40 - Filter HOME *****
41 - Filter STEP 1
42 - Filter STEP n (43 01 n)
43 - Filter Zth filter (43 01 Z) *****
44 - Filter OFF

50 - Y HOME
51 - Y STEP 1 fwd
52 - Y STEP n fwd
53 - Y STEP 1 bwd
54 - Y STEP n bwd
55 - Y OFF
56 - Y Raw Home
57 - Y STEP "m" mm (50 step/mm)
58 - Y STEP "m" mm with raw home

60 - X HOME
61 - X STEP 1 fwd
62 - X STEP n fwd
63 - X STEP 1 bwd
64 - X STEP n bwd
65 - X OFF
66 - X Raw Home
67 - X STEP "m" mm (5 step/mm)
68 - X STEP "m" mm with raw home

70 - WL Home
71 - WL STEP 1 FWD
72 - WL STEP n FWD
73 - WL STEP z-th position
74 - WL STEP l-m nanometers l*256+m
75 - OFF

80 - Spectra, raw full spectra 760-200
81 - Spectra, raw spectra, 5 nm range only
82 - Goto UV - 400 nm (step 360)

A0 - MEASURE R:#0,1000 data points (2 bytes)
A1 - MEASURE R:#0,1000 data points (2 byte) moving in place
A2 - MEASURE R:#0,1000 data points (2 byte) without moving
A3 - MEASURE "n" mm, HiRes accumulation, R:#0, n*50 data points, backward, #0
A4 - MEASURE ZigZag, m1,m2,n,r; m=m1+m2*256 steps, n track steps, r Y steps
	R: #0, m*n data points, backward, #0

C0 - Normalizacio R:D/A
C1 - Normal fel
C2 - Normal le
C8 - D/A 00
C9 - D/A FF
CA - D/A UP
CB - D/A DN
CC - D/A 80
CF - D/A set value

D0 - HiVolt OFF
D1 - HiVolt CH-Refl
D2 - HiVolt CH-Transm

*/

// Sh930 measure main thread function

/*
extern void
sh930_measure_exec_function (void) {
} // sh930_measure_exec_function

extern void*
sh930_measure (void* unused)
{
int			pth_counter;

int			i,j;
int			GotoWL;
int			Fluor;
int			NormX,NormY;
int			iNorm,jNorm;

void internal_sh930_measure (void) {
	Fluor = FALSE;
	switch (WorkLayer.LayerMethod.SH930Parameters.SH930MeasureMode) {
		case Sh930MeasScanModeRefl:
			Fluor = FALSE;
			Sh930CommandExec (Sh930CommandHiVoltRefl,0,0,0,0);
			if (PrintfMode) printf("HiVoltRefl, Fluor=FALSE\n");
			break; // Sh930MeasScanModeRefl
		case Sh930MeasScanModeFluor:
			Fluor = TRUE;
			Sh930CommandExec (Sh930CommandHiVoltRefl,0,0,0,0);
			if (PrintfMode) printf("HiVoltRefl, Fluor=TRUE\n");
			break; // Sh930MeasScanModeFluor
		case Sh930MeasScanModeTransm:
			Fluor = FALSE;
			Sh930CommandExec (Sh930CommandHiVoltTran,0,0,0,0);
			if (PrintfMode) printf("HiVoltTran, Fluor=FALSE\n");
			break; // Sh930MeasScanModeTransm
	} // switch

	if (PrintfMode) printf("Home Y\n");
	Sh930CommandExec (Sh930CommandYHome,0,0,0,0);

	GotoWL = WorkLayer.LayerMethod.SH930Parameters.SH930WaveLength;
	if (PrintfMode) printf("Setting wavelength to %d\n",GotoWL);
	Sh930CommandExec (Sh930CommandGotoWL,GotoWL,Fluor,0,0);

	if (Sh930ThreadCancel == TRUE) return;

	if (WorkLayer.LayerMethod.SH930Parameters.SH930NormFind == TRUE) {
		if (PrintfMode) printf("Normalize in range %d mm.\n",WorkLayer.LayerMethod.SH930Parameters.SH930NormFindInRange);
		NormX = WorkLayer.LayerMethod.SH930Parameters.SH930NormX-WorkLayer.LayerMethod.SH930Parameters.SH930NormFindInRange;
		if (PrintfMode) printf("Goto X: %d\n",NormX);
		Sh930CommandExec (Sh930CommandXStepH,NormX,0,0,0);
		NormY = WorkLayer.LayerMethod.SH930Parameters.SH930NormY-WorkLayer.LayerMethod.SH930Parameters.SH930NormFindInRange;
		if (PrintfMode) printf("Goto Y: %d\n",NormY);
		Sh930CommandExec (Sh930CommandYStepH,NormY,0,0,0);
		if (PrintfMode) printf("Normalization scan start...\n");
		Sh930CommandExec (Sh930CommandNormalize,0,0,0,0);
		WorkLayer.LayerMethod.SH930Parameters.SH930NormValue = Sh930DAByte;
		iNorm = 0;
		jNorm = 0;
		for (i=0; i<2*WorkLayer.LayerMethod.SH930Parameters.SH930NormFindInRange; i++)
		{
		if (i != 0) 
			Sh930CommandExec (Sh930CommandXStepH,NormX,0,0,0);
		if (PrintfMode) printf ("Y= %d  ",i+NormY);
		for (j=0; j<2*WorkLayer.LayerMethod.SH930Parameters.SH930NormFindInRange; j++)
			{
			Sh930CommandExec (Sh930CommandNormalize,0,0,0,0);
			if (PrintfMode) printf (" %d  ",Sh930DAByte);
			if (WorkLayer.LayerMethod.SH930Parameters.SH930NormValue > Sh930DAByte)
				{
				WorkLayer.LayerMethod.SH930Parameters.SH930NormValue = Sh930DAByte;
				iNorm = i;
				jNorm = j;
				} // if Sh930DAByte
			Sh930CommandExec (Sh930CommandXStep,1,0,0,0);
			} // j
		if (PrintfMode) printf ("\n");
		Sh930CommandExec (Sh930CommandYStep,1,0,0,0);
		} // i
		if (PrintfMode) printf("Normalization scan finished.\n");
		if (PrintfMode) printf("Normalize at best point: %d as X, %d as Y.\n",jNorm,iNorm);
		Sh930CommandExec (Sh930CommandXStepH,jNorm,0,0,0);
		Sh930CommandExec (Sh930CommandYStepH,iNorm,0,0,0);
		Sh930CommandExec (Sh930CommandDAHalf,0,0,0,0);
		Sh930CommandExec (Sh930CommandNormalize,0,0,0,0);
		WorkLayer.LayerMethod.SH930Parameters.SH930NormValue = Sh930DAByte;
		WorkLayer.LayerMethod.SH930Parameters.SH930NormX = jNorm;
		WorkLayer.LayerMethod.SH930Parameters.SH930NormY = iNorm;
		} else {
		NormX = WorkLayer.LayerMethod.SH930Parameters.SH930NormX;
		if (PrintfMode) printf("Goto X: %d\n",NormX);
		Sh930CommandExec (Sh930CommandXStepH,NormX,0,0,0);
		NormY = WorkLayer.LayerMethod.SH930Parameters.SH930NormY;
		if (PrintfMode) printf("Goto Y: %d\n",NormY);
		Sh930CommandExec (Sh930CommandYStepH,NormY,0,0,0);
		if (PrintfMode) printf("Normalize \n");
		Sh930CommandExec (Sh930CommandDAHalf,0,0,0,0);
		Sh930CommandExec (Sh930CommandNormalize,0,0,0,0);
		WorkLayer.LayerMethod.SH930Parameters.SH930NormValue = Sh930DAByte;
	} // if SH930NormFind

	if (Sh930ThreadCancel == TRUE) return;

	if (PrintfMode) printf("Home Y\n");
	Sh930CommandExec (Sh930CommandYHome,0,0,0,0);

	if (WorkLayer.LayerMethod.SH930Parameters.SH930HResStart != -1) {
		Sh930CommandExec (Sh930CommandYStep,WorkLayer.LayerMethod.SH930Parameters.SH930HResStart,0,0,0);
		printf("HRes Y start value= %d mm done.\n",WorkLayer.LayerMethod.SH930Parameters.SH930HResStart);
	} // if HRes

	if (Sh930ThreadCancel == TRUE) return;

for (i=0; i<WorkLayer.LayerQueueItemNum; i++)
	{
	if (Sh930ThreadCancel == TRUE) return;
	Sh930DrawMeasLength = 200;
	if (WorkLayer.LayerMethod.SH930Parameters.SH930ScanGeomLinHRes == TRUE) 
		Sh930DrawMeasLength = WorkLayer.LayerMethod.SH930Parameters.SH930HResLength;
	Sh930DrawMeasTrack = i + 1;
	Sh930DrawMeasStart = 0;
	if (WorkLayer.LayerMethod.SH930Parameters.SH930HResStart != -1) 
		Sh930DrawMeasStart = WorkLayer.LayerMethod.SH930Parameters.SH930HResStart;
	if (PrintfMode) printf("Positioning track %d to %d mm\n",i,WorkLayerItems[i].TrackPosition);
	Sh930CommandExec (Sh930CommandXStepH,WorkLayerItems[i].TrackPosition,0,0,0);
	Sh930ZeroRaw10000Data ();
	switch (WorkLayer.LayerMethod.SH930Parameters.SH930ScanGeometry) {
		case Sh930MeasScanGeomLin:
			if (WorkLayer.LayerMethod.SH930Parameters.SH930ScanGeomLinHRes == TRUE) 
			{
			if (PrintfMode) printf("Execute measure in Linear High Res mode\n");
			Sh930CommandExec(Sh930CommandHiResMeas, i, WorkLayer.LayerMethod.SH930Parameters.SH930HResLength,0,0);
			} else {
			if (PrintfMode) printf("Execute measure in Linear Low Res mode\n");
			Sh930CommandExec(Sh930CommandExecMeas, i, 0,0,0);
			if (PrintfMode) printf("Home Y\n");
			Sh930CommandExec (Sh930CommandYHome,0,0,0,0);
			} // SH930ScanGeomLinHRes
			break; // Sh930MeasScanGeomLin
		case Sh930MeasScanGeomZZ1:
			if (WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagHiRes == TRUE) 
			{
			if (PrintfMode) printf("Execute measure in Zigzag High Res mode\n");
			if (PrintfMode) printf ("ZigZagSteps: %d, TrackSteps: %d, YResolSteps: %d\n", 
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagTrackSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagYResolSteps);
			Sh930CommandExec(Sh930CommandZigZagMeas, i, 
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagTrackSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagYResolSteps);
			} else {
			if (PrintfMode) printf("Execute measure in Zigzag Low Res mode\n");
			if (PrintfMode) printf ("ZigZagSteps: %d, TrackSteps: %d, YResolSteps: %d\n", 
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagTrackSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagYResolSteps);
			Sh930CommandExec(Sh930CommandZigZagMeas, i, 
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagTrackSteps,
							WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagYResolSteps);
			} // SH930ScanGeomLinHRes
			break; // Sh930MeasScanGeomZZ1
		case Sh930MeasScanGeomZZ2:
			break; // Sh930MeasScanGeomZZ2
	} // switch WorkLayer.LayerMethod.SH930Parameters.SH930ScanGeometry

	Sh930TrackReady++;

	} // i

	Sh930CommandExec (Sh930CommandHiVoltOff,0,0,0,0);
	if (PrintfMode) printf("Measure end, HiVolt OFF \n");
	Sh930CommandExec (Sh930CommandDA0,0,0,0,0);
	if (PrintfMode) printf("Measure end, DA Zero \n");
	if (PrintfMode) printf("Home Y...start\n");
	Sh930CommandExec (Sh930CommandYHome,0,0,0,0);
	if (PrintfMode) printf("HomeY done\n");
	ch_dir (CurrentLayerMeasureDir); // NEM jó, nem lehet ch_dir()

	Layer = WorkLayer;
	for (i=0; i<MaxLayerItem; i++)
	{
		LayerItems[i] = WorkLayerItems[i];
	} // for i
	if (PrintfMode) printf("Default layer directory is: %s\n",CurrentLayerMeasureDir);
	strcpy(LayName,CurrentLayerMeasureDir);
	if (PrintfMode) printf("Default layer name is: %s\n",DefaultLayerName);
	strcat(LayName,"/");
	strcat(LayName,DefaultLayerName);
	strcat(LayName,".lay");
	strcpy(Filename,LayName);
	if (PrintfMode) printf("Filename is: %s\n",Filename);
	LayerSave ();
} // internal_sh930_measure

	pth_counter = 0;
	Sh930ThreadRun = TRUE;
	Sh930ThreadFinished = FALSE;
	while (Sh930ThreadRun == TRUE) {
		while (Sh930ThreadStart == FALSE) {
		usleep (10000);
		} // while Sh930ThreadStart
		printf ("Sh930ThreadStart detected, InstrID: %d,  PID %d,  Counter: %d\n",InstrID,(int)getpid(),pth_counter);
		pth_counter++;
//
// -----Measure function starts here
//

	if (Sh930ThreadStart == TRUE) {
		Sh930ThreadCancel = FALSE;
		internal_sh930_measure ();
		if (Sh930ThreadCancel == TRUE) {
			Sh930CommandExec (Sh930CommandHiVoltOff,0,0,0,0);
			if (PrintfMode) printf("Measure end, HiVolt OFF \n");
			Sh930CommandExec (Sh930CommandDA0,0,0,0,0);
			if (PrintfMode) printf("Measure end, DA Zero \n");
		} // Sh930ThreadCancel == TRUE
		Sh930ThreadStart = FALSE;
		Sh930ThreadFinished = TRUE;
	} // if (Sh930ThreadStart == TRUE)
	} // while (Sh930ThreadRun)

	ThreadExitOk = TRUE;
	return NULL;
} // sh930_measure

*/

extern void
TR930CommandExec (int CmdCode, int Param1, int Param2, int Param3, int Param4)
{
int flush_result;

  flush_result = tty_flush();
  switch (CmdCode) {
  case TR930CommandXHome:
	  TR930XHome ();
	  break; // TR930CommandXHome
  case TR930CommandXStep:
	  TR930XStep (Param1);
	  break; // TR930CommandXStep
  case TR930CommandXStepH:
	  TR930XStepH (Param1);
	  break; // TR930CommandXStepH
  case TR930CommandYHome:
	  TR930YHome ();
	  break; // TR930CommandYHome
  case TR930CommandYStep:
	  TR930YStep (Param1);
	  break; // TR930CommandYStep
  case TR930CommandYStepH:
	  TR930YStepH (Param1);
	  break; // TR930CommandYStepH
  case TR930CommandGotoWL:
	  TR930GotoWL(Param1, Param2);
	  break; // TR930CommandGotoWL
  case TR930CommandDASet:
	  TR930DASet (Param1);
	  break; // TR930CommandDASet
  case TR930CommandDA0:
	  TR930DA0 ();
	  break; // TR930CommandDA0
  case TR930CommandDAFull:
	  TR930DAFull ();
	  break; // TR930CommandDAFull
  case TR930CommandDAHalf:
	  TR930DAHalf ();
	  break; // TR930CommandDAHalf
  case TR930CommandDAUp:
	  TR930DAUp ();
	  break; // TR930CommandDAUp
  case TR930CommandDADown:
	  TR930DADown ();
	  break; // TR930CommandDADown
  case TR930CommandNormalize:
	  TR930Normal();
	  break; // TR930CommandNormalize
  case TR930CommandLowResMeas:
	  TR930LowResMeasure ();
	  break; // TR930CommandLowResMeas
  case TR930CommandLowResAcqOnly:
	  TR930LowResAcquisiteOnly ();
	  break; // TR930CommandLowResAcqOnly
  case TR930CommandLowResNullStep:
	  TR930LowResNullStepButExcite ();
	  break; // TR930CommandLowResNullStep
  case TR930CommandHiResMeas:
	  TR930HiResMeasure (Param1);
	  break; // TR930CommandHiResMeas
  case TR930CommandZigZagMeas:
	  TR930ZigZagMeasure (Param1,Param2,Param3);
	  break; // TR930CommandZigZagMeas
  case TR930CommandHiVoltRefl:
	  TR930HiVoltRefl ();
	  break; // TR930CommandHiVoltRefl
  case TR930CommandHiVoltTran:
	  TR930HiVoltTransm ();
	  break; // TR930CommandHiVoltTran
  case TR930CommandHiVoltOff:
	  TR930HiVoltOff ();
	  break; // TR930CommandHiVoltOff
  } // switch
} // TR930CommandExec

extern void
TR930HiVoltOff(void)
{
unsigned char	byte1;

  timeout_value=400;
  dputc ('\xD0');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930HiVoltOff

extern void
TR930HiVoltRefl(void)
{
unsigned char	byte1;

  timeout_value=400;
  dputc ('\xD1');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930HiVoltRefl

extern void
TR930HiVoltTransm(void)
{
unsigned char	byte1;

  timeout_value=400;
  dputc ('\xD2');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930HiVoltTransm

extern void
TR930DASet(int DAS)
{
  timeout_value=400;
  dputc ('\xCF');
  dputc ('\x01');
  dputc ((unsigned char)DAS);
//  TR930DAByte = readbyte();
} // TR930DA0

extern void
TR930DA0(void)
{
  timeout_value=400;
  dputc ('\xC8');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930DA0

extern void
TR930DAFull(void)
{
  timeout_value=400;
  dputc ('\xC9');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930DAFull

extern void
TR930DAUp(void)
{
  timeout_value=400;
  dputc ('\xCA');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930DAUp

extern void
TR930DADown(void)
{
  timeout_value=400;
  dputc ('\xCB');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930DADown

extern void
TR930DAHalf(void)
{
  timeout_value=400;
  dputc ('\xCC');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930DAHalf

extern void
TR930Normal(void)
{
//  TR930DAByte = 255;
  timeout_value=60000;
  dputc ('\xC0');
  dputc ('\x00');
//  TR930DAByte = readbyte();
} // TR930Normal

extern void 
TR930XHome(void)
{
unsigned char	byte1;

  timeout_value=10000;
  dputc ('\x60');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930XHome

extern void 
TR930XRawHome(void)
{
unsigned char	byte1;

  timeout_value=10000;
  dputc ('\x66');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930XRawHome

extern void 
TR930YHome(void)
{
unsigned char	byte1;

  timeout_value=200000;
  dputc ('\x50');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930YHome

extern void 
TR930XStep (int XStep)
{
int		modXStep;
unsigned char	byte1;

  modXStep = ((1000*XStep)/1045+0.5);
  timeout_value=20000;
  dputc ('\x67');
  dputc ('\x01');
  dputc ((unsigned char)modXStep);
  byte1 = readbyte();
} // TR930XStep

extern void 
TR930YStep (int YStep)
{
unsigned char	byte1;

  timeout_value=200000;
  dputc ('\x57');
  dputc ('\x01');
  dputc ((unsigned char)YStep);
  byte1 = readbyte();
} // TR930YStep

extern void 
TR930XStepH (int XStep)
{
int		modXStep;
unsigned char	byte1;

  modXStep = ((1000*(XStep-2.829))/1045+0.5);
  timeout_value=20000;
  dputc ('\x68');
  dputc ('\x01');
  dputc ((unsigned char)modXStep);
  byte1 = readbyte();
} // TR930XStepH

extern void 
TR930YStepH (int YStep)
{
unsigned char	byte1;

  timeout_value=200000;
  dputc ('\x58');
  dputc ('\x01');
  dputc ((unsigned char)YStep);
  byte1 = readbyte();
} // TR930YStepH

extern void
TR930GotoWL(int WL, int FL) {
int StepWL;
int i;
unsigned char	byte1;

  timeout_value=10000; // FMHome
  dputc ('\x40');
  dputc ('\x00');
  byte1 = readbyte();

  timeout_value=30000; // WMHome
  dputc ('\x70');
  dputc ('\x00');
  byte1 = readbyte();

  StepWL=(760-WL)*5;
  for (i=0; i<StepWL; i++)
  {
	  timeout_value=500;
	  dputc ('\x71');
	  dputc ('\x00');
	  byte1 = readbyte();
	  //usleep(50);
  } // i

  timeout_value=500; // WLOff
  dputc ('\x74');
  dputc ('\x00');
  byte1 = readbyte();

  if (WL>600)
  {
	  timeout_value=2000; // Filter 1
	  dputc ('\x43');
	  dputc ('\x01');
	  dputc ('\x00');
	  byte1 = readbyte();
  } // Filter set if WL>600

  if (FL)
  {
	  timeout_value=2000; // Filter 2
	  dputc ('\x43');
	  dputc ('\x01');
	  dputc ('\x01');
	  byte1 = readbyte();
  } // Filter set if FL==TRUE

} // TR930GotoWL

// High level functions

extern int
TR930ADData(void)
{
int i;
int sum_ad;
unsigned char	byte1,
						byte2,
						byte3,
						byte4;

  timeout_value=500;
  sum_ad=0;
  for (i=0; i<16; i++)
  {
	  dputc ('\x33');
	  dputc ('\x00');
	  byte1 = readbyte();
	  byte2 = readbyte();
	  byte3 = readbyte();
	  byte4 = readbyte();
	  sum_ad=sum_ad+(byte2*65536+byte3*256+byte4);
  } // for i
  return sum_ad/16;
} // TR930ADData

extern void
TR930LowResMeasure (void) {
int MeasVal;
int i;
unsigned char byte1, byte2, byte3;
int *CDAMeas;

  dputc ('\xa0');
  dputc ('\x00');
  timeout_value=100000;
  byte1=readbyte();
  for (i=0; i< 1000; i++) {
	  if (i > 0) timeout_value=500;
	  byte2=readbyte();
	  byte3=readbyte();
	  MeasVal=(byte2*256+byte3);
	  CDAMeas = Chrom[0].ChromDataArrays[0];
	  CDAMeas[i] = MeasVal;
  } // i
  timeout_value=200000;
  dputc ('\x50');
  dputc ('\x00');
  byte1 = readbyte();
} // TR930LowResMeasure

extern void
TR930LowResAcquisiteOnly (void) {
int MeasVal;
int i;
unsigned char byte1, byte2, byte3;  
int *CDAMeas;

  dputc ('\xa2');
  dputc ('\x00');
  timeout_value=100000;
  byte1=readbyte();
  for (i=0; i< 1000; i++) {
	  if (i > 0) timeout_value=500;
	  byte2=readbyte();
	  byte3=readbyte();
	  MeasVal=(byte2*256+byte3);
	  CDAMeas = Chrom[0].ChromDataArrays[0];
	  CDAMeas[i] = MeasVal;
  } // i
} // TR930LowResAcquisiteOnly

extern void
TR930LowResNullStepButExcite (void) {
int MeasVal;
int i;
unsigned char byte1, byte2, byte3;  
int *CDAMeas;

  dputc ('\xa1');
  dputc ('\x00');
  timeout_value=100000;
  byte1=readbyte();
  for (i=0; i< 1000; i++) {
	  if (i > 0) timeout_value=500;
	  byte2=readbyte();
	  byte3=readbyte();
	  MeasVal=(byte2*256+byte3);
	  CDAMeas = Chrom[0].ChromDataArrays[0];
	  CDAMeas[i] = MeasVal;
  } // i
} // TR930LowResNullStepButExcite

extern void
TR930HiResMeasure (int MeasInMM) {
int MeasVal;
int i,j;
unsigned char byte1, byte2, byte3;  
int *CDAMeas;

  dputc ('\xa3');
  dputc ('\x01');
  dputc ((unsigned char)MeasInMM);
  timeout_value=100000;
  byte1=readbyte();
  for (i = 0; i < MeasInMM; i++) {
	  if (i > 0) timeout_value=500;
	  for (j = 0; j < 50; j++) {
		  byte2=readbyte();
		  byte3=readbyte();
		  MeasVal=(byte2*256+byte3);
		  CDAMeas = Chrom[0].ChromDataArrays[0];
		  CDAMeas[i*50+j] = MeasVal;
	  } // j
	  PRINTF ("i = %d mm of %d\n", i, MeasInMM);
  } // i
  PRINTF ("Waiting HiRes linear backstep...", 0);
  timeout_value=100000;
  byte1=readbyte();
  PRINTF ("done.\n", 0);
} // TR930HiResMeasure

extern void
TR930ZigZagMeasure (int MeasSteps, int TrackSteps, int YResolSteps) {
int i,j;
int MeasStep1;
int MeasStep2;
int MeasVal;
unsigned char byte1, byte2, byte3;  
int *CDAMeas;

  MeasStep2 = MeasSteps/256;
  MeasStep1 = MeasSteps-MeasStep2*256;
  PRINTF ("MeasSteps: %d,  MeasStep1: %d,  MeasStep2: %d\n",MeasSteps,MeasStep1,MeasStep2);
  PRINTF ("TrackSteps: %d,  YResolSteps: %d\n",TrackSteps,YResolSteps);

  dputc ('\xa4');
  dputc ('\x04');
  dputc ((unsigned char)MeasStep1);
  dputc ((unsigned char)MeasStep2);
  dputc ((unsigned char)TrackSteps);
  dputc ((unsigned char)YResolSteps);
  timeout_value=10000;
  byte1=readbyte();
  PRINTF ("Start zero: %d\n",byte1);

  timeout_value=1000;
  // A +1 8051 gépi kód bug miatt, 1-el több adat jön le!
  for (i = 0; i < MeasSteps+1; i++)  {
	  MeasVal = 0;
	  for (j = 0; j < TrackSteps; j++) {
		  byte2 = readbyte();
		  byte3 = readbyte();
		  MeasVal += (byte2*256+byte3);
	  } // for j
	  CDAMeas = Chrom[0].ChromDataArrays[0];
	  CDAMeas[i] = MeasVal / TrackSteps;
  } // for i
  printf ("\n");

  timeout_value=200000;
  byte1=readbyte();
  PRINTF ("Stop zero: %d\n",byte1);
} // TR930ZigZagMeasure

extern void
TR930GetSpectra (int UVVIS, int RefSample, int NormWL){
int i,j;
int iStart, iStop;
int MeasVal;
unsigned char	byte1,
						byte2,
						byte3;
// FILE *RawFile;

  TR930HiVoltRefl ();
  TR930GotoWL (NormWL, FALSE);

  if (RefSample == TR930SpectraSample) {
	if (UVVIS == TR930SpectraUV)
		TR930DASet (Spectra.UVRefHiVoltValue);
	else
		TR930DASet (Spectra.VISRefHiVoltValue);
  } else {
	TR930DAHalf ();
	TR930Normal ();
	  /*
	if (UVVIS == TR930SpectraUV)
		Spectra.UVRefHiVoltValue = TR930DAByte;
	else
		Spectra.VISRefHiVoltValue = TR930DAByte;
	  */
  } // if RefSample

	if (UVVIS == TR930SpectraUV)
	{
	timeout_value=60000;
	printf("Spectra Goto UV start.\n");
	dputc ('\x82');
	dputc ('\x00');
	byte1 = readbyte();
	printf("Spectra Goto UV done.\n");
	iStart = 72;
	iStop = 112;
	} else
	{
	printf("Spectra remain in VIS start.\n");
	TR930GotoWL(760, FALSE);
	iStart = 0;
	iStop = 72;
	printf("Spectra remain in VIS done.\n");
	} // if UVVIS

	for (i=0; i< 560; i++)
	{
	//TR930SpectraRawData[i] = 1;
	} // i

	for (i=iStart; i< iStop; i++)
	{
	if (i == 12) {
		timeout_value=10000;
		dputc ('\x40');
		dputc ('\x00');
		byte1 = readbyte();
		printf("FHome done.\n");
	} // if 700 nm

	timeout_value=2000;
	dputc ('\x81');
	dputc ('\x00');
	byte1 = readbyte();
	printf("Spectra get 5nm data CmdOK.\n");
	for (j=0; j<5; j++)
	{
		printf("i= %d   j= %d   idx= %d   ",i,j,i*5+j);
		byte2=readbyte();
		byte3=readbyte();
		MeasVal=(byte2*256+byte3);
		printf("Hbyte= %d  Lbyte= %d   Value= %d\n",byte2,byte3,MeasVal);
		//TR930SpectraRawData[i*5+j] = MeasVal;
		// fprintf(RawFile,"%d\n",TR930SpectraRawData[i*5+j]);
	} // j
	} // i

	TR930DA0 ();

	if (RefSample == TR930SpectraSample) {
		//Spectra.TR930SpectraSampleData[iStart]=TR930SpectraRawData[iStart];
		//Spectra.TR930SpectraSampleData[iStop*5 - 1]=TR930SpectraRawData[iStop*5 - 1];
	} else {
		//Spectra.TR930SpectraRefData[iStart]=TR930SpectraRawData[iStart];
		//Spectra.TR930SpectraRefData[iStop*5 - 1]=TR930SpectraRawData[iStop*5 - 1];
	}
	for (j=0; j<32; j++)
	{
		for (i = iStart*5 + 1; i < iStop*5 - 2; i++)
		{
		//if (RefSample == TR930SpectraSample) 
			//Spectra.TR930SpectraSampleData[i]=(TR930SpectraRawData[i-1]+2*TR930SpectraRawData[i]+TR930SpectraRawData[i+1])/4;
		//else
			//Spectra.TR930SpectraRefData[i]=(TR930SpectraRawData[i-1]+2*TR930SpectraRawData[i]+TR930SpectraRawData[i+1])/4;
		} // i
		for (i=1; i< 559; i++)
		{
		//if (RefSample == TR930SpectraSample) 
			//TR930SpectraRawData[i]=Spectra.TR930SpectraSampleData[i];
		//else
			//TR930SpectraRawData[i]=Spectra.TR930SpectraRefData[i];
		} // i
	} // j
} // TR930GetSpectra

extern
void	ConvertSh930RawData(int ChrN) {
int		i,j;
int		GetValue;
int		AccValue;
float	LocalMax, LocalMin;
char	ChrNum[10];
FILE	*RawFile;
/*
	strcpy(Filename,"track_");
	sprintf(ChrNum,"%d",ChrN);
	strcat(Filename,ChrNum);
	strcat(Filename,".raw");
	RawFile=fopen(Filename,"r");

	Sh930ZeroRaw10000Data ();
	for (i=0; i<WorkLayer.LayerMethod.SH930Parameters.SH930RawNmp; i++)
	{
	switch (WorkLayer.LayerMethod.SH930Parameters.SH930ScanGeometry) {
		case Sh930MeasScanGeomLin :
			fscanf (RawFile, "%d\n", &RawData[i]);
			break; // Sh930MeasScanGeomLin
		case Sh930MeasScanGeomZZ1 :
		case Sh930MeasScanGeomZZ2 :
			AccValue = 0;
			for (j=0; j<WorkLayer.LayerMethod.SH930Parameters.SH930ZigZagTrackSteps; j++)
			{
			fscanf (RawFile, "%d\n", &GetValue);
			AccValue += GetValue;
			} // for j
			RawData[i] = AccValue;
			break; // Sh930MeasScanGeomZZ1,2
	} // switch 
	} // for i
	fclose(RawFile);

	Sh930PreSmoothRaw10000Data(WorkLayer.LayerMethod.SH930Parameters.SH930RawNmp, WorkLayer.LayerMethod.SH930Parameters.SH930PreSmooth);

	NewChromHead(&ChromHead);
	ChromHead.Method = WorkLayer.LayerMethod;

//	ChromHead.Method.MeasureParameters.Nmp = ChromHead.Method.SH930Parameters.SH930DecimatedNmp;
	ChromHead.Method.MeasureParameters.Nmp = ChromHead.Method.SH930Parameters.SH930FullLengthNmp;
	ChromHead.Method.Instrument.InstrumentSamplingMode = InstrumentSamplingInSecMM;
	for (i = 0; i < 10000; i++) ChromArray[i] = 0;
	LocalMax = -1000000000.0;
	LocalMin = 1000000000.0;
	for (i=ChromHead.Method.SH930Parameters.SH930StartNmp; i<ChromHead.Method.SH930Parameters.SH930StartNmp+ChromHead.Method.SH930Parameters.SH930DecimatedNmp; i++)
	{
		for (j=0; j<ChromHead.Method.SH930Parameters.SH930Decimation; j++)
		{
		ChromArray[i] += RawData[(i-ChromHead.Method.SH930Parameters.SH930StartNmp)*ChromHead.Method.SH930Parameters.SH930Decimation + j];
		} // for j
	if ((i > ChromHead.Method.SH930Parameters.SH930StartNmp + 2) && (i < ChromHead.Method.SH930Parameters.SH930StartNmp+ChromHead.Method.SH930Parameters.SH930DecimatedNmp - 2)) {
		if (ChromArray[i]<LocalMin) LocalMin = ChromArray[i];
		if (ChromArray[i]>LocalMax) LocalMax = ChromArray[i];
		} // if i
	} // for i
	printf ("LocalMin = %.2f,  LocalMax = %.2f.\n", LocalMin, LocalMax);
	for (i = 0; i < 10000; i++) ChromArray[i] = LocalMax;
	for (i=ChromHead.Method.SH930Parameters.SH930StartNmp; i<ChromHead.Method.SH930Parameters.SH930StartNmp+ChromHead.Method.SH930Parameters.SH930DecimatedNmp; i++)
	{
		ChromArray[i] = 0;
		for (j=0; j<ChromHead.Method.SH930Parameters.SH930Decimation; j++)
		{
		ChromArray[i] += RawData[(i-ChromHead.Method.SH930Parameters.SH930StartNmp)*ChromHead.Method.SH930Parameters.SH930Decimation + j];
		} // for j
	} // for i

	SetChromParameters(&ChromHead.Parameter);
	for (i=0; i<ChromHead.Method.MeasureParameters.Nmp; i++)
	{
		ChromArray[i] = ChromHead.Parameter.ChrMax - ChromArray[i];
	} // for i
	Sh930PostSmoothRaw10000Data(ChromHead.Method.MeasureParameters.Nmp, WorkLayer.LayerMethod.SH930Parameters.SH930PostSmooth);

	SetChromParameters(&ChromHead.Parameter);
		ChromHead.FileIdentifier.FileID = ChrFlag;
		strcpy (ChromHead.FileIdentifier.LabChromID,LabChromID);
		strcpy (ChromHead.FileIdentifier.LabChromText,LabChromText);
		sscanf (VERSION,"%d.%d.%d",&ChromHead.FileIdentifier.MainVersion, &ChromHead.FileIdentifier.SubVersion, &ChromHead.FileIdentifier.ServiceVersion);
		*/
	} // ConvertSh930RawData
