// TR541a instrument specific functions

extern void
TR541MeasureExecFunction (void) {
static int InternalSwitch = 0;
int TmpInt;
static int LineCounter;
int i,j;
BT_INIT();


  switch (ThreadStatus[0]) {
	  case ThreadStatusTLCIdle:
		  usleep (100000);
		  break; // ThreadStatusTLCIdle
	  case ThreadStatusStart:
		  InternalSwitch = 0;
		  ThreadStatus[0] = ThreadStatusTLCPreset;
//		  bzero (&Chrom[0].TR541RawDataArray, 200*1000*sizeof(int));
//		  memset (&Chrom[0].TR541RawDataArray, '\xFF', 200*1000*sizeof(int));
		  for (i = 0; i < 200; i++)
			  for (j = 0; j < 1000; j++)
				  Chrom[0].TR541RawDataArray[i][j] = 0xFFFF;
		  Chrom[0].QueueHead.LQMethod.MeasureParameters.StartTime = time (NULL);
		  ThreadCommandOk = TRUE;
		  printf ("@@@ ThreadStatusStart\n");
		  break; // ThreadStatusStart
	  case ThreadStatusTLCPreset:
		  printf ("### InternalSwitch = %d\n", InternalSwitch);
		  switch (InternalSwitch) {
			  case 0 :
				  TR541CommandExec (TR540CommandReflectance, 0, 0);
				  InternalSwitch++;
				  break;
			  case 1 :
				  TR541CommandExec (TR540CommandXHome, 0, 0);
				  InternalSwitch++;
				  break;
			  case 2 :
				  TR541CommandExec (TR540CommandYHome, 0, 0);
				  InternalSwitch++;
				  break;
			  case 3 :
				  TmpInt = Chrom[0].QueueHead.LQMethod.MeasureParameters.NormX;
				  TR541CommandExec (TR540CommandXStep, TmpInt, 0);
				  InternalSwitch++;
				  break;
			  case 4 :
				  TmpInt = Chrom[0].QueueHead.LQMethod.MeasureParameters.NormY;
				  TR541CommandExec (TR540CommandYStep, TmpInt, 0);
				  InternalSwitch++;
				  break;
			  case 5 :
				  TR541CommandExec (TR540CommandMotorOff, 0, 0);
				  InternalSwitch++;
				  break;
			  case 6 :
				  TmpInt = Chrom[0].QueueHead.LQMethod.TR540Parameters.TR540SelectedFilter;
				  printf ("TR540SelectedFilter = %d\n", TmpInt);
				  TR541CommandExec (TR540CommandSetFilter, TmpInt, 0);
				  InternalSwitch++;
				  break;
			  case 7 :
				  TR541CommandExec (TR540CommandDAHalf, 0, 0);
				  InternalSwitch++;
				  break;
			  case 8 :
				  TR541CommandExec (TR540CommandDANormalize, 0, 0);
				  InternalSwitch++;
				  break;
			  case 9 :
				  TR541CommandExec (TR540CommandXHome, 0, 0);
				  InternalSwitch++;
				  break;
			  case 10 :
				  TR541CommandExec (TR540CommandYHome, 0, 0);
				  InternalSwitch++;
				  break;
			  case 11 :
				  TmpInt = Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStart;
				  TR541CommandExec (TR540CommandYStep, TmpInt, 0);
				  ThreadStatus[0] = ThreadStatusTLCViewScanPrepare;
				  break;
		  } // switch InternalSwitch
		  if (timeout_flag)
			  ThreadStatus[0] = ThreadStatusError;
		  break; // ThreadStatusTLCPreset
	  case ThreadStatusTLCViewScanPrepare:
		  LineCounter = 0;
		  Chrom[0].TR541RawDataArrayRows = 0;
		  ThreadStatus[0] = ThreadStatusTLCViewScan;
		  break; // ThreadStatusTLCViewScanPrepare
	  case ThreadStatusTLCViewScan:
		  if (Chrom[0].QueueHead.LQMethod.TR540Parameters.TR540HalfSizeScan)
			  TR541CommandExec (TR540CommandMeasureShortLine, \
				  Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStart +\
				  Chrom[0].TR541RawDataArrayRows - 1, 0);
		  else
			  TR541CommandExec (TR540CommandMeasureLine, \
				  Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStart +\
				  Chrom[0].TR541RawDataArrayRows - 1, 0);
		  TR541CommandExec (TR540CommandYStep, 1, 0);
		  LineCounter++;
		  Chrom[0].TR541RawDataArrayRows++;
		  TmpInt = Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStop - Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStart;
		  MeasureLayerDrawingAreaNeedRedraw = TRUE;
		  //printf ("ViewScanYStop = %d   ViewScanYStart = %d  TmpInt = %d   LineCounter = %d\n", Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStop, Chrom[0].QueueHead.LQMethod.MeasureParameters.ViewScanYStart, TmpInt, LineCounter);
		  if ((LineCounter == TmpInt) || (TmpInt < 1))
			  ThreadStatus[0] = ThreadStatusTLCViewScanDone;
		  if (timeout_flag)
			  ThreadStatus[0] = ThreadStatusTLCViewScanDone;
		  break; // ThreadStatusTLCViewScan
	  case ThreadStatusTLCViewScanDone:
		  TR541CommandExec (TR540CommandXHome, 0, 0);
		  TR541CommandExec (TR540CommandYHome, 0, 0);
		  TR541CommandExec (TR540CommandMotorOff, 0, 0);
		  TR541CommandExec (TR540CommandDAZero, 0, 0);
		  Chrom[0].QueueHead.LQMethod.MeasureParameters.StopTime = time (NULL);
		  ThreadStatus[0] = ThreadStatusWait;
		  //
		  // Menteni!!!
		  //
			  gdk_threads_enter ();
			  gtk_object_set_data (GTK_OBJECT (MeasureWindows[0]), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusViewScanReady));
			  ActivateMeasureWidgets (0);
			  gdk_flush ();
			  gdk_threads_leave ();
		  break; // ThreadStatusTLCViewScanDone
	  case ThreadStatusWait :
		  usleep (100000);
		  InternalSwitch = 0;
		  break; // ThreadStatusWait
	  case ThreadStatusTLCRun:
		  break; // ThreadStatusTLCRun
	  case ThreadStatusTLCDone:
		  TR541CommandExec (TR540CommandMotorOff, 0, 0);
		  TR541CommandExec (TR540CommandDAZero, 0, 0);
		  ThreadStatus[0] = ThreadStatusTLCIdle;
		  break; // ThreadStatusTLCDone
	  case ThreadStatusFinish :
		  ThreadStatus[0] = ThreadStatusTLCDone;
		  ThreadBreakFlag[0] = FALSE;
		  ThreadStopFlag[0] = FALSE;
		  ThreadCommandOk = TRUE;
			  gdk_threads_enter ();
			  ActivateWidget (MeasureWindow, "MeasureFinishButton", FALSE);
			  ActivateWidget (MeasureWindow, "MeasureBreakButton", FALSE);
			  ActivateWidget (MeasureWindow, "MeasureStartButton", TRUE);
			  gdk_flush ();
			  gdk_threads_leave ();
		  break; // ThreadStatusFinish
	  case ThreadStatusUserBreak :
		  ThreadStatus[0] = ThreadStatusTLCDone;
		  ThreadBreakFlag[0] = FALSE;
		  ThreadStopFlag[0] = FALSE;
		  ThreadCommandOk = TRUE;
			  gdk_threads_enter ();
			  ActivateWidget (MeasureWindow, "MeasureFinishButton", FALSE);
			  ActivateWidget (MeasureWindow, "MeasureBreakButton", FALSE);
			  ActivateWidget (MeasureWindow, "MeasureStartButton", TRUE);
			  gdk_flush ();
			  gdk_threads_leave ();
		  break; // ThreadStatusUserBreak
	  case ThreadStatusError :
		  ThreadStatus[0] = ThreadStatusTLCDone;
			  gdk_threads_enter ();
			  ActivateWidget (MeasureWindow, "MeasureErrorButton", TRUE);
			  gdk_flush ();
			  gdk_threads_leave ();
		  break; // ThreadStatusError
  } // switch 

} // TR541MeasureExecFunction

extern void
TR541CommandExec (int CommandCode, int CommandParameter1, int CommandParameter2) {
unsigned char	byte0,
				byte1,
				byte2,
				byte3,
				byte4,
				byte5,
				byte6;
int i, TmpInt;

  pthread_mutex_lock (&measure_command_mutex);

  byte1 = CommandParameter1;
  switch (CommandCode) {
	  case TR540CommandReflectance :
		  printf ("TR540CommandReflectance\n");
		  dputc ('\x31');
		  dputc ('\x00');
		  byte0 = readbyte();
		  break;
	  case TR540CommandTransmittance :
		  printf ("TR540CommandTransmittance\n");
		  dputc ('\x34');
		  dputc ('\x00');
		  byte0 = readbyte();
		  break;
	  case TR540CommandSetFilter :
		  printf ("TR540CommandSetFilter\n");
		  timeout_value = 10000;
		  dputc ('\x43');
		  dputc ('\x01');
		  dputc (byte1); // Filter #
		  byte0 = readbyte();
		  break;
	  case TR540CommandXHome :
		  printf ("TR540CommandXHome\n");
		  timeout_value = 15000;
		  dputc ('\x60');
		  dputc ('\x00');
		  byte0 = readbyte();
		  break;
	  case TR540CommandXStep :
		  printf ("TR540CommandXStep\n");
		  for (i = 0; i < CommandParameter1; i++) {
			  timeout_value = 2000;
			  dputc ('\x62');
			  dputc ('\x01');
			  dputc ('\x05'); // 5x0.2mm
			  byte0 = readbyte();
		  } // i
		  break;
	  case TR540CommandYHome :
		  printf ("TR540CommandYHome\n");
		  timeout_value = 15000;
		  dputc ('\x50');
		  dputc ('\x00');
		  byte0 = readbyte();
		  break;
	  case TR540CommandYStep :
		  printf ("TR540CommandYStep %d [mm]\n", CommandParameter1);
		  for (i = 0; i < CommandParameter1; i++) {
			  timeout_value = 2000;
			  dputc ('\x52');
			  dputc ('\x01');
			  dputc ('\x05'); // 5x0.2mm
			  byte0 = readbyte();
		  } // i
		  break;
	  case TR540CommandMotorOff :
		  printf ("TR540CommandMotorOff\n");
		  dputc ('\x65');
		  dputc ('\x00');
		  byte0 = readbyte();
		  break;
	  case TR540CommandDAZero :
		  printf ("TR540CommandDAZero\n");
		  dputc ('\xC8');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDAHalf :
		  printf ("TR540CommandDAHalf\n");
		  dputc ('\xCC');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDAFull :
		  printf ("TR540CommandDAFull\n");
		  dputc ('\xC9');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDAUp :
		  printf ("TR540CommandDAUp\n");
		  dputc ('\xCA');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDADown :
		  printf ("TR540CommandDADown\n");
		  dputc ('\xCB');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDANormalize :
		  timeout_value = 60000;
		  printf ("TR540CommandDANormalize\n");
		  dputc ('\xC0');
		  dputc ('\x00');
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandDASet :
		  printf ("TR540CommandDASet: %d\n", CommandParameter1);
		  dputc ('\xCF');
		  dputc ('\x01');
		  byte1 = CommandParameter1;
		  dputc (byte1);
		  byte0 = readbyte();
		  Chrom[0].TR541DAValue = byte0;
		  printf ("### Normalization value = %d\n", Chrom[0].TR541DAValue);
		  break;
	  case TR540CommandMeasureLine :
		  printf ("TR540CommandMeasureLine\n");
		  dputc ('\xA0');
		  dputc ('\x00');
		  timeout_value = 20000;
		  byte0 = readbyte();
		  if (timeout_flag)
			  printf ("### MeasureLine error at byte0\n");
		  timeout_value = 500;
		  for (i = 0; i < 1000; i++) {
			  if (!timeout_flag) {
				  byte1 = readbyte ();
				  if (timeout_flag)
					  printf ("### MeasureLine error at %d byte1\n", i);
			  }
			  if (!timeout_flag) {
				  byte2 = readbyte ();
				  if (timeout_flag)
					  printf ("### MeasureLine error at %d byte2\n", i);
			  }
			  if (!timeout_flag)
				  Chrom[0].TR541RawDataArray[CommandParameter1][i] = 256*byte1 + byte2;
		  } // i
		  for (i = 0; i < 998; i++) {
			  Chrom[0].TR541RawDataArray[CommandParameter1][i] = (\
					  Chrom[0].TR541RawDataArray[CommandParameter1][i] +\
					  2 * Chrom[0].TR541RawDataArray[CommandParameter1][i + 1] + \
					  Chrom[0].TR541RawDataArray[CommandParameter1][i + 2] \
			  ) / 4;
		  } // i - Smooth 50Hz
		  break;
	  case TR540CommandMeasureShortLine :
		  printf ("TR540CommandMeasureShortLine\n");
		  dputc ('\xA1');
		  dputc ('\x00');
		  timeout_value = 20000;
		  byte0 = readbyte();
		  if (timeout_flag)
			  printf ("### MeasureShortLine error at byte0\n");
		  timeout_value = 500;
		  for (i = 0; i < 500; i++) {
			  if (!timeout_flag) {
				  byte1 = readbyte ();
				  if (timeout_flag)
					  printf ("### MeasureShortLine error at %d byte1\n", i);
			  }
			  if (!timeout_flag) {
				  byte2 = readbyte ();
				  if (timeout_flag)
					  printf ("### MeasureShortLine error at %d byte2\n", i);
			  }
			  if (!timeout_flag)
				  Chrom[0].TR541RawDataArray[CommandParameter1][i] = 256*byte1 + byte2;
		  } // i
		  for (i = 0; i < 498; i++) {
			  Chrom[0].TR541RawDataArray[CommandParameter1][i] = (\
					  Chrom[0].TR541RawDataArray[CommandParameter1][i] +\
					  2 * Chrom[0].TR541RawDataArray[CommandParameter1][i + 1] + \
					  Chrom[0].TR541RawDataArray[CommandParameter1][i + 2] \
			  ) / 4;
		  } // i - Smooth 50Hz
		  break;
	  case TR540CommandADValue :
		  timeout_value = 1000;
		  printf ("TR540CommandADValue ");
		  dputc ('\xE1');
		  dputc ('\x00');
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  if (byte6 < 59) byte6 -= 48; else byte6 -= 55;
		  byte0 = byte6;
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  if (byte6 < 59) byte6 -= 48; else byte6 -= 55;
		  byte1 = byte6;
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  if (byte6 < 59) byte6 -= 48; else byte6 -= 55;
		  byte2 = byte6;
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  if (byte6 < 59) byte6 -= 48; else byte6 -= 55;
		  byte3 = byte6;
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  byte4 = byte6;
		  byte6 = readbyte ();
		  printf ("%c", byte6);
		  byte5 = byte6;
		  Chrom[0].TR541ADValue = 4096*byte0 + 256*byte1 + 16*byte2 + byte3;
		  printf ("ADValue %d\n", Chrom[0].TR541ADValue);
		  break;
	 case TR540CommandDirectPortSET :
	 	  break;
	 case TR540CommandDirectPortGET :
	 	  break;
	 case TR540CommandDirectPortBitSET :
		  dputc ('\xDD');
		  dputc ('\x01');
		  dputc (byte1);
		  byte2 = readbyte ();
	 	  break;
	 case TR540CommandDirectPortBitGET :
	 	  Chrom[0].TR541ByteValue = 0;
		  dputc ('\xDF');
		  dputc ('\x01');
		  dputc (byte1);
		  byte2 = readbyte ();
		  Chrom[0].TR541ByteValue = byte2;
	 	  break;
	 case TR540CommandDirectPortBitCLR :
		  dputc ('\xDE');
		  dputc ('\x01');
		  dputc (byte1);
		  byte2 = readbyte ();
	 	  break;
	 case TR540CommandDirectLatchSET :
		  dputc ('\xD9');
		  dputc ('\x02');
		  byte1 = CommandParameter1;
		  dputc (byte1);
		  byte1 = CommandParameter2;
		  dputc (byte1);
		  byte2 = readbyte ();
	 	  break;
	 case TR540CommandDirectLatchGET :
		  dputc ('\xDA');
		  dputc ('\x01');
		  byte1 = CommandParameter1;
		  dputc (byte1);
		  byte2 = readbyte ();
		  Chrom[0].TR541ByteValue = byte2;
	 	  break;
//	 case  :
//	 	  break;
  } // switch CommandCode

  pthread_mutex_unlock (&measure_command_mutex);
  if ((timeout_flag) && (!ThreadMeasureError)) {
	  ThreadMeasureError = TRUE;
  } // if timeout_flag
} // TR541CommandExec

extern void
TR541MeasureExec (int DataSource) {
int i, j, k;
int jStart;
int kStart, kNum;
int *DataArray;

  memcpy (&Chrom[DataSource].ChromHead->Method, &Chrom[DataSource].QueueHead.LQMethod, sizeof(struct MethodStruct));
  Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp = 5 * \
	  (Chrom[DataSource].ChromHead->Method.MeasureParameters.ScanStopX -\
	  Chrom[DataSource].ChromHead->Method.MeasureParameters.ScanStartX + 1);
  Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors = 1;
  Chrom[DataSource].ActualDetector = 0;
  DataArray = Chrom[DataSource].ChromDataArrays[Chrom[DataSource].ActualDetector];
  jStart = 5 * (Chrom[DataSource].ChromHead->Method.MeasureParameters.ScanStartX - 1);
  printf ("jStart = %d,   Nmp = %d\n", jStart, Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp);
  for (i = 0; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
	  printf ("TR541MeasureExec i = %d\n", i);
	  kNum = Chrom[DataSource].ChromHead->Method.TR540Parameters.TR540TrackWidth;
	  if (kNum < 0) kNum = 1;
	  kStart = Chrom[DataSource].QueueItemArray[i].TrackPosition - 1 - kNum/2;
	  if (kStart < 0) kStart = 0;
	  for (j = 0; j < 1000; j++)
		  DataArray[j] = 0;
	  for (j = 0; j < Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp; j++) {
		  for (k = 0; k < kNum; k++) {
			  DataArray[j] += Chrom[DataSource].TR541RawDataArray[k + kStart][j + jStart];
		  } // k
	  } // j
	  for (j = 0; j < 1000; j++)
		  DataArray[j] /= kNum;
	  for (j = 0; j < 1000; j++)
		  DataArray[j] = 65536 - DataArray[j];
	  SetChromParameters (DataSource);
	  ReintegrateDBI (DataSource);
	  /*
	  strcpy (Chrom[DataSource].Filename, Options[DataSource].MeasureDataDir);
	  strcat (Chrom[DataSource].Filename, Chrom[DataSource].QueueItemArray[i].BaseFileName);
	  strcat (Chrom[DataSource].Filename, ".");
	  strcat (Chrom[DataSource].Filename, Chrom[DataSource].QueueItemArray[i].BaseExtName);
	  strcat (Chrom[DataSource].Filename, ".chr");
	  printf ("Chrom[DataSource].Filename = %s\n", Chrom[DataSource].Filename);
	  strcpy (Chrom[DataSource].QueueItemArray[i].FinalFilename, Chrom[DataSource].Filename);
	  */
  
	  Chrom[DataSource].FileLoaded[ChrFlag] = TRUE;
	  AssembleMeasureFilename(&DataSource);
	  strcpy (Chrom[DataSource].Filename, Chrom[DataSource].QueueItemArray[i].FinalFilename);
	  printf ("Chrom[DataSource].Filename = %s\n", Chrom[DataSource].Filename);
	  ChromSave (DataSource);
	  Chrom[DataSource].QueueItemArray[i].QueueItemMeasured = TRUE;
	  Chrom[DataSource].QueueItemArray[i].QueueItemLocked = TRUE;
	  Chrom[DataSource].QueueHead.QueueItemClosed++;
	  Chrom[DataSource].QueueHead.QueueItemLocked++;
  } // i
  strcpy (Chrom[DataSource].Filename, Options[DataSource].MeasureDataDir);
  strcat (Chrom[DataSource].Filename, "Raw/");
  strcat (Chrom[DataSource].Filename, Chrom[DataSource].QueueHead.BaseName);
  strcat (Chrom[DataSource].Filename, ".Raw");
  TR541RawDataSave (DataSource);
  
  Chrom[DataSource].QueueHead.RawType = RawTypeTR541;
  Chrom[DataSource].QueueHead.RawSize = 200*1000*sizeof(int);
  QueueSave (DataSource);
  gtk_object_set_data (GTK_OBJECT (MeasureWindows[DataSource]), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusReady));
  ActivateMeasureWidgets (DataSource);
} // TR541MeasureExec


/*
 Case DeviceId Of
      0:;
      ADDataButton:Begin
       ClearFrame(ADDataFrame);
       OpenFrame(ADDataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        Counter:=0;
        V24Send(RS232Port,$E1);
        V24Send(RS232Port,$00);
        Repeat
         V24Read(RS232Port,V24ReadValue);
         OutTextXY(GrCol,GrRow-4,Chr(V24ReadValue));
         Inc(GrCol,10);
         Inc(Counter);
        Until Counter=6;
       CloseFrame(ADDataFrame);
      End; { ADData }
      MotorOffButton:Begin
       V24Send(RS232Port,$65);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { MotorOff }
      MotorGoToButton:Begin
       GraphCursor(SandGlass);
       GotoXY540(XCoord,YCoord);
(*
       V24Send(RS232Port,$50); { Y Home }
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,15);
       V24Read(RS232Port,V24ReadValue);
       V24Send(RS232Port,$60); { X home }
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,15);
       V24Read(RS232Port,V24ReadValue);
       For i:=1 To YCoord Do
           Begin
            V24Send(RS232Port,$52); { Y Step n }
            V24Send(RS232Port,$01);
            V24Send(RS232Port,$05);
            WaitV24(RS232Port,5);
            V24Read(RS232Port,V24ReadValue);
           End; { i -> Y }
       For i:=1 To XCoord Do
           Begin
            V24Send(RS232Port,$62); { X Step n }
            V24Send(RS232Port,$01);
            V24Send(RS232Port,$05);
            WaitV24(RS232Port,5);
            V24Read(RS232Port,V24ReadValue);
           End; { i -> X }
       V24Send(RS232Port,$65); { Off }
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
*)
       GraphCursor(Arrow);
      End; { MotorGoToButton }
      ModeReflectButton:Begin
       GraphCursor(SandGlass);
       V24Send(RS232Port,$31);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       GraphCursor(Arrow);
      End; { Reflectance }
      ModeTransmButton:Begin
       GraphCursor(SandGlass);
       V24Send(RS232Port,$34);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       GraphCursor(Arrow);
      End; { Transm }
      GenericCard:GenericProc;
      SetFilterButton:Begin
       GraphCursor(SandGlass);
       V24Send(RS232Port,$43);
       V24Send(RS232Port,$01);
       V24Send(RS232Port,Filter);
       WaitV24(RS232Port,10);
       V24Read(RS232Port,V24ReadValue);
       GraphCursor(Arrow);
      End; { SetFilter }
      XYCard:XYProc;
      YMotorHomeButton:Begin
       V24Send(RS232Port,$50);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,15);
       V24Read(RS232Port,V24ReadValue);
      End; { YMotorHome }
      YMotorStepButton:Begin
       V24Send(RS232Port,$51);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { YMotorStep }
      YMotorBackButton:Begin
       V24Send(RS232Port,$53);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { YMotorBack }
      XMotorHomeButton:Begin
       V24Send(RS232Port,$60);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,15);
       V24Read(RS232Port,V24ReadValue);
      End; { XMotorHome }
      XMotorStepButton:Begin
       V24Send(RS232Port,$61);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { XMotorStep }
      XMotorBackButton:Begin
       V24Send(RS232Port,$63);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { XMotorBack }
      XMotorOffButton:Begin
       V24Send(RS232Port,$65);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
      End; { XMotorOff }
      NormalCard:NormalProc;
      DAZeroButton:Begin
       V24Send(RS232Port,$C8);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DAZero }
      DAFillButton:Begin
       V24Send(RS232Port,$C9);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DAFill }
      DAUpButton:Begin
       V24Send(RS232Port,$CA);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DAUp }
      DADnButton:Begin
       V24Send(RS232Port,$CB);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DADn }
      DAHalfButton:Begin
       V24Send(RS232Port,$CC);
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DAHalf }
      DANormButton:Begin
       GraphCursor(SandGlass);
       V24Send(RS232Port,$C0);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,45);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,FrameVSize Div 2 - 2,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
       GraphCursor(Arrow);
      End; { DANorm }
      DANormUpButton:Begin
       V24Send(RS232Port,$C1);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,45);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DANormUp }
      DANormDnButton:Begin
       V24Send(RS232Port,$C2);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,45);
       V24Read(RS232Port,V24ReadValue);
       ClearFrame(DADataFrame);
       OpenFrame(DADataFrame);
        SetColor(WindTextColor);
        GrLineInit;
        MaskFormat('###');
        OutTextXY(GrCol-4,GrRow-4,IntToStr(V24ReadValue));
       CloseFrame(DADataFrame);
      End; { DANormDn }
      MeasureCard:MeasureProc;
      MeasureButton:Begin
       GraphCursor(SandGlass);
       MeasCounter:=0;
       MeasIndex:=0;
       ClearAKey;
       ErrFlag:=False;
       ErrIdx:=0;
       FillChar(MeasHByte,SizeOf(MeasHByte),#0);
       FillChar(MeasHByte,SizeOf(MeasLByte),#0);
       FlushV24(RS232Port);
       V24Send(RS232Port,$A0);
       V24Send(RS232Port,$00);
       WaitV24(RS232Port,10);
       V24Read(RS232Port,V24ReadValue);
{       WaitV24(RS232Port,10);}
       Repeat
        If MeasIndex<1000 Then
           Inc(MeasIndex);
        Inc(MeasCounter);
        If Not ErrFlag Then
           ErrIdx:=MeasIndex;
        V24Read(RS232Port,MeasHByte[MeasIndex]);
        If Not ErrFlag Then
           ErrCode:=V24Status;
        ErrFlag:=ErrFlag Or ((V24Status And V24Errors)>0);
        V24Read(RS232Port,MeasLByte[MeasIndex]);
        If Not ErrFlag Then
           ErrCode:=V24Status;
        ErrFlag:=ErrFlag Or ((V24Status And V24Errors)>0);
{        ScanAKey;}
       Until (MeasCounter=1000) Or
             (CharKey=#27) Or ErrFlag;
       V24Send(RS232Port,$65);        { Off }
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearAKey;
       ClearFrame(MeasureFrame);
       OpenFrame(MeasureFrame);
        GrLineInit;
        SetColor(WindTextColor);
        MaskFormat('#');
        OutTextXY(10,24,IntToStr(MeasCounter));
        SetColor(HighLightColor);
        If ErrFlag Then
           Begin
            OutTextXY(10,38,IntToStr(ErrIdx));
            OutTextXY(10,52,IntToStr(ErrCode));
            SetTextjustify(CenterText,CenterText);
            OutTextXY(FrameHSize Div 2,FrameVSize Div 2,
                     'Please, repeat the scan after 10 seconds!');
            Delay(10000);
           End; { ErrFlag }
        SetColor(WindTextColor);
        MeasMin:=$FFFF;
        MeasMax:=0;
        For i:=1 To 1000 Do
            Begin
             ByteRec(MeasW[i]).BLr:=MeasLByte[i];
             ByteRec(MeasW[i]).BHr:=MeasHByte[i];
             If MeasW[i]<MeasMin Then
                MeasMin:=MeasW[i];
             If MeasW[i]>MeasMax Then
                MeasMax:=MeasW[i];
            End; { i }
        SetColor(WindTextColor);
        MouseCursor(OffM);
        For i:=1 To 999 Do
            Begin
             If MeasW[i]<>MeasMin Then
                Line(Trunc(10+(FrameHSize-20)/1000*i),
                     Trunc(10+(FrameVSize-20)/(MeasMax-MeasMin)*
                                              (MeasW[i]-MeasMin)),
                     Trunc(10+(FrameHSize-20)/1000*(i+1)),
                     Trunc(10+(FrameVSize-20)/(MeasMax-MeasMin)*
                                              (MeasW[i+1]-MeasMin)));
            End; { i }
       MouseCursor(OnM);
       SetColor(HighLightColor);
       GrLineInit;
       MaskFormat('#');
       OutTextXY(10,10,IntToStr(MeasMin));
       OutTextXY(10,FrameVSize-10,IntToStr(MeasMax));
       CloseFrame(MeasureFrame);
       MeasureIndex:=1;
       MeasureDataShow;
       GraphCursor(Arrow);
      End; { MeasureButton }
      MeasureViewButton:Begin
       Dens540ComPort:=RS232Port;
       Dens540ErrorFlag:=False;
       ViewScan540;
       V24Send(RS232Port,$65);        { Off }
       V24Send(RS232Port,$00);
       V24Read(RS232Port,V24ReadValue);
       ClearAKey;

       ClearFrame(MeasureViewFrame);
       OpenFrame(MeasureViewFrame);
        GrLineInit;
        MaskFormat('#');
        SetColor(HighLightColor);
        If Dens540ErrorFlag Then
           OutTextXY(10,38,IntToStr(Dens540ErrorIndex));
        If Dens540ErrorFlag Then
           OutTextXY(10,52,IntToStr(Dens540ErrorCode));
        SetColor(WindTextColor);
        If Dens540MinData<>Dens540MaxData Then
           For i:=1 To 99 Do
               Begin
                If Dens540ViewData^[i]<>Dens540MinData Then
                   Line(Trunc(10+(FrameHSize-20)/100*i),
                        Trunc(10+(FrameVSize-20)/(Dens540MaxData-Dens540MinData)*
                                                 (Dens540ViewData^[i]-Dens540MinData)),
                        Trunc(10+(FrameHSize-20)/100*(i+1)),
                        Trunc(10+(FrameVSize-20)/(Dens540MaxData-Dens540MinData)*
                                                 (Dens540ViewData^[i+1]-Dens540MinData)));
               End; { i }
       SetColor(HighLightColor);
       GrLineInit;
       MaskFormat('#');
       OutTextXY(10,10,IntToStr(Dens540MinData));
       OutTextXY(10,FrameVSize-10,IntToStr(Dens540MaxData));
       CloseFrame(MeasureViewFrame);
      End; { MeasureViewButton }
      RS232InitButton:Begin
       GetDeviceData(RS232Com1RadBut,0);
       If DeviceChecked
          Then RS232Port:=Com1
          Else RS232Port:=Com2;
       V24Init(RS232Port,Baud9600+Word8Bit+StopBit2+ParityNone);
      End; { RS232InitButton }
      End; { Case DeviceId Of }

Procedure Flush540;
Begin
 Repeat
  V24Read(Dens540ComPort,V24ReadValue);
 Until (V24Status And TimeOut)>0;
End; { Flush540 }

Procedure SetFilter540(FilterNum : Byte);
Begin
 If Dens540ErrorFlag Then Exit;
 V24Send(Dens540ComPort,$43);
 V24Send(Dens540ComPort,$01);
 V24Send(Dens540ComPort,FilterNum);
 WaitV24(Dens540ComPort,10);
 V24Read(Dens540ComPort,V24ReadValue);
 Dens540ErrorFlag:=(V24Status And V24Errors)>0;
 Dens540ErrorCode:=V24Status;
 Dens540FuncExec:=Dens540FilterExec;
End; { SetFilter540 }

Procedure MeasureExec540;
Type  MeasByte             = Array[1..1000] Of Byte;
      MeasByteDin          = ^MeasByte;
Var   MeasCounter          : Integer;
      MeasIndex            : Integer;
      MeasHByte            : MeasByteDin;
      MeasLByte            : MeasByteDin;
      i                    : Integer;
Begin
 If Dens540ErrorFlag Then Exit;
 New(MeasHByte);
 New(MeasLByte);

 MeasCounter:=0;
 MeasIndex:=0;
 Dens540ErrorFlag:=False;
 Dens540ErrorCode:=0;
 ClearAKey;
 FillChar(MeasHByte^,SizeOf(MeasByte),#0);
 FillChar(MeasLByte^,SizeOf(MeasByte),#0);
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$A0);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,10);
 V24Read(Dens540ComPort,V24ReadValue);
 Repeat
  If MeasIndex<1000 Then
     Inc(MeasIndex);
  Inc(MeasCounter);
  If Not Dens540ErrorFlag Then
     Dens540ErrorIndex:=MeasIndex;
  V24Read(Dens540ComPort,MeasHByte^[MeasIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  V24Read(Dens540ComPort,MeasLByte^[MeasIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  If Not Dens540ErrorFlag Then
     Begin
      ScanAKey;
      Dens540ErrorFlag:=(CharKey=ESCKey);
      Dens540ErrorCode:=$FF;
     End; { Not Dens540ErrorFlag }
 Until (MeasCounter=1000) Or Dens540ErrorFlag;
 ClearAKey;

 Dens540MinData:=$7FFFFFFF;
 Dens540MaxData:=0;
 For i:=1 To 1000 Do
     Begin
      LongRec(Dens540RawData^[i]).LDr:=0;
      LongRec(Dens540RawData^[i]).LHr:=0;
      LongRec(Dens540RawData^[i]).LMr:=MeasHByte^[i];
      LongRec(Dens540RawData^[i]).LLr:=MeasLByte^[i];
      If Dens540RawData^[i]<Dens540MinData Then
         Dens540MinData:=Dens540RawData^[i];
      If Dens540RawData^[i]>Dens540MaxData Then
         Dens540MaxData:=Dens540RawData^[i];
     End; { i }

 Dispose(MeasLByte);
 Dispose(MeasHByte);
 Dens540FuncExec:=Dens540MeasExec;
End; { MeasureExec540 }

Procedure ShortMeasure540;
Type  MeasByte             = Array[1..1000] Of Byte;
      MeasByteDin          = ^MeasByte;
Var   MeasCounter          : Integer;
      MeasIndex            : Integer;
      MeasHByte            : MeasByteDin;
      MeasLByte            : MeasByteDin;
      i                    : Integer;
Begin
 If Dens540ErrorFlag Then Exit;
 New(MeasHByte);
 New(MeasLByte);

 MeasCounter:=0;
 MeasIndex:=0;
 Dens540ErrorFlag:=False;
 Dens540ErrorCode:=0;
 ClearAKey;
 FillChar(MeasHByte^,SizeOf(MeasByte),#0);
 FillChar(MeasLByte^,SizeOf(MeasByte),#0);
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$A1);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,10);
 V24Read(Dens540ComPort,V24ReadValue);
 Repeat
  If MeasIndex<500 Then
     Inc(MeasIndex);
  Inc(MeasCounter);
  If Not Dens540ErrorFlag Then
     Dens540ErrorIndex:=MeasIndex;
  V24Read(Dens540ComPort,MeasHByte^[MeasIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  V24Read(Dens540ComPort,MeasLByte^[MeasIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  If Not Dens540ErrorFlag Then
     Begin
      ScanAKey;
      Dens540ErrorFlag:=(CharKey=ESCKey);
      Dens540ErrorCode:=$FF;
     End; { Not Dens540ErrorFlag }
 Until (MeasCounter=500) Or Dens540ErrorFlag;
 ClearAKey;

 Dens540MinData:=$7FFFFFFF;
 Dens540MaxData:=0;
 For i:=1 To 500 Do
     Begin
      LongRec(Dens540RawData^[i]).LDr:=0;
      LongRec(Dens540RawData^[i]).LHr:=0;
      LongRec(Dens540RawData^[i]).LMr:=MeasHByte^[i];
      LongRec(Dens540RawData^[i]).LLr:=MeasLByte^[i];
      If Dens540RawData^[i]<Dens540MinData Then
         Dens540MinData:=Dens540RawData^[i];
      If Dens540RawData^[i]>Dens540MaxData Then
         Dens540MaxData:=Dens540RawData^[i];
     End; { i }

 For i:=501 To 1000 Do
     Begin
      LongRec(Dens540RawData^[i]).LDr:=0;
      LongRec(Dens540RawData^[i]).LHr:=0;
      LongRec(Dens540RawData^[i]).LMr:=0;
      LongRec(Dens540RawData^[i]).LLr:=0;
     End; { i }

 Dispose(MeasLByte);
 Dispose(MeasHByte);
 Dens540FuncExec:=Dens540MeasExec;
End; { ShortMeasure540 }

Procedure ViewScan540;
Type  ViewByte             = Array[1..100] Of Byte;
      ViewByteDin          = ^ViewByte;
Var   ViewCounter          : Integer;
      ViewIndex            : Integer;
      ViewHByte            : ViewByteDin;
      ViewLByte            : ViewByteDin;
      i                    : Integer;
Begin
 If Dens540ErrorFlag Then Exit;
 New(ViewHByte);
 New(ViewLByte);

 ViewCounter:=0;
 ViewIndex:=0;
 Dens540ErrorFlag:=False;
 Dens540ErrorCode:=0;
 ClearAKey;
 FillChar(ViewHByte^,SizeOf(ViewByte),#0);
 FillChar(ViewHByte^,SizeOf(ViewByte),#0);
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$B0);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,10);
 V24Read(Dens540ComPort,V24ReadValue);
 Repeat
  If ViewIndex<100 Then
     Inc(ViewIndex);
  Inc(ViewCounter);
  If Not Dens540ErrorFlag Then
     Dens540ErrorIndex:=ViewIndex;
  V24Read(Dens540ComPort,ViewHByte^[ViewIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  V24Read(Dens540ComPort,ViewLByte^[ViewIndex]);
  If Not Dens540ErrorFlag Then
     Dens540ErrorCode:=V24Status;
  Dens540ErrorFlag:=Dens540ErrorFlag Or ((V24Status And V24Errors)>0);
  If Not Dens540ErrorFlag Then
     Begin
      ScanAKey;
      Dens540ErrorFlag:=(CharKey=ESCKey);
      Dens540ErrorCode:=$FF;
     End; { Not Dens540ErrorFlag }
 Until (ViewCounter=100) Or Dens540ErrorFlag;
 ClearAKey;

 Dens540MinData:=$7FFFFFFF;
 Dens540MaxData:=0;
 For i:=1 To 100 Do
     Begin
      LongRec(Dens540ViewData^[i]).LDr:=0;
      LongRec(Dens540ViewData^[i]).LHr:=0;
      LongRec(Dens540ViewData^[i]).LMr:=ViewHByte^[i];
      LongRec(Dens540ViewData^[i]).LLr:=ViewLByte^[i];
      If Dens540ViewData^[i]<Dens540MinData Then
         Dens540MinData:=Dens540ViewData^[i];
      If Dens540ViewData^[i]>Dens540MaxData Then
         Dens540MaxData:=Dens540ViewData^[i];
     End; { i }

 Dispose(ViewLByte);
 Dispose(ViewHByte);
 Dens540FuncExec:=Dens540ViewExec;
End; { ViewScan540 }

Procedure XmotorOff540;
Begin
 If Dens540ErrorFlag Then Exit;
 V24Send(Dens540ComPort,$65);
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
 Dens540FuncExec:=Dens540XOffExec;
End; { XmotorOff540 }

Procedure YmotorHome540;
Begin
 If Dens540ErrorFlag Then Exit;
 V24Send(Dens540ComPort,$50);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,10);
 V24Read(Dens540ComPort,V24ReadValue);
 Dens540FuncExec:=Dens540YHomeExec;
End; { YmotorHome540 }

Procedure YmotorStep540;
Begin
 If Dens540ErrorFlag Then Exit;
 V24Send(Dens540ComPort,$51);
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
 Dens540FuncExec:=Dens540YStepExec;
End; { YmotorStep540 }

Procedure YmotorOff540;
Begin
 If Dens540ErrorFlag Then Exit;
 V24Send(Dens540ComPort,$55);
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
 Dens540FuncExec:=Dens540YOffExec;
End; { YmotorOff540 }

Procedure GotoXY540(X,Y : Integer);
Var   i : Integer;
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$50); { Y Home }
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,15);
 V24Read(Dens540ComPort,V24ReadValue);
 V24Send(Dens540ComPort,$60); { X home }
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,15);
 V24Read(Dens540ComPort,V24ReadValue);
 For i:=1 To Y Do
     Begin
      V24Send(Dens540ComPort,$52); { Y Step n }
      V24Send(Dens540ComPort,$01);
      V24Send(Dens540ComPort,$05);
      WaitV24(Dens540ComPort,5);
      V24Read(Dens540ComPort,V24ReadValue);
     End; { i -> Y }
 For i:=1 To X Do
     Begin
      V24Send(Dens540ComPort,$62); { X Step n }
      V24Send(Dens540ComPort,$01);
      V24Send(Dens540ComPort,$05);
      WaitV24(Dens540ComPort,5);
      V24Read(Dens540ComPort,V24ReadValue);
     End; { i -> X }
 V24Send(Dens540ComPort,$65); { Off }
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
End; { GotoXY540 }

Procedure Normal540;
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$C0);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,45);
 V24Read(Dens540ComPort,V24ReadValue);
End; { Normal540 }

Procedure Zero540;
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$C8);
 V24Send(Dens540ComPort,$00);
 WaitV24(Dens540ComPort,5);
 V24Read(Dens540ComPort,V24ReadValue);
End; { Zero540 }

Procedure Set100Percent540;
Var   Counter       : Integer;
      ValString540  : String[6];
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$E1);
 V24Send(Dens540ComPort,$00);
 Counter:=0;
 ValString540:='      ';
 Repeat
  Inc(Counter);
  V24Read(Dens540ComPort,V24ReadValue);
  ValString540[Counter]:=Chr(V24ReadValue);
 Until Counter=6;
End; { Set100Percent540 }

Procedure ReflectanceMode540;
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$31);
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
End; { Reflectance }

Procedure TransmittanceMode540;
Begin
 FlushV24(Dens540ComPort);
 V24Send(Dens540ComPort,$34);
 V24Send(Dens540ComPort,$00);
 V24Read(Dens540ComPort,V24ReadValue);
End; { Transmittance }

Procedure Absorbance540;
Var   i             :        Integer;
      AbsData540    : Real;
Begin
 For i:=1 To 1000 Do
     Begin
      AbsData540:=0;
      If Dens540RawData^[i]>0 Then
         AbsData540:=-Ln(Dens540RawData^[i]/65535.0);
      AbsData540:=AbsData540*65535/Ln(65535);
      If AbsData540<0 Then AbsData540:=0;
      If AbsData540>65535 Then AbsData540:=65535;
      Dens540RawData^[i]:=Trunc(AbsData540);
     End; { i }
End; { Absorbance540 }
*/
