#include "labchrom2.h"

void		SIGTERM_handler (int signal_number);
void		SIGCHLD_handler (int signal_number);
void		SIGUSR1_handler (int signal_number);
void		SIGSEGV_handler (int signal_number);
void*		SIGSEGV_prev_handler (int signal_number);
void		SIGBUS_handler (int signal_number);

gint		CentralTimeoutFunction (gpointer data);

gint
CentralTimeoutFunction (gpointer data) {
BT_INIT();

  if (!InstrumentPIDStatusChanged) return 1;
  gdk_threads_enter ();
  ActivateCentralWidgets ();
  gdk_threads_leave ();
  InstrumentPIDStatusChanged = FALSE;
  BUGTRACE ("CentralTimeoutFunction DONE");
  return 1;
} // CentralTimeoutFunction

extern gint
MainTimeoutFunction (gpointer data) {
BT_INIT();

  if (!MainDrawingAreaNeedRedraw) return 1;
  gdk_threads_enter ();
  RefreshMainWidgets (MainWindow);
  gdk_threads_leave ();
  return 1;
} // MainTimeoutFunction

void SIGTERM_handler (int signal_number)
{
BT_INIT();

  sprintf (BugTraceUserString, "SIGTERM received in %d ActualInstrument, %d PID.\n", ActualInstrument, (int)getpid());
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);
  gtk_main_quit ();
} // SIGTERM_handler

void SIGCHLD_handler (int signal_number)
{
pid_t		WaitForPID;
int		status;
int		i;
BT_INIT();

  if (ActualInstrument > 0) return;

  sprintf (BugTraceUserString, "SIGCHLD received in %d ActualInstrument, %d PID.\n", ActualInstrument, (int)getpid());
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);

  WaitForPID = wait (&status); // In Kill!
  sprintf (BugTraceUserString, "wait for %d has done.\n", WaitForPID);
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);
  for (i = 1; i < MaxInstruments + 1; i++)
	  if (PIDTable[i] == WaitForPID) PIDTable[i] = 0;
  InstrumentPIDStatusChanged = TRUE;
} // SIGCHLD_handler

void SIGUSR1_handler (int signal_number)
{
BT_INIT();

  sprintf (BugTraceUserString, "SIGUSR1 received in %d ActualInstrument, %d PID.\n", ActualInstrument, (int)getpid());
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);
} // SIGUSR1_handler

void SIGSEGV_handler (int signal_number)
{
BT_INIT();

  sprintf (BugTraceUserString, "*** SIGSEGV received in %d ActualInstrument, %d PID.\n", ActualInstrument, (int)getpid());
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);
  kill ((int)getpid(), SIGKILL);
} // SIGSEGV_handler

void SIGBUS_handler (int signal_number)
{
BT_INIT();

  sprintf (BugTraceUserString, "*** SIGBUS received in %d ActualInstrument, %d PID.\n", ActualInstrument, (int)getpid());
  BUGTRACE (BugTraceUserString);
printf ("%s", BugTraceUserString);
  kill ((int)getpid(), SIGKILL);
} // SIGBUS_handler

int
main (int argc, char *argv[])
{
int i, iInstr;
struct sigaction SIGTERM_sa;
struct sigaction SIGCHLD_sa;
struct sigaction SIGUSR1_sa;
struct sigaction SIGSEGV_sa;
struct sigaction SIGSEGV_prev_sa;
struct sigaction SIGBUS_sa;

BT_INIT();

  printf ("\n--- PID: %d, ParentPID: %d\n", getpid(), getppid());

  InstrumentPIDStatusChanged = FALSE;

  memset (&SIGTERM_sa, 0, sizeof (SIGTERM_sa));
  SIGTERM_sa.sa_handler = &SIGTERM_handler;
  sigaction (SIGTERM, &SIGTERM_sa, NULL);

  memset (&SIGCHLD_sa, 0, sizeof (SIGCHLD_sa));
  SIGCHLD_sa.sa_handler = &SIGCHLD_handler;
  sigaction (SIGCHLD, &SIGCHLD_sa, NULL);

  memset (&SIGUSR1_sa, 0, sizeof (SIGUSR1_sa));
  SIGUSR1_sa.sa_handler = &SIGUSR1_handler;
  sigaction (SIGUSR1, &SIGUSR1_sa, NULL);

  memset (&SIGSEGV_sa, 0, sizeof (SIGSEGV_sa));
  SIGSEGV_sa.sa_handler = &SIGSEGV_handler;
  sigaction (SIGSEGV, &SIGSEGV_sa, &SIGSEGV_prev_sa);

  memset (&SIGBUS_sa, 0, sizeof (SIGBUS_sa));
  SIGBUS_sa.sa_handler = &SIGBUS_handler;
  sigaction (SIGBUS, &SIGBUS_sa, NULL);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  g_thread_init (NULL);
  gdk_threads_init ();

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);
  glade_init ();
  
  CentralOptions.PrintfMode = TRUE;
  SystemInit ();

  getcwd (BugTraceDir, FilenameLength);
  getcwd (BugTraceCentralDir, FilenameLength);

  sprintf (BugTraceUserString, "NetCDF library version: %s\n", nc_inq_libvers());
  BUGTRACE (BugTraceUserString);

  if (argc == 1) {
  SystemTest ();
  ActualInstrument = 0;
  } // if argc==1
  else {
  ActualInstrument = atoi (argv[1]);
  } // if argc!=1
  sprintf (BugTraceUserString, "ActualInstrument = %d\n", ActualInstrument);
  BUGTRACE (BugTraceUserString);

  if ((ActualInstrument < 0) || (ActualInstrument > MaxInstruments)) {
	  printf ("*** ActualInstrument = %d\n", ActualInstrument);
	  BUGTRACE ("###");
	  sprintf (BugTraceUserString, "ActualInstrument = %d\n", ActualInstrument);
	  BUGTRACE (BugTraceUserString);
	  BUGTRACE ("###");
	  SystemDone ();
	  return 0;
  } // ActualInstrument

  ConfigLoad (ActualInstrument);

  LabChromInit ();

  if (ActualInstrument == 0) {
	  AutoStart();
	  if (CentralOptions.CentralWindowClose) {
		  LabChromDone ();
		  SystemDone ();
	
		  return 0;
	  } // CentralOptions.CentralWindowClose
  }

  DrawInit ();
  PrintInit ();
  if (ActualInstrument == 0) {
	  CentralWindow = create_CentralWindow ();
	  ActivateCentralWidgets ();
	  gtk_widget_show (CentralWindow);
	  if (CentralOptions.CentralWindowIconify) gtk_window_iconify (GTK_WINDOW (CentralWindow));
	  CentralTimeoutID = gtk_timeout_add (100, CentralTimeoutFunction, NULL);
  } else {
	  BUGTRACE ("---------------------------");
	  BUGTRACE ("Init windows, widgets, etc.");
	  for (i = 0; i < MaxInstrument; i++)
		  MeasureWindows[i] = NULL;
	  MeasureInit ();
	  MainWindow = create_MainWindow ();
	  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
	  PresetMainWidgets ();
	  ActivateMainWidgets ();
	  gtk_widget_show (MainWindow);
	  gtk_window_resize (GTK_WINDOW(MainWindow), 1, 1);
	  for (i = 0; i < MaxInstrument; i++)
		  MeasureWindows[i] = NULL;
	  iInstr = WorkInstruments.NumOfInstrument;
	  for (i = 0; i < iInstr; i++) {
		  MeasureWindows[i] = create_MeasureWindow ();
		  MeasureWindow = MeasureWindows[i];
		  PresetMeasureWidgets (i);
		  ActivateMeasureWidgets (i);
	  } // i
	  MeasureWindow = MeasureWindows[0];
	  MeasureADTraceWindow = create_MeasureADTraceWindow ();
	  ReprocessWindow = create_ReprocessWindow ();
	  PresetReprocessWidgets ();
	  gtk_widget_show (ReprocessWindow);
	  ReprocessDrawChromInit ();
	  gtk_widget_hide (ReprocessWindow);
	  PeakListWindow = create_PeakListWindow ();
	  gtk_window_set_transient_for (GTK_WINDOW (PeakListWindow), GTK_WINDOW (ReprocessWindow));
	  PeakInfoWindow = create_PeakInfoWindow ();
	  gtk_window_set_transient_for (GTK_WINDOW (PeakInfoWindow), GTK_WINDOW (ReprocessWindow));
	  PresetPeakInfoWindow ();
	  CalibrationCheckWindow = create_CalibrationCheckWindow ();
	  AnalyzeWindow = create_AnalyzeWindow ();
	  gtk_widget_show (AnalyzeWindow);
	  gtk_widget_hide (AnalyzeWindow);
	  PopupMenu = create_ReprocessPopupMenu ();
	  BLPopupMenu = create_BLTypeChangeMenu ();
  } // if ActualInstrument == 0

  gdk_threads_enter ();
  MainThreadLock = TRUE;
  setlocale (LC_NUMERIC, "en_US");
  gtk_main ();
  MainThreadLock = FALSE;
  gdk_threads_leave ();

  if (ActualInstrument == 0) {
	  gtk_timeout_remove (CentralTimeoutID);
	  gtk_widget_destroy (CentralWindow);
  } else {
	  gtk_widget_destroy (PopupMenu);
	  gtk_widget_destroy (AnalyzeWindow);
	  gtk_widget_destroy (CalibrationCheckWindow);
	  gtk_widget_destroy (PeakInfoWindow);
	  gtk_widget_destroy (PeakListWindow);
	  ReprocessDrawChromDone ();
	  gtk_widget_destroy (ReprocessWindow);
	  for (i = 0; i < iInstr; i++)
		  gtk_widget_destroy (MeasureWindows[i]);
	  gtk_timeout_remove (MainTimeOutID);
	  gtk_widget_destroy (MainWindow);
  } // if ActualInstrument == 0
  MeasureDone ();
  PrintDone ();
  DrawDone ();

  LabChromDone ();

  ConfigSave (ActualInstrument);

  SystemDone ();

  return 0;
}
