#ifndef TEMP_FAILURE_RETRY
#define TEMP_FAILURE_RETRY(expression) \
    ({ \
        long int _result; \
        do _result = (long int) (expression); \
        while (_result == -1L && errno == EINTR); \
        _result; \
    })
#endif

#define PRINTF(s,f...) if (CentralOptions.PrintfMode) printf (s,f)

#define POW2(x) exp (x * log (2))

#define BT_INIT() \
char *BugTraceString = alloca (1000); \
char *BugTraceUserString = alloca (1000)

#define BUGTRACE(s) \
sprintf (BugTraceString, "%s | File: %s, Line: %d, PID: %d, ParentPID: %d", s, __FILE__, __LINE__, getpid(), getppid()); \
BugTrace (BugTraceString, time (NULL))

#define WIDGET_TOP(b) \
gtk_widget_get_toplevel (GTK_WIDGET(b))

#define MENU_TOP(m) \
get_toplevel_of_menuitem (GTK_WIDGET(m))

#define DATASOURCE_UP(w, d) \
gtk_object_set_data (GTK_OBJECT (w), "DataSource", GINT_TO_POINTER(d))

#define DATASOURCE(w) \
int DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "DataSource"))

#define ADSI_UP(w, d) \
gtk_object_set_data (GTK_OBJECT (w), "ActualDSInstrument", GINT_TO_POINTER(d))

#define ADSI(w) \
int ActualDSInstrument = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "ActualDSInstrument"))

#define DATA_UP(w, s, r) \
gtk_object_set_data (GTK_OBJECT (w), s, GINT_TO_POINTER(r))

#define DATA_DOWN(w, s) \
GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), s))

#define INTPAR_CONDITION(RV, RV_CONST, OLD_PAR, NEW_PAR) \
if (RV == 0) {\
	if (OLD_PAR != NEW_PAR) RV = RV_CONST;\
}\
OLD_PAR = NEW_PAR

#define CAL_SELECTEDS(w) \
int SelectedComponent = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "SelectedComponent")); \
int SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "SelectedLevel")); \
int SelectedChrom = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "SelectedChrom")); \
int SelectedChromPeak = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "SelectedChromPeak"))

#define SERVICE_HISTORY(w, t)\
GtkTextBuffer *HistoryBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(lookup_widget (WIDGET_TOP(w), "ServiceHistoryTextView")));\
GtkTextIter *HistoryIter = alloca (sizeof(GtkTextIter));\
gchar *HistoryString = alloca(1000);\
gtk_text_buffer_get_end_iter (HistoryBuffer, HistoryIter);\
gtk_text_buffer_insert (HistoryBuffer, HistoryIter, t, -1)

#define SERVICE_TEXT(t)\
gtk_text_buffer_get_end_iter (HistoryBuffer, HistoryIter);\
gtk_text_buffer_insert (HistoryBuffer, HistoryIter, t, -1)

#define SERVICE_HISTORY_M(w, t)\
GtkTextBuffer *HistoryBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(lookup_widget (MENU_TOP(w), "ServiceHistoryTextView")));\
GtkTextIter *HistoryIter = alloca (sizeof(GtkTextIter));\
gchar *HistoryString = alloca(1000);\
gtk_text_buffer_get_end_iter (HistoryBuffer, HistoryIter);\
gtk_text_buffer_insert (HistoryBuffer, HistoryIter, t, -1)

#define TR541_MEASURE_STATUS(w)\
int TR541MeasureStatus = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (w), "TR541MeasureStatus"))
