extern void
RefreshGradientGraph (GtkWidget *MethodWindow) {
GtkWidget	*DrawWidget;
GdkGC		*gc;
struct MethodStruct *MethodWork;
int Height, Width;
char		*InfoStr;
double HighRet;
int x1, y1, x2, y2;
int i, j;

  MethodWork = gtk_object_get_data (GTK_OBJECT (MethodWindow), "MethodWork");
  Height = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MethodWindow), "Height"));
  Width = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MethodWindow), "Width"));
  
  DrawWidget = lookup_widget (MethodWindow, "MethodControlGradientDrawingArea");
  if (DrawWidget == NULL) {
    printf ("*** DrawWidget == NULL\n");
    return;
  }

  InfoStr = alloca (1200);

  // Graphic context init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);

  // Axis
  gdk_gc_set_foreground (gc, &DrawColor);
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,10,10,Height-10);
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,Height-10,Width-10,Height-10);

  gdk_draw_string (DrawWidget->window, DrawFont, gc, 15, 20, "100%");

  if (MethodWork->MeasureEvents.GradientEventNum > 0) {
    HighRet = MethodWork->MeasureEvents.GradientTime[MethodWork->MeasureEvents.GradientEventNum - 1];
    if (HighRet < 0.00001)
      HighRet = 5.0;
    for (i = 0; i < MethodWork->MeasureEvents.GradientComponentNum; i++) {
      gdk_gc_set_foreground (gc, &GradientColors[i]);
      x1 = 0;
      y1 = (int)(MethodWork->MeasureEvents.GradientRatio[0][i] / 100 * (double)(Height-20));
      for (j = 1; j < MethodWork->MeasureEvents.GradientEventNum; j++) {
      x2 = (int)(MethodWork->MeasureEvents.GradientTime[j] / HighRet * (double)(Width-20));
      y2 = (int)(MethodWork->MeasureEvents.GradientRatio[j][i] / 100 * (double)(Height-20));
      gdk_draw_line(DrawWidget->window, gc, x1+10, Height-10-y1, x2+10, Height-10-y2);
      x1 = x2;
      y1 = y2;
      } // j GradientEventNum
    } // i GradientComponentNum

  } // if GradientEventNum > 0

  // Graphic context unref
  gdk_gc_unref (gc);
} // RefreshGradientGraph

extern gint
sort_gradient_compare_func (GtkTreeModel *model,
                            GtkTreeIter  *a,
                            GtkTreeIter  *b,
                            gpointer      userdata)
{
gint RetVal = 0;
gdouble Ret1, Ret2;

  gtk_tree_model_get(model, a, GRAD_COL_TIME, &Ret1, -1);
  gtk_tree_model_get(model, b, GRAD_COL_TIME, &Ret2, -1);

  if (Ret1 != Ret2)
     {
       RetVal = (Ret1 > Ret2) ? 1 : -1;
     }

  return RetVal;
} // sort_gradient_compare_func

extern gboolean
grad_i_foreach_func (GtkTreeModel *Model,
                     GtkTreePath  *Path,
                     GtkTreeIter  *Iter,
                     gpointer      user_data) {
GtkListStore *Store;
int *i;

  i = user_data;
  Store = GTK_LIST_STORE(Model);
  gtk_list_store_set (Store, Iter,
                      GRAD_COL_EVENTNUM, *i + 1,
                      -1);
  (*i)++;

  return FALSE;
} // grad_i_foreach_func

extern gboolean
grad_data_foreach_func (GtkTreeModel *Model,
                        GtkTreePath  *Path,
                        GtkTreeIter  *Iter,
                        gpointer      user_data) {
GtkListStore *Store;
int i;
GtkWidget *MethodWindow;
struct MethodStruct *MethodWork;

  MethodWindow = user_data;
  MethodWork = gtk_object_get_data (GTK_OBJECT (MethodWindow), "MethodWork");
  i = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MethodWindow), "iRow"));
  Store = GTK_LIST_STORE(Model);
  gtk_tree_model_get (Model, Iter,
                      GRAD_COL_TIME, &MethodWork->MeasureEvents.GradientTime[i],
                      GRAD_COL_FLOW, &MethodWork->MeasureEvents.GradientFlow[i],
                      GRAD_COL_A, &MethodWork->MeasureEvents.GradientRatio[i][0],
                      GRAD_COL_B, &MethodWork->MeasureEvents.GradientRatio[i][1],
                      GRAD_COL_C, &MethodWork->MeasureEvents.GradientRatio[i][2],
                      GRAD_COL_D, &MethodWork->MeasureEvents.GradientRatio[i][3],
                      -1);
  i++;
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "iRow", GINT_TO_POINTER(i));

  return FALSE;
} // grad_data_foreach_func

extern void
grad_component_reorder (GtkWidget *MethodWindow) {
GtkWidget *View;
GtkListStore *Store;
GtkTreeIter Iter;
GtkTreeSortable *Sortable;
struct MethodStruct *MethodWork;
int i;

  View = lookup_widget (MethodWindow, "MethodControlGradientTreeView");
  Store = GTK_LIST_STORE(gtk_tree_view_get_model (GTK_TREE_VIEW(View)));
  Sortable = GTK_TREE_SORTABLE(Store);

  gtk_tree_sortable_sort_column_changed (Sortable);
  
  MethodWork = gtk_object_get_data (GTK_OBJECT (MethodWindow), "MethodWork");
  i = 0;
  Store = GTK_LIST_STORE(gtk_tree_view_get_model (GTK_TREE_VIEW(View)));
  gtk_tree_model_foreach(GTK_TREE_MODEL(Store), grad_i_foreach_func, &i);
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "iRow", GINT_TO_POINTER(0));
  gtk_tree_model_foreach(GTK_TREE_MODEL(Store), grad_data_foreach_func, MethodWindow);
  //RefreshGradientGraph (MethodWindow);
} // grad_component_reorder

extern void
grad_component_cell_data_function (GtkTreeViewColumn *Column,
                                   GtkCellRenderer   *Renderer,
                                   GtkTreeModel      *Model,
                                   GtkTreeIter       *Iter,
                                   gpointer           user_data)
{
gdouble CompVal;
gchar   buf[20];
guint ColumnNum;

  ColumnNum = GPOINTER_TO_UINT(g_object_get_data(G_OBJECT(Renderer), "ColumnNum"));  

  switch (ColumnNum) {
    case GRAD_COL_TIME:
        gtk_tree_model_get(Model, Iter, GRAD_COL_TIME, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.3f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        break;
    case GRAD_COL_FLOW:
        gtk_tree_model_get(Model, Iter, GRAD_COL_FLOW, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.2f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        break;
    case GRAD_COL_A:
        gtk_tree_model_get(Model, Iter, GRAD_COL_A, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.1f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        g_object_set(Renderer, "foreground-gdk", &GradientColors[0], NULL);
        g_object_set(Renderer, "foreground-set", TRUE, NULL);
        break;
    case GRAD_COL_B:
        gtk_tree_model_get(Model, Iter, GRAD_COL_B, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.1f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        g_object_set(Renderer, "foreground-gdk", &GradientColors[1], NULL);
        g_object_set(Renderer, "foreground-set", TRUE, NULL);
        break;
    case GRAD_COL_C:
        gtk_tree_model_get(Model, Iter, GRAD_COL_C, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.1f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        g_object_set(Renderer, "foreground-gdk", &GradientColors[2], NULL);
        g_object_set(Renderer, "foreground-set", TRUE, NULL);
        break;
    case GRAD_COL_D:
        gtk_tree_model_get(Model, Iter, GRAD_COL_D, &CompVal, -1);
        g_snprintf(buf, sizeof(buf), "%.1f", CompVal);
        g_object_set(Renderer, "text", buf, NULL);
        g_object_set(Renderer, "foreground-gdk", &GradientColors[3], NULL);
        g_object_set(Renderer, "foreground-set", TRUE, NULL);
        break;
  } // switch
}

extern void
grad_cell_edited_callback (GtkCellRendererText *Renderer,
                           gchar               *path_string,
                           gchar               *new_text,
                           gpointer             user_data)
{
guint ColumnNum;
GtkTreeIter Iter;
GtkTreeModel *Model;
GtkWidget *View;
GtkListStore *Store;
gdouble Val;

  ColumnNum = GPOINTER_TO_UINT(g_object_get_data(G_OBJECT(Renderer), "ColumnNum"));
  View = lookup_widget (WIDGET_TOP(user_data), "MethodControlGradientTreeView");
  Model = gtk_tree_view_get_model (GTK_TREE_VIEW (View));
  if (gtk_tree_model_get_iter_from_string (Model, &Iter, path_string)) {
    Store = GTK_LIST_STORE(gtk_tree_view_get_model (GTK_TREE_VIEW(View)));
    Val = strtod (new_text, NULL);
    gtk_list_store_set (Store, &Iter, ColumnNum, Val, -1);
  } // if
  grad_component_reorder (WIDGET_TOP(user_data));
  RefreshGradientGraph (WIDGET_TOP(user_data));
}

extern void
PresetMethodWidgets (GtkWidget *MethodMainWidget,
                     struct MethodStruct *Method,
                     GtkWidget *CallerWidget,
                     GtkWidget *CallerButton,
                     ApplyFunctionType ApplyFunction) {
GtkWidget *WorkNotebook;
int IntParChan;
char *MethodTitle;
struct MethodStruct *MethodWork;
GtkListStore *Store;
GtkCellRenderer *Renderer;
GtkTreeModel *Model;
GtkWidget *View;
GtkTreeIter Iter;
GtkTreeViewColumn* Column;
gint ColNum;
GtkTreeSortable *Sortable;

  DATASOURCE(MethodMainWidget);
  MethodWork = calloc (1, sizeof(struct MethodStruct));
  memcpy (MethodWork, Method, sizeof(struct MethodStruct));

  MethodTitle = alloca (1200);
  strcpy (MethodTitle, "Method");
  if (Chrom[DataSource].FileLoaded[MetFlag]) {
	  strcat (MethodTitle, ":");
	  strcat (MethodTitle, Method->MeasureParameters.MethodName);
  }
  gtk_window_set_title (GTK_WINDOW(MethodMainWidget), MethodTitle);

  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "IntParWindow", NULL);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "ReportEditWindow", NULL);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "OpenFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "SaveFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "OpenSaveFileSelection", NULL);

  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "Method", Method);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "MethodWork", MethodWork);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "CallerButton", CallerButton);
  gtk_object_set_data (GTK_OBJECT (MethodMainWidget), "ApplyFunction", ApplyFunction);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 1);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 0);
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 1);
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 2);
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 0);
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 1);
	gtk_notebook_remove_page (GTK_NOTEBOOK (lookup_widget (MethodMainWidget, "MethodNotebook")), 2);
		break;
  } // switch

  WorkNotebook = lookup_widget (MethodMainWidget, "MethodInstrParNotebook");
  if (WorkNotebook == NULL) {
	PRINTF ("*** (WorkNotebook == NULL) failed\n",0);
	return;
  } // WorkNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (WorkNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (WorkNotebook), FALSE);
  gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);

  WorkNotebook = lookup_widget (MethodMainWidget, "MethodDataProcGHTNotebook");
  if (WorkNotebook == NULL) {
	PRINTF ("*** (WorkNotebook == NULL) failed\n",0);
	return;
  } // WorkNotebook == NULL
  // FIXME!
//  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (WorkNotebook), FALSE);
//  gtk_notebook_set_show_border (GTK_NOTEBOOK (WorkNotebook), FALSE);
//  gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);

  IntParChan = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "IntParChan"));
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodIntParChannelComboBox")), IntParChan);

  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodDataProcPostRunSampleTypeComboBox")), 0);

  View = lookup_widget (MethodMainWidget, "MethodControlGradientTreeView");
  g_object_set_data (G_OBJECT (MethodMainWidget), "MethodControlGradientTreeView", View);
  // Grad.col. #
  Renderer = gtk_cell_renderer_text_new ();
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "#",  
                                               Renderer,
                                               "text", GRAD_COL_EVENTNUM,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);

  // Grad.col. Time
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_TIME));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "Time",  
                                               Renderer,
                                               "text", GRAD_COL_TIME,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);

  // Grad.col. Flow
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_FLOW));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "Flow",  
                                               Renderer,
                                               "text", GRAD_COL_FLOW,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);

  // Grad.col. A
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_A));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "A [%]",  
                                               Renderer,
                                               "text", GRAD_COL_A,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);

  // Grad.col. B
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_B));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "B [%]",  
                                               Renderer,
                                               "text", GRAD_COL_B,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);
  if (MethodWork->MeasureEvents.GradientComponentNum < 2)
    gtk_tree_view_column_set_visible (Column, FALSE);

  // Grad.col. C
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_C));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "C [%]",  
                                               Renderer,
                                               "text", GRAD_COL_C,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);
  if (MethodWork->MeasureEvents.GradientComponentNum < 3)
    gtk_tree_view_column_set_visible (Column, FALSE);

  // Grad.col. D
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set_data(G_OBJECT(Renderer), "ColumnNum", GUINT_TO_POINTER(GRAD_COL_D));  
  g_object_set(Renderer, "editable", TRUE, NULL);
  ColNum = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (View),
                                               -1,      
                                               "D [%]",  
                                               Renderer,
                                               "text", GRAD_COL_D,
                                               NULL);
  Column = gtk_tree_view_get_column (GTK_TREE_VIEW (View), ColNum - 1);
  gtk_tree_view_column_set_cell_data_func(Column, Renderer, grad_component_cell_data_function, NULL, NULL);
  g_signal_connect(Renderer, "edited", (GCallback) grad_cell_edited_callback, MethodMainWidget);
  if (MethodWork->MeasureEvents.GradientComponentNum < 4)
    gtk_tree_view_column_set_visible (Column, FALSE);
  

  Store = gtk_list_store_new (GRAD_COL_NUM, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  Sortable = GTK_TREE_SORTABLE(Store);
  gtk_tree_sortable_set_sort_func(Sortable, GRAD_COL_SORT_TIME, sort_gradient_compare_func,
                                    NULL, NULL);
  gtk_tree_sortable_set_sort_column_id(Sortable, GRAD_COL_SORT_TIME, GTK_SORT_ASCENDING);

  gtk_list_store_append (Store, &Iter);
  gtk_list_store_set (Store, &Iter,
                      GRAD_COL_EVENTNUM, 1,
                      GRAD_COL_TIME, 0.0,
                      GRAD_COL_FLOW, 0.0,
                      GRAD_COL_A, 0.0,
                      GRAD_COL_B, 0.0,
                      GRAD_COL_C, 0.0,
                      GRAD_COL_D, 0.0, -1);

  Model = GTK_TREE_MODEL (Store);

  gtk_tree_view_set_model (GTK_TREE_VIEW (View), Model);

  g_object_unref (Model);

} // PresetMethodWidgets

extern void
SetMethodWidgets (GtkWidget *MethodMainWidget) {
struct MethodStruct *SetMet;
GtkWidget *View;
GtkListStore *Store;
GtkTreeIter Iter;
int i;
GtkWidget *WorkNotebook;

  SetMet = gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "MethodWork");

// MEASURE PARAMETERS
// Measure parameters - COMMON
  SetEntry (MethodMainWidget, "MethodMeasParFilenameEntry", SetMet->MeasureParameters.ChromName);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParExtSpinButton", atoi (SetMet->MeasureParameters.ChromExt));
  SetCheckBox (MethodMainWidget, "MethodMeasParApplyExtCheckButton", SetMet->MeasureParameters.ApplyExtension);
  SetEntry (MethodMainWidget, "MethodMeasParCommentEntry", SetMet->MeasureParameters.SampleComment);
// Quantitative data
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParVolumeSpinButton", SetMet->MeasureParameters.Volume);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParAmountSpinButton", SetMet->MeasureParameters.Amount);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParFactorSpinButton", SetMet->MeasureParameters.Factor);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParPressureSpinButton", SetMet->MeasureParameters.Pressure);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParTemperatureSpinButton", SetMet->MeasureParameters.Temperature);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParInjVolSpinButton", SetMet->MeasureParameters.InjectedVolume);

  SetEntry (MethodMainWidget, "MethodMeasParVolumeDimEntry", SetMet->MeasureParameters.VolumeDim);
  SetEntry (MethodMainWidget, "MethodMeasParAmountDimEntry", SetMet->MeasureParameters.AmountDim);
  SetEntry (MethodMainWidget, "MethodMeasParFactorDimEntry", SetMet->MeasureParameters.FactorDim);
  SetEntry (MethodMainWidget, "MethodMeasParPressureDimEntry", SetMet->MeasureParameters.PressureDim);
  SetEntry (MethodMainWidget, "MethodMeasParTemperatureDimEntry", SetMet->MeasureParameters.TemperatureDim);

  SetCheckBox (MethodMainWidget, "MethodMeasParUseSamplingCheckButton", SetMet->MeasureParameters.UseSamplingParameters);
  SetCheckBox (MethodMainWidget, "MethodMeasParUseGasCheckButton", SetMet->MeasureParameters.UseGasParameters);

  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodMeasParSampleTypeComboBox")), SetMet->MeasureParameters.SampleType);
  SetCheckBox (MethodMainWidget, "MethodMeasParSampleTypeAutoCalibrCheckButton", SetMet->MeasureParameters.StandardAutoCalibrate);
  SetSpinButtonValue (MethodMainWidget, "MethodMeasParSampleTypeLevelSpinButton", SetMet->MeasureParameters.StandardLevel);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodMeasParSampleTypeLevelModeComboBox")), SetMet->MeasureParameters.StandardMode);

// Measure parameters - Name defaults
  SetCheckBox (MethodMainWidget, "MethodMeasParNameUseCheckButton", SetMet->MeasureParameters.NameSettingsUse);

  SetEntry (MethodMainWidget, "MethodMeasParNamePrefixEntry", SetMet->MeasureParameters.NamePrefix);
  SetEntry (MethodMainWidget, "MethodMeasParNameSuffixEntry", SetMet->MeasureParameters.NameSuffix);

  switch (SetMet->MeasureParameters.NameDateMode) {
	  case NameDefaultDateNone:
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateNoneRadioButton", TRUE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDRadioButton", FALSE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDHMSRadioButton", FALSE);
		  break;
	  case NameDefaultDateDay:
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateNoneRadioButton", FALSE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDRadioButton", TRUE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDHMSRadioButton", FALSE);
		  break;
	  case NameDefaultDateSec:
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateNoneRadioButton", FALSE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDRadioButton", FALSE);
		  SetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDHMSRadioButton", TRUE);
		  break;
  } // switch 

  if (SetMet->MeasureParameters.NameIndexMode) {
	  SetCheckBox (MethodMainWidget, "MethodMeasParNameIndexInNameRadioButton", FALSE);
	  SetCheckBox (MethodMainWidget, "MethodMeasParNameIndexInExtRadioButton", TRUE);
  } else {
	  SetCheckBox (MethodMainWidget, "MethodMeasParNameIndexInNameRadioButton", TRUE);
	  SetCheckBox (MethodMainWidget, "MethodMeasParNameIndexInExtRadioButton", FALSE);
  }

// Measure parameters - Sample information
// Measure parameters - User defined
// Measure parameters - Editable 1
// Measure parameters - Editable 2
// Measure parameters - Instrument specific

// INSTRUMENT PARAMETERS
// Instrument parameters - COMMON
// Instrument parameters - Workstation
// Instrument parameters - Data station
// Instrument parameters - TR541
// Instrument parameters - TR542
// Instrument parameters - TR930

// DATA ACQUISITION
// Data acquisition - COMMON
  SetOptionMenuIndex (MethodMainWidget, "MethodDataAcqSamplingRateOptionMenu", SetMet->MeasureParameters.SamplingRateIdx);
  SetCheckBox (MethodMainWidget, "MethodDataAcqLimitCheckButton", SetMet->MeasureParameters.ForcedStop);
  SetSpinButtonValue (MethodMainWidget, "MethodDataAcqLimitSpinButton", SetMet->MeasureParameters.ForcedStopTime);
  SetCheckBox (MethodMainWidget, "MethodDataAcqAutoFinishCheckButton", SetMet->MeasureParameters.AutoFinish);
  SetCheckBox (MethodMainWidget, "MethodDataAcqMedianFilterCheckButton", SetMet->MeasureParameters.ApplyMedianFilter);
// Data acquisition - Workstation
// Data acquisition - Data station
// Data acquisition - TR541
  SetCheckBox (MethodMainWidget, "MethodInstrParTR541ScanShortCheckButton", SetMet->TR540Parameters.TR540HalfSizeScan);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541NormXSpinButton", SetMet->MeasureParameters.NormX);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541NormYSpinButton", SetMet->MeasureParameters.NormY);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541YStartSpinButton", SetMet->MeasureParameters.ViewScanYStart);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541YStopSpinButton", SetMet->MeasureParameters.ViewScanYStop);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541XStartSpinButton", SetMet->MeasureParameters.ScanStartX);
  SetSpinButtonValue (MethodMainWidget, "MethodInstrParTR541XStopSpinButton", SetMet->MeasureParameters.ScanStopX);
  SetOptionMenuIndex (MethodMainWidget, "MethodInstrParTR541WLOptionmenu", SetMet->TR540Parameters.TR540SelectedFilter);
  if (SetMet->MeasureParameters.MeasureMode == TR540FluorescentMode)
	  SetCheckBox (MethodMainWidget, "MethodInstrParTR541FluorescenceCheckButton", TRUE);
  else
	  SetCheckBox (MethodMainWidget, "MethodInstrParTR541FluorescenceCheckButton", FALSE);
  switch (SetMet->MeasureParameters.MeasureMode) {
	  case TR540ReflectionMode:
		  SetCheckBox (MethodMainWidget, "MethodInstrParTR541ReflectanceRadioButton", TRUE);
		  break;
	  case TR540TransmissionMode:
		  SetCheckBox (MethodMainWidget, "MethodInstrParTR541TransmittanceRadioButton", TRUE);
		  break;
  }
// Data acquisition - TR542
// Data acquisition - TR930

// DATA PROCESSING
// Data processing - COMMON
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodDataProcNoiseFilterTypeComboBox")), SetMet->MeasureParameters.SmoothMethod);
  switch (SetMet->MeasureParameters.SmoothMethod) {
	  case SmoothTriangle:
		  switch (SetMet->MeasureParameters.SmoothFactor1) {
			  case 0: SetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleNoneRadioButton", TRUE);
				  break;
			  case 1: SetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleWeakRadioButton", TRUE);
				  break;
			  case 2: SetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleMediumRadioButton", TRUE);
				  break;
			  case 3: SetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleStrongRadioButton", TRUE);
				  break;
			  case 4: SetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserRadioButton", TRUE);
				  break;
		  } // switch SmoothFactor1
		  SetSpinButtonValue (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserSpinButton", SetMet->MeasureParameters.SmoothFactor2);
		  break;
  } // switch SmoothMethod

// Data processing - GC
// Data processing - HPLC
// Data processing - TLC
// Data processing - GC+HPLC
// Data processing - ALL
// Data processing - Post Run - Separated
// Data processing - Calculation method
  switch (SetMet->MeasureParameters.ConcentrationCalculationMethod) {
	  case ConcCalculationAreaPercent :
		  SetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodAreaNormRadioButton", TRUE);
		  break;
	  case ConcCalculationScaleFactor :
		  SetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodInternalStandardRadioButton", TRUE);
		  break;
	  case ConcCalculationInternalStandard :
		  SetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodExternalStandardRadioButton", TRUE);
		  break;
	  case ConcCalculationExternalStandard :
		  SetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodExternalISTAmountSpinButton", TRUE);
		  break;
  } // ConcentrationCalculationMethod

  SetSpinButtonValue (MethodMainWidget, "MethodDataProcCalculationMethodScaleFactorSpinButton", SetMet->MeasureParameters.ScaleFactor);
  SetEntry (MethodMainWidget, "MethodDataProcCalculationMethodScaleFactorDimEntry", SetMet->MeasureParameters.ScaleFactorDim);
  SetSpinButtonValue (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionSpinButton", SetMet->MeasureParameters.ISTRetention);
  SetEntry (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionDimEntry", "min");
  SetSpinButtonValue (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionLimitSpinButton", SetMet->MeasureParameters.ISTRetentionLimit);
  SetSpinButtonValue (MethodMainWidget, "MethodDataProcCalculationMethodISTConcSpinButton", SetMet->MeasureParameters.IstConc);
  SetEntry (MethodMainWidget, "MethodDataProcCalculationMethodISTConcDim", SetMet->MeasureParameters.IstConcDim);
  SetEntry (MethodMainWidget, "MethodDataProcCalculationMethodExternalISTAmountDimEntry", "mg/ml");
  SetGnomeFileEntry (MethodMainWidget, "MethodDataProcCalculationMethodExternalFileEntry", SetMet->MeasureParameters.CalibrationName);

// CONTROL
// Control - Start control
  SetCheckBox (MethodMainWidget, "MethodControlStartGenericWaitCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_GenericEnabled]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartGenericWaitSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_GenericEnabled]);
  SetCheckBox (MethodMainWidget, "MethodControlStartEmitStandardCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_EmitStandard]);
  SetCheckBox (MethodMainWidget, "MethodControlStartHoldStandardCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_HoldStandard]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitStandardCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitStandard]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitStandardSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitStandard]);
  SetCheckBox (MethodMainWidget, "MethodControlStartEmitControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_EmitControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartHoldControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_HoldControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitControl]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitControlSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartEmitRetControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_EmitRetControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartHoldRetControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_HoldRetControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitRetControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitRetControl]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitRetControlSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitRetControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartSendSamplerCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_SendSampler]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartSendSamplerSpinButton", SetMet->MeasureParameters.StartEventData[ControlEvent_START_SendSampler]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitSamplerCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitSampler]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitSamplerSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitSampler]);
  SetCheckBox (MethodMainWidget, "MethodControlStartAutozeroCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_Autozero]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitReadyCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitReady]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitReadySpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitReady]);
  SetCheckBox (MethodMainWidget, "MethodControlStartSTARTCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_EmitStart]);
  SetCheckBox (MethodMainWidget, "MethodControlStartWaitRunCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_WaitRun]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlStartWaitRunSpinButton", SetMet->MeasureParameters.StartEventTime[ControlEvent_START_WaitRun]);
  SetCheckBox (MethodMainWidget, "MethodControlStartCheckSampleCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_CheckSample]);
  SetCheckBox (MethodMainWidget, "MethodControlStartCheckStandardCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_CheckStandard]);
  SetCheckBox (MethodMainWidget, "MethodControlStartCheckControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_CheckControl]);
  SetCheckBox (MethodMainWidget, "MethodControlStartCheckRetControlCheckButton", SetMet->MeasureParameters.StartEventEnabled[ControlEvent_START_CheckRetControl]);
// Control - Run control
  SetCheckBox (MethodMainWidget, "MethodControlRunOverflowCheckButton", SetMet->MeasureParameters.RunEventEnabled[ControlEvent_RUN_SignalOverflow]);
  SetCheckBox (MethodMainWidget, "MethodControlRunWarningCheckButton", SetMet->MeasureParameters.RunEventEnabled[ControlEvent_RUN_CheckWarning]);
  SetCheckBox (MethodMainWidget, "MethodControlRunErrorCheckButton", SetMet->MeasureParameters.RunEventEnabled[ControlEvent_RUN_CheckError]);
  SetCheckBox (MethodMainWidget, "MethodControlRunStopSignalCheckButton", SetMet->MeasureParameters.RunEventEnabled[ControlEvent_RUN_CheckStop]);
// Control - Stop control
  SetCheckBox (MethodMainWidget, "MethodControlSTOPEmitStopCheckButton", SetMet->MeasureParameters.StopEventEnabled[ControlEvent_STOP_EmitStopSignal]);
  SetCheckBox (MethodMainWidget, "MethodControlSTOPReadyCheckButton", SetMet->MeasureParameters.StopEventEnabled[ControlEvent_STOP_WaitStopReady]);
  SetSpinButtonValue (MethodMainWidget, "MethodControlSTOPReadySpinButton", SetMet->MeasureParameters.StopEventTime[ControlEvent_STOP_WaitStopReady]);
// Control - Runtime events
// Control - Temperature
// Control - Gradient
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	case InstrumentWorkstation :
	case InstrumentDataStation :
	  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodControlGradientColorComboBox")), 0);
	
	  SetCheckBox (MethodMainWidget, "MethodControlGradientEnableCheckButton", SetMet->MeasureEvents.GradientEnable);
	  SetSpinButtonValue (MethodMainWidget, "MethodControlGradientEventNumSpinButton", SetMet->MeasureEvents.GradientEventNum);
	  SetSpinButtonValue (MethodMainWidget, "MethodControlGradientComponentsSpinButton", SetMet->MeasureEvents.GradientComponentNum);
	  SetSpinButtonValue (MethodMainWidget, "MethodControlGradientFlowRateSpinButton", SetMet->MeasureEvents.GradientFlowRate);
	  SetSpinButtonValue (MethodMainWidget, "MethodControlGradientMaxFlowRateSpinButton", SetMet->MeasureEvents.GradientMaxFlowRate);

	  View = lookup_widget (MethodMainWidget, "MethodControlGradientTreeView");
	  Store = GTK_LIST_STORE(gtk_tree_view_get_model (GTK_TREE_VIEW(View)));
	  gtk_list_store_clear (Store);
	
	  for (i = 0; i < MaxInstrumentEvents; i++) {
		if (i < SetMet->MeasureEvents.GradientEventNum) {
		  gtk_list_store_append (Store, &Iter);
		  gtk_list_store_set (Store, &Iter,
							  GRAD_COL_EVENTNUM, i + 1,
							  GRAD_COL_TIME, SetMet->MeasureEvents.GradientTime[i],
							  GRAD_COL_FLOW, SetMet->MeasureEvents.GradientFlow[i],
							  GRAD_COL_A, SetMet->MeasureEvents.GradientRatio[i][0],
							  GRAD_COL_B, SetMet->MeasureEvents.GradientRatio[i][1],
							  GRAD_COL_C, SetMet->MeasureEvents.GradientRatio[i][2],
							  GRAD_COL_D, SetMet->MeasureEvents.GradientRatio[i][3],
							  -1);
		} // if
	  } // i
	  WorkNotebook = lookup_widget (MethodMainWidget, "MethodNotebook");
	  gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), 3);
	  WorkNotebook = lookup_widget (MethodMainWidget, "MethodControlNotebook");
	  gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), 5);
	  gdk_flush ();
	  RefreshGradientGraph (MethodMainWidget);
		break;
	case InstrumentTR541 :
	case InstrumentTR542 :
	case InstrumentTR930 :
		break;
  } // switch

// INSTRUMENT DATA
// Instrument data - COMMON
  SetEntry (MethodMainWidget, "MethodInstrumentCommonNameEntry", SetMet->InstrumentData.Instrument);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonInstrSerNoEntry", SetMet->InstrumentData.InstrumentSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonAutosamplerEntry", SetMet->InstrumentData.Autosampler);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonSamplerSerNoEntry", SetMet->InstrumentData.AutosamplerSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonSysContEntry", SetMet->InstrumentData.SystemController);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonSysContSerNoEntry", SetMet->InstrumentData.SystemControllerSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorEntry", SetMet->InstrumentData.Detector);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorSerNoEntry", SetMet->InstrumentData.DetectorSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorSettingsEntry", SetMet->InstrumentData.DetectorSettings);
  SetEntry (MethodMainWidget, "MethodInstrumentCommonTemperatureSettingsEntry", SetMet->InstrumentData.Temperature);
// Instrument data - GC
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificGCCarrierEntry", SetMet->InstrumentData.CarrierGas);
// Instrument data - HPLC
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCEluentEntry", SetMet->InstrumentData.Eluent);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCPumpEntry", SetMet->InstrumentData.Pump);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCPumpSerNoEntry", SetMet->InstrumentData.PumpSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCGradientEntry", SetMet->InstrumentData.GradientMixer);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCGradientSerNoEntry", SetMet->InstrumentData.GradMixSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCFractionEntry", SetMet->InstrumentData.FractionCollector);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCFractionSerNoEntry", SetMet->InstrumentData.FractCollSerNo);
// Instrument data - TLC
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCSamplerEntry", SetMet->InstrumentData.Sampler);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCSamplerSerNoEntry", SetMet->InstrumentData.SamplerSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperEntry", SetMet->InstrumentData.DeveloperDevice);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperSerNoEntry", SetMet->InstrumentData.DeveloperSerNo);
  SetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperSettingsEntry", SetMet->InstrumentData.DeveloperSettings);

// COLUMN DATA
// Column data - COMMON
  SetEntry (MethodMainWidget, "MethodColumnCommonDescriptionEntry", SetMet->InstrumentData.Description);
  SetEntry (MethodMainWidget, "MethodColumnCommonManufacturerEntry", SetMet->InstrumentData.Manufacturer);
  SetEntry (MethodMainWidget, "MethodColumnCommonProductEntry", SetMet->InstrumentData.Product);
  SetEntry (MethodMainWidget, "MethodColumnCommonSerialEntry", SetMet->InstrumentData.Serial);
  SetEntry (MethodMainWidget, "MethodColumnCommonBatchEntry", SetMet->InstrumentData.Batch);
// Column data - GC/HPLC
  SetEntry (MethodMainWidget, "MethodColumnGCHPLCDiameterEntry", SetMet->InstrumentData.Diameter);
  SetEntry (MethodMainWidget, "MethodColumnGCHPLCParticleEntry", SetMet->InstrumentData.Particle);
  SetEntry (MethodMainWidget, "MethodColumnGCHPLCLengthEntry", SetMet->InstrumentData.Length);
// Column data - TLC
  SetEntry (MethodMainWidget, "MethodColumnTLCSizeEntry", SetMet->InstrumentData.Size);
  SetEntry (MethodMainWidget, "MethodColumnTLCThicknessEntry", SetMet->InstrumentData.Thickness);
  SetEntry (MethodMainWidget, "MethodColumnTLCFluorescentEntry", SetMet->InstrumentData.Fluorescent);
  SetEntry (MethodMainWidget, "MethodColumnTLCBaseEntry", SetMet->InstrumentData.Base);

// VALIDATION
// Validation - Verification
  SetEntry (MethodMainWidget, "MethodValidationLastVerifiedEntry", SetMet->InstrumentData.LastVerified);
  SetDateTime (MethodMainWidget, "MethodValidationLastVerifiedDateEdit", SetMet->InstrumentData.LastVerifiedDate);
  SetEntry (MethodMainWidget, "MethodValidationVerificationValidEntry", SetMet->InstrumentData.VerificationValid);
  SetDateTime (MethodMainWidget, "MethodValidationVerificationValidDateEdit", SetMet->InstrumentData.VerificationValidDate);
  SetEntry (MethodMainWidget, "MethodValidationVerificationIDEntry", SetMet->InstrumentData.VerificationId);
// Validation User data
  SetEntry (MethodMainWidget, "MethodValidationUserOperatorEntry", SetMet->InstrumentData.Operator);
  SetEntry (MethodMainWidget, "MethodValidationUserLaborEntry", SetMet->InstrumentData.Labor);

// USER SPECIFIED
// User specified - instrument parameters
  SetEntry (MethodMainWidget, "MethodUserInstrumentQ1Entry", SetMet->InstrumentData.Free1QI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentA1Entry", SetMet->InstrumentData.Free1AI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentQ2Entry", SetMet->InstrumentData.Free2QI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentA2Entry", SetMet->InstrumentData.Free2AI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentQ3Entry", SetMet->InstrumentData.Free3QI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentA3Entry", SetMet->InstrumentData.Free3AI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentQ4Entry", SetMet->InstrumentData.Free4QI);
  SetEntry (MethodMainWidget, "MethodUserInstrumentA4Entry", SetMet->InstrumentData.Free4AI);
// User specified - column parameters
  SetEntry (MethodMainWidget, "MethodUserColumnQ1Entry", SetMet->InstrumentData.Free1Q);
  SetEntry (MethodMainWidget, "MethodUserColumnA1Entry", SetMet->InstrumentData.Free1A);
  SetEntry (MethodMainWidget, "MethodUserColumnQ2Entry", SetMet->InstrumentData.Free2Q);
  SetEntry (MethodMainWidget, "MethodUserColumnA2Entry", SetMet->InstrumentData.Free2A);
  SetEntry (MethodMainWidget, "MethodUserColumnQ3Entry", SetMet->InstrumentData.Free3Q);
  SetEntry (MethodMainWidget, "MethodUserColumnA3Entry", SetMet->InstrumentData.Free3A);
  SetEntry (MethodMainWidget, "MethodUserColumnQ4Entry", SetMet->InstrumentData.Free4Q);
  SetEntry (MethodMainWidget, "MethodUserColumnA4Entry", SetMet->InstrumentData.Free4A);

  WorkNotebook = lookup_widget (MethodMainWidget, "MethodNotebook");
  gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), 0);
} // SetMethodWidgets

extern void
GetMethodWidgets (GtkWidget *MethodMainWidget) {
struct MethodStruct *GetMet;
struct MethodStruct *Method;
int i;

  GetMet = gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "MethodWork");

// MEASURE PARAMETERS
// Measure parameters - COMMON
  strcpy (GetMet->MeasureParameters.ChromName, GetEntry (MethodMainWidget, "MethodMeasParFilenameEntry"));
  sprintf (GetMet->MeasureParameters.ChromExt, "%.3d", GetSpinButtonInt (MethodMainWidget, "MethodMeasParExtSpinButton"));
  GetMet->MeasureParameters.ApplyExtension = GetCheckBox (MethodMainWidget, "MethodMeasParApplyExtCheckButton");
  strcpy (GetMet->MeasureParameters.SampleComment, GetEntry (MethodMainWidget, "MethodMeasParCommentEntry"));
// Quantitative data
  GetMet->MeasureParameters.Volume = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParVolumeSpinButton");
  GetMet->MeasureParameters.Amount = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParAmountSpinButton");
  GetMet->MeasureParameters.Factor = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParFactorSpinButton");
  GetMet->MeasureParameters.Pressure = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParPressureSpinButton");
  GetMet->MeasureParameters.Temperature = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParTemperatureSpinButton");
  GetMet->MeasureParameters.InjectedVolume = GetSpinButtonFloat (MethodMainWidget, "MethodMeasParInjVolSpinButton");

  strcpy (GetMet->MeasureParameters.VolumeDim, GetEntry (MethodMainWidget, "MethodMeasParVolumeDimEntry"));
  strcpy (GetMet->MeasureParameters.AmountDim, GetEntry (MethodMainWidget, "MethodMeasParAmountDimEntry"));
  strcpy (GetMet->MeasureParameters.FactorDim, GetEntry (MethodMainWidget, "MethodMeasParFactorDimEntry"));
  strcpy (GetMet->MeasureParameters.PressureDim, GetEntry (MethodMainWidget, "MethodMeasParPressureDimEntry"));
  strcpy (GetMet->MeasureParameters.TemperatureDim, GetEntry (MethodMainWidget, "MethodMeasParTemperatureDimEntry"));

  GetMet->MeasureParameters.UseSamplingParameters = GetCheckBox (MethodMainWidget, "MethodMeasParUseSamplingCheckButton");
  GetMet->MeasureParameters.UseGasParameters = GetCheckBox (MethodMainWidget, "MethodMeasParUseGasCheckButton");

  GetMet->MeasureParameters.SampleType = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodMeasParSampleTypeComboBox")));
  if (GetMet->MeasureParameters.SampleType < 0)
	  GetMet->MeasureParameters.SampleType = 0;
  GetMet->MeasureParameters.StandardAutoCalibrate = GetCheckBox (MethodMainWidget, "MethodMeasParSampleTypeAutoCalibrCheckButton");
  GetMet->MeasureParameters.StandardLevel = GetSpinButtonInt (MethodMainWidget, "MethodMeasParSampleTypeLevelSpinButton");
  GetMet->MeasureParameters.StandardMode = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodMeasParSampleTypeLevelModeComboBox")));
  if (GetMet->MeasureParameters.StandardMode < 0)
	  GetMet->MeasureParameters.StandardMode = 0;

// Measure parameters - Name defaults
  GetMet->MeasureParameters.NameSettingsUse = GetCheckBox (MethodMainWidget, "MethodMeasParNameUseCheckButton");

  strcpy (GetMet->MeasureParameters.NamePrefix, GetEntry (MethodMainWidget, "MethodMeasParNamePrefixEntry"));
  strcpy (GetMet->MeasureParameters.NameSuffix, GetEntry (MethodMainWidget, "MethodMeasParNameSuffixEntry"));

  if (GetCheckBox (MethodMainWidget, "MethodMeasParNameDateNoneRadioButton"))
	  GetMet->MeasureParameters.NameDateMode = NameDefaultDateNone;
  if (GetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDRadioButton"))
	  GetMet->MeasureParameters.NameDateMode = NameDefaultDateDay;
  if (GetCheckBox (MethodMainWidget, "MethodMeasParNameDateYMDHMSRadioButton"))
	  GetMet->MeasureParameters.NameDateMode = NameDefaultDateSec;
  GetMet->MeasureParameters.NameIndexMode = GetCheckBox (MethodMainWidget, "MethodMeasParNameIndexInExtRadioButton");

// Measure parameters - Sample information
// Measure parameters - User defined
// Measure parameters - Editable 1
// Measure parameters - Editable 2
// Measure parameters - Instrument specific

// INSTRUMENT PARAMETERS
// Instrument parameters - COMMON
// Instrument parameters - Workstation
// Instrument parameters - Data station
// Instrument parameters - TR541
  GetMet->TR540Parameters.TR540HalfSizeScan = GetCheckBox (MethodMainWidget, "MethodInstrParTR541ScanShortCheckButton");
  GetMet->MeasureParameters.NormX = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541NormXSpinButton");
  GetMet->MeasureParameters.NormY = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541NormYSpinButton");
  GetMet->MeasureParameters.ViewScanYStart = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541YStartSpinButton");
  GetMet->MeasureParameters.ViewScanYStop = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541YStopSpinButton");
  GetMet->MeasureParameters.ScanStartX = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541XStartSpinButton");
  GetMet->MeasureParameters.ScanStopX = GetSpinButtonInt (MethodMainWidget, "MethodInstrParTR541XStopSpinButton");
  GetMet->TR540Parameters.TR540SelectedFilter = GetOptionMenuIndex (MethodMainWidget, "MethodInstrParTR541WLOptionmenu");
  if (GetCheckBox (MethodMainWidget, "MethodInstrParTR541FluorescenceCheckButton"))
	  GetMet->MeasureParameters.MeasureMode = TR540FluorescentMode;
  else if (GetCheckBox (MethodMainWidget, "MethodInstrParTR541ReflectanceRadioButton"))
	  GetMet->MeasureParameters.MeasureMode = TR540ReflectionMode;
  else
	  GetMet->MeasureParameters.MeasureMode = TR540TransmissionMode;
// Instrument parameters - TR542
// Instrument parameters - TR930

// DATA ACQUISITION
// Data acquisition - COMMON
  GetMet->MeasureParameters.SamplingRateIdx = GetOptionMenuIndex (MethodMainWidget, "MethodDataAcqSamplingRateOptionMenu");
  GetMet->MeasureParameters.SamplingRate = GetMet->ADParameters.ADSamplingTimeTable[GetMet->MeasureParameters.SamplingRateIdx];
  GetMet->MeasureParameters.Cycle = GetMet->ADParameters.ADSamplingFrequencyTable[GetMet->MeasureParameters.SamplingRateIdx];
  GetMet->MeasureParameters.ForcedStop = GetCheckBox (MethodMainWidget, "MethodDataAcqLimitCheckButton");
  GetMet->MeasureParameters.ForcedStopTime = GetSpinButtonFloat (MethodMainWidget, "MethodDataAcqLimitSpinButton");
  GetMet->MeasureParameters.ForcedStopTick = GetMet->MeasureParameters.ForcedStopTime * GetMet->MeasureParameters.Cycle * 60;
  GetMet->MeasureParameters.AutoFinish = GetCheckBox (MethodMainWidget, "MethodDataAcqAutoFinishCheckButton");
  GetMet->MeasureParameters.ApplyMedianFilter = GetCheckBox (MethodMainWidget, "MethodDataAcqMedianFilterCheckButton");
// Data acquisition - Workstation
// Data acquisition - Data station
// Data acquisition - TR541
// Data acquisition - TR542
// Data acquisition - TR930

// DATA PROCESSING
// Data processing - COMMON
  GetMet->MeasureParameters.SmoothMethod = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodDataProcNoiseFilterTypeComboBox")));
  switch (GetMet->MeasureParameters.SmoothMethod) {
	  case SmoothTriangle:
		  if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleNoneRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 0;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleWeakRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 1;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleMediumRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 2;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleStrongRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 3;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 4;
		  GetMet->MeasureParameters.SmoothFactor2 = GetSpinButtonInt (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserSpinButton");
		  break;
  } // switch SmoothMethod

// Data processing - GC
// Data processing - HPLC
// Data processing - TLC
// Data processing - GC+HPLC
// Data processing - ALL
// Data processing - Post Run - Separated
// Data processing - Calculation method
  if (GetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodAreaNormRadioButton"))
	  GetMet->MeasureParameters.ConcentrationCalculationMethod = ConcCalculationAreaPercent;
  else if (GetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodInternalStandardRadioButton"))
	  GetMet->MeasureParameters.ConcentrationCalculationMethod = ConcCalculationScaleFactor;
  else if (GetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodExternalStandardRadioButton"))
	  GetMet->MeasureParameters.ConcentrationCalculationMethod = ConcCalculationInternalStandard;
  else if (GetCheckBox (MethodMainWidget, "MethodDataProcCalculationMethodExternalISTAmountSpinButton"))
	  GetMet->MeasureParameters.ConcentrationCalculationMethod = ConcCalculationExternalStandard;

  GetMet->MeasureParameters.ScaleFactor = GetSpinButtonFloat (MethodMainWidget, "MethodDataProcCalculationMethodScaleFactorSpinButton");
  strcpy (GetMet->MeasureParameters.ScaleFactorDim, GetEntry (MethodMainWidget, "MethodDataProcCalculationMethodScaleFactorDimEntry"));
  GetMet->MeasureParameters.ISTRetention = GetSpinButtonFloat (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionSpinButton");
  //strcpy ("min", GetEntry (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionDimEntry"));
  GetMet->MeasureParameters.ISTRetentionLimit = GetSpinButtonFloat (MethodMainWidget, "MethodDataProcCalculationMethodISTRetentionLimitSpinButton");
  GetMet->MeasureParameters.IstConc = GetSpinButtonFloat (MethodMainWidget, "MethodDataProcCalculationMethodISTConcSpinButton");
  strcpy (GetMet->MeasureParameters.IstConcDim, GetEntry (MethodMainWidget, "MethodDataProcCalculationMethodISTConcDim"));
  //strcpy ("mg/ml", GetEntry (MethodMainWidget, "MethodDataProcCalculationMethodExternalISTAmountDimEntry"));
  GetGnomeFileEntry (MethodMainWidget, "MethodDataProcCalculationMethodExternalFileEntry", GetMet->MeasureParameters.CalibrationName);

// CONTROL
  GetMet->MeasureParameters.DefaultPulseWidth = 10;
  GetMet->MeasureParameters.DefaultTimeOut = 6000;
// Control - Start control
  GetMet->MeasureParameters.StartControlEnable = TRUE;
  GetMet->MeasureParameters.StartEventNum = 0;
//  iStep = 0;
  for (i = 0; i < ControlEvent_START_Num; i++) {
	  GetMet->MeasureParameters.StartEventEnabled[i] = FALSE;
	  GetMet->MeasureParameters.StartEventFunc[i] = i;
	  GetMet->MeasureParameters.StartEventCode[i] = 0;
	  GetMet->MeasureParameters.StartEventData[i] = 0;
	  GetMet->MeasureParameters.StartEventTime[i] = GetMet->MeasureParameters.DefaultPulseWidth;
	  switch (i) {
		  case ControlEvent_START_GenericEnabled:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_GenericEnable;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartGenericWaitCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartGenericWaitSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_EmitStandard:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_OUT_Standard;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartEmitStandardCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_HoldStandard:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeHOLD;
			  GetMet->MeasureParameters.StartEventCode[i] = 0;
			  if ((GetCheckBox (MethodMainWidget, "MethodControlStartHoldStandardCheckButton")) && \
				  (GetCheckBox (MethodMainWidget, "MethodControlStartEmitStandardCheckButton"))){
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitStandard:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_Standard;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitStandardCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitStandardSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_EmitControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_OUT_Control;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartEmitControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_HoldControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeHOLD;
			  GetMet->MeasureParameters.StartEventCode[i] = 0;
			  if ((GetCheckBox (MethodMainWidget, "MethodControlStartHoldControlCheckButton")) && \
				  (GetCheckBox (MethodMainWidget, "MethodControlStartEmitControlCheckButton"))) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_Control;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitControlSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_EmitRetControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_OUT_RetControl;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartEmitRetControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_HoldRetControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeHOLD;
			  GetMet->MeasureParameters.StartEventCode[i] = 0;
			  if ((GetCheckBox (MethodMainWidget, "MethodControlStartHoldRetControlCheckButton")) && \
				  (GetCheckBox (MethodMainWidget, "MethodControlStartEmitRetControlCheckButton"))) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitRetControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_RetControl;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitRetControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitRetControlSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_SendSampler:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeSET;
			  GetMet->MeasureParameters.StartEventCode[i] = 0;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartSendSamplerCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventData[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartSendSamplerSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitSampler:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_Sampler;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitSamplerCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitSamplerSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_Autozero:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_OUT_Autozero;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartAutozeroCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitReady:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_Ready;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitReadyCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitReadySpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_EmitStart:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_OUT_Start;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartSTARTCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_WaitRun:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_Run;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartWaitRunCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlStartWaitRunSpinButton");
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_CheckSample:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_CheckSample;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartCheckSampleCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_CheckStandard:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_CheckStandard;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartCheckStandardCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_CheckControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_CheckControl;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartCheckControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_START_CheckRetControl:
			  GetMet->MeasureParameters.StartEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.StartEventCode[i] = ControlSignal_IN_CheckRetControl;
			  if (GetCheckBox (MethodMainWidget, "MethodControlStartCheckRetControlCheckButton")) {
				  GetMet->MeasureParameters.StartEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StartEventNum++;
			  }// if GetCheckBox
			  break;
	  } // switch (i)
  } // i ControlEvent_START_Num
// Control - Run control
  GetMet->MeasureParameters.RunControlEnable = TRUE;
  GetMet->MeasureParameters.RunEventNum = 0;
//  iStep = 0;
  for (i = 0; i < ControlEvent_RUN_Num; i++) {
	  GetMet->MeasureParameters.RunEventEnabled[i] = FALSE;
	  GetMet->MeasureParameters.RunEventFunc[i] = i;
	  GetMet->MeasureParameters.RunEventCode[i] = 0;
	  GetMet->MeasureParameters.RunEventData[i] = 0;
	  GetMet->MeasureParameters.RunEventTime[i] = 0;
	  switch (i) {
		  case ControlEvent_RUN_SignalOverflow:
			  GetMet->MeasureParameters.RunEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.RunEventCode[i] = ControlSignal_IN_Overflow;
			  if (GetCheckBox (MethodMainWidget, "MethodControlRunOverflowCheckButton")) {
				  GetMet->MeasureParameters.RunEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.RunEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_RUN_CheckWarning:
			  GetMet->MeasureParameters.RunEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.RunEventCode[i] = ControlSignal_IN_Warning;
			  if (GetCheckBox (MethodMainWidget, "MethodControlRunWarningCheckButton")) {
				  GetMet->MeasureParameters.RunEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.RunEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_RUN_CheckError:
			  GetMet->MeasureParameters.RunEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.RunEventCode[i] = ControlSignal_IN_Error;
			  if (GetCheckBox (MethodMainWidget, "MethodControlRunErrorCheckButton")) {
				  GetMet->MeasureParameters.RunEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.RunEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_RUN_CheckStop:
			  GetMet->MeasureParameters.RunEventMode[i] = ControlSignalModeCHK;
			  GetMet->MeasureParameters.RunEventCode[i] = ControlSignal_IN_CheckStop;
			  if (GetCheckBox (MethodMainWidget, "MethodControlRunStopSignalCheckButton")) {
				  GetMet->MeasureParameters.RunEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.RunEventNum++;
			  }// if GetCheckBox
			  break;
	  } // switch (i)
  } // i ControlEvent_RUN_Num
// Control - Stop control
  GetMet->MeasureParameters.StopControlEnable = TRUE;
  GetMet->MeasureParameters.StopEventNum = 0;
//  iStep = 0;
  for (i = 0; i < ControlEvent_STOP_Num; i++) {
	  GetMet->MeasureParameters.StopEventEnabled[i] = FALSE;
	  GetMet->MeasureParameters.StopEventFunc[i] = i;
	  GetMet->MeasureParameters.StopEventCode[i] = 0;
	  GetMet->MeasureParameters.StopEventData[i] = 0;
	  GetMet->MeasureParameters.StopEventTime[i] = 0;
	  switch (i) {
		  case ControlEvent_STOP_EmitStopSignal:
			  GetMet->MeasureParameters.StopEventMode[i] = ControlSignalModeOUT;
			  GetMet->MeasureParameters.StopEventCode[i] = ControlSignal_OUT_Stop;
			  if (GetCheckBox (MethodMainWidget, "MethodControlSTOPEmitStopCheckButton")) {
				  GetMet->MeasureParameters.StopEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StopEventNum++;
			  }// if GetCheckBox
			  break;
		  case ControlEvent_STOP_WaitStopReady:
			  GetMet->MeasureParameters.StopEventMode[i] = ControlSignalModeIN;
			  GetMet->MeasureParameters.StopEventCode[i] = ControlSignal_IN_Stopped;
			  if (GetCheckBox (MethodMainWidget, "MethodControlSTOPReadyCheckButton")) {
				  GetMet->MeasureParameters.StopEventEnabled[i] = TRUE;
				  GetMet->MeasureParameters.StopEventTime[i] = GetSpinButtonInt (MethodMainWidget, "MethodControlSTOPReadySpinButton");
				  GetMet->MeasureParameters.StopEventNum++;
			  }// if GetCheckBox
			  break;
	  } // switch (i)
  } // i ControlEvent_STOP_Num
// Control - Runtime events
// Control - Temperature
// Control - Gradient
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	case InstrumentWorkstation :
	case InstrumentDataStation :
	  GetMet->MeasureEvents.GradientEnable = GetCheckBox (MethodMainWidget, "MethodControlGradientEnableCheckButton");
	  //SetSpinButtonValue (MethodMainWidget, "MethodControlGradientEventNumSpinButton", SetMet->MeasureEvents.GradientEventNum);
	  //SetSpinButtonValue (MethodMainWidget, "MethodControlGradientComponentsSpinButton", SetMet->MeasureEvents.GradientComponentNum);
	  GetMet->MeasureEvents.GradientFlowRate = GetSpinButtonFloat (MethodMainWidget, "MethodControlGradientFlowRateSpinButton");
	  GetMet->MeasureEvents.GradientMaxFlowRate = GetSpinButtonFloat (MethodMainWidget, "MethodControlGradientMaxFlowRateSpinButton");
		break;
	case InstrumentTR541 :
	case InstrumentTR542 :
	case InstrumentTR930 :
		break;
  } // switch

// INSTRUMENT DATA
// Instrument data - COMMON
  strcpy (GetMet->InstrumentData.Instrument, GetEntry (MethodMainWidget, "MethodInstrumentCommonNameEntry"));
  strcpy (GetMet->InstrumentData.InstrumentSerNo, GetEntry (MethodMainWidget, "MethodInstrumentCommonInstrSerNoEntry"));
  strcpy (GetMet->InstrumentData.Autosampler, GetEntry (MethodMainWidget, "MethodInstrumentCommonAutosamplerEntry"));
  strcpy (GetMet->InstrumentData.AutosamplerSerNo, GetEntry (MethodMainWidget, "MethodInstrumentCommonSamplerSerNoEntry"));
  strcpy (GetMet->InstrumentData.SystemController, GetEntry (MethodMainWidget, "MethodInstrumentCommonSysContEntry"));
  strcpy (GetMet->InstrumentData.SystemControllerSerNo, GetEntry (MethodMainWidget, "MethodInstrumentCommonSysContSerNoEntry"));
  strcpy (GetMet->InstrumentData.Detector, GetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorEntry"));
  strcpy (GetMet->InstrumentData.DetectorSerNo, GetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorSerNoEntry"));
  strcpy (GetMet->InstrumentData.DetectorSettings, GetEntry (MethodMainWidget, "MethodInstrumentCommonDetectorSettingsEntry"));
  strcpy (GetMet->InstrumentData.Temperature, GetEntry (MethodMainWidget, "MethodInstrumentCommonTemperatureSettingsEntry"));
// Instrument data - GC
  strcpy (GetMet->InstrumentData.CarrierGas, GetEntry (MethodMainWidget, "MethodInstrumentSpecificGCCarrierEntry"));
// Instrument data - HPLC
  strcpy (GetMet->InstrumentData.Eluent, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCEluentEntry"));
  strcpy (GetMet->InstrumentData.Pump, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCPumpEntry"));
  strcpy (GetMet->InstrumentData.PumpSerNo, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCPumpSerNoEntry"));
  strcpy (GetMet->InstrumentData.GradientMixer, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCGradientEntry"));
  strcpy (GetMet->InstrumentData.GradMixSerNo, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCGradientSerNoEntry"));
  strcpy (GetMet->InstrumentData.FractionCollector, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCFractionEntry"));
  strcpy (GetMet->InstrumentData.FractCollSerNo, GetEntry (MethodMainWidget, "MethodInstrumentSpecificHPLCFractionSerNoEntry"));
// Instrument data - TLC
  strcpy (GetMet->InstrumentData.Sampler, GetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCSamplerEntry"));
  strcpy (GetMet->InstrumentData.SamplerSerNo, GetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCSamplerSerNoEntry"));
  strcpy (GetMet->InstrumentData.DeveloperDevice, GetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperEntry"));
  strcpy (GetMet->InstrumentData.DeveloperSerNo, GetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperSerNoEntry"));
  strcpy (GetMet->InstrumentData.DeveloperSettings, GetEntry (MethodMainWidget, "MethodInstrumentSpecificTLCDeveloperSettingsEntry"));

// COLUMN DATA
// Column data - COMMON
  strcpy (GetMet->InstrumentData.Description, GetEntry (MethodMainWidget, "MethodColumnCommonDescriptionEntry"));
  strcpy (GetMet->InstrumentData.Manufacturer, GetEntry (MethodMainWidget, "MethodColumnCommonManufacturerEntry"));
  strcpy (GetMet->InstrumentData.Product, GetEntry (MethodMainWidget, "MethodColumnCommonProductEntry"));
  strcpy (GetMet->InstrumentData.Serial, GetEntry (MethodMainWidget, "MethodColumnCommonSerialEntry"));
  strcpy (GetMet->InstrumentData.Batch, GetEntry (MethodMainWidget, "MethodColumnCommonBatchEntry"));
// Column data - GC/HPLC
  strcpy (GetMet->InstrumentData.Diameter, GetEntry (MethodMainWidget, "MethodColumnGCHPLCDiameterEntry"));
  strcpy (GetMet->InstrumentData.Particle, GetEntry (MethodMainWidget, "MethodColumnGCHPLCParticleEntry"));
  strcpy (GetMet->InstrumentData.Length, GetEntry (MethodMainWidget, "MethodColumnGCHPLCLengthEntry"));
// Column data - TLC
  strcpy (GetMet->InstrumentData.Size, GetEntry (MethodMainWidget, "MethodColumnTLCSizeEntry"));
  strcpy (GetMet->InstrumentData.Thickness, GetEntry (MethodMainWidget, "MethodColumnTLCThicknessEntry"));
  strcpy (GetMet->InstrumentData.Fluorescent, GetEntry (MethodMainWidget, "MethodColumnTLCFluorescentEntry"));
  strcpy (GetMet->InstrumentData.Base, GetEntry (MethodMainWidget, "MethodColumnTLCBaseEntry"));

// VALIDATION
// Validation - Verification
  strcpy (GetMet->InstrumentData.LastVerified, GetEntry (MethodMainWidget, "MethodValidationLastVerifiedEntry"));
  GetMet->InstrumentData.LastVerifiedDate = GetDateTime (MethodMainWidget, "MethodValidationLastVerifiedDateEdit");
  strcpy (GetMet->InstrumentData.VerificationValid, GetEntry (MethodMainWidget, "MethodValidationVerificationValidEntry"));
  GetMet->InstrumentData.VerificationValidDate = GetDateTime (MethodMainWidget, "MethodValidationVerificationValidDateEdit");
  strcpy (GetMet->InstrumentData.VerificationId, GetEntry (MethodMainWidget, "MethodValidationVerificationIDEntry"));
// Validation User data
  strcpy (GetMet->InstrumentData.Operator, GetEntry (MethodMainWidget, "MethodValidationUserOperatorEntry"));
  strcpy (GetMet->InstrumentData.Labor, GetEntry (MethodMainWidget, "MethodValidationUserLaborEntry"));

// USER SPECIFIED
// User specified - instrument parameters
  strcpy (GetMet->InstrumentData.Free1QI, GetEntry (MethodMainWidget, "MethodUserInstrumentQ1Entry"));
  strcpy (GetMet->InstrumentData.Free1AI, GetEntry (MethodMainWidget, "MethodUserInstrumentA1Entry"));
  strcpy (GetMet->InstrumentData.Free2QI, GetEntry (MethodMainWidget, "MethodUserInstrumentQ2Entry"));
  strcpy (GetMet->InstrumentData.Free2AI, GetEntry (MethodMainWidget, "MethodUserInstrumentA2Entry"));
  strcpy (GetMet->InstrumentData.Free3QI, GetEntry (MethodMainWidget, "MethodUserInstrumentQ3Entry"));
  strcpy (GetMet->InstrumentData.Free3AI, GetEntry (MethodMainWidget, "MethodUserInstrumentA3Entry"));
  strcpy (GetMet->InstrumentData.Free4QI, GetEntry (MethodMainWidget, "MethodUserInstrumentQ4Entry"));
  strcpy (GetMet->InstrumentData.Free4AI, GetEntry (MethodMainWidget, "MethodUserInstrumentA4Entry"));
// User specified - column parameters
  strcpy (GetMet->InstrumentData.Free1Q, GetEntry (MethodMainWidget, "MethodUserColumnQ1Entry"));
  strcpy (GetMet->InstrumentData.Free1A, GetEntry (MethodMainWidget, "MethodUserColumnA1Entry"));
  strcpy (GetMet->InstrumentData.Free2Q, GetEntry (MethodMainWidget, "MethodUserColumnQ2Entry"));
  strcpy (GetMet->InstrumentData.Free2A, GetEntry (MethodMainWidget, "MethodUserColumnA2Entry"));
  strcpy (GetMet->InstrumentData.Free3Q, GetEntry (MethodMainWidget, "MethodUserColumnQ3Entry"));
  strcpy (GetMet->InstrumentData.Free3A, GetEntry (MethodMainWidget, "MethodUserColumnA3Entry"));
  strcpy (GetMet->InstrumentData.Free4Q, GetEntry (MethodMainWidget, "MethodUserColumnQ4Entry"));
  strcpy (GetMet->InstrumentData.Free4A, GetEntry (MethodMainWidget, "MethodUserColumnA4Entry"));

  Method = gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "Method");
  memcpy (Method, GetMet, sizeof (struct MethodStruct));
} // GetMethodWidgets

extern void
GetReprocessMethodWidgets (GtkWidget *MethodMainWidget) {
struct MethodStruct *GetMet;
struct MethodStruct *Method;
int i;

  GetMet = gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "MethodWork");

// DATA PROCESSING
// Data processing - COMMON
  GetMet->MeasureParameters.SmoothMethod = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MethodMainWidget, "MethodDataProcNoiseFilterTypeComboBox")));
  switch (GetMet->MeasureParameters.SmoothMethod) {
	  case SmoothTriangle:
		  if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleNoneRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 0;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleWeakRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 1;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleMediumRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 2;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleStrongRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 3;
		  else if (GetCheckBox (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserRadioButton")) GetMet->MeasureParameters.SmoothFactor1 = 4;
		  GetMet->MeasureParameters.SmoothFactor2 = GetSpinButtonInt (MethodMainWidget, "MethodDataProcNoiseFilterTriangleUserSpinButton");
		  break;
  } // switch SmoothMethod


  Method = gtk_object_get_data (GTK_OBJECT (MethodMainWidget), "Method");
  memcpy (Method, GetMet, sizeof (struct MethodStruct));
} // GetReprocessMethodWidgets
