extern void
PresetMeasureWidgets (int ActualMeasWin) {
int i;
char *TitleStr;
GtkWidget		*MeasureNotebook;
GtkWidget		*MeasureWorkstationMenu;
static GnomeUIInfo MeasureWorkstationMenu_uiinfo[MaxDetectors + 1] = {
  {
    GNOME_APP_UI_ITEM, NULL,
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, NULL,
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, NULL,
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, NULL,
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
}; // MeasureWorkstationMenu_uiinfo

  TitleStr = alloca (200);
  ADSI_UP (MeasureWindow, ActualMeasWin);
  DATASOURCE_UP (MeasureWindow, ActualMeasWin);
  gtk_object_set_data (GTK_OBJECT (MeasureWindow), "ActualMeasWin", GINT_TO_POINTER(ActualMeasWin));
  gtk_object_set_data (GTK_OBJECT (MeasureWindow), "SelectedQueueItem", GINT_TO_POINTER(-1));
  MeasureNotebook = lookup_widget (MeasureWindow, "MeasureNotebook");

  if (MeasureNotebook == NULL) {
	PRINTF ("*** (MeasureNotebook == NULL) failed\n",0);
	return;
  } // MeasureNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (MeasureNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (MeasureNotebook), FALSE);
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), "None");
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	sprintf (TitleStr, "%s:%s", "Chromatographic Workstation Measure", LC2.Instruments[ActualInstrument].Instrument[ActualMeasWin].InstrumentName);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), TitleStr);
	HideWidget (MeasureWindow, "MeasureViewScanButton");
	// HideWidget (MeasureWindow, "MeasureQueueButton");
	HideWidget (MeasureWindow, "MeasureSpectraButton");
	SetSpinButtonValue (MeasureWindow, "MeasureWorkstationAttenuatorSpinButton", Options[0].MeasureAttenuator[Chrom[ActualMeasWin].ActualDetector]);
	SetSpinButtonValue (MeasureWindow, "MeasureWorkstationShiftSpinButton", Options[0].MeasureShift[Chrom[ActualMeasWin].ActualDetector]);
	SetSpinButtonValue (MeasureWindow, "MeasureWorkstationTimeSpinButton", Options[0].MeasureAxisTime);
	SetCheckBox (MeasureWindow, "MeasureWorkstationAllCheckButton", Options[0].ShowAllDetectors);
	// SetSpinButtonValue (MeasureWindow, "MeasureWorkstationValueSpinButton", WorkstationAxisValue);
	MeasureWorkstationMenu = lookup_widget (MeasureWindow, "MeasureWorkstationMenu");
	for (i = 0; i < WorkInstrument[0].NumDetectors; i++) {
		MeasureWorkstationMenu_uiinfo[i].type = GNOME_APP_UI_ITEM;
		MeasureWorkstationMenu_uiinfo[i].label = WorkInstrument[0].Detectors[i].Name;
		  DetectorColors[0][i].red = Options[0].red[i];
		  DetectorColors[0][i].green = Options[0].green[i];
		  DetectorColors[0][i].blue = Options[0].blue[i];
		  gdk_colormap_alloc_color (DrawColormap, &DetectorColors[0][i], TRUE, TRUE);
	} // i
	MeasureWorkstationMenu_uiinfo[i].type = GNOME_APP_UI_ENDOFINFO;
	gnome_app_fill_menu (GTK_MENU_SHELL (MeasureWorkstationMenu), MeasureWorkstationMenu_uiinfo, NULL, FALSE, 0);
	gtk_option_menu_set_history(GTK_OPTION_MENU (lookup_widget (MeasureWindow, "MeasureWorkstationOptionMenu")), 0);
	gtk_widget_show (MeasureWorkstationMenu);
	SetCheckBox (MeasureWindow, "MeasureWorkstationInfoCheckButton", Options[ActualMeasWin].ShowMeasureFilenames);
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Multi-instrument Data Station Measure");
	SetCheckBox (MeasureWindow, "MeasureWorkstationInfoCheckButton", Options[ActualMeasWin].ShowMeasureFilenames);
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR541a Measure");
	gtk_object_set_data (GTK_OBJECT (MeasureWindow), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusIdle));
	gtk_object_set_data (GTK_OBJECT (MeasureWindow), "TR541SelectedTrack", GINT_TO_POINTER(1));
	HideWidget (MeasureWindow, "MeasureOpenButton");
	HideWidget (MeasureWindow, "MeasureCloseButton");
	HideWidget (MeasureWindow, "MeasureShowLastButton");
	HideWidget (MeasureWindow, "MeasureSpectraButton");
	HideWidget (MeasureWindow, "MeasureQueueRunButton");
	HideWidget (MeasureWindow, "MeasureQueueStopButton");
	HideWidget (MeasureWindow, "MeasureQueueSettingsButton");
	HideWidget (MeasureWindow, "MeasureQueuePreferencesButton");
	HideWidget (MeasureWindow, "MeasureQueueCalibrationButton");
	HideWidget (MeasureWindow, "MeasureQueueRunStopToolbar");
	HideWidget (MeasureWindow, "MeasureQueueSettingsToolbar");
//	HideWidget (MeasureWindow, "");
	SetSpinButtonValue (MeasureWindow, "MeasureTR541SelectedTrackSpinButton", 1);
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR542 Measure");
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR930 Measure");
		break;
  } // switch
  
  
  MeasureQueueListNeedRefresh[ActualMeasWin] = TRUE;
} // PresetMeasureWidgets

extern void
ActivateMeasureWidgets (int ActualMeasWin) {
GtkWidget *ActiveMeasureWindow;
int TmpInt;
int SelectedQueueItem;

ActiveMeasureWindow = MeasureWindows[ActualMeasWin];

TR541_MEASURE_STATUS(ActiveMeasureWindow);

  SelectedQueueItem = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "SelectedQueueItem"));

  ActivateWidget (ActiveMeasureWindow, "MeasureNewButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureOpenButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureCloseButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureViewScanButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureStartButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureBreakButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureFinishButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureShowLastButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureSpectraButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureServiceButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasurePreferencesButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureErrorButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueRunButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueStopButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueRepeatButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueReprocessButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueCalibrationButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueAnalyzeButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueuePrintButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueueSettingsButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureQueuePreferencesButton", FALSE);
  // Workstation
  ActivateWidget (ActiveMeasureWindow, "MeasureWorkstationResetMonitoringButton", FALSE);
  // TR541
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackAddButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackRemoveButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackUpButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackDownButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackStretchButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackShrinkButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541SelectedTrackSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackPositionSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackWidthSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ShortScanCheckButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541NormXSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541NormYSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StartXSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StopXSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StartYSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StopYSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanWavelengthOptionMenu", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanFluorescenceCheckBox", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanReflectanceRadioButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanTransmittanceRadioButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorPicker", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorSpinButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorAutoscaleButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorRedrawButton", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorPicker", FALSE);
  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorSpinButton", FALSE);

  switch (WorkInstruments.InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	case InstrumentDataStation :
	  if (ThreadStatus[ActualMeasWin] == ThreadStatusIdle) {
		  ActivateWidget (ActiveMeasureWindow, "MeasureStartButton", TRUE);
		  ActivateWidget (ActiveMeasureWindow, "MeasurePreferencesButton", TRUE);
		  ActivateWidget (ActiveMeasureWindow, "MeasureServiceButton", TRUE);
		  ActivateWidget (ActiveMeasureWindow, "MeasureWorkstationResetMonitoringButton", TRUE);
		  if (Chrom[ActualMeasWin].FileLoaded[LayFlag])
			  ActivateWidget (ActiveMeasureWindow, "MeasureCloseButton", TRUE);
	  } // ThreadStatusIdle
	  pthread_mutex_lock (&measure_parameter_mutex);
	  TmpInt = strlen(Chrom[ActualMeasWin].LastName);
	  pthread_mutex_unlock (&measure_parameter_mutex);
	  if (TmpInt > 0)
		  ActivateWidget (ActiveMeasureWindow, "MeasureShowLastButton", TRUE);
	  switch (Options[ActualMeasWin].DataAcqMode) {
		  case MeasureRunModeUnique:
			  if (ThreadStatus[ActualMeasWin] != ThreadStatusIdle) {
				  ActivateWidget (ActiveMeasureWindow, "MeasureBreakButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureFinishButton", TRUE);
			  } // !ThreadStatusIdle
			  break;
		  case MeasureRunModeQueue:
			  if (!Chrom[ActualMeasWin].FileLoaded[LayFlag]) {
				  ActivateWidget (ActiveMeasureWindow, "MeasureNewButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureOpenButton", TRUE);
			  } // 
			  if ((ThreadStatus[ActualMeasWin] != ThreadStatusIdle) &&\
				  (ThreadStatus[ActualMeasWin] != ThreadStatusSuspended)){
				  ActivateWidget (ActiveMeasureWindow, "MeasureBreakButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureFinishButton", TRUE);
				  if (ThreadSuspendFlag[ActualMeasWin])
					  ActivateWidget (ActiveMeasureWindow, "MeasureQueueRunButton", TRUE);
				  else
					  ActivateWidget (ActiveMeasureWindow, "MeasureQueueStopButton", TRUE);
			  } // !ThreadStatusIdle && !ThreadStatusSuspended
			  if ((ThreadStatus[ActualMeasWin] != ThreadStatusIdle) &&\
				  (ThreadStatus[ActualMeasWin] == ThreadStatusSuspended)){
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueueRunButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureCloseButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueueButton", TRUE);
			  } // !ThreadStatusIdle && ThreadStatusSuspended
			  if (SelectedQueueItem > -1) {
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueueRepeatButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueueReprocessButton", TRUE);
				  if (Chrom[ActualMeasWin].FileLoaded[CalFlag])
					  ActivateWidget (ActiveMeasureWindow, "MeasureQueueAnalyzeButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueuePrintButton", TRUE);
			  } // SelectedQueueItem > -1
			  if (Chrom[ActualMeasWin].FileLoaded[CalFlag]) {
				  ActivateWidget (ActiveMeasureWindow, "MeasureQueueCalibrationButton", TRUE);
			  } // CalFlag
			  break;
		  case MeasureRunModeContinous:
			  if (ThreadStatus[ActualMeasWin] != ThreadStatusIdle) {
				  ActivateWidget (ActiveMeasureWindow, "MeasureBreakButton", TRUE);
				  ActivateWidget (ActiveMeasureWindow, "MeasureFinishButton", TRUE);
			  } // !ThreadStatusIdle
			  break;
	  } // DataAcqMode
		break; // InstrumentWorkstation, InstrumentDataStation
	case InstrumentTR541 :
		switch (TR541MeasureStatus) {
			case TR540MeasureStatusIdle:
			  ActivateWidget (ActiveMeasureWindow, "MeasureNewButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureServiceButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasurePreferencesButton", TRUE);
				break; // TR540MeasureStatusIdle
			case TR540MeasureStatusNew:
			  ActivateWidget (ActiveMeasureWindow, "MeasureNewButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureViewScanButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ShortScanCheckButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541NormXSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541NormYSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StartYSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StopYSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanWavelengthOptionMenu", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanFluorescenceCheckBox", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanReflectanceRadioButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ScanTransmittanceRadioButton", TRUE);
				break;
			case TR540MeasureStatusViewScan:
			  ActivateWidget (ActiveMeasureWindow, "MeasureBreakButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureFinishButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureQueueButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackAddButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackRemoveButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackUpButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackDownButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackStretchButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackShrinkButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541SelectedTrackSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackPositionSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackWidthSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorAutoscaleButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorRedrawButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorSpinButton", TRUE);
				break;
			case TR540MeasureStatusViewScanReady:
			  ActivateWidget (ActiveMeasureWindow, "MeasureQueueButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StartXSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StopXSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackAddButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackRemoveButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackUpButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackDownButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackStretchButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackShrinkButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541SelectedTrackSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackPositionSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackWidthSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorAutoscaleButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorRedrawButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorSpinButton", TRUE);
				break;
			case TR540MeasureStatusQueueOk:
			  ActivateWidget (ActiveMeasureWindow, "MeasureQueueButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StartXSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541StopXSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureStartButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackAddButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackRemoveButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackUpButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackDownButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackStretchButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackShrinkButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541SelectedTrackSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackPositionSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541TrackWidthSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541UpperColorSpinButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorAutoscaleButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541ColorRedrawButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorPicker", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureTR541LowerColorSpinButton", TRUE);
				break;
			case TR540MeasureStatusReady:
			  ActivateWidget (ActiveMeasureWindow, "MeasureNewButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasureServiceButton", TRUE);
			  ActivateWidget (ActiveMeasureWindow, "MeasurePreferencesButton", TRUE);
				break;
			case TR540MeasureStatusError:
			  ActivateWidget (ActiveMeasureWindow, "MeasureErrorButton", TRUE);
				break;
			case TR540MeasureStatusAllInactive:
				break;
		} // switch TR541MeasureStatus
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
} // ActivateMeasureWidgets

extern void
PresetMeasureErrorWidgets (void) {
GtkWidget		*MeasureErrorNotebook;

  MeasureErrorNotebook = lookup_widget (MeasureErrorDialog, "MeasureErrorDialogNotebook");
  if (MeasureErrorNotebook == NULL) {
	PRINTF ("*** (MeasureErrorNotebook == NULL) failed\n",0);
	return;
  } // MeasureErrorNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (MeasureErrorNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (MeasureErrorNotebook), FALSE);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "None");
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Chromatographic Workstation Measure");
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Multi-instrument Data Station Measure");
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR541a Measure");
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR542 Measure");
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureErrorNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR930 Measure");
		break;
  } // switch
} // PresetMeasureErrorWidgets

extern void
GetTR541Widgets (GtkWidget *MeasureWidget, struct MethodStruct *Method) {
guint16 red;
guint16 green;
guint16 blue;
guint16 alpha;

  Method->TR540Parameters.TR540SelectedFilter = GetOptionMenuIndex (MeasureWidget, "MeasureTR541ScanWavelengthOptionMenu");
  //Method->TR540Parameters.TR540Filters[]
  Method->TR540Parameters.TR540HalfSizeScan = GetCheckBox (MeasureWidget, "MeasureTR541ShortScanCheckButton");
  Method->TR540Parameters.TR540TrackWidth = GetSpinButtonInt (MeasureWidget, "MeasureTR541TrackWidthSpinButton");

  Method->MeasureParameters.Nmp = 1000;
  Method->MeasureParameters.SamplingRate = 0.2;
  Method->MeasureParameters.DigitalResolution = 0xFFFF;
  Method->MeasureParameters.NormX = GetSpinButtonInt (MeasureWidget, "MeasureTR541NormXSpinButton");
  Method->MeasureParameters.NormY = GetSpinButtonInt (MeasureWidget, "MeasureTR541NormYSpinButton");
  Method->MeasureParameters.ViewScanYStart = GetSpinButtonInt (MeasureWidget, "MeasureTR541StartYSpinButton");
  Method->MeasureParameters.ViewScanYStop = GetSpinButtonInt (MeasureWidget, "MeasureTR541StopYSpinButton");
  Method->MeasureParameters.ScanStartX = GetSpinButtonInt (MeasureWidget, "MeasureTR541StartXSpinButton");
  Method->MeasureParameters.ScanStopX = GetSpinButtonInt (MeasureWidget, "MeasureTR541StopXSpinButton");
  Method->MeasureParameters.ScanResol = 0.2;

  SetSpinButtonValue (MeasureWidget, "MeasureTR541LowerColorSpinButton", Method->MeasureParameters.ViewMin);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541UpperColorSpinButton", Method->MeasureParameters.ViewMax);
  gnome_color_picker_get_i16 (GNOME_COLOR_PICKER(lookup_widget (MeasureWidget, "MeasureTR541LowerColorPicker")), \
							  &red, &green, &blue, &alpha);
  Method->MeasureParameters.ViewMinColor.red = red;
  Method->MeasureParameters.ViewMinColor.green = green;
  Method->MeasureParameters.ViewMinColor.blue = blue;
  gnome_color_picker_get_i16 (GNOME_COLOR_PICKER(lookup_widget (MeasureWidget, "MeasureTR541UpperColorPicker")), \
							  &red, &green, &blue, &alpha);
  Method->MeasureParameters.ViewMaxColor.red = red;
  Method->MeasureParameters.ViewMaxColor.green = green;
  Method->MeasureParameters.ViewMaxColor.blue = blue;

  Chrom[0].TR541RawDataArrayBeg = Method->MeasureParameters.ViewScanYStart - 1;
} // GetTR541Widgets

extern void
SetTR541Widgets (GtkWidget *MeasureWidget, struct MethodStruct *Method) {
guint16 red;
guint16 green;
guint16 blue;
int SelectedTrack;

  DATASOURCE (MeasureWidget);
  ADSI(MeasureWidget);

  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MeasureWidget), "TR541SelectedTrack"));
  if (SelectedTrack < 1)
	  SelectedTrack = 1;

  SetOptionMenuIndex (MeasureWidget, "MeasureTR541ScanWavelengthOptionMenu", Method->TR540Parameters.TR540SelectedFilter);
  //Method->TR540Parameters.TR540Filters[]
  SetCheckBox (MeasureWidget, "MeasureTR541ShortScanCheckButton", Method->TR540Parameters.TR540HalfSizeScan);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541TrackWidthSpinButton", Method->TR540Parameters.TR540TrackWidth);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition);

  Method->MeasureParameters.Nmp = 1000;
  Method->MeasureParameters.SamplingRate = 0.2;
  Method->MeasureParameters.DigitalResolution = 0xFFFF;
  SetSpinButtonValue (MeasureWidget, "MeasureTR541NormXSpinButton", Method->MeasureParameters.NormX);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541NormYSpinButton", Method->MeasureParameters.NormY);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541StartYSpinButton", Method->MeasureParameters.ViewScanYStart);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541StopYSpinButton", Method->MeasureParameters.ViewScanYStop);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541StartXSpinButton", Method->MeasureParameters.ScanStartX);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541StopXSpinButton", Method->MeasureParameters.ScanStopX);
  Method->MeasureParameters.ScanResol = 0.2;

  SetSpinButtonValue (MeasureWidget, "MeasureTR541LowerColorSpinButton", Method->MeasureParameters.ViewMin);
  SetSpinButtonValue (MeasureWidget, "MeasureTR541UpperColorSpinButton", Method->MeasureParameters.ViewMax);
  red = Method->MeasureParameters.ViewMinColor.red;
  green = Method->MeasureParameters.ViewMinColor.green;
  blue = Method->MeasureParameters.ViewMinColor.blue;
  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(lookup_widget (MeasureWidget, "MeasureTR541LowerColorPicker")), red, green, blue, 0);
  red = Method->MeasureParameters.ViewMaxColor.red;
  green = Method->MeasureParameters.ViewMaxColor.green;
  blue = Method->MeasureParameters.ViewMaxColor.blue;
  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(lookup_widget (MeasureWidget, "MeasureTR541UpperColorPicker")), red, green, blue, 0);

  Chrom[ActualDSInstrument].TR541RawDataArrayBeg = Method->MeasureParameters.ViewScanYStart - 1;
} // SetTR541Widgets

extern void
RefreshMeasureQueueList (int DataSource) {
int i, j;
GtkWidget *MQList;
GtkWidget *MWindow;
char *RowData[3];

  if (DataSource < 0) return;
  if (DataSource >= MaxInstrument) return;

  MWindow = MeasureWindows[DataSource];
  MQList = lookup_widget (MWindow, "MeasureQueueCList");
  gtk_clist_clear (GTK_CLIST(MQList));
  if (!Chrom[DataSource].FileLoaded[LayFlag]) return;
  
  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(1200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  
  pthread_mutex_lock (&measure_parameter_mutex);
  
  gtk_clist_freeze (GTK_CLIST (MQList));
  for (i=0; i<Chrom[DataSource].QueueHead.QueueItemNum; i++)
  {
	  GetQueueItem (DataSource, i);
	  sprintf (RowData[0],"%d",i+1);
	  switch (WorkInstruments.InstrumentType) {
		case InstrumentNone :
			break;
		case InstrumentWorkstation :
		case InstrumentDataStation :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.SamplerPosition);
			break;
		case InstrumentTR541 :
		case InstrumentTR542 :
		case InstrumentTR930 :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.TrackPosition);
			break;
	  } // switch
	  sprintf (RowData[2],"%s.%s",Chrom[DataSource].QueueItem.BaseFileName \
			  ,Chrom[DataSource].QueueItem.BaseExtName);
	  /*
	  switch (Chrom[DataSource].QueueItem.SampleType) {
		  case SampleTypeSample:
			  sprintf (RowData[4],"Sample");
			  break;
		  case SampleTypeControl:
			  sprintf (RowData[4],"Control");
			  break;
		  case SampleTypeStandard:
			  sprintf (RowData[4],"Standard");
			  break;
		  case SampleTypeRetControl:
			  sprintf (RowData[4],"RetControl");
			  break;
	  }
	  */
	  gtk_clist_append (GTK_CLIST(MQList),RowData);
	  if (Chrom[DataSource].QueueItem.QueueItemLocked) {
		  gtk_clist_set_foreground (GTK_CLIST (MQList), i, &MQListLockedFGColor);
		  gtk_clist_set_background (GTK_CLIST (MQList), i, &MQListLockedBGColor);
	  } // QueueItemLocked
  } // for i
  gtk_clist_thaw (GTK_CLIST (MQList));
  
  pthread_mutex_unlock (&measure_parameter_mutex);
  
} // RefreshMeasureQueueList
