// Widget functions

extern int
SelectedCentralInstrument (void) {
int	SCI;

  SCI = 1;

  if (GetCheckBox (CentralWindow, "CentralInstrumentRadioButton1")) SCI = 1;
  if (GetCheckBox (CentralWindow, "CentralInstrumentRadioButton2")) SCI = 2;
  if (GetCheckBox (CentralWindow, "CentralInstrumentRadioButton3")) SCI = 3;
  if (GetCheckBox (CentralWindow, "CentralInstrumentRadioButton4")) SCI = 4;

  return SCI;
} // SelectedCentralInstrument

extern void
ActivateCentralWidgets (void) {
GtkTextBuffer	*TextBuffer;
GtkWidget			*TextView;
GtkWidget			*Radio1;
gchar				*TextString;
gchar				*UTF8String;
gsize				BytesRead;
gsize				BytesWrite;

  TextString = alloca (1000);

  ActivateWidget (CentralWindow, "CentralNewButton", TRUE);
  ActivateWidget (CentralWindow, "CentralPreferencesButton", TRUE);
  ActivateWidget (CentralWindow, "CentralAboutButton", TRUE);
  ActivateWidget (CentralWindow, "CentralExitButton", TRUE);

  if (LC2.NumberOfInstruments == MaxInstruments)
	  ActivateWidget (CentralWindow, "CentralAddInstrument", FALSE);
  else
	  ActivateWidget (CentralWindow, "CentralAddInstrument", TRUE);

  if (LC2.NumberOfInstruments == 0)
	  ActivateWidget (CentralWindow, "CentralRemoveInstrument", FALSE);
  else
	  ActivateWidget (CentralWindow, "CentralRemoveInstrument", TRUE);

  if (LC2.NumberOfInstruments == 0)
	  ActivateWidget (CentralWindow, "CentralSetupInstrument", FALSE);
  else
	  ActivateWidget (CentralWindow, "CentralSetupInstrument", TRUE);

  if (LC2.NumberOfInstruments == 0)
	  ActivateWidget (CentralWindow, "CentralInstrumentRestart", FALSE);
  else
	  ActivateWidget (CentralWindow, "CentralInstrumentRestart", TRUE);

  Radio1 = lookup_widget (CentralWindow, "CentralInstrumentRadioButton1");
  if (SelectedCentralInstrument () > LC2.NumberOfInstruments) gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (Radio1), TRUE);

  TextView = lookup_widget (CentralWindow, "CentralTextView4");
  TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (TextView));
  if (LC2.NumberOfInstruments < 4) {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton4", FALSE);
  ActivateWidget (CentralWindow, "CentralStop4", FALSE);
  ActivateWidget (CentralWindow, "CentralStart4", FALSE);
  gtk_text_buffer_set_text (TextBuffer, "", -1);
  } else {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton4", TRUE);
  if (PIDTable[4] == 0) {
	ActivateWidget (CentralWindow, "CentralStop4", FALSE);
	ActivateWidget (CentralWindow, "CentralStart4", TRUE);
  } else {
	ActivateWidget (CentralWindow, "CentralStop4", TRUE);
	ActivateWidget (CentralWindow, "CentralStart4", FALSE);
  } // PIDTable == 0
  sprintf (TextString, "Instrument: %s\nPort: %s", LC2.Instruments[4].Instrument[0].InstrumentName, LC2.Instruments[4].ADParameters.ADIOPortName);
  UTF8String = g_convert (TextString, strlen (TextString), "UTF8", "ISO-8859-2", &BytesRead, &BytesWrite, NULL);
  gtk_text_buffer_set_text (TextBuffer, UTF8String, -1);
  g_free (UTF8String);
  } // 4

  TextView = lookup_widget (CentralWindow, "CentralTextView3");
  TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (TextView));
  if (LC2.NumberOfInstruments < 3) {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton3", FALSE);
  ActivateWidget (CentralWindow, "CentralStop3", FALSE);
  ActivateWidget (CentralWindow, "CentralStart3", FALSE);
  gtk_text_buffer_set_text (TextBuffer, "", -1);
  } else {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton3", TRUE);
  if (PIDTable[3] == 0) {
	ActivateWidget (CentralWindow, "CentralStop3", FALSE);
	ActivateWidget (CentralWindow, "CentralStart3", TRUE);
  } else {
	ActivateWidget (CentralWindow, "CentralStop3", TRUE);
	ActivateWidget (CentralWindow, "CentralStart3", FALSE);
  } // PIDTable == 0
  sprintf (TextString, "Instrument: %s\nPort: %s", LC2.Instruments[3].Instrument[0].InstrumentName, LC2.Instruments[3].ADParameters.ADIOPortName);
  UTF8String = g_convert (TextString, strlen (TextString), "UTF8", "ISO-8859-2", &BytesRead, &BytesWrite, NULL);
  gtk_text_buffer_set_text (TextBuffer, UTF8String, -1);
  g_free (UTF8String);
  } // 3

  TextView = lookup_widget (CentralWindow, "CentralTextView2");
  TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (TextView));
  if (LC2.NumberOfInstruments < 2) {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton2", FALSE);
  ActivateWidget (CentralWindow, "CentralStop2", FALSE);
  ActivateWidget (CentralWindow, "CentralStart2", FALSE);
  gtk_text_buffer_set_text (TextBuffer, "", -1);
  } else {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton2", TRUE);
  if (PIDTable[2] == 0) {
	ActivateWidget (CentralWindow, "CentralStop2", FALSE);
	ActivateWidget (CentralWindow, "CentralStart2", TRUE);
  } else {
	ActivateWidget (CentralWindow, "CentralStop2", TRUE);
	ActivateWidget (CentralWindow, "CentralStart2", FALSE);
  } // PIDTable == 0
  sprintf (TextString, "Instrument: %s\nPort: %s", LC2.Instruments[2].Instrument[0].InstrumentName, LC2.Instruments[2].ADParameters.ADIOPortName);
  UTF8String = g_convert (TextString, strlen (TextString), "UTF8", "ISO-8859-2", &BytesRead, &BytesWrite, NULL);
  gtk_text_buffer_set_text (TextBuffer, UTF8String, -1);
  g_free (UTF8String);
  } // 2

  TextView = lookup_widget (CentralWindow, "CentralTextView1");
  TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (TextView));
  if (LC2.NumberOfInstruments < 1) {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton1", FALSE);
  ActivateWidget (CentralWindow, "CentralStop1", FALSE);
  ActivateWidget (CentralWindow, "CentralStart1", FALSE);
  gtk_text_buffer_set_text (TextBuffer, "", -1);
  } else {
  ActivateWidget (CentralWindow, "CentralInstrumentRadioButton1", TRUE);
  if (PIDTable[1] == 0) {
	ActivateWidget (CentralWindow, "CentralStop1", FALSE);
	ActivateWidget (CentralWindow, "CentralStart1", TRUE);
  } else {
	ActivateWidget (CentralWindow, "CentralStop1", TRUE);
	ActivateWidget (CentralWindow, "CentralStart1", FALSE);
  } // PIDTable == 0
  sprintf (TextString, "Instrument: %s\nPort: %s", LC2.Instruments[1].Instrument[0].InstrumentName, LC2.Instruments[1].ADParameters.ADIOPortName);
  UTF8String = g_convert (TextString, strlen (TextString), "UTF8", "ISO-8859-2", &BytesRead, &BytesWrite, NULL);
  gtk_text_buffer_set_text (TextBuffer, UTF8String, -1);
  g_free (UTF8String);
  } // 1

} // ActivateCentralWidgets

extern void
ActivateCentralInstrumentSetupWidgets (GtkWidget *CIS) {
GtkWidget		*ActWidget;
int				Idx;

  Idx = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT (CIS), "SelectedCentralInstrument"));

  SetSpinButtonValue (CIS, "CentralInstrumentSetupNumDSSpinButton", 1);
  ActivateWidget (CIS, "CentralInstrumentSetupNumDSLabel", FALSE);
  ActivateWidget (CIS, "CentralInstrumentSetupNumDSSpinButton", FALSE);

  ActivateWidget (CIS, "CentralInstrumentSetupSamplingLabel", TRUE);
  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", TRUE);
  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", TRUE);
  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);

  ActivateWidget (CIS, "CentralInstrumentSetupOkButton", TRUE);
  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceLabel", TRUE);

  switch (gtk_option_menu_get_history (GTK_OPTION_MENU(lookup_widget (CIS, "CentralInstrumentSetupTypeOptionMenu")))) {
	case InstrumentNone :
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 0);
	// Label deactivate????
	  ActivateWidget (CIS, "CentralInstrumentSetupDetectorLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupOkButton", FALSE);
		break;
	case InstrumentWorkstation :
	  if (GetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu") == 0)
		  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 2);
	  if (GetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu") == 1) {
		  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
	  } else {
		  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMINRadioButton", TRUE);
	  }
	  ActivateWidget (CIS, "CentralInstrumentSetupChromNone", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupDetectorLabel", TRUE);
	  //SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", 3);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", TRUE);
	  ActivateWidget (CIS, "CentralInterfaceADNone", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", TRUE);
		break;
	case InstrumentDataStation :
	  ActivateWidget (CIS, "CentralInstrumentSetupNumDSLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupNumDSSpinButton", TRUE);
	  if (!LC2.Instruments[Idx].NumOfInstrument)
		  SetSpinButtonValue (CIS, "CentralInstrumentSetupNumDSSpinButton", 1);
	  else
		  SetSpinButtonValue (CIS, "CentralInstrumentSetupNumDSSpinButton", LC2.Instruments[Idx].NumOfInstrument);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 0);
	  ActivateWidget (CIS, "CentralInstrumentSetupDetectorLabel", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", 0);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInterfaceADNone", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", FALSE);
		break;
	case InstrumentTR541 :
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 1);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupDetectorLabel", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", 0);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInterfaceADNone", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", FALSE);
		break;
	case InstrumentTR542 :
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 1);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", 0);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInterfaceADNone", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", FALSE);
		break;
	case InstrumentTR930 :
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", 1);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupChromOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupDetectorLabel", FALSE);
	  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", 0);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInterfaceADNone", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", FALSE);
		break;
  } // switch

  switch (GetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu")) {
	  case 0:
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingLabel", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMMRadioButton", FALSE);
		  break;
	  case 1:
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", FALSE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
		  break;
	  case 2:
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMMRadioButton", FALSE);
		  break;
	  case 3:
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingLabel", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMINRadioButton", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingSECRadioButton", TRUE);
	  ActivateWidget (CIS, "CentralInstrumentSetupSamplingMMRadioButton", FALSE);
		  break;
  } // switch

  if (GetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceIOPortOptionMenu"))
	  ActivateWidget (CIS, "CentralInstrumentSetupOkButton", TRUE);
  else
	  ActivateWidget (CIS, "CentralInstrumentSetupOkButton", FALSE);

  switch (GetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu")) {
	  case 0:
	  case 1:
	  case 2:
		  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", 0);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", FALSE);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", FALSE);
		  SetSpinButtonValue (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", 1);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", FALSE);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", FALSE);
		  break;
	  case 3:
	  case 4:
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelLabel", TRUE);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", TRUE);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", TRUE);
		  ActivateWidget (CIS, "CentralInstrumentSetupInterfaceMainChannelLabel", TRUE);
		  break;
  } // switch
} // ActivateCentralInstrumentSetupWidgets

extern void
SetCentralInstrumentSetupWidgets (GtkWidget *CIS) {
GtkWidget		*SignalCList;
gboolean		IconResult;
int				AccessRVal;
int				Idx;
char			*RowData[10];
int				i,j;

  Idx = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT (CIS), "SelectedCentralInstrument"));
  SignalCList = lookup_widget (CIS, "CentralInstrumentSetupSignalCList");

  SetEntry (CIS, "CentralInstrumentSetupNameEntry", LC2.Instruments[Idx].Instrument[0].InstrumentName);
  SetOptionMenuIndex (CIS, "CentralInstrumentSetupTypeOptionMenu", LC2.Instruments[Idx].InstrumentType);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupNumDSSpinButton", LC2.Instruments[Idx].NumOfInstrument);
  SetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu", LC2.Instruments[Idx].Instrument[0].ChromatographType);
  switch (LC2.Instruments[Idx].Instrument[0].SamplingMode) {
	  case InstrumentSamplingInMin:
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMINRadioButton", TRUE);
		  break;
	  case InstrumentSamplingInSec:
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingSECRadioButton", TRUE);
		  break;
	  case InstrumentSamplingInMM:
	  SetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton", TRUE);
		  break;
  } // switch
  AccessRVal = access (LC2.Instruments[Idx].Instrument[0].IconForInstrument, R_OK);
  if (AccessRVal != 0) strcpy (LC2.Instruments[Idx].Instrument[0].IconForInstrument, "/usr/local/share/pixmaps/labchrom2/Instrument.png");
  IconResult = gnome_icon_entry_set_filename (GNOME_ICON_ENTRY (lookup_widget (CIS, "CentralInstrumentSetupIconEntry")) , LC2.Instruments[Idx].Instrument[0].IconForInstrument);
  if (IconResult == FALSE)
	PRINTF ("Icon set filename = FALSE\n",0);
  else
	PRINTF ("Icon set filename = TRUE\n",0);
  SetCheckBox (CIS, "CentralInstrumentSetupAutoStartCheckBox", LC2.Instruments[Idx].AutoStart);

  SetSpinButtonValue (CIS, "CentralInstrumentSetupDetectorNumSpinButton", LC2.Instruments[Idx].Instrument[0].NumDetectors);

  SetEntry (CIS, "CentralInstrumentSetupDet1NameEntry", LC2.Instruments[Idx].Instrument[0].Detectors[0].Name);
  SetEntry (CIS, "CentralInstrumentSetupDet1ExtEntry", LC2.Instruments[Idx].Instrument[0].Detectors[0].Ext);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet1MainSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[0].BindMainChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet1SubSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[0].BindSubChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet1ScaleSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[0].ScaleValue);
  SetEntry (CIS, "CentralInstrumentSetupDet1UnitEntry", LC2.Instruments[Idx].Instrument[0].Detectors[0].ScaleUnit);

  SetEntry (CIS, "CentralInstrumentSetupDet2NameEntry", LC2.Instruments[Idx].Instrument[0].Detectors[1].Name);
  SetEntry (CIS, "CentralInstrumentSetupDet2ExtEntry", LC2.Instruments[Idx].Instrument[0].Detectors[1].Ext);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet2MainSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[1].BindMainChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet2SubSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[1].BindSubChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet2ScaleSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[1].ScaleValue);
  SetEntry (CIS, "CentralInstrumentSetupDet2UnitEntry", LC2.Instruments[Idx].Instrument[0].Detectors[1].ScaleUnit);

  SetEntry (CIS, "CentralInstrumentSetupDet3NameEntry", LC2.Instruments[Idx].Instrument[0].Detectors[2].Name);
  SetEntry (CIS, "CentralInstrumentSetupDet3ExtEntry", LC2.Instruments[Idx].Instrument[0].Detectors[2].Ext);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet3MainSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[2].BindMainChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet3SubSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[2].BindSubChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet3ScaleSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[2].ScaleValue);
  SetEntry (CIS, "CentralInstrumentSetupDet3UnitEntry", LC2.Instruments[Idx].Instrument[0].Detectors[2].ScaleUnit);

  SetEntry (CIS, "CentralInstrumentSetupDet4NameEntry", LC2.Instruments[Idx].Instrument[0].Detectors[3].Name);
  SetEntry (CIS, "CentralInstrumentSetupDet4ExtEntry", LC2.Instruments[Idx].Instrument[0].Detectors[3].Ext);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet4MainSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[3].BindMainChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet4SubSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[3].BindSubChannel);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupDet4ScaleSpinButton", LC2.Instruments[Idx].Instrument[0].Detectors[3].ScaleValue);
  SetEntry (CIS, "CentralInstrumentSetupDet4UnitEntry", LC2.Instruments[Idx].Instrument[0].Detectors[3].ScaleUnit);

  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceIOPortOptionMenu", LC2.Instruments[Idx].ADParameters.ADIOPortMenuIndex);
  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu", LC2.Instruments[Idx].ADParameters.ADDeviceId);
  SetCheckBox (CIS, "CentralInstrumentSetupInterfaceNoCommCheckButton", LC2.Instruments[Idx].ADParameters.ADNoHWCommunication);
  SetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu", LC2.Instruments[Idx].ADParameters.ADChannelMode);
  SetSpinButtonValue (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton", LC2.Instruments[Idx].ADParameters.ADMainChannelNum);

  SetSpinButtonValue (CIS, "CentralInstrumentSetupSignalChannelSpinButton", 1);
  gtk_object_set_data (GTK_OBJECT(CIS), "ActualSignalChannel", GINT_TO_POINTER(1));

  gtk_clist_clear (GTK_CLIST (SignalCList));

  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 2, TRUE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 2, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 3, TRUE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 3, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 4, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 4, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 5, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 5, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 6, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 6, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 7, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 7, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 8, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 8, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 9, FALSE);
  gtk_clist_set_column_justification (GTK_CLIST(SignalCList), 9, GTK_JUSTIFY_CENTER);

  for (i = 0; i < 10; i++) {
	  RowData[i] = alloca (100);
	  strcpy (RowData[i], "");
  } // i

printf ("ControlSignalNum = %d\n", ControlSignalNum);
  for (i = 0; i < ControlSignalNum; i++) {
	  switch (i) {
	  case ControlSignal_IN_GenericEnable:
		  sprintf (RowData[0], "GenericEnable");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_Standard:
		  sprintf (RowData[0], "Standard");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_Standard:
		  sprintf (RowData[0], "Standard");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_Control:
		  sprintf (RowData[0], "Control");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_Control:
		  sprintf (RowData[0], "Control");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_RetControl:
		  sprintf (RowData[0], "RetControl");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_RetControl:
		  sprintf (RowData[0], "RetControl");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_Sampler:
		  sprintf (RowData[0], "Sampler");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_Autozero:
		  sprintf (RowData[0], "Autozero");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_Ready:
		  sprintf (RowData[0], "Ready");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_Start:
		  sprintf (RowData[0], "Start");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_Run:
		  sprintf (RowData[0], "Run");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_CheckSample:
		  sprintf (RowData[0], "CheckSample");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_CheckStandard:
		  sprintf (RowData[0], "CheckStandard");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_CheckControl:
		  sprintf (RowData[0], "CheckControl");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_CheckRetControl:
		  sprintf (RowData[0], "CheckRetControl");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_Overflow:
		  sprintf (RowData[0], "Overflow");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_Warning:
		  sprintf (RowData[0], "Warning");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_Error:
		  sprintf (RowData[0], "Error");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_IN_CheckStop:
		  sprintf (RowData[0], "CheckStop");
		  sprintf (RowData[1], "IN");
		  break;
	  case ControlSignal_OUT_Stop:
		  sprintf (RowData[0], "Stop");
		  sprintf (RowData[1], "OUT");
		  break;
	  case ControlSignal_IN_Stopped:
		  sprintf (RowData[0], "Stopped");
		  sprintf (RowData[1], "IN");
		  break;
	  } // switch (i)
printf ("i = %d,   RowData[0] = %s,   RowData[1] = %s\n", i, RowData[0], RowData[1]);
	  for (j = 0; j < MaxMainChannels; j++) {
		  sprintf (RowData[(j + 1) * 2], "$%.2X", LC2.Instruments[Idx].Instrument[j].ControlSignals[i].Value);
		  sprintf (RowData[(j + 1) * 2 + 1], "%d", !LC2.Instruments[Idx].Instrument[j].ControlSignals[i].ActiveLevel);
	  } // j
  gtk_clist_append (GTK_CLIST(SignalCList),RowData);
  } // i

  gtk_clist_select_row (GTK_CLIST(SignalCList), 0, 0);

} // SetCentralInstrumentSetupWidgets

extern void
RetrieveCentralInstrumentSetupWidgets (GtkWidget *CIS) {
GtkWidget		*GetWidget;
GtkWidget		*SignalCList;
int				ResultCList;
char			*ValueCList;
char			*ValueTemp;
int				i,j;
int				J[4] = {1, 2, 5, 10};
int				Idx;

  Idx = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT (CIS), "SelectedCentralInstrument"));
  SignalCList = lookup_widget (CIS, "CentralInstrumentSetupSignalCList");

  strcpy (LC2.Instruments[Idx].Instrument[0].InstrumentName, GetEntry (CIS, "CentralInstrumentSetupNameEntry"));
  LC2.Instruments[Idx].InstrumentType = GetOptionMenuIndex (CIS, "CentralInstrumentSetupTypeOptionMenu");
  LC2.Instruments[Idx].NumOfInstrument = GetSpinButtonInt (CIS, "CentralInstrumentSetupNumDSSpinButton");
  LC2.Instruments[Idx].Instrument[0].ChromatographType = GetOptionMenuIndex (CIS, "CentralInstrumentSetupChromOptionMenu");
  if (GetCheckBox (CIS, "CentralInstrumentSetupSamplingMINRadioButton"))
	  LC2.Instruments[Idx].Instrument[0].SamplingMode = InstrumentSamplingInMin;
  if (GetCheckBox (CIS, "CentralInstrumentSetupSamplingSECRadioButton"))
	  LC2.Instruments[Idx].Instrument[0].SamplingMode = InstrumentSamplingInSec;
  if (GetCheckBox (CIS, "CentralInstrumentSetupSamplingMMRadioButton"))
	  LC2.Instruments[Idx].Instrument[0].SamplingMode = InstrumentSamplingInMM;
  strcpy (LC2.Instruments[Idx].Instrument[0].IconForInstrument, gnome_icon_entry_get_filename (GNOME_ICON_ENTRY (lookup_widget (CIS, "CentralInstrumentSetupIconEntry"))));
  LC2.Instruments[Idx].AutoStart = GetCheckBox (CIS, "CentralInstrumentSetupAutoStartCheckBox");

  LC2.Instruments[Idx].Instrument[0].NumDetectors = GetSpinButtonInt (CIS, "CentralInstrumentSetupDetectorNumSpinButton");

  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[0].Name, GetEntry (CIS, "CentralInstrumentSetupDet1NameEntry"));
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[0].Ext, GetEntry (CIS, "CentralInstrumentSetupDet1ExtEntry"));
  LC2.Instruments[Idx].Instrument[0].Detectors[0].BindMainChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet1MainSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[0].BindSubChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet1SubSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[0].ScaleValue = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet1ScaleSpinButton");
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[0].ScaleUnit, GetEntry (CIS, "CentralInstrumentSetupDet1UnitEntry"));

  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[1].Name, GetEntry (CIS, "CentralInstrumentSetupDet2NameEntry"));
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[1].Ext, GetEntry (CIS, "CentralInstrumentSetupDet2ExtEntry"));
  LC2.Instruments[Idx].Instrument[0].Detectors[1].BindMainChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet2MainSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[1].BindSubChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet2SubSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[1].ScaleValue = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet2ScaleSpinButton");
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[1].ScaleUnit, GetEntry (CIS, "CentralInstrumentSetupDet2UnitEntry"));

  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[2].Name, GetEntry (CIS, "CentralInstrumentSetupDet3NameEntry"));
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[2].Ext, GetEntry (CIS, "CentralInstrumentSetupDet3ExtEntry"));
  LC2.Instruments[Idx].Instrument[0].Detectors[2].BindMainChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet3MainSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[2].BindSubChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet3SubSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[2].ScaleValue = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet3ScaleSpinButton");
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[2].ScaleUnit, GetEntry (CIS, "CentralInstrumentSetupDet3UnitEntry"));

  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[3].Name, GetEntry (CIS, "CentralInstrumentSetupDet4NameEntry"));
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[3].Ext, GetEntry (CIS, "CentralInstrumentSetupDet4ExtEntry"));
  LC2.Instruments[Idx].Instrument[0].Detectors[3].BindMainChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet4MainSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[3].BindSubChannel = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet4SubSpinButton");
  LC2.Instruments[Idx].Instrument[0].Detectors[3].ScaleValue = GetSpinButtonInt (CIS, "CentralInstrumentSetupDet4ScaleSpinButton");
  strcpy (LC2.Instruments[Idx].Instrument[0].Detectors[3].ScaleUnit, GetEntry (CIS, "CentralInstrumentSetupDet4UnitEntry"));

  LC2.Instruments[Idx].ADParameters.ADIOPortMenuIndex = GetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceIOPortOptionMenu");
  LC2.Instruments[Idx].ADParameters.ADDeviceId = GetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceADOptionMenu");
  LC2.Instruments[Idx].ADParameters.ADNoHWCommunication = GetCheckBox (CIS, "CentralInstrumentSetupInterfaceNoCommCheckButton");
  LC2.Instruments[Idx].ADParameters.ADChannelMode = GetOptionMenuIndex (CIS, "CentralInstrumentSetupInterfaceChannelOptionMenu");
  LC2.Instruments[Idx].ADParameters.ADMainChannelNum = GetSpinButtonInt (CIS, "CentralInstrumentSetupInterfaceMainChannelSpinButton");

  switch (LC2.Instruments[Idx].ADParameters.ADIOPortMenuIndex) {
	case 0: strcpy (LC2.Instruments[Idx].ADParameters.ADIOPortName, "None");
		break;
	case 1: strcpy (LC2.Instruments[Idx].ADParameters.ADIOPortName, "/dev/ttyS0");
		break;
	case 2: strcpy (LC2.Instruments[Idx].ADParameters.ADIOPortName, "/dev/ttyS1");
		break;
  } // IOPortName

  LC2.Instruments[Idx].ADParameters.ADSamplingSelection = 0;
  switch (LC2.Instruments[Idx].ADParameters.ADDeviceId) {
	case 0:
		strcpy (LC2.Instruments[Idx].ADParameters.ADDeviceName, "None");
		LC2.Instruments[Idx].ADParameters.ADSubChannelNum = 1;
		LC2.Instruments[Idx].ADParameters.ADFullScale = 1250.0;
		LC2.Instruments[Idx].ADParameters.ADResolution = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x007FFFFF;
		  switch (LC2.Instruments[Idx].InstrumentType) {
			case InstrumentNone :
				break;
			case InstrumentWorkstation :
				break;
			case InstrumentDataStation :
				break;
			case InstrumentTR541 :
				LC2.Instruments[Idx].ADParameters.ADFullScale = 1000.0;
				LC2.Instruments[Idx].ADParameters.ADResolution = 0x0000FFFF;
				LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x00000000;
				break;
			case InstrumentTR542 :
				LC2.Instruments[Idx].ADParameters.ADFullScale = 1000.0;
				LC2.Instruments[Idx].ADParameters.ADResolution = 0x0000FFFF;
				LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x00000000;
				break;
			case InstrumentTR930 :
				LC2.Instruments[Idx].ADParameters.ADFullScale = 1000.0;
				LC2.Instruments[Idx].ADParameters.ADResolution = 0x0000FFFF;
				LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x00000000;
				break;
		  } // switch
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime = 0.1;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 10;
		for (j = 0; j < 4; j++) {
		  LC2.Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime * J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz / J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = J[j];
		} // j
		break; // 0
	case 1:
		strcpy (LC2.Instruments[Idx].ADParameters.ADDeviceName, "ChromBox-2");
		LC2.Instruments[Idx].ADParameters.ADSubChannelNum = 1;
		LC2.Instruments[Idx].ADParameters.ADFullScale = 1250.0;
		LC2.Instruments[Idx].ADParameters.ADResolution = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime = 0.1;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 10;
		for (j = 0; j < 4; j++) {
		  LC2.Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime * J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz / J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = J[j];
		} // j
		break; // 1
	case 2:
		strcpy (LC2.Instruments[Idx].ADParameters.ADDeviceName, "ChromBox-3");
		LC2.Instruments[Idx].ADParameters.ADSubChannelNum = 1;
		LC2.Instruments[Idx].ADParameters.ADFullScale = 1250.0;
		LC2.Instruments[Idx].ADParameters.ADResolution = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime = 0.1;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 10;
		for (j = 0; j < 4; j++) {
		  LC2.Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime * J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz / J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = J[j];
		} // j
		break; // 2
	case 3:
		strcpy (LC2.Instruments[Idx].ADParameters.ADDeviceName, "ChromBox-4");
		LC2.Instruments[Idx].ADParameters.ADSubChannelNum = 2;
		LC2.Instruments[Idx].ADParameters.ADFullScale = 1250.0;
		LC2.Instruments[Idx].ADParameters.ADResolution = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime = 0.1;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 10;
		for (j = 0; j < 4; j++) {
		  LC2.Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime * J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz / J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = J[j];
		} // j
		break; // 3
	case 4:
		strcpy (LC2.Instruments[Idx].ADParameters.ADDeviceName, "ChromBox-5");
		LC2.Instruments[Idx].ADParameters.ADSubChannelNum = 2;
		LC2.Instruments[Idx].ADParameters.ADFullScale = 1250.0;
		LC2.Instruments[Idx].ADParameters.ADResolution = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADZeroPoint = 0x007FFFFF;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime = 0.1;
		LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 10;
		for (j = 0; j < 4; j++) {
		  LC2.Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingTime * J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = LC2.Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz / J[j];
		  LC2.Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = J[j];
		} // j
		break; // 4
  } // switch ADParameters.ADDeviceId

  ValueTemp = alloca (100);
  for (i = 0; i < ControlSignalNum; i++) {
	  for (j = 0; j < MaxMainChannels; j++) {
		  ResultCList = gtk_clist_get_text (GTK_CLIST(SignalCList), i, (j + 1) * 2, &ValueCList);
		  strcpy (ValueTemp, ValueCList);
		  sscanf (ValueTemp, "$%X", &LC2.Instruments[Idx].Instrument[j].ControlSignals[i].Value);
		  //printf ("ValueCList = %s,   ControlSignals[i].Value = %.2X\n", ValueTemp, LC2.Instruments[Idx].Instrument[j].ControlSignals[i].Value);
		  ResultCList = gtk_clist_get_text (GTK_CLIST(SignalCList), i, (j + 1) * 2 + 1, &ValueCList);
		  strcpy (ValueTemp, ValueCList);
		  sscanf (ValueTemp, "%d", &LC2.Instruments[Idx].Instrument[j].ControlSignals[i].ActiveLevel);
		  LC2.Instruments[Idx].Instrument[j].ControlSignals[i].ActiveLevel = !LC2.Instruments[Idx].Instrument[j].ControlSignals[i].ActiveLevel;
		  //printf ("ValueCList = %s,   ControlSignals[i].ActiveLevel = %d\n", ValueTemp, LC2.Instruments[Idx].Instrument[j].ControlSignals[i].ActiveLevel);
	  } // j
  } // i

} // RetrieveCentralInstrumentSetupWidgets

extern void
SetCentralSignalBits (GtkWidget *TopWidget, int BitValue) {
  if (BitValue & 0x80)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit80", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit80", FALSE);
  if (BitValue & 0x40)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit40", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit40", FALSE);
  if (BitValue & 0x20)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit20", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit20", FALSE);
  if (BitValue & 0x10)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit10", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit10", FALSE);
  if (BitValue & 0x08)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit08", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit08", FALSE);
  if (BitValue & 0x04)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit04", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit04", FALSE);
  if (BitValue & 0x02)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit02", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit02", FALSE);
  if (BitValue & 0x01)
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit01", TRUE);
  else
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit01", FALSE);
} // SetCentralSignalBits

extern int
GetCentralSignalBits (GtkWidget *TopWidget) {
int GCB;

  GCB = 0;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit80"))
	  GCB += 0x80;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit40"))
	  GCB += 0x40;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit20"))
	  GCB += 0x20;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit10"))
	  GCB += 0x10;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit08"))
	  GCB += 0x08;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit04"))
	  GCB += 0x04;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit02"))
	  GCB += 0x02;
  if (GetCheckBox (TopWidget, "CentralInstrumentSetupSignalBit01"))
	  GCB += 0x01;

  return GCB;
} // GetCentralSignalBits

extern void
SetCentralSignalLevel (GtkWidget *TopWidget, int LevelValue) {
  if (LevelValue) {
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalLevelHighRadioButton", TRUE);
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalLevelLowRadioButton", FALSE);
  } else {
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalLevelLowRadioButton", TRUE);
	  SetCheckBox (TopWidget, "CentralInstrumentSetupSignalLevelHighRadioButton", FALSE);
  }
} // SetCentralSignalLevel

extern int
GetCentralSignalLevel (GtkWidget *TopWidget) {
int GCL;

  GCL = GetCheckBox (TopWidget, "CentralInstrumentSetupSignalLevelHighRadioButton");
  return GCL;
} // GetCentralSignalLevel

extern void
SetCentralSignalEntry (GtkWidget *TopWidget, int EntryValue) {
char *ActStr;

  ActStr = alloca (100);
  sprintf (ActStr, "$%.2X", EntryValue);
  SetEntry (TopWidget, "CentralInstrumentSetupSignalBitsEntry", ActStr);
} // SetCentralSignalEntry

extern int
GetCentralSignalEntry (GtkWidget *TopWidget) {
} // GetCentralSignalEntry

extern void
SetCentralSignalRow (GtkWidget *TopWidget, int RowValue, int RowLevel) {
int ActRow;
int ActChn;
GtkWidget *ActCList;
char *ActStr;

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  ActChn = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "ActualSignalChannel"));
  ActCList = lookup_widget (TopWidget, "CentralInstrumentSetupSignalCList");

  ActStr = alloca (100);

  sprintf (ActStr, "$%.2X", RowValue);
  gtk_clist_set_text (GTK_CLIST(ActCList), ActRow, ActChn * 2, ActStr);

  sprintf (ActStr, "%d", RowLevel);
  gtk_clist_set_text (GTK_CLIST(ActCList), ActRow, ActChn * 2 + 1, ActStr);
} // SetCentralSignalRow

extern void
SetCentralPreferences (void) {
GList			*FontList;
GList			*FontListFirst;
gpointer	FontName;

  // General
  SetCheckBox (CentralPreferences, "CentralPreferencesCloseWindowCheckButton", CentralOptions.CentralWindowClose);
  // Directories
  SetGnomeFileEntry (CentralPreferences, "CentralPreferencesBugTraceFileEntry", BugTraceCentralDir);
  // Print
	  // Fonts
  if (strlen (CentralOptions.PrintFontDefaultName) > 1) SetEntry (CentralPreferences, "CentralPreferencesPrintFontsDefaultEntry", CentralOptions.PrintFontDefaultName);
  if (strlen (CentralOptions.PrintFontTestName) > 1) SetEntry (CentralPreferences, "CentralPreferencesPrintFontsTestEntry", CentralOptions.PrintFontTestName);
  if (strlen (CentralOptions.PrintFontChromPeakDataName) > 1) SetEntry (CentralPreferences, "CentralPreferencesPrintFontsChromPeakEntry", CentralOptions.PrintFontChromPeakDataName);
  if (strlen (CentralOptions.PrintFontAxisName) > 1) SetEntry (CentralPreferences, "CentralPreferencesPrintFontsAxisEntry", CentralOptions.PrintFontAxisName);
  if (strlen (CentralOptions.PrintFontPeakListName) > 1) SetEntry (CentralPreferences, "CentralPreferencesPrintFontsPeakListEntry", CentralOptions.PrintFontPeakListName);

  FontListFirst = gnome_font_list ();
  FontList = g_list_first (FontListFirst);
  while (FontList) {
//	  printf ("Font name: %s\n", FontList->data);
	  FontName = FontList->data;
	  gtk_clist_append (GTK_CLIST(lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsCList")), (void *)&FontName);
	  FontList = g_list_next (FontList);
  } // while
  gnome_font_list_free (FontListFirst);

	  // Margins
  SetSpinButtonValue (CentralPreferences, "CentralPreferencesPrintMarginsLeftSpinButton", CentralOptions.PrintMarginLeft);
  SetSpinButtonValue (CentralPreferences, "CentralPreferencesPrintMarginsRightSpinButton", CentralOptions.PrintMarginRight);
  SetSpinButtonValue (CentralPreferences, "CentralPreferencesPrintMarginsTopSpinButton", CentralOptions.PrintMarginTop);
  SetSpinButtonValue (CentralPreferences, "CentralPreferencesPrintMarginsBottomSpinButton", CentralOptions.PrintMarginBottom);
} // SetCentralPreferences

extern void
GetCentralPreferences (void) {
  // General
  CentralOptions.CentralWindowClose = GetCheckBox (CentralPreferences, "CentralPreferencesCloseWindowCheckButton");
  // Directories
  GetGnomeFileEntry (CentralPreferences, "CentralPreferencesBugTraceFileEntry", BugTraceCentralDir);
  CheckDirName (BugTraceCentralDir);
  // Print
	  // Fonts
  strcpy (CentralOptions.PrintFontDefaultName, GetEntry (CentralPreferences, "CentralPreferencesPrintFontsDefaultEntry"));
  strcpy (CentralOptions.PrintFontTestName, GetEntry (CentralPreferences, "CentralPreferencesPrintFontsTestEntry"));
  strcpy (CentralOptions.PrintFontChromPeakDataName, GetEntry (CentralPreferences, "CentralPreferencesPrintFontsChromPeakEntry"));
  strcpy (CentralOptions.PrintFontAxisName, GetEntry (CentralPreferences, "CentralPreferencesPrintFontsAxisEntry"));
  strcpy (CentralOptions.PrintFontPeakListName, GetEntry (CentralPreferences, "CentralPreferencesPrintFontsPeakListEntry"));

	  // Margins
  CentralOptions.PrintMarginLeft = GetSpinButtonFloat (CentralPreferences, "CentralPreferencesPrintMarginsLeftSpinButton");
  CentralOptions.PrintMarginRight = GetSpinButtonFloat (CentralPreferences, "CentralPreferencesPrintMarginsRightSpinButton");
  CentralOptions.PrintMarginTop = GetSpinButtonFloat (CentralPreferences, "CentralPreferencesPrintMarginsTopSpinButton");
  CentralOptions.PrintMarginBottom = GetSpinButtonFloat (CentralPreferences, "CentralPreferencesPrintMarginsBottomSpinButton");
} // GetCentralPreferences

extern GtkWidget*
GetSelectedPrintFontEntry (void) {
GtkWidget*	Entry;

  if (GetCheckBox (CentralPreferences, "CentralPreferencesPrintFontsDefaultRadioButton")) return lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsDefaultEntry");
  if (GetCheckBox (CentralPreferences, "CentralPreferencesPrintFontsTestRadioButton")) return lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsTestEntry");
  if (GetCheckBox (CentralPreferences, "CentralPreferencesPrintFontsChromPeakRadioButton")) return lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsChromPeakEntry");
  if (GetCheckBox (CentralPreferences, "CentralPreferencesPrintFontsAxisRadioButton")) return lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsAxisEntry");
  if (GetCheckBox (CentralPreferences, "CentralPreferencesPrintFontsPeakListRadioButton")) return lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsPeakListEntry");

  return NULL;
} // GetSelectedPrintFontEntry

extern char*
GetSelectedPrintFontName (int SelectedPrintFont) {
static char	*DefaultName = {"Testing"};
char				**FontName;

  if (gtk_clist_get_text (GTK_CLIST(lookup_widget (CentralPreferences, "CentralPreferencesPrintFontsCList")), SelectedPrintFont, 0, FontName) == 1)
	  return *FontName;
  else
	  return DefaultName;
} // GetSelectedPrintFontName
