// Calibration, analysis widget handling functions

extern void
SetAnalyzeWidgets (int DataSource, GtkWidget *AnalyzeWidget) {
gboolean QueueMode;

  QueueMode = DATA_DOWN(AnalyzeWidget, "QueueMode");
  SetEntry (AnalyzeWidget, "AnalyzeChromEntry", Chrom[DataSource].ChrName);
  SetEntry (AnalyzeWidget, "AnalyzeCalibrNameEntry", Chrom[DataSource].CalName);
  SetEntry (AnalyzeWidget, "AnalyzeQueueNameEntry", Chrom[DataSource].LayerQueueName);
  SetCheckBox (AnalyzeWidget, "AnalyzeSingleChromRadioButton", TRUE);
} // SetAnalyzeWidgets

extern void
GetAnalyzeWidgets (int DataSource, GtkWidget *AnalyzeWidget) {
gboolean QueueMode;
gboolean SingleMode;

  QueueMode = DATA_DOWN(AnalyzeWidget, "QueueMode");
  SingleMode = GetCheckBox (AnalyzeWidget, "AnalyzeSingleChromRadioButton");
  DATA_UP(AnalyzeWidget, "SingleMode", SingleMode);
} // GetAnalyzeWidgets

extern void
ActivateCalibrateWidgets (GtkWidget *CalibrWidget) {
gboolean QueueMode;

  DATASOURCE(CalibrWidget);
  CAL_SELECTEDS(CalibrWidget);
  QueueMode = DATA_DOWN(CalibrWidget, "QueueMode");

  ActivateWidget (CalibrWidget, "CalibrationConcLabel", TRUE);
  ActivateWidget (CalibrWidget, "CalibrationSetConcSpinButton", TRUE);
  ActivateWidget (CalibrWidget, "CalibrationSetConcButton", TRUE);
  ActivateWidget (CalibrWidget, "CalibrationGetConcButton", TRUE);

  if (Chrom[DataSource].CalibrHead->LevelNum > 1)
	  ActivateWidget (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton", FALSE);
  else
	  ActivateWidget (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton", TRUE);

  if ((SelectedComponent < 0) || (SelectedLevel < 0)) {
	  ActivateWidget (CalibrWidget, "CalibrationConcLabel", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationSetConcSpinButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationSetConcButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationGetConcButton", FALSE);
  }

  ActivateWidget (CalibrWidget, "CalibrationComponentsRemoveButton", TRUE);
  ActivateWidget (CalibrWidget, "CalibrationComponentsModifyButton", TRUE);
  if (SelectedComponent < 0) {
	  ActivateWidget (CalibrWidget, "CalibrationComponentsRemoveButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationComponentsModifyButton", FALSE);
  }

  ActivateWidget (CalibrWidget, "CalibrationLevelsRemoveLevelButton", TRUE);
  ActivateWidget (CalibrWidget, "CalibrationLevelsModifyLevelButton", TRUE);
  if (SelectedLevel < 0) {
	  ActivateWidget (CalibrWidget, "CalibrationLevelsRemoveLevelButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationLevelsModifyLevelButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationLevelsChromAddButton", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationLevelsChromRemoveButtons", FALSE);
	  ActivateWidget (CalibrWidget, "CalibrationLevelsChromModifyButton", FALSE);
	  if (QueueMode) {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromSelectButton", FALSE);
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromSelectEntry", FALSE);
	  } else {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromFileEntry", FALSE);
	  } // QueueMode
  } else {
	  ActivateWidget (CalibrWidget, "CalibrationLevelsChromAddButton", TRUE);
	  if (QueueMode) {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromSelectButton", TRUE);
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromSelectEntry", TRUE);
	  } else {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromFileEntry", TRUE);
	  } // QueueMode
	  if (SelectedChrom < 0) {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromRemoveButtons", FALSE);
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromModifyButton", FALSE);
	  } else {
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromRemoveButtons", TRUE);
		  ActivateWidget (CalibrWidget, "CalibrationLevelsChromModifyButton", TRUE);
	  }
  }

  ActivateWidget (CalibrWidget, "CalibrationCellDataSetToCellButton", TRUE);
  if ((SelectedChromPeak < 0) || \
	  (SelectedComponent < 0) || \
	  (SelectedLevel < 0) || \
	  (SelectedChrom < 0)) {
	  ActivateWidget (CalibrWidget, "CalibrationCellDataSetToCellButton", FALSE);
  }

} // ActivateCalibrateWidgets

extern void
ConfigureCalibrateWidgets (int CalibrType, GtkWidget *CalibrWidget) {
gboolean QueueMode;

  DATASOURCE(CalibrWidget);

  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromSelectButton"));
  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromSelectEntry"));
  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsChromSelectButton"));
  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsChromSelectEntry"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromFileEntry"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsChromFileEntry"));
  QueueMode = DATA_DOWN(CalibrWidget, "QueueMode");
  if (QueueMode) {
	  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromSelectButton"));
	  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromSelectEntry"));
	  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsChromSelectButton"));
	  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsChromSelectEntry"));
	  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsTemplateChromFileEntry"));
	  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsChromFileEntry"));
  } // "QueueMode"

  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 0));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 1));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 2));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 3));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 4));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 0));
  gtk_widget_show (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 3));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationConcHBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationGetConcButton"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationVBoxHSeparator"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationListOfLevelsLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsScrolledWindow"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationListOfChromatogramsLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationChromatogramsScrolledWindow"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsAnalyzeVBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsMainComponentCheckBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator2"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsCalculateLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsCalculateOptionMenu"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator3"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsCurveLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsCurveOptionMenu"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationSettingsForcedZeroCheckBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComopnentsISTCheckbutton"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComopnentsISTHBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComponentsCurveLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationComponentsResponseFactorHBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsLevelLabel"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsLevelNameHBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsLevelParametersTable"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsLevelHButtonBox"));
  gtk_widget_show (lookup_widget (CalibrWidget, "CalibrationLevelsHSeparator1"));
  switch (CalibrType) {
	  case CalibrPeakIdent:
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 0));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 3));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 4));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationConcHBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationGetConcButton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationVBoxHSeparator"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationListOfLevelsLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsScrolledWindow"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationListOfChromatogramsLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationChromatogramsScrolledWindow"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsAnalyzeVBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsMainComponentCheckBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator2"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCalculateLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCalculateOptionMenu"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator3"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCurveLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCurveOptionMenu"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsForcedZeroCheckBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComopnentsISTCheckbutton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComopnentsISTHBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsCurveLabel"));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 0));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 1));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 3));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsResponseFactorHBox"));
		  break;
	  case CalibrAreaNorm:
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 0));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 3));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 4));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationConcHBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationGetConcButton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationVBoxHSeparator"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationListOfLevelsLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsScrolledWindow"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationListOfChromatogramsLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationChromatogramsScrolledWindow"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsAnalyzeVBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsMainComponentCheckBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator2"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsModeHSeparator3"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCurveLabel"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsCurveOptionMenu"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationSettingsForcedZeroCheckBox"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComopnentsISTCheckbutton"));
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComopnentsISTHBox"));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationComponentsNotebook")), 0));
		  //gtk_widget_hide (lookup_widget (CalibrWidget, ""));
		  break;
	  case CalibrIntStd:
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 0));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 3));
		  gtk_widget_hide (gtk_notebook_get_nth_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 4));
		  break;
	  case CalibrExtStd:
		  gtk_notebook_set_current_page (GTK_NOTEBOOK(lookup_widget(CalibrWidget, "CalibrationNotebook")), 0);
		  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationComponentsResponseFactorHBox"));
		  if (Chrom[DataSource].CalibrHead->ForcedSingleLevelMode) {
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationGetConcButton"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationListOfLevelsLabel"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsScrolledWindow"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsLevelLabel"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsLevelNameHBox"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsLevelParametersTable"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsLevelHButtonBox"));
			  gtk_widget_hide (lookup_widget (CalibrWidget, "CalibrationLevelsHSeparator1"));
			  DATA_UP(CalibrWidget, "SelectedLevel", 0);
			  RefreshCalibrChromList (DataSource, CalibrWidget);
//			  gtk_widget_hide (lookup_widget (CalibrWidget, ""));
		  } else
			  RefreshCalibrLevelList (DataSource, CalibrWidget);
		  break;
  } // switch CalibrType
  CalibrationModified (DataSource);
} // ConfigureCalibrateWidgets

extern void
SetCalibrateWidgets (int DataSource, GtkWidget *CalibrWidget) {

  if ((Chrom[DataSource].CalibrHead->CalibrType < 0) || \
	  (Chrom[DataSource].CalibrHead->CalibrType > CalibrMaxType) || \
	  (!Chrom[DataSource].FileLoaded[CalFlag]))
	  Chrom[DataSource].CalibrHead->CalibrType = CalibrExtStd;
  SetOptionMenuIndex (CalibrWidget, "CalibrationSettingsTypeOptionMenu", Chrom[DataSource].CalibrHead->CalibrType);
  ConfigureCalibrateWidgets (Chrom[DataSource].CalibrHead->CalibrType, CalibrWidget);
  SetOptionMenuIndex (CalibrWidget, "CalibrationSettingsIdentifyOptionMenu", Chrom[DataSource].CalibrHead->CalibrIdentificationMode);
  SetCheckBox (CalibrWidget, "CalibrationSettingsMainComponentCheckBox", Chrom[DataSource].CalibrHead->CalculateByMainComponent);
  SetCheckBox (CalibrWidget, "CalibrationSettingsForcedSingleLevelCheckButton", Chrom[DataSource].CalibrHead->ForcedSingleLevelMode);
  SetOptionMenuIndex (CalibrWidget, "CalibrationSettingsCalculateOptionMenu", Chrom[DataSource].CalibrHead->AreaHeightBase);
  SetOptionMenuIndex (CalibrWidget, "CalibrationSettingsCurveOptionMenu", Chrom[DataSource].CalibrHead->CurveType);
  Chrom[DataSource].CalibrHead->ZeroOption = GetCheckBox (CalibrWidget, "CalibrationSettingsForcedZeroCheckBox");

  SetSpinButtonValue (CalibrWidget, "CalibrationSettingsStaticSpinButton", Chrom[DataSource].CalibrHead->LimitStatic);
  SetSpinButtonValue (CalibrWidget, "CalibrationSettingsDynamicSpinButton", Chrom[DataSource].CalibrHead->LimitDynamic);

  RefreshCalibrComponentList (DataSource, CalibrWidget);
  RefreshCalibrLevelList (DataSource, CalibrWidget);
  RefreshIstList (DataSource, CalibrWidget);

  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget(CalibrWidget, "CalibrationCellDataChannelComboBox")), 0);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget(CalibrWidget, "CalibrationComponentsListDetectorComboBox")), 0);
  ActivateCalibrateWidgets (CalibrWidget);
} // SetCalibrateWidgets

extern void
GetCalibrateWidgets (int DataSource, GtkWidget *CalibrWidget) {

  Chrom[DataSource].CalibrHead->CalibrType = GetOptionMenuIndex (CalibrWidget, "CalibrationSettingsTypeOptionMenu");
  Chrom[DataSource].CalibrHead->CalibrIdentificationMode = GetOptionMenuIndex (CalibrWidget, "CalibrationSettingsIdentifyOptionMenu");
  Chrom[DataSource].CalibrHead->CalculateByMainComponent = GetCheckBox (CalibrWidget, "CalibrationSettingsMainComponentCheckBox");
  Chrom[DataSource].CalibrHead->AreaHeightBase = GetOptionMenuIndex (CalibrWidget, "CalibrationSettingsCalculateOptionMenu");
  Chrom[DataSource].CalibrHead->CurveType = GetOptionMenuIndex (CalibrWidget, "CalibrationSettingsCurveOptionMenu");
  Chrom[DataSource].CalibrHead->ZeroOption = GetCheckBox (CalibrWidget, "CalibrationSettingsForcedZeroCheckBox");
  Chrom[DataSource].CalibrHead->LimitStatic = GetSpinButtonFloat (CalibrWidget, "CalibrationSettingsStaticSpinButton");
  Chrom[DataSource].CalibrHead->LimitDynamic = GetSpinButtonFloat (CalibrWidget, "CalibrationSettingsDynamicSpinButton");
} // GetCalibrateWidgets

extern void
RefreshCalibrComponentList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget	*ComponentList;
char		*RowData[3];
int			i;

  RowData[0] = alloca(20);
  RowData[1] = alloca(200);
  RowData[2] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  ComponentList = lookup_widget(CalibrWidget,"CalibrationComponentsCList");
  gtk_clist_clear (GTK_CLIST (ComponentList));

  for (i=0; i<Chrom[DataSource].CalibrHead->ComponentNum; i++)
  {
	  GetComponent (i, DataSource);
	  sprintf (RowData[0],"%d",i+1);
	  sprintf (RowData[1],"%s", Chrom[DataSource].CalibrComponent->ComponentName);
	  sprintf (RowData[2],"%s",Chrom[DataSource].CalibrComponent->ComponentDetectorName);
	  gtk_clist_append (GTK_CLIST(ComponentList),RowData);
  } // for i
} // RefreshCalibrComponentList

extern void
RefreshIstList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget	*IstComboBox;
int			IstNumInCombo;
int			i, j;

  CAL_SELECTEDS(CalibrWidget);
  IstComboBox = lookup_widget (CalibrWidget, "CalibrationComopnentsISTComboBox");
  IstNumInCombo = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrWidget), "IstNumInCombo"));

  for (i = 0; i < IstNumInCombo; i++)
	  gtk_combo_box_remove_text (GTK_COMBO_BOX(IstComboBox), 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX(IstComboBox), _("None"));

  for (i = 0; i < Chrom[DataSource].CalibrHead->IstNum; i++) {
	  for (j = 0; j < Chrom[DataSource].CalibrHead->ComponentNum; j++) {
		  GetComponent (j, DataSource);
		  if ((i + 1) == Chrom[DataSource].CalibrComponent->IstIdNum) {
			  gtk_combo_box_append_text (GTK_COMBO_BOX(IstComboBox), Chrom[DataSource].CalibrComponent->ComponentName);
			  printf ("--- ### --- IST : %d = %s\n", i, Chrom[DataSource].CalibrComponent->ComponentName);
		  }
	  } // j
  } // i
  gtk_object_set_data (GTK_OBJECT (CalibrWidget), "IstNumInCombo", GINT_TO_POINTER(Chrom[DataSource].CalibrHead->IstNum + 1));
  if (SelectedComponent != -1) {
	  GetComponent (SelectedComponent, DataSource);
	  gtk_combo_box_set_active (GTK_COMBO_BOX(IstComboBox), Chrom[DataSource].CalibrComponent->IstIdNum);
  } else
	  gtk_combo_box_set_active (GTK_COMBO_BOX(IstComboBox), 0);
} // RefreshIstList

extern void
GetCalibrComponentWidgets (int DataSource, GtkWidget *CalibrWidget) {

  Chrom[DataSource].CalibrComponent->Existing = TRUE;
  Chrom[DataSource].CalibrComponent->ComponentMain = FALSE;

  Chrom[DataSource].CalibrComponent->IstFlag = GetCheckBox (CalibrWidget, "CalibrationComopnentsISTCheckbutton");
  Chrom[DataSource].CalibrComponent->AssignIst = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComopnentsISTComboBox")));
  strcpy (Chrom[DataSource].CalibrComponent->ComponentName, GetEntry (CalibrWidget, "CalibrationComopnentsNameEntry"));
  Chrom[DataSource].CalibrComponent->ComponentIdNum = GetSpinButtonInt (CalibrWidget, "CalibrationComponentsIDNumSpinButton");
  strcpy (Chrom[DataSource].CalibrComponent->ComponentIdString, GetEntry (CalibrWidget, "CalibrationComponentsIDEntry"));
  Chrom[DataSource].CalibrComponent->ComponentDetector = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComponentsListDetectorComboBox")));
  strcpy (Chrom[DataSource].CalibrComponent->ComponentDetectorName, GetEntry (CalibrWidget, "CalibrationComponentsDetectorEntry"));
  Chrom[DataSource].CalibrComponent->AmtPerArea = 0;
  Chrom[DataSource].CalibrComponent->CalFactor = GetSpinButtonFloat (CalibrWidget, "CalibrationComponentsResponseFactorSpinButton");
  Chrom[DataSource].CalibrComponent->PeakRet = GetSpinButtonFloat (CalibrWidget, "CalibrationComponentsRetentionSpinButton");
  Chrom[DataSource].CalibrComponent->PeakRelRet = 0;
  Chrom[DataSource].CalibrComponent->PeakRetFactor = 0;
  Chrom[DataSource].CalibrComponent->ComponentLowerLimit = GetSpinButtonFloat (CalibrWidget, "CalibrationSettingsCompLowLimitSpinButton");
  Chrom[DataSource].CalibrComponent->ComponentUpperLimit = GetSpinButtonFloat (CalibrWidget, "CalibrationSettingsCompHighLimitSpinButton");
  Chrom[DataSource].CalibrComponent->ComponentExpectedValue = GetSpinButtonFloat (CalibrWidget, "CalibrationSettingsCompCheckValueSpinButton");
  Chrom[DataSource].CalibrComponent->LimitStatic = GetSpinButtonFloat (CalibrWidget, "CalibrationComponentsIdentStaticSpinButton");
  Chrom[DataSource].CalibrComponent->LimitDynamic = GetSpinButtonFloat (CalibrWidget, "CalibrationComponentsIdentDynamicSpinButton");
  Chrom[DataSource].CalibrComponent->AreaHeightBase = GetOptionMenuIndex (CalibrWidget, "CalibrationComponentsCalcBaseAHOptionMenu");
  Chrom[DataSource].CalibrComponent->CurveType = GetOptionMenuIndex (CalibrWidget, "CalibrationCompCurveOptionMenu");
  Chrom[DataSource].CalibrComponent->ZeroOption = GetCheckBox (CalibrWidget, "CalibrationCompForcedZeroCheckBox");
  Chrom[DataSource].CalibrComponent->IdentifyMorePeaks = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComponentsIdentComboBox")));
} // GetCalibrComponentWidgets

extern void
SetCalibrComponentWidgets (int DataSource, GtkWidget *CalibrWidget) {
char *TmpStr;

  TmpStr = alloca (100);

  SetCheckBox (CalibrWidget, "CalibrationComopnentsISTCheckbutton", Chrom[DataSource].CalibrComponent->IstFlag);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComopnentsISTComboBox")), Chrom[DataSource].CalibrComponent->AssignIst);
  SetEntry (CalibrWidget, "CalibrationComopnentsNameEntry", Chrom[DataSource].CalibrComponent->ComponentName);
  SetSpinButtonValue (CalibrWidget, "CalibrationComponentsIDNumSpinButton", Chrom[DataSource].CalibrComponent->ComponentIdNum);
  SetEntry (CalibrWidget, "CalibrationComponentsIDEntry", Chrom[DataSource].CalibrComponent->ComponentIdString);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComponentsListDetectorComboBox")), Chrom[DataSource].CalibrComponent->ComponentDetector);
  SetEntry (CalibrWidget, "CalibrationComponentsDetectorEntry", Chrom[DataSource].CalibrComponent->ComponentDetectorName);
  SetSpinButtonValue (CalibrWidget, "CalibrationComponentsRetentionSpinButton", Chrom[DataSource].CalibrComponent->PeakRet);
  SetSpinButtonValue (CalibrWidget, "CalibrationComponentsResponseFactorSpinButton", Chrom[DataSource].CalibrComponent->CalFactor);

  sprintf (TmpStr, "%.4f", Chrom[DataSource].CalibrComponent->AParam);
  SetEntry (CalibrWidget, "CalibrationComponentsAParamEntry", TmpStr);
  sprintf (TmpStr, "%.4f", Chrom[DataSource].CalibrComponent->BParam);
  SetEntry (CalibrWidget, "CalibrationComponentsBParamEntry", TmpStr);
  sprintf (TmpStr, "%.4f", Chrom[DataSource].CalibrComponent->RParam);
  SetEntry (CalibrWidget, "CalibrationComponentsRParamEntry", TmpStr);

  SetSpinButtonValue (CalibrWidget, "CalibrationSettingsCompLowLimitSpinButton", Chrom[DataSource].CalibrComponent->ComponentLowerLimit);
  SetSpinButtonValue (CalibrWidget, "CalibrationSettingsCompHighLimitSpinButton", Chrom[DataSource].CalibrComponent->ComponentUpperLimit);
  SetSpinButtonValue (CalibrWidget, "CalibrationSettingsCompCheckValueSpinButton", Chrom[DataSource].CalibrComponent->ComponentExpectedValue);

  SetSpinButtonValue (CalibrWidget, "CalibrationComponentsIdentStaticSpinButton", Chrom[DataSource].CalibrComponent->LimitStatic);
  SetSpinButtonValue (CalibrWidget, "CalibrationComponentsIdentDynamicSpinButton", Chrom[DataSource].CalibrComponent->LimitDynamic);
  SetOptionMenuIndex (CalibrWidget, "CalibrationComponentsCalcBaseAHOptionMenu", Chrom[DataSource].CalibrComponent->AreaHeightBase);
  SetOptionMenuIndex (CalibrWidget, "CalibrationCompCurveOptionMenu", Chrom[DataSource].CalibrComponent->CurveType);
  SetCheckBox (CalibrWidget, "CalibrationCompForcedZeroCheckBox", Chrom[DataSource].CalibrComponent->ZeroOption);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (CalibrWidget, "CalibrationComponentsIdentComboBox")), Chrom[DataSource].CalibrComponent->IdentifyMorePeaks);
} // SetCalibrComponentWidgets

extern void
RefreshCalibrTemplateChromList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget *TemplateChromList;
char *RowData[3];
int i;

  RowData[0] = alloca(20);
  RowData[1] = alloca(200);
  RowData[2] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  TemplateChromList = lookup_widget(CalibrWidget,"CalibrationComponentsTemplateChromCList");
  gtk_clist_clear (GTK_CLIST (TemplateChromList));

  if (!Chrom[DataSource].FileLoaded[TCrFlag]) return;
  for (i=0; i<Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrTemplateActualDetector]; i++)
  {
	  GetCalibrTemplatePeak (i, DataSource);
	  sprintf (RowData[0],"%d",i+1);
	  sprintf (RowData[1],"%.3f", Chrom[DataSource].CalibrTemplatePeak->PeakRetention);
	  sprintf (RowData[2]," ");
	  gtk_clist_append (GTK_CLIST(TemplateChromList),RowData);
  } // for i
} // RefreshCalibrTemplateChromList

extern void
RefreshCalibrLevelList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget	*LevelList;
char		*RowData[3];
int			i;

  RowData[0] = alloca(200);
  RowData[1] = alloca(200);
  RowData[2] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  LevelList = lookup_widget(CalibrWidget,"CalibrationLevelsCList");
  gtk_clist_clear (GTK_CLIST (LevelList));

  for (i=0; i<Chrom[DataSource].CalibrHead->LevelNum; i++)
  {
	  GetLevel (i, DataSource);
	  sprintf (RowData[0],"%d",i+1);
	  sprintf (RowData[1],"%s", Chrom[DataSource].CalibrLevel->LevelName);
	  sprintf (RowData[2],"");
	  gtk_clist_append (GTK_CLIST(LevelList),RowData);
  } // for i
} // RefreshCalibrLevelList

extern void
SetCalibrLevelWidgets (int DataSource, GtkWidget *CalibrWidget) {
  SetEntry (CalibrWidget, "CalibrationLevelsLevelNameEntry", Chrom[DataSource].CalibrLevel->LevelName);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelInjVolSpinButton", Chrom[DataSource].CalibrLevel->InjectedVolume);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelVolumeSpinButton", Chrom[DataSource].CalibrLevel->Volume);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelAmountSpinButton", Chrom[DataSource].CalibrLevel->Amount);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelFactorSpinButton", Chrom[DataSource].CalibrLevel->Factor);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelPressureSpinButton", Chrom[DataSource].CalibrLevel->Pressure);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelTemperSpinButton", Chrom[DataSource].CalibrLevel->Temperature);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsLevelISTConcSpinButton", Chrom[DataSource].CalibrLevel->IstConc);
} // SetCalibrLevelWidgets

extern void
GetCalibrLevelWidgets (int DataSource, GtkWidget *CalibrWidget) {
  Chrom[DataSource].CalibrLevel->Existing = TRUE;
  // Chrom[DataSource].CalibrHead->LevelNum not incremented yet in caller function
  // Chrom[DataSource].CalibrLevel->LevelNum = Chrom[DataSource].CalibrHead->LevelNum;
  strcpy (Chrom[DataSource].CalibrLevel->LevelName, GetEntry (CalibrWidget, "CalibrationLevelsLevelNameEntry"));
  Chrom[DataSource].CalibrLevel->InjectedVolume = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelInjVolSpinButton");
  Chrom[DataSource].CalibrLevel->Volume = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelVolumeSpinButton");
  Chrom[DataSource].CalibrLevel->Amount = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelAmountSpinButton");
  Chrom[DataSource].CalibrLevel->Factor = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelFactorSpinButton");
  Chrom[DataSource].CalibrLevel->Pressure = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelPressureSpinButton");
  Chrom[DataSource].CalibrLevel->Temperature = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelTemperSpinButton");
  Chrom[DataSource].CalibrLevel->IstConc = GetSpinButtonFloat (CalibrWidget, "CalibrationLevelsLevelISTConcSpinButton");
} // GetCalibrLevelWidgets

extern void
RefreshCalibrChromList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget	*ChromList;
char		*RowData[3];
int			i;
int			SelectedLevel;
gchar		*TmpBaseName;

  SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrationWindow), "SelectedLevel"));

  RowData[0] = alloca(200);
  RowData[1] = alloca(200);
  RowData[2] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  ChromList = lookup_widget(CalibrWidget,"CalibrationChromatogramsCList");
  gtk_clist_clear (GTK_CLIST (ChromList));
  if (SelectedLevel < 0) return;

  GetLevel (SelectedLevel, DataSource);
  for (i=0; i<Chrom[DataSource].CalibrLevel->ChromNum; i++)
  {
	  GetChrom (SelectedLevel, i, DataSource);
	  sprintf (RowData[0],"%d",i+1);
	  TmpBaseName = g_path_get_basename (Chrom[DataSource].CalibrChrom->ChromName);
	  sprintf (RowData[1],"%s", TmpBaseName);
	  g_free (TmpBaseName);
	  sprintf (RowData[2],"");
	  gtk_clist_append (GTK_CLIST(ChromList),RowData);
  } // for i
} // RefreshCalibrChromList

extern void
TransferCalibrChromToLevel (int DataSource, GtkWidget *CalibrWidget) {
  CAL_SELECTEDS(CalibrWidget);

  GetLevel (SelectedLevel, DataSource);
  GetChrom (SelectedLevel, SelectedChrom, DataSource);
  Chrom[DataSource].CalibrChrom->InjectedVolume = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.InjectedVolume;
  Chrom[DataSource].CalibrChrom->Volume = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Volume;
  Chrom[DataSource].CalibrChrom->Amount = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Amount;
  Chrom[DataSource].CalibrChrom->Factor = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Factor;
  Chrom[DataSource].CalibrChrom->Pressure = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Pressure;
  Chrom[DataSource].CalibrChrom->Temperature = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Temperature;
  Chrom[DataSource].CalibrChrom->IstConc = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.IstConc;
  Chrom[DataSource].CalibrChrom->SampleId = Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.SampleIdNum;
  strcpy (Chrom[DataSource].CalibrChrom->Comment, Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.SampleComment);
  SetChrom (SelectedLevel, SelectedChrom, DataSource);
  if (Chrom[DataSource].CalibrLevel->ChromNum == 1) {
	  Chrom[DataSource].CalibrLevel->InjectedVolume = Chrom[DataSource].CalibrChrom->InjectedVolume;
	  Chrom[DataSource].CalibrLevel->Volume = Chrom[DataSource].CalibrChrom->Volume;
	  Chrom[DataSource].CalibrLevel->Amount = Chrom[DataSource].CalibrChrom->Amount;
	  Chrom[DataSource].CalibrLevel->Factor = Chrom[DataSource].CalibrChrom->Factor;
	  Chrom[DataSource].CalibrLevel->Pressure = Chrom[DataSource].CalibrChrom->Pressure;
	  Chrom[DataSource].CalibrLevel->Temperature = Chrom[DataSource].CalibrChrom->Temperature;
	  Chrom[DataSource].CalibrLevel->IstConc = Chrom[DataSource].CalibrChrom->IstConc;
	  SetLevel (SelectedLevel, DataSource);
	  SetCalibrLevelWidgets (DataSource, CalibrWidget);
  } else {
	  printf ("### Chrom[DataSource].CalibrLevel->ChromNum != 1\n");
	  if (Chrom[DataSource].CalibrLevel->InjectedVolume != Chrom[DataSource].CalibrChrom->InjectedVolume) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->Volume != Chrom[DataSource].CalibrChrom->Volume) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->Amount != Chrom[DataSource].CalibrChrom->Amount) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->Factor != Chrom[DataSource].CalibrChrom->Factor) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->Pressure != Chrom[DataSource].CalibrChrom->Pressure) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->Temperature != Chrom[DataSource].CalibrChrom->Temperature) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
	  if (Chrom[DataSource].CalibrLevel->IstConc != Chrom[DataSource].CalibrChrom->IstConc) {
		  CalibrChromLevelMismatchDialog = create_CalibrChromLevelMismatchDialog ();
		  gtk_widget_show (CalibrChromLevelMismatchDialog);
		  gtk_window_set_modal (GTK_WINDOW(CalibrChromLevelMismatchDialog), TRUE);
		  gtk_window_set_transient_for (GTK_WINDOW(CalibrChromLevelMismatchDialog), GTK_WINDOW(CalibrWidget));
		  return;
	  } // if Level != Chrom
  } // if Level->ChromNum == 0
} // TransferCalibrChromToLevel

extern void
SetCalibrChromWidgets (int DataSource, GtkWidget *CalibrWidget) {
  CAL_SELECTEDS(CalibrWidget);

  GetChrom (SelectedLevel, SelectedChrom, DataSource);
  SetEntry (CalibrWidget, "CalibrationLevelsChromCommentEntry", Chrom[DataSource].CalibrChrom->Comment);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromAmountSpinButton", Chrom[DataSource].CalibrChrom->Amount);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromVolumeSpinButton", Chrom[DataSource].CalibrChrom->Volume);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromFactorSpinButton", Chrom[DataSource].CalibrChrom->Factor);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromPressureSpinButton", Chrom[DataSource].CalibrChrom->Pressure);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromTemperSpinButton", Chrom[DataSource].CalibrChrom->Temperature);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromISTConcSpinButton", Chrom[DataSource].CalibrChrom->IstConc);
  SetSpinButtonValue (CalibrWidget, "CalibrationLevelsChromInjVolSpinButton", Chrom[DataSource].CalibrChrom->InjectedVolume);
} // SetCalibrChromWidgets

extern void
GetCalibrChromWidgets (int DataSource, GtkWidget *CalibrWidget) {
gboolean QueueMode;

  QueueMode = DATA_DOWN(CalibrWidget, "QueueMode");
  if (QueueMode)
	  strcpy (Chrom[DataSource].CalibrChrom->ChromName, GetEntry (CalibrWidget, "CalibrationLevelsChromSelectEntry"));
  else
	  GetGnomeFileEntry (CalibrWidget, "CalibrationLevelsChromFileEntry", Chrom[DataSource].CalibrChrom->ChromName);
} // GetCalibrChromWidgets

extern void
GetConcField (GtkWidget *CalibrWidget) {
int Idx;

  DATASOURCE(CalibrWidget);
  CAL_SELECTEDS(CalibrWidget);

  if (SelectedComponent < 0) return;
  if (SelectedLevel < 0) return;

  Idx = GetConc (SelectedComponent, SelectedLevel, DataSource);
  Chrom[DataSource].CalibrConc->Concentration = GetSpinButtonFloat (GTK_WIDGET(CalibrationWindow), "CalibrationSetConcSpinButton");
  SetConc (SelectedComponent, SelectedLevel, DataSource);
} // GetConcField

extern void
SetConcField (GtkWidget *CalibrWidget) {
int Idx;

  DATASOURCE(CalibrWidget);
  CAL_SELECTEDS(CalibrWidget);

  if (SelectedComponent < 0) return;
  if (SelectedLevel < 0) return;

  Idx = GetConc (SelectedComponent, SelectedLevel, DataSource);
  SetSpinButtonValue (GTK_WIDGET(CalibrationWindow), "CalibrationSetConcSpinButton", Chrom[DataSource].CalibrConc->Concentration);
} // SetConcField

extern void
RefreshCellDataPeakList (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget *CellDataPeakList;
char *RowData[4];
int i;

  RowData[0] = alloca(20);
  RowData[1] = alloca(200);
  RowData[2] = alloca(200);
  RowData[3] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");

  CellDataPeakList = lookup_widget(CalibrWidget,"CalibrationCellDataPeakListCList");
  gtk_clist_clear (GTK_CLIST (CellDataPeakList));

  for (i=0; i<Chrom[DataSource].CalibrChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrActualDetector]; i++)
  {
	  GetCalibrPeak (i, DataSource);
	  sprintf (RowData[0],"%d",i+1);
	  sprintf (RowData[1],"%.3f", Chrom[DataSource].CalibrPeak->PeakRetention);
	  sprintf (RowData[2],"%.3f", Chrom[DataSource].CalibrPeak->PeakArea);
	  sprintf (RowData[3]," ");
	  gtk_clist_append (GTK_CLIST(CellDataPeakList),RowData);
  } // for i
} // RefreshCellDataPeakList

extern void
RefreshCellDataField (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget *CDField;
GtkTextBuffer *CDBuffer;
gchar *TextBuffer;
gchar *TextBufferTmp;
gchar *TmpBaseName;
int CellIdx;

  TextBuffer = alloca (1000);
  TextBufferTmp = alloca (1000);
  TmpBaseName = alloca (1000);
  CDField = lookup_widget (CalibrWidget, "CalibrationCellDataCellDataTextView");
  CDBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CDField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CDBuffer, TextBuffer, -1);

  CAL_SELECTEDS(CalibrWidget);

  if (SelectedComponent < 0) return;
  if (SelectedLevel < 0) return;
  if (SelectedChrom < 0) return;

  sprintf (TextBuffer, "Cell data at selection\n");
  GetComponent (SelectedComponent, DataSource);
  sprintf (TextBufferTmp, "Comp: %s\n", Chrom[DataSource].CalibrComponent->ComponentName);
  strcat (TextBuffer, TextBufferTmp);

  GetLevel (SelectedLevel, DataSource);
  sprintf (TextBufferTmp, "Level: %s\n", Chrom[DataSource].CalibrLevel->LevelName);
  strcat (TextBuffer, TextBufferTmp);

  GetChrom (SelectedLevel, SelectedChrom, DataSource);
  TmpBaseName = g_path_get_basename (Chrom[DataSource].CalibrChrom->ChromName);
  sprintf (TextBufferTmp, "Chrom: %s\n\n", TmpBaseName);
  g_free (TmpBaseName);
  strcat (TextBuffer, TextBufferTmp);

  NewCell (DataSource);
  CellIdx = GetCell (SelectedComponent, SelectedLevel, SelectedChrom, DataSource);

  sprintf (TextBufferTmp, "CellIdx: %d\n", CellIdx);
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "Retention: %.3f\n", Chrom[DataSource].CalibrCell->RetTime);
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "Height: %.3f\n", Chrom[DataSource].CalibrCell->Height);
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "Area: %.3f\n", Chrom[DataSource].CalibrCell->Integral);
  strcat (TextBuffer, TextBufferTmp);

/*
  sprintf (TextBufferTmp, "", );
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "", );
  strcat (TextBuffer, TextBufferTmp);
*/

  gtk_text_buffer_set_text (CDBuffer, TextBuffer, -1);

} // RefreshCellData

extern void
RefreshSelectedPeakDataField (int DataSource, GtkWidget *CalibrWidget) {
GtkWidget *PDField;
GtkTextBuffer *PDBuffer;
gchar *TextBuffer;
gchar *TextBufferTmp;
int SelectedComponent, SelectedLevel, SelectedChrom;
int SelectedChromPeak;
gchar *TmpBaseName;

  TextBuffer = alloca (1000);
  TextBufferTmp = alloca (1000);
  TmpBaseName = alloca (1000);
  PDField = lookup_widget (CalibrWidget, "CalibrationCellDataSelectedPeakTextView");
  PDBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (PDField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (PDBuffer, TextBuffer, -1);

  SelectedComponent = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrWidget), "SelectedComponent"));
  SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrWidget), "SelectedLevel"));
  SelectedChrom = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrWidget), "SelectedChrom"));

  SelectedChromPeak = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrWidget), "SelectedChromPeak"));

  //if (SelectedComponent < 0) return;
  //if (SelectedLevel < 0) return;
  if (SelectedChrom < 0) return;

  if (SelectedChromPeak < 0) return;

  sprintf (TextBuffer, "Peak data at selection\n");

  GetCalibrPeak (SelectedChromPeak, DataSource);

  sprintf (TextBufferTmp, "Retention: %.3f\n", Chrom[DataSource].CalibrPeak->PeakRetention);
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "Height: %.3f\n", Chrom[DataSource].CalibrPeak->PeakHeight);
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "Area: %.3f\n", Chrom[DataSource].CalibrPeak->PeakArea);
  strcat (TextBuffer, TextBufferTmp);

/*
  sprintf (TextBufferTmp, "", );
  strcat (TextBuffer, TextBufferTmp);

  sprintf (TextBufferTmp, "", );
  strcat (TextBuffer, TextBufferTmp);
*/

  gtk_text_buffer_set_text (PDBuffer, TextBuffer, -1);

} // RefreshSelectedPeakDataField

extern void
RefreshCalibrCheckWindow (GtkWidget *CalibrWidget) {

  DATASOURCE(CalibrWidget);
  CAL_SELECTEDS(CalibrWidget);

  gtk_object_set_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedComponent", GINT_TO_POINTER(SelectedComponent));
  gtk_object_set_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedLevel", GINT_TO_POINTER(SelectedLevel));
  gtk_object_set_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedChrom", GINT_TO_POINTER(SelectedChrom));

  ExecRefreshCalibrCheckWindow (CalibrWidget);
} // RefreshCalibrCheckWindow

extern void
ExecRefreshCalibrCheckWindow (GtkWidget *CalibrWidget) {
GtkWidget *CCField;
GtkTextBuffer *CCBuffer;
gchar *TextBuffer;
gchar *TextBufferTmp;
int SelectedComponent;
int SelectedLevel;
int SelectedChrom;
int Idx, IdxPrev;

  DATASOURCE(CalibrWidget);
  
  SelectedComponent = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedComponent"));
  SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedLevel"));
  SelectedChrom = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CalibrationCheckWindow), "SelectedChrom"));
  
  TextBuffer = alloca (2000);
  TextBufferTmp = alloca (2000);

  // Head

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckHeadTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Head data set\n");

  sprintf (TextBufferTmp, "ComponentInternalNum: %d     ", Chrom[DataSource].CalibrHead->ComponentInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ComponentNum: %d\n", Chrom[DataSource].CalibrHead->ComponentNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "LevelInternalNum: %d     ", Chrom[DataSource].CalibrHead->LevelInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "LevelNum: %d\n", Chrom[DataSource].CalibrHead->LevelNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ChromInternalNum: %d     ", Chrom[DataSource].CalibrHead->ChromInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ChromNum: %d\n", Chrom[DataSource].CalibrHead->ChromNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "CellNum: %d     ", Chrom[DataSource].CalibrHead->CellNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ConcNum: %d     ", Chrom[DataSource].CalibrHead->ConcNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "IstNum: %d\n", Chrom[DataSource].CalibrHead->IstNum);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  // Component

  GetComponent (SelectedComponent, DataSource);

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckComponentTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Component data set\n");

  sprintf (TextBufferTmp, "ComponentName: %s\n", Chrom[DataSource].CalibrComponent->ComponentName);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ComponentInternalNum: %d\n", Chrom[DataSource].CalibrComponent->ComponentInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "IstFlag: %d\n", Chrom[DataSource].CalibrComponent->IstFlag);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "IstIdNum: %d\n", Chrom[DataSource].CalibrComponent->IstIdNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "AssignIst: %d\n", Chrom[DataSource].CalibrComponent->AssignIst);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  // Level

  GetLevel (SelectedLevel, DataSource);

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckLevelTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Level data set\n");

  sprintf (TextBufferTmp, "LevelName: %s\n", Chrom[DataSource].CalibrLevel->LevelName);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "LevelInternalNum: %d\n", Chrom[DataSource].CalibrLevel->LevelInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ChromNum: %d\n", Chrom[DataSource].CalibrLevel->ChromNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "Volume: %.3f\n", Chrom[DataSource].CalibrLevel->Volume);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "Amount: %.3f\n", Chrom[DataSource].CalibrLevel->Amount);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  // Chrom

  GetChrom (SelectedLevel, SelectedChrom, DataSource);

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckChromTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Chrom data set\n");

  sprintf (TextBufferTmp, "ChromName: %s\n", Chrom[DataSource].CalibrChrom->ChromName);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "LevelInternalNum: %d\n", Chrom[DataSource].CalibrChrom->LevelInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ChromInternalNum: %d\n", Chrom[DataSource].CalibrChrom->ChromInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "Volume: %.3f\n", Chrom[DataSource].CalibrChrom->Volume);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "Amount: %.3f\n", Chrom[DataSource].CalibrChrom->Amount);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  // Conc

  Idx = GetConc (SelectedComponent, SelectedLevel, DataSource);
  IdxPrev = GetSpinButtonInt (CalibrationCheckWindow, "CalibrationCheckConcSpinButton");
  if (Idx == IdxPrev)
	  SetSpinButtonValue (CalibrationCheckWindow, "CalibrationCheckConcSpinButton", -1);
  SetSpinButtonValue (CalibrationCheckWindow, "CalibrationCheckConcSpinButton", Idx);

  // Cell

  Idx = GetCell (SelectedComponent, SelectedLevel, SelectedChrom, DataSource);
  IdxPrev = GetSpinButtonInt (CalibrationCheckWindow, "CalibrationCheckCellSpinButton");
  if (Idx == IdxPrev)
	  SetSpinButtonValue (CalibrationCheckWindow, "CalibrationCheckCellSpinButton", -1);
  SetSpinButtonValue (CalibrationCheckWindow, "CalibrationCheckCellSpinButton", Idx);
} // ExecRefreshCalibrCheckWindow

extern void
RefreshCalibrCheckCellByIdx (int Idx, GtkWidget *CalibrWidget) {
GtkWidget *CCField;
GtkTextBuffer *CCBuffer;
gchar *TextBuffer;
gchar *TextBufferTmp;

  DATASOURCE(CalibrWidget);
  GetCellByIdx (Idx, DataSource);

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckCellTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  TextBuffer = alloca (2000);
  TextBufferTmp = alloca (2000);

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Cell data set\n");

  sprintf (TextBufferTmp, "LevelInternalNum: %d\n", Chrom[DataSource].CalibrCell->LevelInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ChromInternalNum: %d\n", Chrom[DataSource].CalibrCell->ChromInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "CompInternalNum: %d\n", Chrom[DataSource].CalibrCell->CompInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "RetTime: %.3f\n", Chrom[DataSource].CalibrCell->RetTime);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "WorkConc: %.3f\n", Chrom[DataSource].CalibrCell->WorkConc);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);
} // RefreshCalibrCheckCellByIdx

extern void
RefreshCalibrCheckConcByIdx (int Idx, GtkWidget *CalibrWidget) {
GtkWidget *CCField;
GtkTextBuffer *CCBuffer;
gchar *TextBuffer;
gchar *TextBufferTmp;

  DATASOURCE(CalibrWidget);
  GetConcByIdx (Idx, DataSource);

  CCField = lookup_widget (CalibrationCheckWindow, "CalibrationCheckConcTextView");
  CCBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CCField));

  TextBuffer = alloca (2000);
  TextBufferTmp = alloca (2000);

  sprintf (TextBuffer, "");
  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);

  sprintf (TextBuffer, "Conc data set\n");

  sprintf (TextBufferTmp, "CompInternalNum: %d\n", Chrom[DataSource].CalibrConc->CompInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "LevelInternalNum: %d\n", Chrom[DataSource].CalibrConc->LevelInternalNum);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "Concentration: %.3f\n", Chrom[DataSource].CalibrConc->Concentration);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "ParameterEndResult: %.3f\n", Chrom[DataSource].CalibrConc->ParameterEndResult);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "WorkValue: %.3f\n", Chrom[DataSource].CalibrConc->WorkValue);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "AreaMean: %.3f\n", Chrom[DataSource].CalibrConc->AreaMean);
  strcat (TextBuffer, TextBufferTmp);
  sprintf (TextBufferTmp, "HeightMean: %.3f\n", Chrom[DataSource].CalibrConc->HeightMean);
  strcat (TextBuffer, TextBufferTmp);

  gtk_text_buffer_set_text (CCBuffer, TextBuffer, -1);
} // RefreshCalibrCheckConcByIdx
