// Widget functions

#include "functions_widget_central.c"
#include "functions_widget_method.c"
#include "functions_widget_measure.c"
#include "functions_widget_calibr.c"

extern void
PresetMainWidgets (void) {
GtkWidget		*MainNotebook;

  MainNotebook = lookup_widget (MainWindow, "MainNotebook");
  if (MainNotebook == NULL) {
	PRINTF ("*** (MainNotebook == NULL) failed\n",0);
	return;
  } // MainNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (MainNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (MainNotebook), FALSE);
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "None");
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "LabChrom-2 Chromatographic Workstation");
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "LabChrom-2 Multi-instrument Data Station");
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "LabChrom-2 for TR541a TLC scanner");
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "LabChrom-2 for TR542 TLC scanner");
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (MainNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	gtk_window_set_title (GTK_WINDOW (MainWindow), "LabChrom-2 for TR930 TLC scanner");
		break;
  } // switch
  DATA_UP(MainWindow, "MainQueueItem", -1);
  DATA_UP(MainWindow, "TR541SelectedTrack", 1);
  ADSI_UP(MainWindow, 0);
  gtk_object_set_data (GTK_OBJECT(MainWindow), "CalibrationWindow", NULL);
  if ((MainWindowShrink) && (!MainWindowShrinked))
	  ShrinkMainWindow();
} // PresetMainWidgets

extern void
ActivateMainWidgets (void) {
  ADSI(MainWindow);
  ActivateWidget (MainWindow, "MainRunningQueueButton", FALSE);
  ActivateWidget (MainWindow, "MainCloseButton", FALSE);
  if ((ThreadStatus[ActualDSInstrument] != ThreadStatusIdle) &&\
	  (Options[ActualDSInstrument].DataAcqMode) == MeasureRunModeQueue)
	  ActivateWidget (MainWindow, "MainRunningQueueButton", TRUE);
  if (Chrom[WorkArea]. FileLoaded[LayFlag])
	  ActivateWidget (MainWindow, "MainCloseButton", TRUE);

//  ActivateWidget (MainWindow, "", FALSE);
} // ActivateMainWidgets

extern void
RefreshMainWidgets (GtkWidget *MainWidget) {

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		if (Chrom[WorkArea].FileLoaded[LayFlag]) {
			TR541RawRedraw (WorkArea, lookup_widget(MainWidget, "MainTR541DrawingArea"));
			TR541TrackRedraw (WorkArea, lookup_widget(MainWidget, "MainTR541ChromDrawingArea"));
		} // if LayFlag
		else TR541MainClean (MainWidget);
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
  MainDrawingAreaNeedRedraw = FALSE;
} // RefreshMainWidgets

extern void
RefreshMainQueue (GtkWidget *MainWidget) {
int i;
GtkWidget *QueueList;
char *RowData[3];
int DataSource;
int InstrumentType;

  DataSource = WorkArea;
  InstrumentType = LC2.Instruments[ActualInstrument].InstrumentType;

  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(1200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  QueueList = lookup_widget(MainWidget, "MainCList");
  gtk_clist_clear (GTK_CLIST (QueueList));

  gtk_clist_freeze (GTK_CLIST (QueueList));
  for (i=0; i<Chrom[DataSource].QueueHead.QueueItemNum; i++)
  {
	  GetQueueItem (DataSource, i);
	  sprintf (RowData[0],"%d",i+1);
	  switch (InstrumentType) {
		case InstrumentNone :
			break;
		case InstrumentWorkstation :
		case InstrumentDataStation :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.SamplerPosition);
			break;
		case InstrumentTR541 :
		case InstrumentTR542 :
		case InstrumentTR930 :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.TrackPosition);
			break;
	  } // switch
	  sprintf (RowData[2],"%s",Chrom[DataSource].QueueItem.BaseFileName);
	  gtk_clist_append (GTK_CLIST(QueueList),RowData);
  } // for i
  gtk_clist_thaw (GTK_CLIST (QueueList));
} // RefreshMainQueue

extern void
RefreshReprocessQueue (GtkWidget *ReprocessWidget) {
int i;
GtkWidget *QueueList;
char *RowData[5];
int DataSource;
int InstrumentType;

  DataSource = WorkArea;
  InstrumentType = LC2.Instruments[ActualInstrument].InstrumentType;

  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(1200);
  RowData[3] = alloca(50);
  RowData[4] = alloca(50);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");
  strcpy(RowData[4],"");

  QueueList = lookup_widget(ReprocessWidget, "ReprocessQueueCList");
  gtk_clist_clear (GTK_CLIST (QueueList));

  gtk_clist_freeze (GTK_CLIST (QueueList));
  for (i=0; i<Chrom[DataSource].QueueHead.QueueItemNum; i++)
  {
	  GetQueueItem (DataSource, i);
	  sprintf (RowData[0],"%d",i+1);
	  switch (InstrumentType) {
		case InstrumentNone :
			break;
		case InstrumentWorkstation :
		case InstrumentDataStation :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.SamplerPosition);
			break;
		case InstrumentTR541 :
		case InstrumentTR542 :
		case InstrumentTR930 :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.TrackPosition);
			break;
	  } // switch
	  strcpy (RowData[2], Chrom[DataSource].QueueItem.BaseFileName);
	  gtk_clist_append (GTK_CLIST(QueueList),RowData);
  } // for i
  gtk_clist_thaw (GTK_CLIST (QueueList));
} // RefreshReprocessQueue

extern void
PresetSampleQueueWidgets (GtkWidget *QueueMainWidget,
									int InstrumentType,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton,
									ApplyFunctionType ApplyFunction,
									DestroyFunctionType DestroyFunction) {
GtkWidget *MeasureGCTLCNotebook;

  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "OpenFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "SaveFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "OpenSaveFileSelection", NULL);

  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "InstrumentType", GINT_TO_POINTER(InstrumentType));
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "CallerButton", CallerButton);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "ApplyFunction", ApplyFunction);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "DestroyFunction", DestroyFunction);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);
  MeasureGCTLCNotebook = lookup_widget (QueueMainWidget, "SampleQueueGCHPLCNoteBook");
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (MeasureGCTLCNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (MeasureGCTLCNotebook), FALSE);

  switch (InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	case InstrumentDataStation :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 0);
		break;
	case InstrumentTR541 :
	case InstrumentTR542 :
	case InstrumentTR930 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 1);
		break;
  } // switch

  MeasureGCTLCNotebook = lookup_widget (QueueMainWidget, "SampleQueueListNotebook");
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (MeasureGCTLCNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (MeasureGCTLCNotebook), FALSE);

  switch (InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	case InstrumentDataStation :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 0);
		break;
	case InstrumentTR541 :
	case InstrumentTR542 :
	case InstrumentTR930 :
		gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 1);
		break;
  } // switch
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeComboBox")), 0);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeLevelModeComboBox")), 0);
  ActivateQueueListWidgets (QueueMainWidget);
} // PresetSampleQueueWidgets

extern void
GetSampleQueueWidgets (GtkWidget *QueueMainWidget) {
int InstrumentType;

  DATASOURCE(QueueMainWidget);
  InstrumentType = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (QueueMainWidget), "InstrumentType"));

  strcpy (Chrom[DataSource].QueueHead.BaseName, GetEntry (QueueMainWidget, "SampleQueueFileNameEntry"));
  GetGnomeFileEntry (QueueMainWidget, "SampleQueueDataDirFileEntry", Chrom[DataSource].QueueHead.Directory);
  if (Chrom[DataSource].QueueHead.Directory[strlen(Chrom[DataSource].QueueHead.Directory) - 1] != '/')
	  strcat (Chrom[DataSource].QueueHead.Directory, "/");
  GetGnomeFileEntry (QueueMainWidget, "SampleQueueCommonMethodFileEntry", Chrom[DataSource].QueueHead.MethodName);
  GetGnomeFileEntry (QueueMainWidget, "SampleQueueCalibrationFileEntry", Chrom[DataSource].QueueHead.Calibration);
  Chrom[DataSource].QueueHead.QueueType = InstrumentType;
  Chrom[DataSource].QueueHead.AddSubfolder = GetCheckBox (QueueMainWidget, "SampleQueueSubDirCheckButton");
  Chrom[DataSource].QueueHead.CalibrationTemplate = GetCheckBox (QueueMainWidget, "SampleQueueCalibrationTemplateCheckButton");
  Chrom[DataSource].QueueHead.CalibrationLocalCopy = GetCheckBox (QueueMainWidget, "SampleQueueCalibrationLocalCopyCheckButton");
  Chrom[DataSource].QueueHead.MeasureTime = GetSpinButtonInt (QueueMainWidget, "SampleQueueGCHPLCMeasureTimeSpinButton");
  Chrom[DataSource].QueueHead.SamplerPosition = GetSpinButtonInt (QueueMainWidget, "SampleQueueGCHPLCSamplerPositionSpinButton");
  Chrom[DataSource].QueueHead.NumberOfChroms = GetSpinButtonInt (QueueMainWidget, "SampleQueueGCHPLCNumChromSpinButton");
  Chrom[DataSource].QueueHead.StartExt = GetSpinButtonInt (QueueMainWidget, "SampleQueueGCHPLCStartExtensionSpinButton");
  Chrom[DataSource].QueueHead.ManualStepForwardDefault = GetCheckBox (QueueMainWidget, "SampleQueueGCHPLCManualForwardDefaultCheckButton");
  Chrom[DataSource].QueueHead.Append = GetCheckBox (QueueMainWidget, "SampleQueueGCHPLCAppendCheckBox");
  Chrom[DataSource].QueueHead.StartPoint = GetSpinButtonFloat (QueueMainWidget, "SampleQueueLayerStartPointSpinButton");
  Chrom[DataSource].QueueHead.Difference = GetSpinButtonFloat (QueueMainWidget, "SampleQueueLayerDifferenceSpinButton");
  Chrom[DataSource].QueueHead.NumberOfTracks = GetSpinButtonInt (QueueMainWidget, "SampleQueueLayerNumTracksSpinButton");
  Chrom[DataSource].QueueHead.LastMeasureTime = GetSpinButtonInt (QueueMainWidget, "SampleQueueListMeasureTimeSpinButton");
} // GetSampleQueueWidgets

extern void
SetSampleQueueWidgets (GtkWidget *QueueMainWidget) {

  DATASOURCE(QueueMainWidget);

  SetEntry (QueueMainWidget, "SampleQueueFileNameEntry", Chrom[DataSource].QueueHead.BaseName);
  SetGnomeFileEntry (QueueMainWidget, "SampleQueueDataDirFileEntry", Chrom[DataSource].QueueHead.Directory);
  SetGnomeFileEntry (QueueMainWidget, "SampleQueueCommonMethodFileEntry", Chrom[DataSource].QueueHead.MethodName);
  SetGnomeFileEntry (QueueMainWidget, "SampleQueueCalibrationFileEntry", Chrom[DataSource].QueueHead.Calibration);
  SetCheckBox (QueueMainWidget, "SampleQueueSubDirCheckButton", Chrom[DataSource].QueueHead.AddSubfolder);
  SetCheckBox (QueueMainWidget, "SampleQueueCalibrationTemplateCheckButton", Chrom[DataSource].QueueHead.CalibrationTemplate);
  SetCheckBox (QueueMainWidget, "SampleQueueCalibrationLocalCopyCheckButton", Chrom[DataSource].QueueHead.CalibrationLocalCopy);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueGCHPLCMeasureTimeSpinButton", Chrom[DataSource].QueueHead.MeasureTime);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueGCHPLCSamplerPositionSpinButton", Chrom[DataSource].QueueHead.SamplerPosition);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueGCHPLCNumChromSpinButton", Chrom[DataSource].QueueHead.NumberOfChroms);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueGCHPLCStartExtensionSpinButton", Chrom[DataSource].QueueHead.StartExt);
  SetCheckBox (QueueMainWidget, "SampleQueueGCHPLCManualForwardDefaultCheckButton", Chrom[DataSource].QueueHead.ManualStepForwardDefault);
  SetCheckBox (QueueMainWidget, "SampleQueueGCHPLCAppendCheckBox", Chrom[DataSource].QueueHead.Append);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueLayerStartPointSpinButton", Chrom[DataSource].QueueHead.StartPoint);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueLayerDifferenceSpinButton", Chrom[DataSource].QueueHead.Difference);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueLayerNumTracksSpinButton", Chrom[DataSource].QueueHead.NumberOfTracks);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueListMeasureTimeSpinButton", Chrom[DataSource].QueueHead.LastMeasureTime);
  gtk_object_set_data (GTK_OBJECT (QueueMainWidget), "SelectedItem", GINT_TO_POINTER(-1));
  ActivateQueueListWidgets (QueueMainWidget);
} // SetSampleQueueWidgets

extern void
GetQueueItemWidgets (GtkWidget *QueueMainWidget) {

  DATASOURCE(QueueMainWidget);

  strcpy (Chrom[DataSource].QueueItem.BaseFileName, GetEntry (QueueMainWidget, "SampleQueueNameEntry"));
  strcpy (Chrom[DataSource].QueueItem.BaseExtName, GetEntry (QueueMainWidget, "SampleQueueExtEntry"));
  Chrom[DataSource].QueueItem.ExtIdx = atoi (Chrom[DataSource].QueueItem.BaseExtName);
  sprintf (Chrom[DataSource].QueueItem.BaseExtName, "%.3d", Chrom[DataSource].QueueItem.ExtIdx);
  SetEntry (QueueMainWidget, "SampleQueueExtEntry", Chrom[DataSource].QueueItem.BaseExtName);
  strcpy (Chrom[DataSource].QueueItem.Comment, GetEntry (QueueMainWidget, "SampleQueueCommentEntry"));
  strcpy (Chrom[DataSource].QueueItem.Id, GetEntry (QueueMainWidget, "SampleQueueIDEntry"));
  strcpy (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseFileName);
  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".");
  strcat (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseExtName);
  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".chr");

  Chrom[DataSource].QueueItem.SampleType = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeComboBox")));
  Chrom[DataSource].QueueItem.StandardAutoCalibrate = GetCheckBox (QueueMainWidget, "SampleQueueSampleTypeAutoCalibrCheckButton");
  Chrom[DataSource].QueueItem.StandardLevel = GetSpinButtonInt (QueueMainWidget, "SampleQueueSampleTypeLevelSpinButton");
  Chrom[DataSource].QueueItem.StandardMode = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeLevelModeComboBox")));

  Chrom[DataSource].QueueItem.Volume = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiVolumeSpinButton");
  Chrom[DataSource].QueueItem.Amount = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiAmountSpinButton");
  Chrom[DataSource].QueueItem.Factor = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiFactorSpinButton");
  Chrom[DataSource].QueueItem.Pressure = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiPressureSpinButton");
  Chrom[DataSource].QueueItem.Temperature = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiTemperSpinButton");
  Chrom[DataSource].QueueItem.ScaleFactor = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiScaleFactorSpinButton");
  Chrom[DataSource].QueueItem.InjectedVolume = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiInjVolSpinButton");
  Chrom[DataSource].QueueItem.IstConc = GetSpinButtonFloat (QueueMainWidget, "SampleQueueQuantiISTConcSpinButton");

  Chrom[DataSource].QueueItem.SamplerPosition = GetSpinButtonInt (QueueMainWidget, "SampleQueueListSamplerSpinButton");
  Chrom[DataSource].QueueItem.TrackPosition = GetSpinButtonInt (QueueMainWidget, "SampleQueueListTrackPositionSpinButton");
  Chrom[DataSource].QueueItem.MeasureTime = GetSpinButtonFloat (QueueMainWidget, "SampleQueueListMeasureTimeSpinButton");
  Chrom[DataSource].QueueItem.ManualStepForward = GetCheckBox (QueueMainWidget, "SampleQueueListWaitChechkButton");
} // GetQueueItemWidgets

extern void
SetQueueItemWidgets (GtkWidget *QueueMainWidget) {

  DATASOURCE(QueueMainWidget);

  SetEntry (QueueMainWidget, "SampleQueueNameEntry", Chrom[DataSource].QueueItem.BaseFileName);
  sprintf (Chrom[DataSource].QueueItem.BaseExtName, "%.3d", Chrom[DataSource].QueueItem.ExtIdx);
  SetEntry (QueueMainWidget, "SampleQueueExtEntry", Chrom[DataSource].QueueItem.BaseExtName);
  SetEntry (QueueMainWidget, "SampleQueueCommentEntry", Chrom[DataSource].QueueItem.Comment);
  SetEntry (QueueMainWidget, "SampleQueueIDEntry", Chrom[DataSource].QueueItem.Id);
  //FinalFilename[FilenameLength];

  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeComboBox")), Chrom[DataSource].QueueItem.SampleType);
  SetCheckBox (QueueMainWidget, "SampleQueueSampleTypeAutoCalibrCheckButton", Chrom[DataSource].QueueItem.StandardAutoCalibrate);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueSampleTypeLevelSpinButton", Chrom[DataSource].QueueItem.StandardLevel);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (QueueMainWidget, "SampleQueueSampleTypeLevelModeComboBox")), Chrom[DataSource].QueueItem.StandardMode);

  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiVolumeSpinButton", Chrom[DataSource].QueueItem.Volume);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiAmountSpinButton", Chrom[DataSource].QueueItem.Amount);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiFactorSpinButton", Chrom[DataSource].QueueItem.Factor);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiPressureSpinButton", Chrom[DataSource].QueueItem.Pressure);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiTemperSpinButton", Chrom[DataSource].QueueItem.Temperature);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiScaleFactorSpinButton", Chrom[DataSource].QueueItem.ScaleFactor);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiInjVolSpinButton", Chrom[DataSource].QueueItem.InjectedVolume);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueQuantiISTConcSpinButton", Chrom[DataSource].QueueItem.IstConc);

  SetSpinButtonValue (QueueMainWidget, "SampleQueueListSamplerSpinButton", Chrom[DataSource].QueueItem.SamplerPosition);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueListTrackPositionSpinButton", Chrom[DataSource].QueueItem.TrackPosition);
  SetSpinButtonValue (QueueMainWidget, "SampleQueueListMeasureTimeSpinButton", Chrom[DataSource].QueueItem.MeasureTime);
  SetCheckBox (QueueMainWidget, "SampleQueueListWaitChechkButton", Chrom[DataSource].QueueItem.ManualStepForward);
} // SetQueueItemWidgets

extern void
RefreshQueueList (GtkWidget *QueueMainWidget) {
int i;
GtkWidget *QueueList;
char *RowData[11];
int InstrumentType;

  DATASOURCE(QueueMainWidget);
  InstrumentType = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (QueueMainWidget), "InstrumentType"));

  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(1200);
  RowData[3] = alloca(200);
  RowData[4] = alloca(20);
  RowData[5] = alloca(20);
  RowData[6] = alloca(20);
  RowData[7] = alloca(20);
  RowData[8] = alloca(20);
  RowData[9] = alloca(200);
  RowData[10] = alloca(200);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");
  strcpy(RowData[4],"");
  strcpy(RowData[5],"");
  strcpy(RowData[6],"");
  strcpy(RowData[7],"");
  strcpy(RowData[8],"");
  strcpy(RowData[9],"");
  strcpy(RowData[10],"");

  QueueList = lookup_widget(QueueMainWidget, "SampleQueueCList");
  gtk_clist_clear (GTK_CLIST (QueueList));

  gtk_clist_freeze (GTK_CLIST (QueueList));
  for (i=0; i<Chrom[DataSource].QueueHead.QueueItemNum; i++)
  {
	  GetQueueItem (DataSource, i);
	  sprintf (RowData[0],"%d",i+1);
	  switch (InstrumentType) {
		case InstrumentNone :
			break;
		case InstrumentWorkstation :
		case InstrumentDataStation :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.SamplerPosition);
			break;
		case InstrumentTR541 :
		case InstrumentTR542 :
		case InstrumentTR930 :
			sprintf (RowData[1],"%d",Chrom[DataSource].QueueItem.TrackPosition);
			break;
	  } // switch
	  sprintf (RowData[2],"%s",Chrom[DataSource].QueueItem.BaseFileName);
	  sprintf (RowData[3],"%s",Chrom[DataSource].QueueItem.BaseExtName);
	  switch (Chrom[DataSource].QueueItem.SampleType) {
		  case SampleTypeSample:
			  sprintf (RowData[4],"Sample");
			  break;
		  case SampleTypeControl:
			  sprintf (RowData[4],"Control");
			  break;
		  case SampleTypeStandard:
			  sprintf (RowData[4],"Standard");
			  break;
		  case SampleTypeRetControl:
			  sprintf (RowData[4],"RetControl");
			  break;
	  }
	  sprintf (RowData[5],"%d",Chrom[DataSource].QueueItem.StandardLevel);
	  sprintf (RowData[6],"%.3f",Chrom[DataSource].QueueItem.Volume);
	  sprintf (RowData[7],"%.3f",Chrom[DataSource].QueueItem.Amount);
	  sprintf (RowData[8],"%.3f",Chrom[DataSource].QueueItem.Factor);
	  sprintf (RowData[9],"%s",Chrom[DataSource].QueueItem.Id);
	  sprintf (RowData[10],"%s",Chrom[DataSource].QueueItem.Comment);
	  gtk_clist_append (GTK_CLIST(QueueList),RowData);
	  if (Chrom[DataSource].QueueItem.QueueItemLocked)
		  gtk_clist_set_selectable (GTK_CLIST(QueueList), i, FALSE);
	  if (Chrom[DataSource].QueueItem.QueueItemLocked) {
		  gtk_clist_set_foreground (GTK_CLIST (QueueList), i, &MQListLockedFGColor);
		  gtk_clist_set_background (GTK_CLIST (QueueList), i, &MQListLockedBGColor);
	  } // QueueItemLocked
  } // for i
  gtk_clist_thaw (GTK_CLIST (QueueList));
  if (DataSource == 0)
	  MeasureLayerDrawingAreaNeedRedraw = TRUE;
} // RefreshQueueList

extern void
ActivateQueueListWidgets (GtkWidget *QueueMainWidget) {
int QueIdx;

  DATASOURCE(QueueMainWidget);
  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (QueueMainWidget), "SelectedItem"));

  if (Chrom[DataSource].QueueHead.QueueItemNum != 0) {
	  ActivateWidget (QueueMainWidget, "SampleQueueRemoveButton", TRUE);
	  ActivateWidget (QueueMainWidget, "SampleQueueModifyButton", TRUE);
	  ActivateWidget (QueueMainWidget, "SampleQueueInsertButton", TRUE);
	  ActivateWidget (QueueMainWidget, "SampleQueueUpButton", TRUE);
	  ActivateWidget (QueueMainWidget, "SampleQueueDownButton", TRUE);
  } // QueueItemNum != 0

  if (Chrom[DataSource].QueueHead.QueueItemNum == 0) {
	  ActivateWidget (QueueMainWidget, "SampleQueueRemoveButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueModifyButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueInsertButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueUpButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueDownButton", FALSE);
  } // QueueItemNum == 0

  if (QueIdx != -1) {
	  GetQueueItem (DataSource, QueIdx);
	  if (!Chrom[DataSource].QueueItem.QueueItemLocked) {
		  ActivateWidget (QueueMainWidget, "SampleQueueRemoveButton", TRUE);
		  ActivateWidget (QueueMainWidget, "SampleQueueModifyButton", TRUE);
		  ActivateWidget (QueueMainWidget, "SampleQueueInsertButton", TRUE);
		  ActivateWidget (QueueMainWidget, "SampleQueueUpButton", TRUE);
		  ActivateWidget (QueueMainWidget, "SampleQueueDownButton", TRUE);
	  } else {
		  ActivateWidget (QueueMainWidget, "SampleQueueRemoveButton", FALSE);
		  ActivateWidget (QueueMainWidget, "SampleQueueModifyButton", FALSE);
		  ActivateWidget (QueueMainWidget, "SampleQueueInsertButton", FALSE);
		  ActivateWidget (QueueMainWidget, "SampleQueueUpButton", FALSE);
		  ActivateWidget (QueueMainWidget, "SampleQueueDownButton", FALSE);
	  }
  } // QueIdx != -1

  if (QueIdx == -1) {
	  ActivateWidget (QueueMainWidget, "SampleQueueRemoveButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueModifyButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueInsertButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueUpButton", FALSE);
	  ActivateWidget (QueueMainWidget, "SampleQueueDownButton", FALSE);
  } // QueIdx == -1

  if (Chrom[DataSource].QueueHead.QueueItemNum < 1)
	  ActivateWidget (SampleQueueWindow, "SampleQueueOkButton", FALSE);
  else
	  ActivateWidget (SampleQueueWindow, "SampleQueueOkButton", TRUE);
  if (DataSource == DevelopSingleFile)
	  ActivateWidget (SampleQueueWindow, "SampleQueueOkButton", TRUE);
} // ActivateQueueListWidgets

extern void
MakeQueueDialogTree (GtkWidget *QueueDialog) {
  GtkListStore *Store;
  GtkWidget *Tree;
  GtkTreeViewColumn *Column;
  GtkCellRenderer *Renderer;
  GtkTreeSelection *Selection;

enum {
   NUMBER_COLUMN,
   SAMPLETYPE_COLUMN,
   NAME_COLUMN,
   FULLNAME_COLUMN,
   N_COLUMNS
};

  Store = gtk_list_store_new (N_COLUMNS,
                              G_TYPE_INT,
                              G_TYPE_STRING,
                              G_TYPE_STRING,
                              G_TYPE_STRING);
  Tree = lookup_widget (QueueDialog, "SelectQueueItemTreeView");
  gtk_tree_view_set_model (GTK_TREE_VIEW(Tree), GTK_TREE_MODEL (Store));
  g_object_unref (G_OBJECT (Store));
  Selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(Tree));
  gtk_tree_selection_set_mode (Selection, GTK_SELECTION_BROWSE);

   /* Create a cell render and arbitrarily make it red for demonstration
    * purposes */
  Renderer = gtk_cell_renderer_text_new ();
  g_object_set (G_OBJECT (Renderer), "foreground", "black", NULL);

  Column = gtk_tree_view_column_new_with_attributes ("#", Renderer,
                                                     "text", NUMBER_COLUMN, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (Tree), Column);

  Renderer = gtk_cell_renderer_text_new ();
  Column = gtk_tree_view_column_new_with_attributes ("Type", Renderer,
                                                      "text", SAMPLETYPE_COLUMN, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (Tree), Column);

  Renderer = gtk_cell_renderer_text_new ();
  Column = gtk_tree_view_column_new_with_attributes ("Name", Renderer,
                                                      "text", NAME_COLUMN, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (Tree), Column);

  Renderer = gtk_cell_renderer_text_new ();
  Column = gtk_tree_view_column_new_with_attributes ("Full", Renderer,
                                                      "text", FULLNAME_COLUMN, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (Tree), Column);
  gtk_tree_view_column_set_visible (Column, FALSE);

  /* Now we can manipulate the view just like any other GTK widget */


} // MakeQueueDialogTree

extern void
RefreshQueueDialogWidgets (GtkWidget *QueueDialog) {
  GtkWidget *Tree;
  GtkListStore *Store;
  GtkTreeModel *Model;
  GtkTreeIter Iter;
  gchar *ListName;
  gchar TypeName[30];
  int i;

enum {
   NUMBER_COLUMN,
   SAMPLETYPE_COLUMN,
   NAME_COLUMN,
   FULLNAME_COLUMN,
   N_COLUMNS
};

  DATASOURCE(QueueDialog);
  Tree = lookup_widget (QueueDialog, "SelectQueueItemTreeView");
  Model = gtk_tree_view_get_model (GTK_TREE_VIEW(Tree));
  Store = GTK_LIST_STORE(Model);

  for (i = 0; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
	  GetQueueItem (DataSource, i);
	  gtk_list_store_append (Store, &Iter);
	  ListName = g_path_get_basename (Chrom[DataSource].QueueItem.FinalFilename);
	  switch (Chrom[DataSource].QueueItem.SampleType) {
		  case SampleTypeSample:
			  strcpy (TypeName, "Sample");
			  break;
		  case SampleTypeControl:
			  strcpy (TypeName, "Control");
			  break;
		  case SampleTypeStandard:
			  strcpy (TypeName, "Standard");
			  break;
		  case SampleTypeRetControl:
			  strcpy (TypeName, "RetControl");
			  break;
	  }  // switch SampleType
	  gtk_list_store_set (Store, &Iter,
                          NUMBER_COLUMN, (i + 1),
                          SAMPLETYPE_COLUMN, TypeName,
                          NAME_COLUMN, ListName,
                          FULLNAME_COLUMN, Chrom[DataSource].QueueItem.FinalFilename,
                          -1);
	  g_free (ListName);
  } // i

} // RefreshQueueDialogWidgets

extern void
PresetPreferencesWidgets (GtkWidget *PreferencesMainWidget,
									int DefaultNoteTab,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton,
									ApplyFunctionType ApplyFunction) {
GtkWidget		*PreferencesNotebook;
GtkWidget		*PreferencesMeasureNotebook;
int				i;
int ADSI;
char *TemplateName;
char *InternalTemplate;

  ADSI = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (PreferencesMainWidget), "ActualDSInstrument"));

  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "DefaultNoteTab", GINT_TO_POINTER(DefaultNoteTab));
  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "CallerButton", CallerButton);
  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "ApplyFunction", ApplyFunction);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);

  PreferencesNotebook = lookup_widget (PreferencesWindow, "PreferencesNotebook");
  if (PreferencesNotebook == NULL) {
	PRINTF ("*** (PreferencesNotebook == NULL) failed\n",0);
	return;
  } // PreferencesNotebook == NULL
  if (DefaultNoteTab != -1) {
	  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (PreferencesNotebook), FALSE);
	  gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesNotebook), DefaultNoteTab);
  }
  else
	  gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesNotebook), 0);

  PreferencesMeasureNotebook = lookup_widget (PreferencesWindow, "PreferencesMeasureNotebook");
  if (PreferencesMeasureNotebook == NULL) {
	PRINTF ("*** (PreferencesMeasureNotebook == NULL) failed\n",0);
	return;
  } // PreferencesMeasureNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (PreferencesMeasureNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (PreferencesMeasureNotebook), FALSE);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "None");
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Chromatographic Workstation Measure");
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Multi-instrument Data Station Measure");
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR541a Measure");
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR542 Measure");
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (PreferencesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR930 Measure");
		break;
  } // switch

  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (lookup_widget (PreferencesWindow, "PreferencesMeasureDataSeriesNotebook")), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (lookup_widget (PreferencesWindow, "PreferencesMeasureDataSeriesNotebook")), FALSE);

  // Deactivate widgets if measure in progress
  if (ThreadStatus[ADSI] != ThreadStatusIdle) {
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureUniqueRadioButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureQueueRadioButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureContRadioButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureMethodFileEntry", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureDataDirFileEntry", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureRegisterCheckButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureQueueFileEntry", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureRestartQueueByNumRadioButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureRestartNumSpinButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureRestartQueueByTimeRadioButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureRestartDateEdit", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesMeasureTemplateQueueCheckButton", FALSE);
	  ActivateWidget (PreferencesWindow, "PreferencesmeasureTemplateQueueFileEntry", FALSE);
//	  ActivateWidget (PreferencesWindow, "", FALSE);
  } // ThreadStatus[ADSI] != ThreadStatusIdle
  TemplateName = calloc(FilenameLength, sizeof(char));
  InternalTemplate = calloc(ExportInternalTemplateLength, sizeof(char));
  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "TemplateName", TemplateName);
  gtk_object_set_data (GTK_OBJECT (PreferencesMainWidget), "InternalTemplate", InternalTemplate);
} // PresetPreferencesWidgets

extern void
SetPreferencesWidgets (GtkWidget *PreferencesMainWidget) {
char *TemplateName;
char *InternalTemplate;
char *HomeDir;
GtkWidget *CDField;
GtkTextBuffer *CDBuffer;

  ADSI(PreferencesMainWidget);

  // Measure TAB
  switch (Options[ActualDSInstrument].DataAcqMode) {
	  case MeasureRunModeUnique:
		  gtk_notebook_set_current_page (GTK_NOTEBOOK(lookup_widget (PreferencesMainWidget, "PreferencesMeasureDataSeriesNotebook")), 0);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureUniqueRadioButton", TRUE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContRadioButton", FALSE);
		  break;
	  case MeasureRunModeQueue:
		  gtk_notebook_set_current_page (GTK_NOTEBOOK(lookup_widget (PreferencesMainWidget, "PreferencesMeasureDataSeriesNotebook")), 1);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureUniqueRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueRadioButton", TRUE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContRadioButton", FALSE);
		  break;
	  case MeasureRunModeContinous:
		  gtk_notebook_set_current_page (GTK_NOTEBOOK(lookup_widget (PreferencesMainWidget, "PreferencesMeasureDataSeriesNotebook")), 2);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureUniqueRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContRadioButton", TRUE);
		  break;
	  default: {
		  gtk_notebook_set_current_page (GTK_NOTEBOOK(lookup_widget (PreferencesMainWidget, "PreferencesMeasureDataSeriesNotebook")), 0);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureUniqueRadioButton", TRUE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContRadioButton", FALSE);
	  } // default
  } // switch DataAcqMode
  // Common
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureMethodFileEntry", Options[ActualDSInstrument].MeasureMethod);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureDataDirFileEntry", Options[ActualDSInstrument].MeasureDataDir);
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureGenerateDirCheckButton", Options[ActualDSInstrument].GenerateWorkDir);
  // Unique
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRegisterCheckButton", Options[ActualDSInstrument].RegisterInQueue);
  // Queue
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureQueueFileEntry", Options[ActualDSInstrument].QueueName);
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueDefaultsCheckButton", Options[ActualDSInstrument].StoreDefaults);
  // Continous
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContMeasNumCheckButton", Options[ActualDSInstrument].LimitedNumber);
  SetSpinButtonValue (PreferencesMainWidget, "PreferencesMeasureContMeasNumSpinButton", Options[ActualDSInstrument].LimitedNumOfChrom);
  switch (Options[ActualDSInstrument].RestartMode) {
	  case ContinousRestartChrom:
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByNumRadioButton", TRUE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByTimeRadioButton", FALSE);
		  break;
	  case ContinousRestartTime:
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByNumRadioButton", FALSE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByTimeRadioButton", TRUE);
		  break;
	  default: {
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByNumRadioButton", TRUE);
		  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByTimeRadioButton", FALSE);
	  } // default
  } // switch RestartMode
  SetSpinButtonValue (PreferencesMainWidget, "PreferencesMeasureRestartNumSpinButton", Options[ActualDSInstrument].RestartChrom);
  SetDateTime (PreferencesMainWidget, "PreferencesMeasureRestartDateEdit", Options[ActualDSInstrument].RestartTime);
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureTemplateQueueCheckButton", Options[ActualDSInstrument].UseTemplateQueue);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesmeasureTemplateQueueFileEntry", Options[ActualDSInstrument].TemplateQueueName);
  SetCheckBox (PreferencesMainWidget, "PreferencesMeasureContAutogenerateDir", Options[ActualDSInstrument].AutoGenerateDir);
  // Reprocess TAB
  switch (Options[ActualDSInstrument].ExportMode) {
	  case EXPORT_MODE_FIXED:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportFixedRadioButton", TRUE);
		  break;
	  case EXPORT_MODE_FILE:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportFileRadioButton", TRUE);
		  break;
	  case EXPORT_MODE_INTERNAL:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportInternalRadioButton", TRUE);
		  break;
	  default: {
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportFixedRadioButton", TRUE);
	  } // default
  } // switch ExportMode
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportCRLFCheckButton", Options[ActualDSInstrument].ExportDOSLineFeed);
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportExtendedHeaderCheckButton", Options[ActualDSInstrument].ExportExtendedHeader);
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportQuantiDataCheckButton", Options[ActualDSInstrument].ExportQuantitativeData);
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportSampleInfoCheckButton", Options[ActualDSInstrument].ExportSampleInformation);
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportInstrumentParCheckButton", Options[ActualDSInstrument].ExportInstrumentParams);
  switch (Options[ActualDSInstrument].ExportDataInTable) {
	  case EXPORT_TABLE_BASE:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportColumnsShortRadioButton", TRUE);
		  break;
	  case EXPORT_TABLE_EXTENDED:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportColumnsMediumRadioButton", TRUE);
		  break;
	  default: {
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportColumnsShortRadioButton", TRUE);
	  } // default
  } // switch ExportDataInTable
  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportSignaturesCheckButton", Options[ActualDSInstrument].ExportSignatures);
  TemplateName = gtk_object_get_data (GTK_OBJECT(PreferencesMainWidget), "TemplateName");
  strcpy (TemplateName, Options[ActualDSInstrument].ExportTemplate);
  printf ("TemplateName = %s\n", TemplateName);
  if (FileExist (TemplateName))
	  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(lookup_widget(PreferencesMainWidget, "PreferencesReprocessExportFileFileChooserButton")),\
									 TemplateName);
  InternalTemplate = gtk_object_get_data (GTK_OBJECT (PreferencesMainWidget), "InternalTemplate");
  strncpy (InternalTemplate, Options[ActualDSInstrument].ExportInternalTemplate, ExportInternalTemplateLength - 1);
  CDField = lookup_widget (PreferencesMainWidget, "PreferencesReprocessExportInternalTextView");
  CDBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CDField));
  gtk_text_buffer_set_text (CDBuffer, InternalTemplate, -1);
  switch (Options[ActualDSInstrument].ExportInputEnc) {
	  case EXPORT_INPUT_ENC_DEFAULT:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncDefaultRadioButton", TRUE);
		  break;
	  case EXPORT_INPUT_ENC_LOCALE:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncLocaleRadioButton", TRUE);
		  break;
	  case EXPORT_INPUT_ENC_UTF8:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncUTF8RadioButton", TRUE);
		  break;
	  case EXPORT_INPUT_ENC_OTHER:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncOtherRadioButton", TRUE);
		  break;
	  default: {
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncDefaultRadioButton", TRUE);
	  } // default
  } // switch 
  SetEntry (PreferencesMainWidget, "PreferencesReprocessInputEncEntry", Options[ActualDSInstrument].ExportInputEncOther);
  switch (Options[ActualDSInstrument].ExportOutputEnc) {
	  case EXPORT_OUTPUT_ENC_DEFAULT:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncDefaultRadioButton", TRUE);
		  break;
	  case EXPORT_OUTPUT_ENC_LOCALE:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncLocaleRadioButton", TRUE);
		  break;
	  case EXPORT_OUTPUT_ENC_UTF8:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncUTF8RadioButton", TRUE);
		  break;
	  case EXPORT_OUTPUT_ENC_OTHER:
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncOtherRadioButton", TRUE);
		  break;
	  default: {
		  SetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncDefaultRadioButton", TRUE);
	  } // default
  } // switch 
  SetEntry (PreferencesMainWidget, "PreferencesReprocessOutputEncOtherEntry", Options[ActualDSInstrument].ExportOutputEncOther);
  // Directories TAB
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesBugTraceFileEntry", BugTraceDir);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesDataRootFileEntry", Options[ActualDSInstrument].DefaultDataRootDir);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesMethodDirFileEntry", Options[ActualDSInstrument].MethodDir);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesCalibrDirFileEntry", Options[ActualDSInstrument].CalibrDir);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesImportDirFileEntry", Options[ActualDSInstrument].ImportDir);
  SetGnomeFileEntry (PreferencesMainWidget, "PreferencesExportDirFileEntry", Options[ActualDSInstrument].ExportDir);
  // Print TAB
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintFrameCheckButton", Options[ActualDSInstrument].PrintFrame);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintTickMarksCheckButton", Options[ActualDSInstrument].PrintTickMarks);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintBaselineCheckButton", Options[ActualDSInstrument].PrintBaselines);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintXAxisTicksCheckButton", Options[ActualDSInstrument].PrintXAxisTicks);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintXAxisValuesCheckButton", Options[ActualDSInstrument].PrintXAxisValues);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakNameCheckButton", Options[ActualDSInstrument].PrintPeakName);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakNumberCheckButton", Options[ActualDSInstrument].PrintPeakNumber);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakRetentionCheckButton", Options[ActualDSInstrument].PrintPeakRetention);
  SetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakConcentrationCheckButton", Options[ActualDSInstrument].PrintPeakConcentration);
  // General
  SetCheckBox (PreferencesMainWidget, "PreferencesCloseWindowCheckButton", CentralOptions.CentralWindowClose);
  SetCheckBox (PreferencesMainWidget, "PreferencesShrinkMainWindowCheckButton", MainWindowShrink);
  SetCheckBox (PreferencesMainWidget, "PreferencesShrinkedMainWindowTopCheckButton", MainWindowKeepOnTop);
} // SetPreferencesWidgets

extern void
GetPreferencesWidgets (GtkWidget *PreferencesMainWidget) {
int CentralWindowCloseTmp;
char *TemplateName;
GtkTextBuffer *CDBuffer;
GtkWidget *CDField;
GtkTextIter StartIter, EndIter;
char *TemplateText;

  ADSI(PreferencesMainWidget);


  // Measure TAB
  if (GetCheckBox (PreferencesMainWidget, "PreferencesMeasureUniqueRadioButton")) Options[ActualDSInstrument].DataAcqMode = MeasureRunModeUnique;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueRadioButton")) Options[ActualDSInstrument].DataAcqMode = MeasureRunModeQueue;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesMeasureContRadioButton")) Options[ActualDSInstrument].DataAcqMode = MeasureRunModeContinous;
  // Common
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureMethodFileEntry", Options[ActualDSInstrument].MeasureMethod);
  CheckFileName (Options[ActualDSInstrument].MeasureMethod);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureDataDirFileEntry", Options[ActualDSInstrument].MeasureDataDir);
  CheckDirName (Options[ActualDSInstrument].MeasureDataDir);
  Options[ActualDSInstrument].GenerateWorkDir = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureGenerateDirCheckButton");
  // Unique
  Options[ActualDSInstrument].RegisterInQueue = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureRegisterCheckButton");
  // Queue
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesMeasureQueueFileEntry", Options[ActualDSInstrument].QueueName);
  CheckFileName (Options[ActualDSInstrument].QueueName);
  Options[ActualDSInstrument].StoreDefaults = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureQueueDefaultsCheckButton");
  // Continous
  Options[ActualDSInstrument].LimitedNumber = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureContMeasNumCheckButton");
  Options[ActualDSInstrument].LimitedNumOfChrom = GetSpinButtonInt (PreferencesMainWidget, "PreferencesMeasureContMeasNumSpinButton");
  if (GetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByNumRadioButton")) Options[ActualDSInstrument].RestartMode = ContinousRestartChrom;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesMeasureRestartQueueByTimeRadioButton")) Options[ActualDSInstrument].RestartMode = ContinousRestartTime;
  Options[ActualDSInstrument].RestartChrom = GetSpinButtonInt (PreferencesMainWidget, "PreferencesMeasureRestartNumSpinButton");
  Options[ActualDSInstrument].RestartTime = GetDateTime (PreferencesMainWidget, "PreferencesMeasureRestartDateEdit");
  Options[ActualDSInstrument].UseTemplateQueue = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureTemplateQueueCheckButton");
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesmeasureTemplateQueueFileEntry", Options[ActualDSInstrument].TemplateQueueName);
  CheckFileName (Options[ActualDSInstrument].TemplateQueueName);
  Options[ActualDSInstrument].AutoGenerateDir = GetCheckBox (PreferencesMainWidget, "PreferencesMeasureContAutogenerateDir");
  // Reprocess TAB
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportFixedRadioButton"))
	  Options[ActualDSInstrument].ExportMode = EXPORT_MODE_FIXED;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportFileRadioButton"))
	  Options[ActualDSInstrument].ExportMode = EXPORT_MODE_FILE;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportInternalRadioButton"))
	  Options[ActualDSInstrument].ExportMode = EXPORT_MODE_INTERNAL;
  Options[ActualDSInstrument].ExportDOSLineFeed = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportCRLFCheckButton");
  Options[ActualDSInstrument].ExportExtendedHeader = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportExtendedHeaderCheckButton");
  Options[ActualDSInstrument].ExportQuantitativeData = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportQuantiDataCheckButton");
  Options[ActualDSInstrument].ExportSampleInformation = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportSampleInfoCheckButton");
  Options[ActualDSInstrument].ExportInstrumentParams = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportInstrumentParCheckButton");
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportColumnsShortRadioButton"))
	  Options[ActualDSInstrument].ExportDataInTable = EXPORT_TABLE_BASE;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportColumnsMediumRadioButton"))
	  Options[ActualDSInstrument].ExportDataInTable = EXPORT_TABLE_EXTENDED;
  Options[ActualDSInstrument].ExportSignatures = GetCheckBox (PreferencesMainWidget, "PreferencesReprocessExportSignaturesCheckButton");
  TemplateName = gtk_object_get_data (GTK_OBJECT(PreferencesMainWidget), "TemplateName");
  strcpy (Options[ActualDSInstrument].ExportTemplate, TemplateName);
  CDField = lookup_widget (PreferencesMainWidget, "PreferencesReprocessExportInternalTextView");
  CDBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (CDField));
  gtk_text_buffer_get_start_iter (CDBuffer, &StartIter);
  gtk_text_buffer_get_end_iter (CDBuffer, &EndIter);
  TemplateText = gtk_text_buffer_get_text (CDBuffer, &StartIter, &EndIter, FALSE);
  strncpy (Options[ActualDSInstrument].ExportInternalTemplate, TemplateText, ExportInternalTemplateLength - 1);
  free (TemplateText);
  //printf ("Template content:\n%s\n", Options[ActualDSInstrument].ExportInternalTemplate);
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncDefaultRadioButton"))
	  Options[ActualDSInstrument].ExportInputEnc = EXPORT_INPUT_ENC_DEFAULT;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncLocaleRadioButton"))
	  Options[ActualDSInstrument].ExportInputEnc = EXPORT_INPUT_ENC_LOCALE;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncUTF8RadioButton"))
	  Options[ActualDSInstrument].ExportInputEnc = EXPORT_INPUT_ENC_UTF8;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessInputEncOtherRadioButton"))
	  Options[ActualDSInstrument].ExportInputEnc = EXPORT_INPUT_ENC_OTHER;
  strcpy (Options[ActualDSInstrument].ExportInputEncOther, GetEntry (PreferencesMainWidget, "PreferencesReprocessInputEncEntry"));
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncDefaultRadioButton"))
	  Options[ActualDSInstrument].ExportOutputEnc = EXPORT_OUTPUT_ENC_DEFAULT;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncLocaleRadioButton"))
	  Options[ActualDSInstrument].ExportOutputEnc = EXPORT_OUTPUT_ENC_LOCALE;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncUTF8RadioButton"))
	  Options[ActualDSInstrument].ExportOutputEnc = EXPORT_OUTPUT_ENC_UTF8;
  if (GetCheckBox (PreferencesMainWidget, "PreferencesReprocessOutputEncOtherRadioButton"))
	  Options[ActualDSInstrument].ExportOutputEnc = EXPORT_OUTPUT_ENC_OTHER;
  strcpy (Options[ActualDSInstrument].ExportOutputEncOther, GetEntry (PreferencesMainWidget, "PreferencesReprocessOutputEncOtherEntry"));
  // Directories TAB
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesBugTraceFileEntry", BugTraceDir);
  CheckDirName (BugTraceDir);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesDataRootFileEntry", Options[ActualDSInstrument].DefaultDataRootDir);
  CheckDirName (Options[ActualDSInstrument].DefaultDataRootDir);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesMethodDirFileEntry", Options[ActualDSInstrument].MethodDir);
  CheckDirName (Options[ActualDSInstrument].MethodDir);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesCalibrDirFileEntry", Options[ActualDSInstrument].CalibrDir);
  CheckDirName (Options[ActualDSInstrument].CalibrDir);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesImportDirFileEntry", Options[ActualDSInstrument].ImportDir);
  CheckDirName (Options[ActualDSInstrument].ImportDir);
  GetGnomeFileEntry (PreferencesMainWidget, "PreferencesExportDirFileEntry", Options[ActualDSInstrument].ExportDir);
  CheckDirName (Options[ActualDSInstrument].ExportDir);
  // Print TAB
  Options[ActualDSInstrument].PrintFrame = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintFrameCheckButton");
  Options[ActualDSInstrument].PrintTickMarks = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintTickMarksCheckButton");
  Options[ActualDSInstrument].PrintBaselines = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintBaselineCheckButton");
  Options[ActualDSInstrument].PrintXAxisTicks = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintXAxisTicksCheckButton");
  Options[ActualDSInstrument].PrintXAxisValues = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintXAxisValuesCheckButton");
  Options[ActualDSInstrument].PrintPeakName = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakNameCheckButton");
  Options[ActualDSInstrument].PrintPeakNumber = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakNumberCheckButton");
  Options[ActualDSInstrument].PrintPeakRetention = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakRetentionCheckButton");
  Options[ActualDSInstrument].PrintPeakConcentration = GetCheckBox (PreferencesMainWidget, "PreferencesPrintPrintPeakConcentrationCheckButton");
  // General
  CentralWindowCloseTmp = CentralOptions.CentralWindowClose;
  CentralOptions.CentralWindowClose = GetCheckBox (PreferencesMainWidget, "PreferencesCloseWindowCheckButton");
  if (CentralWindowCloseTmp != CentralOptions.CentralWindowClose) ConfigSave (0);
  MainWindowShrink = GetCheckBox (PreferencesMainWidget, "PreferencesShrinkMainWindowCheckButton");
  MainWindowKeepOnTop = GetCheckBox (PreferencesMainWidget, "PreferencesShrinkedMainWindowTopCheckButton");
  if ((MainWindowShrink) && (!MainWindowShrinked))
	  ShrinkMainWindow();
  if ((!MainWindowShrink) && (MainWindowShrinked))
	  ExpandMainWindow();
} // GetPreferencesWidgets

extern void
ValidatePreferencesWidgets (GtkWidget *PreferencesMainWidget) {
int ADSI;

  ADSI = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (PreferencesMainWidget), "ActualDSInstrument"));

} // ValidatePreferencesWidgets

extern void
PresetServicesWidgets (GtkWidget *ServicesMainWidget,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton) {
GtkWidget		*ServicesMeasureNotebook;

  gtk_object_set_data (GTK_OBJECT (ServicesMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (ServicesMainWidget), "CallerButton", CallerButton);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);

  ServicesMeasureNotebook = lookup_widget (ServiceWindow, "ServiceNotebook");
  if (ServicesMeasureNotebook == NULL) {
	PRINTF ("*** (ServicesMeasureNotebook == NULL) failed\n",0);
	return;
  } // ServicesMeasureNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (ServicesMeasureNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (ServicesMeasureNotebook), FALSE);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "None");
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Chromatographic Workstation Measure");
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "Multi-instrument Data Station Measure");
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR541a Measure");
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR542 Measure");
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (ServicesMeasureNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
	//gtk_window_set_title (GTK_WINDOW (MeasureWindow), "TR930 Measure");
		break;
  } // switch
} // PresetServicesWidgets

extern void
RefreshPeakList (void) {
GtkWidget	*PeakList;
char			*RowData[9];
int			i;

  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(20);
  RowData[3] = alloca(20);
  RowData[4] = alloca(20);
  RowData[5] = alloca(20);
  RowData[6] = alloca(20);
  RowData[7] = alloca(20);
  RowData[8] = alloca(500);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");
  strcpy(RowData[4],"");
  strcpy(RowData[5],"");
  strcpy(RowData[6],"");
  strcpy(RowData[7],"");
  strcpy(RowData[8],"");

  PeakList = lookup_widget(PeakListWindow,"PeakListCList");
  gtk_clist_clear (GTK_CLIST (PeakList));

  for (i=0; i<Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]; i++)
  {
	GetPeak (i, WorkArea);
	sprintf (RowData[0],"%d",i+1);
	switch (Chrom[WorkArea].Peak->BlTypeBegin) {
	  case BP_BASE:
		  strcpy (RowData[1],"B");
		  break; // BP_BASE
	  case BP_VALLEY:
		  strcpy (RowData[1],"V");
		  break; // BP_VALLEY
	  default:sprintf (RowData[1],"XX");
	} // switch BLType
	switch (Chrom[WorkArea].Peak->BlTypeEnd) {
	  case BP_BASE:
		  strcat (RowData[1],"B");
		  break; // BP_BASE
	  case BP_VALLEY:
		  strcat (RowData[1],"V");
		  break; // BP_VALLEY
	  default:sprintf (RowData[1],"XX");
	} // switch BLType
	sprintf (RowData[2],"%.3f",Chrom[WorkArea].Peak->PeakRetention);
	sprintf (RowData[3],"%.0f",Chrom[WorkArea].Peak->PeakArea);
	sprintf (RowData[4],"%.3f",100*Chrom[WorkArea].Peak->PeakAreaR);
	sprintf (RowData[5],"%.1f",Chrom[WorkArea].Peak->PeakHeight);
	sprintf (RowData[6],"%.3f",100*Chrom[WorkArea].Peak->PeakHeightR);
	sprintf (RowData[7],"%.3f",Chrom[WorkArea].Peak->PeakConc);
	sprintf (RowData[8],"[%d] %s",Chrom[WorkArea].Peak->PeakId, Chrom[WorkArea].Peak->PeakName);
	gtk_clist_append (GTK_CLIST(PeakList),RowData);
  } // for i
} // RefreshPeakList

extern void
PresetPeakInfoWindow (void) {
GtkWidget *PINoteBook;

  PINoteBook = lookup_widget (PeakInfoWindow, "PeakInfoNotebook");
  gtk_notebook_set_current_page (GTK_NOTEBOOK (PINoteBook), 3);
  gtk_widget_show (PeakInfoWindow);
  RefreshPeakInfo ();
  gtk_widget_hide (PeakInfoWindow);
  gtk_notebook_set_current_page (GTK_NOTEBOOK (PINoteBook), 0);
} // PresetPeakInfoWindow

extern void
RefreshPeakInfo (void) {
GtkWidget	*PeakInfoList;
GtkWidget	*PeakInfoAppBar;
GtkWidget	*DrawWidget;
GdkGC		*gc;
char		*RowData[3];
char		*AppBarText;
int			ActDet;

  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListGeneral");
  gtk_clist_clear (GTK_CLIST (PeakInfoList));
  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListBaseline");
  gtk_clist_clear (GTK_CLIST (PeakInfoList));
  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListPerformance");
  gtk_clist_clear (GTK_CLIST (PeakInfoList));
  PeakInfoAppBar = lookup_widget(PeakInfoWindow,"PeakInfoAppBar");
  gnome_appbar_set_progress_percentage (GNOME_APPBAR (PeakInfoAppBar), 0.00);
  gnome_appbar_clear_stack (GNOME_APPBAR (PeakInfoAppBar));

  DrawWidget = lookup_widget (PeakInfoWindow,"PeakInfoDrawingArea");
  gdk_window_clear (DrawWidget->window);

  AppBarText = alloca (400);

  if ((Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector] < 1) || \
	  (SelectedPeak<0) || \
	  (SelectedPeak >= Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector])) {
	  sprintf (AppBarText, "No peak selected");
	  gnome_appbar_push (GNOME_APPBAR (PeakInfoAppBar), AppBarText);
	  return;
  }

  gnome_appbar_set_progress_percentage (GNOME_APPBAR (PeakInfoAppBar), (double)(SelectedPeak + 1) / (double)Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]);
  sprintf (AppBarText, "Peak %d of %d.", SelectedPeak + 1, Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]);
  gnome_appbar_push (GNOME_APPBAR (PeakInfoAppBar), AppBarText);


  GetPeak (SelectedPeak, WorkArea);

  RowData[0] = calloc(200,sizeof(char));
  RowData[1] = calloc(200,sizeof(char));
  RowData[2] = calloc(200,sizeof(char));

  // General parameters
  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListGeneral");

	sprintf (RowData[0],"Peak number");
	sprintf (RowData[1],"%d",SelectedPeak+1);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak name");
	sprintf (RowData[1],"%s",Chrom[WorkArea].Peak->PeakName);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak retention");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakRetention);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak begin");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakBegin);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak end");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakEnd);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak area");
	sprintf (RowData[1],"%.0f",Chrom[WorkArea].Peak->PeakArea);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak area%%");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakAreaR*100);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak height");
	sprintf (RowData[1],"%.0f",Chrom[WorkArea].Peak->PeakHeight);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak height%%");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakHeightR*100);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak A/H");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakAperH);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak concentration");
	sprintf (RowData[1],"%3f",Chrom[WorkArea].Peak->PeakConc);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak concentration%%");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakConcPercent);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Ist code");
	sprintf (RowData[1],"%d",Chrom[WorkArea].Peak->PeakIsIst);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Assigned to Ist");
	sprintf (RowData[1],"%d",Chrom[WorkArea].Peak->AssignedToIst);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Component code");
	sprintf (RowData[1],"%d",Chrom[WorkArea].Peak->PeakComponent);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

  // Baseline parameters
  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListBaseline");

	sprintf (RowData[0],"Baseline begin");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->BlTimeBegin);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Baseline end");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->BlTimeEnd);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Baseline value at begin");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->BlValueBegin);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Baseline value at end");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->BlValueEnd);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

  // Performance parameters
  PeakInfoList = lookup_widget(PeakInfoWindow,"PeakInfoCListPerformance");

	sprintf (RowData[0],"Peak Width at 10%% height");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakW10);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Width at half height");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakW50);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Width at baseline");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakWBL);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Efficiency by Width at 10%%");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakN10);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Efficiency by Width at 50%%");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakN50);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Efficiency by Width at baseline");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakNBL);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak Efficiency by Area/Height");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakNIH);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak partition factor");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakK);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak selectivity to previous peak");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakAlfa);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak selectivity to selected peak");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakAlfaS);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak resolution");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakR);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak theoretical plate");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakN);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak symmetry at 10%% height");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakSym10);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak symmetry at 50%% height");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakSym50);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak symmetry at baseline");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakSymBL);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak symmetry by area");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakSymA);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak 1st moment");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakM1);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak 2nd moment");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakM2);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak 3rd moment");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakM3);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

	sprintf (RowData[0],"Peak 4th moment");
	sprintf (RowData[1],"%.3f",Chrom[WorkArea].Peak->PeakM4);
	sprintf (RowData[2]," ");
	gtk_clist_append (GTK_CLIST(PeakInfoList),RowData);

  free(RowData[2]);
  free(RowData[1]);
  free(RowData[0]);

  // Graphic

  // Color init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);

  ActDet = Chrom[WorkArea].ActualDetector;


  // Color unref
  gdk_gc_unref (gc);
} // RefreshPeakInfo

extern void
SetImportWidgets (GtkWidget *ImportMainWidget) {
//  SetGnomeFileEntry (ImportMainWidget, "ImportDialogFileEntry", ImportLastDir);
  SetEntry (ImportMainWidget, "ImportDialogCommentEntry", ImportComment);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogChannelsSpinButton", ImportChannels);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogChannelsOfSpinButton", ImportChannelsOf);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogXAxisSpinButton", ImportXResolution);
  SetOptionMenuIndex (ImportMainWidget, "ImportDialogXAxisOptionMenu", ImportXAxisMenuIndex);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogDecimationSpinButton", ImportDecimation);
  SetCheckBox (ImportMainWidget, "ImportDialogRevertCheckBox", ImportRevert);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogScaleSpinButton", ImportScaleFactor);
  SetEntry (ImportMainWidget, "ImportDialogScaleEntry", ImportScaleDim);
  SetSpinButtonValue (ImportMainWidget, "ImportDialogResolutionSpinButton", ImportResolution);
  ImportResolutionUser = GetSpinButtonInt (ImportMainWidget, "ImportDialogResolutionSpinButton");
  SetOptionMenuIndex (ImportMainWidget, "ImportDialogResolutionOptionMenu", ImportResolutionMenuIndex);
  SetCheckBox (ImportMainWidget, "ImportDialogStoreDefaultsCheckBox", ImportStoreSettings);
} // SetImportWidgets

extern void
GetImportWidgets (GtkWidget *ImportMainWidget) {
  GetGnomeFileEntry (ImportMainWidget, "ImportDialogFileEntry", ImportLastDir);
  strcpy (ImportComment, GetEntry (ImportMainWidget, "ImportDialogCommentEntry"));
  ImportChannels = GetSpinButtonInt (ImportMainWidget, "ImportDialogChannelsSpinButton");
  ImportChannelsOf = GetSpinButtonInt (ImportMainWidget, "ImportDialogChannelsOfSpinButton");
  ImportXResolution = GetSpinButtonFloat (ImportMainWidget, "ImportDialogXAxisSpinButton");
  ImportXAxisMenuIndex = GetOptionMenuIndex (ImportMainWidget, "ImportDialogXAxisOptionMenu");
  ImportDecimation = GetSpinButtonInt (ImportMainWidget, "ImportDialogDecimationSpinButton");
  ImportRevert = GetCheckBox (ImportMainWidget, "ImportDialogRevertCheckBox");
  ImportScaleFactor = GetSpinButtonFloat (ImportMainWidget, "ImportDialogScaleSpinButton");
  strcpy (ImportScaleDim, GetEntry (ImportMainWidget, "ImportDialogScaleEntry"));
  ImportResolution = GetSpinButtonInt (ImportMainWidget, "ImportDialogResolutionSpinButton");
  ImportResolutionMenuIndex = GetOptionMenuIndex (ImportMainWidget, "ImportDialogResolutionOptionMenu");
  ImportStoreSettings = GetCheckBox (ImportMainWidget, "ImportDialogStoreDefaultsCheckBox");
} // GetImportWidgets

extern void
SetReprocessWidgets (void) {
} // SetReprocessWidgets

extern void
GetReprocessWidgets (void) {
} // GetReprocessWidgets

extern void
PresetReprocessWidgets (void) {
int j;

  gtk_toggle_tool_button_set_active (GTK_TOGGLE_TOOL_BUTTON(lookup_widget (ReprocessWindow, "ReprocessIndexToggleButton")), ReprocessShowLists);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessIndex")), ReprocessShowLists);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessSampleQueue")), ReprocessShowQueue);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessOverlay")), ReprocessShowOverlay);

  ReprocessShowInitStatus = TRUE;
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessTickMarks")), ReprocessShowTickMarks);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessBaselines")), ReprocessShowBaselines);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessFillPeaks")), ReprocessShowFillPeaks);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessPeakNumbers")), ReprocessShowPeakNumbers);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessRetention")), ReprocessShowRetention);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessName")), ReprocessShowName);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessComment")), ReprocessShowComment);
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessTime")), ReprocessShowTime);
  ReprocessShowInitStatus = FALSE;

  gtk_object_set_data (GTK_OBJECT (ReprocessWindow), "MeasureActiv", GINT_TO_POINTER(FALSE));
  HideWidget (ReprocessWindow, "ReprocessIntoCalibrButton");
  HideWidget (ReprocessWindow, "ReprocessFileToolbarVSeparator3");

  if (ReprocessShowQueue == FALSE) {
	  HideWidget (ReprocessWindow, "ReprocessQueueVBox");
	  HideWidget (ReprocessWindow, "ReprocessHSeparator");
  } else {
	  ShowWidget (ReprocessWindow, "ReprocessQueueVBox");
  } // ReprocessShowQueue

  if (ReprocessShowOverlay == FALSE) {
	  HideWidget (ReprocessWindow, "ReprocessOverlayVBox");
	  HideWidget (ReprocessWindow, "ReprocessHSeparator");
  } else {
	  ShowWidget (ReprocessWindow, "ReprocessOverlayVBox");
  } // ReprocessShowQueue

  if ((ReprocessShowOverlay == TRUE) && (ReprocessShowQueue == TRUE))
	  ShowWidget (ReprocessWindow, "ReprocessHSeparator");

  if (ReprocessShowLists == FALSE)
	  HideWidget (ReprocessWindow, "ReprocessVBox");
  else
	  ShowWidget (ReprocessWindow, "ReprocessVBox");

  ReprocessShowListsReady = TRUE;

  for (j = 0; j < MaxDetectors; j++) {
	  ReprocessDetectorColors[j].red = Options[WorkArea].red[j];
	  ReprocessDetectorColors[j].green = Options[WorkArea].green[j];
	  ReprocessDetectorColors[j].blue = Options[WorkArea].blue[j];
	  gdk_colormap_alloc_color (DrawColormap, &ReprocessDetectorColors[j], TRUE, TRUE);
  } // j
  ActivateReprocessWidgets ();
  ADSI_UP(ReprocessWindow, 0);
  DATASOURCE_UP(ReprocessWindow, WorkArea);
  DATA_UP(ReprocessWindow, "SelectedItem", -1);
} // PresetReprocessWidgets

extern void
ActivateReprocessWidgets (void) {
  // Overlay
  ActivateWidget (ReprocessWindow, "ReprocessOverlayAddButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayRemoveButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlaySelectButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayColorButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayZoomToFitToggleButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayHideToggleButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayFunctionsToggleButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayEnableToggleButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayCList", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlay1DRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlay2DRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlay3DRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayPlusRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayMinusRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayMultiplyRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayDivideRadioButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayRevertOperandToggleButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftSpinButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifySpinButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftDownImage", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftUpImage", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifyUpImage", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifyDownImage", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayEstimateShiftButton", FALSE);
  ActivateWidget (ReprocessWindow, "ReprocessOverlayEstimateMagnifyButton", FALSE);
//  ActivateWidget (ReprocessWindow, "", FALSE);
//  ActivateWidget (ReprocessWindow, "", FALSE);
  if (Chrom[WorkArea].FileLoaded[ChrFlag]) {
	  if (ReprocessOverlayChromNum < MaxOverlayedChrom)
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayAddButton", TRUE);
	  if (ReprocessOverlayChromNum > 0) {
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayEnableToggleButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayCList", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlay1DRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlay2DRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlay3DRadioButton", TRUE);
	  }
	  if (ReprocessOverlayCListSelected > -1) {
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayRemoveButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlaySelectButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayColorButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayZoomToFitToggleButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayHideToggleButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftSpinButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifySpinButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftDownImage", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayShiftUpImage", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifyUpImage", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayMagnifyDownImage", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayEstimateShiftButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayEstimateMagnifyButton", TRUE);
	  }
	  if (ReprocessOverlaySelected > -1) {
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayFunctionsToggleButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayPlusRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayMinusRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayMultiplyRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayDivideRadioButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOverlayRevertOperandToggleButton", TRUE);
	  }
  }
} // ActivateReprocessWidgets

extern void
ConfigureReprocessWidget (void) {
} // ConfigureReprocessWidget

extern void
RefreshOverlayList (void) {
GtkWidget *OverlayCList;
int i;
char *RowData[5];
char *TmpStr;
struct tm *ConvLocalTime;

  ConvLocalTime = alloca (sizeof(struct tm));

  RowData[0] = alloca(20);
  RowData[1] = alloca(40);
  RowData[2] = alloca(FilenameLength);
  RowData[3] = alloca(100);
  RowData[4] = alloca(CommentLength);

  strcpy (RowData[0], "");
  strcpy (RowData[1], "");
  strcpy (RowData[2], "");
  strcpy (RowData[3], "");
  strcpy (RowData[4], "");

  OverlayCList = lookup_widget (ReprocessWindow, "ReprocessOverlayCList");
  gtk_clist_clear (GTK_CLIST(OverlayCList));
  for (i = 0; i < ReprocessOverlayChromNum; i++) {
	  sprintf (RowData[0], "%d", i + 1);
	  
	  TmpStr = g_path_get_basename (Chrom[OverlayedChromBase + i].ChrName);
	  sprintf (RowData[2], "%s", TmpStr);
	  g_free (TmpStr);
	  localtime_r (&Chrom[OverlayedChromBase + i].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);
	  sprintf (RowData[3], "%d.%.2d.%.2d %.2d:%.2d:%.2d",  \
			  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
			  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec); // Timestamp of start
	  sprintf (RowData[4], "%s", Chrom[OverlayedChromBase + i].ChromHead->Method.MeasureParameters.SampleComment);
	  gtk_clist_append (GTK_CLIST(OverlayCList), RowData);
  }
} // RefreshOverlayList

extern void
PresetIntParWidgets (GtkWidget *IntParMainWidget,
							struct IntegrationParametersStruct *IntPar,
							GtkWidget *CallerWidget,
							GtkWidget *CallerButton,
							ApplyFunctionType ApplyFunction) {
int i;
struct IntegrationParametersStruct *IntParLocal;

  IntParLocal = calloc (1, sizeof(struct IntegrationParametersStruct));
  memcpy (IntParLocal, IntPar, sizeof(struct IntegrationParametersStruct));
  gtk_object_set_data (GTK_OBJECT (IntParMainWidget), "IntPar", IntPar);
  gtk_object_set_data (GTK_OBJECT (IntParMainWidget), "IntParLocal", IntParLocal);
  gtk_object_set_data (GTK_OBJECT (IntParMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (IntParMainWidget), "CallerButton", CallerButton);
  gtk_object_set_data (GTK_OBJECT (IntParMainWidget), "ApplyFunction", ApplyFunction);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);

  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (IntParMainWidget, "IntParSelectEventComboBox")), 0);
  for (i = 0; i < EventNumbers; i++)
	  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (IntParMainWidget, "IntParSelectEventComboBox")), EventNames[i]);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (IntParMainWidget, "IntParSelectEventComboBox")), 0);
} // PresetIntParWidgets

extern void
SetIntParWidgets (GtkWidget *IntParMainWidget) {
struct IntegrationParametersStruct *IntPar;
char *TmpStr;
int i;
char			*RowData[5];

  RowData[0] = alloca(20);
  RowData[1] = alloca(20);
  RowData[2] = alloca(200);
  RowData[3] = alloca(20);
  RowData[4] = alloca(20);

  TmpStr = alloca (100);
  IntPar = gtk_object_get_data (GTK_OBJECT(IntParMainWidget), "IntParLocal");

// Detection parameters
  SetSpinButtonValue (IntParMainWidget, "IntParUpSlopeSpinButton", IntPar->PozSlope);
  SetSpinButtonValue (IntParMainWidget, "IntParDownSlopeSpinButton", IntPar->NegSlope);

  SetSpinButtonValue (IntParMainWidget, "IntParAreaThresholdSpinButton", IntPar->MinArea);
  SetSpinButtonValue (IntParMainWidget, "IntParHeightThresholdSpinButton", IntPar->MinLevel);
  SetSpinButtonValue (IntParMainWidget, "IntParWidthThresholdSpinButton", IntPar->MinWidth);

  SetSpinButtonValue (IntParMainWidget, "IntParSolventSlopeSpinButton", IntPar->SolventSlope);
  SetSpinButtonValue (IntParMainWidget, "IntParSolventAreaSpinButton", IntPar->SolventArea);
  SetSpinButtonValue (IntParMainWidget, "IntParSolventHeightSpinButton", IntPar->SolventHeight);
  SetSpinButtonValue (IntParMainWidget, "IntParSolventWidthSpinButton", IntPar->SolventWidth);
  SetSpinButtonValue (IntParMainWidget, "IntParFollowerUpsideSpinButton", IntPar->FollowUp);
  SetSpinButtonValue (IntParMainWidget, "IntParFollowerApexSpinButton", IntPar->FollowAx);
  SetSpinButtonValue (IntParMainWidget, "IntParFollowerDownsideSpinButton", IntPar->FollowDn);

// Advanced parameters
  SetSpinButtonValue (IntParMainWidget, "IntPar2ndUpslopeSpinButton", IntPar->Poz2Slope);
  SetSpinButtonValue (IntParMainWidget, "IntPar2ndUplevelSpinButton", IntPar->Poz2Level);
  SetSpinButtonValue (IntParMainWidget, "IntPar2ndDownslopeSpinButton", IntPar->Neg2Slope);
  SetSpinButtonValue (IntParMainWidget, "IntPar2ndDownlevelSpinButton", IntPar->Neg2Level);
  SetSpinButtonValue (IntParMainWidget, "IntParSmoothSizeSpinButton", IntPar->DetSmooth);
  SetSpinButtonValue (IntParMainWidget, "IntParBaselineDriftSpinButton", IntPar->BaseLineDrift);
  SetSpinButtonValue (IntParMainWidget, "IntParNoiseLevelSpinButton", IntPar->NoiseLevel);

// Lock parameters
  sprintf (TmpStr, "%d", IntPar->LockNum);
  SetEntry (IntParMainWidget, "IntParLockNumEntry", TmpStr);
  SetSpinButtonValue (IntParMainWidget, "IntParStartLockSpinButton", IntPar->LockWait);
  SetCheckBox (IntParMainWidget, "IntParTruncPeakCheckBox", IntPar->LockDropPeaks);
  gtk_clist_clear (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParLockCList")));
  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");
  strcpy(RowData[4],"");
  for (i = 0; i < IntPar->LockNum; i++) {
	  sprintf (RowData[0],"%d", i);
	  sprintf (RowData[1],"%.3f", IntPar->LockWindOn[i]);
	  sprintf (RowData[2],"%.3f", IntPar->LockWindOff[i]);
	  gtk_clist_append (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParLockCList")), RowData);
  } // i ->LockNum
  if (IntPar->LockNum == 0) {
	  ActivateWidget (IntParMainWidget, "IntParLockRemoveButton", FALSE);
	  ActivateWidget (IntParMainWidget, "IntParLockModifyButton", FALSE);
  } // LockNum == 0
  if (IntPar->LockNum == MaxIntegrationLock) {
	  ActivateWidget (IntParMainWidget, "IntParLockAddButton", FALSE);
  } // LockNum == 0

// Merge parameters
  SetCheckBox (IntParMainWidget, "IntParMergeHeightCheckButton", IntPar->HeightFApply);
  SetSpinButtonValue (IntParMainWidget, "IntParMergeHeightSpinButton", IntPar->HeightF);
  SetCheckBox (IntParMainWidget, "IntParMergeTimeCheckButton", IntPar->TimeFApply);
  SetSpinButtonValue (IntParMainWidget, "IntParMergeTimeSpinButton", IntPar->TimeF);
  SetCheckBox (IntParMainWidget, "IntParMergeSeparationCheckButton", IntPar->CloseFApply);
  SetSpinButtonValue (IntParMainWidget, "IntParMergeSeparationSpinButton", IntPar->CloseF);
  SetCheckBox (IntParMainWidget, "IntParMergeTangentCheckButton", IntPar->TangentFApply);
  SetSpinButtonValue (IntParMainWidget, "IntParMergeTangentSpinButton", IntPar->TangentF);

// Timed events
  sprintf (TmpStr, "", IntPar->EventNum);
  SetEntry (IntParMainWidget, "IntParEventNumEntry", TmpStr);
  gtk_clist_clear (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParEventCList")));
  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");
  strcpy(RowData[3],"");
  strcpy(RowData[4],"");
  for (i = 0; i < IntPar->EventNum; i++) {
	  sprintf (RowData[0],"%d", i);
	  sprintf (RowData[1],"%s", "FIX ME - Event name!");
	  sprintf (RowData[2],"%.3f", IntPar->EventTime[i]);
	  sprintf (RowData[3],"%d", IntPar->EventFactor[i]);
	  sprintf (RowData[4],"%.3f", IntPar->EventParameter[i]);
	  gtk_clist_append (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParEventCList")), RowData);
  } // i ->EventNum

  RefreshIntParLockCList (IntParMainWidget);
  RefreshIntParEventCList (IntParMainWidget);
  ActivateIntParWidgets (IntParMainWidget);
} // SetIntParWidgets

extern void
GetIntParWidgets (GtkWidget *IntParMainWidget) {
struct IntegrationParametersStruct *IntPar;
int i;
char *ValueCList;
char *ValueTemp;
float ValTmp;
int ResultCList;
int RetVal;

  IntPar = gtk_object_get_data (GTK_OBJECT(IntParMainWidget), "IntParLocal");
  RetVal = 0;

// Detection parameters
  IntPar->PozSlope = GetSpinButtonFloat (IntParMainWidget, "IntParUpSlopeSpinButton");
  IntPar->NegSlope = GetSpinButtonFloat (IntParMainWidget, "IntParDownSlopeSpinButton");

  IntPar->MinArea = GetSpinButtonFloat (IntParMainWidget, "IntParAreaThresholdSpinButton");
  IntPar->MinLevel = GetSpinButtonFloat (IntParMainWidget, "IntParHeightThresholdSpinButton");
  IntPar->MinWidth = GetSpinButtonFloat (IntParMainWidget, "IntParWidthThresholdSpinButton");

  IntPar->SolventSlope = GetSpinButtonFloat (IntParMainWidget, "IntParSolventSlopeSpinButton");
  IntPar->SolventArea = GetSpinButtonFloat (IntParMainWidget, "IntParSolventAreaSpinButton");
  IntPar->SolventHeight = GetSpinButtonFloat (IntParMainWidget, "IntParSolventHeightSpinButton");
  IntPar->SolventWidth = GetSpinButtonFloat (IntParMainWidget, "IntParSolventWidthSpinButton");
  IntPar->FollowUp = GetSpinButtonFloat (IntParMainWidget, "IntParFollowerUpsideSpinButton");
  IntPar->FollowAx = GetSpinButtonFloat (IntParMainWidget, "IntParFollowerApexSpinButton");
  IntPar->FollowDn = GetSpinButtonFloat (IntParMainWidget, "IntParFollowerDownsideSpinButton");

// Advanced parameters
  IntPar->Poz2Slope = GetSpinButtonFloat (IntParMainWidget, "IntPar2ndUpslopeSpinButton");
  IntPar->Poz2Level = GetSpinButtonFloat (IntParMainWidget, "IntPar2ndUplevelSpinButton");
  IntPar->Neg2Slope = GetSpinButtonFloat (IntParMainWidget, "IntPar2ndDownslopeSpinButton");
  IntPar->Neg2Level = GetSpinButtonFloat (IntParMainWidget, "IntPar2ndDownlevelSpinButton");
  IntPar->DetSmooth = GetSpinButtonInt (IntParMainWidget, "IntParSmoothSizeSpinButton");
  IntPar->BaseLineDrift = GetSpinButtonFloat (IntParMainWidget, "IntParBaselineDriftSpinButton");
  IntPar->NoiseLevel = GetSpinButtonFloat (IntParMainWidget, "IntParNoiseLevelSpinButton");

// Lock parameters
  IntPar->LockNum = atoi (GetEntry (IntParMainWidget, "IntParLockNumEntry"));
  IntPar->LockWait = GetSpinButtonFloat (IntParMainWidget, "IntParStartLockSpinButton");
  IntPar->LockDropPeaks = GetCheckBox (IntParMainWidget, "IntParTruncPeakCheckBox");
  ValueTemp = alloca (100);
  for (i = 0; i < IntPar->LockNum; i++) {
	  ResultCList = gtk_clist_get_text (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParLockCList")), i, 1, &ValueCList);
	  strcpy (ValueTemp, ValueCList);
	  sscanf (ValueTemp, "%f", &ValTmp);
	  IntPar->LockWindOn[i] = ValTmp;
	  ResultCList = gtk_clist_get_text (GTK_CLIST(lookup_widget (IntParMainWidget, "IntParLockCList")), i, 2, &ValueCList);
	  strcpy (ValueTemp, ValueCList);
	  sscanf (ValueTemp, "%f", &ValTmp);
	  IntPar->LockWindOff[i] = ValTmp;
  } // i

// Merge parameters
  IntPar->HeightFApply = GetCheckBox (IntParMainWidget, "IntParMergeHeightCheckButton");
  IntPar->HeightF = GetSpinButtonFloat (IntParMainWidget, "IntParMergeHeightSpinButton");
  IntPar->TimeFApply = GetCheckBox (IntParMainWidget, "IntParMergeTimeCheckButton");
  IntPar->TimeF = GetSpinButtonFloat (IntParMainWidget, "IntParMergeTimeSpinButton");
  IntPar->CloseFApply = GetCheckBox (IntParMainWidget, "IntParMergeSeparationCheckButton");
  IntPar->CloseF = GetSpinButtonFloat (IntParMainWidget, "IntParMergeSeparationSpinButton");
  IntPar->TangentFApply = GetCheckBox (IntParMainWidget, "IntParMergeTangentCheckButton");
  IntPar->TangentF = GetSpinButtonFloat (IntParMainWidget, "IntParMergeTangentSpinButton");

// Timed events
  IntPar->EventNum = atoi (GetEntry (IntParMainWidget, "IntParEventNumEntry"));

} // GetIntParWidgets

extern void
ActivateIntParWidgets (GtkWidget *IntParMainWidget) {
struct IntegrationParametersStruct *IntPar;
int LockWindowSelectedTrack;
int EventSelectedTrack;

  IntPar = gtk_object_get_data (GTK_OBJECT(IntParMainWidget), "IntParLocal");
  LockWindowSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntParMainWidget), "LockWindowSelectedTrack"));
  EventSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntParMainWidget), "EventSelectedTrack"));

  ActivateWidget (IntParMainWidget, "IntParLockAddButton", FALSE);
  ActivateWidget (IntParMainWidget, "IntParLockRemoveButton", FALSE);
  ActivateWidget (IntParMainWidget, "IntParLockModifyButton", FALSE);

  if (IntPar->LockNum < MaxIntegrationLock)
	  ActivateWidget (IntParMainWidget, "IntParLockAddButton", TRUE);
  if (LockWindowSelectedTrack > -1)
	  ActivateWidget (IntParMainWidget, "IntParLockRemoveButton", TRUE);
  if (LockWindowSelectedTrack > -1)
	  ActivateWidget (IntParMainWidget, "IntParLockModifyButton", TRUE);


} // ActivateIntParWidgets

extern void
RefreshIntParLockCList (GtkWidget *IntParMainWidget) {
struct IntegrationParametersStruct *IntPar;
int i;
GtkWidget *LockCList;
char *RowData[4];
char *TmpStr;

  RowData[0] = alloca(20);
  RowData[1] = alloca(40);
  RowData[2] = alloca(40);
  RowData[3] = alloca(20);

  strcpy (RowData[0], "");
  strcpy (RowData[1], "");
  strcpy (RowData[2], "");
  strcpy (RowData[3], "");

  TmpStr = alloca (100);

  IntPar = gtk_object_get_data (GTK_OBJECT(IntParMainWidget), "IntParLocal");
  LockCList = lookup_widget (IntParMainWidget, "IntParLockCList");
  gtk_clist_clear (GTK_CLIST(LockCList));
  for (i = 0; i < IntPar->LockNum; i++) {
	  sprintf (RowData[0], "%d", i + 1);
	  sprintf (RowData[1], "%.3f", IntPar->LockWindOn[i]);
	  sprintf (RowData[2], "%.3f", IntPar->LockWindOff[i]);
	  gtk_clist_append (GTK_CLIST(LockCList), RowData);
  } // i

} // RefreshIntParLockCList

extern void
RefreshIntParEventCList (GtkWidget *IntParMainWidget) {
struct IntegrationParametersStruct *IntPar;
int i;
GtkWidget *EventCList;
char *RowData[7];
char *TmpStr;

  RowData[0] = alloca(20);
  RowData[1] = alloca(40);
  RowData[2] = alloca(200);
  RowData[3] = alloca(40);
  RowData[4] = alloca(40);
  RowData[5] = alloca(40);
  RowData[6] = alloca(20);

  strcpy (RowData[0], "");
  strcpy (RowData[1], "");
  strcpy (RowData[2], "");
  strcpy (RowData[3], "");
  strcpy (RowData[4], "");
  strcpy (RowData[5], "");
  strcpy (RowData[6], "");

  TmpStr = alloca (100);

  IntPar = gtk_object_get_data (GTK_OBJECT(IntParMainWidget), "IntParLocal");
  EventCList = lookup_widget (IntParMainWidget, "IntParEventCList");
  gtk_clist_clear (GTK_CLIST(EventCList));
  for (i = 0; i < IntPar->EventNum; i++) {
	  sprintf (RowData[0], "%d", i + 1);
	  sprintf (RowData[1],"%.3f", IntPar->EventTime[i]);
	  sprintf (RowData[2],"%s", EventNames[EventOrderInMenu (IntPar->EventType[i])]);
	  sprintf (RowData[3],"%d", IntPar->EventFactor[i]);
	  sprintf (RowData[4],"%.3f", IntPar->EventParameter[i]);
	  sprintf (RowData[5],"%.3f", IntPar->EventActiveTime[i]);
	  gtk_clist_append (GTK_CLIST(EventCList), RowData);
  } // i

} // RefreshIntParEventCList

extern void
PresetReportEditWidgets (GtkWidget *ReportEditMainWidget,
									struct ReportStruct *Report,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton,
									ApplyFunctionType ApplyFunction) {

  gtk_object_set_data (GTK_OBJECT (ReportEditMainWidget), "Report", Report);
  gtk_object_set_data (GTK_OBJECT (ReportEditMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (ReportEditMainWidget), "CallerButton", CallerButton);
  gtk_object_set_data (GTK_OBJECT (ReportEditMainWidget), "ApplyFunction", ApplyFunction);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);
} // PresetReportEditWidgets

extern void
SetReportEditWidgets (GtkWidget *ReportEditMainWidget) {
struct ReportStruct *Report;

  Report = gtk_object_get_data (GTK_OBJECT (ReportEditMainWidget), "Report");
} // SetReportEditWidgets

extern void
GetReportEditWidgets (GtkWidget *ReportEditMainWidget) {
struct ReportStruct *Report;

  Report = gtk_object_get_data (GTK_OBJECT (ReportEditMainWidget), "Report");
} // GetReportEditWidgets

extern void
PresetSpectraWidgets (GtkWidget *SpectraMainWidget,
								GtkWidget *CallerWidget,
								GtkWidget *CallerButton) {
GtkWidget		*WorkNotebook;

  gtk_object_set_data (GTK_OBJECT (SpectraMainWidget), "OpenFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (SpectraMainWidget), "SaveFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT (SpectraMainWidget), "OpenSaveFileSelection", NULL);

  gtk_object_set_data (GTK_OBJECT (SpectraMainWidget), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (SpectraMainWidget), "CallerButton", CallerButton);
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);

  WorkNotebook = lookup_widget (SpectraMainWidget, "SpectraNotebook");
  if (WorkNotebook == NULL) {
	PRINTF ("*** (WorkNotebook == NULL) failed\n",0);
	return;
  } // WorkNotebook == NULL
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (WorkNotebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (WorkNotebook), FALSE);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
	case InstrumentWorkstation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
	case InstrumentDataStation :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
	case InstrumentTR541 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
	case InstrumentTR542 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
	case InstrumentTR930 :
	gtk_notebook_set_current_page (GTK_NOTEBOOK (WorkNotebook), LC2.Instruments[ActualInstrument].InstrumentType);
		break;
  } // switch

} // PresetSpectraWidgets

extern void
ActivateSpectraWidgets (void) {
} // ActivateSpectraWidgets

extern void
SetSpectraWidgets (void) {
} // SetSpectraWidgets

extern void
GetSpectraWidgets (void) {
} // GetSpectraWidgets

extern void
PresetZoomWidgets (GtkWidget *ZoomWindow,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton,
											ApplyFunctionType ApplyFunction) {
  gtk_object_set_data (GTK_OBJECT (ZoomWindow), "CallerWidget", CallerWidget);
  gtk_object_set_data (GTK_OBJECT (ZoomWindow), "CallerButton", CallerButton);
  ZoomIn ();
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, FALSE);
} // PresetZoomWidgets

extern void
SetZoomWidgets (GtkWidget *ZoomWindow) {
char *TmpStr;

  TmpStr = calloc (1, 100);

  SetSpinButtonValue (ZoomWindow, "ZoomYMaxSpinButton", Zoom->ZoomMax);
  sprintf (TmpStr, "%9.3f", Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue);
  SetEntry (ZoomWindow, "ZoomYMax0Entry", TmpStr);
  SetSpinButtonValue (ZoomWindow, "ZoomYMinSpinButton", Zoom->ZoomMin);
  sprintf (TmpStr, "%9.3f", -Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue);
  SetEntry (ZoomWindow, "ZoomYMin0Entry", TmpStr);

  SetSpinButtonValue (ZoomWindow, "ZoomXMaxSpinButton", CPTR (Zoom->ZoomEnd, WorkArea));
  sprintf (TmpStr, "%9.3f", 0.0);
  SetEntry (ZoomWindow, "ZoomXMin0Entry", TmpStr);
  SetSpinButtonValue (ZoomWindow, "ZoomXMinSpinButton", CPTR (Zoom->ZoomBeg, WorkArea));
  sprintf (TmpStr, "%9.3f", CPTR (Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1, WorkArea));
  SetEntry (ZoomWindow, "ZoomXMax0Entry", TmpStr);

  SetSpinButtonValue (ZoomWindow, "ZoomReportYMaxSpinButton", Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepMax);
  SetSpinButtonValue (ZoomWindow, "ZoomReportYMinSpinButton", Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepMin);
  SetSpinButtonValue (ZoomWindow, "ZoomReportXMaxSpinButton", CPTR (Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepEnd, WorkArea));
  SetSpinButtonValue (ZoomWindow, "ZoomReportXMinSpinButton", CPTR (Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepBeg, WorkArea));

  free (TmpStr);
} // SetZoomWidgets

extern void
GetZoomWidgets (GtkWidget *ZoomWindow) {
int TmpInt;
double TmpDouble;

  TmpDouble = GetSpinButtonFloat (ZoomWindow, "ZoomYMaxSpinButton");
  if (TmpDouble > Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue)
	  TmpDouble = Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue;
  Zoom->ZoomMax = TmpDouble;

  TmpDouble = GetSpinButtonFloat (ZoomWindow, "ZoomYMinSpinButton");
  if (TmpDouble < -Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue)
	  TmpDouble = -Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleValue;
  Zoom->ZoomMin = TmpDouble;

  TmpInt = GetSpinButtonInt (ZoomWindow, "ZoomXMinSpinButton");
  if (TmpInt < 0)
	  TmpInt = 0;
  Zoom->ZoomBeg = CRTP (TmpInt, WorkArea);

  TmpInt = GetSpinButtonInt (ZoomWindow, "ZoomXMaxSpinButton");
  if (TmpInt > Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1)
	  TmpInt = Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1;
  Zoom->ZoomEnd = CRTP (TmpInt, WorkArea);

  
  
} // GetZoomWidgets
