// Sample queue handler functions

extern void
GetQueueItem (int DataSource, int QueIdx) {
BT_INIT();
struct QueueItemStruct *QI;

  if (QueIdx < Chrom[DataSource].QueueHead.QueueItemNum) {
	  QI = Chrom[DataSource].QueueItemArray;
	  memcpy (&Chrom[DataSource].QueueItem, &QI[QueIdx], sizeof(struct QueueItemStruct));
  } else {
	  sprintf (BugTraceUserString, "### Queue GET error - GetQueueItem, QueIdx: %d, QueueHeadActual->QueueItemNum: %d, DataSource = %d",QueIdx,Chrom[DataSource].QueueHead.QueueItemNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // GetQueueItem

extern void
SetQueueItem (int DataSource, int QueIdx) {
BT_INIT();
struct QueueItemStruct *QI;

  if (QueIdx < Chrom[DataSource].QueueHead.QueueItemNum) {
	  QI = Chrom[DataSource].QueueItemArray;
	  memcpy (&QI[QueIdx], &Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));
  } else {
	  sprintf (BugTraceUserString, "### Queue SET error - GetQueueItem, QueIdx: %d, QueueHeadActual->QueueItemNum: %d, DataSource = %d",QueIdx,Chrom[DataSource].QueueHead.QueueItemNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // SetQueueItem

extern void
AddQueueItem (int DataSource, int QueIdx) {
int i;
int SetQueueIdx;
struct QueueItemStruct *QI;

  SetQueueIdx = QueIdx;
  Chrom[DataSource].QueueHead.QueueItemNum++;
  ReallocQueueData (Chrom[DataSource].QueueHead.QueueItemNum, DataSource);
  QI = Chrom[DataSource].QueueItemArray;
  if (QueIdx < 0)
	  SetQueueIdx = Chrom[DataSource].QueueHead.QueueItemNum - 1;
  else
	  for (i = Chrom[DataSource].QueueHead.QueueItemNum - 1; i > SetQueueIdx; i--)
		  memcpy (&QI[i], &QI[i-1], sizeof(struct QueueItemStruct));
  SetQueueItem (DataSource, SetQueueIdx);
} // AddQueueItem

extern void
DelQueueItem (int DataSource, int QueIdx) {
int i;
struct QueueItemStruct *QI;

  if (Chrom[DataSource].QueueHead.QueueItemNum == 0) return;
  if (Chrom[DataSource].QueueHead.QueueItemNum == 1) {
	  Chrom[DataSource].QueueHead.QueueItemNum--;
	  return;
  } // Chrom[DataSource].QueueHead.QueueItemNum

  QI = Chrom[DataSource].QueueItemArray;
  for (i = QueIdx + 1; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
	  memcpy (&QI[i - 1], &QI[i], sizeof(struct QueueItemStruct));
  } // i
  Chrom[DataSource].QueueHead.QueueItemNum--;
} // DelQueueItem

extern void
UpQueueItem (int DataSource, int QueIdx) {
} // UpQueueItem

extern void
DownQueueItem (int DataSource, int QueIdx) {
} // DownQueueItem

extern void
DefaultQueueItem (int DataSource) {
  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));
  Chrom[DataSource].QueueItem.Volume = 1;
  Chrom[DataSource].QueueItem.Amount = 1;
  Chrom[DataSource].QueueItem.Factor = 1;
  Chrom[DataSource].QueueItem.Pressure = 1;
  Chrom[DataSource].QueueItem.Temperature = 1;
  Chrom[DataSource].QueueItem.ScaleFactor = 1;
  Chrom[DataSource].QueueItem.InjectedVolume = 1;
  Chrom[DataSource].QueueItem.IstConc = 1;
} // DefaultQueueItem
