// Format number functions

extern void
FormatFloat (double FloatToFormat, int ValueLength, int ValueDigits, char *FormatString) {
	sprintf (FormatString, "%%.%df", ValueDigits, ValueDigits);
	printf ("FORMAT: %s\n", FormatString);
} // FormatFloat

// Common printing functions

extern void
PrintFontInit (GnomeFont *PrintFont, guchar *PrintFontName, gint PrintFontSize) {
BT_INIT();

  sprintf (BugTraceUserString, "PrintFont = gnome_font_find_closest (%s, %d); FAILED", PrintFontName, PrintFontSize);
  PrintFont = gnome_font_find_closest (PrintFontName, PrintFontSize);
  if (!PrintFont) {
	  BUGTRACE (BugTraceUserString); }
} // PrintFontInit

void
PrintFontReInit (GnomeFont *PrintFont, guchar *PrintFontName, gint PrintFontSize) {
BT_INIT();

  if (PrintFont)
	  g_object_unref (G_OBJECT (PrintFont));

  sprintf (BugTraceUserString, "ReInit PrintFont = gnome_font_find_closest (%s, %d); FAILED", PrintFontName, PrintFontSize);
  PrintFont = gnome_font_find_closest (PrintFontName, PrintFontSize);
  if (!PrintFont) {
	  BUGTRACE (BugTraceUserString); }
} // PrintFontReInit

void
PrintFontDone (GnomeFont *PrintFont) {
  if (PrintFont)
	  g_object_unref (G_OBJECT (PrintFont));
} // PrintFontDone

void
SetPrintJustify (struct PrintStruct *PS, int PrintJust, int PrintTabN) {
	PS->PrintJustification = PrintJust;
	PS->PrintJustificationPosition = PrintTabN;
} // SetPrintJustify

void
SetPrintFont (struct PrintStruct *PS, GnomeFont *ActFont) {
	PS->ActualPrintFont = ActFont;
} // SetPrintFont

void
DrawPrintFrame (struct PrintStruct *PS, double LineWidth, double LeftPos, double RightPos, double TopPos, double BottomPos) {
double		RealLeftPos;
double		RealBottomPos;

  gnome_print_grestore (PS->PrintContext);
  gnome_print_setlinewidth (PS->PrintContext, LineWidth);
  gnome_print_newpath (PS->PrintContext);
  gnome_print_moveto(PS->PrintContext, LeftPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, BottomPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  gnome_print_lineto(PS->PrintContext, RightPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, BottomPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  gnome_print_lineto(PS->PrintContext, RightPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, TopPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  gnome_print_lineto(PS->PrintContext, LeftPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, TopPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  gnome_print_lineto(PS->PrintContext, LeftPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, BottomPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  gnome_print_closepath (PS->PrintContext);
  if (LineWidth > 0)
	  gnome_print_stroke (PS->PrintContext);
  gnome_print_gsave (PS->PrintContext);

  RealLeftPos = RightPos > LeftPos ? LeftPos : RightPos;
  RealBottomPos = TopPos > BottomPos ? BottomPos : TopPos;
  gnome_print_translate (PS->PrintContext, RealLeftPos*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight) + PS->LCMarginLeft, RealBottomPos*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom) + PS->LCMarginBottom);
  PS->PrintLocalWidth = (RightPos - LeftPos)*(PS->PaperWidth - PS->LCMarginLeft - PS->LCMarginRight);
  if (PS->PrintLocalWidth < 0) PS->PrintLocalWidth *= -1;
  PS->PrintLocalHeight = (TopPos - BottomPos)*(PS->PaperHeight - PS->LCMarginTop - PS->LCMarginBottom);
  if (PS->PrintLocalHeight < 0) PS->PrintLocalHeight *= -1;
} // DrawPrintFrame

void
PrintText (struct PrintStruct *PS, double PrintX, double PrintY, const char *TextToPrint) {
gchar			*TextUTF8;
double			TextXDiff;
int				FontSetResult;
gsize			bytes_read;
gsize			bytes_written;

  TextXDiff = 0;

  if (!strlen (TextToPrint)) return;

  FontSetResult = gnome_print_setfont (PS->PrintContext, PS->ActualPrintFont);

  TextUTF8 = g_locale_to_utf8 (TextToPrint, -1, &bytes_read, &bytes_written, NULL);

//double gnome_font_get_width_utf8 (const GnomeFont *font, const char *s);
//double gnome_font_get_width_utf8_sized (const GnomeFont *font, const char *s, int n);
//double gnome_font_get_width_string (const GnomeFont *font, const char *s);
//double gnome_font_get_width_string_n (const GnomeFont *font, const char *s, int n);

  switch (PS->PrintJustification) {
	case PrintLeftJustify:
		break; // PrintLeftJustify
	case PrintRightJustify:
		  TextXDiff= gnome_font_get_width_utf8 (PS->ActualPrintFont, TextUTF8);
		break; // PrintRightJustify
	case PrintCenterJustify:
		  TextXDiff= gnome_font_get_width_utf8 (PS->ActualPrintFont, TextUTF8) / 2;
		break; // PrintCenterJustify
	case PrintDecimalPointJustify:
		break; // PrintDecimalPointJustify
	case PrintLengthJustify:
		break; // PrintLengthJustify
  } // switch
  gnome_print_moveto(PS->PrintContext, PrintX - TextXDiff, PrintY);
  gnome_print_show(PS->PrintContext, (guchar *)TextUTF8);
  g_free (TextUTF8);
} // PrintText

void
PrintFormFeed (struct PrintStruct *PS) {
guchar *PageNum;

  PageNum = alloca (10);
  gnome_print_grestore (PS->PrintContext);
  gnome_print_showpage (PS->PrintContext);
  PS->PageNumber++;
  sprintf ((char *)PageNum, "%d", PS->PageNumber);
  gnome_print_beginpage (PS->PrintContext, PageNum);
  gnome_print_gsave (PS->PrintContext);
} // PrintFormFeed

// Line printer functions

void
LinePrintInit (struct PrintStruct *PS, double PrintXLeft, double PrintYFromUp, int Page0Lines) {
  PS->NumPrintLines = 50;
  PS->LineFeedValue = 14;
  PS->Page0Lines = Page0Lines;
  PS->PrintXLeft = PrintXLeft;
  PS->PrintYFromUp = PrintYFromUp;
  PS->PrintLineCounter = 0;
} // LinePrintInit

void
LinePrintDone (struct PrintStruct *PS) {
} // LinePrintDone

int
LinePrint (struct PrintStruct *PS, const char *TextToPrint) {
  PrintText (PS, PS->PrintXLeft, PS->PrintYFromUp + PS->ActualLinePos, TextToPrint);
  PS->ActualLinePos += PS->LineFeedValue;
  PS->PrintLineCounter++;
  if (PS->PageNumber == 0) {
	  if (PS->PrintLineCounter >= PS->Page0Lines) {
		  PrintFormFeed (PS);
		  PS->ActualLinePos = 0;
		  PS->PrintLineCounter = 0;
	  } // Page0Lines
  } else {
	  if (PS->PrintLineCounter >= PS->NumPrintLines) {
		  PrintFormFeed (PS);
		  PS->ActualLinePos = 0;
		  PS->PrintLineCounter = 0;
	  } // NumPrintLines
  }
} // LinePrint

void
LinePrintCounterInit (struct PrintStruct *PS, int Page0Lines) {
  PS->NumPrintLines = 50;
  PS->Page0Lines = Page0Lines;
  PS->PrintLineCounter = 0;
  PS->PageNumber = 0;
  PS->ActualLinePos = 0;
} // LinePrintCounterInit

void
LinePrintCounterDone (struct PrintStruct *PS) {
} // LinePrintCounterDone

int
LinePrintCounter (struct PrintStruct *PS) {
  PS->PrintLineCounter++;
  if (PS->PageNumber == 0) {
	  if (PS->PrintLineCounter >= PS->Page0Lines) {
		  PrintFormFeed (PS);
		  PS->PrintLineCounter = 0;
	  } // Page0Lines
  } else {
	  if (PS->PrintLineCounter >= PS->NumPrintLines) {
		  PrintFormFeed (PS);
		  PS->PrintLineCounter = 0;
	  } // NumPrintLines
  }
} // LinePrintCounter

/*
**************************************
***
***    Start of chromatographic print functions
***
**************************************
*/

void
PrintTest (struct PrintStruct *PS) {
int		i;
char	*TestString;
double	Xcoord, Ycoord;

  TestString = alloca (1000);

  gnome_print_setfont (PS->PrintContext, PS->PrintFontTest);
  gnome_print_setlinewidth (PS->PrintContext, 0.1);

  gnome_print_moveto (PS->PrintContext, 0, PS->PaperHeight / 2);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth, PS->PaperHeight / 2);
  gnome_print_stroke (PS->PrintContext);

  for (i = 0; i < ((int)PS->PaperWidth / 100) + 1; i++) {
	  gnome_print_moveto (PS->PrintContext, i * 100, PS->PaperHeight / 2);
	  gnome_print_lineto (PS->PrintContext, i * 100, (PS->PaperHeight / 2) + 15);
	  gnome_print_stroke (PS->PrintContext);
	  gnome_print_moveto (PS->PrintContext, i * 100, PS->PaperHeight / 2 + 20);
	  sprintf (TestString, "X = %d", i * 100);
	  gnome_print_show (PS->PrintContext, (guchar *)TestString);
  } // for i

  for (i = 0; i < ((int)PS->PaperWidth / 10) + 1; i++) {
	  gnome_print_moveto (PS->PrintContext, i * 10, PS->PaperHeight / 2);
	  gnome_print_lineto (PS->PrintContext, i * 10, (PS->PaperHeight / 2) + 5);
	  gnome_print_stroke (PS->PrintContext);
  } // for i

  gnome_print_moveto (PS->PrintContext, PS->PaperWidth / 2, 0);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth / 2, PS->PaperHeight);
  gnome_print_stroke (PS->PrintContext);

  for (i = 0; i < ((int)PS->PaperHeight / 100) + 1; i++) {
	  gnome_print_moveto (PS->PrintContext, PS->PaperWidth / 2, i * 100);
	  gnome_print_lineto (PS->PrintContext, PS->PaperWidth / 2 + 15, i * 100);
	  gnome_print_stroke (PS->PrintContext);
	  gnome_print_moveto (PS->PrintContext, PS->PaperWidth / 2 + 20, i * 100);
	  sprintf (TestString, "Y = %d", i * 100);
	  gnome_print_show (PS->PrintContext, (guchar *)TestString);
  } // for i

  for (i = 0; i < ((int)PS->PaperHeight / 10) + 1; i++) {
	  gnome_print_moveto (PS->PrintContext, PS->PaperWidth / 2, i * 10);
	  gnome_print_lineto (PS->PrintContext, PS->PaperWidth / 2 + 5, i * 10);
	  gnome_print_stroke (PS->PrintContext);
  } // for i

  gnome_print_moveto (PS->PrintContext, PS->PageMarginLeft, PS->PageMarginBottom);
  gnome_print_lineto (PS->PrintContext, PS->PageMarginLeft, PS->PaperHeight - PS->PageMarginTop);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth - PS->PageMarginRight, PS->PaperHeight - PS->PageMarginTop);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth - PS->PageMarginRight, PS->PageMarginBottom);
  gnome_print_lineto (PS->PrintContext, PS->PageMarginLeft, PS->PageMarginBottom);
  gnome_print_stroke (PS->PrintContext);

  
  gnome_print_setlinewidth (PS->PrintContext, 0.25);
  
  gnome_print_moveto (PS->PrintContext, PS->LCMarginLeft, PS->LCMarginBottom);
  gnome_print_lineto (PS->PrintContext, PS->LCMarginLeft, PS->PaperHeight - PS->LCMarginTop);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth - PS->LCMarginRight, PS->PaperHeight - PS->LCMarginTop);
  gnome_print_lineto (PS->PrintContext, PS->PaperWidth - PS->LCMarginRight, PS->LCMarginBottom);
  gnome_print_lineto (PS->PrintContext, PS->LCMarginLeft, PS->LCMarginBottom);
  gnome_print_stroke (PS->PrintContext);

  PrintFormFeed (PS);

  gnome_print_moveto (PS->PrintContext, 100, 200);
  gnome_print_lineto (PS->PrintContext, 200, 200);
  gnome_print_lineto (PS->PrintContext, 200, 100);
  gnome_print_lineto (PS->PrintContext, 100, 200);
  gnome_print_stroke (PS->PrintContext);

  PrintFormFeed (PS);


} // PrintTest

#include "print_queue.c"
#include "print_chrom.c"
#include "print_peak.c"
#include "print_params.c"

void
PrintTR930Spectra (struct PrintStruct *PS) {
char		*PrintString;
double	AxisX0,AxisY0;
double	AxisLength,AxisHeight;
double	x1,x2,y1,y2;
int		i;

  PrintString = alloca (10000);
  DrawPrintFrame (PS, 0.4, 0, 1, 1, 0.7);

  AxisX0 = 10;
  AxisY0 = 15;
  AxisLength = PS->PrintLocalWidth - 20;
  AxisHeight = PS->PrintLocalHeight - 35;

  // Draws the axis
  gnome_print_setlinewidth (PS->PrintContext, 0.2);
  gnome_print_newpath (PS->PrintContext);
  gnome_print_moveto(PS->PrintContext, AxisX0, AxisY0 + AxisHeight);
  gnome_print_lineto(PS->PrintContext, AxisX0, AxisY0);
  gnome_print_lineto(PS->PrintContext, AxisX0 + AxisLength, AxisY0);
  gnome_print_moveto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_lineto(PS->PrintContext, 0, 0);
  gnome_print_closepath (PS->PrintContext);
  gnome_print_stroke (PS->PrintContext);
  gnome_print_setlinewidth (PS->PrintContext, 1.0);

  gnome_print_setlinewidth (PS->PrintContext, 0.3);
  for (i=0; i<57; i++) {
	  gnome_print_newpath (PS->PrintContext);
	  gnome_print_moveto(PS->PrintContext, AxisX0 + i * (AxisLength / 56.0), AxisY0);
	  gnome_print_lineto(PS->PrintContext, AxisX0 + i * (AxisLength / 56.0), AxisY0 - 3);
	  gnome_print_lineto(PS->PrintContext, AxisX0 + i * (AxisLength / 56.0), AxisY0);
	  gnome_print_closepath (PS->PrintContext);
	  gnome_print_stroke (PS->PrintContext);
  } // i
  gnome_print_setlinewidth (PS->PrintContext, 0.6);
  for (i=0; i<6; i++) {
	  gnome_print_newpath (PS->PrintContext);
	  gnome_print_moveto(PS->PrintContext, AxisX0 + i * (AxisLength / 5.6), AxisY0);
	  gnome_print_lineto(PS->PrintContext, AxisX0 + i * (AxisLength / 5.6), AxisY0 - 6);
	  gnome_print_lineto(PS->PrintContext, AxisX0 + i * (AxisLength / 5.6), AxisY0);
	  gnome_print_closepath (PS->PrintContext);
	  gnome_print_stroke (PS->PrintContext);
  } // i
  SetPrintFont (PS, PS->PrintFontAxis);
  for (i=0; i<6; i++) {
	  sprintf (PrintString, "%d [nm]", 200 + i*100);
	  PrintText (PS, AxisX0 + 2 + i * (AxisLength / 5.6), AxisY0 - 12, PrintString);
  } // i

  /*
  gnome_print_setlinewidth (PS->PrintContext, 0.6);
	if (Spectra.Sh930ResultMaxData!=0)
	{
		for (i=1; i<560; i++)
		{
			x1=(560.0-(float)i)*AxisLength/560.0;
			x2=(560.0-(float)i-1.0)*AxisLength/560.0;
			y1=AxisHeight*(Spectra.Sh930ResultMaxData-Spectra.Sh930SpectraEvaluatedData[i-1]+Spectra.Sh930ResultMinData)/Spectra.Sh930ResultMaxData;
			y2=AxisHeight*(Spectra.Sh930ResultMaxData-Spectra.Sh930SpectraEvaluatedData[i]+Spectra.Sh930ResultMinData)/Spectra.Sh930ResultMaxData;
			gnome_print_newpath (PS->PrintContext);
			gnome_print_moveto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x2, AxisY0 + y2);
			gnome_print_lineto(PS->PrintContext, AxisX0 + x1, AxisY0 + y1);
			gnome_print_closepath (PS->PrintContext);
			gnome_print_stroke (PS->PrintContext);
		} // i
	} // MaxData!=0

	FontSetResult = gnome_print_setfont (PS->PrintContext, BoldBigFont);
	sprintf (PrintString, "File name: %s", SpectraName);
	PrintText (PS->PrintContext, AxisX0, AxisY0 + AxisHeight + 10, PrintString);
	*/
} // PrintTR930Spectra

/*
**************************************
***
***    End of chromatographic print functions
***
**************************************
*/

extern void
PrintFontsInit (struct PrintStruct *PS) {
BT_INIT();

  sprintf (BugTraceUserString, "PrintFontDefault = gnome_font_find_closest (%s, 10); FAILED", CentralOptions.PrintFontDefaultName);
  PS->PrintFontDefault = gnome_font_find_closest ((guchar *)CentralOptions.PrintFontDefaultName, 10);
  if (!PS->PrintFontDefault) {
	  BUGTRACE (BugTraceUserString); }

  sprintf (BugTraceUserString, "PrintFontTest = gnome_font_find_closest (%s, 6); FAILED", CentralOptions.PrintFontTestName);
  PS->PrintFontTest = gnome_font_find_closest ((guchar *)CentralOptions.PrintFontTestName, 6);
  if (!PS->PrintFontTest) {
	  BUGTRACE (BugTraceUserString); }

  sprintf (BugTraceUserString, "PrintFontChromPeakData = gnome_font_find_closest (%s, 6); FAILED", CentralOptions.PrintFontChromPeakDataName);
  PS->PrintFontChromPeakData = gnome_font_find_closest ((guchar *)CentralOptions.PrintFontChromPeakDataName, 6);
  if (!PS->PrintFontChromPeakData) {
	  BUGTRACE (BugTraceUserString); }

  sprintf (BugTraceUserString, "PrintFontPeakList = gnome_font_find_closest (%s, 10); FAILED", CentralOptions.PrintFontPeakListName);
  PS->PrintFontPeakList = gnome_font_find_closest ((guchar *)CentralOptions.PrintFontPeakListName, 10);
  if (!PS->PrintFontPeakList) {
	  BUGTRACE (BugTraceUserString); }

  sprintf (BugTraceUserString, "PrintFontAxis = gnome_font_find_closest (%s, 6); FAILED", CentralOptions.PrintFontAxisName);
  PS->PrintFontAxis = gnome_font_find_closest ((guchar *)CentralOptions.PrintFontAxisName, 6);
  if (!PS->PrintFontAxis) {
	  BUGTRACE (BugTraceUserString); }

  // Internal init
  SetPrintFont (PS, PS->PrintFontDefault);
  SetPrintJustify (PS, PrintLeftJustify, 0);
} // PrintFontsInit

void
PrintFontsDone (struct PrintStruct *PS) {
  if (PS->PrintFontAxis)
	  g_object_unref (G_OBJECT (PS->PrintFontAxis));
  if (PS->PrintFontPeakList)
	  g_object_unref (G_OBJECT (PS->PrintFontPeakList));
  if (PS->PrintFontChromPeakData)
	  g_object_unref (G_OBJECT (PS->PrintFontChromPeakData));
  if (PS->PrintFontTest)
	  g_object_unref (G_OBJECT (PS->PrintFontTest));
  if (PS->PrintFontDefault)
	  g_object_unref (G_OBJECT (PS->PrintFontDefault));
} // PrintFontsDone

void
PrintExec (struct PrintStruct *PS) {
guchar *PageNumber;

  PrintFontsInit (PS);
  PS->PageNumber = 1;
  PageNumber = alloca (10);
  sprintf ((char *)PageNumber, "%d", 1);
  gnome_print_beginpage (PS->PrintContext, PageNumber);
  gnome_print_setfont (PS->PrintContext, PS->PrintFontDefault);
  gnome_print_gsave (PS->PrintContext);
  switch (PS->PrintMode) {
	  case PrintTestMode:
		  gnome_print_config_dump (PS->PrintConfig);
		  PrintTest (PS);
		  break;
	  case PrintChromMode:
		  PrintChrom (PS);
		  break;
	  case PrintPeakDataMode:
		  PrintPeakData (PS);
		  break;
	  case PrintTR930SpectraMode:
		  PrintTR930Spectra (PS);
		  break;
	  case PrintControlListMode:
		  PrintControlList (PS);
		  break;
	  case PrintSampleQueueMode:
		  PrintSampleQueue (PS);
		  break;
	  case PrintIntParMode:
		  PrintIntPar (PS);
		  break;
  } // switch PrintMode
  gnome_print_grestore (PS->PrintContext);
  gnome_print_showpage (PS->PrintContext);
  PrintFontsDone (PS);

} // PrintExec

void
PrintConfigParameters (struct PrintStruct *PS) {
double PrintConfigDouble;
gboolean SizeRetVal;
gdouble Width, Height;

  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_WIDTH, &PrintConfigDouble);
  PS->PaperWidth = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_HEIGHT, &PrintConfigDouble);
  PS->PaperHeight = PrintConfigDouble;

  SizeRetVal = gnome_print_config_get_page_size (PS->PrintConfig, &Width, &Height);
  PS->PaperWidth = Width;
  PS->PaperHeight = Height;

  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_LAYOUT_WIDTH, &PrintConfigDouble);
  PS->LayoutWidth = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_LAYOUT_HEIGHT, &PrintConfigDouble);
  PS->LayoutHeight = PrintConfigDouble;

  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_MARGIN_LEFT, &PrintConfigDouble);
  PS->PaperMarginLeft = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_MARGIN_RIGHT, &PrintConfigDouble);
  PS->PaperMarginRight = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_MARGIN_TOP, &PrintConfigDouble);
  PS->PaperMarginTop = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAPER_MARGIN_BOTTOM, &PrintConfigDouble);
  PS->PaperMarginBottom = PrintConfigDouble;

  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAGE_MARGIN_LEFT, &PrintConfigDouble);
  PS->PageMarginLeft = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAGE_MARGIN_RIGHT, &PrintConfigDouble);
  PS->PageMarginRight = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAGE_MARGIN_TOP, &PrintConfigDouble);
  PS->PageMarginTop = PrintConfigDouble;
  gnome_print_config_get_double (PS->PrintConfig, (guchar *)GNOME_PRINT_KEY_PAGE_MARGIN_BOTTOM, &PrintConfigDouble);
  PS->PageMarginBottom = PrintConfigDouble;

  PS->PageRatio = 1.0;
  if (PS->PaperHeight > 0)
	  PS->PageRatio = PS->PaperWidth / PS->PaperHeight;

  PS->LCMarginLeft = CentralOptions.PrintMarginLeft;
  PS->LCMarginRight = CentralOptions.PrintMarginRight;
  PS->LCMarginTop = CentralOptions.PrintMarginTop;
  PS->LCMarginBottom = CentralOptions.PrintMarginBottom;

  /*
  printf ("PS->LCMarginLeft = %f\n", PS->LCMarginLeft);
  printf ("PS->LCMarginRight = %f\n", PS->LCMarginRight);
  printf ("PS->LCMarginTop = %f\n", PS->LCMarginTop);
  printf ("PS->LCMarginBottom = %f\n", PS->LCMarginBottom);
  */

  printf ("PS->PaperWidth = %f\n", PS->PaperWidth);
  printf ("PS->PaperHeight = %f\n", PS->PaperHeight);
  printf ("PS->LayoutWidth = %f\n", PS->LayoutWidth);
  printf ("PS->LayoutHeight = %f\n", PS->LayoutHeight);

//  gnome_print_config_dump (PS->PrintConfig);
} // PrintConfigParameters

extern void
PrintFunction (int PrintMode, void *UserParams1, void *UserParams2, gboolean ShowUserWindow)
{
struct PrintStruct *PS;
GtkWidget *PrintDialog;
gint DialogResponse;
gchar *PrintHeader;

  PS = calloc (1, sizeof (struct PrintStruct));
  PS->PrintMode = PrintMode;
  PS->UserParams1 = UserParams1;
  PS->UserParams2 = UserParams2;
  PS->PrintJob = gnome_print_job_new (NULL);
  PS->PrintContext = gnome_print_job_get_context (PS->PrintJob);
  PS->PrintConfig = gnome_print_job_get_config (PS->PrintJob);
  //PrintConfigParameters (PS);

  if (ShowUserWindow) {
	  PrintHeader = calloc (100, sizeof(char));
	  strcpy (PrintHeader, "Print");
	  printf ("PrintDialog\n");
	  if (PS == NULL)
		  printf ("### PS == NULL\n");
	  if (PS->PrintJob == NULL)
		  printf ("### PS->PrintJob == NULL\n");
	  printf ("PrintHeader: %s\n", PrintHeader);
	  PrintDialog = gnome_print_dialog_new (PS->PrintJob, (const guchar *)PrintHeader, 0);
	  printf ("PrintDialog\n");
	  free (PrintHeader);
	  DialogResponse = gnome_print_dialog_run (GNOME_PRINT_DIALOG (PrintDialog));
	  // g_print ("DialogResponse %d\n", DialogResponse);
	  gtk_widget_destroy (PrintDialog);
  } else {
	  DialogResponse = GNOME_PRINT_DIALOG_RESPONSE_PRINT;
  }

  if (DialogResponse != GNOME_PRINT_DIALOG_RESPONSE_CANCEL) {
	  PrintConfigParameters (PS);
	  PrintExec (PS);
  } // if DialogResponse

  gnome_print_job_close (PS->PrintJob);

  switch (DialogResponse) {
	  case GNOME_PRINT_DIALOG_RESPONSE_PRINT:
	  g_print ("Printing ...\n");
	  gnome_print_job_print (PS->PrintJob);
		  break;
	  case GNOME_PRINT_DIALOG_RESPONSE_PREVIEW:
	  g_print ("Print preview ...\n");
	  gtk_widget_show (GTK_WIDGET(gnome_print_job_preview_new (PS->PrintJob, "Print preview")));
		  break;
	  case GNOME_PRINT_DIALOG_RESPONSE_CANCEL:
	  g_print ("Printing was canceled\n");
		  break;
  } // switch (DialogResponse)

  g_object_unref (G_OBJECT (PS->PrintConfig));
  g_object_unref (G_OBJECT (PS->PrintContext));
  g_object_unref (G_OBJECT (PS->PrintJob));
  free (PS);
} // PrintFunction

extern void
PrintInit (void) {
} // PrintInit

extern void
PrintDone (void) {
} // PrintDone
