// Definitions of peak functions and integrate

extern void
ReintegrateDBI (int DataSource) {
  PeakListResetForDetect (DataSource);
  PeakListResetForBaseline (DataSource);
  PeakListResetForIntegration (DataSource);
  PeakDetect (DataSource);
  CalculateBaseline (DataSource);
  PostProcessBaseline (DataSource);
  CalculateIntegral (DataSource);
  CalculatePerformance (DataSource);
  UpperPeak (DataSource);
} // Reintegrate

extern void
ReintegrateBI (int DataSource) {
  PeakListResetForBaseline (DataSource);
  PeakListResetForIntegration (DataSource);
  CalculateBaseline (DataSource);
  PostProcessBaseline (DataSource);
  CalculateIntegral (DataSource);
  CalculatePerformance (DataSource);
  UpperPeak (DataSource);
} // Reintegrate

extern void
ReintegrateI (int DataSource) {
  PeakListResetForIntegration (DataSource);
  CalculateIntegral (DataSource);
  CalculatePerformance (DataSource);
  UpperPeak (DataSource);
} // Reintegrate

extern void
UpperPeak (int DataSource) {
int		j;

  Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper = Chrom[DataSource].ChromHead->PeakHead.PeakNum[0];
  for (j = 1; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++)
	  if (Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper < Chrom[DataSource].ChromHead->PeakHead.PeakNum[j])
		  Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper = Chrom[DataSource].ChromHead->PeakHead.PeakNum[j];
} // UpperPeak

extern void
PeakListResetForDetect (int DataSource) {
int j;

  Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] = 0;
  Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper = 0;
  for (j = 0; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++)
	  if (Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper < Chrom[DataSource].ChromHead->PeakHead.PeakNum[j])
		  Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper = Chrom[DataSource].ChromHead->PeakHead.PeakNum[j];
  Chrom[DataSource].ChromHead->PeakHead.Integrated = TRUE;
} // PeakListResetForDetect

extern void
PeakListResetForBaseline (int DataSource) {

} // PeakListResetForBaseline

extern void
PeakListResetForIntegration (int DataSource) {

  Chrom[DataSource].ChromHead->PeakHead.AreaSum[Chrom[DataSource].ActualDetector] = 0;
  Chrom[DataSource].ChromHead->PeakHead.HeightSum[Chrom[DataSource].ActualDetector] = 0;
} // PeakListResetForIntegration

extern double
BaseIntegral (int BegBI, int EndBI, int DataSource) {
double		BIRetVal;
int			i;

  BIRetVal = 0;
  for (i = BegBI; i<EndBI + 1; i++)
  {
	  BIRetVal += ChromData (i, DataSource);
  } // for i
  BIRetVal -= (ChromData (BegBI, DataSource) + ChromData (EndBI, DataSource)) * (EndBI - BegBI + 1) / 2;

  return BIRetVal;
} // BaseIntegral

extern double
BaseHeight (int BegBH, int ApexBH, int EndBH, int DataSource) {
double		BHRetVal;

  BHRetVal = 0;
  if (BegBH != EndBH)
	  BHRetVal = ChromData (ApexBH, DataSource) - (ChromData (BegBH, DataSource) + (ChromData(EndBH, DataSource) - ChromData (BegBH, DataSource)) * (ApexBH - BegBH) / (EndBH - BegBH));

  return BHRetVal;
} // BaseHeight

extern int
CheckPeakThreshold (int CPTBeg, int CPTApex, int CPTEnd, int DataSource) {

  //PRINTF ("CheckPeakThreshold started.\n", 0);
  //PRINTF ("CheckPeakThreshold retention: %.3f.\n",CPTR(CPTApex, DataSource));

  //PRINTF ("BaseIntegral: %.3f\n",BaseIntegral (CPTBeg, CPTEnd, DataSource));
  if (BaseIntegral (CPTBeg, CPTEnd, DataSource) < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].MinArea) return FALSE;
  //PRINTF ("Peak AREA Ok.\n", 0);

  //PRINTF ("BaseHeight: %.3f\n",BaseHeight (CPTBeg, CPTApex, CPTEnd, DataSource));
  if (BaseHeight (CPTBeg, CPTApex, CPTEnd, DataSource) < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].MinLevel) return FALSE;
  //PRINTF ("Peak HEIGHT Ok.\n", 0);

  //PRINTF ("BaseWidth: %.3f\n",CPTR (CPTEnd - CPTBeg, DataSource));
  if (CPTR (CPTEnd - CPTBeg, DataSource) < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].MinWidth) return FALSE;
  //PRINTF ("Peak WIDTH Ok.\n", 0);

  return TRUE;
} // CheckPeakThreshold

gboolean
EvaluateLock (int DataSource, int Idx) {
gboolean ELo;
int i;

  ELo = FALSE;
  for (i = 0; i < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].LockNum; i++) {
	  if ((CPTR (Idx, DataSource) > Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].LockWindOn[i]) && \
		  (CPTR (Idx, DataSource) < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].LockWindOff[i]))
		  ELo = TRUE;
  } // i

  return ELo;
} // EvaluateLock in PeakDetect

void
EvaluateEvents (int DataSource) {
} // EvaluateEvents in PeakDetect

extern
void	PeakDetect (int DataSource) {
/*
#define PeakDetectStateIdle 0
#define PeakDetectStateUp 1
#define PeakDetectStateApex 2
#define PeakDetectStateDown 3
#define PeakDetectStateDone 4
*/
int			i;
int			EndPeakDet;
int			PeakDetectState;
int			PeakDetectLastState;

int			PeakStartIdx;
int			PeakApexIdx;
int			PeakEndIdx;

double	PeakStartVal;
double	PeakApexVal;
double	PeakEndVal;
double	PeakBaseVal;

int			DetFollowUp;
int			DetFollowApex;
int			DetFollowDown;

double	PeakDetDeriv1;
double	PeakDetDeriv2;
double	PeakDetValue;

BT_INIT();

  BUGTRACE ("Peak detection started.");

  i = 0;
	EndPeakDet = FALSE;
	DetFollowUp = 0;
	DetFollowApex = 0;
	DetFollowDown = 0;
	PeakStartIdx = 0;
	PeakApexIdx = 0;
	PeakEndIdx = 0;
	PeakDetectState = PeakDetectStateIdle;
	PeakDetectLastState = PeakDetectStateIdle;
	while (EndPeakDet == FALSE) {

  if (EvaluateLock (DataSource, i))
	  PeakDetectState = PeakDetectStateIdle;
	EvaluateEvents (DataSource);

	DetectPoint (i, &PeakDetValue, &PeakDetDeriv1, &PeakDetDeriv2, DataSource);
  //PRINTF ("i = %d   PeakDetValue = %.3f   PeakDetDeriv1 = %.3f   PeakDetDeriv2 = %.3f\n", i, PeakDetValue, PeakDetDeriv1, PeakDetDeriv2);
	switch (PeakDetectState) {
	case PeakDetectStateIdle:
		if (PeakDetDeriv1 > Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].PozSlope)
		{
		ResetPeak (DataSource);
		Chrom[DataSource].Peak->PeakBegin = CPTR (i, DataSource);
		PeakStartIdx = i;
		PeakStartVal = PeakDetValue;
		PeakEndVal = PeakDetValue;
		PeakBaseVal = PeakDetValue;
		PeakDetectState = PeakDetectStateUp;
		PeakDetectLastState = PeakDetectStateIdle;
		DetFollowUp = 0;
		} // if Deriv1
		break; // PeakDetectStateIdle
	case PeakDetectStateUp:
		if (DetFollowUp < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].FollowUp)
		{
		if (PeakDetDeriv1 > Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].PozSlope)
		{
			DetFollowUp++;
		} else {
			PeakDetectState = PeakDetectStateIdle;
		} // if Deriv
		} else {
		if (PeakDetDeriv1 < 0)
		{
		Chrom[DataSource].Peak->PeakRetention = CPTR (i, DataSource);
		PeakApexIdx = i;
		PeakApexVal = PeakDetValue;
		PeakDetectState = PeakDetectStateApex;
		DetFollowApex = 0;
		} // if Deriv < 0
		} // FollowUp
		break; // PeakDetectStateUp
	case PeakDetectStateApex:
		if (DetFollowApex < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].FollowAx)
		{
		if (PeakDetDeriv1 < 0)
		{
			DetFollowApex++;
		} else {
			PeakDetectState = PeakDetectStateUp;
		} // if Deriv < 0
		} else {
			PeakDetectState = PeakDetectStateDown;
		} // if DetFollowApex <
		break; // PeakDetectStateApex
	case PeakDetectStateDown:
		if (PeakDetDeriv1 > Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].NegSlope)
		{
			Chrom[DataSource].Peak->PeakEnd = CPTR (i, DataSource);
			PeakEndIdx = i;
			PeakEndVal = PeakDetValue;
			DetFollowDown = 0;
			PeakDetectState = PeakDetectStateDone;
			PeakDetectLastState = PeakDetectStateDown;
		} // if Deriv > NegSlope
		break; // PeakDetectStateDown
	case PeakDetectStateDone:
		if (DetFollowDown < Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].FollowDn)
		{
		if (PeakDetDeriv1 > Chrom[DataSource].ChromHead->Method.IntegrationParameters[Chrom[DataSource].ActualDetector].NegSlope)
		{
			DetFollowDown++;
		} else {
			PeakDetectState = PeakDetectStateDown;
		} // Deriv > NegSlope
		} else {
			if (CheckPeakThreshold (PeakStartIdx, PeakApexIdx, PeakEndIdx, DataSource) == TRUE)
			{
				Chrom[DataSource].Peak->PeakRetentionIdx = PeakApexIdx;
				Chrom[DataSource].Peak->PeakBeginIdx = PeakStartIdx;
				Chrom[DataSource].Peak->PeakEndIdx = PeakEndIdx;
				AddPeak (DataSource);
			} // Threshold == TRUE
			PeakDetectState = PeakDetectStateIdle;
			i = PeakEndIdx -1;
		} // if FollowDown
		break; // PeakDetectStateDone
	} // switch (PeakDetectState)

	i++;
	if (i<Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp) 
		{ EndPeakDet = FALSE; } else
		{ EndPeakDet = TRUE; }
	} // while i

  BUGTRACE ("Peak detection finished.");
} // PeakDetect

extern void
DetectPoint (int Idx, double *PeakDetValue, double *PeakDetDeriv1, double *PeakDetDeriv2, int DataSource) {

  *PeakDetValue = ChromData (Idx, DataSource);
  *PeakDetDeriv1 = 0;
  *PeakDetDeriv2 = 0;

  if (Idx == 0) return;
  if (Idx > (Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp - 2)) return;

  *PeakDetDeriv1 = (ChromData (Idx+1, DataSource) - ChromData (Idx-1, DataSource)) /2;
  //PRINTF ("i = %d   PeakDetValue = %.3f   PeakDetDeriv1 = %.3f   PeakDetDeriv2 = %.3f\n", Idx, *PeakDetValue, *PeakDetDeriv1, *PeakDetDeriv2);
} // DetectPoint

extern void
CalculateBaseline (int DataSource) {
int i;

  for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
	  GetPeak (i, DataSource);
	  Chrom[DataSource].Peak->BlTimeBegin = Chrom[DataSource].Peak->PeakBegin;
	  Chrom[DataSource].Peak->BlTimeEnd = Chrom[DataSource].Peak->PeakEnd;
	  Chrom[DataSource].Peak->BlValueBegin = ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource);
	  Chrom[DataSource].Peak->BlValueEnd = ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource);
	  SetPeak (i, DataSource);
 } // for i
} // CalculateBaseline

void
CheckPeakInterSkim (int Idx, int DataSource) {
int i;
double PosSum, NegSum, TempSum;
double BlValLocal;
int FoundPoint;
double FoundSlope, TempSlope;

BT_INIT();

  PosSum = 0;
  NegSum = 0;

  for (i = CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource); i < CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource); i++) {
	  BlValLocal = (double)(i - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource)) / \
	  				(double)(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource) - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource));
	  BlValLocal *= (ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource) - \
	  				ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource));
	  BlValLocal += ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource);
	  TempSum = ChromData (i, DataSource) - BlValLocal;
	  if (TempSum > 0)
		  PosSum += TempSum;
	  else
		  NegSum += TempSum;
  } // i

  if (fabs (NegSum) > 0.01*PosSum) {
	  sprintf (BugTraceUserString, "InterSkim peak found: %d,   PosSum = %.3f,   NegSum = %.3f", Idx + 1, PosSum, NegSum);
	  BUGTRACE(BugTraceUserString);
	  if (ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource) - \
					ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource) < 0) {
		  // Downslope peak
		  FoundPoint = CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource);
		  FoundSlope = (ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource) - \
	  					ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource)) / \
	  					(double)(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource) - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource));
		  for (i = CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource); i > CRTP(Chrom[DataSource].Peak->PeakRetention, DataSource); i--) {
			  TempSlope = (ChromData(i, DataSource) - ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource)) / \
	  					(double)(i - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource));
			  if (TempSlope < FoundSlope) {
				  FoundPoint = i;
				  FoundSlope = TempSlope;
			  }
		  } // i
		  Chrom[DataSource].Peak->BlTimeEnd = CPTR (FoundPoint, DataSource);
		  Chrom[DataSource].Peak->BlValueEnd = ChromData(FoundPoint, DataSource);
	  } else {
		  // Upslope peak
		  FoundPoint = CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource);
		  FoundSlope = (ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource) - \
	  					ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource)) / \
	  					(double)(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource) - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource));
		  for (i = CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource); i < CRTP(Chrom[DataSource].Peak->PeakRetention, DataSource); i++) {
			  TempSlope = (ChromData(i, DataSource) - ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource)) / \
	  					(double)(i - CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource));
			  if (TempSlope > FoundSlope) {
				  FoundPoint = i;
				  FoundSlope = TempSlope;
			  }
		  } // i
		  Chrom[DataSource].Peak->BlTimeBegin = CPTR (FoundPoint, DataSource);
		  Chrom[DataSource].Peak->BlValueBegin = ChromData(FoundPoint, DataSource);
	  }
  } // if NegSum > PosSum
} // CheckPeakInterSkim

extern void
PostProcessBaseline (int DataSource) {
int i;

  for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
	  GetPeak (i, DataSource);
	  CheckPeakInterSkim (i, DataSource);
	  SetPeak (i, DataSource);
 } // for i
} // PostProcessBaseline

extern
void	CalculateIntegral (int DataSource) {
int		i;

	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++)
	{
		GetPeak (i, DataSource);
		CalculateArea (DataSource);
		CalculateHeight (DataSource);
		if (Chrom[DataSource].Peak->PeakHeight != 0) Chrom[DataSource].Peak->PeakAperH = Chrom[DataSource].Peak->PeakArea / Chrom[DataSource].Peak->PeakHeight;
		Chrom[DataSource].ChromHead->PeakHead.AreaSum[Chrom[DataSource].ActualDetector] += Chrom[DataSource].Peak->PeakArea;
		Chrom[DataSource].ChromHead->PeakHead.HeightSum[Chrom[DataSource].ActualDetector] += Chrom[DataSource].Peak->PeakHeight;
		SetPeak (i, DataSource);
	} // for i

	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++)
	{
		GetPeak (i, DataSource);
		if (Chrom[DataSource].ChromHead->PeakHead.AreaSum[Chrom[DataSource].ActualDetector] != 0)
			Chrom[DataSource].Peak->PeakAreaR = Chrom[DataSource].Peak->PeakArea/Chrom[DataSource].ChromHead->PeakHead.AreaSum[Chrom[DataSource].ActualDetector];
		if (Chrom[DataSource].ChromHead->PeakHead.HeightSum[Chrom[DataSource].ActualDetector] != 0)
			Chrom[DataSource].Peak->PeakHeightR = Chrom[DataSource].Peak->PeakHeight/Chrom[DataSource].ChromHead->PeakHead.HeightSum[Chrom[DataSource].ActualDetector];
		SetPeak (i, DataSource);
	} // for i
} // CalculateIntegral

extern void
CalculateArea (int DataSource) {
int		i;

	Chrom[DataSource].Peak->PeakArea = 0;
	for (i=CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource); i<CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource) + 1; i++)
	{
		Chrom[DataSource].Peak->PeakArea += ChromData (i, DataSource);
	} // for i

	Chrom[DataSource].Peak->PeakArea -= (Chrom[DataSource].Peak->BlValueEnd+Chrom[DataSource].Peak->BlValueBegin)/2*(CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource)-CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource)+1);

} // CalculateArea

extern void
CalculateHeight (int DataSource) {

	Chrom[DataSource].Peak->PeakHeight = 0;

	if ((Chrom[DataSource].Peak->BlTimeEnd - Chrom[DataSource].Peak->BlTimeBegin) == 0) return;

	Chrom[DataSource].Peak->PeakHeight = ChromData (CRTP(Chrom[DataSource].Peak->PeakRetention, DataSource), DataSource) - 
					(Chrom[DataSource].Peak->BlValueBegin + 
					(Chrom[DataSource].Peak->BlValueEnd - Chrom[DataSource].Peak->BlValueBegin) * 
					(Chrom[DataSource].Peak->PeakRetention - Chrom[DataSource].Peak->BlTimeBegin) / (Chrom[DataSource].Peak->BlTimeEnd - Chrom[DataSource].Peak->BlTimeBegin));
} // CalculateHeight

extern void
CalculatePerformance (int DataSource) {
int		i,j;
int		w1_10,w2_10;
int		w1_50,w2_50;
double	SelK;
int		SelPeak;
double	LastK;
double	LastRet;
double	LastW50;
double	HeightL;

//	if (FileLoaded[ChrFlag] != TRUE) return;
	if (Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] < 1) return;
//	FileSaved[ChrFlag] = FALSE;

	SelK = 0;
	LastK = 0;
	LastRet = 0;
	LastW50 = 0;

	if (Chrom[DataSource].ChromHead->PeakHead.SelPeakForAlfa > 0) {
		SelPeak = InPeak (Chrom[DataSource].ChromHead->PeakHead.SelPeakForAlfa, DataSource);
		if (SelPeak > -1) {
			GetPeak (SelPeak, DataSource);
			SelK = 0;
			if (Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0 > 0) SelK = (Chrom[DataSource].Peak->PeakRetention - Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0) / Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0;
		} // SelPeak > -1
	} // ChromHeadActual->PeakHead.SelPeakForAlfa > 0

	for (i = 0; i< Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
		GetPeak (i, DataSource);
		// Width at 10%
		w1_10 = 0;
		w2_10 = 0;
		HeightL = ChromData (CRTP (Chrom[DataSource].Peak->PeakRetention, DataSource), DataSource)-0.9 * Chrom[DataSource].Peak->PeakHeight;
		for (j = CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource); j < CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource); j++) {
			if ((ChromData (j, DataSource) >= HeightL) && (w1_10 == 0)) w1_10 = j;
		} // for j
		for (j = CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource); j > CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource); j--) {
			if ((ChromData (j, DataSource) >= HeightL) && (w2_10 == 0)) w2_10 = j;
		} // for j
		Chrom[DataSource].Peak->Peak10B = CPTR (w1_10, DataSource);
		Chrom[DataSource].Peak->Peak10E = CPTR (w2_10, DataSource);
		Chrom[DataSource].Peak->PeakW10 = Chrom[DataSource].Peak->Peak10E - Chrom[DataSource].Peak->Peak10B;
		
		// Width at 50%
		w1_50 = 0;
		w2_50 = 0;
		HeightL = ChromData (CRTP (Chrom[DataSource].Peak->PeakRetention, DataSource), DataSource)-0.5 * Chrom[DataSource].Peak->PeakHeight;
		for (j = CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource); j < CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource); j++) {
			if ((ChromData (j, DataSource) >= HeightL) && (w1_50 == 0)) w1_50 = j;
		} // for j
		for (j = CRTP(Chrom[DataSource].Peak->BlTimeEnd, DataSource); j > CRTP(Chrom[DataSource].Peak->BlTimeBegin, DataSource); j--) {
			if ((ChromData (j, DataSource) >= HeightL) && (w2_50 == 0)) w2_50 = j;
		} // for j
		Chrom[DataSource].Peak->Peak50B = CPTR (w1_50, DataSource);
		Chrom[DataSource].Peak->Peak50E = CPTR (w2_50, DataSource);
		Chrom[DataSource].Peak->PeakW50 = Chrom[DataSource].Peak->Peak50E - Chrom[DataSource].Peak->Peak50B;
		
	// n BL
		Chrom[DataSource].Peak->PeakWBL = Chrom[DataSource].Peak->BlTimeEnd - Chrom[DataSource].Peak->BlTimeBegin;
		Chrom[DataSource].Peak->PeakNBL = 0;
		if (Chrom[DataSource].Peak->PeakWBL > 0)
			Chrom[DataSource].Peak->PeakNBL = 16 * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakWBL) * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakWBL);

		// n 10%
		if (Chrom[DataSource].Peak->PeakW10 > 0)
			Chrom[DataSource].Peak->PeakN10 = 16 * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakW10) * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakW10);

		// n 50%
		if (Chrom[DataSource].Peak->PeakW50 > 0)
			Chrom[DataSource].Peak->PeakN50 = 5.545 * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakW50) * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakW50);

		// n I/H
		if (Chrom[DataSource].Peak->PeakAperH > 0)
			Chrom[DataSource].Peak->PeakNIH = 5.545 * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakAperH/0.939) * (Chrom[DataSource].Peak->PeakRetention / Chrom[DataSource].Peak->PeakAperH/0.939);

		// k
		Chrom[DataSource].Peak->PeakK = 0;
		if (Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0 != 0)
			Chrom[DataSource].Peak->PeakK = (Chrom[DataSource].Peak->PeakRetention - Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0) / Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].RetT0;

		// Alfa
		Chrom[DataSource].Peak->PeakAlfa = 0;
		if (LastK != 0)
			Chrom[DataSource].Peak->PeakAlfa = Chrom[DataSource].Peak->PeakK / LastK;

		// Selected Alfa
		Chrom[DataSource].Peak->PeakAlfaS = 0;
		if (SelK != 0)
			Chrom[DataSource].Peak->PeakAlfaS = Chrom[DataSource].Peak->PeakK / SelK;

		// Resolution
		Chrom[DataSource].Peak->PeakR = 0;
		if ((Chrom[DataSource].Peak->PeakW50 > 0) && (LastW50 > 0))
			Chrom[DataSource].Peak->PeakR = (Chrom[DataSource].Peak->PeakRetention - LastRet) / (Chrom[DataSource].Peak->PeakW50 + LastW50) * 2.0 / 1.699;

		LastRet = Chrom[DataSource].Peak->PeakRetention;
		LastW50 = Chrom[DataSource].Peak->PeakW50;
		LastK = Chrom[DataSource].Peak->PeakK;

		SetPeak (i, DataSource);
	} // i -> PeakNum

/*
 For i:=1 To ChromHead->PeakH.PeakNum Do
     Begin
      GetPeak(i);
      { Rf }
      Case Config.SystemMode Of
           SystemGeneric:;
           SystemTR540:Begin
            If (ChromHead->Par.FrontL>0) And
               (ChromHead->Par.FrontL-ChromHead->Par.T0>0) Then
               Chrom[DataSource].Peak->PeakRf:=(Chrom[DataSource].Peak->PeakRet-ChromHead->Par.T0)/
                            (ChromHead->Par.FrontL-ChromHead->Par.T0);
           End; { 540 }
           SystemGenericDens:;
           SystemHP3396A:;
           BCMEControler:;
           Else RunError(255);
           End; { Case Config.SystemMode Of }
      { Width at 10% }
      w1_10:=0;
      w2_10:=0;
      HeightL:=ChromData(CRTP(Chrom[DataSource].Peak->PeakRet))-0.9*Chrom[DataSource].Peak->PeakHeight;
      For j:=CRTP(Chrom[DataSource].Peak->BlTimeBeg) To CRTP(Chrom[DataSource].Peak->BlTimeEnd) Do
          If (ChromData(j)>=HeightL) And
             (w1_10=0) Then
             w1_10:=j;
      For j:=CRTP(Chrom[DataSource].Peak->BlTimeEnd) DownTo CRTP(Chrom[DataSource].Peak->BlTimeBeg) Do
          If (ChromData(j)>=HeightL) And
             (w2_10=0) Then
             w2_10:=j;
      Chrom[DataSource].Peak->Peak10B:=CPTR(w1_10);
      Chrom[DataSource].Peak->Peak10E:=CPTR(w2_10);
      Chrom[DataSource].Peak->PeakW10:=Chrom[DataSource].Peak->Peak10E-Chrom[DataSource].Peak->Peak10B;
      { Width at half height }
      w1_50:=0;
      w2_50:=0;
      HeightL:=ChromData(CRTP(Chrom[DataSource].Peak->PeakRet))-0.5*Chrom[DataSource].Peak->PeakHeight;
      For j:=CRTP(Chrom[DataSource].Peak->BlTimeBeg) To CRTP(Chrom[DataSource].Peak->BlTimeEnd) Do
          If (ChromData(j)>=HeightL) And
             (w1_50=0) Then
             w1_50:=j;
      For j:=CRTP(Chrom[DataSource].Peak->BlTimeEnd) DownTo CRTP(Chrom[DataSource].Peak->BlTimeBeg) Do
          If (ChromData(j)>=HeightL) And
             (w2_50=0) Then
             w2_50:=j;
      Chrom[DataSource].Peak->Peak50B:=CPTR(w1_50);
      Chrom[DataSource].Peak->Peak50E:=CPTR(w2_50);
      Chrom[DataSource].Peak->PeakW50:=Chrom[DataSource].Peak->Peak50E-Chrom[DataSource].Peak->Peak50B;

      { n BL }
      Chrom[DataSource].Peak->PeakWBL:=Chrom[DataSource].Peak->BlTimeEnd-Chrom[DataSource].Peak->BlTimeBeg;
      If Chrom[DataSource].Peak->PeakWBL>0
         Then Chrom[DataSource].Peak->PeakNBL:=16*Sqr(Chrom[DataSource].Peak->PeakRet/Chrom[DataSource].Peak->PeakWBL)
         Else Chrom[DataSource].Peak->PeakNBL:=0;

      { n 10% }
      If Chrom[DataSource].Peak->PeakW10>0
         Then Chrom[DataSource].Peak->PeakN10:=16*Sqr(Chrom[DataSource].Peak->PeakRet/Chrom[DataSource].Peak->PeakW10)
         Else Chrom[DataSource].Peak->PeakN10:=0;

      { n 50% }
      If Chrom[DataSource].Peak->PeakW50>0
         Then Chrom[DataSource].Peak->PeakN50:=5.545*Sqr(Chrom[DataSource].Peak->PeakRet/Chrom[DataSource].Peak->PeakW50)
         Else Chrom[DataSource].Peak->PeakN50:=0;

      { n I/H }
      If Chrom[DataSource].Peak->PeakAPerH>0
         Then Chrom[DataSource].Peak->PeakNIH:=5.545*Sqr(Chrom[DataSource].Peak->PeakRet/Chrom[DataSource].Peak->PeakAPerH/0.939)
         Else Chrom[DataSource].Peak->PeakNIH:=0;

      { k }
      If ChromHead->Par.T0<>0
         Then Chrom[DataSource].Peak->PeakK:=(Chrom[DataSource].Peak->PeakRet-ChromHead->Par.T0)/ChromHead->Par.T0
         Else Chrom[DataSource].Peak->PeakK:=0;

      { Alfa }
      If LastK<>0
         Then Chrom[DataSource].Peak->PeakAlfa:=Chrom[DataSource].Peak->PeakK/LastK
         Else Chrom[DataSource].Peak->PeakAlfa:=0;
      LastK:=Chrom[DataSource].Peak->PeakK;

      { Selected Alfa }
      If SelK<>0
         Then Chrom[DataSource].Peak->PeakAlfaS:=Chrom[DataSource].Peak->PeakK/SelK
         Else Chrom[DataSource].Peak->PeakAlfaS:=0;

      { Resolution }
      If (Chrom[DataSource].Peak->PeakW50>0) And (LastW50>0)
         Then Chrom[DataSource].Peak->PeakR:=(Chrom[DataSource].Peak->PeakRet-LastRet)/(Chrom[DataSource].Peak->PeakW50+LastW50)*2/1.699
         Else Chrom[DataSource].Peak->PeakR:=0;

      { Symmetry 10% }
      If (Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->Peak10B>0) And (Chrom[DataSource].Peak->Peak10B<>0)
         Then Chrom[DataSource].Peak->PeakSym10:=(Chrom[DataSource].Peak->Peak10E-Chrom[DataSource].Peak->PeakRet)/
                              (Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->Peak10B)
         Else Chrom[DataSource].Peak->PeakSym10:=0;

      { Symmetry 50% }
      If (Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->Peak50B>0) And (Chrom[DataSource].Peak->Peak50B<>0)
         Then Chrom[DataSource].Peak->PeakSym50:=(Chrom[DataSource].Peak->Peak50E-Chrom[DataSource].Peak->PeakRet)/
                              (Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->Peak50B)
         Else Chrom[DataSource].Peak->PeakSym50:=0;

      { Symmetry BL }
      If Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->BlTimeBeg>0
         Then Chrom[DataSource].Peak->PeakSymBL:=(Chrom[DataSource].Peak->BlTimeEnd-Chrom[DataSource].Peak->PeakRet)/
                              (Chrom[DataSource].Peak->PeakRet-Chrom[DataSource].Peak->BlTimeBeg)
         Else Chrom[DataSource].Peak->PeakSymBL:=0;

      LastRet:=Chrom[DataSource].Peak->PeakRet;
      LastW50:=Chrom[DataSource].Peak->PeakW50;

      SetPeak(i);
     End; { i }
 Menteni[ChrFlag]:=MenteniKell;
*/
} // CalculatePerformance

extern void
ResetPeak (int DataSource) {

	// Names
	strcpy(Chrom[DataSource].Peak->PeakName,"");
	Chrom[DataSource].Peak->PeakId = 0;
	strcpy(Chrom[DataSource].Peak->PeakIdStr,"");
	Chrom[DataSource].Peak->PeakIdentified = FALSE;
	// Special information
	Chrom[DataSource].Peak->PeakOverFlow = FALSE;                // Bool, any overflow int the peak
	Chrom[DataSource].Peak->PeakRetentionMode = 0;
	Chrom[DataSource].Peak->PeakSolvent = 0;
	Chrom[DataSource].Peak->PeakNegative = 0;
	// Peak data
	Chrom[DataSource].Peak->PeakRetention = 0;
	Chrom[DataSource].Peak->PeakRf = 0;
	Chrom[DataSource].Peak->PeakRelativeRetention = 0;
	Chrom[DataSource].Peak->PeakBegin = 0;
	Chrom[DataSource].Peak->PeakEnd = 0;
	Chrom[DataSource].Peak->Peak10B = 0;
	Chrom[DataSource].Peak->Peak10E = 0;
	Chrom[DataSource].Peak->Peak50B = 0;
	Chrom[DataSource].Peak->Peak50E = 0;
	Chrom[DataSource].Peak->PeakArea = 0;
	Chrom[DataSource].Peak->PeakHeight = 0;
	Chrom[DataSource].Peak->PeakAreaR = 0;
	Chrom[DataSource].Peak->PeakHeightR = 0;
	Chrom[DataSource].Peak->PeakAperH = 0;
	Chrom[DataSource].Peak->PeakConc = 0;
	Chrom[DataSource].Peak->PeakConcPercent = 0;
	Chrom[DataSource].Peak->PeakConcFactor = 0;                 // Factor from caliration
	// Ist id data
	Chrom[DataSource].Peak->PeakIsIst = 0;
	Chrom[DataSource].Peak->AssignedToIst = 0;
	// Detected peak type data
	Chrom[DataSource].Peak->DetTypeBeg = BP_BASE;
	Chrom[DataSource].Peak->DetTypeEnd = BP_BASE;
	// Baseline data
	Chrom[DataSource].Peak->BlTimeBegin = 0;
	Chrom[DataSource].Peak->BlTimeEnd = 0;
	Chrom[DataSource].Peak->BlValueBegin = 0;
	Chrom[DataSource].Peak->BlValueEnd = 0;
	Chrom[DataSource].Peak->BlTypeBegin = BP_BASE;
	Chrom[DataSource].Peak->BlTypeEnd = BP_BASE;
	Chrom[DataSource].Peak->PeakComponent = 0;
	// Performance data
	Chrom[DataSource].Peak->PeakW10 = 0;                        // Width at baseline
	Chrom[DataSource].Peak->PeakW50 = 0;                        // Width at half height
	Chrom[DataSource].Peak->PeakWBL = 0;                        // Width at baseline
	Chrom[DataSource].Peak->PeakN10 = 0;                        // Efficiency by Width at 10%
	Chrom[DataSource].Peak->PeakN50 = 0;                        // Efficiency by Width at 50%
	Chrom[DataSource].Peak->PeakNBL = 0;                        // Efficiency by Width at baseline
	Chrom[DataSource].Peak->PeakNIH = 0;                        // Efficiency by Area/Height
	Chrom[DataSource].Peak->PeakK = 0;                          // Partition factor
	Chrom[DataSource].Peak->PeakAlfa = 0;                       // Selectivity to prev. peak
	Chrom[DataSource].Peak->PeakAlfaS = 0;                      // Selectivity to selected peak
	Chrom[DataSource].Peak->PeakR = 0;                          // Resolution
	Chrom[DataSource].Peak->PeakN = 0;                          // Theoretical plates
	Chrom[DataSource].Peak->PeakSym10 = 0;                      // Symmetry at 10%
	Chrom[DataSource].Peak->PeakSym50 = 0;                      // Symmetry at 50%
	Chrom[DataSource].Peak->PeakSymBL = 0;                      // Symmetry at BaseLine
	Chrom[DataSource].Peak->PeakSymA = 0;                       // Symmetry by area
	Chrom[DataSource].Peak->PeakM1 = 0;                         // 1st moment
	Chrom[DataSource].Peak->PeakM2 = 0;                         // 2nd moment
	Chrom[DataSource].Peak->PeakM3 = 0;                         // 3rd moment
	Chrom[DataSource].Peak->PeakM4 = 0;                         // 4th moment
	// System information
	Chrom[DataSource].Peak->SelectForDel = FALSE;
	Chrom[DataSource].Peak->CompIdentResult = 0;                // Component identified in Analysis
	Chrom[DataSource].Peak->SelectForBLR = FALSE;               // Selected for Baseline recalc
} // ResetPeak

extern void
ResetIstPeak (int DataSource) {

	// Names
	strcpy(Chrom[DataSource].IstPeak->PeakName,"");
	Chrom[DataSource].IstPeak->PeakId = 0;
	strcpy(Chrom[DataSource].IstPeak->PeakIdStr,"");
	Chrom[DataSource].IstPeak->PeakIdentified = FALSE;
	// Special information
	Chrom[DataSource].IstPeak->PeakOverFlow = FALSE;                // Bool, any overflow int the peak
	Chrom[DataSource].IstPeak->PeakRetentionMode = 0;
	Chrom[DataSource].IstPeak->PeakSolvent = 0;
	Chrom[DataSource].IstPeak->PeakNegative = 0;
	// Peak data
	Chrom[DataSource].IstPeak->PeakRetention = 0;
	Chrom[DataSource].IstPeak->PeakRf = 0;
	Chrom[DataSource].IstPeak->PeakRelativeRetention = 0;
	Chrom[DataSource].IstPeak->PeakBegin = 0;
	Chrom[DataSource].IstPeak->PeakEnd = 0;
	Chrom[DataSource].IstPeak->Peak10B = 0;
	Chrom[DataSource].IstPeak->Peak10E = 0;
	Chrom[DataSource].IstPeak->Peak50B = 0;
	Chrom[DataSource].IstPeak->Peak50E = 0;
	Chrom[DataSource].IstPeak->PeakArea = 1;
	Chrom[DataSource].IstPeak->PeakHeight = 1;
	Chrom[DataSource].IstPeak->PeakAreaR = 0;
	Chrom[DataSource].IstPeak->PeakHeightR = 0;
	Chrom[DataSource].IstPeak->PeakAperH = 0;
	Chrom[DataSource].IstPeak->PeakConc = 0;
	Chrom[DataSource].IstPeak->PeakConcPercent = 0;
	Chrom[DataSource].IstPeak->PeakConcFactor = 0;                 // Factor from caliration
	// Ist id data
	Chrom[DataSource].IstPeak->PeakIsIst = 0;
	Chrom[DataSource].IstPeak->AssignedToIst = 0;
	// Detected peak type data
	Chrom[DataSource].IstPeak->DetTypeBeg = BP_BASE;
	Chrom[DataSource].IstPeak->DetTypeEnd = BP_BASE;
	// Baseline data
	Chrom[DataSource].IstPeak->BlTimeBegin = 0;
	Chrom[DataSource].IstPeak->BlTimeEnd = 0;
	Chrom[DataSource].IstPeak->BlValueBegin = 0;
	Chrom[DataSource].IstPeak->BlValueEnd = 0;
	Chrom[DataSource].IstPeak->BlTypeBegin = BP_BASE;
	Chrom[DataSource].IstPeak->BlTypeEnd = BP_BASE;
	Chrom[DataSource].IstPeak->PeakComponent = 0;
	// Performance data
	Chrom[DataSource].IstPeak->PeakW10 = 0;                        // Width at baseline
	Chrom[DataSource].IstPeak->PeakW50 = 0;                        // Width at half height
	Chrom[DataSource].IstPeak->PeakWBL = 0;                        // Width at baseline
	Chrom[DataSource].IstPeak->PeakN10 = 0;                        // Efficiency by Width at 10%
	Chrom[DataSource].IstPeak->PeakN50 = 0;                        // Efficiency by Width at 50%
	Chrom[DataSource].IstPeak->PeakNBL = 0;                        // Efficiency by Width at baseline
	Chrom[DataSource].IstPeak->PeakNIH = 0;                        // Efficiency by Area/Height
	Chrom[DataSource].IstPeak->PeakK = 0;                          // Partition factor
	Chrom[DataSource].IstPeak->PeakAlfa = 0;                       // Selectivity to prev. peak
	Chrom[DataSource].IstPeak->PeakAlfaS = 0;                      // Selectivity to selected peak
	Chrom[DataSource].IstPeak->PeakR = 0;                          // Resolution
	Chrom[DataSource].IstPeak->PeakN = 0;                          // Theoretical plates
	Chrom[DataSource].IstPeak->PeakSym10 = 0;                      // Symmetry at 10%
	Chrom[DataSource].IstPeak->PeakSym50 = 0;                      // Symmetry at 50%
	Chrom[DataSource].IstPeak->PeakSymBL = 0;                      // Symmetry at BaseLine
	Chrom[DataSource].IstPeak->PeakSymA = 0;                       // Symmetry by area
	Chrom[DataSource].IstPeak->PeakM1 = 0;                         // 1st moment
	Chrom[DataSource].IstPeak->PeakM2 = 0;                         // 2nd moment
	Chrom[DataSource].IstPeak->PeakM3 = 0;                         // 3rd moment
	Chrom[DataSource].IstPeak->PeakM4 = 0;                         // 4th moment
	// System information
	Chrom[DataSource].IstPeak->SelectForDel = FALSE;
	Chrom[DataSource].IstPeak->CompIdentResult = 0;                // Component identified in Analysis
	Chrom[DataSource].IstPeak->SelectForBLR = FALSE;               // Selected for Baseline recalc
} // ResetIstPeak

extern void
GetPeak (int PeakNum, int DataSource) {
BT_INIT();
struct PeakStruct *PA;

  if (PeakNum < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]) {
	  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
	  memcpy (Chrom[DataSource].Peak, &PA[PeakNum], sizeof(struct PeakStruct));
  } else {
	  sprintf (BugTraceUserString, "### Peak GET error - GetPeak, PeakNum: %d, ChromHeadActual->PeakHead.PeakNum: %d, DataSource = %d",PeakNum,Chrom[DataSource].ChromHead->PeakHead.PeakNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // GetPeak

extern void
SetPeak (int PeakNum, int DataSource) {
BT_INIT();
struct PeakStruct *PA;

  if (PeakNum < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]) {
	  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
	  memcpy (&PA[PeakNum], Chrom[DataSource].Peak, sizeof(struct PeakStruct));
  } else {
	  sprintf (BugTraceUserString, "### Peak SET error - SetPeak, PeakNum: %d, ChromHeadActual->PeakHead.PeakNum: %d, DataSource = %d",PeakNum,Chrom[DataSource].ChromHead->PeakHead.PeakNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // SetPeak

extern void
GetCalibrTemplatePeak (int PeakNum, int DataSource) {
BT_INIT();
struct PeakStruct *PA;

  if (PeakNum < Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrTemplateActualDetector]) {
	  PA = Chrom[DataSource].CalibrTemplatePeakArray[Chrom[DataSource].CalibrTemplateActualDetector];
	  memcpy (Chrom[DataSource].CalibrTemplatePeak, &PA[PeakNum], sizeof(struct PeakStruct));
  } else {
	  sprintf (BugTraceUserString, "### Peak GET error - GetCalibrTemplatePeak, PeakNum: %d, CalibrTemplateChromHead->PeakHead.PeakNum: %d, DataSource = %d",PeakNum,Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // GetCalibrTemplatePeak

extern void
GetCalibrPeak (int PeakNum, int DataSource) {
BT_INIT();
struct PeakStruct *PA;

  if (PeakNum < Chrom[DataSource].CalibrChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrActualDetector]) {
	  PA = Chrom[DataSource].CalibrPeakArray[Chrom[DataSource].CalibrActualDetector];
	  memcpy (Chrom[DataSource].CalibrPeak, &PA[PeakNum], sizeof(struct PeakStruct));
  } else {
	  sprintf (BugTraceUserString, "### Peak GET error - GetCalibrPeak, PeakNum: %d, CalibrChromHead->PeakHead.PeakNum: %d, DataSource = %d",PeakNum,Chrom[DataSource].CalibrChromHead->PeakHead.PeakNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // GetCalibrPeak

extern int
FindPeak (float PeakBeg, float PeakEnd, int DataSource) {
int		FPRet;
int		i;

  for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++)
  {
	  FPRet = i;
	  GetPeak (i, DataSource);
	  if ((Chrom[DataSource].Peak->PeakRetention>=PeakBeg) && (Chrom[DataSource].Peak->PeakRetention<=PeakEnd)) { return FPRet; }
  } // i

	FPRet = -1;
	return FPRet;
} // FindPeak

extern int
InPeak (float PeakRet, int DataSource) {
int		IPRet;
int		i;

	for (i=0; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++)
	{
		IPRet = i;
		GetPeak (i, DataSource);
		if ((PeakRet>=Chrom[DataSource].Peak->BlTimeBegin) &&\
			(PeakRet<=Chrom[DataSource].Peak->BlTimeEnd)) return IPRet;
	} // i

	IPRet = -1;
	return IPRet;
} // InPeak

extern int
FindNearestPeak (double PeakRet, int DataSource) {
int FNP;
int i;
double RetDiff;

  FNP = 0;
  GetPeak (0, DataSource);
  RetDiff = fabs (PeakRet - Chrom[DataSource].Peak->BlTimeBegin);
  for (i = 0; i < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
	  GetPeak (i, DataSource);
	  if (fabs (PeakRet - Chrom[DataSource].Peak->BlTimeBegin) < RetDiff) {
		  RetDiff = fabs (PeakRet - Chrom[DataSource].Peak->BlTimeBegin);
		  FNP = i;
	  }
	  if (fabs (PeakRet - Chrom[DataSource].Peak->BlTimeEnd) < RetDiff) {
		  RetDiff = fabs (PeakRet - Chrom[DataSource].Peak->BlTimeEnd);
		  FNP = i;
	  }
  } // i

  return FNP;
} // FindNearestPeak

extern void
AddPeak (int DataSource) {
struct PeakStruct *PA;
  ReallocPeakData (Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper + 1, DataSource);
  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
  memcpy (&PA[Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]], \
		  Chrom[DataSource].Peak, sizeof(struct PeakStruct));
  Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]++;
  if (Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector])
	  Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper = Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector];
  SortPeakList (DataSource);
} // AddPeak

extern void	ModPeak (int ModPeakNum, int DataSource) {
struct PeakStruct *PA;
BT_INIT();

  if (ModPeakNum < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]) {
	  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
	  memcpy (&PA[ModPeakNum], Chrom[DataSource].Peak, sizeof (struct PeakStruct));
  } else {
	  sprintf (BugTraceUserString, "### Peak modify error, ModPeakNum: %d, ChromHead->PeakHead.PeakNum: %d, DataSource = %d",ModPeakNum,Chrom[DataSource].ChromHead->PeakHead.PeakNum, DataSource);
	  BUGTRACE(BugTraceUserString);
  } // if
} // ModPeak

extern void
DelPeak (int DelPeakNum, int DataSource) {
int		i;
struct PeakStruct *PA;
BT_INIT();

  if ((DelPeakNum < 0) || \
	  (Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] < DelPeakNum) || \
	  (Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] < 1)) {
	  sprintf (BugTraceUserString, "### Peak delete error, DelPeakNum: %d, ChromHead->PeakHead.PeakNum: %d, DataSource = %d",DelPeakNum,Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector], DataSource);
	  BUGTRACE(BugTraceUserString);
	  return;
  } // if

  Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]--;
  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
  for (i=DelPeakNum; i<Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++)
  {
	  memcpy (&PA[i], &PA[i+1], sizeof (struct PeakStruct));
  } // i
  ReintegrateI (DataSource);
  Chrom[DataSource].FileSaved[ChrFlag] = FALSE;
} // DelPeak

extern void
DelPeaks (int DataSource) {
} // DelPeaks

extern void
SortPeakList (int DataSource) {
int i;
struct PeakStruct *PS, *PST;
BT_INIT();

  if (Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] < 2) return;

  PS = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
  PST = alloca (sizeof (struct PeakStruct));
  for (i = Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] - 1; i > 0; i--) {
	  if (PS[i-1].PeakRetention > PS[i].PeakRetention) {
		  memcpy (PST, &PS[i], sizeof (struct PeakStruct));
		  memcpy (&PS[i], &PS[i-1], sizeof (struct PeakStruct));
		  memcpy (&PS[i-1], PST, sizeof (struct PeakStruct));
	  } // PeakRetention
  } // i
} // SortPeakList

extern void
FindPeakRet (int DataSource) {
int		i;
int		TempMaxI;
float	TempMax;

	TempMaxI = CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource);
	TempMax = ChromData (TempMaxI, DataSource);
	for (i=CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource); i<CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource); i++)
	{
		if (ChromData(i, DataSource) > TempMax)
		{
			TempMax = ChromData(i, DataSource);
			TempMaxI = i;
		} // if
	} // for i
	Chrom[DataSource].Peak->PeakRetention = CPTR (TempMaxI, DataSource);
} // FindPeakRet

extern int
FindNearestPeakByBasepoint (int DataSource, double ActualRetention) {
} // FindNearestPeakByBasepoint

extern void
FitValleyGroupBaseline (int DataSource, int PeakInGroup) {
int FirstGroupPeak, LastGroupPeak;
int i, j;
double FirstBPRet, FirstBPVal;
double LastBPRet, LastBPVal;
double CommonRet, CommonRetEnd, CommonVal;

  i = PeakInGroup;
  FirstGroupPeak = i;
  GetPeak (i, DataSource);
  FirstBPRet = Chrom[DataSource].Peak->BlTimeBegin;
  FirstBPVal = Chrom[DataSource].Peak->BlValueBegin;
  while ((i > 0) && (Chrom[DataSource].Peak->BlTypeBegin == BP_VALLEY)) {
	  i--;
	  GetPeak (i, DataSource);
	  FirstGroupPeak = i;
	  FirstBPRet = Chrom[DataSource].Peak->BlTimeBegin;
	  FirstBPVal = Chrom[DataSource].Peak->BlValueBegin;
  } // while i
  i = PeakInGroup;
  LastGroupPeak = i;
  GetPeak (i, DataSource);
  LastBPRet = Chrom[DataSource].Peak->BlTimeEnd;
  LastBPVal = Chrom[DataSource].Peak->BlValueEnd;
  while ((i < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]) &&\
         (Chrom[DataSource].Peak->BlTypeEnd == BP_VALLEY)) {
	  i++;
	  GetPeak (i, DataSource);
	  LastGroupPeak = i;
	  LastBPRet = Chrom[DataSource].Peak->BlTimeEnd;
	  LastBPVal = Chrom[DataSource].Peak->BlValueEnd;
  } // while i
  printf ("FirstGroupPeak = %d,   LastGroupPeak = %d\n", FirstGroupPeak, LastGroupPeak);
  for (i = FirstGroupPeak; i < LastGroupPeak; i++) {
	  GetPeak (i, DataSource);
	  CommonRet = Chrom[DataSource].Peak->BlTimeEnd;
	  CommonVal = Chrom[DataSource].Peak->BlValueEnd;
	  GetPeak (i + 1, DataSource);
	  CommonRetEnd = Chrom[DataSource].Peak->BlTimeBegin;
	  for (j = CRTP (CommonRet, DataSource); j < CRTP (CommonRetEnd, DataSource); j++) {
		  if (ChromData (j, DataSource) < CommonVal) {
			  CommonRet = CPTR (j, DataSource);
			  CommonVal = ChromData (j, DataSource);
		  } // if
	  } // j
	  GetPeak (i, DataSource);
	  Chrom[DataSource].Peak->BlTimeEnd = CommonRet;
	  SetPeak (i, DataSource);
	  GetPeak (i + 1, DataSource);
	  Chrom[DataSource].Peak->BlTimeBegin = CommonRet;
	  SetPeak (i + 1, DataSource);
  } // i
  printf ("FirstBPRet = %.3f,   LastBPRet = %.3f\n", FirstBPRet, LastBPRet);
  if (LastBPRet == FirstBPRet) LastBPRet = FirstBPRet + 0.1;
  for (i = FirstGroupPeak; i < LastGroupPeak + 1; i++) {
	  printf ("i = %d\n", i);
	  GetPeak (i, DataSource);
	  Chrom[DataSource].Peak->BlValueBegin = FirstBPVal + (Chrom[DataSource].Peak->BlTimeBegin - FirstBPRet) / (LastBPRet - FirstBPRet) * (LastBPVal - FirstBPVal);
	  Chrom[DataSource].Peak->BlValueEnd = FirstBPVal + (Chrom[DataSource].Peak->BlTimeEnd - FirstBPRet) / (LastBPRet - FirstBPRet) * (LastBPVal - FirstBPVal);
	  SetPeak (i, DataSource);
  } // i
} // FitValleyGroupBaseline

extern gboolean
ChangePeakBaseline (int DataSource, int ChangeMode){
gboolean RetVal;
int NearestPeak;
int OtherPeak;
int PeakSide;

  RetVal = TRUE;
  printf ("DataSource = %d\n", DataSource);
  printf ("CursorRetention = %.3f\n", CursorRetention);
  NearestPeak = FindNearestPeak (CursorRetention, DataSource);
  printf ("NearestPeak = %d\n", NearestPeak);
  GetPeak (NearestPeak, DataSource);
  PeakSide = PEAK_SIDE_BEGIN;
  if (CursorRetention - Chrom[DataSource].Peak->BlTimeBegin > Chrom[DataSource].Peak->BlTimeEnd - CursorRetention)
	  PeakSide = PEAK_SIDE_END;
  if (PeakSide == PEAK_SIDE_BEGIN)
	  printf ("PEAK_SIDE_BEGIN\n");
  else
	  printf ("PEAK_SIDE_END\n");
  if (Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] < 2) return FALSE;
  if ((PeakSide == PEAK_SIDE_BEGIN) && (NearestPeak < 1)) return FALSE;
  if ((PeakSide == PEAK_SIDE_END) && (NearestPeak > Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector] - 2)) return FALSE;
  if (PeakSide == PEAK_SIDE_END) {
	  NearestPeak = NearestPeak + 1;
  }
  OtherPeak = NearestPeak - 1;
  switch (ChangeMode) {
	  case BASEPOINT_TO_BASE:
		  GetPeak (NearestPeak, DataSource);
		  Chrom[DataSource].Peak->BlTypeBegin = BP_BASE;
	  Chrom[DataSource].Peak->BlTimeBegin = Chrom[DataSource].Peak->PeakBegin;
	  Chrom[DataSource].Peak->BlValueBegin = ChromData(CRTP(Chrom[DataSource].Peak->PeakBegin, DataSource), DataSource);
		  SetPeak (NearestPeak, DataSource);
		  GetPeak (OtherPeak, DataSource);
		  Chrom[DataSource].Peak->BlTypeEnd = BP_BASE;
	  Chrom[DataSource].Peak->BlTimeEnd = Chrom[DataSource].Peak->PeakEnd;
	  Chrom[DataSource].Peak->BlValueEnd = ChromData(CRTP(Chrom[DataSource].Peak->PeakEnd, DataSource), DataSource);
		  SetPeak (OtherPeak, DataSource);
		  FitValleyGroupBaseline (DataSource, NearestPeak);
		  FitValleyGroupBaseline (DataSource, OtherPeak);
		  break;
	  case BASEPOINT_TO_VALLEY:
		  GetPeak (NearestPeak, DataSource);
		  Chrom[DataSource].Peak->BlTypeBegin = BP_VALLEY;
		  SetPeak (NearestPeak, DataSource);
		  GetPeak (OtherPeak, DataSource);
		  Chrom[DataSource].Peak->BlTypeEnd = BP_VALLEY;
		  SetPeak (OtherPeak, DataSource);
		  FitValleyGroupBaseline (DataSource, NearestPeak);
		  break;
  } // switch
  return RetVal;
} // ChangePeakBaseline


// ***
// Integration parameter functions
// ***

extern int
FindLock (struct IntegrationParametersStruct *IntegrationParameters, double Retention) {
int RetVal;
int i;

  RetVal = -1;
  if (IntegrationParameters->LockNum == 0) return RetVal;
  for (i = 0; i < IntegrationParameters->LockNum; i++) {
	  if ((Retention > IntegrationParameters->LockWindOn[i]) &&\
		  (Retention < IntegrationParameters->LockWindOff[i]))
		  RetVal = i;
  } //  i

  return RetVal;
} // FindLock

extern int
FindEvent (struct IntegrationParametersStruct *IntegrationParameters, double Retention) {
double Diff;
int RetVal;
int i;

  RetVal = -1;
  if (IntegrationParameters->EventNum == 0) return RetVal;
  if (IntegrationParameters->EventNum == 1) return 0;

  Diff = fabs(IntegrationParameters->EventTime[IntegrationParameters->EventNum - 1] - Retention);
  RetVal = IntegrationParameters->EventNum - 1;
  for (i = 0; i < IntegrationParameters->EventNum; i++) {
	  if (fabs(IntegrationParameters->EventTime[i] - Retention) < Diff) {
		  RetVal = i;
		  Diff = fabs(IntegrationParameters->EventTime[i] - Retention);
	  } // if < Diff
  } //  i

  return RetVal;
} // FindEvent

extern void
DeleteLock (struct IntegrationParametersStruct *IntegrationParameters, int LockToDelete) {
int i;

  if (IntegrationParameters->LockNum == 0) return;
  IntegrationParameters->LockNum--;
  if (IntegrationParameters->LockNum == 0) return;
  if (IntegrationParameters->LockNum == LockToDelete) return;
  for (i = LockToDelete; i < IntegrationParameters->LockNum; i++) {
	  IntegrationParameters->LockWindOn[i] = IntegrationParameters->LockWindOn[i+1];
	  IntegrationParameters->LockWindOff[i] = IntegrationParameters->LockWindOff[i+1];
  } // for i

} // DeleteLock

extern void
DeleteEvent (struct IntegrationParametersStruct *IntegrationParameters, int EventToDelete) {
int		i;

  if (IntegrationParameters->EventNum == 0) return;
  IntegrationParameters->EventNum--;
  if (IntegrationParameters->EventNum == 0) return;
  if (IntegrationParameters->EventNum == EventToDelete) return;
  for (i = EventToDelete; i < IntegrationParameters->EventNum; i++) {
	  IntegrationParameters->EventType[i] = IntegrationParameters->EventType[i+1];
	  IntegrationParameters->EventTime[i] = IntegrationParameters->EventTime[i+1];
	  IntegrationParameters->EventFactor[i] = IntegrationParameters->EventFactor[i+1];
	  IntegrationParameters->EventParameter[i] = IntegrationParameters->EventParameter[i+1];
	  IntegrationParameters->EventActiveTime[i] = IntegrationParameters->EventActiveTime[i+1];
  } // for i

} // DeleteEvent

extern void
SortLocks (struct IntegrationParametersStruct *IntegrationParameters) {
int i;
double LockTemp;

  if (IntegrationParameters->LockNum < 2) return;
  for (i = IntegrationParameters->LockNum - 1; i > 0; i--) {
	  if (IntegrationParameters->LockWindOn[i] < IntegrationParameters->LockWindOn[i-1]) {
		  LockTemp = IntegrationParameters->LockWindOn[i-1];
		  IntegrationParameters->LockWindOn[i-1] = IntegrationParameters->LockWindOn[i];
		  IntegrationParameters->LockWindOn[i] = LockTemp;
		  LockTemp = IntegrationParameters->LockWindOff[i-1];
		  IntegrationParameters->LockWindOff[i-1] = IntegrationParameters->LockWindOff[i];
		  IntegrationParameters->LockWindOff[i] = LockTemp;
	  } // if
  } // for i

} // SortLocks

extern void
SortEvents (struct IntegrationParametersStruct *IntegrationParameters) {
int i;
double EventTempFloat;
int EventTempInt;

  if (IntegrationParameters->EventNum < 2) return;
  for (i=IntegrationParameters->EventNum-1; i>0; i--) {
	  if (IntegrationParameters->EventTime[i] < IntegrationParameters->EventTime[i-1]) {
		  EventTempInt = IntegrationParameters->EventType[i-1];
		  IntegrationParameters->EventType[i-1] = IntegrationParameters->EventType[i];
		  IntegrationParameters->EventType[i] = EventTempInt;
		  EventTempFloat = IntegrationParameters->EventTime[i-1];
		  IntegrationParameters->EventTime[i-1] = IntegrationParameters->EventTime[i];
		  IntegrationParameters->EventTime[i] = EventTempFloat;
		  EventTempInt = IntegrationParameters->EventFactor[i-1];
		  IntegrationParameters->EventFactor[i-1] = IntegrationParameters->EventFactor[i];
		  IntegrationParameters->EventFactor[i] = EventTempInt;
		  EventTempFloat = IntegrationParameters->EventParameter[i-1];
		  IntegrationParameters->EventParameter[i-1] = IntegrationParameters->EventParameter[i];
		  IntegrationParameters->EventParameter[i] = EventTempFloat;
		  EventTempFloat = IntegrationParameters->EventActiveTime[i-1];
		  IntegrationParameters->EventActiveTime[i-1] = IntegrationParameters->EventActiveTime[i];
		  IntegrationParameters->EventActiveTime[i] = EventTempFloat;
	  } // if
  } // for i

} // SortEvents

extern void
EventListInit (void) {
//				EventNumbers 42
EventList[0] = EventResetAllEvents;						// 0
EventList[1] = EventResetAllBaselineParameterEvent;		// 10
EventList[2] = EventSampleBaseline;						// 11
EventList[3] = EventResetBaselineParameters;			// 12
EventList[4] = EventResetAllSlopeCalculationEvent;		// 20
EventList[5] = EventSampleBaselineSlopeHere;			// 21
EventList[6] = EventResetBaselineSlopeValue;			// 22
EventList[7] = EventResetAllThresholdEvent;				// 30
EventList[8] = EventIncAreaThreshold;					// 31
EventList[9] = EventDecAreaThreshold;					// 32
EventList[10] = EventResetAreaThreshold;				// 33
EventList[11] = EventIncHeightThreshold;				// 34
EventList[12] = EventDecHeightThreshold;				// 35
EventList[13] = EventResetHeightThreshold;				// 36
EventList[14] = EventIncWidthThreshold;					// 37
EventList[15] = EventDecWidthThreshold;					// 38
EventList[16] = EventResetWidthThreshold;				// 39
EventList[17] = EventIncreaseUpslope;					// 40
EventList[18] = EventDecreaseUpslope;					// 41
EventList[19] = EventResetUpslope;						// 42
EventList[20] = EventIncreaseDownslope;					// 43
EventList[21] = EventDecreaseDownslope;					// 44
EventList[22] = EventResetDownslope;					// 45
EventList[23] = EventSetSlopeCalculationPoints;			// 46
EventList[24] = EventResetSlopeCalculation;				// 47
EventList[25] = EventPeakStartsHere;					// 50
EventList[26] = EventPeakEndsHere;						// 51
EventList[27] = EventResetBaselineSettingEvents;		// 60
EventList[28] = EventForceBaseBaseMethod;				// 61
EventList[29] = EventForcedValleyMethodON;				// 62
EventList[30] = EventForcedValleyMethodOFF;				// 63
EventList[31] = EventThisPeakIsTangentMain;				// 64
EventList[32] = EventNextPeakIsTangentMain;				// 65
EventList[33] = EventForceTangentMethodInRange;			// 66
EventList[34] = EventForcedBaselineSTART;				// 70
EventList[35] = EventForcedBaselineSTOP;				// 71
EventList[36] = EventForcedBaselineStringMethodENABLE;	// 72
EventList[37] = EventForcedBaselineStringMethodDISABLE;	// 73
EventList[38] = EventGluePeaks;							// 80
EventList[39] = EventGluePeaksON;						// 81
EventList[40] = EventGluePeaksOFF;						// 82
EventList[41] = EventSplitPeakHere;						// 83

strcpy (EventNames[0],"Reset all events");							// EventResetAllEvents							0
strcpy (EventNames[1],"Reset all baseline parameter events");		// EventResetAllBaselineParameterEvent			10
strcpy (EventNames[2],"Sample baseline parameters here");			// EventSampleBaseline							11
strcpy (EventNames[3],"Reset baseline parameters");					// EventResetBaselineParameters					12
strcpy (EventNames[4],"Reset slope calculation events");			// EventResetAllSlopeCalculationEvent			20
strcpy (EventNames[5],"Sample baseline slope here");				// EventSampleBaselineSlopeHere					21
strcpy (EventNames[6],"Reset baseline slope value");				// EventResetBaselineSlopeValue					22
strcpy (EventNames[7],"Reset all threshold events");				// EventResetAllThresholdEvent					30
strcpy (EventNames[8],"Increase area threshold");					// EventIncAreaThreshold						31
strcpy (EventNames[9],"Decrease area threshold");					// EventDecAreaThreshold						32
strcpy (EventNames[10],"Reset area threshold");						// EventResetAreaThreshold						33
strcpy (EventNames[11],"Increase height threshold");				// EventIncHeightThreshold						34
strcpy (EventNames[12],"Decrease height threshold");				// EventDecHeightThreshold						35
strcpy (EventNames[13],"Reset height threshold");					// EventResetHeightThreshold					36
strcpy (EventNames[14],"Increase width threshold");					// EventIncWidthThreshold						37
strcpy (EventNames[15],"Decrease width threshold");					// EventDecWidthThreshold						38
strcpy (EventNames[16],"Reset width threshold");					// EventResetWidthThreshold						39
strcpy (EventNames[17],"Increase upslope");							// EventIncreaseUpslope							40
strcpy (EventNames[18],"Decrease upslope");							// EventDecreaseUpslope							41
strcpy (EventNames[19],"Reset upslope");							// EventResetUpslope							42
strcpy (EventNames[20],"Increase downslope");						// EventIncreaseDownslope						43
strcpy (EventNames[21],"Decrease downslope");						// EventDecreaseDownslope						44
strcpy (EventNames[22],"Reset downslope");							// EventResetDownslope							45
strcpy (EventNames[23],"Set slope calculation points");				// EventSetSlopeCalculationPoints				46
strcpy (EventNames[24],"Reset slope calculation");					// EventResetSlopeCalculation					47
strcpy (EventNames[25],"Peak starts here");							// EventPeakStartsHere							50
strcpy (EventNames[26],"Peak ends here");							// EventPeakEndsHere							51
strcpy (EventNames[27],"Reset baseline setting events");			// EventResetBaselineSettingEvents					60
strcpy (EventNames[28],"Force Base-Base method");					// EventForceBaseBaseMethod						61
strcpy (EventNames[29],"Forced Valley method ON");					// EventForcedValleyMethodON					62
strcpy (EventNames[30],"Forced Valley method OFF");					// EventForcedValleyMethodOFF					63
strcpy (EventNames[31],"This peak is tangent main");				// EventThisPeakIsTangentMain					64
strcpy (EventNames[32],"Next peak is tangent main");				// EventNextPeakIsTangentMain					65
strcpy (EventNames[33],"Force tangent method in range");			// EventForceTangentMethodInRange				66
strcpy (EventNames[34],"Forced baseline START");					// EventForcedBaselineSTART						70
strcpy (EventNames[35],"Forced baseline STOP");						// EventForcedBaselineSTOP						71
strcpy (EventNames[36],"Forced baseline string method ENABLE");		// EventForcedBaselineStringMethodENABLE		72
strcpy (EventNames[37],"Forced baseline string method DISABLE");	// EventForcedBaselineStringMethodDISABLE		73
strcpy (EventNames[38],"Glue peaks");								// EventGluePeaks								80
strcpy (EventNames[39],"Glue peaks ON");							// EventGluePeaksON								81
strcpy (EventNames[40],"Glue peaks OFF");							// EventGluePeaksOFF							82
strcpy (EventNames[41],"Split peak here");							// EventSplitPeakHere							83
} // EventListInit

extern int
EventCode (int EventOrderInMenu) {
	strcpy (EventName, EventNames[EventOrderInMenu]);
	return EventList[EventOrderInMenu];
} // EventCode

extern int
EventOrderInMenu (int EventCode) {
int		i;
int		RetVal;

	RetVal = 0;
	for (i=0; i<EventNumbers; i++) {
		if (EventList[i] == EventCode) RetVal = i;
	} // for i

	return RetVal;
} // EventOrderInMenu

// Calibration functions

// Gaussian elimination

void
Initial(int Dimen, TNvector *Coefficients, double *Constants, double *Solution, int *Error) {
  *Error = 0;
  if (Dimen < 1) {
	  *Error = 1;
	  return;
  }
  if (Dimen != 1) return;
  if (fabs(Coefficients[0][0]) < TNNearlyZero)
    *Error = 2;
  else
    Solution[0] = Constants[0] / Coefficients[0][0];
} // Initial

void
EROswitch(double *Row1, double *Row2) {
  TNvector DummyRow;

  memcpy(&DummyRow, Row1, sizeof(TNvector));
  memcpy(Row1, Row2, sizeof(TNvector));
  memcpy(Row2, &DummyRow, sizeof(TNvector));
} // EROswitch

void
EROmultAdd(double Multiplier, int Dimen, double *ReferenceRow, double *ChangingRow) {
int Term;

  for (Term = 0; Term < Dimen; Term++) {
    ChangingRow[Term] += Multiplier * ReferenceRow[Term];
  }
} // EROmultAdd

void
Pivot(int Dimen, int ReferenceRow, TNvector *Coefficients, double *Constants, int *Error) {
int NewRow;
double Dummy;

  *Error = 2;   /* No solution exists */
  NewRow = ReferenceRow;
  while ((*Error > 0) && (NewRow < Dimen)) {
	  NewRow++;
	  if (fabs(Coefficients[NewRow-1][ReferenceRow-1]) <= TNNearlyZero)
		  continue;
	  EROswitch(Coefficients[NewRow-1], Coefficients[ReferenceRow-1]);
	  Dummy = Constants[NewRow-1];
	  Constants[NewRow-1] = Constants[ReferenceRow-1];
	  Constants[ReferenceRow-1] = Dummy;
	  *Error = 0;   /* Solution may exist */
  } // while
} // Pivot

void
UpperTriangular(int Dimen, TNvector *Coefficients, double *Constants, int *Error) {
double Multiplier;
int Row;
int ReferenceRow;

  ReferenceRow = 0;

  while (*Error == 0 && ReferenceRow < Dimen - 1) {
	  ReferenceRow++;
	  if (fabs(Coefficients[ReferenceRow-1][ReferenceRow-1]) < TNNearlyZero) {
		  Pivot(Dimen, ReferenceRow, Coefficients, Constants, Error);
	  }
	  if (*Error != 0)
		  break;
	  for (Row = ReferenceRow; Row < Dimen; Row++) {
		  if (fabs(Coefficients[Row][ReferenceRow-1]) > TNNearlyZero) {
			  Multiplier = -(Coefficients[Row][ReferenceRow-1] / Coefficients[ReferenceRow-1][ReferenceRow-1]);
			  EROmultAdd(Multiplier, Dimen, Coefficients[ReferenceRow-1], Coefficients[Row]);
			  Constants[Row] += Multiplier * Constants[ReferenceRow-1];
		  }
	  } // Row
  } // while
  if (fabs(Coefficients[Dimen-1][Dimen-1]) < TNNearlyZero) {
	  *Error = 2;
  }
} // UpperTriangular

void
BackwardsSub(int Dimen, TNvector *Coefficients, double *Constants, double *Solution) {
int Term;
int Row;
double Sum;

  Term = Dimen;
  while (Term >= 1) {
	  Sum = 0.0;
	  for (Row = Term; Row < Dimen; Row++) {
		  Sum += Coefficients[Term-1][Row] * Solution[Row];
	  }
	  Solution[Term-1] = (Constants[Term-1] - Sum) / Coefficients[Term-1]
		       [Term-1];
	  Term--;
  }
} // BackwardsSub


void
GaussianElimination(int Dimen, TNvector *Coefficients, double *Constants, double *Solution, int *Error) {
  Initial (Dimen, Coefficients, Constants, Solution, Error);
  if (Dimen <= 1) return;
  UpperTriangular (Dimen, Coefficients, Constants, Error);
  if (*Error == 0)
	  BackwardsSub (Dimen, Coefficients, Constants, Solution);
} // GaussianElimination

// Regression calculation functions

extern void
ResetRegr (int Params, int DataSource) {
  Chrom[DataSource].RegrParam.RegrAParam = 0;
  Chrom[DataSource].RegrParam.RegrBParam = 0;
  Chrom[DataSource].RegrParam.RegrCParam = 0;
  Chrom[DataSource].RegrParam.RegrRParam = 0;

  Chrom[DataSource].RegrParam.RegrParams = 0;
  if ((Params>0) && (Params <= MaxRegrParam))
     Chrom[DataSource].RegrParam.RegrParams = Params;

  Chrom[DataSource].RegrParam.RegrN = 0;
  Chrom[DataSource].RegrParam.RegrSumX = 0;
  Chrom[DataSource].RegrParam.RegrSumX2 = 0;
  Chrom[DataSource].RegrParam.RegrSumY = 0;
  Chrom[DataSource].RegrParam.RegrSumY2 = 0;
  Chrom[DataSource].RegrParam.RegrSumXY = 0;

  Chrom[DataSource].RegrParam.RegrCorrX = 1.0;
  Chrom[DataSource].RegrParam.RegrCorrY = 1.0;

  Chrom[DataSource].RegrParam.RegrOk = FALSE;
} // ResetRegr

extern void
AddRegr (double XData, double YData, int DataSource) {
  if (Chrom[DataSource].RegrParam.RegrParams == 0) return;
  if (Chrom[DataSource].RegrParam.RegrCorrX == 0) return;
  if (Chrom[DataSource].RegrParam.RegrCorrY == 0) return;

  Chrom[DataSource].RegrParam.RegrN++;
  Chrom[DataSource].RegrParam.RegrSumX += XData/Chrom[DataSource].RegrParam.RegrCorrX;
  Chrom[DataSource].RegrParam.RegrSumX2 += (XData/Chrom[DataSource].RegrParam.RegrCorrX) * (XData/Chrom[DataSource].RegrParam.RegrCorrX);
  Chrom[DataSource].RegrParam.RegrSumY += YData/Chrom[DataSource].RegrParam.RegrCorrY;
  Chrom[DataSource].RegrParam.RegrSumY2 += (YData/Chrom[DataSource].RegrParam.RegrCorrY) * (YData/Chrom[DataSource].RegrParam.RegrCorrY);
  Chrom[DataSource].RegrParam.RegrSumXY += XData/Chrom[DataSource].RegrParam.RegrCorrX*YData/Chrom[DataSource].RegrParam.RegrCorrY;
} // AddRegr

void
RegrCoeff (int DataSource) {
double D1, D2, D3;

  D1 = Chrom[DataSource].RegrParam.RegrSumX2*Chrom[DataSource].RegrParam.RegrN-(Chrom[DataSource].RegrParam.RegrSumX*Chrom[DataSource].RegrParam.RegrSumX);
  D2 = Chrom[DataSource].RegrParam.RegrSumY2*Chrom[DataSource].RegrParam.RegrN-(Chrom[DataSource].RegrParam.RegrSumY*Chrom[DataSource].RegrParam.RegrSumY);
  D3 = Chrom[DataSource].RegrParam.RegrSumXY*Chrom[DataSource].RegrParam.RegrN-Chrom[DataSource].RegrParam.RegrSumX*Chrom[DataSource].RegrParam.RegrSumY;
  if (D1 == 0) return;
  if (D2 == 0) return;
  if (D1*D2 <= 0) return;
  Chrom[DataSource].RegrParam.RegrRParam = D3/sqrt(D1*D2);
} // RegrCoeff

extern void
CalculateRegr (int DataSource) {
  if (Chrom[DataSource].RegrParam.RegrParams == 0) return;
  if (Chrom[DataSource].RegrParam.RegrCorrX == 0) return;
  if (Chrom[DataSource].RegrParam.RegrCorrY == 0) return;

  switch (Chrom[DataSource].RegrParam.RegrParams) {
	  case 1:
		  if (Chrom[DataSource].RegrParam.RegrN < 1) return;
		  if (Chrom[DataSource].RegrParam.RegrSumX2 == 0) return;
		  Chrom[DataSource].RegrParam.RegrAParam = Chrom[DataSource].RegrParam.RegrSumXY/Chrom[DataSource].RegrParam.RegrSumX2*Chrom[DataSource].RegrParam.RegrCorrY/Chrom[DataSource].RegrParam.RegrCorrX;
		  RegrCoeff (DataSource);
		  break;
	  case 2:
		  if (Chrom[DataSource].RegrParam.RegrN < 2) return;
		  Chrom[DataSource].RegrParam.GaussDim = 2;
		  Chrom[DataSource].RegrParam.GaussCoeff[1][1] = Chrom[DataSource].RegrParam.RegrSumX2;
		  Chrom[DataSource].RegrParam.GaussCoeff[1][2] = Chrom[DataSource].RegrParam.RegrSumX;
		  Chrom[DataSource].RegrParam.GaussCoeff[2][1] = Chrom[DataSource].RegrParam.RegrSumX;
		  Chrom[DataSource].RegrParam.GaussCoeff[2][2] = Chrom[DataSource].RegrParam.RegrN;
		  Chrom[DataSource].RegrParam.GaussConst[1] = Chrom[DataSource].RegrParam.RegrSumXY;
		  Chrom[DataSource].RegrParam.GaussConst[2] = Chrom[DataSource].RegrParam.RegrSumY;
		  GaussianElimination(Chrom[DataSource].RegrParam.GaussDim, (TNvector *)&Chrom[DataSource].RegrParam.GaussCoeff, (double *)&Chrom[DataSource].RegrParam.GaussConst, (double *)&Chrom[DataSource].RegrParam.GaussSolut, &Chrom[DataSource].RegrParam.GaussError);
		  if (Chrom[DataSource].RegrParam.GaussError == 0) {
			  Chrom[DataSource].RegrParam.RegrAParam = Chrom[DataSource].RegrParam.GaussSolut[1]*Chrom[DataSource].RegrParam.RegrCorrY/Chrom[DataSource].RegrParam.RegrCorrX;
			  Chrom[DataSource].RegrParam.RegrBParam = Chrom[DataSource].RegrParam.GaussSolut[2]*Chrom[DataSource].RegrParam.RegrCorrY;
			  RegrCoeff (DataSource);
		  } // GaussError == 0
		  break;
  } // switch RegrParams

  Chrom[DataSource].RegrParam.RegrOk = TRUE;
} // CalculateRegr

// ***
// Calibration
// ***

extern void
CalibrationModified (int DataSource) {
  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;
  Chrom[DataSource].FileSaved[CalFlag] = FALSE;
  if (Chrom[DataSource].CalibrHead->SaveCalibrAfterMod)
	  CalibrSave (DataSource, Chrom[DataSource].CalName);
} // CalibrationModified

// Component functions

extern void
GetComponent (int Idx, int DataSource) {
int i;
struct CalibrComponentStruct *CompA;

  NewComponent (DataSource);
  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->ComponentNum) return;

  CompA = Chrom[DataSource].CalibrComponentArray;
  memcpy (Chrom[DataSource].CalibrComponent, &CompA[Idx], sizeof (struct CalibrComponentStruct));
} // GetComponent

extern void
SetComponent (int Idx, int DataSource) {
int i;
struct CalibrComponentStruct *CompA;

  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->ComponentNum) return;

  CompA = Chrom[DataSource].CalibrComponentArray;
  memcpy (&CompA[Idx], Chrom[DataSource].CalibrComponent, sizeof (struct CalibrComponentStruct));
} // SetComponent

extern void
NewComponent (int DataSource) {
  bzero (Chrom[DataSource].CalibrComponent, sizeof (struct CalibrComponentStruct));
} // NewComponent

extern void
AddComponent (int DataSource) {
struct CalibrComponentStruct *CompA;
int i;

  ReallocCalibrComponentData (Chrom[DataSource].CalibrHead->ComponentNum + 1, DataSource);
  CompA = Chrom[DataSource].CalibrComponentArray;
  Chrom[DataSource].CalibrHead->ComponentInternalNum++;
  Chrom[DataSource].CalibrComponent->ComponentInternalNum = Chrom[DataSource].CalibrHead->ComponentInternalNum;
  memcpy (&CompA[Chrom[DataSource].CalibrHead->ComponentNum], Chrom[DataSource].CalibrComponent, sizeof (struct CalibrComponentStruct));
  Chrom[DataSource].CalibrHead->ComponentNum++;
  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum; i++) {
	  GetLevel (i, DataSource);
	  AddConc (Chrom[DataSource].CalibrComponent->ComponentInternalNum, \
			   Chrom[DataSource].CalibrLevel->LevelInternalNum, DataSource);
  } // i
} // AddComponent

extern void
DelComponent (int Idx, int DataSource) {
struct CalibrComponentStruct *CompA;
gboolean CompFound;
int i;

  BT_INIT();

  if (Idx < 0) return;
  if (Chrom[DataSource].CalibrHead->ComponentNum < 1) return;

  CompA = Chrom[DataSource].CalibrComponentArray;

  DelConc (Idx, -1, DataSource);
  DelCellByComp (Idx, DataSource);

  CompFound = FALSE;
  GetComponent (Idx, DataSource);
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum - 1; i++) {
	  if (Chrom[DataSource].CalibrComponent->ComponentInternalNum == CompA[i].ComponentInternalNum)
		  CompFound = TRUE;
	  if (CompFound)
		  memcpy (&CompA[i], &CompA[i + 1], sizeof (struct CalibrComponentStruct));
  } // i
  i = Chrom[DataSource].CalibrHead->ComponentNum - 1;
  if (Chrom[DataSource].CalibrComponent->ComponentInternalNum == CompA[i].ComponentInternalNum)
	  CompFound = TRUE;

  if (CompFound)
	  Chrom[DataSource].CalibrHead->ComponentNum--;
} // DelComponent

// Level functions

extern void
GetLevel (int Idx, int DataSource) {
int i;
struct CalibrLevelStruct *LevA;

  NewLevel (DataSource);
  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->LevelNum) return;

  LevA = Chrom[DataSource].CalibrLevelArray;
  memcpy (Chrom[DataSource].CalibrLevel, &LevA[Idx], sizeof (struct CalibrLevelStruct));
} // GetLevel

extern void
SetLevel (int Idx, int DataSource) {
int i;
struct CalibrLevelStruct *LevA;

  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->LevelNum) return;

  LevA = Chrom[DataSource].CalibrLevelArray;
  memcpy (&LevA[Idx], Chrom[DataSource].CalibrLevel, sizeof (struct CalibrLevelStruct));
} // SetLevel

extern void
NewLevel (int DataSource) {
  bzero (Chrom[DataSource].CalibrLevel, sizeof (struct CalibrLevelStruct));
} // NewLevel

extern void
AddLevel (int DataSource) {
struct CalibrLevelStruct *LevA;
int i;

  ReallocCalibrLevelData (Chrom[DataSource].CalibrHead->LevelNum + 1, DataSource);
  LevA = Chrom[DataSource].CalibrLevelArray;
  Chrom[DataSource].CalibrHead->LevelInternalNum++;
  Chrom[DataSource].CalibrLevel->LevelInternalNum = Chrom[DataSource].CalibrHead->LevelInternalNum;
  memcpy (&LevA[Chrom[DataSource].CalibrHead->LevelNum], Chrom[DataSource].CalibrLevel, sizeof (struct CalibrLevelStruct));
  Chrom[DataSource].CalibrHead->LevelNum++;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  GetComponent (i, DataSource);
	  AddConc (Chrom[DataSource].CalibrComponent->ComponentInternalNum, \
			   Chrom[DataSource].CalibrLevel->LevelInternalNum, DataSource);
  } // i
} // AddLevel

extern void
DelLevel (int Idx, int DataSource) {
struct CalibrLevelStruct *LevA;
gboolean LevelFound;
int i;

  BT_INIT();

  if (Idx < 0) return;
  if (Chrom[DataSource].CalibrHead->LevelNum < 1) return;

  LevA = Chrom[DataSource].CalibrLevelArray;

  DelConc (-1, Idx, DataSource);
  DelCellByLevel (Idx, DataSource);

  LevelFound = FALSE;
  GetLevel (Idx, DataSource);
  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum - 1; i++) {
	  if (Chrom[DataSource].CalibrLevel->LevelInternalNum == LevA[i].LevelInternalNum)
		  LevelFound = TRUE;
	  if (LevelFound)
		  memcpy (&LevA[i], &LevA[i + 1], sizeof (struct CalibrLevelStruct));
  } // i
  i = Chrom[DataSource].CalibrHead->LevelNum - 1;
  if (Chrom[DataSource].CalibrLevel->LevelInternalNum == LevA[i].LevelInternalNum)
	  LevelFound = TRUE;

  if (LevelFound)
	  Chrom[DataSource].CalibrHead->LevelNum--;
} // DelLevel

// Chromatogram functions

extern void
GetChrom (int LevelIdx, int ChromIdx, int DataSource) {
int i;
int i_num;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;

  NewChrom (DataSource);
  if (LevelIdx < 0) return;
  if (LevelIdx >= Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return;
  if (ChromIdx >= Chrom[DataSource].CalibrHead->ChromNum) return;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  memcpy (Chrom[DataSource].CalibrChrom, &ChromA[i], sizeof (struct CalibrChromStruct));
		  i_num++;
	  }
} // GetChrom

extern void
SetChrom (int LevelIdx, int ChromIdx, int DataSource) {
int i;
int i_num;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;

  if (LevelIdx < 0) return;
  if (LevelIdx >= Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return;
  if (ChromIdx >= Chrom[DataSource].CalibrHead->ChromNum) return;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  memcpy (&ChromA[i], Chrom[DataSource].CalibrChrom, sizeof (struct CalibrChromStruct));
		  i_num++;
	  }
} // SetChrom

extern void
NewChrom (int DataSource) {
  bzero (Chrom[DataSource].CalibrChrom, sizeof (struct CalibrChromStruct));
} // NewChrom

extern void
AddChrom (int LevelIdx, int DataSource) {
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;

  if (LevelIdx < 0) return;
  if (LevelIdx >= Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  Chrom[DataSource].CalibrChrom->LevelInternalNum = LevA[LevelIdx].LevelInternalNum;
  Chrom[DataSource].CalibrHead->ChromInternalNum++;
  Chrom[DataSource].CalibrChrom->ChromInternalNum = Chrom[DataSource].CalibrHead->ChromInternalNum;
  ReallocCalibrChromData (Chrom[DataSource].CalibrHead->ChromNum + 1, DataSource);
  ChromA = Chrom[DataSource].CalibrChromArray;
  memcpy (&ChromA[Chrom[DataSource].CalibrHead->ChromNum], Chrom[DataSource].CalibrChrom, sizeof (struct CalibrChromStruct));
  Chrom[DataSource].CalibrHead->ChromNum++;
  LevA[LevelIdx].ChromNum++;
} // AddChrom

extern void
DelChrom (int LevelIdx, int ChromIdx, int DataSource) {
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;
gboolean ChromFound;
int i;

  BT_INIT();

  if (LevelIdx < 0) return;
  if (LevelIdx >= Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return;
  if (ChromIdx >= Chrom[DataSource].CalibrHead->ChromNum) return;
  if (Chrom[DataSource].CalibrHead->ChromNum < 1) return;
  if (ChromIdx >= LevA[LevelIdx].ChromNum) return;
  if (LevA[LevelIdx].ChromNum < 1) return;

  DelCellByChrom (LevelIdx, ChromIdx, DataSource);

  GetChrom (LevelIdx, ChromIdx, DataSource);
  ChromA = Chrom[DataSource].CalibrChromArray;
  ChromFound = FALSE;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum - 1; i++) {
	  if (Chrom[DataSource].CalibrChrom->ChromInternalNum == ChromA[i].ChromInternalNum)
		  ChromFound = TRUE;
	  if (ChromFound)
		  memcpy (&ChromA[i], &ChromA[i + 1], sizeof (struct CalibrChromStruct));
  } // i
  i = Chrom[DataSource].CalibrHead->ChromNum - 1;
  if (Chrom[DataSource].CalibrChrom->ChromInternalNum == ChromA[i].ChromInternalNum)
	  ChromFound = TRUE;

  if (ChromFound) {
	  Chrom[DataSource].CalibrHead->ChromNum--;
	  LevA[LevelIdx].ChromNum--;
  }
} // DelChrom

// Concentration functions

extern void
GetConcByIdx (int Idx, int DataSource) {
struct CalibrConcStruct *ConcA;

  NewConc (DataSource);
  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->ConcNum) return;
  ConcA = Chrom[DataSource].CalibrConcArray;
  memcpy (Chrom[DataSource].CalibrConc, &ConcA[Idx], sizeof (struct CalibrConcStruct));
} // GetConcByIdx

extern int
GetConc (int CompIdx, int LevelIdx, int DataSource) {
int i;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrConcStruct *ConcA;
int RetVal;

  RetVal = -1;
  NewConc (DataSource);
  if (CompIdx < 0) return RetVal;
  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return RetVal;
  CompA = Chrom[DataSource].CalibrComponentArray;
  if (LevelIdx < 0) return RetVal;
  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return RetVal;
  LevA = Chrom[DataSource].CalibrLevelArray;
  ConcA = Chrom[DataSource].CalibrConcArray;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ConcNum; i++)
	  if ((LevA[LevelIdx].LevelInternalNum == ConcA[i].LevelInternalNum) && \
		  (CompA[CompIdx].ComponentInternalNum == ConcA[i].CompInternalNum)) {
			  RetVal = i;
			  memcpy (Chrom[DataSource].CalibrConc, &ConcA[i], sizeof (struct CalibrConcStruct));
		  }
  return RetVal;
} // GetConc

extern void
SetConc (int CompIdx, int LevelIdx, int DataSource) {
int i;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrConcStruct *ConcA;

  if (CompIdx < 0) return;
  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return;
  CompA = Chrom[DataSource].CalibrComponentArray;
  if (LevelIdx < 0) return;
  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  ConcA = Chrom[DataSource].CalibrConcArray;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ConcNum; i++)
	  if ((LevA[LevelIdx].LevelInternalNum == ConcA[i].LevelInternalNum) && \
		  (CompA[CompIdx].ComponentInternalNum == ConcA[i].CompInternalNum))
		  memcpy (&ConcA[i], Chrom[DataSource].CalibrConc, sizeof (struct CalibrConcStruct));
} // SetConc

extern void
NewConc (int DataSource) {
  bzero (Chrom[DataSource].CalibrConc, sizeof (struct CalibrConcStruct));
} // NewConc

extern void
AddConc (int CompInternalIdx, int LevelInternalIdx, int DataSource) {
struct CalibrConcStruct *ConcA;

  NewConc (DataSource);
  Chrom[DataSource].CalibrConc->CompInternalNum = CompInternalIdx;
  Chrom[DataSource].CalibrConc->LevelInternalNum = LevelInternalIdx;
  ReallocCalibrConcData (Chrom[DataSource].CalibrHead->ConcNum + 1, DataSource);
  ConcA = Chrom[DataSource].CalibrConcArray;
  memcpy (&ConcA[Chrom[DataSource].CalibrHead->ConcNum], Chrom[DataSource].CalibrConc, sizeof (struct CalibrConcStruct));
  Chrom[DataSource].CalibrHead->ConcNum++;
} // AddConc

extern void
DelConc (int CompIdx, int LevelIdx, int DataSource) {
int i, j;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrConcStruct *ConcA;
gboolean CompFound;
gboolean LevelFound;

BT_INIT();

  ConcA = Chrom[DataSource].CalibrConcArray;

  if (CompIdx > -1) {
	  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return;
	  CompA = Chrom[DataSource].CalibrComponentArray;
	  for (i = 0; i < Chrom[DataSource].CalibrHead->ConcNum; i++) {
		  CompFound = FALSE;
		  if (CompA[CompIdx].ComponentInternalNum == ConcA[i].CompInternalNum)
			  CompFound = TRUE;
		  while (CompFound) {
			  for (j = i; j < Chrom[DataSource].CalibrHead->ConcNum - 1; j++)
				  memcpy (&ConcA[j], &ConcA[j + 1], sizeof (struct CalibrConcStruct));
			  bzero (&ConcA[Chrom[DataSource].CalibrHead->ConcNum - 1], sizeof (struct CalibrConcStruct));
			  CompFound = FALSE;
			  if (CompA[CompIdx].ComponentInternalNum == ConcA[i].CompInternalNum)
				  CompFound = TRUE;
		  } // while
	  } // i
	  if (Chrom[DataSource].CalibrHead->ConcNum >= Chrom[DataSource].CalibrHead->ComponentNum)
		  Chrom[DataSource].CalibrHead->ConcNum -= Chrom[DataSource].CalibrHead->ComponentNum;
	  else {
		  sprintf (BugTraceUserString, "DataSource = %d, ConcNum = %d, , ComponentNum = %d, Filename = %s", \
				   DataSource, Chrom[DataSource].CalibrHead->ConcNum, \
				   Chrom[DataSource].CalibrHead->ComponentNum, \
				   Chrom[DataSource].CalName);
		  BUGTRACE(BugTraceUserString);
	  }
  } // CompIdx > -1

  if (LevelIdx > -1) {
	  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return;
	  LevA = Chrom[DataSource].CalibrLevelArray;
	  for (i = 0; i < Chrom[DataSource].CalibrHead->ConcNum; i++) {
		  LevelFound = FALSE;
		  if (LevA[LevelIdx].LevelInternalNum == ConcA[i].LevelInternalNum)
			  LevelFound = TRUE;
		  while (LevelFound) {
			  for (j = i; j < Chrom[DataSource].CalibrHead->ConcNum - 1; j++)
				  memcpy (&ConcA[j], &ConcA[j + 1], sizeof (struct CalibrConcStruct));
			  bzero (&ConcA[Chrom[DataSource].CalibrHead->ConcNum - 1], sizeof (struct CalibrConcStruct));
			  LevelFound = FALSE;
			  if (LevA[LevelIdx].LevelInternalNum == ConcA[i].LevelInternalNum)
				  LevelFound = TRUE;
		  } // while
	  } // i
	  if (Chrom[DataSource].CalibrHead->ConcNum >= Chrom[DataSource].CalibrHead->LevelNum)
		  Chrom[DataSource].CalibrHead->ConcNum -= Chrom[DataSource].CalibrHead->LevelNum;
	  else {
		  sprintf (BugTraceUserString, "DataSource = %d, ConcNum = %d, , LevelNum = %d, Filename = %s", \
				   DataSource, Chrom[DataSource].CalibrHead->ConcNum, \
				   Chrom[DataSource].CalibrHead->LevelNum, \
				   Chrom[DataSource].CalName);
		  BUGTRACE(BugTraceUserString);
	  }
  } // LevelIdx > -1
} // DelConc

// Cell functions

extern void
GetCellByIdx (int Idx, int DataSource) {
struct CalibrCellStruct *CellA;

  NewCell (DataSource);
  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->CellNum) return;

  CellA = Chrom[DataSource].CalibrCellArray;
  memcpy (Chrom[DataSource].CalibrCell, &CellA[Idx], sizeof (struct CalibrCellStruct));
} // GetCellByIdx

extern void
SetCellByIdx (int Idx, int DataSource) {
struct CalibrCellStruct *CellA;

  if (Idx < 0) return;
  if (Idx >= Chrom[DataSource].CalibrHead->CellNum) return;

  CellA = Chrom[DataSource].CalibrCellArray;
  memcpy (&CellA[Idx], Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
} // SetCellByIdx

extern int
GetCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource) {
int i;
int i_num, ChromFoundIdx;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;
struct CalibrCellStruct *CellA;
gboolean CellFound;
int RetVal;

  RetVal = -1;
  if (CompIdx < 0) return RetVal;
  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return RetVal;
  CompA = Chrom[DataSource].CalibrComponentArray;
  if (LevelIdx < 0) return RetVal;
  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return RetVal;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return RetVal;
  if (ChromIdx > LevA[LevelIdx].ChromNum) return RetVal;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  ChromFoundIdx = -1;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  ChromFoundIdx = i;
		  i_num++;
	  }
  CellFound = FALSE;
  CellA = Chrom[DataSource].CalibrCellArray;
  if (ChromFoundIdx > -1) {
	  for (i = 0; i < Chrom[DataSource].CalibrHead->CellNum; i++)
		  if ((LevA[LevelIdx].LevelInternalNum == CellA[i].LevelInternalNum) && \
			  (CompA[CompIdx].ComponentInternalNum == CellA[i].CompInternalNum) && \
			  (ChromA[ChromFoundIdx].ChromInternalNum == CellA[i].ChromInternalNum)) {
			  CellFound = TRUE;
			  RetVal = i;
			  memcpy (Chrom[DataSource].CalibrCell, &CellA[i], sizeof (struct CalibrCellStruct));
		  }
	  if (!CellFound)
		  AddCellByIdx (CompIdx, LevelIdx, ChromIdx, DataSource);
	  } // ChromFoundIdx > -1
  return (RetVal);
} // GetCell

gboolean
GetIstCell (int IstIdx, int LevelIdx, int ChromIdx, int DataSource) {
int i;
int CompIdx;
int i_num, ChromFoundIdx;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;
struct CalibrCellStruct *CellA;
gboolean CellFound;

  if (IstIdx == 0) return FALSE;

  printf ("      IstIdx = %d, LevelIdx = %d, ChromIdx = %d\n", IstIdx, LevelIdx, ChromIdx);
  if (LevelIdx < 0) return FALSE;
  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return FALSE;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return FALSE;
  if (ChromIdx > LevA[LevelIdx].ChromNum) return FALSE;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  ChromFoundIdx = -1;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  ChromFoundIdx = i;
		  i_num++;
	  }
  CellFound = FALSE;
  NewCell (DataSource);
  CompA = Chrom[DataSource].CalibrComponentArray;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  if (CompA[i].IstIdNum == IstIdx) {
		  CellFound = TRUE;
		  GetCell (i, LevelIdx, ChromIdx, DataSource);
		  memcpy (Chrom[DataSource].CalibrIstCell, Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
		  printf ("      Found.\n");
	  } // CellFound
  } // i
  return CellFound;
} // GetIstCell

extern void
SetCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource) {
int i;
int i_num, ChromFoundIdx;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;
struct CalibrCellStruct *CellA;
gboolean CellFound;

  if (CompIdx < 0) return;
  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return;
  CompA = Chrom[DataSource].CalibrComponentArray;
  if (LevelIdx < 0) return;
  if (LevelIdx > Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return;
  if (ChromIdx > LevA[LevelIdx].ChromNum) return;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  ChromFoundIdx = -1;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  ChromFoundIdx = i;
		  i_num++;
	  }
  CellFound = FALSE;
  CellA = Chrom[DataSource].CalibrCellArray;
  if (ChromFoundIdx > -1) {
	  for (i = 0; i < Chrom[DataSource].CalibrHead->CellNum; i++)
		  if ((LevA[LevelIdx].LevelInternalNum == CellA[i].LevelInternalNum) && \
			  (CompA[CompIdx].ComponentInternalNum == CellA[i].CompInternalNum) && \
			  (ChromA[ChromFoundIdx].ChromInternalNum == CellA[i].ChromInternalNum)) {
			  CellFound = TRUE;
			  memcpy (&CellA[i], Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
		  } // if
	  } // ChromFoundIdx > -1
  if (CellFound) return;
  printf ("@@@ Cell not found in SetCell\n");
} // SetCell

extern void
NewCell (int DataSource) {
  bzero (Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
} // NewCell

extern void
AddCell (int DataSource) {
struct CalibrCellStruct *CellA;

  ReallocCalibrCellData (Chrom[DataSource].CalibrHead->CellNum + 1, DataSource);
  CellA = Chrom[DataSource].CalibrCellArray;
  memcpy (&CellA[Chrom[DataSource].CalibrHead->CellNum], Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
  Chrom[DataSource].CalibrHead->CellNum++;
} // AddCell

extern void
AddCellByIdx (int CompIdx, int LevelIdx, int ChromIdx, int DataSource) {
int i, i_num, ChromFoundIdx;
struct CalibrComponentStruct *CompA;
struct CalibrLevelStruct *LevA;
struct CalibrChromStruct *ChromA;
struct CalibrCellStruct *CellA;

  if (CompIdx < 0) return;
  if (CompIdx >= Chrom[DataSource].CalibrHead->ComponentNum) return;
  CompA = Chrom[DataSource].CalibrComponentArray;
  if (LevelIdx < 0) return;
  if (LevelIdx >= Chrom[DataSource].CalibrHead->LevelNum) return;
  LevA = Chrom[DataSource].CalibrLevelArray;
  if (ChromIdx < 0) return;
  if (ChromIdx >= LevA[LevelIdx].ChromNum) return;
  ChromA = Chrom[DataSource].CalibrChromArray;
  i_num = 0;
  ChromFoundIdx = -1;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ChromNum; i++)
	  if (LevA[LevelIdx].LevelInternalNum == ChromA[i].LevelInternalNum) {
		  if (ChromIdx == i_num)
			  ChromFoundIdx = i;
		  i_num++;
	  }
  if (ChromFoundIdx < 0) return;

  ReallocCalibrCellData (Chrom[DataSource].CalibrHead->CellNum + 1, DataSource);
  CellA = Chrom[DataSource].CalibrCellArray;
  NewCell (DataSource);
  Chrom[DataSource].CalibrCell->Filled = FALSE;
  Chrom[DataSource].CalibrCell->CompInternalNum = CompA[CompIdx].ComponentInternalNum;
  Chrom[DataSource].CalibrCell->LevelInternalNum = LevA[LevelIdx].LevelInternalNum;
  Chrom[DataSource].CalibrCell->ChromInternalNum = ChromA[ChromFoundIdx].ChromInternalNum;
  memcpy (&CellA[Chrom[DataSource].CalibrHead->CellNum], Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
  Chrom[DataSource].CalibrHead->CellNum++;
} // AddCellByIdx

extern void
DelCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource) {


} // DelCell

extern void
DelCellByComp (int CompIdx, int DataSource) {
int i, j;
int CellDel;
gboolean CellFound;
struct CalibrCellStruct *CellA;

BT_INIT();

  CellDel = 0;
  CellA = Chrom[DataSource].CalibrCellArray;
  GetComponent (CompIdx, DataSource);
  for (i = 0; i < Chrom[DataSource].CalibrHead->CellNum; i++) {
		  CellFound = FALSE;
		  if (Chrom[DataSource].CalibrComponent->ComponentInternalNum == CellA[i].CompInternalNum)
			  CellFound = TRUE;
		  while (CellFound) {
			  CellDel++;
			  for (j = i; j < Chrom[DataSource].CalibrHead->CellNum - 1; j++)
				  memcpy (&CellA[j], &CellA[j + 1], sizeof (struct CalibrCellStruct));
			  bzero (&CellA[Chrom[DataSource].CalibrHead->CellNum - 1], sizeof (struct CalibrCellStruct));
			  CellFound = FALSE;
			  if (Chrom[DataSource].CalibrComponent->ComponentInternalNum == CellA[i].CompInternalNum)
				  CellFound = TRUE;
		  } // while
	  } // i
	  if (Chrom[DataSource].CalibrHead->CellNum >= CellDel)
		  Chrom[DataSource].CalibrHead->CellNum -= CellDel;
	  else {
		  sprintf (BugTraceUserString, "DataSource = %d, CellNum = %d, , CellDel = %d, Filename = %s", \
				   DataSource, Chrom[DataSource].CalibrHead->CellNum, \
				   CellDel, Chrom[DataSource].CalName);
		  BUGTRACE(BugTraceUserString);
	  }
} // DelCellByComp

extern void
DelCellByLevel (int LevelIdx, int DataSource) {
int i, j;
int CellDel;
gboolean CellFound;
struct CalibrCellStruct *CellA;

BT_INIT();

  CellDel = 0;
  CellA = Chrom[DataSource].CalibrCellArray;
  GetLevel (LevelIdx, DataSource);
  for (i = 0; i < Chrom[DataSource].CalibrHead->CellNum; i++) {
		  CellFound = FALSE;
		  if (Chrom[DataSource].CalibrLevel->LevelInternalNum == CellA[i].LevelInternalNum)
			  CellFound = TRUE;
		  while (CellFound) {
			  CellDel++;
			  for (j = i; j < Chrom[DataSource].CalibrHead->CellNum - 1; j++)
				  memcpy (&CellA[j], &CellA[j + 1], sizeof (struct CalibrCellStruct));
			  bzero (&CellA[Chrom[DataSource].CalibrHead->CellNum - 1], sizeof (struct CalibrCellStruct));
			  CellFound = FALSE;
			  if (Chrom[DataSource].CalibrLevel->LevelInternalNum == CellA[i].LevelInternalNum)
				  CellFound = TRUE;
		  } // while
	  } // i
	  if (Chrom[DataSource].CalibrHead->CellNum >= CellDel)
		  Chrom[DataSource].CalibrHead->CellNum -= CellDel;
	  else {
		  sprintf (BugTraceUserString, "DataSource = %d, CellNum = %d, , CellDel = %d, Filename = %s", \
				   DataSource, Chrom[DataSource].CalibrHead->CellNum, \
				   CellDel, Chrom[DataSource].CalName);
		  BUGTRACE(BugTraceUserString);
	  }
} // DelCellByLevel

extern void
DelCellByChrom (int LevelIdx, int ChromIdx, int DataSource) {
int i, j;
int CellDel;
gboolean CellFound;
struct CalibrCellStruct *CellA;

BT_INIT();

  CellDel = 0;
  CellA = Chrom[DataSource].CalibrCellArray;
  GetChrom (LevelIdx, ChromIdx, DataSource);
  for (i = 0; i < Chrom[DataSource].CalibrHead->CellNum; i++) {
		  CellFound = FALSE;
		  if (Chrom[DataSource].CalibrChrom->ChromInternalNum == CellA[i].ChromInternalNum)
			  CellFound = TRUE;
		  while (CellFound) {
			  CellDel++;
			  for (j = i; j < Chrom[DataSource].CalibrHead->CellNum - 1; j++)
				  memcpy (&CellA[j], &CellA[j + 1], sizeof (struct CalibrCellStruct));
			  bzero (&CellA[Chrom[DataSource].CalibrHead->CellNum - 1], sizeof (struct CalibrCellStruct));
			  CellFound = FALSE;
			  if (Chrom[DataSource].CalibrChrom->ChromInternalNum == CellA[i].ChromInternalNum)
				  CellFound = TRUE;
		  } // while
	  } // i
	  if (Chrom[DataSource].CalibrHead->CellNum >= CellDel)
		  Chrom[DataSource].CalibrHead->CellNum -= CellDel;
	  else {
		  sprintf (BugTraceUserString, "DataSource = %d, CellNum = %d, , CellDel = %d, Filename = %s", \
				   DataSource, Chrom[DataSource].CalibrHead->CellNum, \
				   CellDel, Chrom[DataSource].CalName);
		  BUGTRACE(BugTraceUserString);
	  }
} // DelCellByChrom

// Generic functions

extern int
FindIst (int IstIdNum, int DataSource) {
int FI;
int i;

  FI = -1;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  GetComponent (i, DataSource);
	  if (IstIdNum == Chrom[DataSource].CalibrComponent->IstIdNum)
		  FI = i;
  } // i

  return FI;
} // FindIst

extern void
RebuildIstId (int DataSource) {
int i;

  Chrom[DataSource].CalibrHead->IstNum = 0;
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  GetComponent (i, DataSource);
	  Chrom[DataSource].CalibrComponent->IstIdNum = 0;
	  if (Chrom[DataSource].CalibrComponent->IstFlag) {
		  Chrom[DataSource].CalibrHead->IstNum++;
		  Chrom[DataSource].CalibrComponent->IstIdNum = Chrom[DataSource].CalibrHead->IstNum;
	  } // if IstFlag
	  SetComponent (i, DataSource);
  } // i

} // RebuildIstId

extern void
RecalculateComponent (int CompIdx, int DataSource) {
int j;

  GetComponent (CompIdx, DataSource);
  switch (Chrom[DataSource].CalibrComponent->CurveType) {
	  case CalibrCurve1ParL:
	  case CalibrCurve1ParQ:
		  ResetRegr (1, DataSource);
		  if (Chrom[DataSource].CalibrComponent->ZeroOption)
			  AddRegr (0, 0, DataSource);
		  break;
	  case CalibrCurve2ParL:
	  case CalibrCurve2ParE:
		  ResetRegr (2, DataSource);
		  if (Chrom[DataSource].CalibrComponent->ZeroOption)
			  AddRegr (0, 0, DataSource);
		  break;
  } // switch CurveType

  for (j = 0; j < Chrom[DataSource].CalibrHead->LevelNum; j++) {
	  GetConc (CompIdx, j, DataSource);
	  switch (Chrom[DataSource].CalibrComponent->CurveType) {
		  case CalibrCurve1ParL:
			  if ((Chrom[DataSource].CalibrConc->Concentration != 0) &&
			  	  (Chrom[DataSource].CalibrConc->WorkValue != 0))
				  AddRegr (Chrom[DataSource].CalibrConc->Concentration*Chrom[DataSource].CalibrConc->ParameterEndResult,\
				    Chrom[DataSource].CalibrConc->WorkValue, DataSource);
			  break;
		  case CalibrCurve2ParL:
			  break;
		  case CalibrCurve2ParE:
			  break;
		  case CalibrCurve1ParQ:
			  if ((Chrom[DataSource].CalibrConc->Concentration != 0) && (Chrom[DataSource].CalibrConc->WorkValue > 0))
				  AddRegr (Chrom[DataSource].CalibrConc->Concentration, sqrt(Chrom[DataSource].CalibrConc->WorkValue), DataSource);
			  break;
	  } // switch CurveType
  } // j

  CalculateRegr (DataSource);
  if (Chrom[DataSource].RegrParam.RegrOk) {
	  Chrom[DataSource].CalibrComponent->AParam = Chrom[DataSource].RegrParam.RegrAParam;
	  Chrom[DataSource].CalibrComponent->BParam = Chrom[DataSource].RegrParam.RegrBParam;
	  Chrom[DataSource].CalibrComponent->CParam = Chrom[DataSource].RegrParam.RegrCParam;
	  Chrom[DataSource].CalibrComponent->RParam = Chrom[DataSource].RegrParam.RegrRParam;
	  printf ("AParam = %.3f\n", Chrom[DataSource].CalibrComponent->AParam);
	  printf ("BParam = %.3f\n", Chrom[DataSource].CalibrComponent->BParam);
	  printf ("CParam = %.3f\n", Chrom[DataSource].CalibrComponent->CParam);
	  printf ("RParam = %.3f\n", Chrom[DataSource].CalibrComponent->RParam);
  } // 

  SetComponent (CompIdx, DataSource);
} // RecalculateComponent

extern void
RecalculateCalibr (int DataSource) {
int i,j,k,l;
double IstWorkValArea;
double IstWorkValHeight;
int ConcIdx;

  printf ("\n-----------------------------------\n");
  printf ("RecalculateCalibr, ComponentNum = %d\n", Chrom[DataSource].CalibrHead->ComponentNum);
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  GetComponent (i, DataSource);
	  printf ("\nComponentNum = %d\n", i);
	  printf ("ComponentName = %s\n", Chrom[DataSource].CalibrComponent->ComponentName);
	  printf ("ComponentInternalNum = %d\n", Chrom[DataSource].CalibrComponent->ComponentInternalNum);
	  printf ("PeakRet = %.3f\n", Chrom[DataSource].CalibrComponent->PeakRet);
	  printf ("IstFlag = %d\n", Chrom[DataSource].CalibrComponent->IstFlag);
	  printf ("IstIdNum = %d\n", Chrom[DataSource].CalibrComponent->IstIdNum);
	  printf ("AssignIst = %d\n", Chrom[DataSource].CalibrComponent->AssignIst);
	  for (j = 0; j < Chrom[DataSource].CalibrHead->LevelNum; j++) {
		  printf ("   LevelNum = %d\n", j);
		  ConcIdx = GetConc (i, j, DataSource);
		  printf ("   ConcIdx = %d for Comp %d and Level %d\n", ConcIdx, i, j);
		  Chrom[DataSource].CalibrConc->WorkValue = 0;
		  Chrom[DataSource].CalibrConc->N = 0;
		  GetLevel (j, DataSource);
		  // !!! Check the gboolean variables
		  Chrom[DataSource].CalibrConc->ParameterEndResult = \
		  	Chrom[DataSource].CalibrLevel->Amount /\
		  	Chrom[DataSource].CalibrLevel->Volume *\
		  	Chrom[DataSource].CalibrLevel->Factor;
		  if (Chrom[DataSource].CalibrConc->ParameterEndResult <= 0)
		    Chrom[DataSource].CalibrConc->ParameterEndResult = 1;
		  printf ("   Concentration = %.3f\n", Chrom[DataSource].CalibrConc->Concentration);
		  for (k = 0; k < Chrom[DataSource].CalibrLevel->ChromNum; k++) {
			  printf ("      ChromNum = %d\n", k);
			  GetCell (i, j, k, DataSource);
			  printf ("      CalibrCell->Integral = %.3f\n", Chrom[DataSource].CalibrCell->Integral);
			  printf ("      CalibrCell->Height = %.3f\n", Chrom[DataSource].CalibrCell->Height);
			  //printf ("      \n", );
			  IstWorkValArea = 1;
			  IstWorkValHeight = 1;
			  printf ("      Trying to find IST cell...\n");
			  if (GetIstCell (Chrom[DataSource].CalibrComponent->AssignIst, j, k, DataSource)) {
				  GetComponent (i, DataSource);
				  GetCell (i, j, k, DataSource);
				  printf ("      Found IST cell.\n");
				  IstWorkValArea = Chrom[DataSource].CalibrIstCell->Integral;
				  printf ("      IstWorkValArea = %.3f\n", IstWorkValArea);
				  if (IstWorkValArea == 0)
					  IstWorkValArea = 1;
				  IstWorkValHeight = Chrom[DataSource].CalibrIstCell->Height;
				  printf ("      IstWorkValHeight= %.3f\n", IstWorkValHeight);
				  if (IstWorkValHeight == 0)
					  IstWorkValHeight = 1;
			  } // if GetIstCell
			  switch (Chrom[DataSource].CalibrComponent->AreaHeightBase) {
				  case CalibrAreaBase:
					  if (Chrom[DataSource].CalibrCell->Integral != 0) {
						  Chrom[DataSource].CalibrConc->WorkValue += Chrom[DataSource].CalibrCell->Integral / IstWorkValArea;
						  Chrom[DataSource].CalibrConc->N++;
					  } // != 0
					  break;
				  case CalibrHeightBase:
					  if (Chrom[DataSource].CalibrCell->Height != 0) {
						  Chrom[DataSource].CalibrConc->WorkValue += Chrom[DataSource].CalibrCell->Height / IstWorkValHeight;
						  Chrom[DataSource].CalibrConc->N++;
					  } // != 0
					  break;
			  } // swicth AreaHeightBase
		  } // k - ChromNum
		  if (Chrom[DataSource].CalibrConc->N != 0) {
			  Chrom[DataSource].CalibrConc->WorkValue /= Chrom[DataSource].CalibrConc->N;
		  } // N != 0
		  printf ("   ComponentName = %s\n", Chrom[DataSource].CalibrComponent->ComponentName);
		  printf ("   CalibrConc->N = %d\n", Chrom[DataSource].CalibrConc->N);
		  printf ("   CalibrConc->WorkValue = %.6f\n", Chrom[DataSource].CalibrConc->WorkValue);
		  printf ("   CalibrConc->ParameterEndResult = %.6f\n", Chrom[DataSource].CalibrConc->ParameterEndResult);
		  SetConc (i, j, DataSource);
	  } // j - LevelNum
  } // i - CompNum

  printf ("\nRecalculateComponent\n");
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  RecalculateComponent (i, DataSource);
  printf ("\n");
  } // i - CompNum
  printf ("-----------------------------------\n\n");
  CalibrationModified (DataSource);
} // RecalculateCalibr

gboolean
FindIstPeak (int IstCode, int DataSource) {
int i,k;
int PeakNum, StoreDet;
gboolean RetVal;
struct PeakStruct *PA;
BT_INIT();

  if (IstCode == 0) {
	  ResetIstPeak (DataSource);
	  printf ("Case of IstCode == 0\n");
	  return TRUE;
  } // IstCode == 0

  RetVal = FALSE;
  StoreDet = Chrom[DataSource].ActualDetector;

  for (k = 0; k < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; k++) {
	  Chrom[DataSource].ActualDetector = k;
	  PA = Chrom[DataSource].PeakArray[Chrom[DataSource].ActualDetector];
	  for (i = 0; i < Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector]; i++) {
		  if (IstCode == PA[i].PeakIsIst) {
			  memcpy (Chrom[DataSource].IstPeak, &PA[i], sizeof(struct PeakStruct));
			  RetVal = TRUE;
			  printf ("IstPeak.PeakIsIst = %d\n", PA[i].PeakIsIst);
			  printf ("IstPeak.AssignedToIst = %d\n", PA[i].AssignedToIst);
			  printf ("IstPeak.PeakComponent = %d\n", PA[i].PeakComponent);
			  printf ("IstPeak.PeakRetention = %.3f\n", PA[i].PeakRetention);
			  printf ("IstPeak.PeakArea = %.3f\n", PA[i].PeakArea);
			  printf ("IstPeak.PeakHeight = %.3f\n", PA[i].PeakHeight);
		  } // if
	  } // i
  } // k

  Chrom[DataSource].ActualDetector = StoreDet;
  if (!RetVal)
	  printf ("*** Ist peak not found!\n");
  return RetVal;
} // FindIstPeak

double
CalculateConc (int DataSource) {
double CCRet;
double WorkData; // Area/height

  CCRet = 0;

  switch (Chrom[DataSource].CalibrComponent->AreaHeightBase) {
	  case CalibrAreaBase:
		  printf ("Chrom[DataSource].Peak->PeakArea = %.3f\n", Chrom[DataSource].Peak->PeakArea);
		  printf ("Chrom[DataSource].IstPeak->PeakArea = %.3f\n", Chrom[DataSource].IstPeak->PeakArea);
		  WorkData = Chrom[DataSource].Peak->PeakArea;
		  if (Chrom[DataSource].IstPeak->PeakArea != 0)
			  WorkData /= Chrom[DataSource].IstPeak->PeakArea;
		  printf ("WorkData = %.3f\n", WorkData);
		  break;
	  case CalibrHeightBase:
		  WorkData = Chrom[DataSource].Peak->PeakHeight;
		  if (Chrom[DataSource].IstPeak->PeakHeight != 0)
			  WorkData /= Chrom[DataSource].IstPeak->PeakHeight;
		  break;
  } // swicth AreaHeightBase

  switch (Chrom[DataSource].CalibrComponent->CurveType) {
	  case CalibrCurve1ParL:
		  printf ("AParam = %.3f\n", Chrom[DataSource].CalibrComponent->AParam);
		  if (Chrom[DataSource].CalibrComponent->AParam != 0) {
			  CCRet = WorkData / Chrom[DataSource].CalibrComponent->AParam;
		  } // AParam != 0
		  break;
	  case CalibrCurve2ParL:
		  if (Chrom[DataSource].CalibrComponent->AParam != 0)
			  CCRet = (WorkData - Chrom[DataSource].CalibrComponent->BParam) / Chrom[DataSource].CalibrComponent->AParam;
		  break;
	  case CalibrCurve2ParE:
		  break;
	  case CalibrCurve1ParQ:
		  if ((Chrom[DataSource].CalibrComponent->AParam != 0) && (WorkData > 0))
			  CCRet = sqrt (WorkData) / Chrom[DataSource].CalibrComponent->AParam;
		  break;
  } // swicth CurveType
  
  if ((Chrom[DataSource].ChromHead->Method.MeasureParameters.Amount != 0) && 
  	  (Chrom[DataSource].ChromHead->Method.MeasureParameters.Factor != 0))
  	CCRet = CCRet / Chrom[DataSource].ChromHead->Method.MeasureParameters.Amount *\
  					Chrom[DataSource].ChromHead->Method.MeasureParameters.Volume /\
  					Chrom[DataSource].ChromHead->Method.MeasureParameters.Factor;

  return CCRet;
} // CalculateConc

void
IdentifyPeaks (int ChromDataSource, int CalibrDataSource) {
int StoreDet;
int i,j,k,l;
int CompLow, CompHigh, CompFinal;
double RetLow, RetHigh;

  if (!Chrom[ChromDataSource].FileLoaded[ChrFlag]) return;
  if (!Chrom[CalibrDataSource].FileLoaded[CalFlag]) return;

  StoreDet = Chrom[ChromDataSource].ActualDetector;
  for (k = 0; k < Chrom[ChromDataSource].ChromHead->Method.Instrument.NumDetectors; k++) {
	  Chrom[ChromDataSource].ActualDetector = k;
	  for (i = 0; i < Chrom[ChromDataSource].ChromHead->PeakHead.PeakNum[k]; i++) {
		  GetPeak (i, ChromDataSource);
		  CompLow = -1;
		  CompHigh = -1;
		  CompFinal = -1;
		  strcpy (Chrom[ChromDataSource].Peak->PeakName, "");
		  Chrom[ChromDataSource].Peak->PeakId = 0;
		  strcpy (Chrom[ChromDataSource].Peak->PeakIdStr, "");
		  Chrom[ChromDataSource].Peak->PeakIdentified = FALSE;
		  Chrom[ChromDataSource].Peak->PeakIsIst = 0;
		  Chrom[ChromDataSource].Peak->AssignedToIst = 0;
		  //Chrom[ChromDataSource].Peak->PeakComponent = 0;
		  Chrom[ChromDataSource].Peak->PeakComponent = -1;
		  Chrom[ChromDataSource].Peak->PeakConcLowerLimit = 0;
		  Chrom[ChromDataSource].Peak->PeakConcUpperLimit = 0;
		  Chrom[ChromDataSource].Peak->PeakConcExpectedValue = 0;
		  for (j = 0; j < Chrom[CalibrDataSource].CalibrHead->ComponentNum; j++) {
			  GetComponent (j, CalibrDataSource);
			  if (Chrom[CalibrDataSource].CalibrComponent->ComponentDetector == k) {
				  RetLow = Chrom[CalibrDataSource].CalibrComponent->PeakRet - Chrom[CalibrDataSource].CalibrComponent->LimitStatic;
				  RetHigh = Chrom[CalibrDataSource].CalibrComponent->PeakRet + Chrom[CalibrDataSource].CalibrComponent->LimitStatic;
				  if ((Chrom[ChromDataSource].Peak->PeakRetention > RetLow) && \
					  (Chrom[ChromDataSource].Peak->PeakRetention < RetHigh)) {
					  if (CompLow == -1) CompLow = j;
					  CompHigh = j;
					  CompFinal = j;
					  if (CompLow != CompHigh) {
					  } // CompLow != CompHigh
					  strcpy (Chrom[ChromDataSource].Peak->PeakName, Chrom[CalibrDataSource].CalibrComponent->ComponentName);
					  Chrom[ChromDataSource].Peak->PeakId = Chrom[CalibrDataSource].CalibrComponent->ComponentIdNum;
					  strcpy (Chrom[ChromDataSource].Peak->PeakIdStr, Chrom[CalibrDataSource].CalibrComponent->ComponentIdString);
					  Chrom[ChromDataSource].Peak->PeakIdentified = TRUE;
					  Chrom[ChromDataSource].Peak->PeakIsIst = Chrom[CalibrDataSource].CalibrComponent->IstIdNum;
					  Chrom[ChromDataSource].Peak->AssignedToIst = Chrom[CalibrDataSource].CalibrComponent->AssignIst;
					  //Chrom[ChromDataSource].Peak->PeakComponent = Chrom[CalibrDataSource].CalibrComponent->ComponentNum;
					  Chrom[ChromDataSource].Peak->PeakComponent = CompFinal;
					  Chrom[ChromDataSource].Peak->PeakConcLowerLimit = Chrom[CalibrDataSource].CalibrComponent->ComponentLowerLimit;
					  Chrom[ChromDataSource].Peak->PeakConcUpperLimit = Chrom[CalibrDataSource].CalibrComponent->ComponentUpperLimit;
					  Chrom[ChromDataSource].Peak->PeakConcExpectedValue = Chrom[CalibrDataSource].CalibrComponent->ComponentExpectedValue;
					  printf ("Chrom[ChromDataSource].Peak->PeakName = %s\n", Chrom[ChromDataSource].Peak->PeakName);
					  printf ("Chrom[ChromDataSource].Peak->PeakRetention = %.3f\n", Chrom[ChromDataSource].Peak->PeakRetention);
					  printf ("Chrom[CalibrDataSource].CalibrComponent->PeakRet = %.3f\n\n", Chrom[CalibrDataSource].CalibrComponent->PeakRet);
				  } // RetLow < PeakRetention < RetHigh
			  } // Detector == k
		  } // j
		  SetPeak (i, ChromDataSource);
	  } // i
  } // k
  Chrom[ChromDataSource].ActualDetector = StoreDet;
} // IdentifyPeaks

extern void
Analyze (int DataSource) {
int StoreDet;
int i,k;

  if (!Chrom[DataSource].FileLoaded[ChrFlag]) return;
  if (!Chrom[DataSource].FileLoaded[CalFlag]) return;
  strcpy (Chrom[DataSource].ChromHead->Method.MeasureParameters.CalibrationName, Chrom[DataSource].CalName);

  printf ("\n### Analyze\n");
  printf ("IdentifyPeaks\n");
  IdentifyPeaks (DataSource, DataSource);

  StoreDet = Chrom[DataSource].ActualDetector;
  for (k = 0; k < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; k++) {
	  Chrom[DataSource].ActualDetector = k;
	  for (i = 0; i < Chrom[DataSource].ChromHead->PeakHead.PeakNum[k]; i++) {
		  GetPeak (i, DataSource);
		  if (Chrom[DataSource].Peak->PeakIdentified) {
			  printf ("Trying to find Ist peak if any...\n");
			  if (FindIstPeak (Chrom[DataSource].Peak->AssignedToIst, DataSource)) {
				  GetComponent (Chrom[DataSource].Peak->PeakComponent, DataSource);
				  Chrom[DataSource].Peak->PeakConc = CalculateConc (DataSource);
				  printf ("Peak# = %d\n", i);
				  printf ("Name = %s\n", Chrom[DataSource].Peak->PeakName);
				  printf ("Ist = %d\n", Chrom[DataSource].Peak->PeakIsIst);
				  printf ("Assigned = %d\n", Chrom[DataSource].Peak->AssignedToIst);
				  printf ("Component = %d\n", Chrom[DataSource].Peak->PeakComponent);
				  printf ("Concentration = %.6f\n\n", Chrom[DataSource].Peak->PeakConc);
			  } // if FindIstpeak
		  } else {
			  strcpy (Chrom[DataSource].Peak->PeakName, "");
			  Chrom[DataSource].Peak->PeakId = 0;
			  strcpy (Chrom[DataSource].Peak->PeakIdStr, "");
			  strcpy (Chrom[DataSource].Peak->ConcDim, "");
			  Chrom[DataSource].Peak->PeakConc = 0;
			  Chrom[DataSource].Peak->PeakConcPercent = 0;
			  Chrom[DataSource].Peak->PeakConcFactor = 0;
			  Chrom[DataSource].Peak->PeakConcLowerLimit = 0;
			  Chrom[DataSource].Peak->PeakConcUpperLimit = 0;
			  Chrom[DataSource].Peak->PeakConcExpectedValue = 0;
		  } // PeakIdentified
		  SetPeak (i, DataSource);
	  } // i
  } // k
  Chrom[DataSource].ActualDetector = StoreDet;
} // Analyze

extern void
MakeTemplateFromCalibr (int DataSource) {
int i, j, jChrom;

  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum; i++) {
	  GetLevel (i, DataSource);
	  jChrom = Chrom[DataSource].CalibrLevel->ChromNum;
	  for (j = 0; j < jChrom; j++) {
		  DelChrom (i, 0, DataSource);
	  } // j
  } // i
} // MakeTemplateFromCalibr

extern void
ImplantChromToCalibr (int ChromSource, int CalibrSource, int ImpLevel, int ImpMode) {
int StoreDet;
int i,j,k,l;
int CellIdx;

  printf ("\n### ImplantChromToCalibr\n");
  printf ("IdentifyPeaks\n");
  IdentifyPeaks (ChromSource, CalibrSource);
  
  StoreDet = Chrom[ChromSource].ActualDetector;
  for (k = 0; k < Chrom[ChromSource].ChromHead->Method.Instrument.NumDetectors; k++) {
	  Chrom[ChromSource].ActualDetector = k;
	  for (i = 0; i < Chrom[ChromSource].ChromHead->PeakHead.PeakNum[k]; i++) {
		  GetPeak (i, ChromSource);
		  if ((Chrom[ChromSource].Peak->PeakIdentified) &&\
			  (Chrom[ChromSource].Peak->PeakComponent > -1)){
				  CellIdx = GetCell (Chrom[ChromSource].Peak->PeakComponent, ImpLevel, 0, CalibrSource);
				  Chrom[CalibrSource].CalibrCell->RetTime = Chrom[ChromSource].Peak->PeakRetention;
				  Chrom[CalibrSource].CalibrCell->Height = Chrom[ChromSource].Peak->PeakHeight;
				  Chrom[CalibrSource].CalibrCell->Integral = Chrom[ChromSource].Peak->PeakArea;
				  SetCellByIdx (CellIdx, CalibrSource);
		  } // PeakIdentified
	  } // i
  } // k
  Chrom[ChromSource].ActualDetector = StoreDet;
  RecalculateCalibr (CalibrSource);
} // ImplantChromToCalibr
