// OK functions

extern void
DefaultOkFunction (void) {
  PRINTF ("DefaultOkFunction executed\n", 0);
} // DefaultOkFunction

// ***
// *** Open, Save
// ***

extern void
OpenChromOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
gchar *TmpStr;
BT_INIT();

  BUGTRACE ("OpenChromOkFunction executed");
  gtk_widget_show (ReprocessWindow);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[WorkArea].Filename, FN_UTF8);
  g_free (FN_UTF8);
  ChromLoad (WorkArea);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[WorkArea].Filename);
  BUGTRACE (BugTraceUserString);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
  gtk_window_present (GTK_WINDOW (ReprocessWindow));
} // OpenChromOkFunction

extern void
OpenOverlayChromOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
int OverlayIdx;
BT_INIT();

  BUGTRACE ("OpenOverlayChromOkFunction executed");
  if (ReprocessOverlayChromNum >= MaxOverlayedChrom) {
	  sprintf (BugTraceUserString, "ReprocessOverlayChromNum: %d, OverlayIdx: %d",\
			ReprocessOverlayChromNum, OverlayIdx);
	  BUGTRACE (BugTraceUserString);
	  return;
  } // ReprocessOverlayChromNum >= MaxOverlayedChrom
  OverlayIdx = OverlayedChromBase + ReprocessOverlayChromNum;
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[OverlayIdx].Filename, FN_UTF8);
  strcpy (Chrom[OverlayIdx].ChrName, FN_UTF8);
  g_free (FN_UTF8);
  ChromLoad (OverlayIdx);
  if (Chrom[OverlayIdx].FileLoaded[ChrFlag]) ReprocessOverlayChromNum++;

  sprintf (BugTraceUserString, "Filename: %s, ReprocessOverlayChromNum: %d, OverlayIdx: %d",\
  			Chrom[OverlayIdx].Filename, ReprocessOverlayChromNum, OverlayIdx);
  BUGTRACE (BugTraceUserString);
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshOverlayList ();
  ActivateReprocessWidgets ();
  gtk_window_present (GTK_WINDOW (ReprocessWindow));
} // OpenOverlayChromOkFunction

extern void
SaveChromOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
gchar *TmpStr;
BT_INIT();

  BUGTRACE ("SaveChromOkFunction executed");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[WorkArea].Filename, FN_UTF8);
  g_free (FN_UTF8);
  ChromSave (WorkArea);

  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[WorkArea].Filename);
  BUGTRACE (BugTraceUserString);
} // SaveChromOkFunction

extern void
IntParSaveOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *IntParActualWindow;
struct IntegrationParametersStruct *IntParForSave;

BT_INIT();

  BUGTRACE ("IntParSaveOkFunction executed");

  IntParActualWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParWindow");
  IntParForSave = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParLocal");
  GetIntParWidgets (IntParActualWindow);

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  if (IntParSave (IntParForSave, FN_UTF8)) {
  } // if MethodSave
  else BUGTRACE ("IntParSave returned FALSE.");
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)));
  BUGTRACE (BugTraceUserString);
} // IntParSaveOkFunction

extern void
IntParOpenOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *IntParActualWindow;
struct IntegrationParametersStruct *IntParForOpen;

BT_INIT();

  BUGTRACE ("IntParOpenOkFunction executed");

  IntParActualWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParWindow");
  IntParForOpen = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParLocal");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  if (IntParLoad (IntParForOpen, FN_UTF8)) {
	  SetIntParWidgets (IntParActualWindow);
  } // if MethodLoad
  else BUGTRACE ("IntParLoad returned FALSE.");
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)));
  BUGTRACE (BugTraceUserString);
} // IntParOpenOkFunction

// ***

extern void
GenericDataAcqStartMethodOkFunction (GtkWidget *ApplyWidget) {
struct MethodStruct *GDA_Met;
FILE *TestFile;
char *TestFilename;
int FinalError;
int ActualDSInstrument;
BT_INIT();

  BUGTRACE ("GenericDataAcqStartMethodOkFunction ENTER");

  TestFilename = alloca (1000);
  ActualDSInstrument = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ApplyWidget), "ActualDSInstrument"));

  strcpy (TestFilename, "/tmp/");
  GDA_Met = gtk_object_get_data (GTK_OBJECT (ApplyWidget), "MethodWork");

  pthread_mutex_lock (&measure_parameter_mutex);
  GetMethodWidgets (ApplyWidget);
  pthread_mutex_unlock (&measure_parameter_mutex);

  if (DirExist (Options[ActualDSInstrument].MeasureDataDir)) {
	  strcpy (Options[ActualDSInstrument].MeasureFilename, Options[ActualDSInstrument].MeasureDataDir);
	  sprintf (BugTraceUserString, "Measure directory OK: %s", Options[ActualDSInstrument].MeasureDataDir);
	  BUGTRACE (BugTraceUserString);
	  printf ("%s\n", BugTraceUserString);
  }
  else {
	  strcpy (Options[ActualDSInstrument].MeasureFilename, getenv ("HOME"));
	  sprintf (BugTraceUserString, "MeasureDataDir: %s FAILED", Options[ActualDSInstrument].MeasureDataDir);
	  BUGTRACE (BugTraceUserString);
	  sprintf (BugTraceUserString, "Trying HOME dir: %s", Options[ActualDSInstrument].MeasureFilename);
	  BUGTRACE (BugTraceUserString);
	  printf ("%s\n", BugTraceUserString);
  } // check dir
  if (Options[ActualDSInstrument].MeasureDataDir[strlen (Options[ActualDSInstrument].MeasureDataDir)-1] != '/')
	  strcat (Options[ActualDSInstrument].MeasureFilename, "/");
  strcat (Options[ActualDSInstrument].MeasureFilename, GDA_Met->MeasureParameters.ChromName);
  strcat (TestFilename, GDA_Met->MeasureParameters.ChromName);
  if (GDA_Met->MeasureParameters.ApplyExtension == TRUE) {
	  strcat (Options[ActualDSInstrument].MeasureFilename, ".");
	  strcat (Options[ActualDSInstrument].MeasureFilename, GDA_Met->MeasureParameters.ChromExt);
	  strcat (TestFilename, ".");
	  strcat (TestFilename, GDA_Met->MeasureParameters.ChromExt);
  }
  strcat (Options[ActualDSInstrument].MeasureFilename, ".chr");
  sprintf (BugTraceUserString, "MeasureFilename = %s", Options[ActualDSInstrument].MeasureFilename);
  BUGTRACE (BugTraceUserString);
  strcat (TestFilename, ".chr");

  TestFile = fopen (TestFilename, "w");
  if (TestFile == NULL) {
	  sprintf (BugTraceUserString, "MeasureFilename: %s FAILED", Options[ActualDSInstrument].MeasureFilename);
	  BUGTRACE (BugTraceUserString);
	  FinalError = TRUE;
  } else {
	  FinalError = FALSE;
	  unlink (TestFilename);
	  fclose (TestFile);
  } // if TestFile

  if (!FinalError) {
	  gtk_window_set_modal (GTK_WINDOW(ApplyWidget), TRUE);
	  gtk_object_set_data (GTK_OBJECT (ApplyWidget), "CallerButton", NULL);
	  GenerateWorkDir (&ActualDSInstrument);
	  ThreadCommandSend (ThreadCommandStart, 0, ActualDSInstrument);
	  ActivateMeasureWidgets (ActualDSInstrument);
	  gtk_widget_destroy (ApplyWidget);
  } else {
	  MeasureFilenameErrorDialog = create_MeasureFilenameErrorDialog ();
	  gtk_object_set_data (GTK_OBJECT (MeasureFilenameErrorDialog), "MethodWin", ApplyWidget);
	  gtk_widget_show (MeasureFilenameErrorDialog);
  } // if FinalError

  BUGTRACE ("GenericDataAcqStartMethodOkFunction EXIT");
} // GenericDataAcqStartMethodOkFunction

extern void
GenericDataAcqStartQueueOkFunction (GtkWidget *ApplyWidget) {
int ActualDSInstrument;
GtkWidget *MeasureWindow;
gboolean DirOK;
int i;
char *TmpStr;
char *TmpName;
gchar *TmpBaseName;
BT_INIT();

  BUGTRACE ("GenericDataAcqStartQueueOkFunction ENTER");
  ActualDSInstrument = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ApplyWidget), "ActualDSInstrument"));

  TmpStr = alloca (20);
  TmpName = alloca (1200);

  GetSampleQueueWidgets (ApplyWidget);
  MeasureWindow = gtk_object_get_data (GTK_OBJECT (ApplyWidget), "CallerWidget");

  DirOK = FALSE;
  if ((CheckDirName (Chrom[ActualDSInstrument].QueueHead.Directory)) && (strlen (Chrom[ActualDSInstrument].QueueHead.Directory) > 1)) {
	  strcpy (Options[ActualDSInstrument].MeasureDataDir, Chrom[ActualDSInstrument].QueueHead.Directory);
	  DirOK = TRUE;
  } else {
	  if ((Options[ActualDSInstrument].MeasureDataDir) && (strlen (Options[ActualDSInstrument].MeasureDataDir) > 1)) {
		  DirOK = TRUE;
	  }
  }
  if (DirOK) {
	  memcpy (&Chrom[ActualDSInstrument].Method, \
			  &Chrom[ActualDSInstrument].QueueHead.LQMethod, \
			  sizeof(struct MethodStruct));
	  GenerateWorkDir (&ActualDSInstrument);
	  strcpy (Chrom[ActualDSInstrument].QueueHead.Directory, Options[ActualDSInstrument].MeasureDataDir);
	  CalibrLoad (ActualDSInstrument, Chrom[ActualDSInstrument].QueueHead.Calibration);
	  if (Chrom[ActualDSInstrument].FileLoaded[CalFlag]) {
		  if (Chrom[ActualDSInstrument].QueueHead.CalibrationTemplate) {
			  Chrom[ActualDSInstrument].CalibrHead->ChromNum = 0;
			  Chrom[ActualDSInstrument].CalibrHead->CellNum = 0;
			  for (i = 0; i < Chrom[ActualDSInstrument].CalibrHead->LevelNum; i++) {
				  GetLevel (i, ActualDSInstrument);
				  Chrom[ActualDSInstrument].CalibrLevel->ChromNum = 0;
				  SetLevel (i, ActualDSInstrument);
			  } // i
			  Chrom[ActualDSInstrument].QueueHead.CalibrationLocalCopy = TRUE;
		  } // if Template
		  if (Chrom[ActualDSInstrument].QueueHead.CalibrationLocalCopy) {
			  strcpy (TmpName, Options[ActualDSInstrument].MeasureDataDir);
			  strcat (TmpName, "Data/");
			  TmpBaseName = g_path_get_basename (Chrom[ActualDSInstrument].QueueHead.Calibration);
			  strcat (TmpName, TmpBaseName);
//			  strcat (TmpName, Chrom[ActualDSInstrument].QueueHead.BaseName);
//			  strcat (TmpName, ".cal");
			  g_free (TmpBaseName);
			  strcpy (Chrom[ActualDSInstrument].QueueHead.Calibration, TmpName);
			  strcpy (Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.CalibrationName, TmpName);
			  strcpy (Chrom[ActualDSInstrument].Method.MeasureParameters.CalibrationName, TmpName);
			  CalibrSave (ActualDSInstrument, TmpName);
		  } // if LocalCopy
	  } // if CalFlag
	  Chrom[ActualDSInstrument].QueueHead.StartTime = time (NULL);
	  GenerateFileName (Options[ActualDSInstrument].MeasureDataDir, \
						Chrom[ActualDSInstrument].QueueHead.BaseName, \
						".que", TmpName, \
						Chrom[ActualDSInstrument].QueueHead.StartTime);
	  strcpy (Chrom[ActualDSInstrument].LayerQueueName, TmpName);
	  Chrom[ActualDSInstrument].QueueHead.QueueItemClosed = 0;
	  QueueSave (ActualDSInstrument);
	  ActivateWidget (MeasureWindow, "MeasureWorkstationResetMonitoringButton", FALSE);
	  ActivateWidget (MeasureWindow, "MeasureBreakButton", TRUE);
	  ActivateWidget (MeasureWindow, "MeasureFinishButton", TRUE);
	  ThreadCommandSend (ThreadCommandStart, 0, ActualDSInstrument);
	  ActivateMeasureWidgets (ActualDSInstrument);
  } else {
	  create_FilenameErrorDialog (MeasureWindow, _("Hiba a megadott könyvtárnévnél!"), _("Directory hiba"));
  }

  gtk_widget_destroy (ApplyWidget);
  RefreshMeasureQueueList (ActualDSInstrument);
  BUGTRACE ("GenericDataAcqStartQueueOkFunction EXIT");
} // GenericDataAcqStartQueueOkFunction

extern void
MethodOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
int ADSI;

  DATASOURCE(ApplyWidget);
  ADSI = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ApplyWidget), "ActualDSInstrument"));

  GetMethodWidgets (ApplyWidget);

  Chrom[DataSource].FileLoaded[MetFlag] = TRUE;
  Chrom[DataSource].FileSaved[MetFlag] = FALSE;
  if (Chrom[DataSource].FileSaved[MetFlag] == FALSE) {
	  OpenSaveFileSelection = create_OpenSaveFileSelection ();
	  gtk_object_set_data (GTK_OBJECT(ApplyWidget), "OpenSaveFileSelection", OpenSaveFileSelection);
	  DATASOURCE_UP(OpenSaveFileSelection, DataSource);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "MethodWork", gtk_object_get_data (GTK_OBJECT (ApplyWidget), "MethodWork"));
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", ApplyWidget);
	  CallerButton = lookup_widget (ApplyWidget, "MethodOkButton");
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", CallerButton);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", MethodExitSaveOkFunction);
	  if (CallerButton != NULL)
		  gtk_widget_set_sensitive (CallerButton, FALSE);
	  FN_UTF8 = g_filename_from_utf8 (Options[ADSI].MethodDir, -1, &bytes_read, &bytes_written, NULL);
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), FN_UTF8);
	  g_free (FN_UTF8);
	  gtk_window_set_transient_for (GTK_WINDOW (OpenSaveFileSelection), GTK_WINDOW (ApplyWidget));
	  gtk_widget_show (OpenSaveFileSelection);
  } // FileSaved
} // MethodOkFunction

extern void
MethodInQueueOkFunction (GtkWidget *ApplyWidget) {
  DATASOURCE(ApplyWidget);
  GetMethodWidgets (ApplyWidget);

  gtk_widget_destroy (ApplyWidget);
} // MethodInQueueOkFunction

extern void
MethodReprocessOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;

  DATASOURCE(ApplyWidget);

  GetReprocessMethodWidgets (ApplyWidget);
  ReprocessDrawChromDone ();
  SetChromParameters (DataSource);
  ReintegrateDBI (DataSource);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  gtk_widget_destroy (ApplyWidget);
} // MethodReprocessOkFunction

extern void
IntParInMethodApplyFunction (GtkWidget *ApplyWidget) {
struct IntegrationParametersStruct *IntPar;
struct IntegrationParametersStruct *IntParLocal;
BT_INIT();

  BUGTRACE ("IntParInMethodApplyFunction executed");
  GetIntParWidgets (ApplyWidget);
  IntPar = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntPar");
  IntParLocal = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParLocal");
  memcpy (IntPar, IntParLocal, sizeof(struct IntegrationParametersStruct));
} // IntParInMethodApplyFunction

extern void
ReportInMethodApplyFunction (GtkWidget *ApplyWidget) {
  PRINTF ("ReportInMethodApplyFunction executed\n", 0);
  GetReportEditWidgets (ApplyWidget);
} // ReportInMethodApplyFunction

extern void
SampleQueueOkFunction (GtkWidget *ApplyWidget) {
  PRINTF ("SampleQueueOkFunction executed\n", 0);
  GetSampleQueueWidgets (ApplyWidget);
} // SampleQueueOkFunction

extern void
SampleQueueDevelopOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
int ADSI;

  DATASOURCE(ApplyWidget);
  ADSI = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ApplyWidget), "ActualDSInstrument"));

  GetSampleQueueWidgets (ApplyWidget);

  Chrom[DataSource].FileLoaded[LayFlag] = TRUE;
  Chrom[DataSource].FileSaved[LayFlag] = FALSE;
  if (Chrom[DataSource].FileSaved[LayFlag] == FALSE) {
	  OpenSaveFileSelection = create_OpenSaveFileSelection ();
	  gtk_object_set_data (GTK_OBJECT(ApplyWidget), "OpenSaveFileSelection", OpenSaveFileSelection);
	  DATASOURCE_UP(OpenSaveFileSelection, DataSource);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "MethodWork", gtk_object_get_data (GTK_OBJECT (ApplyWidget), "MethodWork"));
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", ApplyWidget);
	  CallerButton = lookup_widget (ApplyWidget, "SampleQueueOkButton");
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", CallerButton);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SampleQueueExitSaveOkFunction);
	  if (CallerButton != NULL)
		  gtk_widget_set_sensitive (CallerButton, FALSE);
	  FN_UTF8 = g_filename_from_utf8 (Options[ADSI].MethodDir, -1, &bytes_read, &bytes_written, NULL);
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), FN_UTF8);
	  g_free (FN_UTF8);
	  gtk_window_set_transient_for (GTK_WINDOW (OpenSaveFileSelection), GTK_WINDOW (ApplyWidget));
	  gtk_widget_show (OpenSaveFileSelection);
  } // FileSaved
  PRINTF ("SampleQueueDevelopOkFunction executed\n", 0);
} // SampleQueueDevelopOkFunction

extern void
MeasurePreferencesApplyFunction (GtkWidget *ApplyWidget) {
  PRINTF ("MeasurePreferencesApplyFunction executed\n", 0);
  GetPreferencesWidgets (ApplyWidget);
} // MeasurePreferencesApplyFunction

// *** Main

extern void
MainOpenOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gchar *DN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *MethodActualWindow;
struct MethodStruct *MethodForOpen;

BT_INIT();

  BUGTRACE ("MainOpenOkFunction executed");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[WorkArea].LayerQueueName, FN_UTF8);
  QueueLoad (WorkArea);
  DN_UTF8 = g_path_get_dirname (FN_UTF8);
  strcpy (LastMainOpenDir, DN_UTF8);
  if (LastMainOpenDir[strlen(LastMainOpenDir) - 1] != '/')
	  strcat (LastMainOpenDir, "/");
  g_free (DN_UTF8);
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[WorkArea].LayerQueueName);
  BUGTRACE (BugTraceUserString);
  if (Chrom[WorkArea].FileLoaded[LayFlag]) {
	  DATA_UP(MainWindow, "TR541SelectedTrack", 1);
	  SetSpinButtonValue (MainWindow, "MainTR541ChromSelectedTrackSpinButton", 1);
	  SetSpinButtonValue (MainWindow, "MainTR541ChromLowerValueSpinButton", Chrom[WorkArea].QueueHead.LQMethod.MeasureParameters.ViewMin);
	  SetSpinButtonValue (MainWindow, "MainTR541ChromUpperValueSpinButton", Chrom[WorkArea].QueueHead.LQMethod.MeasureParameters.ViewMax);
	  CalibrLoad (WorkArea, Chrom[WorkArea].QueueHead.Calibration);
	  ActivateWidget (MainWindow, "MainCloseButton", TRUE);
  }
  OverrideMainWindowShrink = TRUE;
  if (MainWindowShrinked)
	  ExpandMainWindow();
  RefreshMainQueue (MainWindow);
  RefreshMainWidgets (MainWindow);
  RefreshReprocessQueue (ReprocessWindow);
} // MainOpenOkFunction

extern void
MainPreferencesApplyFunction (GtkWidget *ApplyWidget) {
  PRINTF ("MainPreferencesApplyFunction executed\n", 0);
  GetPreferencesWidgets (ApplyWidget);
} // MainPreferencesApplyFunction

extern void
MethodOpenOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *MethodActualWindow;
struct MethodStruct *MethodForOpen;

BT_INIT();

  BUGTRACE ("OpenMethodOkFunction executed");

  MethodActualWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "MethodWindow");
  DATASOURCE(MethodActualWindow);
  MethodForOpen = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "MethodWork");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  if (MethodLoad (MethodForOpen, FN_UTF8)) {
	  strcpy (Chrom[DataSource].MetName, FN_UTF8);
  } // if MethodLoad
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[DataSource].MetName);
  BUGTRACE (BugTraceUserString);
  SetMethodWidgets (MethodActualWindow);
} // MethodOpenOkFunction

extern void
MethodSaveAsOkFunction (GtkWidget *ApplyWidget) {
} // MethodSaveAsOkFunction

extern void
MethodExitSaveOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
GtkWidget *CallerWidget;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
struct MethodStruct *MethodForSave;

DATASOURCE(ApplyWidget);

BT_INIT();

  BUGTRACE ("OpenMethodOkFunction executed");
  MethodForSave = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "MethodWork");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(OpenSaveFileSelection)), -1, &bytes_read, &bytes_written, NULL);
  Chrom[DataSource].FileLoaded[MetFlag] = TRUE;
  Chrom[DataSource].FileSaved[MetFlag] = FALSE;
  if (MethodSave (MethodForSave, FN_UTF8)) {
	  strcpy (Chrom[DataSource].MetName, FN_UTF8);
	  Chrom[DataSource].FileSaved[MetFlag] = TRUE;
  } // if
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[DataSource].MetName);
  BUGTRACE (BugTraceUserString);

  CallerWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");
  gtk_object_set_data (GTK_OBJECT(CallerWidget), "OpenSaveFileSelection", NULL);
  gtk_object_set_data (GTK_OBJECT(ApplyWidget), "CallerWidget", NULL);
  gtk_object_set_data (GTK_OBJECT(ApplyWidget), "CallerButton", NULL);

  gtk_widget_destroy (CallerWidget);
} // MethodExitSaveOkFunction

extern void
IntParReprocessApplyFunction (GtkWidget *ApplyWidget) {
struct IntegrationParametersStruct *IntPar;
struct IntegrationParametersStruct *IntParLocal;
BT_INIT();

  BUGTRACE ("IntParReprocessApplyFunction executed");
  GetIntParWidgets (ApplyWidget);
  IntPar = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntPar");
  IntParLocal = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "IntParLocal");
  memcpy (IntPar, IntParLocal, sizeof(struct IntegrationParametersStruct));
  ReintegrateDBI (WorkArea);
  ReprocessDrawChrom ();
  RefreshPeakList ();
} // IntParReprocessApplyFunction

extern void
OverlayColorOkFunction (GtkWidget *ApplyWidget) {
int OvrSelect;

BT_INIT();

  BUGTRACE ("OverlayColorOkFunction executed");
  OvrSelect = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "ReprocessOverlayCListSelected"));
  gtk_color_selection_get_current_color (GTK_COLOR_SELECTION(lookup_widget(ApplyWidget, "ColorSelection")),\
	  &OverlayColor[OvrSelect]);
  gdk_colormap_alloc_color (DrawColormap, &OverlayColor[OvrSelect], TRUE, TRUE);
  ReprocessDrawChrom ();
} // 

extern void
SpectraOpenOkFunction (GtkWidget *ApplyWidget) {
BT_INIT();

  BUGTRACE ("SpectraOpenOkFunction executed");
} // SpectraOpenOkFunction

extern void
SpectraSaveAsOkFunction (GtkWidget *ApplyWidget) {
BT_INIT();

  BUGTRACE ("SpectraSaveAsOkFunction executed");
} // SpectraSaveAsOkFunction

extern void
SpectraExportOkFunction (GtkWidget *ApplyWidget) {
BT_INIT();

  BUGTRACE ("SpectraExportOkFunction executed");
} // SpectraExportOkFunction

extern void
SpectraExitSaveOkFunction (GtkWidget *ApplyWidget) {
BT_INIT();

  BUGTRACE ("SpectraExitSaveOkFunction executed");
} // SpectraExitSaveOkFunction

extern void
AnalyzeApplyFunction (GtkWidget *ApplyWidget) {
gboolean QueueMode;
gboolean SingleMode;
char TmpName[FilenameLength];
int i;
BT_INIT();

  DATASOURCE(ApplyWidget);
  SingleMode = TRUE;
  QueueMode = DATA_DOWN(ApplyWidget, "QueueMode");

  if (QueueMode) {
	  GetAnalyzeWidgets (DataSource, ApplyWidget);
	  SingleMode = DATA_DOWN(ApplyWidget, "SingleMode");
  }

  if (SingleMode) {
	  printf ("SingleAnalyze\n");
	  Analyze (DataSource);
	  ChromSave (DataSource);
  } else {
	  printf ("QueueAnalyze\n");
	  strcpy (TmpName, "");
	  if (Chrom[DataSource].FileLoaded[ChrFlag])
		  strcpy (TmpName, Chrom[DataSource].ChrName);
	  for (i = 0; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
		  GetQueueItem (DataSource, i);
		  strcpy (Chrom[DataSource].Filename, Chrom[DataSource].QueueItem.FinalFilename);
		  printf ("Chrom #%d: %s analyzed\n", i, Chrom[DataSource].Filename);
		  ChromLoad (DataSource);
		  Analyze (DataSource);
		  ChromSave (DataSource);
	  } // i
	  if (strlen(TmpName) > 0) {
		  strcpy (Chrom[DataSource].Filename, TmpName);
		  ChromLoad (DataSource);
	  }
  } // SingleMode

  BUGTRACE ("AnalyzeApplyFunction executed");
} // AnalyzeApplyFunction

extern void
OpenCalibrOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *CalibrWidget;
int DataSource;
BT_INIT();

  BUGTRACE ("OpenCalibrOkFunction executed");

  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "DataSource"));
  CalibrWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  CalibrLoad (DataSource, FN_UTF8);
  g_free (FN_UTF8);

  SetCalibrateWidgets (DataSource, CalibrWidget);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[DataSource].Filename);
  BUGTRACE (BugTraceUserString);
  gtk_window_present (GTK_WINDOW (CalibrWidget));
} // OpenCalibrOkFunction

extern void
SaveCalibrOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *CalibrWidget;
int DataSource;
BT_INIT();

  BUGTRACE ("SaveCalibrOkFunction executed");

  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "DataSource"));
  CalibrWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  CalibrSave (DataSource, FN_UTF8);
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s, DataSource = %d",Chrom[DataSource].Filename, DataSource);
  BUGTRACE (BugTraceUserString);
} // SaveCalibrOkFunction

extern void
CalibrateApplyFunction (GtkWidget *ApplyWidget) {
gboolean QueueMode;
BT_INIT();


  QueueMode = DATA_DOWN(ApplyWidget, "QueueMode");
  DATASOURCE(ApplyWidget);

  GetCalibrateWidgets (DataSource, ApplyWidget);
  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;

  if (QueueMode) {
	  CalibrSave (DataSource, Chrom[DataSource].CalName);
//	  return;
  } // QueueMode

  sprintf (BugTraceUserString, "CalibrateApplyFunction executed, DataSource = %d", DataSource);
  BUGTRACE (BugTraceUserString);
} // CalibrateApplyFunction

extern void
TR541MeasureImportTR540RAWOkFunction (GtkWidget *ApplyWidget) {
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
GtkWidget *CallerWindow;
int DataSource;
int DataShift;
BT_INIT();

  BUGTRACE ("TR541MeasureOpenOkFunction executed");

  CallerWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWindow");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "ActualDSInstrument"));
  DataShift = GetSpinButtonInt (CallerWindow, "MeasureTR541StartYSpinButton") - 1;
  if (DataShift < 0) DataShift = 0;
  if (DataShift > 199) DataShift = 199;

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(ApplyWidget)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[DataSource].Filename, FN_UTF8);
  TR541OldRawDataOpen (DataSource, DataShift);
  g_free (FN_UTF8);

  sprintf (BugTraceUserString, "Filename: %s",Chrom[DataSource].Filename);
  BUGTRACE (BugTraceUserString);
  TR541RawRedraw (DataSource, lookup_widget (CallerWindow, "MeasureTR541LayerDrawingArea"));
} // TR541MeasureImportTR540RAWOkFunction

extern void
TR541MeasureNewOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerWindow;
int DataSource;
BT_INIT();

  BUGTRACE ("TR541MeasureNewOkFunction executed");

  CallerWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWindow");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "ActualDSInstrument"));

  GetSampleQueueWidgets (ApplyWidget);

  gtk_object_set_data (GTK_OBJECT (CallerWindow), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusNew));
  ActivateMeasureWidgets (DataSource);

  gtk_widget_destroy (ApplyWidget);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;

  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMinColor.red = 65535;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMinColor.green = 65535;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMinColor.blue = 65535;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMaxColor.red = 0;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMaxColor.green = 0;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMaxColor.blue = 0;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMin = 0;
  Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMax = 1000;
  SetTR541Widgets (CallerWindow, &Chrom[DataSource].QueueHead.LQMethod);
} // TR541MeasureNewOkFunction

extern void
TR541MeasureNewDestroyFunction (GtkObject *DestroyObject) {
int DataSource;

  DataSource = GPOINTER_TO_INT(gtk_object_get_data (DestroyObject, "ActualDSInstrument"));
  ActivateMeasureWidgets (DataSource);
} // TR541MeasureNewDestroyFunction

extern void
TR541MeasureQueueOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerWindow;
gboolean DirOK;
int i;
char *TmpName;
gchar *TmpBaseName;
BT_INIT();

  BUGTRACE ("TR541MeasureQueueOkFunction executed");

  TmpName = alloca (1200);

  CallerWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWindow");
  DATASOURCE(ApplyWidget);
  ADSI(ApplyWidget);

  GetSampleQueueWidgets (ApplyWidget);

  if (Chrom[DataSource].QueueHead.QueueItemNum > 0)
	  gtk_object_set_data (GTK_OBJECT (CallerWindow), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusQueueOk));
  else
	  gtk_object_set_data (GTK_OBJECT (CallerWindow), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusViewScanReady));

  DirOK = FALSE;
  if ((CheckDirName (Chrom[ActualDSInstrument].QueueHead.Directory)) && (strlen (Chrom[ActualDSInstrument].QueueHead.Directory) > 1)) {
	  strcpy (Options[ActualDSInstrument].MeasureDataDir, Chrom[ActualDSInstrument].QueueHead.Directory);
	  DirOK = TRUE;
  } else {
	  if ((Options[ActualDSInstrument].MeasureDataDir) && (strlen (Options[ActualDSInstrument].MeasureDataDir) > 1)) {
		  DirOK = TRUE;
	  }
  } // if DirOK

  if (DirOK) {
	  memcpy (&Chrom[ActualDSInstrument].Method, \
			  &Chrom[ActualDSInstrument].QueueHead.LQMethod, \
			  sizeof(struct MethodStruct));
	  GenerateWorkDir (&ActualDSInstrument);
	  strcpy (Chrom[ActualDSInstrument].QueueHead.Directory, Options[ActualDSInstrument].MeasureDataDir);
	  CalibrLoad (ActualDSInstrument, Chrom[ActualDSInstrument].QueueHead.Calibration);
	  if (Chrom[ActualDSInstrument].FileLoaded[CalFlag]) {
		  if (Chrom[ActualDSInstrument].QueueHead.CalibrationTemplate) {
			  Chrom[ActualDSInstrument].CalibrHead->ChromNum = 0;
			  Chrom[ActualDSInstrument].CalibrHead->CellNum = 0;
			  for (i = 0; i < Chrom[ActualDSInstrument].CalibrHead->LevelNum; i++) {
				  GetLevel (i, ActualDSInstrument);
				  Chrom[ActualDSInstrument].CalibrLevel->ChromNum = 0;
				  SetLevel (i, ActualDSInstrument);
			  } // i
			  Chrom[ActualDSInstrument].QueueHead.CalibrationLocalCopy = TRUE;
		  } // if Template
		  if (Chrom[ActualDSInstrument].QueueHead.CalibrationLocalCopy) {
			  strcpy (TmpName, Options[ActualDSInstrument].MeasureDataDir);
			  strcat (TmpName, "Data/");
			  TmpBaseName = g_path_get_basename (Chrom[ActualDSInstrument].QueueHead.Calibration);
//			  strcat (TmpName, TmpBaseName);
			  strcat (TmpName, Chrom[ActualDSInstrument].QueueHead.BaseName);
			  strcat (TmpName, ".cal");
			  g_free (TmpBaseName);
			  strcpy (Chrom[ActualDSInstrument].QueueHead.Calibration, TmpName);
			  CalibrSave (ActualDSInstrument, TmpName);
		  } // if LocalCopy
	  } // if CalFlag
	  Chrom[ActualDSInstrument].QueueHead.StartTime = time (NULL);
	  GenerateFileName (Options[ActualDSInstrument].MeasureDataDir, \
						Chrom[ActualDSInstrument].QueueHead.BaseName, \
						".lay", TmpName, \
						Chrom[ActualDSInstrument].QueueHead.StartTime);
	  strcpy (Chrom[ActualDSInstrument].LayerQueueName, TmpName);
	  Chrom[ActualDSInstrument].QueueHead.QueueItemClosed = 0;
  } else {
	  create_FilenameErrorDialog (MeasureWindow, _("Hiba a megadott könyvtárnévnél!"), _("Directory hiba"));
	  gtk_object_set_data (GTK_OBJECT (CallerWindow), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusViewScanReady));
  }

  ActivateMeasureWidgets (ActualDSInstrument);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
  gtk_widget_destroy (ApplyWidget);
} // TR541MeasureQueueOkFunction

extern void
WorkstationMeasureNewOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerWindow;
GtkWidget *CallerButton;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
int DataSource;
BT_INIT();

  BUGTRACE ("WorkstationMeasureNewOkFunction executed");

  CallerWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWindow");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "ActualDSInstrument"));

  GetSampleQueueWidgets (ApplyWidget);

  Chrom[DataSource].FileLoaded[LayFlag] = TRUE;
  Chrom[DataSource].FileSaved[LayFlag] = FALSE;
  if (Chrom[DataSource].FileSaved[LayFlag] == FALSE) {
	  OpenSaveFileSelection = create_OpenSaveFileSelection ();
	  gtk_object_set_data (GTK_OBJECT(ApplyWidget), "OpenSaveFileSelection", OpenSaveFileSelection);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", ApplyWidget);
	  CallerButton = lookup_widget (ApplyWidget, "SampleQueueOkButton");
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", CallerButton);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SampleQueueSaveOkFunction);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "Channel", GINT_TO_POINTER(DataSource));
	  if (CallerButton != NULL)
		  gtk_widget_set_sensitive (CallerButton, FALSE);
	  FN_UTF8 = g_filename_from_utf8 (Options[DataSource].MeasureDataDir, -1, &bytes_read, &bytes_written, NULL);
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), FN_UTF8);
	  g_free (FN_UTF8);
	  gtk_window_set_transient_for (GTK_WINDOW (OpenSaveFileSelection), GTK_WINDOW (ApplyWidget));
	  gtk_widget_show (OpenSaveFileSelection);
  } // FileSaved

  ActivateWidget (CallerWindow, "MeasureOpenButton", TRUE);
  ActivateWidget (CallerWindow, "MeasureCloseButton", TRUE);
} // WorkstationMeasureNewOkFunction

extern void
WorkstationMeasureQueueOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerWindow;
GtkWidget *CallerButton;
int DataSource;
BT_INIT();

  BUGTRACE ("WorkstationMeasureNewOkFunction executed");

  CallerWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWindow");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ApplyWidget), "ActualDSInstrument"));

  GetSampleQueueWidgets (ApplyWidget);
  RefreshMeasureQueueList (DataSource);

  gtk_widget_destroy (ApplyWidget);
} // WorkstationMeasureQueueOkFunction

extern void
SampleQueueExitSaveOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
GtkWidget *CallerWidget;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
char *TitleStr;

  CallerWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");

  DATASOURCE(CallerWidget);

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(OpenSaveFileSelection)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[DataSource].LayerQueueName, FN_UTF8);
  QueueSave (DataSource);
  g_free (FN_UTF8);

  TitleStr = alloca (FilenameLength + 40);
  strcpy (TitleStr, "Queue: ");
  strcat (TitleStr, Chrom[DataSource].LayerQueueName);
  gtk_window_set_title (GTK_WINDOW(CallerWidget), TitleStr);
  gtk_widget_destroy (CallerWidget);
} // SampleQueueExitSaveOkFunction

extern void
SampleQueueSaveOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
GtkWidget *CallerWidget;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
char *TitleStr;

  CallerWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");

  DATASOURCE(CallerWidget);

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(OpenSaveFileSelection)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[DataSource].LayerQueueName, FN_UTF8);
  QueueSave (DataSource);
  g_free (FN_UTF8);

  TitleStr = alloca (FilenameLength + 40);
  strcpy (TitleStr, "Queue: ");
  strcat (TitleStr, Chrom[DataSource].LayerQueueName);
  gtk_window_set_title (GTK_WINDOW(CallerWidget), TitleStr);
} // SampleQueueSaveOkFunction

extern void
SampleQueueOpenOkFunction (GtkWidget *ApplyWidget) {
GtkWidget *CallerButton;
GtkWidget *CallerWidget;
gchar *FN_UTF8;
gsize bytes_read;
gsize bytes_written;
char *TitleStr;

  CallerWidget = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CallerWidget");

  DATASOURCE(CallerWidget);

  FN_UTF8 = g_filename_to_utf8 (gtk_file_selection_get_filename (GTK_FILE_SELECTION(OpenSaveFileSelection)), -1, &bytes_read, &bytes_written, NULL);
  strcpy (Chrom[DataSource].LayerQueueName, FN_UTF8);
  QueueLoad (DataSource);
  g_free (FN_UTF8);


  SetSampleQueueWidgets (CallerWidget);
  RefreshQueueList (CallerWidget);
  TitleStr = alloca (FilenameLength + 40);
  strcpy (TitleStr, "Queue: ");
  strcat (TitleStr, Chrom[DataSource].LayerQueueName);
  gtk_window_set_title (GTK_WINDOW(CallerWidget), TitleStr);
} // SampleQueueOpenOkFunction


//***
//*** Select sample queue item dialog functions
//***

extern void
SelectCalibrTemplateDialogApplyFunction (GtkWidget *ApplyWidget) {
GtkWidget *Tree;
GtkTreeSelection *Selection;
GtkTreeModel *Model;
GtkTreeIter Iter;
gboolean IfSelected;
gchar *FullFilename;
GtkWidget *CalibrationWindow;
int j;

enum {
   NUMBER_COLUMN,
   SAMPLETYPE_COLUMN,
   NAME_COLUMN,
   FULLNAME_COLUMN,
   N_COLUMNS
};

  DATASOURCE(ApplyWidget);
  CalibrationWindow = gtk_object_get_data (GTK_OBJECT(ApplyWidget), "CalibrationWindow");

  Tree = lookup_widget (ApplyWidget, "SelectQueueItemTreeView");
  Selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(Tree));
  IfSelected = gtk_tree_selection_get_selected (Selection, &Model, &Iter);
  if (IfSelected) {
	  FullFilename = NULL;
	  gtk_tree_model_get (Model, &Iter, FULLNAME_COLUMN, &FullFilename, -1);
	  printf ("FullFilename = %s\n", FullFilename);
	  strcpy (Chrom[DataSource].CalibrTemplateChromName, FullFilename);
	  g_free (FullFilename);
	  CalibrTemplateChromLoad (DataSource);
	  RefreshCalibrTemplateChromList (DataSource, CalibrationWindow);
	  for (j = 0; j < MaxDetectors; j++)
		  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (CalibrationWindow, "CalibrationComponentsListDetectorComboBox")), 0);
	  for (j = 0; j < Chrom[DataSource].CalibrTemplateChromHead->Method.Instrument.NumDetectors; j++)
		  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (CalibrationWindow, "CalibrationComponentsListDetectorComboBox")), \
	  														Chrom[DataSource].CalibrTemplateChromHead->Method.Instrument.Detectors[j].Name);
	  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (CalibrationWindow, "CalibrationComponentsListDetectorComboBox")), \
	  												Chrom[DataSource].CalibrTemplateActualDetector);
	  if (Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrTemplateActualDetector] > 0)
		  gtk_clist_select_row (GTK_CLIST(lookup_widget (CalibrationWindow, "CalibrationComponentsTemplateChromCList")), 0, 0);
	  else
		  gtk_clist_unselect_row (GTK_CLIST(lookup_widget (CalibrationWindow, "CalibrationComponentsTemplateChromCList")), 0, 0);
	  CalibrationModified (DataSource);
  } // IfSelected
} // SelectCalibrTemplateDialogApplyFunction

extern void
SelectCalibrChromDialogApplyFunction (GtkWidget *ApplyWidget) {
GtkWidget *Tree;
GtkTreeSelection *Selection;
GtkTreeModel *Model;
GtkTreeIter Iter;
gboolean IfSelected;
gchar *FullFilename;
GtkWidget *CalibrationWindow;

enum {
   NUMBER_COLUMN,
   SAMPLETYPE_COLUMN,
   NAME_COLUMN,
   FULLNAME_COLUMN,
   N_COLUMNS
};

  DATASOURCE(ApplyWidget);
  CalibrationWindow = gtk_object_get_data(GTK_OBJECT(ApplyWidget), "CalibrationWindow");

  Tree = lookup_widget (ApplyWidget, "SelectQueueItemTreeView");
  Selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(Tree));
  IfSelected = gtk_tree_selection_get_selected (Selection, &Model, &Iter);
  if (IfSelected) {
	  FullFilename = NULL;
	  gtk_tree_model_get (Model, &Iter, FULLNAME_COLUMN, &FullFilename, -1);
	  printf ("FullFilename = %s\n", FullFilename);
	  SetEntry (CalibrationWindow, "CalibrationLevelsChromSelectEntry", FullFilename);
	  g_free (FullFilename);
  } // IfSelected
} // SelectCalibrChromDialogApplyFunction

extern void
SelectCalibrTemplateDialogDestroyFunction (GtkObject *DestroyObject) {
GtkWidget *CalibrationWindow;

  CalibrationWindow = gtk_object_get_data (DestroyObject, "CalibrationWindow");
  if (CalibrationWindow != NULL)
	  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectTemplateDialog", NULL);
} // SelectCalibrTemplateDialogDestroyFunction

extern void
SelectCalibrChromDialogDestroyFunction (GtkObject *DestroyObject) {
GtkWidget *CalibrationWindow;

  CalibrationWindow = gtk_object_get_data (DestroyObject, "CalibrationWindow");
  if (CalibrationWindow != NULL)
	  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectChromDialog", NULL);
} // SelectCalibrChromDialogDestroyFunction

extern void
ZoomReprocessApplyFunction (GtkWidget *ApplyWidget) {
GtkWidget *ZoomWindow;

  GetZoomWidgets (ApplyWidget);
  ReprocessDrawChrom ();
} // ZoomReprocessApplyFunction
