// Generic measure

extern void
DefaultInitFunction (void) {
	//if (PrintfMode) printf ("DefaultInitFunction executed\n");
} // DefaultInitFunction

extern void
DefaultDoneFunction (void) {
	//if (PrintfMode) printf ("DefaultDoneFunction executed\n");
} // DefaultDoneFunction

extern void
DefaultCommandFunction (void) {
	//if (PrintfMode) printf ("DefaultCommandFunction executed\n");
} // DefaultCommandFunction

extern void
DefaultExecFunction (void) {
	//if (PrintfMode) printf ("DefaultExecFunction executed\n");
} // DefaultExecFunction

extern void
DefaultErrorFunction (void) {
	//if (PrintfMode) printf ("DefaultErrorFunction executed\n");
} // DefaultErrorFunction

extern void*
generic_measure_function (void* unused)
{
int i;

  printf ("\nThread --- PID: %d, ParentPID: %d\n", getpid(), getppid());

  ThreadExit = FALSE;
  ThreadExitOk = FALSE;

  for (i = 0; i < MaxInstrument; i++) {
	  ThreadStatus[i] = ThreadStatusIdle;
	  ThreadStopFlag[i] = FALSE;
	  ThreadBreakFlag[i] = FALSE;
	  ThreadFinishFlag[i] = FALSE;
	  ThreadSuspendFlag[i] = FALSE;
  } // i
  ThreadCmdChannel = 0;
  ThreadCommand = ThreadCommandNone;
  ThreadCommandOk = TRUE;
  ThreadCommandError = ThreadCommandErrorNone;

  ThreadMeasureOk = FALSE;
  ThreadMeasureFinished = TRUE;
  ThreadMeasureError = FALSE;
  ThreadMeasureErrorFlag = FALSE;

  MeasureInitFunction ();

  ThreadIsRunning = TRUE;
  while (ThreadIsRunning == TRUE) {
	  if (!ThreadMeasureError) {
		  MeasureCommandFunction ();
		  MeasureExecFunction ();
	  }
	  if (ThreadMeasureError == TRUE)
		  MeasureErrorFunction ();
	  if (ThreadExit == TRUE)
		  ThreadIsRunning = FALSE;
  } // while (ThreadIsRunning)

  MeasureDoneFunction ();

  ThreadExitOk = TRUE;
  return NULL;
} // generic_measure_function

extern void
ThreadCommandSend (int ThreadCmd, int TOMultiplicator, int CmdChannel) {
int TOCounter;

  ThreadCommandOk = FALSE;
  ThreadCommand = ThreadCmd;
  ThreadCmdChannel = CmdChannel;

  ThreadCommandError = ThreadCommandErrorTimeOut;
  TOCounter = 100;
  if (TOMultiplicator > 0) TOCounter *= TOMultiplicator;
  while ((!ThreadCommandOk) && (TOCounter)) {
	  TOCounter--;
	  usleep (10000);
	  PRINTF ("TOCounter is %d\n", TOCounter);
  }
  if (!TOCounter) return;
  ThreadCommandError = ThreadCommandErrorNone;
} // ThreadCommandSend

extern void
GenericCommandFunction (void) {
  switch (ThreadCommand) {
	  case ThreadCommandNone :
		  break;
	  case ThreadCommandStart :
		  ThreadStatus[ThreadCmdChannel] = ThreadStatusStart;
		  ThreadMeasureOk = FALSE;
		  ThreadMeasureFinished = FALSE;
		  break;
	  case ThreadCommandStop :
		  ThreadStopFlag[ThreadCmdChannel] = TRUE;
		  break;
	  case ThreadCommandConvert :
		  ThreadStatus[ThreadCmdChannel] = ThreadStatusConvert;
		  break;
	  case ThreadCommandFinish :
		  ThreadStatus[ThreadCmdChannel] = ThreadStatusFinish;
		  break;
	  case ThreadCommandSuspend :
		  ThreadSuspendFlag[ThreadCmdChannel] = TRUE;
		  ThreadCommandOk = TRUE;
		  break;
	  case ThreadCommandContinue :
		  ThreadSuspendFlag[ThreadCmdChannel] = FALSE;
		  if (ThreadStatus[ThreadCmdChannel] != ThreadStatusSuspended)
			  ThreadCommandOk = TRUE;
		  break;
	  case ThreadCommandCancel :
		  ThreadStatus[ThreadCmdChannel] = ThreadStatusCancelled;
		  break;
	  case ThreadCommandBreak :
		  ThreadBreakFlag[ThreadCmdChannel] = TRUE;
		  break;
	  case ThreadCommandTestIn :
	      if (ThreadStatus[ThreadCmdChannel] == ThreadStatusIdle)
	          ThreadStatus[ThreadCmdChannel] = ThreadStatusInTest;
		  break;
	  case ThreadCommandTestOut :
	      if (ThreadStatus[ThreadCmdChannel] == ThreadStatusInTest)
	          ThreadStatus[ThreadCmdChannel] = ThreadStatusCloseTest;
		  break;
  } // switch (ThreadCommand)
  ThreadCommand = ThreadCommandNone;
} // GenericCommandFunction

extern void
GenericErrorFunction (void) {
GtkWidget *MeasureWindow;

BT_INIT();

  if (!MainThreadLock) {
//	  printf ("### MainThreadLock error\n");
	  sprintf (BugTraceUserString, "MainThreadLock error");
	  BUGTRACE(BugTraceUserString);
	  usleep (100000);
	  return;
  } //!MainThreadLock

  MeasureWindow = MeasureWindows[0];
  if (MeasureWindow == NULL) return;

  if (ThreadMeasureErrorFlag) return;
  ThreadMeasureErrorFlag = TRUE;

  gdk_threads_enter ();
  ActivateWidget (MeasureWindow, "MeasureErrorButton", TRUE);
  gdk_flush ();
  gdk_threads_leave ();

} // GenericErrorFunction

gboolean
SRSEvent (int i, int SRS, gboolean Rst) {
static int ProcessIdx[MaxInstrument] = {0, 0, 0, 0};
int j,k;
int ChkSign;
gboolean SRSRetVal;

BT_INIT();

  SRSRetVal = FALSE;

  if (Rst) {
	  ProcessIdx[i] = 0;

	  for (j = 0; j < Chrom[i].ChromHead->Method.MeasureEvents.SRSEventNum[SRS]; j++)
		  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventMode[SRS][j] == ControlSignalModeOUT)
			  Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j] = Chrom[i].ChromHead->Method.MeasureEvents.SRSEventTime[SRS][j];

	  return SRSRetVal;
  } // Rst

  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventNum[SRS] == 0)
	  return TRUE;

  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventNum[SRS] == ProcessIdx[i]) {
	  SRSRetVal = TRUE;
	  for (j = 0; j < ProcessIdx[i]; j++)
		  if ((Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j] > 0) &&\
			  (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventMode[SRS][j] == ControlSignalModeOUT)) {
			  SRSRetVal = FALSE;
			  if (ADFreshData (i))
				  Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j]--;
			  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j] == 0)
				  ClrStandardSignal (i, Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][j]);
			  } // if StartEventPulse[j] != 0
  } else {
	  switch (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventMode[SRS][ProcessIdx[i]]) {
		  case ControlSignalModeIN:
			  if (GetStandardSignal (i, Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][ProcessIdx[i]]))
				  ProcessIdx[i]++;
			  break;
		  case ControlSignalModeOUT:
			  SetStandardSignal (i, Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][ProcessIdx[i]]);
			  ProcessIdx[i]++;
			  break;
		  case ControlSignalModeGET:
			  break;
		  case ControlSignalModeSET:
			  break;
		  case ControlSignalModeCHK:
			  ChkSign = GetStandardSignal (i, Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][ProcessIdx[i]]);
			  if (ChkSign) {
				  switch (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][ProcessIdx[i]]) {
					  case ControlSignal_IN_CheckSample:
						  Chrom[i].ChromHead->Method.MeasureParameters.SampleType = SampleTypeSample;
						  break;
					  case ControlSignal_IN_CheckStandard:
						  Chrom[i].ChromHead->Method.MeasureParameters.SampleType = SampleTypeStandard;
						  break;
					  case ControlSignal_IN_CheckControl:
						  Chrom[i].ChromHead->Method.MeasureParameters.SampleType = SampleTypeControl;
						  break;
					  case ControlSignal_IN_CheckRetControl:
						  Chrom[i].ChromHead->Method.MeasureParameters.SampleType = SampleTypeRetControl;
						  break;
				  } // switch
			  } // if ChkSign
			  ProcessIdx[i]++;
			  break;
		  case ControlSignalModeHOLD:
			  break;
	  } // 
	  if (ADFreshData (i)) {
		  if (ProcessIdx[i] < Chrom[i].ChromHead->Method.MeasureEvents.SRSEventNum[SRS]) {
			  if ((Chrom[i].ChromHead->Method.MeasureEvents.SRSEventMode[SRS][ProcessIdx[i]] == ControlSignalModeIN) &&\
				  (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][ProcessIdx[i]] > 0)) {
					  Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][ProcessIdx[i]]--;
					  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][ProcessIdx[i]] == 0) {
						  ProcessIdx[i]++;
						  // Set some ERROR flag here!
						  BUGTRACE ("GetStandardSignal TIMEOUT");
					  } // if StartEventPulse[ProcessIdx[i]] == 0
				  } // if IN && > 1
			  } // if ProcessIdx[i] < SRSEventNum
		  for (j = 0; j < ProcessIdx[i]; j++) {
			  if ((Chrom[i].ChromHead->Method.MeasureEvents.SRSEventMode[SRS][j] == ControlSignalModeOUT) &&\
				  (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j] > 0)) {
					  Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j]--;
					  if (Chrom[i].ChromHead->Method.MeasureEvents.SRSEventPulse[SRS][j] == 0)
						  ClrStandardSignal (i, Chrom[i].ChromHead->Method.MeasureEvents.SRSEventCode[SRS][j]);
				  } // if OUT && > 1
		  } // j - ProcessIdx[i] - Pulse
	  } // FreshData
  } // else

  return SRSRetVal;
} // SRSEvent

void
InitGradient (int Channel) {
  GradCounter[Channel] = 0;
  MeasureGradMaxFlow[Channel] = 1;
  MeasureGradFlow[Channel] = 0;
  MeasureGradRatio[Channel][0] = 0;
  MeasureGradRatio[Channel][1] = 0;
  MeasureGradRatio[Channel][2] = 0;
  MeasureGradRatio[Channel][3] = 0;

  if (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientEnable) {
    if (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientEventNum > 0) {
      MeasureGradMaxFlow[Channel] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientMaxFlowRate;
      MeasureGradFlow[Channel] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientFlow[0];
      MeasureGradRatio[Channel][0] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[0][0];
      MeasureGradRatio[Channel][1] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[0][1];
      MeasureGradRatio[Channel][2] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[0][2];
      MeasureGradRatio[Channel][3] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[0][3];
      NewGradValue[Channel] = TRUE;
      SetGradient (Channel);
    } // if GradientEventNum > 0
  } // if GradientEnable
} // InitGradient

void
CalculateGradient (int Channel) {
int i;
int GradTick;
int GradNum;
double GradRatio;
double BaseVal;

  GradNum = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientEventNum;
  GradCounter[Channel] = 0;
  MeasureGradMaxFlow[Channel] = 1;
  MeasureGradFlow[Channel] = 0;
  MeasureGradRatio[Channel][0] = 0;
  MeasureGradRatio[Channel][1] = 0;
  MeasureGradRatio[Channel][2] = 0;
  MeasureGradRatio[Channel][3] = 0;

  if (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientEnable) {
    if (GradNum > 1) {
      for (i = 0; i < GradNum - 1; i++) {
        GradTick = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[i] * 60 * 10;
//if (MeasureTickCounter[Channel] % 20 == 0)
//  printf ("i = %d,  GradTick = %d,  MeasureTickCounter = %d\n",i ,GradTick , MeasureTickCounter[Channel]);
        if (MeasureTickCounter[Channel] > GradTick)
          GradCounter[Channel] = i;
      } // i
      GradTick = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradNum - 1] * 60 * 10;
      if (MeasureTickCounter[Channel] >= GradTick) {
        MeasureGradFlow[Channel] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientFlow[GradNum - 1];
        MeasureGradRatio[Channel][0] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradNum - 1][0];
        MeasureGradRatio[Channel][1] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradNum - 1][1];
        MeasureGradRatio[Channel][2] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradNum - 1][2];
        MeasureGradRatio[Channel][3] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradNum - 1][3];
      } else {
        if (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradCounter[Channel]] == Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradCounter[Channel] + 1])
          GradRatio = 0;
        else
          GradRatio = (((double)MeasureTickCounter[Channel] / 60.0 / 10.0) -\
                       Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradCounter[Channel]]) / \
                      (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradCounter[Channel] + 1] -\
                       Chrom[Channel].ChromHead->Method.MeasureEvents.GradientTime[GradCounter[Channel]]);
          BaseVal = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientFlow[GradCounter[Channel]];
          MeasureGradFlow[Channel] = BaseVal +\
                                     (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientFlow[GradCounter[Channel] + 1] -\
                                      Chrom[Channel].ChromHead->Method.MeasureEvents.GradientFlow[GradCounter[Channel]]) * GradRatio;
          BaseVal = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][0];
          MeasureGradRatio[Channel][0] = BaseVal +\
                                     (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel] + 1][0] -\
                                      Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][0]) * GradRatio;
          BaseVal = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][1];
          MeasureGradRatio[Channel][1] = BaseVal +\
                                     (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel] + 1][1] -\
                                      Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][1]) * GradRatio;
          BaseVal = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][2];
          MeasureGradRatio[Channel][2] = BaseVal +\
                                     (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel] + 1][2] -\
                                      Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][2]) * GradRatio;
          BaseVal = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][3];
          MeasureGradRatio[Channel][3] = BaseVal +\
                                     (Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel] + 1][3] - \
                                      Chrom[Channel].ChromHead->Method.MeasureEvents.GradientRatio[GradCounter[Channel]][3]) * GradRatio;
       } // if MeasureTickCounter[i] >= GradTick
      MeasureGradMaxFlow[Channel] = Chrom[Channel].ChromHead->Method.MeasureEvents.GradientMaxFlowRate;
/*
if (MeasureTickCounter[Channel] % 20 == 0) {
printf ("GradCounter[Channel] = %d   ", GradCounter[Channel]);
printf ("GradRatio = %.3f   ", GradRatio);
printf ("Flow = %.3f   ", MeasureGradFlow[Channel]);
printf ("A = %.3f   ", MeasureGradRatio[Channel][0]);
printf ("B = %.3f\n", MeasureGradRatio[Channel][1]);
}
*/
      NewGradValue[Channel] = TRUE;
      SetGradient (Channel);
    } // if GradientEventNum > 0
  } // if GradientEnable
} // CalculateGradient

extern void
GenericDataAcqExecFunction (void) {
static FILE			*RawFile[MaxInstrument];
static int			RawFileError[MaxInstrument];
char				*RawFileName;
static FILE			*InfFile[MaxInstrument];
static int			InfFileError[MaxInstrument];
char				*InfFileName;
static int			AccumCounter[MaxInstrument];
static int			AccumValue[MaxInstrument][MaxDetectors];
static int			TestData[MaxInstrument] = {0, 0, 0, 0};
int					*ChromDataArrayMeasure;
int					i,j,k;
static gboolean		ProcessReady[MaxInstrument] = {FALSE, FALSE, FALSE, FALSE};

BT_INIT();

  ContactAD ();

  for (i = 0; i < WorkInstruments.NumOfInstrument; i++) {
	  switch (ThreadStatus[i]) {
		  case ThreadStatusIdle :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusIdle");
			  pthread_mutex_lock (&measure_data_mutex);
			  if (ADFreshData (i)) {
				  ReallocChromData (MeasureTickCounter[i], i);
				  for (j = 0; j < WorkInstrument[i].NumDetectors; j++) {
					  ChromDataArrayMeasure = Chrom[i].ChromDataArrays[j];
					  ChromDataArrayMeasure[MeasureTickCounter[i]] = MeasureDataValue[i][j];
				  } // j
				  TestData[i]++;
				  MeasureTickCounter[i]++;
				  if (MeasureTickCounter[i] == 6000)
					  MeasureTickCounter[i] = 0;
			  } // ADFreshData
			  pthread_mutex_unlock (&measure_data_mutex);
			  if (ThreadBreakFlag[i]) ThreadStatus[i] = ThreadStatusUserBreak;
			  if (ThreadStopFlag[i]) ThreadStatus[i] = ThreadStatusUserBreak;
			break; // ThreadStatusIdle
		  case ThreadStatusStart :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusStart");
			  prepare_run (&i);
			  pthread_mutex_lock (&measure_data_mutex);
			  MeasureDataCounter[i] = 0;
			  MeasureTickCounter[i] = 0;
			  AccumCounter[i] = 0;
			  for (j = 0; j < MaxDetectors; j++)
				  AccumValue[i][j] = 0;
			  RawFileError[i] = FALSE;
			  InfFileError[i] = FALSE;
			  pthread_mutex_unlock (&measure_data_mutex);
			  ThreadCommandOk = TRUE;
			  TestData[i] = 0;
			  ProcessReady[i] = SRSEvent (i, SRSStart, SRSInit);
			  ThreadStatus[i] = ThreadStatusStartProcess;
			  ConvertProcessParameters (&Chrom[i].ChromHead->Method);
			  break; // ThreadStatusStart
		  case ThreadStatusStartProcess :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusStartProcess");
			  ProcessReady[i] = SRSEvent (i, SRSStart, SRSWork);
			  if (ProcessReady[i]) {
				  ProcessReady[i] = SRSEvent (i, SRSRun, SRSInit);
				  ThreadStatus[i] = ThreadStatusStartExec;
				  Chrom[i].ChromHead->Method.MeasureParameters.StartTime = time (NULL);
			  }
			  if (ThreadBreakFlag[i]) ThreadStatus[i] = ThreadStatusUserBreak;
			  if (ThreadStopFlag[i]) ThreadStatus[i] = ThreadStatusUserBreak;
			  break; // ThreadStatusStartProcess
		  case ThreadStatusStartExec :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusStartExec");
			  RawFileName = alloca (FilenameLength);
			  InfFileName = alloca (FilenameLength);
			  pthread_mutex_lock (&measure_parameter_mutex);
			  GenerateBaseName (&i);
			  AssembleMeasureFilename (&i);
			  strcpy (RawFileName, Options[i].MeasureRawName);
			  strcpy (InfFileName, Options[i].MeasureRawName);
			  strcpy (Chrom[i].InfoName, Options[i].MeasureFilename);
			  pthread_mutex_unlock (&measure_parameter_mutex);
			  strcat (RawFileName, ".raw");
			  strcat (InfFileName, ".inf");
			  RawFile[i] = fopen (RawFileName, "w");
			  InfFile[i] = fopen (InfFileName, "w");
			  if (RawFile[i] == NULL) RawFileError[i] = TRUE;
			  if (InfFile[i] == NULL) InfFileError[i] = TRUE;
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Start time = %d\n", Chrom[i].ChromHead->Method.MeasureParameters.StartTime);
			  ThreadStatus[i] = ThreadStatusRun;
			  HandleMeasureWidgets (&i);
			  InitGradient (i);
			  break; // ThreadStatusStartExec
		  case ThreadStatusRun :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusRun");
			  ThreadStatus[i] = ThreadStatusRunProcess;
			  pthread_mutex_lock (&measure_data_mutex);
			  if (ADFreshData (i)) {
				  ReallocChromData (MeasureDataCounter[i], i);
				  for (j = 0; j < MaxDetectors; j++) {
					  AccumValue[i][j] += MeasureDataValue[i][j];
				  } // j
				  AccumCounter[i]++;
				  if (AccumCounter[i] == Chrom[i].ChromHead->Method.ADParameters.ADSamplingAccumulationTable[Chrom[i].ChromHead->Method.MeasureParameters.SamplingRateIdx]) {
					  for (j = 0; j < MaxDetectors; j++) {
						  ChromDataArrayMeasure = Chrom[i].ChromDataArrays[j];
						  ChromDataArrayMeasure[MeasureDataCounter[i]] = AccumValue[i][j] / AccumCounter[i];
						  AccumValue[i][j] = 0;
						  if (!RawFileError[i]) fprintf (RawFile[i], "%d ", ChromDataArrayMeasure[MeasureDataCounter[i]]);
					  } // j
					  MeasureDataCounter[i]++;
					  AccumCounter[i] = 0;
					  if (!RawFileError[i]) fprintf (RawFile[i], "\n");
				  } // if AccumCounter
				  TestData[i]++;
				  MeasureTickCounter[i]++;
				  if ((Chrom[i].ChromHead->Method.MeasureParameters.ForcedStopTick == MeasureDataCounter[i]) && \
					  (Chrom[i].ChromHead->Method.MeasureParameters.ForcedStop))
					  ThreadStatus[i] = ThreadStatusStop;
			    CalculateGradient (i);
			  } // ADFreshData
			  pthread_mutex_unlock (&measure_data_mutex);
			  if (ThreadBreakFlag[i]) ThreadStatus[i] = ThreadStatusStop;
			  if (ThreadStopFlag[i]) ThreadStatus[i] = ThreadStatusStop;
			  break; // ThreadStatusRun
		  case ThreadStatusRunProcess :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusRunProcess");
			  ProcessReady[i] = SRSEvent (i, SRSRun, SRSWork);
			  ThreadStatus[i] = ThreadStatusRun;
			  break; // ThreadStatusRunProcess
		  case ThreadStatusStop :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusStop");
			  Chrom[i].ChromHead->Method.MeasureParameters.StopTime = time (NULL);
			  pthread_mutex_lock (&measure_parameter_mutex);
			  Chrom[i].ChromHead->Method.MeasureParameters.Nmp = MeasureDataCounter[i];
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Data points = %d\n", Chrom[i].ChromHead->Method.MeasureParameters.Nmp);
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Sampling rate = %.3f\n", Chrom[i].ChromHead->Method.MeasureParameters.SamplingRate);
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Cycle = %d\n", Chrom[i].ChromHead->Method.MeasureParameters.Cycle);
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Forced stop time = %.3f\n", Chrom[i].ChromHead->Method.MeasureParameters.ForcedStopTime);
			  if (!InfFileError[i])
				  fprintf (InfFile[i], "Forced stop ticks = %d\n", Chrom[i].ChromHead->Method.MeasureParameters.ForcedStopTick);
			  strcpy (Chrom[i].LastName, Options[i].MeasureFilename);
			  strcpy (Chrom[i].InfoName, "");
			  pthread_mutex_unlock (&measure_parameter_mutex);
			  pthread_mutex_lock (&measure_data_mutex);
			  MeasureTickCounter[i] = 0;
			  MeasureDataCounter[i] = 0;
			  pthread_mutex_unlock (&measure_data_mutex);
			  if (!RawFileError[i]) fclose (RawFile[i]);
			  if (!InfFileError[i]) fclose (InfFile[i]);
			  ProcessReady[i] = SRSEvent (i, SRSStop, SRSInit);
			  ThreadStatus[i] = ThreadStatusStopProcess;
			  InitGradient (i);
			  break; // ThreadStatusStop
		  case ThreadStatusStopProcess :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusStopProcess");
			  ProcessReady[i] = SRSEvent (i, SRSStop, SRSWork);
			  if (ProcessReady[i]) {
				  ThreadMeasureFinished = TRUE;
				  ThreadStatus[i] = ThreadStatusWait;
				  pthread_mutex_lock (&measure_parameter_mutex);
				  MeasureStopped (&i);
				  pthread_mutex_unlock (&measure_parameter_mutex);
				  ThreadCommandOk = TRUE;
			  }
			  break; // ThreadStatusStopProcess
		  case ThreadStatusConvert :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusConvert");
			  convert_done[i] = FALSE;
			  convert_i[i] = i;
			  pthread_create (&convert_threads[i], NULL, (void *)convert_generic_acq_data, (void *)&convert_i[i]);
			  ThreadStatus[i] = ThreadStatusConvertExec;
			  break; // ThreadStatusConvert
		  case ThreadStatusConvertExec :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusConvertExec");
			  if (convert_done[i]) {
				  pthread_join (convert_threads[i], NULL);
				  ThreadMeasureFinished = TRUE;
				  ThreadStatus[i] = ThreadStatusConvertWait;
			  } // convert_done
			  break; // ThreadStatusConvertExec
		  case ThreadStatusConvertWait :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusConvertWait");
			  switch (Options[i].DataAcqMode) {
				  case MeasureRunModeUnique:
					  ThreadStatus[i] = ThreadStatusPrepareNext;
					  break;
				  case MeasureRunModeQueue:
					  ThreadStatus[i] = ThreadStatusPrepareNext;
					  if (ThreadStopFlag[i]) ThreadSuspendFlag[i] = TRUE;
					  CheckManualQueueContinue (&i);
					  if (ThreadSuspendFlag[i]) {
						  ThreadStopFlag[i] = FALSE;
						  ThreadStatus[i] = ThreadStatusSuspended;
						  HandleMeasureWidgets (&i);
					  } // if ThreadSuspendFlag
					  break;
				  case MeasureRunModeContinous:
					  ThreadStatus[i] = ThreadStatusPrepareNext;
					  if (ThreadStopFlag[i]) {
						  ThreadMeasureOk = TRUE;
						  ThreadStatus[i] = ThreadStatusIdle;
						  ThreadCommandOk = TRUE;
						  ThreadStopFlag[i] = FALSE;
						  HandleMeasureWidgets (&i);
					  } // if ThreadStopFlag
					  break;
			  } // switch Options[i].DataAcqMode
			  break; // ThreadStatusConvertWait
		  case ThreadStatusPrepareNext:
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusPrepareNext");
			  prepare_next_done[i] = FALSE;
			  prepare_next_i[i] = i;
			  pthread_create (&prepare_next_threads[i], NULL, (void *)prepare_next_run, (void *)&prepare_next_i[i]);
			  ThreadStatus[i] = ThreadStatusPrepareNextWait;
			  break; // ThreadStatusPrepareNext
		  case ThreadStatusPrepareNextWait:
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusPrepareNextWait");
			  if (prepare_next_done[i]) {
				  pthread_join (prepare_next_threads[i], NULL);
				  switch (Options[i].DataAcqMode) {
					  case MeasureRunModeUnique:
						  ThreadMeasureOk = TRUE;
						  ThreadStopFlag[i] = FALSE;
						  ThreadStatus[i] = ThreadStatusIdle;
						  HandleMeasureWidgets (&i);
						  ThreadCommandOk = TRUE;
						  break; // MeasureRunModeUnique
					  case MeasureRunModeQueue:
						  ThreadMeasureFinished = TRUE;
						  ThreadStatus[i] = ThreadStatusStart;
						  if (ThreadFinishFlag[i]) {
							  ThreadStatus[i] = ThreadStatusIdle;
							  ThreadFinishFlag[i] = FALSE;
							  HandleMeasureWidgets (&i);
							  ThreadCommandOk = TRUE;
						  } // if ThreadFinishFlag
						  break; // MeasureRunModeQueue
					  case MeasureRunModeContinous:
						  ThreadMeasureFinished = TRUE;
						  ThreadStatus[i] = ThreadStatusStart;
						  if (ThreadFinishFlag[i]) {
							  ThreadStatus[i] = ThreadStatusIdle;
							  HandleMeasureWidgets (&i);
							  ThreadFinishFlag[i] = FALSE;
							  ThreadCommandOk = TRUE;
						  } // if ThreadFinishFlag
						  break; // MeasureRunModeContinous
				  } // switch Options[i].DataAcqMode
			  } // prepare_next_done
			  break; // ThreadStatusPrepareNextWait
		  case ThreadStatusWait :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusWait");
			  pthread_mutex_lock (&measure_parameter_mutex);
			  switch (Options[i].DataAcqMode) {
				  case MeasureRunModeUnique:
					  if (Chrom[i].ChromHead->Method.MeasureParameters.AutoFinish)
						  ThreadStatus[i] = ThreadStatusConvert;
					  if (ThreadStopFlag[i]) ThreadStatus[i] = ThreadStatusConvert;
					  break;
				  case MeasureRunModeQueue:
					  ThreadStatus[i] = ThreadStatusConvert;
					  break;
				  case MeasureRunModeContinous:
					  ThreadStatus[i] = ThreadStatusConvert;
					  break;
			  } // switch Options[i].DataAcqMode
			  if (ThreadBreakFlag[i]) ThreadStatus[i] = ThreadStatusUserBreak;
			  pthread_mutex_unlock (&measure_parameter_mutex);
			  break; // ThreadStatusWait
		  case ThreadStatusFinish :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusFinish");
			  ThreadMeasureOk = TRUE;
			  ThreadSuspendFlag[i] = FALSE;
			  ThreadStatus[i] = ThreadStatusIdle;
			  ThreadCommandOk = TRUE;
			  break; // ThreadStatusFinish
		  case ThreadStatusSuspended :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusSuspended");
			  switch (Options[i].DataAcqMode) {
				  case MeasureRunModeUnique:
					  ThreadStatus[i] = ThreadStatusIdle;
					  break;
				  case MeasureRunModeQueue:
					  if (!ThreadSuspendFlag[i]) {
						  ThreadStatus[i] = ThreadStatusPrepareNext;
						  ThreadCommandOk = TRUE;
					  }
					  break;
				  case MeasureRunModeContinous:
					  ThreadStatus[i] = ThreadStatusIdle;
					  break;
			  } // switch Options[i].DataAcqMode
			  break; // ThreadStatusSuspended
		  case ThreadStatusCancelled :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusCancelled");
			  ThreadStatus[i] = ThreadStatusIdle;
			  ThreadCommandOk = TRUE;
			  break; // ThreadStatusCancelled
		  case ThreadStatusUserBreak :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusUserBreak");
			  ThreadBreakFlag[i] = FALSE;
			  ThreadStopFlag[i] = FALSE;
			  switch (Options[i].DataAcqMode) {
				  case MeasureRunModeUnique:
					  ThreadStatus[i] = ThreadStatusIdle;
					  break;
				  case MeasureRunModeQueue:
					  ThreadStatus[i] = ThreadStatusSuspended;
					  ThreadSuspendFlag[i] = TRUE;
					  break;
				  case MeasureRunModeContinous:
					  ThreadStatus[i] = ThreadStatusIdle;
					  break;
			  } // switch Options[i].DataAcqMode
			  ThreadCommandOk = TRUE;
			  HandleMeasureWidgets (&i);
			  break; // ThreadStatusUserBreak
		  case ThreadStatusInTest :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusInTest");
		  	  if (NewGradValue[i]) {
		  	    SetGradient (i);
		  	    printf ("NewGradTestValue\n");
		  	  } // if
		  	  if (NewGradCheck[i]) {
		  	    SetGradient (i);
		  	    printf ("NewGradTestCheck\n");
		  	  } // if
			  ThreadCommandOk = TRUE;
			  break; // ThreadStatusCancelled
		  case ThreadStatusCloseTest :
			  if (ADTraceStatusGetNow) ADTraceStatusFunc (ThreadStatus[i], i, "ThreadStatusCloseTest");
			  ThreadStatus[i] = ThreadStatusIdle;
			  ThreadCommandOk = TRUE;
			  break; // ThreadStatusCancelled
	  } // switch ThreadStatus[i]
  } // i
} // GenericDataAcqExecFunction

extern void
HandleMeasureWidgets (int *convert_channel) {
int ConvChan;

  ConvChan = *convert_channel;

  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  gdk_threads_enter ();
		  RefreshMeasureQueueList (ConvChan); // measure_parameter_mutex is locked inside!
		  gdk_flush ();
		  gdk_threads_leave ();
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  switch (Options[ConvChan].RestartMode) {
			  case ContinousRestartChrom:
				  break;
			  case ContinousRestartTime:
				  break;
		  } // switch RestartMode
		  break; // MeasureRunModeContinous
  } // switch Options[ConvChan].DataAcqMode
  gdk_threads_enter ();
  ActivateMeasureWidgets (ConvChan);
  gdk_flush ();
  gdk_threads_leave ();
} // HandleMeasureWidgets

extern void
CheckManualQueueContinue (int *convert_channel) {
int ConvChan;
BT_INIT();

  ConvChan = *convert_channel;
  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  GetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed - 1); // in MeasureStopped was ++-ed QueueItemClosed
		  if (Chrom[ConvChan].QueueItem.ManualStepForward)
			  ThreadSuspendFlag[ConvChan] = TRUE;
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  break; // MeasureRunModeContinous
  } // switch Options[i].DataAcqMode

  sprintf (BugTraceUserString, "CheckManualQueueContinue = %d, %s", Chrom[ConvChan].QueueItem.ManualStepForward, Options[ConvChan].MeasureFilename);
  BUGTRACE(BugTraceUserString);
} // CheckManualQueueContinue

extern void
MeasureStopped (int *convert_channel) {
int ConvChan;
BT_INIT();

  ConvChan = *convert_channel;
  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  GetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  Chrom[ConvChan].QueueItem.QueueItemMeasured = TRUE;
		  SetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  Chrom[ConvChan].QueueHead.QueueItemClosed++;
		  QueueSave (ConvChan);
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  break; // MeasureRunModeContinous
  } // switch Options[i].DataAcqMode

  sprintf (BugTraceUserString, "MeasureStopped OK, %s", Options[ConvChan].MeasureFilename);
  BUGTRACE(BugTraceUserString);
} // MeasureStopped

extern void
AssembleMeasureFilename (int *convert_channel) {
int ConvChan;
BT_INIT();

  ConvChan = *convert_channel;

  strcpy (Options[ConvChan].MeasureFilename, getenv ("HOME"));
  strcat (Options[ConvChan].MeasureFilename, "/LabChrom_Rescue_Asm/");
  if (CheckDirName (Options[ConvChan].MeasureDataDir)) {
	  strcpy (Options[ConvChan].MeasureFilename, Options[ConvChan].MeasureDataDir);
  } else {
	  mkdir (Options[ConvChan].MeasureFilename, 0777);
  } // if MeasureDataDir
  strcpy (Options[ConvChan].MeasureRawDir, Options[ConvChan].MeasureFilename);
  strcat (Options[ConvChan].MeasureRawDir, "Raw/");
  if (!CheckDirName (Options[ConvChan].MeasureRawDir))
	  mkdir (Options[ConvChan].MeasureRawDir, 0777);
  strcpy (Options[ConvChan].MeasureRawName, Options[ConvChan].MeasureRawDir);

  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  strcat (Options[ConvChan].MeasureFilename, Options[ConvChan].MeasureBaseName);
		  strcat (Options[ConvChan].MeasureRawName, Options[ConvChan].MeasureBaseName);
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  GetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  strcat (Options[ConvChan].MeasureFilename, "Data/");
		  strcat (Options[ConvChan].MeasureFilename, Chrom[ConvChan].QueueItem.FinalFilename);
		  strcat (Options[ConvChan].MeasureRawName, Chrom[ConvChan].QueueItem.FinalFilename);
		  strcpy (Chrom[ConvChan].QueueItem.FinalFilename, Options[ConvChan].MeasureFilename);
		  SetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  QueueSave (ConvChan);
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  switch (Chrom[ConvChan].ChromHead->Method.MeasureParameters.SampleType) {
			  case SampleTypeSample:
				  break;
			  case SampleTypeControl:
				  strcat (Options[ConvChan].MeasureFilename, "Control/");
				  break;
			  case SampleTypeStandard:
				  strcat (Options[ConvChan].MeasureFilename, "Standard/");
				  break;
			  case SampleTypeRetControl:
				  strcat (Options[ConvChan].MeasureFilename, "RetControl/");
				  break;
		  } // switch SampleType
		  strcat (Options[ConvChan].MeasureFilename, Options[ConvChan].MeasureBaseName);
		  strcat (Options[ConvChan].MeasureRawName, Options[ConvChan].MeasureBaseName);
		  break; // MeasureRunModeContinous
  } // switch Options[i].DataAcqMode
  sprintf (BugTraceUserString, "MeasureFilename assembled : %s", Options[ConvChan].MeasureFilename);
  BUGTRACE(BugTraceUserString);
} // AssembleMeasureFilename

extern void
GenerateWorkDir (int *convert_channel) {
int ConvChan;
time_t *ConvTime;
struct tm *ConvLocalTime;
char *TmpDir;
char *QuantiDir;
BT_INIT();

  ConvChan = *convert_channel;
  ConvTime = alloca (sizeof(time_t));
  ConvLocalTime = alloca (sizeof(struct tm));
  QuantiDir = alloca (1200);
  TmpDir = alloca (1200);

  if (Options[ConvChan].GenerateWorkDir) {
	  if (CheckDirName (Options[ConvChan].DefaultDataRootDir)) {
		  strcpy (Options[ConvChan].MeasureDataDir, Options[ConvChan].DefaultDataRootDir);
	  } else {
		  sprintf (BugTraceUserString, "DefaultDataRootDir: %s FAILED", Options[ConvChan].DefaultDataRootDir);
		  BUGTRACE (BugTraceUserString);
		  strcpy (Options[ConvChan].MeasureDataDir, getenv ("HOME"));
		  strcat (Options[ConvChan].MeasureDataDir, "/LabChrom_Rescue/");
		  mkdir (Options[ConvChan].MeasureDataDir, 0777);
	  } // if DefaultDataRootDir

	  time (ConvTime);
	  localtime_r (ConvTime, ConvLocalTime);
	
	  sprintf (TmpDir, "%s%d/", Options[ConvChan].MeasureDataDir, ConvLocalTime->tm_year + 1900);
	  mkdir (TmpDir, 0777);
	  if (DirExist (TmpDir)) {
		  strcpy (Options[ConvChan].MeasureDataDir, TmpDir);
	  } // if DirExist
	
	  sprintf (TmpDir, "%s%.2d/", Options[ConvChan].MeasureDataDir, ConvLocalTime->tm_mon + 1);
	  mkdir (TmpDir, 0777);
	  if (DirExist (TmpDir)) {
		  strcpy (Options[ConvChan].MeasureDataDir, TmpDir);
	  } // if DirExist
	
	  sprintf (TmpDir, "%s%.2d/", Options[ConvChan].MeasureDataDir, ConvLocalTime->tm_mday);
	  mkdir (TmpDir, 0777);
	  if (DirExist (TmpDir)) {
		  strcpy (Options[ConvChan].MeasureDataDir, TmpDir);
	  } // if DirExist
  } // if GenerateWorkDir

  strcpy (QuantiDir, Options[ConvChan].MeasureDataDir);
  strcat (QuantiDir, "Raw/");
  mkdir (QuantiDir, 0777);
  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  if (Chrom[ConvChan].QueueHead.AddSubfolder) {
			  sprintf (TmpDir, "%s%s/", Options[ConvChan].MeasureDataDir, Chrom[ConvChan].QueueHead.BaseName);
			  mkdir (TmpDir, 0777);
			  if (DirExist (TmpDir))
				  strcpy (Options[ConvChan].MeasureDataDir, TmpDir);
		  } // if AddSubfolder
		  strcpy (QuantiDir, Options[ConvChan].MeasureDataDir);
		  strcat (QuantiDir, "Data/");
		  mkdir (QuantiDir, 0777);
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  strcpy (QuantiDir, Options[ConvChan].MeasureDataDir);
		  strcat (QuantiDir, "Control/");
		  mkdir (QuantiDir, 0777);
		  strcpy (QuantiDir, Options[ConvChan].MeasureDataDir);
		  strcat (QuantiDir, "RetControl/");
		  mkdir (QuantiDir, 0777);
		  strcpy (QuantiDir, Options[ConvChan].MeasureDataDir);
		  strcat (QuantiDir, "Standard/");
		  mkdir (QuantiDir, 0777);
		  break; // MeasureRunModeContinous
  } // switch

  if (!DirExist (Options[ConvChan].MeasureDataDir)) {
	  strcpy (Options[ConvChan].MeasureDataDir, getenv ("HOME"));
	  strcat (Options[ConvChan].MeasureDataDir, "/LabChrom_Rescue/");
	  mkdir (Options[ConvChan].MeasureDataDir, 0777);
  }
  printf ("\n### Options[ConvChan].MeasureDataDir = %s\n\n", Options[ConvChan].MeasureDataDir);
} // GenerateWorkDir

extern void
GenerateBaseName (int *convert_channel) {
int ConvChan;
struct tm *ConvLocalTime;
char *TmpName;
char *TmpNameErr;
char *TmpNameDate;
char *TmpExt;
BT_INIT();

  ConvChan = *convert_channel;
  ConvLocalTime = alloca (sizeof(struct tm));
  TmpName = alloca (1200);
  TmpNameErr = alloca (1200);
  TmpNameDate = alloca (1200);
  TmpExt = alloca (200);

  localtime_r (&Chrom[ConvChan].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);

  sprintf (Options[ConvChan].MeasureBaseName, "%d.%.2d.%.2d.%.2d.%.2d.%.2d", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
			ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);

  if (Chrom[ConvChan].Method.MeasureParameters.NameSettingsUse) {
	  strcpy (TmpName, Chrom[ConvChan].Method.MeasureParameters.NamePrefix);
	  switch (Chrom[ConvChan].Method.MeasureParameters.NameDateMode) {
		  case NameDefaultDateNone:
			  strcpy (TmpNameDate, "");
			  break;
		  case NameDefaultDateDay:
			  sprintf (TmpNameDate, "%d.%.2d.%.2d", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday);
			  break;
		  case NameDefaultDateSec:
			  sprintf (TmpNameDate, "%d.%.2d.%.2d.%.2d.%.2d.%.2d", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
						ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
			  break;
	  }
	  strcat (TmpName, TmpNameDate);
	  strcat (TmpName, Chrom[ConvChan].Method.MeasureParameters.NameSuffix);
	  sprintf (TmpNameErr, "%d.%.2d.%.2d.%.2d.%.2d.%.2d_BaseNameError_Use", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
					ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
  } else {
	  strcpy (TmpName, Chrom[ConvChan].Method.MeasureParameters.ChromName);
	  sprintf (TmpNameErr, "%d.%.2d.%.2d.%.2d.%.2d.%.2d_BaseNameError_NoUse", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
				ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
  } // NameSettingsUse
  
  strcpy (TmpExt, "");
  if (Chrom[ConvChan].Method.MeasureParameters.ApplyExtension) {
	  if (strlen(TmpName) == 0)
		  sprintf (TmpExt, "%.4d", Chrom[ConvChan].ActualExtension);
	  else
		  sprintf (TmpExt, ".%.4d", Chrom[ConvChan].ActualExtension);
  } // ApplyExtension
  strcat (TmpName, TmpExt);
  if (strlen(TmpName) == 0)
	  strcpy (TmpName, TmpNameErr);
  strcpy (Options[ConvChan].MeasureBaseName, TmpName);
  strcat (Options[ConvChan].MeasureBaseName, ".chr");
  
} // GenerateBaseName

extern void*
prepare_run (int *convert_channel) {
int ConvChan;
int j;

  ConvChan = *convert_channel;

  memcpy (&Chrom[ConvChan].ChromHead->Method, &Chrom[ConvChan].Method, sizeof(struct MethodStruct));
  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  pthread_mutex_lock (&measure_parameter_mutex);
		  GetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  Chrom[ConvChan].QueueItem.QueueItemLocked = TRUE;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.SampleType = Chrom[ConvChan].QueueItem.SampleType;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardAutoCalibrate = Chrom[ConvChan].QueueItem.StandardAutoCalibrate;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardLevel = Chrom[ConvChan].QueueItem.StandardLevel;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardMode = Chrom[ConvChan].QueueItem.StandardMode;
		  for (j = 0; j < MaxDetectors; j++) {
			  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardFlagDet[j] = Chrom[ConvChan].QueueItem.StandardFlagDet[j];
			  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardLevelDet[j] = Chrom[ConvChan].QueueItem.StandardLevelDet[j];
			  Chrom[ConvChan].ChromHead->Method.MeasureParameters.StandardModeDet[j] = Chrom[ConvChan].QueueItem.StandardModeDet[j];
		  } // j
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.RetControlMode = Chrom[ConvChan].QueueItem.RetControlMode;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.Volume = Chrom[ConvChan].QueueItem.Volume;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.Amount = Chrom[ConvChan].QueueItem.Amount;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.Factor = Chrom[ConvChan].QueueItem.Factor;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.Pressure = Chrom[ConvChan].QueueItem.Pressure;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.Temperature = Chrom[ConvChan].QueueItem.Temperature;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.IstConc = Chrom[ConvChan].QueueItem.IstConc;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.ScaleFactor = Chrom[ConvChan].QueueItem.ScaleFactor;
		  Chrom[ConvChan].ChromHead->Method.MeasureParameters.InjectedVolume = Chrom[ConvChan].QueueItem.InjectedVolume;
		  SetQueueItem (ConvChan, Chrom[ConvChan].QueueHead.QueueItemClosed);
		  Chrom[ConvChan].QueueHead.QueueItemLocked++;
		  QueueSave (ConvChan);
		  pthread_mutex_unlock (&measure_parameter_mutex);
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  break; // MeasureRunModeContinous
  } // switch Options[i].DataAcqMode
} // prepare_run

extern void*
prepare_next_run (int *convert_channel) {
int ConvChan;
time_t *ConvTime;
struct tm *ConvLocalTime;
struct tm *ConvRestartTime;
static gboolean RestartedSeries[MaxInstrument] = {FALSE, FALSE, FALSE, FALSE};

BT_INIT();

  ConvChan = *convert_channel;
  ConvTime = alloca (sizeof(time_t));
  ConvLocalTime = alloca (sizeof(struct tm));
  ConvRestartTime = alloca (sizeof(struct tm));

  sprintf (BugTraceUserString, "prepare_next_run ENTER at channel %d", ConvChan);
  BUGTRACE(BugTraceUserString);

  pthread_mutex_lock (&measure_parameter_mutex);
  switch (Options[ConvChan].DataAcqMode) {
	  case MeasureRunModeUnique:
		  Chrom[ConvChan].ActualExtension++;
		  break; // MeasureRunModeUnique
	  case MeasureRunModeQueue:
		  if (Chrom[ConvChan].QueueHead.QueueItemClosed == Chrom[ConvChan].QueueHead.QueueItemNum)
			  ThreadFinishFlag[ConvChan] = TRUE;
		  QueueSave (ConvChan);
		  break; // MeasureRunModeQueue
	  case MeasureRunModeContinous:
		  sprintf (Options[ConvChan].MeasureFilename,"%s.%.3d", Options[ConvChan].MeasureBaseName, Chrom[ConvChan].ActualExtension);
		  Chrom[ConvChan].ActualExtension++;
		  if (Options[ConvChan].LimitedNumber) {
			  if (Chrom[ConvChan].ActualExtension == Options[ConvChan].LimitedNumOfChrom + 1)
				  ThreadFinishFlag[ConvChan] = TRUE;
		  } // if (Chrom[ConvChan].ActualExtension == Options[ConvChan].LimitedNumOfChrom)
		  else
		  switch (Options[ConvChan].RestartMode) {
			  case ContinousRestartChrom:
				  if ((Chrom[ConvChan].ActualExtension == Options[ConvChan].RestartChrom) || \
					  (Chrom[ConvChan].ActualExtension > Options[ConvChan].RestartChrom)) {
					  GenerateWorkDir(&ConvChan);
				  } // if ActualExtension
				  break;
			  case ContinousRestartTime:
				  time (ConvTime);
				  localtime_r (ConvTime, ConvLocalTime);
				  sprintf (BugTraceUserString, "Measure cont restart. Date: %d.%.2d.%.2d   Time: %.2d:%.2d:%.2d", \
						  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
						  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
				  printf ("%s\n", BugTraceUserString);
				  localtime_r (&Options[ConvChan].RestartTime, ConvRestartTime);
				  sprintf (BugTraceUserString, "Measure requested restart. Date: %d.%.2d.%.2d   Time: %.2d:%.2d:%.2d", \
						  ConvRestartTime->tm_year + 1900, ConvRestartTime->tm_mon + 1, ConvRestartTime->tm_mday, \
						  ConvRestartTime->tm_hour, ConvRestartTime->tm_min, ConvRestartTime->tm_sec);
				  printf ("%s\n", BugTraceUserString);
				  if (ConvLocalTime->tm_hour == ConvRestartTime->tm_hour) {
					  if (!RestartedSeries[ConvChan]) {
						  RestartedSeries[ConvChan] = TRUE;
						  GenerateWorkDir(&ConvChan);
						  Chrom[ConvChan].ActualExtension = 0;
						  printf ("--- Restart series, ConvLocalTime->tm_hour == ConvRestartTime->tm_hour\n");
					  } // if !RestartedSeries
				  } else {
					  RestartedSeries[ConvChan] = FALSE;
				  } // if ConvLocalTime->tm_hour == ConvRestartTime->tm_hour
				  break;
		  } // switch RestartMode
		  // Temporary here, Control sample controlling
		  break; // MeasureRunModeContinous
  } // switch Options[i].DataAcqMode
  pthread_mutex_unlock (&measure_parameter_mutex);

  prepare_next_done[ConvChan] = TRUE;

  sprintf (BugTraceUserString, "prepare_next_run DONE at channel %d", ConvChan);
  BUGTRACE(BugTraceUserString);
} // prepare_next_run

extern void*
convert_generic_acq_data (int *convert_channel) {
int			ConvChan;
int			j;
int			SampleType;
gchar		*MeasDirName;
gchar		*MeasFilName;
gchar		*SystemCommand;
gchar		*SystemCommandParameter;
char *ResultString;

BT_INIT();

  ConvChan = *convert_channel;
  SystemCommand = alloca (1000);
  bzero (SystemCommand, 1000);
  SystemCommandParameter = alloca (1000);
  bzero (SystemCommandParameter, 1000);

  sprintf (BugTraceUserString, "convert_generic_acq_data ENTER at channel %d", ConvChan);
  BUGTRACE(BugTraceUserString);

  Chrom[ConvChan].ChromHead->Method.Instrument = WorkInstrument[ConvChan];
  BUGTRACE("VERSION OK.");

  for (j = 0; j < Chrom[ConvChan].ChromHead->Method.Instrument.NumDetectors; j++) {
	  Chrom[ConvChan].ActualDetector = j;
	  SetChromParameters (ConvChan);
	  ReintegrateDBI (ConvChan);
  } // j
  Chrom[ConvChan].ActualDetector = 0;
  sprintf (BugTraceUserString, "ReintegrateDBI at channel %d OK.", ConvChan);
  BUGTRACE(BugTraceUserString);

  strcpy (Chrom[ConvChan].Filename, Options[ConvChan].MeasureFilename);
  strcpy (Chrom[ConvChan].ChrName, Options[ConvChan].MeasureFilename);
  strcpy (Options[ConvChan].MeasureLastName, Options[ConvChan].MeasureFilename);
  sprintf (BugTraceUserString, "Filename is: %s", Options[ConvChan].MeasureFilename);
  BUGTRACE (BugTraceUserString);
  
  Chrom[ConvChan].FileLoaded[ChrFlag] = TRUE;
  ChromSave (ConvChan);

  SampleType = Chrom[ConvChan].ChromHead->Method.MeasureParameters.SampleType;

  CalibrLoad (ConvChan, Chrom[ConvChan].ChromHead->Method.MeasureParameters.CalibrationName);
  Chrom[ConvChan].CalibrHead->SaveCalibrAfterMod = TRUE;

  switch (SampleType) {
	  case SampleTypeSample:
		  break;
	  case SampleTypeControl:
		  break;
	  case SampleTypeStandard:
		  NewChrom (ConvChan);
		  strcpy (Chrom[ConvChan].CalibrChrom->ChromName, Options[ConvChan].MeasureFilename);
		  AddChrom (0, ConvChan);
		  CalibrSave (ConvChan, Chrom[ConvChan].ChromHead->Method.MeasureParameters.CalibrationName);
		  break;
	  case SampleTypeRetControl:
		  strcpy (Chrom[ConvChan].CalibrHead->RetentiontemplateName, Options[ConvChan].MeasureFilename);
		  strcpy (Chrom[ConvChan].CalibrTemplateChromName, Chrom[ConvChan].CalibrHead->RetentiontemplateName);
		  CalibrTemplateChromLoad(ConvChan);
		  Chrom[ConvChan].CalibrHead->RetentionTemplateLoaded = Chrom[ConvChan].FileLoaded[TCrFlag];
		  CalibrSave (ConvChan, Chrom[ConvChan].ChromHead->Method.MeasureParameters.CalibrationName);
		  break;
  } // switch SampleType

  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].PostRunAnalyze) {
	  Analyze (ConvChan);
	  strcpy (Chrom[ConvChan].Filename, Options[ConvChan].MeasureFilename);
	  ChromSave (ConvChan);
	  printf ("PostRunAnalyze DONE.\n");
  } // PostRunAnalyze

  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].AutoPrint) {
	  gdk_threads_enter ();
	  switch (SampleType) {
		  case SampleTypeSample:
			  PrintFunction (PrintChromMode, GINT_TO_POINTER(ConvChan), GINT_TO_POINTER(ConvChan), FALSE);
			  break;
		  case SampleTypeControl:
			  PrintFunction (PrintChromMode/*PrintControlListMode*/, GINT_TO_POINTER(ConvChan), GINT_TO_POINTER(ConvChan), FALSE);
			  break;
		  case SampleTypeStandard:
			  PrintFunction (PrintChromMode, GINT_TO_POINTER(ConvChan), GINT_TO_POINTER(ConvChan), FALSE);
			  break;
		  case SampleTypeRetControl:
			  PrintFunction (PrintChromMode, GINT_TO_POINTER(ConvChan), GINT_TO_POINTER(ConvChan), FALSE);
			  break;
	  }  // switch SampleType
	  gdk_flush ();
	  gdk_threads_leave ();
	  printf ("PrintFunction (XXX_Mode, GINT_TO_POINTER(ConvChan), FALSE); OK.\n");
  } // 


  MeasDirName = g_path_get_dirname (Options[ConvChan].MeasureFilename);
  MeasFilName = g_path_get_basename (Options[ConvChan].MeasureFilename);
  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResultToFolder)
	  strcpy (Chrom[ConvChan].Filename, Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResultFolder);
  else
	  strcpy (Chrom[ConvChan].Filename, MeasDirName);
  if (Chrom[ConvChan].Filename[strlen (Chrom[ConvChan].Filename)-1] != '/')
	  strcat (Chrom[ConvChan].Filename, "/");
  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResultOnName)
	  strcat (Chrom[ConvChan].Filename, Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResultName);
  else
	  strcat (Chrom[ConvChan].Filename, MeasFilName);
  g_free (MeasFilName);
  g_free (MeasDirName);

  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResult) {
	  ResultString = NULL;
	  ResultString = GenerateFixExportString (WorkArea);
	  SaveResultList (ConvChan, ResultString);
	  if (ResultString != NULL) free (ResultString);
  } // if ExportResult

  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExecuteCommand) {
	  strcpy (SystemCommand, Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].CommandToCall);
	  strcat (SystemCommand, " ");
	  switch (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].CommandParameter) {
		  case 0:; // None
		  case 1:
			  MeasDirName = g_path_get_dirname (Options[ConvChan].MeasureFilename);
			  strcpy (SystemCommandParameter, MeasDirName);
			  g_free (MeasDirName);
			  break; // Work directory
		  case 2:
			  strcpy (SystemCommandParameter, Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExportResultFolder);
			  break; // Specified result folder
		  case 3:
			  strcpy (SystemCommandParameter, Chrom[ConvChan].ChrName);
			  break; // Chromatogram name
		  case 4:
			  strcpy (SystemCommandParameter, Chrom[ConvChan].Filename);
			  break; // Result name
	  } // switch CommandParameter
	  strcat (SystemCommand, SystemCommandParameter);

	  sprintf (BugTraceUserString, "System command call: %s; at channel: %d", SystemCommand, ConvChan);
	  BUGTRACE(BugTraceUserString);

	  if (Chrom[ConvChan].ChromHead->Method.MeasureParameters.PostRunOptions[SampleType].ExecuteCommand)
		  system (SystemCommand);
	  } // ExecuteCommand

  convert_done[ConvChan] = TRUE;
} // convert_generic_acq_data

//
// Instrument specific measure functions
//

extern void
ConvertProcessParameters (struct MethodStruct *ConvMet) {
/*
Converts the Measure parameters control event set to
Measure events type control events, that is applicable directly to drive the AD driver.
*/
int i,iStep;

  printf ("\n--- ConvertProcessParameters ENTER\n\n");

// Control - Start control
  iStep = 0;
  for (i = 0; i < ControlEvent_START_Num; i++) {
	  if (ConvMet->MeasureParameters.StartEventEnabled[i]) {
		  ConvMet->MeasureEvents.SRSControlEnable[SRSStart] = ConvMet->MeasureParameters.StartEventEnabled[i];
		  ConvMet->MeasureEvents.SRSEventCode[SRSStart][iStep] = ConvMet->MeasureParameters.StartEventCode[i];
		  ConvMet->MeasureEvents.SRSEventMode[SRSStart][iStep] = ConvMet->MeasureParameters.StartEventMode[i];
		  ConvMet->MeasureEvents.SRSEventData[SRSStart][iStep] = ConvMet->MeasureParameters.StartEventData[i];
		  ConvMet->MeasureEvents.SRSEventTime[SRSStart][iStep] = ConvMet->MeasureParameters.StartEventTime[i];
		  ConvMet->MeasureEvents.SRSEventPulse[SRSStart][iStep] = ConvMet->MeasureParameters.StartEventTime[i];
		  iStep++;
		  ConvMet->MeasureEvents.SRSEventNum[SRSStart] = iStep;
	  } // if Enabled
  } // i ControlEvent_START_Num

// Control - Run control
  iStep = 0;
  for (i = 0; i < ControlEvent_RUN_Num; i++) {
	  if (ConvMet->MeasureParameters.RunEventEnabled[i]) {
		  ConvMet->MeasureEvents.SRSControlEnable[SRSRun] = ConvMet->MeasureParameters.StartEventEnabled[i];
		  ConvMet->MeasureEvents.SRSEventCode[SRSRun][iStep] = ConvMet->MeasureParameters.RunEventCode[i];
		  ConvMet->MeasureEvents.SRSEventMode[SRSRun][iStep] = ConvMet->MeasureParameters.RunEventMode[i];
		  ConvMet->MeasureEvents.SRSEventData[SRSRun][iStep] = ConvMet->MeasureParameters.RunEventData[i];
		  ConvMet->MeasureEvents.SRSEventTime[SRSRun][iStep] = ConvMet->MeasureParameters.RunEventTime[i];
		  ConvMet->MeasureEvents.SRSEventPulse[SRSRun][iStep] = ConvMet->MeasureParameters.RunEventTime[i];
		  iStep++;
		  ConvMet->MeasureEvents.SRSEventNum[SRSRun] = iStep;
	  } // if Enabled
  } // i ControlEvent_RUN_Num

// Control - Stop control
  iStep = 0;
  for (i = 0; i < ControlEvent_STOP_Num; i++) {
	  if (ConvMet->MeasureParameters.StopEventEnabled[i]) {
		  ConvMet->MeasureEvents.SRSControlEnable[SRSStop] = ConvMet->MeasureParameters.StartEventEnabled[i];
		  ConvMet->MeasureEvents.SRSEventCode[SRSStop][iStep] = ConvMet->MeasureParameters.StopEventCode[i];
		  ConvMet->MeasureEvents.SRSEventMode[SRSStop][iStep] = ConvMet->MeasureParameters.StopEventMode[i];
		  ConvMet->MeasureEvents.SRSEventData[SRSStop][iStep] = ConvMet->MeasureParameters.StopEventData[i];
		  ConvMet->MeasureEvents.SRSEventTime[SRSStop][iStep] = ConvMet->MeasureParameters.StopEventTime[i];
		  ConvMet->MeasureEvents.SRSEventPulse[SRSStop][iStep] = ConvMet->MeasureParameters.StopEventTime[i];
		  iStep++;
		  ConvMet->MeasureEvents.SRSEventNum[SRSStop] = iStep;
	  } // if Enabled
  } // i ControlEvent_STOP_Num
} // ConvertProcessParameters

extern void
StartExec (GtkWidget *MeasureTop) {
GtkWidget *MethodWindow;

  DATASOURCE (MeasureTop);
  ADSI (MeasureTop);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	case InstrumentDataStation :
	  NewChromHead(Chrom[ActualDSInstrument].ChromHead);
	  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = MethodLoad (&Chrom[ActualDSInstrument].Method, Options[ActualDSInstrument].MeasureMethod);
	  strcpy (Chrom[ActualDSInstrument].Method.MeasureParameters.MethodName, Options[ActualDSInstrument].MeasureMethod);
	  Chrom[ActualDSInstrument].ChromHead->Method = Chrom[ActualDSInstrument].Method;
	  Chrom[ActualDSInstrument].Method.ADParameters = WorkAD;
	  Chrom[ActualDSInstrument].Method.Instrument = WorkInstrument[ActualDSInstrument];
	  switch (Options[ActualDSInstrument].DataAcqMode) {
		  case MeasureRunModeQueue:
			  strcpy (Chrom[ActualDSInstrument].LayerQueueName, Options[ActualDSInstrument].QueueName);
			  QueueLoad (ActualDSInstrument);
			  if (Chrom[ActualDSInstrument].FileLoaded[LayFlag]) {
				  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = \
					  MethodLoad (&Chrom[ActualDSInstrument].QueueHead.LQMethod, \
								  Chrom[ActualDSInstrument].QueueHead.MethodName);
				  if (!Chrom[ActualDSInstrument].FileLoaded[MetFlag]) {
					  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = \
						  MethodLoad (&Chrom[ActualDSInstrument].QueueHead.LQMethod, \
									  Options[ActualDSInstrument].MeasureMethod);
					  strcpy (Chrom[ActualDSInstrument].QueueHead.MethodName, Options[ActualDSInstrument].MeasureMethod);
				  } // if !MetFlag
				  if (Chrom[ActualDSInstrument].FileLoaded[MetFlag]) {
					  Chrom[ActualDSInstrument].QueueHead.LQMethod.ADParameters = WorkAD;
					  Chrom[ActualDSInstrument].QueueHead.LQMethod.Instrument = WorkInstrument[ActualDSInstrument];
					  ActivateWidget (MeasureWindow, "MeasureStartButton", FALSE);
					  SampleQueueWindow = create_SampleQueueWindow ();
					  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "MethodWindow", NULL);
					  gtk_window_set_title (GTK_WINDOW (SampleQueueWindow), "Start measure");
					  DATASOURCE_UP(SampleQueueWindow, ActualDSInstrument);
					  ADSI_UP(SampleQueueWindow, ActualDSInstrument);
					  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "CallerWindow", MeasureTop);
					  PresetSampleQueueWidgets (SampleQueueWindow,
								LC2.Instruments[ActualInstrument].InstrumentType,
								MeasureTop,
								lookup_widget (MeasureTop, "MeasureStartButton"),
								GenericDataAcqStartQueueOkFunction, NULL);
					  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "SelectedItem", GINT_TO_POINTER(-1));
					  SetSampleQueueWidgets (SampleQueueWindow);
					  RefreshQueueList (SampleQueueWindow);
					  on_SampleQueueGenerateNameButton_clicked (GTK_BUTTON(lookup_widget(SampleQueueWindow, "SampleQueueGenerateNameButton")), NULL);
					  if (Chrom[ActualDSInstrument].QueueHead.QueueItemNum < 1)
						  ActivateWidget (SampleQueueWindow, "SampleQueueOkButton", FALSE);
					  gtk_widget_show (SampleQueueWindow);
				  } // if MetFlag
				  else create_FilenameErrorDialog (MeasureWindow, _("Hiba a megadott METHOD filenévnél!"), _("Filenév hiba"));
			  } else {
				  FileErrorDialog = create_FileErrorDialog ();
				  gtk_widget_show (FileErrorDialog);
			  }
			  break; // MeasureRunModeQueue
		  case MeasureRunModeUnique:
		  case MeasureRunModeContinous:
				if (Chrom[ActualDSInstrument].FileLoaded[MetFlag]) {
					Options[ActualDSInstrument].ContinousFreshMeasure = TRUE;
					ActivateWidget (MeasureWindow, "MeasureStartButton", FALSE);
					MethodWindow = create_MethodWindow ();
					gtk_object_set_data (GTK_OBJECT (MeasureTop), "MethodWindow", MethodWindow);
					gtk_object_set_data (GTK_OBJECT (MethodWindow), "ActualDSInstrument", GINT_TO_POINTER(ActualDSInstrument));
					DATASOURCE_UP(MethodWindow, ActualDSInstrument);
					PresetMethodWidgets (MethodWindow,
										&Chrom[ActualDSInstrument].Method,
										MeasureTop,
										lookup_widget (MeasureTop, "MeasureStartButton"),
										GenericDataAcqStartMethodOkFunction);
					gtk_object_set_data (GTK_OBJECT (MethodWindow), "Report", &Chrom[ActualDSInstrument].Method.Report);
					sprintf (Chrom[ActualDSInstrument].Method.MeasureParameters.ChromExt, "%.3d", Chrom[ActualDSInstrument].ActualExtension);
					gtk_widget_show (MethodWindow);
					gdk_flush ();
					SetMethodWidgets (MethodWindow);
					ActivateWidget (MethodWindow, "MethodNewButton", FALSE);
					ActivateWidget (MethodWindow, "MethodOpenButton", FALSE);
					ActivateWidget (MethodWindow, "MethodSaveButton", FALSE);
					ActivateWidget (MethodWindow, "MethodPrintButton", FALSE);
					SetSpinButtonValue (MethodWindow, "MethodMeasParExtSpinButton", Chrom[ActualDSInstrument].ActualExtension);
				} // if FileLoadoed
				else create_FilenameErrorDialog (MeasureWindow, _("Hiba a megadott METHOD filenévnél!"), _("Filenév hiba"));
			  break; // MeasureRunModeUnique, MeasureRunModeContinous
	  } // switch Options[i].DataAcqMode
		break;
	case InstrumentTR541 :
		printf ("StartExec : InstrumentTR541\n");
		GetTR541Widgets (MeasureTop, &Chrom[ActualDSInstrument].QueueHead.LQMethod);
		TR541MeasureExec (ActualDSInstrument);
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
} // StartExec

extern void
BreakExec (GtkWidget *MeasureTop) {

  DATASOURCE (MeasureTop);
  ADSI (MeasureTop);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		ActivateWidget (MeasureWindow, "MeasureBreakButton", FALSE);
		ActivateWidget (MeasureWindow, "MeasureFinishButton", FALSE);
		ThreadCommandSend (ThreadCommandBreak, 10, ActualDSInstrument);
		ActivateWidget (MeasureWindow, "MeasureStartButton", TRUE);
		ActivateWidget (MeasureWindow, "MeasureWorkstationResetMonitoringButton", TRUE);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		ThreadCommandSend (ThreadCommandBreak, 20, ActualDSInstrument);
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
  ActivateMeasureWidgets (ActualDSInstrument);
} // BreakExec

extern void
StopExec (GtkWidget *MeasureTop) {

  DATASOURCE (MeasureTop);
  ADSI (MeasureTop);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		ActivateWidget (MeasureWindow, "MeasureFinishButton", FALSE);
		ActivateWidget (MeasureWindow, "MeasureBreakButton", FALSE);
		ThreadCommandSend (ThreadCommandStop, 0, ActualDSInstrument);
		ActivateWidget (MeasureWindow, "MeasureStartButton", TRUE);
		ActivateWidget (MeasureWindow, "MeasureWorkstationResetMonitoringButton", TRUE);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		ThreadCommandSend (ThreadCommandStop, 20, ActualDSInstrument);
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
  ActivateMeasureWidgets (ActualDSInstrument);
} // StopExec

extern void
TestModeON (GtkWidget *MeasureTop)
{
  DATASOURCE (MeasureTop);
  ADSI (MeasureTop);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	    ThreadCommandSend (ThreadCommandTestIn, 0, ActualDSInstrument);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
  ActivateMeasureWidgets (ActualDSInstrument);
} // TestModeON

extern void
TestModeOFF (GtkWidget *MeasureTop)
{
  DATASOURCE (MeasureTop);
  ADSI (MeasureTop);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	    ThreadCommandSend (ThreadCommandTestOut, 0, ActualDSInstrument);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		TR930CommandExec (TR930CommandHiVoltOff, 0, 0, 0, 0);
		break;
  } // switch
  ActivateMeasureWidgets (ActualDSInstrument);
} // TestModeOFF


extern gint
oneSecondCallBackMeasure(gpointer data)
{
  ADSI(MainWindow);
  gdk_threads_enter ();
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	  WorkstationMeasureRedraw ();
	  //RefreshMeasureQueueList (ActualDSInstrument);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		if (MeasureLayerDrawingAreaNeedRedraw) {
			TR541RawRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541LayerDrawingArea"));
			TR541TrackRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541TrackDrawingArea"));
		}
		MeasureLayerDrawingAreaNeedRedraw = FALSE;
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
	  TR930MeasureRedraw ();
		break;
  } // switch
  gdk_flush ();
  gdk_threads_leave ();
  return TRUE;
} // oneSecondCallBackMeasure

  // Queue handler in-thread functions

  // Workstation

  // Datastation

  // Generic densitometer

#include "measure_ds.c"

  // TR541

#include "measure_tr541.c"
  
  // TR542
  
  // TR930

#include "measure_tr930.c"
