extern gboolean
FileExist (char *FileName) {
FILE *CheckFile;
gboolean FERet;

  FERet = FALSE;
  CheckFile = fopen (FileName, "r");
  if (CheckFile != NULL) {
	  FERet = TRUE;
	  fclose (CheckFile);
	  printf ("Exist: %s\n", FileName);
  } else {
	  int errsv = errno;
	  printf ("Does not exist: %s\n", FileName);
	  printf ("errno = %d, %s\n", errsv, strerror(errsv));
  }
  return FERet;
} // FileExist

extern gboolean
DirExist (char *DirName) {
gboolean DERet;
DIR *dp;

  DERet = FALSE;
  dp = opendir (DirName);
  if (dp != NULL) {
	  (void) closedir (dp);
	  DERet = TRUE;
  }
  return DERet;
} // DirExist

extern void
GenerateFileName (char *DirName, char *BaseName, char *ExtName, char *ResultName, time_t RescueTime) {
char *TmpStr;
char *TmpName;
int TmpCounter;
struct tm *ConvLocalTime;
char *TmpNameDate;
time_t RescueTimeInternal;

  ConvLocalTime = alloca (sizeof(struct tm));
  TmpNameDate = alloca (200);
  TmpName = alloca (2*FilenameLength);
  TmpStr = alloca (40);
  TmpCounter = 0;
  RescueTimeInternal = RescueTime;
  localtime_r (&RescueTime, ConvLocalTime);

  sprintf (TmpNameDate, "%d.%.2d.%.2d.%.2d.%.2d.%.2d_Rescue", \
			ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
			ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
  do {
	  strcpy (TmpName, "");
	  if (DirName != NULL)
		  strcpy (TmpName, DirName);
	  if (strlen (BaseName) > 0) {
		  strcat (TmpName, BaseName);
		  } else strcat (TmpName, TmpNameDate);
	  sprintf (TmpStr, "_%.3d", TmpCounter);
	  if (TmpCounter != 0)
		  strcat (TmpName, TmpStr);
	  if (ExtName != NULL)
		  strcat (TmpName, ExtName);
	  TmpCounter++;
  } while (FileExist (TmpName));
  if (ResultName != NULL)
	  strcpy (ResultName, TmpName);
} // GenerateFileName

extern int
CheckDirName (char *DirName) {
char *WorkCheckDir;

  if (!DirName) return FALSE;
  if (!strlen (DirName)) return FALSE;

  WorkCheckDir = alloca (1000);
  strcpy (WorkCheckDir, DirName);
  g_strstrip(WorkCheckDir);
  if (WorkCheckDir[strlen (WorkCheckDir) - 1] != '/')
	  strcat (WorkCheckDir, "/");
  strcpy (DirName, WorkCheckDir);
  if (!DirExist (DirName)) return FALSE;
  return TRUE;
} // CheckDirName

extern int
CheckFileName (char *FileName) {
char *WorkCheckFN;

  if (!FileName) return FALSE;
  if (!strlen (FileName)) return FALSE;

  WorkCheckFN = alloca (1000);
  strcpy (WorkCheckFN, FileName);
  g_strstrip(WorkCheckFN);
  strcpy (FileName, WorkCheckFN);
  return TRUE;
} // CheckFileName

extern int
FileCheck (int FileIDCode, FILE *CheckFile, char *Filename) {
struct	FileIdentifierStruct FileIdentifier;
int		FileCheckResult;
int		BlockIn;

  FileCheckResult = TRUE;
  BlockIn = fread(&FileIdentifier,sizeof(struct FileIdentifierStruct),1,CheckFile);
  FileCheckResult = (!strncmp (FileIdentifier.LabChromID, LabChromID, sizeof(LabChromID)) && (FileIDCode == FileIdentifier.FileID));
  PRINTF ("FileIdentifier.LabChromID = %s, LabChromID = %s\n", FileIdentifier.LabChromID, LabChromID);
  PRINTF ("Check for. %d, Result is %d,\nVersion %d.%d.%d,\nIdText %s,\nLabChromText %s\n", \
	  FileIDCode, FileIdentifier.FileID, \
	  FileIdentifier.MainVersion, FileIdentifier.SubVersion, FileIdentifier.ServiceVersion, \
	  FileIdentifier.LabChromID, FileIdentifier.LabChromText);
  if (FileCheckResult)
	  printf ("File check OK for %s\n",Filename);
  else
	  printf ("File check failed for %s\n",Filename);
  return FileCheckResult;
} // FileCheck

extern void
CheckOut (int FileIDCode, FILE *CheckFile, struct FileIdentifierStruct *FileIdentifier) {
int		BlockOut;
BT_INIT();

  FileIdentifier->FileID = FileIDCode;
  strcpy (FileIdentifier->LabChromID,LabChromID);
  strcpy (FileIdentifier->LabChromText,LabChromText);
  sprintf (BugTraceUserString, "VERSION: %s", VERSION);
  BUGTRACE(BugTraceUserString);
  sscanf (VERSION,"%d.%d.%d",&FileIdentifier->MainVersion, &FileIdentifier->SubVersion, &FileIdentifier->ServiceVersion);
  BlockOut = fwrite(FileIdentifier,sizeof(struct FileIdentifierStruct),1,CheckFile);
} // CheckOut

extern void
ChromSave (int DataSource) {
struct FileIdentifierStruct FileIdentifier;
FILE *ChromFile;
int BlockOut;
int j;
BT_INIT();

  if (!Chrom[DataSource].FileLoaded[ChrFlag]) return;

  ChromFile = fopen(Chrom[DataSource].Filename,"wb");
  if (ChromFile != NULL) {
	  CheckOut (ChrFlag, ChromFile, &FileIdentifier);
	  BlockOut = fwrite(Chrom[DataSource].ChromHead,sizeof(struct ChromHeadStruct),1,ChromFile);
	  for (j = 0; j < MaxDetectors; j++) {
		  BlockOut = fwrite(Chrom[DataSource].PeakArray[j],sizeof(struct PeakStruct),Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper, ChromFile);
		  BlockOut = fwrite(Chrom[DataSource].ChromDataArrays[j],sizeof(int),Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp, ChromFile);
	  } // j
	  fclose(ChromFile);
	  strcpy (Chrom[DataSource].ChrName, Chrom[DataSource].Filename);
	  Chrom[DataSource].FileSaved[ChrFlag] = TRUE;
  } // if ChromFile != NULL
} // ChromSave

extern void
ChromLoad(int DataSource) {
FILE *ChromFile;
int BlockIn;
int j;
char *TmpDirName;

  ChromFile = fopen (Chrom[DataSource].Filename,"rb");

  if (ChromFile != NULL) {
	  Chrom[DataSource].FileLoaded[ChrFlag] = FALSE;
	  if (FileCheck (ChrFlag, ChromFile, Chrom[DataSource].Filename)) {
		BlockIn = fread (Chrom[DataSource].ChromHead,sizeof(struct ChromHeadStruct),1,ChromFile);
		ReallocPeakData (Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper, DataSource);
		ReallocChromData (Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp, DataSource);
		for (j = 0; j < MaxDetectors; j++) {
			BlockIn = fread (Chrom[DataSource].PeakArray[j],sizeof(struct PeakStruct),Chrom[DataSource].ChromHead->PeakHead.PeakNumUpper,ChromFile);
			BlockIn = fread (Chrom[DataSource].ChromDataArrays[j],sizeof(int),Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp,ChromFile);
		} // j
		Chrom[DataSource].ActualDetector = 0;
		if (!Chrom[DataSource].ChromHead->PeakHead.Integrated) ReintegrateDBI (DataSource);
		Chrom[DataSource].FileLoaded[ChrFlag] = TRUE;
		Chrom[DataSource].FileSaved[ChrFlag] = TRUE;
	  } // if FileCheck
	  fclose (ChromFile);
	  strcpy (Chrom[DataSource].ChrName, Chrom[DataSource].Filename);
	  if (DataSource == WorkArea) {
		  TmpDirName = alloca (FilenameLength);
		  strcpy (TmpDirName, Chrom[DataSource].ChrName);
		  strcpy (LastChromDir, dirname (TmpDirName));
		  strcat (LastChromDir, "/");
	  } // if WorkArea
  } // if ChromFile != NULL
} // ChromLoad

extern void
CalibrLoad (int DataSource, char *Filename) {
FILE *CalibrFile;
int BlockIn;
BT_INIT();

  CalibrFile = fopen(Filename,"rb");

  if (CalibrFile != NULL) {
	  Chrom[DataSource].FileLoaded[CalFlag] = FALSE;
	  if (FileCheck (CalFlag, CalibrFile, Filename)) {
		  BlockIn = fread (Chrom[DataSource].CalibrHead,sizeof(struct CalibrHeadStruct),1,CalibrFile);
		  ReallocCalibrComponentData (Chrom[DataSource].CalibrHead->ComponentNum, DataSource);
		  BlockIn = fread (Chrom[DataSource].CalibrComponentArray,sizeof(struct CalibrComponentStruct),Chrom[DataSource].CalibrHead->ComponentNum, CalibrFile);
		  ReallocCalibrLevelData (Chrom[DataSource].CalibrHead->LevelNum, DataSource);
		  BlockIn = fread (Chrom[DataSource].CalibrLevelArray,sizeof(struct CalibrLevelStruct),Chrom[DataSource].CalibrHead->LevelNum, CalibrFile);
		  ReallocCalibrChromData (Chrom[DataSource].CalibrHead->ChromNum, DataSource);
		  BlockIn = fread (Chrom[DataSource].CalibrChromArray,sizeof(struct CalibrChromStruct),Chrom[DataSource].CalibrHead->ChromNum, CalibrFile);
		  ReallocCalibrCellData (Chrom[DataSource].CalibrHead->CellNum, DataSource);
		  BlockIn = fread (Chrom[DataSource].CalibrCellArray,sizeof(struct CalibrCellStruct),Chrom[DataSource].CalibrHead->CellNum, CalibrFile);
		  ReallocCalibrConcData (Chrom[DataSource].CalibrHead->ConcNum, DataSource);
		  BlockIn = fread (Chrom[DataSource].CalibrConcArray,sizeof(struct CalibrConcStruct),Chrom[DataSource].CalibrHead->ConcNum, CalibrFile);
		  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;
		  Chrom[DataSource].FileSaved[CalFlag] = TRUE;
		  strcpy (Chrom[DataSource].CalibrTemplateChromName, Chrom[DataSource].CalibrHead->RetentiontemplateName);
		  CalibrTemplateChromLoad(DataSource);
		  Chrom[DataSource].CalibrHead->RetentionTemplateLoaded = Chrom[DataSource].FileLoaded[TCrFlag];
		  Chrom[DataSource].CalibrHead->SaveCalibrAfterMod = FALSE;
		  } // if FileCheck
  fclose(CalibrFile);
  strcpy (Chrom[DataSource].CalName, Filename);
  } // if CalibrFile != NULL
} // CalibrLoad

extern void
CalibrSave (int DataSource, char *Filename) {
struct FileIdentifierStruct FileIdentifier;
FILE *CalibrFile;
int BlockOut;
BT_INIT();

  if (!Chrom[DataSource].FileLoaded[CalFlag]) return;

  CalibrFile = fopen(Filename,"wb");
  if (CalibrFile != NULL) {
	  CheckOut (CalFlag, CalibrFile, &FileIdentifier);
	  BlockOut = fwrite(Chrom[DataSource].CalibrHead,sizeof(struct CalibrHeadStruct),1,CalibrFile);
	  BlockOut = fwrite(Chrom[DataSource].CalibrComponentArray,sizeof(struct CalibrComponentStruct),Chrom[DataSource].CalibrHead->ComponentNum, CalibrFile);
	  BlockOut = fwrite(Chrom[DataSource].CalibrLevelArray,sizeof(struct CalibrLevelStruct),Chrom[DataSource].CalibrHead->LevelNum, CalibrFile);
	  BlockOut = fwrite(Chrom[DataSource].CalibrChromArray,sizeof(struct CalibrChromStruct),Chrom[DataSource].CalibrHead->ChromNum, CalibrFile);
	  BlockOut = fwrite(Chrom[DataSource].CalibrCellArray,sizeof(struct CalibrCellStruct),Chrom[DataSource].CalibrHead->CellNum, CalibrFile);
	  BlockOut = fwrite(Chrom[DataSource].CalibrConcArray,sizeof(struct CalibrConcStruct),Chrom[DataSource].CalibrHead->ConcNum, CalibrFile);
	  fclose(CalibrFile);
	  Chrom[DataSource].FileSaved[CalFlag] = TRUE;
	  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;
	  strcpy (Chrom[DataSource].CalName, Filename);
  } // if ChromFile != NULL
} // CalibrSave

extern char *
LoadExportTemplateString (int DataSource) {
} // LoadExportTemplateString

extern void
SaveResultList (int DataSource, char *ResultString) {
FILE *ResultFile;

  ResultFile = fopen (Chrom[DataSource].Filename,"w");

  if (ResultFile != NULL) {
	  printf ("ResultFile != NULL\n");
	  printf ("%s", ResultString);
	  fprintf (ResultFile, "%s", ResultString);
	  fclose (ResultFile);
  } // ResultFile != NULL
} // SaveResultList

extern void
CalibrChromLoad(int DataSource) {
FILE *CalibrChromFile;
int BlockIn;
int j;
char *TmpDirName;

  CalibrChromFile = fopen (Chrom[DataSource].CalibrChromName,"rb");

  if (CalibrChromFile != NULL) {
	  Chrom[DataSource].FileLoaded[CCrFlag] = FALSE;
	  if (FileCheck (ChrFlag, CalibrChromFile, Chrom[DataSource].CalibrChromName)) {
		BlockIn = fread (Chrom[DataSource].CalibrChromHead,sizeof(struct ChromHeadStruct),1,CalibrChromFile);
		ReallocCalibrChromPeakData (Chrom[DataSource].CalibrChromHead->PeakHead.PeakNumUpper, DataSource);
		ReallocCalibrChromChromData (Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Nmp, DataSource);
		for (j = 0; j < MaxDetectors; j++) {
			BlockIn = fread (Chrom[DataSource].CalibrPeakArray[j],sizeof(struct PeakStruct),Chrom[DataSource].CalibrChromHead->PeakHead.PeakNumUpper,CalibrChromFile);
			BlockIn = fread (Chrom[DataSource].CalibrChromDataArrays[j],sizeof(int),Chrom[DataSource].CalibrChromHead->Method.MeasureParameters.Nmp,CalibrChromFile);
		} // j
		Chrom[DataSource].CalibrActualDetector = 0;
		Chrom[DataSource].FileLoaded[CCrFlag] = TRUE;
		Chrom[DataSource].FileSaved[CCrFlag] = TRUE;
	  } // if FileCheck
	  fclose (CalibrChromFile);
  } // if ChromFile != NULL
} // CalibrChromLoad

extern void
CalibrTemplateChromLoad(int DataSource) {
FILE *CalibrTemplateChromFile;
int BlockIn;
int j;
char *TmpDirName;

  CalibrTemplateChromFile = fopen (Chrom[DataSource].CalibrTemplateChromName,"rb");

  if (CalibrTemplateChromFile != NULL) {
	  Chrom[DataSource].FileLoaded[TCrFlag] = FALSE;
	  if (FileCheck (ChrFlag, CalibrTemplateChromFile, Chrom[DataSource].CalibrTemplateChromName)) {
		BlockIn = fread (Chrom[DataSource].CalibrTemplateChromHead,sizeof(struct ChromHeadStruct),1,CalibrTemplateChromFile);
		ReallocCalibrTemplatePeakData (Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNumUpper, DataSource);
		ReallocCalibrTemplateChromData (Chrom[DataSource].CalibrTemplateChromHead->Method.MeasureParameters.Nmp, DataSource);
		for (j = 0; j < MaxDetectors; j++) {
			BlockIn = fread (Chrom[DataSource].CalibrTemplatePeakArray[j],sizeof(struct PeakStruct),Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNumUpper,CalibrTemplateChromFile);
			BlockIn = fread (Chrom[DataSource].CalibrTemplateChromDataArrays[j],sizeof(int),Chrom[DataSource].CalibrTemplateChromHead->Method.MeasureParameters.Nmp,CalibrTemplateChromFile);
		} // j
		Chrom[DataSource].CalibrTemplateActualDetector = 0;
		Chrom[DataSource].FileLoaded[TCrFlag] = TRUE;
		Chrom[DataSource].FileSaved[TCrFlag] = TRUE;
		strcpy (Chrom[DataSource].CalibrHead->RetentiontemplateName, Chrom[DataSource].CalibrTemplateChromName);
		Chrom[DataSource].CalibrHead->RetentionTemplateLoaded = TRUE;
	  } // if FileCheck
	  fclose (CalibrTemplateChromFile);
  } // if ChromFile != NULL
} // CalibrTemplateChromLoad

extern void
ChromImport (GtkWidget *ImportMainWidget, const gchar *ImportName)
{
FILE	*ImportFile;
int		TempData;
int		DummyData;
int		*ImportData;
int		*ImportSizedData;
int		DataPointerSize;
int		i;

//  PRINTF ("Filename: %s\n", ImportName);
  Chrom[WorkArea].FileLoaded[ImpFlag] = FALSE;
  ImportFile = fopen (ImportName, "r");
  if (ImportFile != NULL) {
	  i = 0;
	  strcpy (ImportFileName, ImportName);
	  ImportData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataPointer"); // (int *)ImportData[i]
	  ImportSizedData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedPointer"); // (int *)ImportData[i]
	  DataPointerSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataPointerSize"));
	  while (!feof(ImportFile)) {
		  if (i == DataPointerSize) {
			  DataPointerSize += 10000;
			  ImportData = realloc (ImportData, DataPointerSize * sizeof (int));
			  ImportSizedData = realloc (ImportSizedData, DataPointerSize * sizeof (int));
		  } // if i==DataPointerSize
		  switch (ImportChannelsOf) {
			  case 1: fscanf (ImportFile, "%d\n", &TempData);
			  case 2: fscanf (ImportFile, "%d %d\n", &TempData, &DummyData);
			  case 3: fscanf (ImportFile, "%d %d %d\n", &TempData, &DummyData, &DummyData);
			  case 4: fscanf (ImportFile, "%d %d %d %d\n", &TempData, &DummyData, &DummyData, &DummyData);
		  }
		  ImportData[i] = TempData;
		  i++;
	  } // while
	  printf ("TempData = %d\n", TempData);
	  TempData = 0;
	  TempData = (int)(int *)ImportData[i-1];
	  printf ("TempData = %d\n", TempData);
	  gtk_object_set_data (GTK_OBJECT (ImportMainWidget), "DataSize", GINT_TO_POINTER (i));
	  gtk_object_set_data (GTK_OBJECT (ImportMainWidget), "DataPointer", ImportData);
	  gtk_object_set_data (GTK_OBJECT (ImportMainWidget), "DataPointerSize", GINT_TO_POINTER (DataPointerSize));

	  
	  Chrom[WorkArea].FileLoaded[ImpFlag] = TRUE;
	  fclose (ImportFile);
  } // ImportFile != NULL

} // ChromImport

extern void
ChromExportInRaw (int DataSource, char *Filename, struct ExportModeStruct *ExportMode) {
FILE *ExportStreamFile;
FILE *ExportHeaderFile;
char *StreamName;
char *HeaderName;
int i, j;
int DetStore;
struct tm *ConvLocalTime;

/*
printf ("Filename: %s\n",Filename );
printf ("ExportMode->AddExtension %d\n", ExportMode->AddExtension);
printf ("ExportMode->Extension %s\n", ExportMode->Extension);
printf ("ExportMode->ParameterMode %d\n", ExportMode->ParameterMode);
printf ("ExportMode->ParamExtension %s\n", ExportMode->ParamExtension);
*/

  ExportStreamFile = NULL;
  ExportHeaderFile = NULL;
  StreamName = calloc (1200, 1);
  HeaderName = calloc (1200, 1);
  strcpy (StreamName, Filename);
  strcpy (HeaderName, Filename);

  if (ExportMode->AddExtension) strcat (StreamName, ExportMode->Extension);
  if (ExportMode->ParameterMode == 2) 
	  strcat (HeaderName, ExportMode->ParamExtension);
  if (!strcmp (StreamName, HeaderName))
	  strcat (HeaderName, ".par");

/*
printf ("StreamName: %s\n",StreamName );
printf ("HeaderName: %s\n",HeaderName );
*/

  ExportStreamFile = fopen (StreamName, "w");
  if (ExportMode->ParameterMode == 2)
	  ExportHeaderFile = fopen (HeaderName, "w");

  free (StreamName);
  free (HeaderName);
  if (ExportStreamFile != NULL) {
	  if (ExportMode->ParameterMode == 1)
		  ExportHeaderFile = ExportStreamFile;
	  if (ExportHeaderFile != NULL) {
		  fprintf (ExportHeaderFile, "Data_points= %d", Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp);
		  if (Options[DataSource].ExportDOSLineFeed)
			  fprintf (ExportHeaderFile, "\r");
		  fprintf (ExportHeaderFile, "\n");
		  DetStore = Chrom[DataSource].ActualDetector;
		  for (j = 0; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++) {
			  if (Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors > 1) 
				  fprintf (ExportHeaderFile, "Scale_value_%d= %.3f", j + 1, Chrom[DataSource].ChromHead->Method.Instrument.Detectors[j].ScaleValue);
			  else
				  fprintf (ExportHeaderFile, "Scale_value= %.3f", Chrom[DataSource].ChromHead->Method.Instrument.Detectors[j].ScaleValue);
			  if (Options[DataSource].ExportDOSLineFeed)
				  fprintf (ExportHeaderFile, "\r");
			  fprintf (ExportHeaderFile, "\n");
		  } // j - ScaleValue
		  Chrom[DataSource].ActualDetector = DetStore;
		  fprintf (ExportHeaderFile, "Sampling_rate_sec= %.3f", Chrom[DataSource].ChromHead->Method.MeasureParameters.SamplingRate);
		  if (Options[DataSource].ExportDOSLineFeed)
			  fprintf (ExportHeaderFile, "\r");
		  fprintf (ExportHeaderFile, "\n");
		  fprintf (ExportHeaderFile, "Start_time_UTC= %d", Chrom[DataSource].ChromHead->Method.MeasureParameters.StartTime);
		  if (Options[DataSource].ExportDOSLineFeed)
			  fprintf (ExportHeaderFile, "\r");
		  fprintf (ExportHeaderFile, "\n");
		  ConvLocalTime = calloc (1, sizeof(struct tm));
		  localtime_r (&Chrom[DataSource].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);
		  fprintf (ExportHeaderFile, "Start_time_ASC= %d.%.2d.%.2d   %.2d:%.2d:%.2d",   \
			  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
			  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec);
		  if (Options[DataSource].ExportDOSLineFeed)
			  fprintf (ExportHeaderFile, "\r");
		  fprintf (ExportHeaderFile, "\n");
		  free (ConvLocalTime);
		  if (ExportMode->ParameterMode == 2)
			  fclose (ExportHeaderFile);
	  } // Header
	  for (i = 0; i < Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp; i++) {
		  fprintf (ExportStreamFile, "%.3f ", CPTR (i, WorkArea));
		  for (j = 0; j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors; j++) {
			  Chrom[WorkArea].ActualDetector = j;
			  fprintf (ExportStreamFile, "%.3f", ChromData(i, WorkArea));
			  if (j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors - 1)
				  fprintf (ExportStreamFile, " ");
		  } // j
		  if (Options[DataSource].ExportDOSLineFeed)
			  fprintf (ExportStreamFile, "\r");
		  fprintf (ExportStreamFile, "\n");
	  } // i
	  fclose (ExportStreamFile);
  } // ExportStreamFile != NULL
} // ChromExportInRaw

extern int
MethodSave(struct MethodStruct *Method, char *Filename) {
struct	FileIdentifierStruct FileIdentifier;
FILE	*MethodFile;
int		BlockOut;
int		MethodResult;

  MethodResult = FALSE;

  MethodFile = fopen(Filename, "wb");
  if (MethodFile != NULL) {
	  CheckOut (MetFlag, MethodFile, &FileIdentifier);
	  BlockOut = fwrite(Method, sizeof(struct MethodStruct), 1, MethodFile);
	  fclose (MethodFile);
	  MethodResult = TRUE;
  } // if MethodFile != NULL

  return MethodResult;
} // MethodSave

extern int
MethodLoad(struct MethodStruct *Method, char *Filename) {
FILE	*MethodFile;
int		BlockIn;
int		MethodResult;

  MethodResult = FALSE;
  MethodFile = fopen(Filename, "rb");

  if (MethodFile != NULL) {
	  if (FileCheck (MetFlag, MethodFile, Filename)) {
		BlockIn = fread(Method, sizeof(struct MethodStruct), 1, MethodFile);
		MethodResult = TRUE;
	  } // if FileCheck
	  fclose (MethodFile);
  }

  return MethodResult;
} // MethodLoad

extern int
IntParSave(struct IntegrationParametersStruct *IntPar, char *Filename) {
struct	FileIdentifierStruct FileIdentifier;
FILE	*IntParFile;
int		BlockOut;
int		IntParResult;

  IntParResult = FALSE;

  IntParFile = fopen(Filename, "wb");
  if (IntParFile != NULL) {
	  CheckOut (IntFlag, IntParFile, &FileIdentifier);
	  BlockOut = fwrite(IntPar, sizeof(struct IntegrationParametersStruct), 1, IntParFile);
	  fclose (IntParFile);
	  IntParResult = TRUE;
  } // if IntParFile != NULL

  return IntParResult;
} // IntParSave

extern int
IntParLoad(struct IntegrationParametersStruct *IntPar, char *Filename) {
FILE	*IntParFile;
int		BlockIn;
int		IntParResult;

  IntParResult = FALSE;
  IntParFile = fopen(Filename, "rb");

  if (IntParFile != NULL) {
	  if (FileCheck (IntFlag, IntParFile, Filename)) {
		BlockIn = fread(IntPar, sizeof(struct IntegrationParametersStruct), 1, IntParFile);
		IntParResult = TRUE;
	  } // if FileCheck
	  fclose (IntParFile);
  }

  return IntParResult;
} // IntParLoad

extern void
QueueSave (int DataSource) {
struct	FileIdentifierStruct FileIdentifier;
FILE	*QueueFile;
int		BlockOut;

  QueueFile = fopen(Chrom[DataSource].LayerQueueName, "wb");
  if (QueueFile != NULL) {
	  CheckOut (LayFlag, QueueFile, &FileIdentifier);
	  BlockOut = fwrite(&Chrom[DataSource].QueueHead, \
						sizeof(struct LayerQueueHeadStruct),1,QueueFile);
	  switch (Chrom[DataSource].QueueHead.RawType) {
		  case RawTypeNone:
			  break;
		  case RawTypeTR541:
			  BlockOut = fwrite (&Chrom[DataSource].TR541RawDataArray, Chrom[DataSource].QueueHead.RawSize, 1, QueueFile);
			  //printf ("QueueSave BlockOut = %d\n", BlockOut);
			  break;
		  case RawTypeTR542:
			  break;
		  case RawTypeTR930:
			  break;
	  } // switch RawType
	  BlockOut = fwrite(Chrom[DataSource].QueueItemArray, \
						Chrom[DataSource].QueueHead.QueueItemNum*sizeof(struct QueueItemStruct), \
						1,QueueFile);
	  fclose (QueueFile);
	  Chrom[DataSource].FileSaved[LayFlag] = TRUE;
  } // if QueueFile != NULL
} // QueueSave

extern void
QueueLoad (int DataSource) {
FILE	*QueueFile;
int		BlockIn;

  QueueFile = fopen(Chrom[DataSource].LayerQueueName, "rb");

  if (QueueFile != NULL) {
	  if (FileCheck (LayFlag, QueueFile, Chrom[DataSource].LayerQueueName)) {
		  BlockIn = fread(&Chrom[DataSource].QueueHead, \
						  sizeof(struct LayerQueueHeadStruct),1,QueueFile);
	  switch (Chrom[DataSource].QueueHead.RawType) {
		  case RawTypeNone:
			  break;
		  case RawTypeTR541:
			  BlockIn = fread (&Chrom[DataSource].TR541RawDataArray, Chrom[DataSource].QueueHead.RawSize, 1, QueueFile);
			  //printf ("QueueLoad BlockIn = %d\n", BlockIn);
			  break;
		  case RawTypeTR542:
			  break;
		  case RawTypeTR930:
			  break;
	  } // switch RawType
			  // !!! Realloc missing!
		  BlockIn = fread(Chrom[DataSource].QueueItemArray, \
						  Chrom[DataSource].QueueHead.QueueItemNum*sizeof(struct QueueItemStruct), \
						  1,QueueFile);
		  Chrom[DataSource].FileSaved[LayFlag] = TRUE;
		  Chrom[DataSource].FileLoaded[LayFlag] = TRUE;
	  } // if FileCheck
	  fclose (QueueFile);
  }
} // QueueLoad

extern void
QueueOpen (int DataSource) {
} // QueueOpen

extern void
QueueClose (int DataSource) {
} // QueueClose

extern void
QueueRead (int DataSource, int QueIdx) {
} // QueueRead

extern void
QueueWrite (int DataSource, int QueIdx) {
} // QueueWrite

extern void
SpectraSave (void) {
struct	FileIdentifierStruct FileIdentifier;
FILE	*SpectraFile;
int		BlockOut;

	Chrom[WorkArea].FileError = TRUE;
	SpectraFile = fopen(Chrom[WorkArea].Filename,"wb");

	if (SpectraFile != NULL) {
		CheckOut (SpeFlag, SpectraFile, &FileIdentifier);
		BlockOut = fwrite(&Spectra,sizeof(struct SpectraStruct),1,SpectraFile);

		Chrom[WorkArea].FileError = FALSE;
		fclose (SpectraFile);
		Chrom[WorkArea].FileSaved[SpeFlag] = TRUE;
		strcpy(SpectraName,Chrom[WorkArea].Filename);
	} // if SpectraFile != NULL
} // SpectraSave

extern void
SpectraLoad (void) {
FILE	*SpectraFile;
int		BlockIn;

	Chrom[WorkArea].FileError = TRUE;
	Chrom[WorkArea].FileLoaded[SpeFlag] = FALSE;
	SpectraFile = fopen(Chrom[WorkArea].Filename,"rb");
	
	if (SpectraFile != NULL) {
		if (FileCheck (SpeFlag, SpectraFile, Chrom[WorkArea].Filename) == TRUE) {
		BlockIn = fread(&Spectra,sizeof(struct SpectraStruct),1,SpectraFile);
	
		Chrom[WorkArea].FileError = FALSE;
		Chrom[WorkArea].FileLoaded[SpeFlag] = TRUE;
		Chrom[WorkArea].FileSaved[SpeFlag] = TRUE;
		} // if FileCheck
		fclose (SpectraFile);
		strcpy(SpectraName,Chrom[WorkArea].Filename);
	} else {
//		FileOpenErrorMessage = create_FileOpenErrorMessage ();
//		gtk_widget_show (FileOpenErrorMessage);
	} // if SpectraFile != NULL
} // SpectraLoad

extern void
TR541OldRawDataOpen (int DataSource, int DataShift) {
FILE *RawDataFile;
int i,j;
int temp_data;

  RawDataFile=fopen(Chrom[DataSource].Filename,"r");
  if (RawDataFile != NULL) {
	  j = DataShift;
	  Chrom[DataSource].TR541RawDataArrayRows = 0;
	  Chrom[DataSource].TR541RawDataArrayBeg = DataShift;
	  bzero (&Chrom[DataSource].TR541RawDataArray, 200*1000*sizeof(int));
	  while (!feof(RawDataFile)) {
		  for (i=0; i<1000; i++) {
			  temp_data=fgetc(RawDataFile) + 256 * fgetc(RawDataFile);
			  fgetc(RawDataFile);
			  fgetc(RawDataFile);
			  Chrom[DataSource].TR541RawDataArray[j][i] = temp_data;
		  } // for i
		  Chrom[DataSource].TR541RawDataArrayRows++;
		  j++;
		  if (j == 200) j = 199;
	  } // while
	  fclose(RawDataFile);
  } // RawDataFile != NULL
} // TR541OldRawDataOpen

extern void
TR541RawDataSave (int DataSource) {
FILE *RawDataFile;
int i,j;

  RawDataFile=fopen(Chrom[DataSource].Filename,"w");
  if (RawDataFile != NULL) {
	  Chrom[DataSource].TR541RawDataArrayRows = 0;
	  for (j = 0; j < 200; j++) {
		  for (i=0; i<1000; i++) {
			  fwrite (&Chrom[DataSource].TR541RawDataArray[j][i], 1, sizeof(int), RawDataFile);
		  } // for i
	  } // j
	  fclose(RawDataFile);
  } // RawDataFile != NULL
} // TR541RawDataSave

void
check_err(const int stat, const int line, const char *file) {
    if (stat != NC_NOERR) {
	   (void) fprintf(stderr, "line %d of %s: %s\n", line, file, nc_strerror(stat));
        exit(1);
    }
}

extern void
NetCDFExport (int DataSource, char *FileName) {

   int  i;

   int  stat;			/* return status */
   int  ncid;			/* netCDF id */

   /* dimension ids */
   int _2_byte_string_dim;
   int _4_byte_string_dim;
   int _8_byte_string_dim;
   int _16_byte_string_dim;
   int _32_byte_string_dim;
   int _64_byte_string_dim;
   int _128_byte_string_dim;
   int _255_byte_string_dim;
   int point_number_dim;
   int peak_number_dim;
   int error_number_dim;

   /* dimension lengths */
   size_t _2_byte_string_len = 2;
   size_t _4_byte_string_len = 4;
   size_t _8_byte_string_len = 8;
   size_t _16_byte_string_len = 16;
   size_t _32_byte_string_len = 32;
   size_t _64_byte_string_len = 64;
   size_t _128_byte_string_len = 128;
   size_t _255_byte_string_len = 255;
   //size_t point_number_len = 5;
   //size_t peak_number_len = 2;
   size_t error_number_len = 1;

   /* variable ids */
   int error_log_id;
   int detector_maximum_value_id;
   int detector_minimum_value_id;
   int actual_run_time_length_id;
   int actual_sampling_interval_id;
   int actual_delay_time_id;
   int ordinate_values_id;
   int raw_data_retention_id;
   int peak_retention_time_id;
   int peak_name_id;
   int peak_amount_id;
   int peak_start_time_id;
   int peak_end_time_id;
   int peak_width_id;
   int peak_area_id;
   int peak_area_percent_id;
   int peak_height_id;
   int peak_height_percent_id;
   int baseline_start_time_id;
   int baseline_start_value_id;
   int baseline_stop_time_id;
   int baseline_stop_value_id;
   int peak_start_detection_code_id;
   int peak_stop_detection_code_id;
   int retention_index_id;
   int migration_time_id;
   int peak_asymmetry_id;
   int peak_efficiency_id;
   int mass_on_column_id;
   int manually_reintegrated_peaks_id;

   /* rank (number of dimensions) for each variable */
#  define RANK_error_log 2
#  define RANK_detector_maximum_value 0
#  define RANK_detector_minimum_value 0
#  define RANK_actual_run_time_length 0
#  define RANK_actual_sampling_interval 0
#  define RANK_actual_delay_time 0
#  define RANK_ordinate_values 1
#  define RANK_raw_data_retention 1
#  define RANK_peak_retention_time 1
#  define RANK_peak_name 2
#  define RANK_peak_amount 1
#  define RANK_peak_start_time 1
#  define RANK_peak_end_time 1
#  define RANK_peak_width 1
#  define RANK_peak_area 1
#  define RANK_peak_area_percent 1
#  define RANK_peak_height 1
#  define RANK_peak_height_percent 1
#  define RANK_baseline_start_time 1
#  define RANK_baseline_start_value 1
#  define RANK_baseline_stop_time 1
#  define RANK_baseline_stop_value 1
#  define RANK_peak_start_detection_code 2
#  define RANK_peak_stop_detection_code 2
#  define RANK_retention_index 1
#  define RANK_migration_time 1
#  define RANK_peak_asymmetry 1
#  define RANK_peak_efficiency 1
#  define RANK_mass_on_column 1
#  define RANK_manually_reintegrated_peaks 1

   /* variable shapes */
   int error_log_dims[RANK_error_log];
   int ordinate_values_dims[RANK_ordinate_values];
   int raw_data_retention_dims[RANK_raw_data_retention];
   int peak_retention_time_dims[RANK_peak_retention_time];
   int peak_name_dims[RANK_peak_name];
   int peak_amount_dims[RANK_peak_amount];
   int peak_start_time_dims[RANK_peak_start_time];
   int peak_end_time_dims[RANK_peak_end_time];
   int peak_width_dims[RANK_peak_width];
   int peak_area_dims[RANK_peak_area];
   int peak_area_percent_dims[RANK_peak_area_percent];
   int peak_height_dims[RANK_peak_height];
   int peak_height_percent_dims[RANK_peak_height_percent];
   int baseline_start_time_dims[RANK_baseline_start_time];
   int baseline_start_value_dims[RANK_baseline_start_value];
   int baseline_stop_time_dims[RANK_baseline_stop_time];
   int baseline_stop_value_dims[RANK_baseline_stop_value];
   int peak_start_detection_code_dims[RANK_peak_start_detection_code];
   int peak_stop_detection_code_dims[RANK_peak_stop_detection_code];
   int retention_index_dims[RANK_retention_index];
   int migration_time_dims[RANK_migration_time];
   int peak_asymmetry_dims[RANK_peak_asymmetry];
   int peak_efficiency_dims[RANK_peak_efficiency];
   int mass_on_column_dims[RANK_mass_on_column];
   int manually_reintegrated_peaks_dims[RANK_manually_reintegrated_peaks];

   if (!Chrom[DataSource].FileLoaded[ChrFlag]) return;
   ADSI(MainWindow);
   size_t point_number_len = Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp;
   printf ("point_number_len = %d\n", point_number_len);
   size_t peak_number_len = 0; //Chrom[DataSource].ChromHead->PeakHead.PeakNum[Chrom[DataSource].ActualDetector];
   printf ("peak_number_len = %d\n", peak_number_len);

   /* enter define mode */
   stat = nc_create(FileName, NC_CLOBBER, &ncid);
   check_err(stat,__LINE__,__FILE__);

   /* define dimensions */
   stat = nc_def_dim(ncid, "_2_byte_string", _2_byte_string_len, &_2_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_4_byte_string", _4_byte_string_len, &_4_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_8_byte_string", _8_byte_string_len, &_8_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_16_byte_string", _16_byte_string_len, &_16_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_32_byte_string", _32_byte_string_len, &_32_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_64_byte_string", _64_byte_string_len, &_64_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_128_byte_string", _128_byte_string_len, &_128_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "_255_byte_string", _255_byte_string_len, &_255_byte_string_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "point_number", point_number_len, &point_number_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "peak_number", peak_number_len, &peak_number_dim);
   check_err(stat,__LINE__,__FILE__);
   stat = nc_def_dim(ncid, "error_number", error_number_len, &error_number_dim);
   check_err(stat,__LINE__,__FILE__);

   /* define variables */

   error_log_dims[0] = error_number_dim;
   error_log_dims[1] = _64_byte_string_dim;
   stat = nc_def_var(ncid, "error_log", NC_CHAR, RANK_error_log, error_log_dims, &error_log_id);
   check_err(stat,__LINE__,__FILE__);

   stat = nc_def_var(ncid, "detector_maximum_value", NC_FLOAT, RANK_detector_maximum_value, 0, &detector_maximum_value_id);
   check_err(stat,__LINE__,__FILE__);

   stat = nc_def_var(ncid, "detector_minimum_value", NC_FLOAT, RANK_detector_minimum_value, 0, &detector_minimum_value_id);
   check_err(stat,__LINE__,__FILE__);

   stat = nc_def_var(ncid, "actual_run_time_length", NC_FLOAT, RANK_actual_run_time_length, 0, &actual_run_time_length_id);
   check_err(stat,__LINE__,__FILE__);

   stat = nc_def_var(ncid, "actual_sampling_interval", NC_FLOAT, RANK_actual_sampling_interval, 0, &actual_sampling_interval_id);
   check_err(stat,__LINE__,__FILE__);

   stat = nc_def_var(ncid, "actual_delay_time", NC_FLOAT, RANK_actual_delay_time, 0, &actual_delay_time_id);
   check_err(stat,__LINE__,__FILE__);

   ordinate_values_dims[0] = point_number_dim;
   stat = nc_def_var(ncid, "ordinate_values", NC_FLOAT, RANK_ordinate_values, ordinate_values_dims, &ordinate_values_id);
   check_err(stat,__LINE__,__FILE__);

   raw_data_retention_dims[0] = point_number_dim;
   stat = nc_def_var(ncid, "raw_data_retention", NC_FLOAT, RANK_raw_data_retention, raw_data_retention_dims, &raw_data_retention_id);
   check_err(stat,__LINE__,__FILE__);

   peak_retention_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_retention_time", NC_FLOAT, RANK_peak_retention_time, peak_retention_time_dims, &peak_retention_time_id);
   check_err(stat,__LINE__,__FILE__);

   peak_name_dims[0] = peak_number_dim;
   peak_name_dims[1] = _32_byte_string_dim;
   stat = nc_def_var(ncid, "peak_name", NC_CHAR, RANK_peak_name, peak_name_dims, &peak_name_id);
   check_err(stat,__LINE__,__FILE__);

   peak_amount_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_amount", NC_FLOAT, RANK_peak_amount, peak_amount_dims, &peak_amount_id);
   check_err(stat,__LINE__,__FILE__);

   peak_start_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_start_time", NC_FLOAT, RANK_peak_start_time, peak_start_time_dims, &peak_start_time_id);
   check_err(stat,__LINE__,__FILE__);

   peak_end_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_end_time", NC_FLOAT, RANK_peak_end_time, peak_end_time_dims, &peak_end_time_id);
   check_err(stat,__LINE__,__FILE__);

   peak_width_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_width", NC_FLOAT, RANK_peak_width, peak_width_dims, &peak_width_id);
   check_err(stat,__LINE__,__FILE__);

   peak_area_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_area", NC_FLOAT, RANK_peak_area, peak_area_dims, &peak_area_id);
   check_err(stat,__LINE__,__FILE__);

   peak_area_percent_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_area_percent", NC_FLOAT, RANK_peak_area_percent, peak_area_percent_dims, &peak_area_percent_id);
   check_err(stat,__LINE__,__FILE__);

   peak_height_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_height", NC_FLOAT, RANK_peak_height, peak_height_dims, &peak_height_id);
   check_err(stat,__LINE__,__FILE__);

   peak_height_percent_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_height_percent", NC_FLOAT, RANK_peak_height_percent, peak_height_percent_dims, &peak_height_percent_id);
   check_err(stat,__LINE__,__FILE__);

   baseline_start_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "baseline_start_time", NC_FLOAT, RANK_baseline_start_time, baseline_start_time_dims, &baseline_start_time_id);
   check_err(stat,__LINE__,__FILE__);

   baseline_start_value_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "baseline_start_value", NC_FLOAT, RANK_baseline_start_value, baseline_start_value_dims, &baseline_start_value_id);
   check_err(stat,__LINE__,__FILE__);

   baseline_stop_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "baseline_stop_time", NC_FLOAT, RANK_baseline_stop_time, baseline_stop_time_dims, &baseline_stop_time_id);
   check_err(stat,__LINE__,__FILE__);

   baseline_stop_value_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "baseline_stop_value", NC_FLOAT, RANK_baseline_stop_value, baseline_stop_value_dims, &baseline_stop_value_id);
   check_err(stat,__LINE__,__FILE__);

   peak_start_detection_code_dims[0] = peak_number_dim;
   peak_start_detection_code_dims[1] = _2_byte_string_dim;
   stat = nc_def_var(ncid, "peak_start_detection_code", NC_CHAR, RANK_peak_start_detection_code, peak_start_detection_code_dims, &peak_start_detection_code_id);
   check_err(stat,__LINE__,__FILE__);

   peak_stop_detection_code_dims[0] = peak_number_dim;
   peak_stop_detection_code_dims[1] = _2_byte_string_dim;
   stat = nc_def_var(ncid, "peak_stop_detection_code", NC_CHAR, RANK_peak_stop_detection_code, peak_stop_detection_code_dims, &peak_stop_detection_code_id);
   check_err(stat,__LINE__,__FILE__);

   retention_index_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "retention_index", NC_FLOAT, RANK_retention_index, retention_index_dims, &retention_index_id);
   check_err(stat,__LINE__,__FILE__);

   migration_time_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "migration_time", NC_FLOAT, RANK_migration_time, migration_time_dims, &migration_time_id);
   check_err(stat,__LINE__,__FILE__);

   peak_asymmetry_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_asymmetry", NC_FLOAT, RANK_peak_asymmetry, peak_asymmetry_dims, &peak_asymmetry_id);
   check_err(stat,__LINE__,__FILE__);

   peak_efficiency_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "peak_efficiency", NC_FLOAT, RANK_peak_efficiency, peak_efficiency_dims, &peak_efficiency_id);
   check_err(stat,__LINE__,__FILE__);

   mass_on_column_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "mass_on_column", NC_FLOAT, RANK_mass_on_column, mass_on_column_dims, &mass_on_column_id);
   check_err(stat,__LINE__,__FILE__);

   manually_reintegrated_peaks_dims[0] = peak_number_dim;
   stat = nc_def_var(ncid, "manually_reintegrated_peaks", NC_SHORT, RANK_manually_reintegrated_peaks, manually_reintegrated_peaks_dims, &manually_reintegrated_peaks_id);
   check_err(stat,__LINE__,__FILE__);

   /* assign attributes */
   stat = nc_put_att_text(ncid, NC_GLOBAL, "dataset_completeness", 5, "C1+C2");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "aia_template_revision", 3, "1.0");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "netcdf_revision", 3, "2.0");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "languages", 7, "English");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "administrative_comments", 13, "none for now!");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "dataset_origin", strlen("Chemotron - LabChrom2"), "Chemotron - LabChrom2");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "dataset_owner", strlen("Chemotron Inc."), "Chemotron Inc.");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "dataset_date_time_stamp", 19, "00000000000000-0800");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "injection_date_time_stamp", 19, "00000000000000-0800");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "operator_name", 8, "Operator");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "separation_experiment_type", 21, "liquid chromatography");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "company_method_name", 11, "default.met");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "company_method_id", 11, "default_XYZ");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "pre_experiment_program_name", 5, "setup");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "post_experiment_program_name", 20, "response calibration");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "source_file_reference", 8, "test.cdl");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_id_comments", 4, "none");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_id", 1, "1");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_name", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_type", 7, "control");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_injection_volume", 4, "1.00");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "sample_amount", 4, "1.00");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "ss_int_std", 4, "1.00");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "detection_method_table_name", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "detection_method_name", 7, "default");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "detection_method_comments", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "detector_name", 4, "elsd");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "detector_unit", 15, "Absorbance Unit");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "raw_data_table_name", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "retention_unit", 15, "time in seconds");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, ordinate_values_id, "uniform_sampling_flag", 1, "Y");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, ordinate_values_id, "autosampler_position", 1, " ");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "peak_processing_results_table_name", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "peak_processing_results_table_comments", 1, "");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "peak_processing_method_name", 11, "test method");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "peak_processing_date_time_stamp", 19, "19910123084749-0800");
   check_err(stat,__LINE__,__FILE__);
   stat = nc_put_att_text(ncid, NC_GLOBAL, "peak_amount_unit", 5, "grams");
   check_err(stat,__LINE__,__FILE__);

   /* leave define mode */
   stat = nc_enddef (ncid);
   check_err(stat,__LINE__,__FILE__);

   {			/* store error_log */
    static char error_log[] = {"none\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"};
    stat = nc_put_var_text(ncid, error_log_id, error_log);
    check_err(stat,__LINE__,__FILE__);
   }

   {			/* store detector_maximum_value */
    float detector_maximum_value = Chrom[DataSource].ChromHead->Method.Instrument.Detectors[Chrom[DataSource].ActualDetector].ScaleValue;
    stat = nc_put_var_float(ncid, detector_maximum_value_id, &detector_maximum_value);
    check_err(stat,__LINE__,__FILE__);
   }

   {			/* store detector_minimum_value */
    float detector_minimum_value = Chrom[DataSource].ChromHead->Method.Instrument.Detectors[Chrom[DataSource].ActualDetector].ScaleValue/\
	                               Chrom[DataSource].ChromHead->Method.ADParameters.ADResolution;
    stat = nc_put_var_float(ncid, detector_minimum_value_id, &detector_minimum_value);
    check_err(stat,__LINE__,__FILE__);
   }

   {			/* store actual_run_time_length */
    float actual_run_time_length = CPTR(point_number_len, DataSource);
    stat = nc_put_var_float(ncid, actual_run_time_length_id, &actual_run_time_length);
    check_err(stat,__LINE__,__FILE__);
   }

   {			/* store actual_sampling_interval */
    float actual_sampling_interval = Chrom[DataSource].ChromHead->Method.MeasureParameters.SamplingRate;
    stat = nc_put_var_float(ncid, actual_sampling_interval_id, &actual_sampling_interval);
    check_err(stat,__LINE__,__FILE__);
   }

   {			/* store actual_delay_time */
    static float actual_delay_time = 0;
    stat = nc_put_var_float(ncid, actual_delay_time_id, &actual_delay_time);
    check_err(stat,__LINE__,__FILE__);
   }

   /*********************/
   /* store peak_values */
   /*                   */
   /*********************/
   {			/* store peak_name */
    static char peak_name[] = {"BACKFLUSH         \000\000\000\000\000\000\000\000\000\000\000\000\000\000BFX2              \000\000\000\000\000\000\000\000\000\000\000\000\000\000"};
    //stat = nc_put_var_text(ncid, peak_name_id, peak_name);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_retention_time */
    //float *peak_retention_time = calloc(peak_number_len, sizeof(float));
    //stat = nc_put_var_float(ncid, peak_retention_time_id, peak_retention_time);
	//free (peak_retention_time);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_amount */
    static float peak_amount[] = {60.749882, 36.071411};
    //stat = nc_put_var_float(ncid, peak_amount_id, peak_amount);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_start_time */
    static float peak_start_time[] = {11.5, 31};
    //stat = nc_put_var_float(ncid, peak_start_time_id, peak_start_time);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_end_time */
    static float peak_end_time[] = {24, 39};
    //stat = nc_put_var_float(ncid, peak_end_time_id, peak_end_time);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_area */
    static float peak_area[] = {60.749882, 36.071411};
    //stat = nc_put_var_float(ncid, peak_area_id, peak_area);
    //check_err(stat,__LINE__,__FILE__);
   }

   {			/* store peak_height */
    static float peak_height[] = {8.2216663, 7.294641};
    //stat = nc_put_var_float(ncid, peak_height_id, peak_height);
    //check_err(stat,__LINE__,__FILE__);
   }
 
   {			/* store manually_reintegrated_peaks */
    static short manually_reintegrated_peaks[] = {0, 1};
    //stat = nc_put_var_short(ncid, manually_reintegrated_peaks_id, manually_reintegrated_peaks);
    //check_err(stat,__LINE__,__FILE__);
   }

   /*************************/
   /* store ordinate_values */
   /*                       */
   /*************************/
   {			
    //static float ordinate_values[] = {		};
	float *ordinate_values = calloc (point_number_len, sizeof(float));
	for (i = 0; i < point_number_len; i++)
		ordinate_values[i] = ChromData (i, DataSource);
    stat = nc_put_var_float(ncid, ordinate_values_id, ordinate_values);
	free (ordinate_values);
    check_err(stat,__LINE__,__FILE__);
   }
   
   /* end of netcdf export */
   stat = nc_close(ncid);
   check_err(stat,__LINE__,__FILE__);
} // NetCDFExport

extern void
NetCDFImport (int DataSource, char *FileName) {
} // NetCDFImport

/*
extern
void	LayerSave(void) {
FILE	*LayerFile;
int		BlockOut;

	FileError = TRUE;
	LayerFile = fopen(Filename,"wb");
	
	if (LayerFile != NULL) {
		Layer.FileIdentifier.FileID = LayFlag;
		strcpy (Layer.FileIdentifier.LabChromID,LabChromID);
		strcpy (Layer.FileIdentifier.LabChromText,LabChromText);
		sscanf (VERSION,"%d.%d.%d",&Layer.FileIdentifier.MainVersion, &Layer.FileIdentifier.SubVersion, &Layer.FileIdentifier.ServiceVersion);
		BlockOut = fwrite(&Layer,sizeof(struct LayerStruct),1,LayerFile);
		BlockOut = fwrite (&LayerItems, sizeof(struct QueueStruct), MaxLayerItem, LayerFile);
		FileError = FALSE;
		fclose (LayerFile);
		if (PrintfMode) printf ("Layer save OK.\n");
	} // if LayerFile != NULL
	} // LayerSave

extern
void	LayerLoad(void) {
FILE	*LayerFile;
int		BlockIn;

	FileError = TRUE;
	LayerFile = fopen(Filename,"rb");

	if (LayerFile != NULL) {
		if (FileCheck (LayFlag, LayerFile) == TRUE) {
		BlockIn = fread(&Layer,sizeof(struct LayerStruct),1,LayerFile);
		BlockIn = fread (&LayerItems, sizeof(struct QueueStruct), MaxLayerItem, LayerFile);
		FileError = FALSE;
		} // if FileCheck
		strcpy(LayName,Filename);
		fclose (LayerFile);
		if (PrintfMode) printf ("Layer open OK.\n");
		FileLoaded [LayFlag] = TRUE;
	} else {
		FileOpenErrorMessage = create_FileOpenErrorMessage ();
		gtk_widget_show (FileOpenErrorMessage);
		FileLoaded [LayFlag] = FALSE;
	} // if LayerFile != NULL
	} // LayerLoad

extern
void	CalibrSave(void) {
FILE	*CalibrFile;
int		BlockOut;

	FileError = TRUE;
	CalibrFile = fopen(Filename,"wb");
	
	if (CalibrFile != NULL) {
		CalibrHead.FileIdentifier.FileID = CalFlag;
		strcpy (CalibrHead.FileIdentifier.LabChromID,LabChromID);
		strcpy (CalibrHead.FileIdentifier.LabChromText,LabChromText);
		sscanf (VERSION,"%d.%d.%d",&CalibrHead.FileIdentifier.MainVersion, &CalibrHead.FileIdentifier.SubVersion, &CalibrHead.FileIdentifier.ServiceVersion);
		BlockOut = fwrite (&CalibrHead,sizeof(struct CalibrHeadStruct),1,CalibrFile);
		BlockOut = fwrite (&CalibrComponents, sizeof(struct CalibrComponentStruct), CalibrMaxComponent, CalibrFile);
		BlockOut = fwrite (&CalibrLevels, sizeof(struct CalibrLevelStruct), CalibrMaxLevel, CalibrFile);
		BlockOut = fwrite (&CalibrChroms, sizeof(struct CalibrChromStruct), CalibrMaxLevel*CalibrMaxChrom, CalibrFile);
		BlockOut = fwrite (&CalibrCells, sizeof(struct CalibrCellStruct), CalibrMaxComponent*CalibrMaxLevel*CalibrMaxChrom, CalibrFile);
		BlockOut = fwrite (&CalibrConcs, sizeof(struct CalibrConcStruct), CalibrMaxComponent*CalibrMaxLevel, CalibrFile);
		FileError = FALSE;
		FileSaved[CalFlag] = TRUE;
		FileLoaded[CalFlag] = TRUE;
		strcpy (CalName, Filename);
		fclose (CalibrFile);
		if (PrintfMode) printf ("Calibr save OK.\n");
	} // if CalibrFile != NULL
	} // CalibrSave

extern
void	CalibrLoad(void) {
FILE	*CalibrFile;
int		BlockIn;

	FileError = TRUE;
	CalibrFile = fopen(Filename,"rb");
	
	if (CalibrFile != NULL) {
		if (FileCheck (CalFlag, CalibrFile) == TRUE) {
		BlockIn = fread (&CalibrHead,sizeof(struct CalibrHeadStruct),1,CalibrFile);
		BlockIn = fread (&CalibrComponents, sizeof(struct CalibrComponentStruct), CalibrMaxComponent, CalibrFile);
		BlockIn = fread (&CalibrLevels, sizeof(struct CalibrLevelStruct), CalibrMaxLevel, CalibrFile);
		BlockIn = fread (&CalibrChroms, sizeof(struct CalibrChromStruct), CalibrMaxLevel*CalibrMaxChrom, CalibrFile);
		BlockIn = fread (&CalibrCells, sizeof(struct CalibrCellStruct), CalibrMaxComponent*CalibrMaxLevel*CalibrMaxChrom, CalibrFile);
		BlockIn = fread (&CalibrConcs, sizeof(struct CalibrConcStruct), CalibrMaxComponent*CalibrMaxLevel, CalibrFile);
		FileLoaded[CalFlag] = TRUE;
		FileSaved[CalFlag] = TRUE;
		FileError = FALSE;
		} // if FileCheck
		strcpy (CalName,Filename);
		fclose (CalibrFile);
		if (PrintfMode) printf ("Calibr open OK.\n");
	} else {
		FileOpenErrorMessage = create_FileOpenErrorMessage ();
		gtk_widget_show (FileOpenErrorMessage);
	} // if CalibrFile != NULL
	} // CalibrLoad

*/
