// Data field (structure) initialization functions

extern void
NewIntPar (struct IntegrationParametersStruct *IntParForNew) {
  bzero (IntParForNew, sizeof(struct IntegrationParametersStruct));

  IntParForNew->PozSlope = 0.001;
  IntParForNew->NegSlope = -0.001;
  IntParForNew->MinArea = 1;
  IntParForNew->MinLevel = 1;
  IntParForNew->MinWidth = 0.1;
  IntParForNew->SolventSlope = 1000;
  IntParForNew->SolventArea = 1000;
  IntParForNew->SolventHeight = 1000;
  IntParForNew->SolventWidth = 10;
  IntParForNew->FollowUp = 1;
  IntParForNew->FollowAx = 1;
  IntParForNew->FollowDn = 1;
  IntParForNew->Poz2Slope = 0.001;
  IntParForNew->Poz2Level = 0.001;
  IntParForNew->Neg2Slope = -0.001;
  IntParForNew->Neg2Level = -0.001;
  IntParForNew->DetSmooth = 1;
  IntParForNew->BaseLineDrift = 0;
  IntParForNew->NoiseLevel = 0;
  IntParForNew->LockWait = 0.1;
  IntParForNew->HeightF = 1;
  IntParForNew->TimeF = 1;
  IntParForNew->CloseF = 10;
  IntParForNew->TangentF = 10;
} // NewIntPar

extern void
NewMethod (struct MethodStruct *MethodForNew) {
int j;

  bzero (MethodForNew, sizeof(struct MethodStruct));
  for ( j = 0; j < MaxDetectors; j++)
	  NewIntPar (&MethodForNew->IntegrationParameters[j]);
} // NewMethod

extern void
NewInstrumentDataStructure (void) {
int		i,j;
/*
  for (i = 0; i < MaxInstruments + 1; i++) {
	strcpy (Instruments[i].InstrumentName,"");
	Instruments[i].InstrumentType = 0;
	Instruments[i].ChromatographType = 0;
	Instruments[i].IOPortMenuIndex = 0;
	strcpy (Instruments[i].IOPortName,"");
	strcpy (Instruments[i].IconForInstrument,"");
	Instruments[i].AutoStart = FALSE;
	Instruments[i].InstrumentSamplingMode = 0;
	Instruments[i].ADParameters.ADDeviceId = 0;
	strcpy (Instruments[i].ADParameters.ADDeviceName,"");
	Instruments[i].ADParameters.ADResolution = 1;
	Instruments[i].ADParameters.ADZeroPoint = 0;
	Instruments[i].ADParameters.ADBaseSamplingTime = 1;
	Instruments[i].ADParameters.ADBaseSamplingFrequencyInHz = 1;
	for (j = 0; j < MaxADSamplingArray; j++) {
	  Instruments[i].ADParameters.ADSamplingTimeTable[j] = 1;
	  Instruments[i].ADParameters.ADSamplingFrequencyTable[j] = 1;
	  Instruments[i].ADParameters.ADSamplingAccumulationTable[j] = 1;
	} // j
  } // i
  */
} // NewInstrumentDataStructure

extern void
ClearInstrumentDataStructure (int Idx) {
int		j;
/*
  strcpy (Instruments[Idx].InstrumentName,"");
  Instruments[Idx].InstrumentType = 0;
  Instruments[Idx].ChromatographType = 0;
  Instruments[Idx].IOPortMenuIndex = 0;
  strcpy (Instruments[Idx].IOPortName,"");
  strcpy (Instruments[Idx].IconForInstrument,"");
  Instruments[Idx].AutoStart = FALSE;
  Instruments[Idx].InstrumentSamplingMode = 0;
  Instruments[Idx].ADParameters.ADDeviceId = 0;
  strcpy (Instruments[Idx].ADParameters.ADDeviceName,"");
  Instruments[Idx].ADParameters.ADResolution = 1;
  Instruments[Idx].ADParameters.ADZeroPoint = 0;
  Instruments[Idx].ADParameters.ADBaseSamplingTime = 1;
  Instruments[Idx].ADParameters.ADBaseSamplingFrequencyInHz = 1;
  for (j = 0; j < MaxADSamplingArray; j++) {
	Instruments[Idx].ADParameters.ADSamplingTimeTable[j] = 1;
	Instruments[Idx].ADParameters.ADSamplingFrequencyTable[j] = 1;
	Instruments[Idx].ADParameters.ADSamplingAccumulationTable[j] = 1;
  } // j
  */
} // ClearInstrumentDataStructure

extern void
NewChromHead (struct ChromHeadStruct *ChromHeadToReset) {

  bzero (ChromHeadToReset, sizeof (struct ChromHeadStruct));

//  NewMethod (&ChromHeadToReset->Method);
//  NewCalibrHead (&ChromHeadToReset->CalibrHead);
} // NewChromHead

extern void
SetChromParameters(int DataSource) {
int		i;
struct ChromHeadStruct *ChromHeadForSet;

  ChromHeadForSet = Chrom[DataSource].ChromHead;

  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].SmoothMethod = ChromHeadForSet->Method.MeasureParameters.SmoothMethod;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].SmoothFactor1 = ChromHeadForSet->Method.MeasureParameters.SmoothFactor1;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].SmoothFactor2 = ChromHeadForSet->Method.MeasureParameters.SmoothFactor2;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].SmoothParameter = ChromHeadForSet->Method.MeasureParameters.SmoothParameter;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMin = ChromData(0, DataSource);
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMax = ChromData(0, DataSource);
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMinSmoothed = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMaxSmoothed = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].Der1Min = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].Der1Max = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].Der2Min = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].Der2Max = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RelRet0 = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RelRetRef = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RetCorr = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RetT0 = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RetSamplingLine = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RetFrontLine = 0;
  for (i = 0; i < ChromHeadForSet->Method.MeasureParameters.Nmp; i++) {
	  if (ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMin>ChromData(i, DataSource))
		  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMin = ChromData(i, DataSource);
	  if (ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMax<ChromData(i, DataSource))
		  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMax = ChromData(i, DataSource);
	  } // for i
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RepMin = ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMin;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RepMax = ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].ChrMax;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RepBeg = 0;
  ChromHeadForSet->Parameter[Chrom[DataSource].ActualDetector].RepEnd = ChromHeadForSet->Method.MeasureParameters.Nmp - 1;
  } // SetChromParameters

extern void
NewSpectra (struct SpectraStruct *SpectraForInit) {
  bzero (SpectraForInit, sizeof (struct SpectraStruct));
  SpectraForInit->UVRefWaveLength = 200;
  SpectraForInit->VISRefWaveLength = 360;
  SpectraForInit->SampleXPosition = 10;
  SpectraForInit->SampleYPosition = 10;
  SpectraForInit->RefXPosition = 10;
  SpectraForInit->RefYPosition = 10;
  Chrom[WorkArea].FileLoaded[SpeFlag] = TRUE;
  Chrom[WorkArea].FileSaved[SpeFlag] = TRUE;
} // NewSpectra

extern void
NewSampleQueue (int DataSource) {
  bzero (&Chrom[DataSource].QueueHead, sizeof(struct LayerQueueHeadStruct));
  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));
  bzero (Chrom[DataSource].QueueItemArray, Chrom[DataSource].LayerQueueActualSize*sizeof (struct QueueItemStruct));
  strcpy (Chrom[DataSource].LayerQueueName, "");
} // NewSampleQueue
