// Core functions

extern int
CRTP(double Ret, int DataSource) {
int			C;
struct		ChromHeadStruct *ChromHeadActual;

  ChromHeadActual = Chrom[DataSource].ChromHead;
  C = ChromHeadActual->Method.Instrument.SamplingMode==InstrumentSamplingInMin
	? (int) (60*Ret/ChromHeadActual->Method.MeasureParameters.SamplingRate+0.5)
	: (int) (Ret/ChromHeadActual->Method.MeasureParameters.SamplingRate+0.5);
  return C;
} // CRTP ConvertRetTimeToPoint

extern double
CPTR(int Point, int DataSource) {
double		C;
struct		ChromHeadStruct *ChromHeadActual;

  ChromHeadActual = Chrom[DataSource].ChromHead;
  C = ChromHeadActual->Method.Instrument.SamplingMode==InstrumentSamplingInMin
	? Point*ChromHeadActual->Method.MeasureParameters.SamplingRate/60
	: Point*ChromHeadActual->Method.MeasureParameters.SamplingRate;
  return C;
} // CPTR ConvertPointToRetTime

extern double
ChromData (int Idx, int DataSource) {
int CDi;
double CD;
int *CDA;
double CDPar;
int CDRes;
int NMP;
int F2;
int D;
int CDiT;
int j;

  CDA = Chrom[DataSource].ChromDataArrays[Chrom[DataSource].ActualDetector];
  NMP = Chrom[DataSource].ChromHead->Method.MeasureParameters.Nmp;
  if ((Idx>Chrom[DataSource].ChromDataArrayActualSize) || (Idx==Chrom[DataSource].ChromDataArrayActualSize)) Idx = Chrom[DataSource].ChromDataArrayActualSize - 1;
  if (Idx<0) Idx = 0;
  CDi = CDA[Idx];
  // Smooth
  switch (Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].SmoothMethod) {
	  case SmoothTriangle:
		  switch (Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].SmoothFactor1) {
			  case 0:
				  CDi = CDA[Idx];
				  break;
			  case 1:
				  if ((Idx > 0) && (Idx < (NMP - 1)))
					  CDi = (CDA[Idx-1] + 2*CDA[Idx] + CDA[Idx+1]) / 4;
				  break;
			  case 2:
				  if ((Idx > 1) && (Idx < (NMP - 2)))
					  CDi = (CDA[Idx-2] + 2*CDA[Idx-1] + 3*CDA[Idx] + 2*CDA[Idx+1] + CDA[Idx+2]) / 9;
				  break;
			  case 3:
				  if ((Idx > 2) && (Idx < (NMP - 3)))
					  CDi = (CDA[Idx-3] + 2*CDA[Idx-2] + 3*CDA[Idx-1] + 4*CDA[Idx] + 3*CDA[Idx+1] + 2*CDA[Idx+2] + CDA[Idx+3]) / 16;
				  break;
			  case 4:
				  F2 = Chrom[DataSource].ChromHead->Parameter[Chrom[DataSource].ActualDetector].SmoothFactor2;
				  D = 0;
				  CDiT = 0;
				  if (((F2 > 3) && (F2 < 17)) &&\
					  ((Idx > (F2 - 1)) && (Idx < (NMP - F2)))){
					  for (j = 0; j < F2; j++) {
						  D += 2*(j +1);
						  CDiT += (j + 1)*(CDA[Idx - j - 1] + CDA[Idx + j + 1]);
					  } // j
					  D += (F2 + 1);
					  CDiT += (F2 + 1)*CDA[Idx];
					  CDi = CDiT / D;
				  }
				  break;
		  } // switch SmoothTriangle/SmoothFactor1
		  break;
  } // switch SmoothTriangle
  
  // Scaling
  if (Chrom[DataSource].ChromHead->Method.ADParameters.ADResolution < 1)
	  CDRes = 1;
  else
	  CDRes = Chrom[DataSource].ChromHead->Method.ADParameters.ADResolution;
  CDPar = Chrom[DataSource].ChromHead->Method.Instrument.Detectors[Chrom[DataSource].ActualDetector].ScaleValue;
  CD = CDPar * (double)CDi / (double)CDRes;
  return CD;
} // ChromData

// Memory allocations

extern void
ReallocChromData (int ChromArraySize, int DataSource) {
int j;

  if (ChromArraySize < Chrom[DataSource].ChromDataArrayActualSize) return;

  Chrom[DataSource].ChromDataArrayActualSize = ChromArraySize + 1000;
  for (j = 0; j < MaxDetectors; j++)
	  Chrom[DataSource].ChromDataArrays[j] = realloc (Chrom[DataSource].ChromDataArrays[j], \
											 Chrom[DataSource].ChromDataArrayActualSize * sizeof (int));
} // ReallocChromData

extern
void ReallocPeakData (int PeakArraySize, int DataSource) {
int		j;

BT_INIT();

  if (PeakArraySize < Chrom[DataSource].PeakArrayActualSize) return;

  Chrom[DataSource].PeakArrayActualSize = PeakArraySize + 100;
  for (j = 0; j < MaxDetectors; j++) {
	  Chrom[DataSource].PeakArray[j] = realloc (Chrom[DataSource].PeakArray[j], \
									   Chrom[DataSource].PeakArrayActualSize * sizeof (struct PeakStruct));
	  if (Chrom[DataSource].PeakArray[j] == NULL) {
		  sprintf (BugTraceUserString, "***   Chrom[%d].PeakArray[%d] == NULL ***", DataSource, j);
		  BUGTRACE (BugTraceUserString);
		  } // if
	  } // j
} // ReallocPeakData

extern void
ReallocCalibrTemplateChromData (int ChromArraySize, int DataSource) {
int j;

  if (ChromArraySize < Chrom[DataSource].CalibrTemplateChromDataArrayActualSize) return;

  Chrom[DataSource].CalibrTemplateChromDataArrayActualSize = ChromArraySize + 1000;
  for (j = 0; j < MaxDetectors; j++)
	  Chrom[DataSource].CalibrTemplateChromDataArrays[j] = \
		  realloc (Chrom[DataSource].CalibrTemplateChromDataArrays[j], \
		  Chrom[DataSource].CalibrTemplateChromDataArrayActualSize * sizeof (int));
} // ReallocCalibrTemplateChromData

extern
void ReallocCalibrTemplatePeakData (int PeakArraySize, int DataSource) {
int		j;

BT_INIT();

  if (PeakArraySize < Chrom[DataSource].CalibrTemplatePeakArrayActualSize) return;

  Chrom[DataSource].CalibrTemplatePeakArrayActualSize = PeakArraySize + 100;
  for (j = 0; j < MaxDetectors; j++) {
	  Chrom[DataSource].CalibrTemplatePeakArray[j] = \
		  realloc (Chrom[DataSource].CalibrTemplatePeakArray[j], \
		  Chrom[DataSource].CalibrTemplatePeakArrayActualSize * sizeof (struct PeakStruct));
	  if (Chrom[DataSource].CalibrTemplatePeakArray[j] == NULL) {
		  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrTemplatePeakArray[%d] == NULL ***", DataSource, j);
		  BUGTRACE (BugTraceUserString);
		  } // if
	  } // j
} // ReallocCalibrTemplatePeakData

extern void
ReallocCalibrChromChromData (int ChromArraySize, int DataSource) {
int j;

  if (ChromArraySize < Chrom[DataSource].CalibrChromDataArrayActualSize) return;

  Chrom[DataSource].CalibrChromDataArrayActualSize = ChromArraySize + 1000;
  for (j = 0; j < MaxDetectors; j++)
	  Chrom[DataSource].CalibrChromDataArrays[j] = \
		  realloc (Chrom[DataSource].CalibrChromDataArrays[j], \
		  Chrom[DataSource].CalibrChromDataArrayActualSize * sizeof (int));
} // ReallocCalibrChromChromData

extern
void ReallocCalibrChromPeakData (int PeakArraySize, int DataSource) {
int		j;

BT_INIT();

  if (PeakArraySize < Chrom[DataSource].CalibrPeakArrayActualSize) return;

  Chrom[DataSource].CalibrPeakArrayActualSize = PeakArraySize + 100;
  for (j = 0; j < MaxDetectors; j++) {
	  Chrom[DataSource].CalibrPeakArray[j] = \
		  realloc (Chrom[DataSource].CalibrPeakArray[j], \
		  Chrom[DataSource].CalibrPeakArrayActualSize * sizeof (struct PeakStruct));
	  if (Chrom[DataSource].CalibrPeakArray[j] == NULL) {
		  sprintf (BugTraceUserString, "***   Chrom[DataSource].CalibrPeakArray[j] == NULL ***");
		  BUGTRACE (BugTraceUserString);
		  } // if
	  } // j
} // ReallocCalibrChromPeakData

extern void
ReallocCalibrComponentData (int ComponentArraySize, int DataSource) {
BT_INIT();

  if (ComponentArraySize < Chrom[DataSource].CalibrComponentActualSize) return;

  Chrom[DataSource].CalibrComponentActualSize = ComponentArraySize + 10;
  Chrom[DataSource].CalibrComponentArray = \
	  realloc (Chrom[DataSource].CalibrComponentArray, \
	  Chrom[DataSource].CalibrComponentActualSize * sizeof (struct CalibrComponentStruct));
  if (Chrom[DataSource].CalibrComponentArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrComponentArray == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocCalibrComponentData

extern void
ReallocCalibrLevelData (int LevelArraySize, int DataSource) {
BT_INIT();

  if (LevelArraySize < Chrom[DataSource].CalibrLevelActualSize) return;

  Chrom[DataSource].CalibrLevelActualSize = LevelArraySize + 10;
  Chrom[DataSource].CalibrLevelArray = \
	  realloc (Chrom[DataSource].CalibrLevelArray, \
	  Chrom[DataSource].CalibrLevelActualSize * sizeof (struct CalibrLevelStruct));
  if (Chrom[DataSource].CalibrLevelArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrLevelArray == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocCalibrLevelData

extern void
ReallocCalibrChromData (int ChromArraySize, int DataSource) {
BT_INIT();

  if (ChromArraySize < Chrom[DataSource].CalibrChromActualSize) return;

  Chrom[DataSource].CalibrChromActualSize = ChromArraySize + 10;
  Chrom[DataSource].CalibrChromArray = \
	  realloc (Chrom[DataSource].CalibrChromArray, \
	  Chrom[DataSource].CalibrChromActualSize * sizeof (struct CalibrChromStruct));
  if (Chrom[DataSource].CalibrChromArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrChromArray == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocCalibrChromData

extern void
ReallocCalibrCellData (int CellArraySize, int DataSource) {
BT_INIT();

  if (CellArraySize < Chrom[DataSource].CalibrCellActualSize) return;

  Chrom[DataSource].CalibrCellActualSize = CellArraySize + 10;
  Chrom[DataSource].CalibrCellArray = \
	  realloc (Chrom[DataSource].CalibrCellArray, \
	  Chrom[DataSource].CalibrCellActualSize * sizeof (struct CalibrCellStruct));
  if (Chrom[DataSource].CalibrCellArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrCellArray == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocCalibrCellData

extern void
ReallocCalibrConcData (int ConcArraySize, int DataSource) {
BT_INIT();

  if (ConcArraySize < Chrom[DataSource].CalibrConcActualSize) return;

  Chrom[DataSource].CalibrConcActualSize = ConcArraySize + 10;
  Chrom[DataSource].CalibrConcArray = \
	  realloc (Chrom[DataSource].CalibrConcArray, \
	  Chrom[DataSource].CalibrConcActualSize * sizeof (struct CalibrConcStruct));
  if (Chrom[DataSource].CalibrConcArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].CalibrConcArray == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocCalibrConcData

extern void
ReallocQueueData (int QueueArraySize, int DataSource) {
BT_INIT();

  if (QueueArraySize < Chrom[DataSource].LayerQueueActualSize) return;

  Chrom[DataSource].LayerQueueActualSize = QueueArraySize + 10;
  Chrom[DataSource].QueueItemArray = \
	  realloc (Chrom[DataSource].QueueItemArray, \
	  Chrom[DataSource].LayerQueueActualSize * sizeof (struct QueueItemStruct));
  if (Chrom[DataSource].QueueItemArray == NULL) {
	  sprintf (BugTraceUserString, "***   Chrom[%d].QueueItem == NULL ***", DataSource);
	  BUGTRACE (BugTraceUserString);
  } // if NULL
} // ReallocQueueData

extern void
ConvertImportRawData (GtkWidget *ImportMainWidget) {
int					*ImportData;
int					*ImportSizedData;
int					*TempData;
int					*TempSizedData;
int					DataSize;
int					DataSizedSize;
int					MaxData;
int					i,j;

  ImportData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataPointer");
  DataSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSize"));

  ImportSizedData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedPointer");
  DataSizedSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedSize"));

  if (!Chrom[WorkArea].FileLoaded[ImpFlag]) {
	  
	  
	  return;
  } // FileLoaded[ImpFlag] == FALSE

  TempData = calloc (DataSize, sizeof (int));
  TempSizedData = calloc (DataSize, sizeof (int));
  // Upload defaults
  DataSizedSize = DataSize;
  for (i = 0; i < DataSize; i++) ImportSizedData[i] = ImportData[i];
  for (i = 0; i < DataSize; i++) TempData[i] = ImportData[i];
  for (i = 0; i < DataSize; i++) TempSizedData[i] = ImportData[i];

  // Pre-decimation smooth
  TempData[0] = ImportData[0];
  TempData[DataSize-1] = ImportData[DataSize-1];
  for (i = 1; i < DataSize-1; i++) TempData[i] = (ImportData[i-1] + 2*ImportData[i] + ImportData[i+1]) / 4;

  // Decimation
  if (ImportDecimation < 1) ImportDecimation = 1;
  DataSizedSize = DataSize / ImportDecimation;

  for (i = 0; i < DataSizedSize; i++) {
	  TempSizedData[i] = 0;
	  for (j = 0; j < ImportDecimation; j++) TempSizedData[i] += TempData[i*ImportDecimation + j];
	  TempSizedData[i] = (TempSizedData[i]) / ImportDecimation;
  } // i

  // Post-decimation smooth
  ImportSizedData[0] = TempSizedData[0];
  ImportSizedData[DataSizedSize-1] = TempSizedData[DataSizedSize-1];
  for (i = 1; i < DataSizedSize-1; i++) ImportSizedData[i] = (TempSizedData[i-1] + 2*TempSizedData[i] + TempSizedData[i+1]) / 4;

  if (ImportRevert == TRUE) {
	  MaxData = ImportSizedData[0];
	  for (i = 0; i < DataSizedSize; i++)
		  if (MaxData < ImportSizedData[i]) MaxData = ImportSizedData[i];
 	  for (i = 0; i < DataSizedSize; i++)
		  ImportSizedData[i] = MaxData - ImportSizedData[i];
 } // ImportRevert

  gtk_object_set_data (GTK_OBJECT (ImportMainWidget), "DataSizedSize", GINT_TO_POINTER (DataSizedSize));

  free (TempSizedData);
  free (TempData);
} // ConvertImportRawData

extern void
ConvertImportRawDataToChrom (GtkWidget *ImportMainWidget) {
int					*ImportData;
int					*ImportSizedData;
int					DataSize;
int					DataSizedSize;
int					i,j;
int					*CDA;

  ImportData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataPointer");
  DataSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSize"));

  ImportSizedData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedPointer");
  DataSizedSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedSize"));

  NewChromHead(Chrom[WorkArea].ChromHead);
//  ChromHead->Method = Method;

  Chrom[WorkArea].ActualDetector = 0;
  Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors = 1;
  strcpy (Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[0].Name, "Virtual");
  for (j = 0; j < MaxDetectors; j++)
	  Chrom[WorkArea].ChromHead->PeakHead.PeakNum[j] = 0;
  Chrom[WorkArea].ChromHead->PeakHead.PeakNumUpper = 0;
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.ImportTime = time (NULL);
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp = DataSizedSize;
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.DetSetting = ImportScaleFactor;
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.DigitalResolution = ImportResolution;
  strcpy (Chrom[WorkArea].ChromHead->Method.MeasureParameters.ScaleXDim, "min");
  Chrom[WorkArea].ChromHead->Method.Instrument.SamplingMode = InstrumentSamplingInMin;
  switch (ImportXAxisMenuIndex) {
	  case 0:strcpy (Chrom[WorkArea].ChromHead->Method.MeasureParameters.ScaleXDim, "min");
		  Chrom[WorkArea].ChromHead->Method.Instrument.SamplingMode = InstrumentSamplingInMin;
		  break;
	  case 1:strcpy (Chrom[WorkArea].ChromHead->Method.MeasureParameters.ScaleXDim, "sec");
		  Chrom[WorkArea].ChromHead->Method.Instrument.SamplingMode = InstrumentSamplingInSec;
		  break;
	  case 2:strcpy (Chrom[WorkArea].ChromHead->Method.MeasureParameters.ScaleXDim, "mm");
		  Chrom[WorkArea].ChromHead->Method.Instrument.SamplingMode = InstrumentSamplingInMM;
		  break;
  } // switch
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.SamplingRate = ImportXResolution * ImportDecimation;
  Chrom[WorkArea].ChromHead->Method.MeasureParameters.ImportFlag = TRUE;
//  ChromHead->Method.MeasureParameters.
//  ChromHead->Method.MeasureParameters.


  CDA = Chrom[WorkArea].ChromDataArrays[0];
  ReallocChromData (Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp, WorkArea);
  for (i=0; i<Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp; i++)
  {
	  CDA[i] = ImportSizedData[i];
  } // for i
  SetChromParameters(WorkArea);

  strcpy (Chrom[WorkArea].Filename, ImportFileName);
  strcat (Chrom[WorkArea].Filename, ".chr");
  strcpy (Chrom[WorkArea].ChromHead->Method.MeasureParameters.OrigChromName, Chrom[WorkArea].Filename);
  Chrom[WorkArea].FileLoaded[ChrFlag] = TRUE;
  PRINTF ("Imported chromatogram filename: %s\n", Chrom[WorkArea].Filename);
  ChromSave (WorkArea);
} // ConvertImportRawDataToChrom

extern char*
GetTemplateRow (FILE *TemplateFile) {
char InputRow[MaxTemplateRowLength];
char *OutputRow;
char *ReturnRow;

  OutputRow = NULL;
  ReturnRow = fgets (InputRow, MaxTemplateRowLength - 1, TemplateFile);
  if (ReturnRow != NULL) {
	  if (strlen (InputRow) >= MaxTemplateRowLength - 2)
		  return OutputRow;
	  OutputRow = calloc (MaxTemplateRowLength, sizeof(char));
	  strcpy (OutputRow, InputRow);
  } else {
	  if (ferror (TemplateFile)) {
		  clearerr (TemplateFile);
	  }
  }

  return OutputRow;
} // GetTemplateRow

extern char*
ProcessTemplateRow (char *InputRow) {
char *OutputRow;
int i,j;

  OutputRow = NULL;
  if (strlen (InputRow) < 1)
	  return OutputRow;
  if (InputRow[0] == '#')
	  return OutputRow;
  OutputRow = calloc (MaxTemplateRowLength, sizeof(char));
  for (i = 0; i < strlen (InputRow); i++) {
  } // i

  return OutputRow;
} // ProcessTemplateRow

extern void
EvaluateTemplateCmd (int DataSource, char *CmdStr, char *ParStr, char *OutStr, int *OutCounter) {
#include "template_variables.c"
int i, j;
char *TmpStr;
int TmpCounter;
int TmpOutCounter;

  printf ("CmdStr = %s,   ParStr = %s\n", CmdStr, ParStr);
  TmpStr = calloc (2000, sizeof(char));
  for (i = 0; i < TEMPLATE_LAST; i++) {
	  if (strcmp (CmdStr, TemplateVarNames[i]) == 0) {
		  printf ("Command: %s found\n", TemplateVarNames[i]);
		  switch (i) {
			  case TEMPLATE_CHR_NAME:
				  strcpy (TmpStr, Chrom[DataSource].ChrName);
				  break;
			  case TEMPLATE_PEAK_NUM:
				  break;
		  } // switch i
	  } // if strcmp
  } // i
  TmpCounter = 0;
  TmpOutCounter = *OutCounter;
  while (TmpStr[TmpCounter] != '\0') {
	  OutStr[TmpOutCounter] = TmpStr[TmpCounter];
	  TmpOutCounter++;
	  TmpCounter++;
  }
  OutStr[TmpOutCounter] = '\0';
  *OutCounter = TmpOutCounter;
  free (TmpStr);
} // EvaluateTemplateCmd

extern char *
ProcessTemplateString (char *InString, int DataSource, int ActDSI, int InEncDef, int OutEncDef) {
#define TemplateCmdLength 256
int WorkStrL;
int LineCounter;
char *WorkInString;
char *WorkOutString;
char *RetString;
char VarStr[TemplateCmdLength];
char ParStr[TemplateCmdLength];
gboolean ParseErr;
gboolean ParseEnd;

int StrInPtr;
int StrOutPtr;
int StrVarPtr;
gboolean NewLineStatus;
int EncIn;
int EncOut;
char *ConvStr;
gsize ByteIn, ByteOut;

  WorkStrL = strlen (InString);
  if (WorkStrL < 1) return NULL;

  // In encoding settings
  EncIn = Options[ActDSI].ExportInputEnc;
  if (EncIn == EXPORT_INPUT_ENC_DEFAULT)
	  EncIn = InEncDef;
  switch (EncIn) {
	  case EXPORT_INPUT_ENC_DEFAULT:
		  WorkInString = calloc (WorkStrL + 1, sizeof(char));
		  strcpy (WorkInString, InString);
		  break;
	  case EXPORT_INPUT_ENC_LOCALE:
		  ConvStr = g_locale_to_utf8 (InString, -1, &ByteIn, &ByteOut, NULL);
		  WorkInString = calloc(strlen(ConvStr) + 1, sizeof(char));
		  strcpy (WorkInString, ConvStr);
		  g_free (ConvStr);
		  break;
	  case EXPORT_INPUT_ENC_UTF8:
		  WorkInString = calloc (WorkStrL + 1, sizeof(char));
		  strcpy (WorkInString, InString);
		  break;
	  case EXPORT_INPUT_ENC_OTHER:
		  WorkInString = calloc (WorkStrL + 1, sizeof(char));
		  strcpy (WorkInString, InString);
		  break;
	  default:{
	  } // default
  } // switch

  // Processing
  StrInPtr = 0;
  StrOutPtr = 0;
  NewLineStatus = TRUE;
  WorkOutString = calloc (3*WorkStrL, sizeof(char));
  ParseErr = FALSE;
  LineCounter = 1;
  while ((WorkInString[StrInPtr] != '\0') && (!ParseErr)){
	  switch (WorkInString[StrInPtr]) {
		  case '#':
			  if (NewLineStatus) {
				  while (WorkInString[StrInPtr] != '\n') {
					  StrInPtr++;
				  }
			  } else {
				  WorkOutString[StrOutPtr] = WorkInString[StrInPtr];
				  StrOutPtr++;
				  StrInPtr++;
			  }
			  break; // #
		  case '$':
			  StrVarPtr = 0;
			  VarStr[0] = '\0';
			  StrInPtr++;
			  ParseErr = FALSE;
			  while ((isalnum(WorkInString[StrInPtr])) && (!ParseErr)) {
				  VarStr[StrVarPtr] = WorkInString[StrInPtr];
				  StrVarPtr++;
				  VarStr[StrVarPtr] = '\0';
				  StrInPtr++;
				  if ((StrVarPtr == TemplateCmdLength - 1))
					  ParseErr = TRUE;
				  if (ParseErr) {
					  strcpy (WorkOutString, "");
					  sprintf (WorkOutString, "Error at line %d at variable name: %s\n", LineCounter, VarStr);
				  } // ParseErr
			  } // while - parse the command
			  StrVarPtr = 0;
			  ParStr[0] = '\0';
			  ParseEnd = FALSE;
			  while ((!ParseErr) && (!ParseEnd)) {
				  if (WorkInString[StrInPtr] == ';')
					  ParseEnd = TRUE;
				  if ((WorkInString[StrInPtr] != '(') &&
					  (WorkInString[StrInPtr] != ')') &&
					  (WorkInString[StrInPtr] != ';')) {
						  ParStr[StrVarPtr] = WorkInString[StrInPtr];
						  StrVarPtr++;
						  ParStr[StrVarPtr] = '\0';
					  }
				  StrInPtr++;
				  if ((StrVarPtr == TemplateCmdLength - 1))
					  ParseErr = TRUE;
				  if (ParseErr) {
					  strcpy (WorkOutString, "");
					  sprintf (WorkOutString, "Error at line %d at variable name: %s\n", LineCounter, VarStr);
				  } // ParseErr
			  } // while - parse the params
			  if (ParseEnd)
				  EvaluateTemplateCmd (DataSource, VarStr, ParStr, WorkOutString, &StrOutPtr);
			  NewLineStatus = FALSE;
			  break; // $
		  case '@':
			  StrInPtr++;
			  NewLineStatus = FALSE;
			  break; // @
		  default: {
			  if (WorkInString[StrInPtr] == '\n') {
				  LineCounter++;
				  NewLineStatus = TRUE;
			  } else NewLineStatus = FALSE;
			  if ((WorkInString[StrInPtr] == '\n') && (Options[DataSource].ExportDOSLineFeed)){
				  WorkOutString[StrOutPtr] = '\r';
				  StrOutPtr++;
			  }
			  WorkOutString[StrOutPtr] = WorkInString[StrInPtr];
			  StrOutPtr++;
			  WorkOutString[StrOutPtr] = '\0';
			  StrInPtr++;
		  } // default
	  } // switch
  } // while (WorkInString[StrInPtr] != '\0') && (!ParseErr)
  free (WorkInString);

  // Out encoding settings
  EncOut = Options[ActDSI].ExportOutputEnc;
  if (EncOut == EXPORT_OUTPUT_ENC_DEFAULT)
	  EncOut = OutEncDef;
  switch (EncOut) {
	  case EXPORT_OUTPUT_ENC_DEFAULT:
		  RetString = WorkOutString;
		  break;
	  case EXPORT_OUTPUT_ENC_LOCALE:
		  ConvStr = g_locale_from_utf8 (WorkOutString, -1, &ByteIn, &ByteOut, NULL);
		  RetString = calloc(strlen(ConvStr) + 1, sizeof(char));
		  strcpy (RetString, ConvStr);
		  g_free (ConvStr);
		  free (WorkOutString);
		  break;
	  case EXPORT_OUTPUT_ENC_UTF8:
		  RetString = WorkOutString;
		  break;
	  case EXPORT_OUTPUT_ENC_OTHER:
		  RetString = WorkOutString;
		  break;
	  default: {
		  RetString = WorkOutString;
	  } // default
  } // switch
  
  return RetString;
} // ProcessTemplateString

extern char *
GenerateFixExportString (int DataSource) {
char *OutputString;
char *TmpStr;
int j,k;
int StoreDet;
struct tm *ConvLocalTime;

  ConvLocalTime = alloca (sizeof(struct tm));

  OutputString = NULL;
  OutputString = calloc (2500, sizeof(char));
  TmpStr = calloc (500, sizeof(char));

  sprintf (OutputString, "%s\n", Chrom[DataSource].ChrName); // File name
  localtime_r (&Chrom[DataSource].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);
  sprintf (TmpStr, "Date: %d.%.2d.%.2d   Time: %.2d:%.2d:%.2d\n",  \
		  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
		  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec); // Timestamp of start
  strcat (OutputString, TmpStr);
  sprintf (TmpStr, "%d\n",(int)Chrom[DataSource].ChromHead->Method.MeasureParameters.StartTime);
  strcat (OutputString, TmpStr);
  StoreDet = Chrom[DataSource].ActualDetector;
  sprintf (TmpStr, "%s\n", "  #       Area     Height      Conc    Id    Name");
  strcat (OutputString, TmpStr);
  for (j = 0; j < Chrom[DataSource].ChromHead->Method.Instrument.NumDetectors; j++) {
	  Chrom[DataSource].ActualDetector = j;
	  for (k = 0; k < Chrom[DataSource].ChromHead->PeakHead.PeakNum[j]; k++) {
		  GetPeak (k, DataSource);
			  //if (Chrom[DataSource].Peak->PeakIdentified)
			  sprintf (TmpStr, "%3d %10.0f %10.1f    ", k + 1, Chrom[DataSource].Peak->PeakArea, Chrom[DataSource].Peak->PeakHeight);
			  strcat (OutputString, TmpStr);
			  sprintf (TmpStr, "%5.4f %5d %s\n", Chrom[DataSource].Peak->PeakConc, Chrom[DataSource].Peak->PeakId, Chrom[DataSource].Peak->PeakName);
			  strcat (OutputString, TmpStr);
	  } // k
  } // j
  Chrom[DataSource].ActualDetector = StoreDet;

  free (TmpStr);

  return OutputString;
} // GenerateFixExportString

extern void
BugTrace (const char *TraceText, time_t BTTime) {
FILE	*BugTraceFile;
char	*BTFname;
char	*BTTimeStr;
char	*BTErrorStr;

  pthread_mutex_lock (&bug_report_mutex);
  BTFname = calloc (FilenameLength, sizeof (char));
  BTTimeStr = alloca (100);
  BTErrorStr = alloca (10000);
  BTTimeStr = ctime_r (&BTTime, BTTimeStr);
  if (ActualInstrument)
	  strcpy (BTFname, BugTraceDir);
  else
	  strcpy (BTFname, BugTraceCentralDir);
  if (!DirExist (BTFname)) {
	  sprintf (BTErrorStr, "*** BugTraceDir not valid! --- %s", BTFname);
	  printf ("*** BugTraceDir ERROR %s\n", BTErrorStr);
	  strcpy (BTFname, "");
  } // BugTraceDir
  strcat (BTFname, "BugTrace");
  BugTraceFile = fopen (BTFname, "a");
  if (BugTraceFile == NULL) {
	  strcpy (BTFname, "BugTraceRescue");
	  BugTraceFile = fopen (BTFname, "a");
  } // if (BugTraceFile == NULL)
  if (BugTraceFile != NULL) {
	fwrite (TraceText, sizeof (char), strlen (TraceText), BugTraceFile);
	fwrite (" | Time: ", sizeof (char), strlen (" | Time: "), BugTraceFile);
	fwrite (BTTimeStr, sizeof (char), strlen (BTTimeStr), BugTraceFile);
//	PRINTF ("%s | Time: %s", TraceText, BTTimeStr);
	fclose (BugTraceFile);
  } // BugTraceFile != NULL

  free (BTFname);
  pthread_mutex_unlock (&bug_report_mutex);
} // BugTrace

extern int
ADTraceStatusFunc (int Status, int Channel, const char *StatusName) {
int RetVal;

  RetVal = Status;
  pthread_mutex_lock (&ad_trace_mutex);
  if (Channel == ADTraceChannel) {
	  ADTraceStatus = Status;
	  ADTraceStatusGetNow = FALSE;
	  strcpy (ADTraceString, StatusName);
	  printf ("Status: %s\n", ADTraceString);
  }
  pthread_mutex_unlock (&ad_trace_mutex);

  return RetVal;
} // ADTraceStatusFunc
