// System functions

#include "widget_system_functions.h"

gint MainTimeoutFunction (gpointer data);

// Measure functions

typedef void MeasureFunctionType (void);

MeasureFunctionType *MeasureInitFunction;
MeasureFunctionType *MeasureDoneFunction;
MeasureFunctionType *MeasureCommandFunction;
MeasureFunctionType *MeasureExecFunction;
MeasureFunctionType *MeasureErrorFunction;

MeasureFunctionType DefaultInitFunction ;
MeasureFunctionType DefaultDoneFunction ;
MeasureFunctionType DefaultCommandFunction ;
MeasureFunctionType DefaultExecFunction ;
MeasureFunctionType DefaultErrorFunction ;

void*		generic_measure_function (void* unused);

void		ThreadCommandSend (int ThreadCmd, int TOMultiplicator, int CmdChannel);
MeasureFunctionType GenericCommandFunction ;
MeasureFunctionType GenericErrorFunction ;
MeasureFunctionType GenericDataAcqExecFunction ;
MeasureFunctionType GenericDensitometerExecFunction ;

void		HandleMeasureWidgets (int *convert_channel);
void		CheckManualQueueContinue (int *convert_channel);
void		MeasureStopped (int *convert_channel);
void		AssembleMeasureFilename (int *convert_channel);
void		GenerateWorkDir (int *convert_channel);
void		GenerateBaseName (int *convert_channel);
void*		convert_generic_acq_data (int *convert_channel);
void*		prepare_run (int *convert_channel);
void*		prepare_next_run (int *convert_channel);
void		ConvertProcessParameters (struct MethodStruct *ConvMet);

gint		oneSecondCallBackMeasure(gpointer data);

//
// A/D handler functions
//
void		ADInit (void);
void		ADClose (void);

void		SetStandardSignal (int Channel, int SignalCode);
void		ClrStandardSignal (int Channel, int SignalCode);
int			GetStandardSignal (int Channel, int SignalCode);
void		SetGradient (int Channel);
void		ContactAD (void);
int			ADFreshData (int Channel);

int			ADTraceStatusFunc (int Status, int Channel, const char *StatusName);

//
// Instrument specific measure functions
//

void StartExec (GtkWidget *MeasureTop);
void BreakExec (GtkWidget *MeasureTop);
void StopExec (GtkWidget *MeasureTop);

void TestModeON (GtkWidget *MeasureTop);
void TestModeOFF (GtkWidget *MeasureTop);

void GetQueueItem (int DataSource, int QueIdx);
void SetQueueItem (int DataSource, int QueIdx);
void AddQueueItem (int DataSource, int QueIdx);
void DelQueueItem (int DataSource, int QueIdx);
void UpQueueItem (int DataSource, int QueIdx);
void DownQueueItem (int DataSource, int QueIdx);
void DefaultQueueItem (int DataSource);

  // Workstation

  // Datastation

  // TR541
void TR541CommandExec (int CommandCode, int CommandParameter1, int CommandParameter2);
void TR541MeasureExec (int DataSource);
  // TR542

  // TR930
MeasureFunctionType TR930InitFunction ;
MeasureFunctionType TR930DoneFunction ;
MeasureFunctionType TR930ExecFunction ;

void TR930CommandExec (int CmdCode, int Param1, int Param2, int Param3, int Param4);
void TR930LowResMeasure ();
void TR930LowResAcquisiteOnly ();
void TR930LowResNullStepButExcite ();
void TR930HiResMeasure (int MeasInMM);
void TR930ZigZagMeasure (int MeasSteps, int TrackSteps, int YResolSteps);
void TR930GetSpectra (int UVVIS, int RefSample, int NormWL);
int TR930ADData(void);

void	ConvertSh930RawData (int ChrN);

void TR930XHome(void);
void TR930XRawHome(void);
void TR930YHome(void);
void TR930XStep (int XStep);
void TR930YStep (int YStep);
void TR930XStepH (int XStep);
void TR930YStepH (int YStep);
void TR930GotoWL(int WL, int FL);
void TR930DASet(int DAS);
void TR930DA0(void);
void TR930DAFull(void);
void TR930DAUp(void);
void TR930DADown(void);
void TR930DAHalf(void);
void TR930Normal(void);
void TR930HiVoltOff(void);
void TR930HiVoltRefl(void);
void TR930HiVoltTransm(void);

// OK functions

typedef void OkFunctionType (void);

OkFunctionType *OkFunction;
OkFunctionType DefaultOkFunction ;

typedef void ApplyFunctionType (GtkWidget *ApplyWidget);

ApplyFunctionType OpenChromOkFunction ;
ApplyFunctionType OpenOverlayChromOkFunction ;
ApplyFunctionType SaveChromOkFunction ;

ApplyFunctionType IntParSaveOkFunction ;
ApplyFunctionType IntParOpenOkFunction ;

ApplyFunctionType IntParInMethodApplyFunction;
ApplyFunctionType ReportInMethodApplyFunction;
ApplyFunctionType MeasurePreferencesApplyFunction;
ApplyFunctionType MainOpenOkFunction;
ApplyFunctionType MainPreferencesApplyFunction;

ApplyFunctionType SampleQueueOkFunction;
ApplyFunctionType SampleQueueDevelopOkFunction;

ApplyFunctionType GenericDataAcqStartMethodOkFunction;
ApplyFunctionType GenericDataAcqStartQueueOkFunction;
ApplyFunctionType MethodOkFunction;
ApplyFunctionType MethodInQueueOkFunction;
ApplyFunctionType MethodReprocessOkFunction;

ApplyFunctionType MethodOpenOkFunction;
ApplyFunctionType MethodSaveAsOkFunction;
ApplyFunctionType MethodExitSaveOkFunction;

ApplyFunctionType IntParReprocessApplyFunction;
ApplyFunctionType OverlayColorOkFunction;

ApplyFunctionType SpectraOpenOkFunction;
ApplyFunctionType SpectraSaveAsOkFunction;
ApplyFunctionType SpectraExportOkFunction;
ApplyFunctionType SpectraExitSaveOkFunction;

ApplyFunctionType AnalyzeApplyFunction;
ApplyFunctionType OpenCalibrOkFunction ;
ApplyFunctionType SaveCalibrOkFunction ;
ApplyFunctionType CalibrateApplyFunction;

ApplyFunctionType TR541MeasureImportTR540RAWOkFunction;
ApplyFunctionType TR541MeasureNewOkFunction;
ApplyFunctionType TR541MeasureQueueOkFunction;
ApplyFunctionType WorkstationMeasureNewOkFunction;
ApplyFunctionType WorkstationMeasureQueueOkFunction;
ApplyFunctionType SampleQueueExitSaveOkFunction;
ApplyFunctionType SampleQueueSaveOkFunction;
ApplyFunctionType SampleQueueOpenOkFunction;

ApplyFunctionType SelectCalibrTemplateDialogApplyFunction;
ApplyFunctionType SelectCalibrChromDialogApplyFunction;

ApplyFunctionType ZoomReprocessApplyFunction;

typedef void DestroyFunctionType (GtkObject *DestroyObject);

DestroyFunctionType TR541MeasureNewDestroyFunction;

DestroyFunctionType SelectCalibrTemplateDialogDestroyFunction;
DestroyFunctionType SelectCalibrChromDialogDestroyFunction;

// Core functions

int		Spawn (int Instr);
int		Kill (int Instr);
void	AutoStart (void);

int		CRTP(double Ret, int DataSource);
double	CPTR(int Point, int DataSource);
double	ChromData (int Idx, int DataSource);

void	ReallocChromData (int ChromArraySize, int DataSource);
void	ReallocPeakData (int PeakArraySize, int DataSource);

void	ReallocCalibrTemplateChromData (int ChromArraySize, int DataSource);
void	ReallocCalibrTemplatePeakData (int PeakArraySize, int DataSource);

void	ReallocCalibrChromChromData (int ChromArraySize, int DataSource);
void	ReallocCalibrChromPeakData (int PeakArraySize, int DataSource);

void	ReallocCalibrComponentData (int ComponentArraySize, int DataSource);
void	ReallocCalibrLevelData (int LevelArraySize, int DataSource);
void	ReallocCalibrChromData (int ChromArraySize, int DataSource);
void	ReallocCalibrCellData (int CellArraySize, int DataSource);
void	ReallocCalibrConcData (int ConcArraySize, int DataSource);

void	ReallocQueueData (int QueueArraySize, int DataSource);

void	ConvertImportRawData (GtkWidget *ImportMainWidget);
void	ConvertImportRawDataToChrom (GtkWidget *ImportMainWidget);

void	BugTrace (const char *TraceText, time_t BTTime);

// LabChrom2 Init functions

void	ImportConfigLoad (int Instr);
void	ImportConfigSave (int Instr);

void	ConfigLoad (int Instr);
void	ConfigSave (int Instr);

void	ShrinkMainWindow (void);
void	ExpandMainWindow (void);

void	LabChromInit (void);
void	LabChromDone (void);

void	MeasureInit (void);
void	MeasureDone (void);

// These functions initialize system variables only, char * pointers, arrays, etc.

void	SystemInit (void);
void	SystemDone (void);
void	SystemTest (void);

// Data init functions

void	NewMethod (struct MethodStruct *MethodForNew);
void	NewInstrumentDataStructure (void);
void	ClearInstrumentDataStructure (int Idx);

void	NewChromHead(struct ChromHeadStruct *ChromHeadToReset);
void	SetChromParameters(int DataSource);

void	NewSpectra(struct SpectraStruct *SpectraForInit);

void	NewSampleQueue (int DataSource);
// File functions

int		FileCheck (int FileIDCode, FILE *CheckFile, char *Filename);
void	CheckOut (int FileIDCode, FILE *CheckFile, struct FileIdentifierStruct *FileIdentifier);

gboolean FileExist (char *FileName);
gboolean DirExist (char *DirName);
void GenerateFileName (char *DirName, char *BaseName, char *ExtName, char *ResultName, time_t RescueTime);
int		CheckDirName (char *DirName);
int		CheckFileName (char *FileName);

void	ChromSave (int DataSource);
void	ChromLoad (int DataSource);
char	*LoadExportTemplateString (int DataSource);
void	SaveResultList (int DataSource, char *ResultString);
void	CalibrChromLoad (int DataSource);
void	CalibrTemplateChromLoad (int DataSource);

void	ChromImport (GtkWidget *ImportMainWidget, const gchar *ImportFilename);
void	ChromExportInRaw (int DataSource, char *Filename, struct ExportModeStruct *ExportMode);

int		MethodSave(struct MethodStruct *Method, char *Filename);
int		MethodLoad(struct MethodStruct *Method, char *Filename);
int		IntParSave(struct IntegrationParametersStruct *IntPar, char *Filename);
int		IntParLoad(struct IntegrationParametersStruct *IntPar, char *Filename);

void QueueSave (int DataSource);
void QueueLoad (int DataSource);
void QueueOpen (int DataSource);
void QueueClose (int DataSource);
void QueueRead (int DataSource, int QueIdx);
void QueueWrite (int DataSource, int QueIdx);

void	LayerSave(void);
void	LayerLoad(void);

void	CalibrSave(int DataSource, char *Filename);
void	CalibrLoad(int DataSource, char *Filename);

void	SpectraSave (void);
void	SpectraLoad (void);

void	TR541OldRawDataOpen (int DataSource, int DataShift);
void	TR541RawDataSave (int DataSource);

void	NetCDFExport (int DataSource, char *FileName);
void	NetCDFImport (int DataSource, char *FileName);

// Widget functions

int		SelectedCentralInstrument (void);
void	ActivateCentralWidgets (void);

void	SetCentralInstrumentSetupWidgets (GtkWidget *CIS);
void	ActivateCentralInstrumentSetupWidgets (GtkWidget *CIS);
void	RetrieveCentralInstrumentSetupWidgets (GtkWidget *CIS);
void	SetCentralSignalBits (GtkWidget *TopWidget, int BitValue);
int		GetCentralSignalBits (GtkWidget *TopWidget);
void	SetCentralSignalRow (GtkWidget *TopWidget, int RowValue, int RowLevel);
void	SetCentralSignalLevel (GtkWidget *TopWidget, int LevelValue);
int		GetCentralSignalLevel (GtkWidget *TopWidget);
void	SetCentralSignalEntry (GtkWidget *TopWidget, int EntryValue);
int		GetCentralSignalEntry (GtkWidget *TopWidget);

void	SetCentralPreferences (void);
void	GetCentralPreferences (void);
GtkWidget*	GetSelectedPrintFontEntry (void);
char*			GetSelectedPrintFontName (int SelectedPrintFont);

void	PresetMainWidgets (void);
void	ActivateMainWidgets (void);
void	RefreshMainWidgets (GtkWidget *MainWidget);
void	RefreshMainQueue (GtkWidget *MainWidget);
void	RefreshReprocessQueue (GtkWidget *ReprocessWidget);

void	PresetMeasureWidgets (int ActualMeasWin);
void	ActivateMeasureWidgets (int ActualMeasWin);

void	PresetMeasureErrorWidgets (void);

void	PresetPreferencesWidgets (GtkWidget *PreferencesMainWidget,
											int DefaultNoteTab,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton,
											ApplyFunctionType ApplyFunction);
void	SetPreferencesWidgets (GtkWidget *PreferencesMainWidget);
void	GetPreferencesWidgets (GtkWidget *PreferencesMainWidget);
void	ValidatePreferencesWidgets (GtkWidget *PreferencesMainWidget);

void	RefreshMeasureQueueList (int DataSource);
void	GetTR541Widgets (GtkWidget *MeasureWidget, struct MethodStruct *Method);
void	SetTR541Widgets (GtkWidget *MeasureWidget, struct MethodStruct *Method);

void	PresetSampleQueueWidgets (GtkWidget *QueueMainWidget,
									int InstrumentType,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton,
									ApplyFunctionType ApplyFunction,
									DestroyFunctionType DestroyFunction);
void	SetSampleQueueWidgets (GtkWidget *QueueMainWidget);
void	GetSampleQueueWidgets (GtkWidget *QueueMainWidget);

void	SetQueueItemWidgets (GtkWidget *QueueMainWidget);
void	GetQueueItemWidgets (GtkWidget *QueueMainWidget);
void	RefreshQueueList (GtkWidget *QueueMainWidget);
void	ActivateQueueListWidgets (GtkWidget *QueueMainWidget);
void	MakeQueueDialogTree (GtkWidget *QueueDialog);
void	RefreshQueueDialogWidgets (GtkWidget *QueueDialog);

void	PresetServicesWidgets (GtkWidget *ServicesMainWidget,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton);

void RefreshPeakList (void);
void PresetPeakInfoWindow (void);
void RefreshPeakInfo (void);

void	SetImportWidgets (GtkWidget *ImportMainWidget);
void	GetImportWidgets (GtkWidget *ImportMainWidget);

void PresetMethodWidgets (GtkWidget *MethodMainWidget,
											struct MethodStruct *Method,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton,
											ApplyFunctionType ApplyFunction);
void SetMethodWidgets (GtkWidget *MethodMainWidget);
void GetMethodWidgets (GtkWidget *MethodMainWidget);
void RefreshGradientGraph (GtkWidget *MethodWindow);
void GetReprocessMethodWidgets (GtkWidget *MethodMainWidget);

void SetReprocessWidgets (void);
void GetReprocessWidgets (void);
void PresetReprocessWidgets (void);
void ActivateReprocessWidgets (void);
void ConfigureReprocessWidgets (void);
void RefreshOverlayList (void);

void PresetIntParWidgets (GtkWidget *IntParMainWidget, 
									struct IntegrationParametersStruct *IntPar,
									GtkWidget *CallerWidget,
									GtkWidget *CallerButton,
									ApplyFunctionType ApplyFunction);
void SetIntParWidgets (GtkWidget *IntParMainWidget);
void GetIntParWidgets (GtkWidget *IntParMainWidget);
void ActivateIntParWidgets (GtkWidget *IntParMainWidget);
void RefreshIntParLockCList (GtkWidget *IntParMainWidget);
void RefreshIntParEventCList (GtkWidget *IntParMainWidget);

void PresetReportEditWidgets (GtkWidget *ReportEditMainWidget,
											struct ReportStruct *Report,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton,
											ApplyFunctionType ApplyFunction);
void SetReportEditWidgets (GtkWidget *ReportEditMainWidget);
void GetReportEditWidgets (GtkWidget *ReportEditMainWidget);

void PresetSpectraWidgets (GtkWidget *SpectraMainWidget,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton);
void ActivateSpectraWidgets (void);
void SetSpectraWidgets (void);
void GetSpectraWidgets (void);

void PresetZoomWidgets (GtkWidget *ZoomWindow,
											GtkWidget *CallerWidget,
											GtkWidget *CallerButton,
											ApplyFunctionType ApplyFunction);
void SetZoomWidgets (GtkWidget *ZoomWindow);
void GetZoomWidgets (GtkWidget *ZoomWindow);

void SetAnalyzeWidgets (int DataSource, GtkWidget *CalibrWidget);
void GetAnalyzeWidgets (int DataSource, GtkWidget *CalibrWidget);

void ActivateCalibrateWidgets (GtkWidget *CalibrWidget);
void ConfigureCalibrateWidgets (int CalibrType, GtkWidget *CalibrWidget);
void SetCalibrateWidgets (int DataSource, GtkWidget *CalibrWidget);
void GetCalibrateWidgets (int DataSource, GtkWidget *CalibrWidget);
void RefreshCalibrCheckWindow (GtkWidget *CalibrWidget);
void ExecRefreshCalibrCheckWindow (GtkWidget *CalibrWidget);
void RefreshCalibrCheckCellByIdx (int Idx, GtkWidget *CalibrWidget);
void RefreshCalibrCheckConcByIdx (int Idx, GtkWidget *CalibrWidget);

void RefreshCalibrComponentList (int DataSource, GtkWidget *CalibrWidget);
void RefreshIstList (int DataSource, GtkWidget *CalibrWidget);
void GetCalibrComponentWidgets (int DataSource, GtkWidget *CalibrWidget);
void SetCalibrComponentWidgets (int DataSource, GtkWidget *CalibrWidget);
void RefreshCalibrTemplateChromList (int DataSource, GtkWidget *CalibrWidget);

void RefreshCalibrLevelList (int DataSource, GtkWidget *CalibrWidget);
void GetCalibrLevelWidgets (int DataSource, GtkWidget *CalibrWidget);
void SetCalibrLevelWidgets (int DataSource, GtkWidget *CalibrWidget);

void RefreshCalibrChromList (int DataSource, GtkWidget *CalibrWidget);
void GetCalibrChromWidgets (int DataSource, GtkWidget *CalibrWidget);
void SetCalibrChromWidgets (int DataSource, GtkWidget *CalibrWidget);
void TransferCalibrChromToLevel (int DataSource, GtkWidget *CalibrWidget);

void GetConcField (GtkWidget *CalibrWidget);
void SetConcField (GtkWidget *CalibrWidget);

void RefreshCellDataPeakList (int DataSource, GtkWidget *CalibrWidget);
void RefreshCellDataField (int DataSource, GtkWidget *CalibrWidget);
void RefreshSelectedPeakDataField (int DataSource, GtkWidget *CalibrWidget);
// Draw / Print functions

// Common

void	AxisTickCalculate (struct AxisTickStruct *ATC, int LegendDensity);
void	DrawInit (void);
void	DrawDone (void);

// Reprocess

void	ReprocessDrawChrom (void);
void	ReprocessDrawChromInit (void);
void	ReprocessDrawChromDone (void);
void	RefreshReprocessAppBar (void);
void	CalculateRetentionFromCursor (int CursorX, int CursorY);
void	StoreTickedCursorValues (void);
void	CursorInit (void);
void	CursorDone (void);
void	CursorLineInit (void);
void	CursorLineDone (void);
void	CursorLineDraw (void);
void	CursorLineOn (void);
void	CursorLineOff (void);
void	CalculatePeakDataFromLine (void);
void	PeakAddInit (void);
void	PeakAddDone (void);
void	PeakAddLineInit (void);
void	PeakAddLineDone (void);
void	PeakAddLineDraw (void);
void	CalculateBaselineDataFromLine (void);
void	BaselineMoveInit (void);
void	BaselineMoveDone (void);
void	BaselineMoveLineInit (void);
void	BaselineMoveLineDone (void);
void	BaselineMoveLineDraw (void);
void	BaselineTypeChangeInit (void);
void	BaselineTypeChangeDone (void);
void	CalculateZoomDataFromRectangle (void);
void	ZoomIn (void);
void	ZoomOut (void);
void	ZoomReset (void);
int		ZoomPermanentCheck (void);
void	ZoomPermanentSuspend (void);
void	ZoomPermanentContinue (void);
void	ZoomInit (void);
void	ZoomDone (void);
void	ZoomRectangleInit (void);
void	ZoomRectangleDone (void);
void	ZoomRectangleDraw (void);

void	RetMoveInit (void);
void	RetMoveDone (void);

void	EventAddInit (void);
void	EventAddDone (void);

void	EventDelInit (void);
void	EventDelDone (void);

void	ImportRedraw (GtkWidget *ImportMainWidget);

// Draw measure

void	WorkstationMeasureRedraw (void);
void	WorkstationMeasureIOAreaRecalc (int CursorX, int CursorY);
void	TR930MeasureRedraw (void);
void	TR930SpectraRedraw (void);

void	TR541MainClean (GtkWidget *MainWidget);
void	TR541RawRedraw (int DataSource, GtkWidget *DrawingArea);
void	TR541TrackRedraw (int DataSource, GtkWidget *DrawingArea);

void	ServiceRedraw (void);

// Draw calibration

void	CalibrationRedraw (GtkWidget *CalibrationWindow);

// Function declarations for peak handling, integration and analysis

void	ReintegrateDBI (int DataSource);
void	ReintegrateBI (int DataSource);
void	ReintegrateI (int DataSource);

void	ResetPeak (int DataSource);
void	UpperPeak (int DataSource);

void	GetPeak (int PeakNum, int DataSource);
void	SetPeak (int PeakNum, int DataSource);
void	GetCalibrTemplatePeak (int PeakNum, int DataSource);
void	GetCalibrPeak (int PeakNum, int DataSource);

int		FindPeak (float PeakBeg, float PeakEnd, int DataSource);
int		InPeak (float PeakRet, int DataSource);
int		FindNearestPeak (double PeakRet, int DataSource);
void	AddPeak (int DataSource);
void	ModPeak (int ModPeakNum, int DataSource);
void	DelPeak (int DelPeakNum, int DataSource);
void	DelPeaks (int DataSource);
void	SortPeakList (int DataSource);

void	FindPeakRet (int DataSource);

void	PeakListResetForDetect (int DataSource);
void	PeakListResetForBaseline (int DataSource);
void	PeakListResetForIntegration (int DataSource);

void	PeakDetect (int DataSource);
void	CalculateBaseline (int DataSource);
void	PostProcessBaseline (int DataSource);
void	CalculateIntegral (int DataSource);

void	CalculatePerformance (int DataSource);

void	DetectPoint (int Idx, double *PeakDetValue, double *PeakDetDeriv1, double *PeakDetDeriv2, int DataSource);
void	CalculateArea (int DataSource);
void	CalculateHeight (int DataSource);

double	BaseIntegral (int BegBI, int EndBI, int DataSource);
double	BaseHeight (int BegBH, int ApexBH, int EndBH, int DataSource);

int		CheckPeakThreshold (int CPTBeg, int CPTApex, int CPTEnd, int DataSource);

int		FindNearestPeakByBasepoint (int DataSource, double ActualRetention);
void	FitValleyGroupBaseline (int DataSource, int PeakInGroup);
gboolean	ChangePeakBaseline (int DataSource, int ChangeMode);

int		FindLock (struct IntegrationParametersStruct *IntegrationParameters, double Retention);
int		FindEvent (struct IntegrationParametersStruct *IntegrationParameters, double Retention);
void	DeleteLock (struct IntegrationParametersStruct *IntegrationParameters, int LockToDelete);
void	DeleteEvent (struct IntegrationParametersStruct *IntegrationParameters, int EventToDelete);
void	SortLocks (struct IntegrationParametersStruct *IntegrationParameters);
void	SortEvents (struct IntegrationParametersStruct *IntegrationParameters);
void	EventListInit (void);
int		EventCode (int EventOrderInMenu);
int		EventOrderInMenu (int EventCode);

// Analysis functions

void	GaussianElimination (int Dimen, TNvector *Coefficients, double *Constants, double *Solution, int *Error);

void	ResetRegr (int Params, int DataSource);
void	AddRegr (double XData, double YData, int DataSource);
void	CalculateRegr (int DataSource);

void	CalibrationModified (int DataSource);

void	GetComponent (int Idx, int DataSource);
void	SetComponent (int Idx, int DataSource);
void	NewComponent (int DataSource);
void	AddComponent (int DataSource);
void	DelComponent (int Idx, int DataSource);

void	GetLevel (int Idx, int DataSource);
void	SetLevel (int Idx, int DataSource);
void	NewLevel (int DataSource);
void	AddLevel (int DataSource);
void	DelLevel (int Idx, int DataSource);

void	GetChrom (int LevelIdx, int ChromIdx, int DataSource);
void	SetChrom (int LevelIdx, int ChromIdx, int DataSource);
void	NewChrom (int DataSource);
void	AddChrom (int LevelIdx, int DataSource);
void	DelChrom (int LevelIdx, int ChromIdx, int DataSource);

void	GetConcByIdx (int Idx, int DataSource);
int		GetConc (int CompIdx, int LevelIdx, int DataSource);
void	SetConc (int CompIdx, int LevelIdx, int DataSource);
void	NewConc (int DataSource);
void	AddConc (int CompInternalIdx, int LevelInternalIdx, int DataSource);
void	DelConc (int CompIdx, int LevelIdx, int DataSource);

void	SetCellByIdx (int Idx, int DataSource);
void	GetCellByIdx (int Idx, int DataSource);
int		GetCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource);
void	SetCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource);
void	NewCell (int DataSource);
void	AddCell (int DataSource);
void	AddCellByIdx (int CompIdx, int LevelIdx, int ChromIdx, int DataSource);
void	DelCell (int CompIdx, int LevelIdx, int ChromIdx, int DataSource);
void	DelCellByComp (int CompIdx, int DataSource);
void	DelCellByLevel (int LevelIdx, int DataSource);
void	DelCellByChrom (int LevelIdx, int ChromIdx, int DataSource);

int		FindIst (int IstIdNum, int DataSource);
void	RebuildIstId (int DataSource);
void	MakeTemplateFromCalibr (int DataSource);
void	RecalculateComponent (int CompIdx, int DataSource);
void	RecalculateCalibr (int DataSource);
void	Analyze (int DataSource);

void	ImplantChromToCalibr (int ChromSource, int CalibrSource, int ImpLevel, int ImpMode);

// Print functions

void	FormatFloat (double FloatToFormat, int ValueLength, int ValueDigits, char *FormatString);
void	PrintFunction (int PrintMode, void *UserParams1, void *UserParams2, gboolean ShowUserWindow);
void	PrintInit (void);
void	PrintDone (void);

// Template based functions

char *ProcessTemplateString (char *InString, int DataSource, int ActDSI, int InEncDef, int OutEncDef);
char *GenerateFixExportString (int DataSource);
