extern void
ReprocessDrawChromInit (void)
{
int j;

  Zoom = (struct ZoomStruct *)calloc (1, sizeof (struct ZoomStruct));
  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMin;
  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMax;
  Zoom->ZoomBeg = 0;
  Zoom->ZoomEnd = Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1;
  Zoom->PrevZoom = NULL;
  Zoom->NextZoom = NULL;
  //PRINTF ("ReprocessDrawChromInit\n",0);
	// PRINTF("Min: %f   Max: %f   Beg: %d   End: %d\n",Zoom.ZoomMin,Zoom.ZoomMax,Zoom.ZoomBeg,Zoom.ZoomEnd);
  CursorInit ();
  SelectedPeak = -1;

  for (j = 0; j < MaxDetectors; j++)
	  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")), 0);
  if (Chrom[WorkArea].FileLoaded[ChrFlag]) {
	  for (j = 0; j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors; j++)
		  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")), \
	  														Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[j].Name);
	  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")), \
	  												Chrom[WorkArea].ActualDetector);
	  if (Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors > 1) {
		  ActivateWidget (ReprocessWindow, "ReprocessDetectorShowAllCheckButton", TRUE);
		  SetCheckBox (ReprocessWindow, "ReprocessDetectorShowAllCheckButton", Options[WorkArea].ShowAllDetectors);
	  } else {
		  SetCheckBox (ReprocessWindow, "ReprocessDetectorShowAllCheckButton", FALSE);
		  ActivateWidget (ReprocessWindow, "ReprocessDetectorShowAllCheckButton", FALSE);
	  } // if NumDetectors < 2
	  //if (Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors > 1)
		  //gtk_widget_show_all (lookup_widget(ReprocessWindow, "ReprocessDetectorToolbar"));
	  //else
		  //gtk_widget_hide_all (lookup_widget(ReprocessWindow, "ReprocessDetectorToolbar"));
  } else {
	  //gtk_widget_hide_all (lookup_widget(ReprocessWindow, "ReprocessDetectorToolbar"));
  }

} // ReprocessDrawChromInit

extern void
ReprocessDrawChromDone (void)
{
struct ZoomStruct *ZoomTemp;
int j;

  if (Chrom[WorkArea].FileLoaded[ChrFlag]) {
	  for (j = 0; j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors; j++) {
		  //gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")), 0);
	  }
  } // FileLoaded
printf ("\n");

  CursorDone ();
  while (Zoom != NULL) {
	  ZoomTemp = Zoom->PrevZoom;
	  free (Zoom);
	  Zoom = ZoomTemp;
  } // while
  PRINTF ("ReprocessDrawChromDone\n",0);
} // ReprocessDrawChromDone

void
DrawChromCalc (int AxisH, int AxisW, int ChrIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = ChrIdx -1 - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(ChrIdx - 1, WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = ChrIdx - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(ChrIdx, WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	// printf("ChromData: %f\n",ChromData(ChrIdx));
	// if (ChrIdx==1)
		// printf("BegEndDiff: %d    MinMaxDiff: %f\n",BegEndDiff,MinMaxDiff);
} // DrawChromCalc

void
DrawOverlayCalc (int OvrIdx, int AxisH, int AxisW, int ChrIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = ChrIdx -1 - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	DrawMMDiff = (ReprocessOverlayZoom[OvrIdx - OverlayedChromBase]*ChromData(ChrIdx - 1, OvrIdx) + ReprocessOverlayShift[OvrIdx - OverlayedChromBase]) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = ChrIdx - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = (ReprocessOverlayZoom[OvrIdx - OverlayedChromBase]*ChromData(ChrIdx, OvrIdx) + ReprocessOverlayShift[OvrIdx - OverlayedChromBase]) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	// printf("ChromData: %f\n",ChromData(ChrIdx));
	// if (ChrIdx==1)
		// printf("BegEndDiff: %d    MinMaxDiff: %f\n",BegEndDiff,MinMaxDiff);
} // DrawOverlayCalc

int
DrawBaselineCalc (int AxisH, int AxisW, int PeakIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	GetPeak (PeakIdx, WorkArea);
	
	if (CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) > DrawZoom.ZoomEnd) return FALSE;

	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	//DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	DrawMMDiff = Chrom[WorkArea].Peak->BlValueBegin - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	//DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	DrawMMDiff = Chrom[WorkArea].Peak->BlValueEnd - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);

	return TRUE;
} // DrawBaselineCalc

int
DrawBaselineValleyBeg (int AxisH, int AxisW, int PeakIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	GetPeak (PeakIdx, WorkArea);
	
	if (CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	if (Chrom[WorkArea].Peak->BlTypeBegin != BP_VALLEY) return FALSE;

	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	//DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	DrawMMDiff = Chrom[WorkArea].Peak->BlValueBegin - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	//DrawMMDiff = Chrom[WorkArea].Peak->BlValueEnd - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);

	return TRUE;
} // DrawBaselineValleyBeg

int
DrawBaselineValleyEnd (int AxisH, int AxisW, int PeakIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	GetPeak (PeakIdx, WorkArea);
	
	if (CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	if (Chrom[WorkArea].Peak->BlTypeEnd != BP_VALLEY) return FALSE;

	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	//DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeBegin, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	DrawMMDiff = Chrom[WorkArea].Peak->BlValueEnd - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->BlTimeEnd, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	//DrawMMDiff = Chrom[WorkArea].Peak->BlValueEnd - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);

	return TRUE;
} // DrawBaselineValleyEnd

int
DrawPeaknumberCalc (int AxisH, int AxisW, int PeakIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	GetPeak (PeakIdx, WorkArea);
	
	if (CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH) - 5;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH) + 5;

	return TRUE;
} // DrawPeaknumberCalc

int
DrawPeakSelection (int AxisH, int AxisW, int PeakIdx)
{
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	GetPeak (PeakIdx, WorkArea);
	
	if (Chrom[WorkArea].Peak->SelectForDel != TRUE) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH);
	
	DrawDiff = CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].Peak->PeakRetention, WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH);

	return TRUE;
} // DrawPeakSelection

int
DrawEventCalc (int AxisH, int AxisW, int EventNumber) {
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	if (CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH) - 5;
	
	DrawDiff = CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].EventTime[EventNumber], WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH) + 15;

	return TRUE;
} // DrawEventCalc

int
DrawLockCalc (int AxisH, int AxisW, int LockNumber) {
	int		BegEndDiff;
	int		DrawDiff;
	double	MinMaxDiff;
	double	DrawMMDiff;
	
	DrawData.x1 = 0;
	DrawData.y1 = 0;
	DrawData.x2 = 0;
	DrawData.y2 = 0;
	
	if (CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOff[LockNumber], WorkArea) < DrawZoom.ZoomBeg) return FALSE;
	if (CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOn[LockNumber], WorkArea) > DrawZoom.ZoomEnd) return FALSE;
	
	BegEndDiff = DrawZoom.ZoomEnd - DrawZoom.ZoomBeg;
	if (BegEndDiff<1)
		BegEndDiff = 1;
	
	MinMaxDiff = DrawZoom.ZoomMax - DrawZoom.ZoomMin;
	if (MinMaxDiff<0.0000001)
		MinMaxDiff = 0.0000001;
	
	DrawDiff = CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOn[LockNumber], WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	DrawData.x1 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOn[LockNumber], WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y1 = (DrawMMDiff/MinMaxDiff*AxisH) - 5;
	
	DrawDiff = CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOff[LockNumber], WorkArea) - DrawZoom.ZoomBeg;
	if (DrawDiff<0)
		DrawDiff=0;
	if (DrawDiff > BegEndDiff)
		DrawDiff = BegEndDiff;
	DrawData.x2 = (double)DrawDiff/(double)BegEndDiff*AxisW;
	
	DrawMMDiff = ChromData(CRTP (Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector].LockWindOff[LockNumber], WorkArea), WorkArea) - DrawZoom.ZoomMin;
	if (DrawMMDiff<0)
		DrawMMDiff = 0;
	DrawData.y2 = (DrawMMDiff/MinMaxDiff*AxisH) + 15;

	return TRUE;
} // DrawLockCalc

extern void
ReprocessDrawChrom (void)
{
GtkWidget	*DrawWidget;
int				i, iGrid, j;
int				x1, x2, y1, y2;
float			GridlinePrevDiff;
int				FromDet, ToDet, SelectedDet;
struct IntegrationParametersStruct *IntPar;
char			DrawTempString[IdLength];

int Precision;

gchar		*DrawStrLocale;
gsize		bytes_read;
gsize		bytes_written;

GdkGC		*gc;

struct tm *ConvLocalTime;

  ConvLocalTime = alloca (sizeof(struct tm));

  DrawWidget = lookup_widget (ReprocessWindow,"ReprocessDrawingArea");
  gdk_window_clear (DrawWidget->window);

  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  SelectedDet = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")));
  FromDet = SelectedDet;
  ToDet = FromDet + 1;
  Chrom[WorkArea].ActualDetector = FromDet;
  gnome_color_picker_set_title (GNOME_COLOR_PICKER(lookup_widget (ReprocessWindow, "ReprocessDetectorColorPicker")), Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[FromDet].Name);
  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(lookup_widget (ReprocessWindow, "ReprocessDetectorColorPicker")), \
	  ReprocessDetectorColors[FromDet].red, \
	  ReprocessDetectorColors[FromDet].green, \
	  ReprocessDetectorColors[FromDet].blue, \
	  0);
  if (Options[WorkArea].ShowAllDetectors) {
	  FromDet = 0;
	  ToDet = Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors;
  } // ReprocessDetectorShowAllCheckButton
  RefreshPeakList ();

	// Color init
	gc = gdk_gc_new (DrawWidget->window);

	// Background
	gdk_window_set_background (DrawWidget->window, &BackgroundColor);

	// Gridlines
	// X

	gdk_gc_set_foreground (gc, &ReprocessGridlineColor);

	// Y

	gdk_gc_set_foreground (gc, &ReprocessGridlineStrongColor);


	// Axis
	ReprocessAxisX = ReprocessDrawingAreaWidth - 10;
	ReprocessAxisY = 10;
	ReprocessAxisX0 = 10;
	ReprocessAxisY0 = ReprocessDrawingAreaHeight - 10;
	gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,10,10,ReprocessDrawingAreaHeight-10);
	gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,ReprocessDrawingAreaHeight-10,ReprocessDrawingAreaWidth-10,ReprocessDrawingAreaHeight-10);

	Precision = 3;
	sprintf (DrawString, "%.*f", Precision, Zoom->ZoomMax);
	gdk_draw_string (DrawWidget->window, AxisFont, DrawWidget->style->black_gc, 15, 10 + 10, DrawString);
	sprintf (DrawString, "%.*f / %.0f", Precision,Zoom->ZoomMin,CPTR(Zoom->ZoomBeg, WorkArea));
	gdk_draw_string (DrawWidget->window, AxisFont, DrawWidget->style->black_gc, 15, ReprocessDrawingAreaHeight - 12, DrawString);
	sprintf (DrawString, "%.0f",CPTR(Zoom->ZoomEnd, WorkArea));
	gdk_draw_string (DrawWidget->window, AxisFont, DrawWidget->style->black_gc, ReprocessDrawingAreaWidth - 10 - gdk_string_width (AxisFont, DrawString), ReprocessDrawingAreaHeight - 12, DrawString);

  // Chromatogram
  for (j = FromDet; j < ToDet; j++) {
	  Chrom[WorkArea].ActualDetector = j;
	  DrawZoom.ZoomBeg = Zoom->ZoomBeg;
	  DrawZoom.ZoomEnd = Zoom->ZoomEnd;
	  DrawZoom.ZoomMin = Zoom->ZoomMin;
	  DrawZoom.ZoomMax = Zoom->ZoomMax;
	  gdk_gc_set_foreground (gc, &ReprocessDetectorColors[j]);
	  for (i=(Zoom->ZoomBeg + 1); i<(Zoom->ZoomEnd + 1); i++)
	  {
		  DrawChromCalc(ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i);
		  x1 = DrawData.x1;
		  y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		  x2 = DrawData.x2;
		  y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		  gdk_draw_line(DrawWidget->window, gc, x1 + 10, ReprocessDrawingAreaHeight - 10 - y1, x2 + 10, ReprocessDrawingAreaHeight - 10 - y2);
	  } // for i
  } // j
  Chrom[WorkArea].ActualDetector = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (ReprocessWindow, "ReprocessDetectorComboBox")));

  // Overlay
  for (j = 0; j < ReprocessOverlayChromNum; j++) {
	  Chrom[OverlayedChromBase + j].ActualDetector = Chrom[WorkArea].ActualDetector;
	  DrawZoom.ZoomBeg = Zoom->ZoomBeg;
	  DrawZoom.ZoomEnd = Zoom->ZoomEnd;
	  DrawZoom.ZoomMin = Zoom->ZoomMin;
	  DrawZoom.ZoomMax = Zoom->ZoomMax;
	  gdk_gc_set_foreground (gc, &OverlayColor[j]);
	  for (i=(Zoom->ZoomBeg + 1); i<(Zoom->ZoomEnd + 1); i++)
	  {
		  if (i <= Chrom[OverlayedChromBase + j].ChromHead->Method.MeasureParameters.Nmp) {
			  DrawOverlayCalc(OverlayedChromBase + j, ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i);
			  x1 = DrawData.x1;
			  y1 = DrawData.y1;
			  if (y1 < 0) y1 = 0;
			  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
			  x2 = DrawData.x2;
			  y2 = DrawData.y2;
			  if (y2 < 0) y2 = 0;
			  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
			  gdk_draw_line(DrawWidget->window, gc, x1 + 10, ReprocessDrawingAreaHeight - 10 - y1, x2 + 10, ReprocessDrawingAreaHeight - 10 - y2);
		  } // if
	  } // for i
  } // j

	// Baseline
	gdk_gc_set_foreground (gc, &BaselineColor);
	for (i=0; i<Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]; i++)
	{
	if (DrawBaselineCalc (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		  if (ReprocessShowBaselines)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x1 + 10,ReprocessDrawingAreaHeight - 5 - y1);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2,x2 + 10,ReprocessDrawingAreaHeight - 15 - y2);
	} // if DrawBaselineCalc
	if (DrawBaselineValleyBeg (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		  if (ReprocessShowBaselines)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x1 + 10,ReprocessDrawingAreaHeight - 5 - y1);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2,x2 + 10,ReprocessDrawingAreaHeight - 15 - y2);
	} // if DrawBaselineValleyBeg
	if (DrawBaselineValleyEnd (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		  if (ReprocessShowBaselines)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x1 + 10,ReprocessDrawingAreaHeight - 5 - y1);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2,x2 + 10,ReprocessDrawingAreaHeight - 15 - y2);
	} // if DrawBaselineValleyEnd
	} // for i - PeakNum

	// Peak number
	gdk_gc_set_foreground (gc, &PeakNumberColor);
	for (i=0; i<Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]; i++)
	{
	if (DrawPeaknumberCalc (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		gdk_gc_set_foreground (gc, &BaselineColor);
		  if (ReprocessShowTickMarks)
			gdk_draw_line(DrawWidget->window, gc,x1 + 10,ReprocessDrawingAreaHeight - 10 - y1,x2 + 10,ReprocessDrawingAreaHeight - 10 - y2);
		gdk_gc_set_foreground (gc, &PeakNumberColor);
		GetPeak (i, WorkArea);
		  strcpy (DrawString, "");
		  if (ReprocessShowPeakNumbers) {
			sprintf (DrawTempString, "#%d",i+1);
			strcat (DrawString, DrawTempString);
			  if ((ReprocessShowRetention) || (ReprocessShowName))
				  strcat (DrawString, ":");
		  }
		  if (ReprocessShowRetention) {
			sprintf (DrawTempString, "%.3f",Chrom[WorkArea].Peak->PeakRetention);
			strcat (DrawString, DrawTempString);
			  if (ReprocessShowName)
				  strcat (DrawString, ":");
		  }
		  if (ReprocessShowName) {
			sprintf (DrawTempString, "%s",Chrom[WorkArea].Peak->PeakName);
			strcat (DrawString, DrawTempString);
		  }
		  if ((ReprocessShowPeakNumbers) || (ReprocessShowRetention) || (ReprocessShowName))
			gdk_draw_string (DrawWidget->window, PeakFont, gc, x1 + 11, ReprocessDrawingAreaHeight - 12 - y1, DrawString);
	} // if DrawPeaknumberCalc
	} // for i - PeakNum

	// Peak selection
	gdk_gc_set_foreground (gc, &SelectionColor);
	for (i=0; i<Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector]; i++)
	{
	if (DrawPeakSelection (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20,i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		  if (y1 < 0) y1 = 0;
		  if (y1 > ReprocessDrawingAreaHeight - 20) y1 = ReprocessDrawingAreaHeight - 20;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		  if (y2 < 0) y2 = 0;
		  if (y2 > ReprocessDrawingAreaHeight - 20) y2 = ReprocessDrawingAreaHeight - 20;
		gdk_draw_arc(DrawWidget->window, gc, TRUE, x1 + 10 - 5, ReprocessDrawingAreaHeight - 10 - y1 - 5, 10, 10, 0, 64*360);
	} // if DrawPeakSelection
	} // for i - PeakNum

	if (ReprocessShowComment) {
		strcpy (DrawString, "Comment:");
		strcat (DrawString, Chrom[WorkArea].ChromHead->Method.MeasureParameters.SampleComment);
		DrawStrLocale = g_locale_from_utf8 (DrawString, -1, &bytes_read, &bytes_written, NULL);
		gdk_draw_string (DrawWidget->window, PeakFont, DrawWidget->style->black_gc, ReprocessDrawingAreaWidth - 10 - gdk_string_width (AxisFont, DrawStrLocale), 20, DrawStrLocale);
//		gdk_draw_string (DrawWidget->window, PeakFont, DrawWidget->style->black_gc, ReprocessDrawingAreaWidth - 10 - gdk_string_width (AxisFont, DrawString), 20, DrawString);
		g_free (DrawStrLocale);
	} // ReprocessShowComment
	if (ReprocessShowTime) {
	  localtime_r (&Chrom[WorkArea].ChromHead->Method.MeasureParameters.StartTime, ConvLocalTime);
	  sprintf (DrawString, "Measure start date and time : %d.%.2d.%.2d   %.2d:%.2d:%.2d",  \
		  ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday, \
		  ConvLocalTime->tm_hour, ConvLocalTime->tm_min, ConvLocalTime->tm_sec); // Timestamp of start
		gdk_draw_string (DrawWidget->window, PeakFont, DrawWidget->style->black_gc, ReprocessDrawingAreaWidth - 10 - gdk_string_width (AxisFont, DrawString), 32, DrawString);
	}

	IntPar = &Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector];

	// Lock windows
	gdk_gc_set_foreground (gc, &LockColor);
	for (i = 0; i < IntPar->LockNum; i++)
	{
	if (DrawLockCalc (ReprocessDrawingAreaHeight - 20, ReprocessDrawingAreaWidth - 20, i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		gdk_gc_set_fill (gc, GDK_SOLID);
		gdk_gc_set_function (gc, GDK_XOR);
		gdk_draw_rectangle(DrawWidget->window, gc, TRUE, x1 + 10,ReprocessDrawingAreaHeight - 20, x2 - x1, 10);
		gdk_gc_set_function (gc, GDK_COPY);
	} // if
	} // i -> EventNum

	// Timed events
	gdk_gc_set_foreground (gc, &EventColor);
	for (i = 0; i < IntPar->EventNum; i++)
	{
	if (DrawEventCalc (ReprocessDrawingAreaHeight - 20, ReprocessDrawingAreaWidth - 20, i) == TRUE) {
		x1 = DrawData.x1;
		y1 = DrawData.y1;
		x2 = DrawData.x2;
		y2 = DrawData.y2;
		gdk_pixbuf_render_to_drawable (EventFlagPixbuf, DrawWidget->window, gc,\
		0, 0, x1 + 10, ReprocessDrawingAreaHeight - 15 - y2, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
		
	} // if
	} // i -> EventNum

	// Color unref
	gdk_gc_unref (gc);
} // ReprocessDrawChrom


extern void
RefreshReprocessAppBar (void) {
GtkWidget			*AppBar;
char					*AppBarText;

  AppBar = lookup_widget (ReprocessWindow, "ReprocessAppBar");
  AppBarText = alloca (400);
  if (CursorPeak < 0) {
	  if (SelectedPeak == -1)
		  sprintf (AppBarText, "Position %9.3f,   Value %9.3f %s", CursorRetention, CursorValue, CursorDim);
	  else
		  sprintf (AppBarText, "Position %9.3f,   Value %9.3f %s,   Selected Peak %d", CursorRetention, CursorValue, CursorDim, SelectedPeak + 1);
  } else {
	  if (SelectedPeak == -1)
		  sprintf (AppBarText, "Position %9.3f,   Value %9.3f %s,   Peak %d", CursorRetention, CursorValue, CursorDim, CursorPeak + 1);
	  else
		  sprintf (AppBarText, "Position %9.3f,   Value %9.3f %s,   Peak %d,   Selected Peak %d", CursorRetention, CursorValue, CursorDim, CursorPeak + 1, SelectedPeak + 1);
  } // CursorPeak < 0
  gnome_appbar_clear_stack (GNOME_APPBAR (AppBar));
  gnome_appbar_push (GNOME_APPBAR (AppBar), AppBarText);
  gnome_appbar_set_progress_percentage (GNOME_APPBAR (AppBar), CursorRetention / CPTR (Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp, WorkArea));
} // RefreshReprocessAppBar

extern void
CalculateRetentionFromCursor (int CursorX, int CursorY) {

	CursorPosition = Zoom->ZoomBeg;
	if (CursorX > ReprocessAxisX0) {
		CursorPosition = Zoom->ZoomBeg + (int)((float)(CursorX - ReprocessAxisX0) / (float)(ReprocessAxisX - ReprocessAxisX0) * (float)(Zoom->ZoomEnd - Zoom->ZoomBeg));
	} // CursorX > ReprocessAxisX0
	if (CursorPosition > Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1) CursorPosition = Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1;
	CursorValue = ChromData (CursorPosition, WorkArea);
	CursorRetention = CPTR (CursorPosition, WorkArea);
	CursorPeak = InPeak (CursorRetention, WorkArea);
	strcpy (CursorDim, "");
	strcpy (CursorDim, Chrom[WorkArea].ChromHead->Method.Instrument.Detectors[Chrom[WorkArea].ActualDetector].ScaleUnit);
} // CalculateRetentionFromCursor

extern void
StoreTickedCursorValues (void) {
	StoreCursorPosition = CursorPosition;
	StoreCursorRetention = CursorRetention;
	StoreCursorValue = CursorValue;
	StoreCursorPeak = CursorPeak;
} // StoreTickedCursorValues

void
CursorLineDrawExecute (int CLPosition) {
GtkWidget	*CursorLineWidget;
GdkGC		*gc;
int			CursorLineX;
int			CursorLineY0;
int			CursorLineY;

	if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

	CursorLineY0 = ReprocessDrawingAreaHeight - 10;
	CursorLineY = 10;
	if (Zoom->ZoomEnd != Zoom->ZoomBeg) {
	CursorLineX = 10 + 1 + (int)((float)(CLPosition - Zoom->ZoomBeg) / (float)(Zoom->ZoomEnd - Zoom->ZoomBeg) * (float)(ReprocessDrawingAreaWidth - 20));
	} else {
	CursorLineX = 10 + 1;
	}
	CursorLineWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (CursorLineWidget->window);
	gdk_gc_set_foreground (gc, &CursorLineColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (CursorLineWidget->window, gc, CursorLineX, CursorLineY0, CursorLineX, CursorLineY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);
} // CursorLineDrawExecute

extern void
CursorInit (void) {
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  CursorStatus = TRUE;
} // CursorInit

extern void
CursorDone (void) {
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

} // CursorDone

extern void
CursorLineInit (void) {
  CursorLinePosition = Zoom->ZoomBeg;
  CursorLinePrevPosition = CursorLinePosition;
  if (CursorStatus)
	  CursorLineDrawExecute (CursorLinePosition);
} // CursorLineInit

extern void
CursorLineDone (void) {
  if (CursorStatus)
	  CursorLineDrawExecute (CursorLinePrevPosition);
} // CursorLineDone

extern void
CursorLineDraw (void) {
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  if (CursorStatus) {
	  CursorLineDrawExecute (CursorLinePrevPosition);
	  CursorLinePosition = CursorPosition;
	  CursorLinePrevPosition = CursorLinePosition;
	  CursorLineDrawExecute (CursorLinePosition);
  } // (CursorStatus == TRUE)
} // CursorLineDraw

extern void
CursorLineOn (void) {
	CursorStatus = TRUE;
	CursorLineDraw ();
} // CursorLineOn

extern void
CursorLineOff (void) {
	CursorLineDraw ();
	CursorStatus = FALSE;
} // CursorLineOff

extern void
CalculatePeakDataFromLine () {
int		NewBeg;
int		NewEnd;
int		TempEnd;

	NewBeg = Zoom->ZoomBeg + (int)((float)(PeakAddX0 - ReprocessAxisX0) / (float)(ReprocessAxisX - ReprocessAxisX0) * ((float)Zoom->ZoomEnd - (float)Zoom->ZoomBeg) + 0.5);
	NewEnd = Zoom->ZoomBeg + (int)((float)(PeakAddX - ReprocessAxisX0) / (float)(ReprocessAxisX - ReprocessAxisX0) * ((float)Zoom->ZoomEnd - (float)Zoom->ZoomBeg) + 0.5);

	if (NewBeg > NewEnd) {
		TempEnd = NewEnd;
		NewEnd = NewBeg;
		NewBeg = TempEnd;
	} // NewBeg > NewEnd

	ResetPeak (WorkArea);
	Chrom[WorkArea].Peak->PeakBegin = CPTR(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->PeakEnd = CPTR(NewEnd, WorkArea);
	Chrom[WorkArea].Peak->BlTimeBegin = CPTR(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->BlTimeEnd = CPTR(NewEnd, WorkArea);
	Chrom[WorkArea].Peak->BlValueBegin = ChromData(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->BlValueEnd = ChromData(NewEnd, WorkArea);
	PRINTF ("BegVal: %d,  EndVal %d\n",NewBeg,NewEnd);

	FindPeakRet (WorkArea);
	AddPeak (WorkArea);
	ReintegrateBI (WorkArea);
} // CalculatePeakDataFromLine

extern void
PeakAddInit (void) {
GtkWidget	*PeakAddWidget;

	PeakAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	PRINTF ("PeakAddInit\n", 0);
	gdk_window_set_cursor (PeakAddWidget->window, PeakAddCursor);
} // PeakAddInit

extern void
PeakAddDone (void) {
GtkWidget	*PeakAddWidget;

	PeakAddLineDone ();
	PeakAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gdk_window_set_cursor (PeakAddWidget->window, NormalCursor);
	PRINTF ("PeakAddDone\n", 0);
	CalculatePeakDataFromLine ();
	ReprocessDrawChrom ();
//	if (Opened (PeakInfoWindow)) RefreshPeakInfo ();
  RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
} // PeakAddDone

extern void
PeakAddLineInit (void) {
GtkWidget	*PeakAddWidget;
GdkGC		*gc;

	PeakAddX0 = DrawCursorX0;
	PeakAddY0 = DrawCursorY0;
	if (PeakAddX0 < ReprocessAxisX0) { PeakAddX0 = ReprocessAxisX0; }
	if (PeakAddX0 > ReprocessAxisX) { PeakAddX0 = ReprocessAxisX; }
	if (PeakAddY0 < ReprocessAxisY) { PeakAddY0 = ReprocessAxisY; }
	if (PeakAddY0 > ReprocessAxisY0) { PeakAddY0 = ReprocessAxisY0; }
	PeakAddX = PeakAddX0;
	PeakAddY = PeakAddY0;
	PeakAddOrigX0 = PeakAddX0;
	PeakAddOrigY0 = PeakAddY0;
	PeakAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (PeakAddWidget->window);
	gdk_gc_set_foreground (gc, &PeakAddColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (PeakAddWidget->window, gc, PeakAddX0, PeakAddY0, PeakAddX0, PeakAddY0);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	PRINTF ("PeakAddLineInit\n", 0);
} // PeakAddLineInit

extern void
PeakAddLineDone (void) {
GtkWidget	*PeakAddWidget;
GdkGC		*gc;

	PeakAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (PeakAddWidget->window);
	gdk_gc_set_foreground (gc, &PeakAddColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (PeakAddWidget->window, gc, PeakAddX0, PeakAddY0, PeakAddX, PeakAddY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	ReprocessDrawChrom ();
	PRINTF ("PeakAddLineDone\n", 0);
} // PeakAddLineDone

extern void
PeakAddLineDraw (void) {
GtkWidget	*PeakAddWidget;
GdkGC		*gc;

	PeakAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (PeakAddWidget->window);
	gdk_gc_set_foreground (gc, &PeakAddColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (PeakAddWidget->window, gc, PeakAddX0, PeakAddY0, PeakAddX, PeakAddY);
	PeakAddX = DrawCursorX;
	PeakAddY = DrawCursorY;
	if (PeakAddX < ReprocessAxisX0) { PeakAddX = ReprocessAxisX0; }
	if (PeakAddX > ReprocessAxisX) { PeakAddX = ReprocessAxisX; }
	if (PeakAddY < ReprocessAxisY) { PeakAddY = ReprocessAxisY; }
	if (PeakAddY > ReprocessAxisY0) { PeakAddY = ReprocessAxisY0; }
	gdk_draw_line (PeakAddWidget->window, gc, PeakAddX0, PeakAddY0, PeakAddX, PeakAddY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

} // PeakAddLineDraw

extern void
CalculateBaselineDataFromLine () {
int		NewBeg;
int		NewEnd;
int		TempEnd;

	NewBeg = Zoom->ZoomBeg + (int)((double)(BaselineMoveX0 - ReprocessAxisX0) / (double)(ReprocessAxisX - ReprocessAxisX0) * ((double)Zoom->ZoomEnd - (double)Zoom->ZoomBeg) + 0.5);
	NewEnd = Zoom->ZoomBeg + (int)((double)(BaselineMoveX - ReprocessAxisX0) / (double)(ReprocessAxisX - ReprocessAxisX0) * ((double)Zoom->ZoomEnd - (double)Zoom->ZoomBeg) + 0.5);

	if (NewBeg > NewEnd) {
		TempEnd = NewEnd;
		NewEnd = NewBeg;
		NewBeg = TempEnd;
	} // NewBeg > NewEnd

	if (BaselineMovePeak < 0) return;
	GetPeak (BaselineMovePeak, WorkArea);
	Chrom[WorkArea].Peak->PeakBegin = CPTR(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->PeakEnd = CPTR(NewEnd, WorkArea);
	Chrom[WorkArea].Peak->BlTimeBegin = CPTR(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->BlTimeEnd = CPTR(NewEnd, WorkArea);
	Chrom[WorkArea].Peak->BlValueBegin = ChromData(NewBeg, WorkArea);
	Chrom[WorkArea].Peak->BlValueEnd = ChromData(NewEnd, WorkArea);
	PRINTF ("BegVal: %d,  EndVal %d\n",NewBeg,NewEnd);

	FindPeakRet (WorkArea);
	ModPeak (BaselineMovePeak, WorkArea);
	ReintegrateI (WorkArea);
} // CalculateBaselineDataFromLine

extern void
BaselineMoveInit (void) {
GtkWidget	*BaselineMoveWidget;

	BaselineMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	PRINTF ("BaselineMoveInit\n", 0);
	gdk_window_set_cursor (BaselineMoveWidget->window, BaselineMoveCursor);
} // BaselineMoveInit

extern void
BaselineMoveDone (void) {
GtkWidget	*BaselineMoveWidget;

	BaselineMoveLineDone ();
	BaselineMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gdk_window_set_cursor (BaselineMoveWidget->window, NormalCursor);
	PRINTF ("BaselineMoveDone\n", 0);
	CalculateBaselineDataFromLine ();
	ReprocessDrawChrom ();
	//if (Opened (PeakInfoWindow)) RefreshPeakInfo ();
	RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
} // BaselineMoveDone

extern void
BaselineMoveLineInit (void) {
GtkWidget	*BaselineMoveWidget;
GdkGC		*gc;

  BaselineMovePeak = FindNearestPeak (CursorRetention, WorkArea);
  DrawZoom.ZoomBeg = Zoom->ZoomBeg;
  DrawZoom.ZoomEnd = Zoom->ZoomEnd;
  DrawZoom.ZoomMin = Zoom->ZoomMin;
  DrawZoom.ZoomMax = Zoom->ZoomMax;
  if (DrawBaselineCalc (ReprocessDrawingAreaHeight - 20,ReprocessDrawingAreaWidth - 20, BaselineMovePeak)) {
	  if (fabs(Chrom[WorkArea].Peak->BlTimeBegin - CursorRetention) > fabs(Chrom[WorkArea].Peak->BlTimeEnd - CursorRetention)) {
		  BaselineMoveX0 = 10 + DrawData.x1;
		  BaselineMoveY0 = ReprocessDrawingAreaHeight - 10 - DrawData.y1;
	  } else {
		  BaselineMoveX0 = 10 + DrawData.x2;
		  BaselineMoveY0 = ReprocessDrawingAreaHeight - 10 - DrawData.y2;
	  }
  } // if DrawBaselineCalc
	if (BaselineMoveX0 < ReprocessAxisX0) { BaselineMoveX0 = ReprocessAxisX0; }
	if (BaselineMoveX0 > ReprocessAxisX) { BaselineMoveX0 = ReprocessAxisX; }
	if (BaselineMoveY0 < ReprocessAxisY) { BaselineMoveY0 = ReprocessAxisY; }
	if (BaselineMoveY0 > ReprocessAxisY0) { BaselineMoveY0 = ReprocessAxisY0; }
	BaselineMoveX = DrawCursorX0;
	BaselineMoveY = DrawCursorY0;
	if (BaselineMoveX < ReprocessAxisX0) { BaselineMoveX = ReprocessAxisX0; }
	if (BaselineMoveX > ReprocessAxisX) { BaselineMoveX = ReprocessAxisX; }
	if (BaselineMoveY < ReprocessAxisY) { BaselineMoveY = ReprocessAxisY; }
	if (BaselineMoveY > ReprocessAxisY0) { BaselineMoveY = ReprocessAxisY0; }
	BaselineMoveOrigX0 = BaselineMoveX0;
	BaselineMoveOrigY0 = BaselineMoveY0;
	BaselineMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (BaselineMoveWidget->window);
	gdk_gc_set_foreground (gc, &BaselineMoveColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (BaselineMoveWidget->window, gc, BaselineMoveX0, BaselineMoveY0, BaselineMoveX, BaselineMoveY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	PRINTF ("BaselineMoveLineInit\n", 0);
} // BaselineMoveLineInit

extern void
BaselineMoveLineDone (void) {
GtkWidget	*BaselineMoveWidget;
GdkGC		*gc;

	BaselineMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (BaselineMoveWidget->window);
	gdk_gc_set_foreground (gc, &BaselineMoveColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (BaselineMoveWidget->window, gc, BaselineMoveX0, BaselineMoveY0, BaselineMoveX, BaselineMoveY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	PRINTF ("BaselineMoveLineDone\n", 0);
} // BaselineMoveLineDone

extern void
BaselineMoveLineDraw (void) {
GtkWidget	*BaselineMoveWidget;
GdkGC		*gc;

	BaselineMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (BaselineMoveWidget->window);
	gdk_gc_set_foreground (gc, &BaselineMoveColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_line (BaselineMoveWidget->window, gc, BaselineMoveX0, BaselineMoveY0, BaselineMoveX, BaselineMoveY);
	BaselineMoveX = DrawCursorX;
	BaselineMoveY = DrawCursorY;
	if (BaselineMoveX < ReprocessAxisX0) { BaselineMoveX = ReprocessAxisX0; }
	if (BaselineMoveX > ReprocessAxisX) { BaselineMoveX = ReprocessAxisX; }
	if (BaselineMoveY < ReprocessAxisY) { BaselineMoveY = ReprocessAxisY; }
	if (BaselineMoveY > ReprocessAxisY0) { BaselineMoveY = ReprocessAxisY0; }
	gdk_draw_line (BaselineMoveWidget->window, gc, BaselineMoveX0, BaselineMoveY0, BaselineMoveX, BaselineMoveY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

} // BaselineMoveLineDraw

extern void
BaselineTypeChangeInit (void) {
GtkWidget	*BaselineTypeChangeWidget;

	BaselineTypeChangeWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	PRINTF ("BaselineTypeChangeInit\n", 0);
	gdk_window_set_cursor (BaselineTypeChangeWidget->window, BaselineTypeChangeCursor);
} // BaselineTypeChangeInit

extern void
BaselineTypeChangeDone (void) {
GtkWidget	*BaselineTypeChangeWidget;

	BaselineTypeChangeWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gdk_window_set_cursor (BaselineTypeChangeWidget->window, NormalCursor);
	PRINTF ("BaselineTypeChangeDone\n", 0);
//	CalculateBaselineDataFromLine ();
	ReprocessDrawChrom ();
	//if (Opened (PeakInfoWindow)) RefreshPeakInfo ();
	RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
} // BaselineTypeChangeDone

extern void
CalculateZoomDataFromRectangle () {
float	NewMin;
float	NewMax;
int		NewBeg;
int		NewEnd;

	NewBeg = Zoom->ZoomBeg + (int)((float)(ZoomRectangleX0 - ReprocessAxisX0) / (float)(ReprocessAxisX - ReprocessAxisX0) * ((float)Zoom->ZoomEnd - (float)Zoom->ZoomBeg));
	NewEnd = Zoom->ZoomBeg + (int)((float)(ZoomRectangleX - ReprocessAxisX0) / (float)(ReprocessAxisX - ReprocessAxisX0) * ((float)Zoom->ZoomEnd - (float)Zoom->ZoomBeg));
	NewMin = Zoom->ZoomMin + (float)(ReprocessAxisY0 - ZoomRectangleY) / (float)(ReprocessAxisY0 - ReprocessAxisY) * (Zoom->ZoomMax - Zoom->ZoomMin);
	NewMax = Zoom->ZoomMin + (float)(ReprocessAxisY0 - ZoomRectangleY0) / (float)(ReprocessAxisY0 - ReprocessAxisY) * (Zoom->ZoomMax - Zoom->ZoomMin);

	Zoom->ZoomMin = NewMin;
	Zoom->ZoomMax = NewMax;
	Zoom->ZoomBeg = NewBeg;
	Zoom->ZoomEnd = NewEnd;
} // CalculateZoomDataFromRectangle

extern void
ZoomIn (void) {
struct ZoomStruct *ZoomTemp;

	ZoomTemp = Zoom;

	Zoom = (struct ZoomStruct *)calloc (1, sizeof (struct ZoomStruct));
	Zoom->ZoomMin = ZoomTemp->ZoomMin;
	Zoom->ZoomMax = ZoomTemp->ZoomMax;
	Zoom->ZoomBeg = ZoomTemp->ZoomBeg;
	Zoom->ZoomEnd = ZoomTemp->ZoomEnd;
	Zoom->PrevZoom = ZoomTemp;
	ZoomTemp->NextZoom = Zoom;
} // ZoomIn

extern void
ZoomOut (void) {
struct ZoomStruct *ZoomTemp;

	if (Zoom->PrevZoom == NULL) return;

	ZoomTemp = Zoom->PrevZoom;
	free (Zoom);
	Zoom = ZoomTemp;
} // ZoomOut

extern void
ZoomReset (void) {
struct ZoomStruct *ZoomTemp;

	while (Zoom->PrevZoom != NULL) {
		ZoomTemp = Zoom->PrevZoom;
		free (Zoom);
		Zoom = ZoomTemp;
	} // while
} // ZoomReset

extern int
ZoomPermanentCheck (void) {
  ADSI(ReprocessWindow);
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return FALSE;

  Options[ActualDSInstrument].ZoomPermanent = gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON(lookup_widget (ReprocessWindow, "ReprocessZoomSwitchButton")));

  return Options[ActualDSInstrument].ZoomPermanent;
} // ZoomPermanentCheck

extern void
ZoomPermanentSuspend (void) {
GtkWidget	*ZoomWidget;

  if (ZoomRectangleStarted)
	  ZoomRectangleDone ();
  ZoomRectangleStarted = FALSE;
  ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  gdk_window_set_cursor (ZoomWidget->window, NormalCursor);
  PRINTF ("ZoomPermanentSuspend\n", 0);
  ZoomStart = FALSE;
} // ZoomPermanentSuspend

extern void
ZoomPermanentContinue (void) {
GtkWidget	*ZoomWidget;

  ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  PRINTF ("ZoomPermanentContinue\n", 0);
  gdk_window_set_cursor (ZoomWidget->window, ZoomCursor);
  ZoomRectangleStarted = FALSE;
  ZoomStart = TRUE;
} // ZoomPermanentContinue

extern void
ZoomInit (void) {
GtkWidget	*ZoomWidget;

  ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  PRINTF ("ZoomInit\n", 0);
  gdk_window_set_cursor (ZoomWidget->window, ZoomCursor);
  ZoomRectangleStarted = FALSE;
} // ZoomInit

extern void
ZoomDone (void) {
GtkWidget	*ZoomWidget;

  if (ZoomRectangleStarted)
	  ZoomRectangleDone ();
  ZoomRectangleStarted = FALSE;
  ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  gdk_window_set_cursor (ZoomWidget->window, NormalCursor);
  PRINTF ("ZoomDone\n", 0);
  ZoomIn ();
  CalculateZoomDataFromRectangle ();
  ReprocessDrawChrom ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
	//if (PrintfMode) printf ("ZoomRectangle:   X0 %d, Y0 %d, X %d, Y %d\n",ZoomRectangleX0,ZoomRectangleY0,ZoomRectangleX,ZoomRectangleY);
} // ZoomDone

extern void
ZoomRectangleInit (void) {
GtkWidget	*ZoomWidget;
GdkGC		*gc;

	ZoomRectangleX0 = DrawCursorX0;
	ZoomRectangleY0 = DrawCursorY0;
	if (ZoomRectangleX0 < ReprocessAxisX0) { ZoomRectangleX0 = ReprocessAxisX0; }
	if (ZoomRectangleX0 > ReprocessAxisX) { ZoomRectangleX0 = ReprocessAxisX; }
	if (ZoomRectangleY0 < ReprocessAxisY) { ZoomRectangleY0 = ReprocessAxisY; }
	if (ZoomRectangleY0 > ReprocessAxisY0) { ZoomRectangleY0 = ReprocessAxisY0; }
	ZoomRectangleX = ZoomRectangleX0;
	ZoomRectangleY = ZoomRectangleY0;
	ZoomOrigX0 = ZoomRectangleX0;
	ZoomOrigY0 = ZoomRectangleY0;
	ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (ZoomWidget->window);
	gdk_gc_set_foreground (gc, &ZoomColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_rectangle (ZoomWidget->window, gc, FALSE, ZoomRectangleX0, ZoomRectangleY0, 0, 0);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);
	ZoomRectangleStarted = TRUE;

	PRINTF ("ZoomRectangleInit\n", 0);
} // ZoomRectangleInit

extern void
ZoomRectangleDone (void) {
GtkWidget	*ZoomWidget;
GdkGC		*gc;

	ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (ZoomWidget->window);
	gdk_gc_set_foreground (gc, &ZoomColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_rectangle (ZoomWidget->window, gc, FALSE, ZoomRectangleX0, ZoomRectangleY0, 
						ZoomRectangleX - ZoomRectangleX0, ZoomRectangleY0 - ZoomRectangleY);
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	ReprocessDrawChrom ();
	PRINTF ("ZoomRectangleDone\n", 0);
} // ZoomRectangleDone

extern void
ZoomRectangleDraw (void) {
GtkWidget	*ZoomWidget;
GdkGC		*gc;

	ZoomWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
	gc = gdk_gc_new (ZoomWidget->window);
	gdk_gc_set_foreground (gc, &ZoomColor);
	gdk_gc_set_function (gc, GDK_XOR);
	gdk_draw_rectangle (ZoomWidget->window, gc, FALSE, ZoomRectangleX0, ZoomRectangleY0, 
						abs (ZoomRectangleX - ZoomRectangleX0), abs (ZoomRectangleY0 - ZoomRectangleY));
	if (DrawCursorX < ZoomOrigX0) {
		ZoomRectangleX0 = DrawCursorX;
		ZoomRectangleX = DrawCursorX0;
	} else {
		ZoomRectangleX0 = DrawCursorX0;
		ZoomRectangleX = DrawCursorX;
	} // DrawCursorX
	if (DrawCursorY < ZoomOrigY0) {
		ZoomRectangleY0 = DrawCursorY;
		ZoomRectangleY = DrawCursorY0;
	} else {
		ZoomRectangleY0 = DrawCursorY0;
		ZoomRectangleY = DrawCursorY;
	} // DrawCursorY
	if (ZoomRectangleX < ReprocessAxisX0) { ZoomRectangleX = ReprocessAxisX0; }
	if (ZoomRectangleX > ReprocessAxisX) { ZoomRectangleX = ReprocessAxisX; }
	if (ZoomRectangleY < ReprocessAxisY) { ZoomRectangleY = ReprocessAxisY; }
	if (ZoomRectangleY > ReprocessAxisY0) { ZoomRectangleY = ReprocessAxisY0; }
	if (ZoomRectangleX0 < ReprocessAxisX0) { ZoomRectangleX0 = ReprocessAxisX0; }
	if (ZoomRectangleX0 > ReprocessAxisX) { ZoomRectangleX0 = ReprocessAxisX; }
	if (ZoomRectangleY0 < ReprocessAxisY) { ZoomRectangleY0 = ReprocessAxisY; }
	if (ZoomRectangleY0 > ReprocessAxisY0) { ZoomRectangleY0 = ReprocessAxisY0; }
	gdk_draw_rectangle (ZoomWidget->window, gc, FALSE, ZoomRectangleX0, ZoomRectangleY0, 
						abs (ZoomRectangleX - ZoomRectangleX0), abs (ZoomRectangleY0 - ZoomRectangleY));
	gdk_gc_set_function (gc, GDK_COPY);
	gdk_gc_unref (gc);

	//if (PrintfMode) printf ("ZoomCursors:     X0 %d, Y0 %d, X %d, Y %d\n",ZoomCursorX0,ZoomCursorY0,ZoomCursorX,ZoomCursorY);
	//if (PrintfMode) printf ("ZoomRectangle:   X0 %d, Y0 %d, X %d, Y %d\n",ZoomRectangleX0,ZoomRectangleY0,ZoomRectangleX,ZoomRectangleY);
	//if (PrintfMode) printf ("ReprocessAxis:   X0 %d, Y0 %d, X %d, Y %d\n",ReprocessAxisX0,ReprocessAxisY0,ReprocessAxisX,ReprocessAxisY);
} // ZoomRectangleDraw

extern void
CalculateNewRetention () {
  if (CursorPeak < 0) return;
  GetPeak (CursorPeak, WorkArea);
  Chrom[WorkArea].Peak->PeakRetention = CursorRetention;
  SetPeak (CursorPeak, WorkArea);
  ReintegrateI (WorkArea);
} // CalculateNewRetention

extern void
RetMoveInit (void) {
GtkWidget *RetMoveWidget;

  RetMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  PRINTF ("RetMoveInit\n", 0);
  gdk_window_set_cursor (RetMoveWidget->window, RetMoveCursor);
} // RetMoveInit

extern void
RetMoveDone (void) {
GtkWidget *RetMoveWidget;

  RetMoveWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  gdk_window_set_cursor (RetMoveWidget->window, NormalCursor);
  PRINTF ("RetMoveDone\n", 0);
  CalculateNewRetention ();
  ReprocessDrawChrom ();
//	if (Opened (PeakInfoWindow)) RefreshPeakInfo ();
  RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
} // RetMoveDone

extern void
EventAddInit (void) {
GtkWidget *EventAddWidget;

  EventAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  PRINTF ("EventAddInit\n", 0);
  gdk_window_set_cursor (EventAddWidget->window, EventAddCursor);
} // EventAddInit

extern void
EventAddDone (void) {
GtkWidget *EventAddWidget;
GtkWidget *EventAddWindow;
int i;
struct IntegrationParametersStruct *IntPar;
char *TmpStr;

  PRINTF ("RetMoveDone\n", 0);
  EventAddWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  gdk_window_set_cursor (EventAddWidget->window, NormalCursor);

  TmpStr = alloca(20);
  IntPar = &Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector];

  EventAddWindow = create_EventHandlerWindow ();
  gtk_object_set_data (GTK_OBJECT (EventAddWindow), "IntPar", IntPar);
  gtk_object_set_data (GTK_OBJECT (EventAddWindow), "DataSource", GINT_TO_POINTER(WorkArea));
  gtk_widget_hide (lookup_widget (EventAddWindow, "EventHandlerRemoevButton"));
  
  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (EventAddWindow, "EventHandlerTypeComboBox")), 0);
  for (i = 0; i < EventNumbers; i++)
	  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (EventAddWindow, "EventHandlerTypeComboBox")), EventNames[i]);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (EventAddWindow, "EventHandlerTypeComboBox")), 0);
  SetSpinButtonValue (EventAddWindow, "EventHandlerRetentionSpinButton", CursorRetention);
  sprintf (TmpStr, "%d", IntPar->EventNum);
  SetEntry (EventAddWindow, "EventHandlerNumEntry", TmpStr);
  gtk_widget_show (EventAddWindow);
} // EventAddDone

extern void
EventDelInit (void) {
GtkWidget *EventDelWidget;

  EventDelWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  PRINTF ("EventDelInit\n", 0);
  gdk_window_set_cursor (EventDelWidget->window, EventDelCursor);
} // EventDelInit

extern void
EventDelDone (void) {
GtkWidget *EventDelWidget;
GtkWidget *EventDelWindow;
int i;
int SelectedEvent;
int EventMenuItem;
struct IntegrationParametersStruct *IntPar;
char *TmpStr;

  PRINTF ("EventDelDone\n", 0);
  EventDelWidget = lookup_widget (ReprocessWindow, "ReprocessDrawingArea");
  gdk_window_set_cursor (EventDelWidget->window, NormalCursor);

  TmpStr = alloca(20);
  IntPar = &Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector];
  SelectedEvent = FindEvent (IntPar, CursorRetention);
  if (SelectedEvent < 0) return;
  EventMenuItem = EventOrderInMenu (IntPar->EventType[SelectedEvent]);

  EventDelWindow = create_EventHandlerWindow ();
  gtk_object_set_data (GTK_OBJECT (EventDelWindow), "IntPar", IntPar);
  gtk_object_set_data (GTK_OBJECT (EventDelWindow), "DataSource", GINT_TO_POINTER(WorkArea));
  gtk_object_set_data (GTK_OBJECT (EventDelWindow), "SelectedEvent", GINT_TO_POINTER(SelectedEvent));
  gtk_widget_hide (lookup_widget (EventDelWindow, "EventHandlerAddButton"));
  
  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (EventDelWindow, "EventHandlerTypeComboBox")), 0);
  for (i = 0; i < EventNumbers; i++)
	  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (EventDelWindow, "EventHandlerTypeComboBox")), EventNames[i]);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (EventDelWindow, "EventHandlerTypeComboBox")), EventMenuItem);
  
  SetSpinButtonValue (EventDelWindow, "EventHandlerRetentionSpinButton", IntPar->EventTime[SelectedEvent]);
  SetSpinButtonValue (EventDelWindow, "EventHandlerFactorSpinButton", IntPar->EventFactor[SelectedEvent]);
  SetSpinButtonValue (EventDelWindow, "EventHandlerParameterSpinButton", IntPar->EventParameter[SelectedEvent]);
  SetSpinButtonValue (EventDelWindow, "EventHandlerTimeSpinButton", IntPar->EventActiveTime[SelectedEvent]);
  sprintf (TmpStr, "%d", IntPar->EventNum);
  SetEntry (EventDelWindow, "EventHandlerNumEntry", TmpStr);

  gtk_widget_show (EventDelWindow);
} // EventDelDone

// ***
// ImportDialog drawing functions
// ***

extern void
ImportRedraw (GtkWidget *ImportMainWidget)
{
GtkWidget			*DrawWidget;
GdkGC				*gc;

int					DrawAxisX;
int					DrawAxisY;
int					DrawAxisX0;
int					DrawAxisY0;
int					DrawX, DrawY;
int					DrawX1, DrawY1;

int					ImportDrawingAreaHeight;
int					ImportDrawingAreaWidth;
int					*ImportData;
int					*ImportSizedData;

int					i;
int					DataSize;
int					DataSizedSize;
int					MinData, MaxData;

double				ScaleXValue;
char					ScaleXDim[10];

  GetImportWidgets (ImportMainWidget);
  ConvertImportRawData (ImportMainWidget);

  strcpy (ScaleXDim, "min");
  switch (ImportXAxisMenuIndex) {
	  case 0:strcpy (ScaleXDim, "min");
	  case 1:strcpy (ScaleXDim, "sec");
	  case 2:strcpy (ScaleXDim, "mm");
  } // switch

  DrawWidget = lookup_widget (ImportMainWidget,"ImportDialogDrawingArea");

  ImportDrawingAreaHeight = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "ImportDrawingAreaHeight"));
  ImportDrawingAreaWidth = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "ImportDrawingAreaWidth")),

  ImportData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataPointer"); // (int *)ImportData[i]
  DataSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSize"));
  ImportSizedData = gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedPointer"); // (int *)ImportData[i]
  DataSizedSize = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (ImportMainWidget), "DataSizedSize"));

  if (Chrom[WorkArea].FileLoaded[ImpFlag] == TRUE)
	  ScaleXValue = DataSizedSize * ImportXResolution * ImportDecimation;
  else
	  ScaleXValue = 0;

  // Color init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);

  // Axis
  DrawAxisX = ImportDrawingAreaWidth - 10;
  DrawAxisY = 15;
  DrawAxisX0 = 10;
  DrawAxisY0 = ImportDrawingAreaHeight - 15;
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,15,10,ImportDrawingAreaHeight-15);
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,ImportDrawingAreaHeight-15,ImportDrawingAreaWidth-10,ImportDrawingAreaHeight-15);

  sprintf (DrawString, "0");
  gdk_draw_string (DrawWidget->window, AxisFont, DrawWidget->style->black_gc, 10, ImportDrawingAreaHeight - 2, DrawString);
  sprintf (DrawString, "%.0f [%s]", ScaleXValue, ScaleXDim);
  gdk_draw_string (DrawWidget->window, AxisFont, DrawWidget->style->black_gc, ImportDrawingAreaWidth - 10 - gdk_string_width (AxisFont, DrawString), ImportDrawingAreaHeight - 2, DrawString);

  if (Chrom[WorkArea].FileLoaded[ImpFlag] == TRUE) {
	  MinData = (int)(int *)ImportSizedData[0];
	  MaxData = (int)(int *)ImportSizedData[0];
	  for (i = 1; i < DataSizedSize; i++) {
		  if (MinData > (int)(int *)ImportSizedData[i]) MinData = (int)(int *)ImportSizedData[i];
		  if (MaxData < (int)(int *)ImportSizedData[i]) MaxData = (int)(int *)ImportSizedData[i];
	  } // for i

	  if ((MaxData != MinData) && (DataSizedSize > 0)) {
		  DrawX = DrawAxisX0;
		  DrawY = DrawAxisY0 - (int)((double)((int)(int *)ImportSizedData[0] - MinData) / (MaxData - MinData) * (DrawAxisY0 - DrawAxisY));
		  for (i = 1; i < DataSizedSize; i++) {
			  DrawX1 = DrawAxisX0 + (int)((double)i / (double)DataSizedSize * (DrawAxisX - DrawAxisX0));
			  DrawY1 = DrawAxisY0 - (int)((double)((int)(int *)ImportSizedData[i] - MinData) / (MaxData - MinData) * (DrawAxisY0 - DrawAxisY));
			  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, DrawX, DrawY, DrawX1, DrawY1);
			  DrawX = DrawX1;
			  DrawY = DrawY1;
		  } // for i
	  } // MaxData != MinData
  } // FileLoaded[ImpFlag] == TRUE

  // Color unref
  gdk_gc_unref (gc);
} // ImportRedraw
