// Measure draw functions

extern void
WorkstationMeasureRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

GtkWidget	*DrawWidgetIO;
GdkGC		*gcIO;

int			i, iGrid;
int			FromDet, ToDet, iDet;
static int	LastDet[MaxInstrument] = {-1, -1, -1, -1};
int			x1, x2, y1, y2;
double		DrawValue;
double		DrawFreq;
int			DrawTickCounter;
int			DrawTickMax;
int			*DrawArray;
int			DrawResolution;
int			DrawZeroPoint;
double		DrawFullScale;
int			*ChromDataArrayMeasure;
int			LedBit, LedX;
char		*InfoStr;

unsigned char	DigIN, DigOUT;
static unsigned char	DigINPrev, DigOUTPrev;

  InfoStr = alloca (1200);

  ADSI(MeasureWindow);
  Chrom[ActualDSInstrument].ActualDetector = GetOptionMenuIndex (MeasureWindow, "MeasureWorkstationOptionMenu");
  FromDet = Chrom[ActualDSInstrument].ActualDetector;
  ToDet = Chrom[ActualDSInstrument].ActualDetector;
  Options[ActualDSInstrument].ShowAllDetectors = GetCheckBox (MeasureWindow, "MeasureWorkstationAllCheckButton");
  if (Options[ActualDSInstrument].ShowAllDetectors) {
	  FromDet = 0;
	  ToDet = WorkInstrument[ActualDSInstrument].NumDetectors - 1;
  } // if MeasureWorkstationAllCheckButton

  Options[ActualDSInstrument].ShowMeasureFilenames = GetCheckBox (MeasureWindow, "MeasureWorkstationInfoCheckButton");

  if (LastDet[ActualDSInstrument] != Chrom[ActualDSInstrument].ActualDetector) {
	  SetSpinButtonValue (MeasureWindow, "MeasureWorkstationAttenuatorSpinButton", Options[ActualDSInstrument].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector]);
	  SetSpinButtonValue (MeasureWindow, "MeasureWorkstationShiftSpinButton", Options[ActualDSInstrument].MeasureShift[Chrom[ActualDSInstrument].ActualDetector]);
	  gnome_color_picker_set_title (GNOME_COLOR_PICKER(lookup_widget (MeasureWindow, "MeasureWorkstationColorPicker")), WorkInstrument[ActualDSInstrument].Detectors[Chrom[ActualDSInstrument].ActualDetector].Name);
	  gnome_color_picker_set_i16 (GNOME_COLOR_PICKER(lookup_widget (MeasureWindow, "MeasureWorkstationColorPicker")), \
	  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].red, \
	  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].green, \
	  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].blue, \
	  0);
	  LastDet[ActualDSInstrument] = Chrom[ActualDSInstrument].ActualDetector;
  } // if LastDet

  DrawWidget = lookup_widget (MeasureWindow,"MeasureWorkstationDrawingArea");

  // Graphic context init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);

  // Gridlines
  // X

  gdk_gc_set_foreground (gc, &MeasureGridlineColor);

  // Y

  gdk_gc_set_foreground (gc, &MeasureGridlineStrongColor);

  // Axis
  gdk_gc_set_foreground (gc, &DrawColor);
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,10,10,MeasureDrawingAreaHeight-10);
  gdk_draw_line(DrawWidget->window, DrawWidget->style->black_gc, 10,MeasureDrawingAreaHeight-10,MeasureDrawingAreaWidth-10,MeasureDrawingAreaHeight-10);

  // Axis values
  gdk_gc_set_foreground (gc, &DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector]);
  DrawValue = Options[0].MeasureShift[Chrom[ActualDSInstrument].ActualDetector] + Options[0].MeasureAxisValue * POW2 (Options[0].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector]);
  if (Options[0].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector] > 0)
	  sprintf (DrawString, "%.0f mV", DrawValue);
  else if (Options[0].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector] == 0)
	  sprintf (DrawString, "%.1f mV", DrawValue);
  else
	  sprintf (DrawString, "%.2f mV", DrawValue);
  gdk_draw_string (DrawWidget->window, DrawFont, gc, 15, 10 + 10, DrawString);
  gdk_gc_set_foreground (gc, &DrawColor);
  if (Options[0].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector] > 0)
	  sprintf (DrawString, "%.0f mV / 0 min", Options[0].MeasureShift[Chrom[ActualDSInstrument].ActualDetector]);
  else if (Options[0].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector] == 0)
	  sprintf (DrawString, "%.1f mV / 0 min", Options[0].MeasureShift[Chrom[ActualDSInstrument].ActualDetector]);
  else
	  sprintf (DrawString, "%.2f mV / 0 min", Options[0].MeasureShift[Chrom[ActualDSInstrument].ActualDetector]);
  gdk_draw_string (DrawWidget->window, DrawFont, gc, 15, MeasureDrawingAreaHeight - 12, DrawString);

  gdk_gc_set_foreground (gc, &DrawColor);
  sprintf (DrawString, "%.0f min",Options[0].MeasureAxisTime);
  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), MeasureDrawingAreaHeight - 12, DrawString);

  // Draw

  for (iDet = FromDet; iDet < ToDet + 1; iDet++) {
	  DrawFreq = 60.0 * (double)LC2.Instruments[ActualInstrument].ADParameters.ADBaseSamplingFrequencyInHz;
	  if ((ThreadStatus[ActualDSInstrument] != ThreadStatusIdle) && (LC2.Instruments[ActualInstrument].ADParameters.ADSamplingAccumulationTable[LC2.Instruments[ActualInstrument].ADParameters.ADSamplingSelection] != 0))
		  DrawFreq = 60.0 * (double)Chrom[ActualDSInstrument].ChromHead->Method.MeasureParameters.Cycle;
	  DrawTickMax = DrawFreq * Options[0].MeasureAxisTime;
	  if (DrawTickMax == 0) DrawTickMax = 1;
	  pthread_mutex_lock (&measure_data_mutex);
	  DrawArray = calloc (Chrom[ActualDSInstrument].ChromDataArrayActualSize, sizeof(int));
	  if (ThreadStatus[ActualDSInstrument] != ThreadStatusIdle) {
		  DrawTickCounter = MeasureDataCounter[ActualDSInstrument];
	  } else {
		  if (MeasureTickCounter[ActualDSInstrument] > DrawTickMax) MeasureTickCounter[ActualDSInstrument] = 0;
		  DrawTickCounter = MeasureTickCounter[ActualDSInstrument];
	  } // ThreadStatus
	  ChromDataArrayMeasure = Chrom[ActualDSInstrument].ChromDataArrays[iDet];
	  for (i = 0; i < DrawTickCounter; i++) {
		  DrawArray[i] = ChromDataArrayMeasure[i];
	  } // i
	  DrawFullScale = WorkAD.ADFullScale;
	  DrawResolution = WorkAD.ADResolution;
	  DrawZeroPoint = WorkAD.ADZeroPoint;
	  pthread_mutex_unlock (&measure_data_mutex);

	  gdk_gc_set_foreground (gc, &DetectorColors[ActualDSInstrument][iDet]);
	  for (i = 1; i < DrawTickCounter; i++) {
		  x1 = (int)((float)(i-1) / DrawTickMax * (float)(MeasureDrawingAreaWidth - 20));
		  x2 = (int)((float)(i) / DrawTickMax * (float)(MeasureDrawingAreaWidth - 20));
		  y1 = (int)((DrawFullScale * (double)((int)(int *)DrawArray[i-1]) / (double)DrawResolution - Options[ActualDSInstrument].MeasureShift[iDet]) / (double)(POW2 (Options[0].MeasureAttenuator[iDet]) / Options[ActualDSInstrument].MeasureAxisValue) * (double)(MeasureDrawingAreaHeight - 20));
		  y2 = (int)((DrawFullScale * (double)((int)(int *)DrawArray[i]) / (double)DrawResolution - Options[ActualDSInstrument].MeasureShift[iDet]) / (double)(POW2 (Options[0].MeasureAttenuator[iDet]) / Options[ActualDSInstrument].MeasureAxisValue) * (double)(MeasureDrawingAreaHeight - 20));
		  if (x1 < 1) x1 = 1;
		  if (x1 > MeasureDrawingAreaWidth - 20) x1 = MeasureDrawingAreaWidth - 20;
		  if (x2 < 1) x2 = 1;
		  if (x2 > MeasureDrawingAreaWidth - 20) x2 = MeasureDrawingAreaWidth - 20;
		  if (y1 < 0) y1 = 0;
		  if (y1 > MeasureDrawingAreaHeight - 20) y1 = MeasureDrawingAreaHeight - 20;
		  if (y2 < 0) y2 = 0;
		  if (y2 > MeasureDrawingAreaHeight - 20) y2 = MeasureDrawingAreaHeight - 20;
		  gdk_draw_line(DrawWidget->window, gc, x1+10, MeasureDrawingAreaHeight-10-y1, x2+10, MeasureDrawingAreaHeight-10-y2);
	  } // i

	  free (DrawArray);
  } // for iDet

  // Print values

  for (iDet = FromDet; iDet < ToDet + 1; iDet++) {
	  pthread_mutex_lock (&measure_data_mutex);
	  sprintf (DrawString,"Value %9.3f  mV",MeasureScaleValue[ActualDSInstrument][iDet]);
	  pthread_mutex_unlock (&measure_data_mutex);
	  gdk_gc_set_foreground (gc, &DetectorColors[ActualDSInstrument][iDet]);
	  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), 20 + (iDet - FromDet) * 14, DrawString);
  } // for iDet
  gdk_gc_set_foreground (gc, &RetColor);
  if (ThreadStatus[ActualDSInstrument] != ThreadStatusIdle) {
	  DrawFreq = 60.0 * (double)Chrom[ActualDSInstrument].ChromHead->Method.MeasureParameters.Cycle;
	  if (DrawFreq == 0) DrawFreq = 600.0;
	  pthread_mutex_lock (&measure_data_mutex);
	  sprintf (DrawString,"Retention %9.3f min", (float)MeasureDataCounter[ActualDSInstrument] / DrawFreq);
	  pthread_mutex_unlock (&measure_data_mutex);
	  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), 34 + (iDet - FromDet) * 14, DrawString);
	  if (Chrom[ActualDSInstrument].ChromHead->Method.MeasureParameters.GradControlEnable) {
		  pthread_mutex_lock (&measure_data_mutex);
		  sprintf (DrawString,"Flow %9.3f ml/min", (float)MeasureDataCounter[ActualDSInstrument] / DrawFreq);
		  pthread_mutex_unlock (&measure_data_mutex);
		  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), 34 + (iDet - FromDet) * 14, DrawString);
		  for (i = 0; i < 4;/* GradNum!!! */ i++) {
			  pthread_mutex_lock (&measure_data_mutex);
			  sprintf (DrawString,"X %9.3f [%]", (float)MeasureDataCounter[ActualDSInstrument] / DrawFreq);
			  pthread_mutex_unlock (&measure_data_mutex);
			  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), 34 + (iDet - FromDet) * 14, DrawString);
		  } // i
	  } // if GradientEnable
  } // if ThreadStatus

  // Print INFO
  if (Options[ActualDSInstrument].ShowMeasureFilenames) {
	  gdk_gc_set_foreground (gc, &DrawColor);
	  pthread_mutex_lock (&measure_parameter_mutex);
	  strcpy (InfoStr, Chrom[ActualDSInstrument].InfoName);
	  pthread_mutex_unlock (&measure_parameter_mutex);
	  if (strlen (InfoStr) > 0)
		  sprintf (DrawString,"Filename: %s", InfoStr);
	  else
		  sprintf (DrawString,"Filename: ---");
	  gdk_draw_string (DrawWidget->window, DrawFont, gc, MeasureDrawingAreaWidth - 10 - gdk_string_width (DrawFont, DrawString), 48 + (ToDet - FromDet + 1) * 14, DrawString);
  } // if Options[ActualDSInstrument].ShowMeasureFilenames

  // Graphic context unref
  gdk_gc_unref (gc);

  // IO Redraw if need
  pthread_mutex_lock (&measure_data_mutex);
  DigIN = ADRawINPort[ActualDSInstrument];
  DigOUT = ADRawOUTPort[ActualDSInstrument];
  pthread_mutex_unlock (&measure_data_mutex);

  if (DigIN != DigINPrev) MeasureIOAreaNeedRedraw = TRUE;
  if (DigOUT != DigOUTPrev) MeasureIOAreaNeedRedraw = TRUE;

  DigOUTPrev = DigOUT;
  DigINPrev = DigIN;

  if (MeasureIOAreaNeedRedraw) {
	  DrawWidgetIO = lookup_widget (MeasureWindow,"MeasureWorkstationIODrawingArea");
	  gcIO = gdk_gc_new (DrawWidgetIO->window);
	  gdk_window_set_background (DrawWidgetIO->window, &BackgroundIOColor);
	  gdk_window_clear (DrawWidgetIO->window);
	  gdk_gc_set_foreground (gcIO, &Background2IOColor);
	  gdk_draw_rectangle (DrawWidgetIO->window, gcIO, TRUE, 10, 0, MeasureIODrawingAreaWidth - 10, MeasureIODrawingAreaHeight - 1);

	  // Draw digital IO
	  gdk_pixbuf_render_to_drawable (InputPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 14, 4, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
	  gdk_pixbuf_render_to_drawable (OutputPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 344, 4, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);

	  for (i = 0; i < 8; i++) {
		  LedBit = POW2 (i) + 0.1;

		  LedX = LedBit & DigIN;

		  if (LedX)
			  gdk_pixbuf_render_to_drawable (LedOnPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 94 + (7-i)*28, 6, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
		  else
			  gdk_pixbuf_render_to_drawable (LedOffPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 94 + (7-i)*28, 6, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);

		  LedX = LedBit & DigOUT;
		  if (LedX)
			  gdk_pixbuf_render_to_drawable (LedOnPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 424 + (7-i)*28, 6, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
		  else
			  gdk_pixbuf_render_to_drawable (LedOffPixbuf, DrawWidgetIO->window, gcIO, 0, 0, 424 + (7-i)*28, 6, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
	  } // i

	  gdk_gc_unref (gcIO);
	  MeasureIOAreaNeedRedraw = FALSE;
  } // if MeasureIOAreaNeedRedraw
} // WorkstationMeasureRedraw

extern void
WorkstationMeasureIOAreaRecalc (int CursorX, int CursorY) {
int i;

unsigned char LedScan, LedVal, DigIN;

  ADSI(MeasureWindow);
  LedVal = 0x00;
  for (i = 0; i < 8; i++) {
	  LedScan = POW2 (i) + 0.1;
	  if (((CursorX > 94 + (7-i)*28) && (CursorX < 94 + (8-i)*28)) && \
		  (CursorY > 6) && (CursorY < 34)) LedVal = LedScan;
  } // i

  if (serial_no_communicate) {
	  pthread_mutex_lock (&measure_data_mutex);
	  DigIN = ADRawINPort[ActualDSInstrument];
	  if (DigIN & LedVal)
		  ADRawINPort[ActualDSInstrument] &= ~LedVal;
	  else
		  ADRawINPort[ActualDSInstrument] |= LedVal;
	  pthread_mutex_unlock (&measure_data_mutex);
  } // serial_no_communicate
} // WorkstationMeasureIOAreaRecalc

void
TR930LayerRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

int			i;

  DrawWidget = lookup_widget (MeasureWindow,"MeasureTR930LayerDrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);



  // Graphic context unref
  gdk_gc_unref (gc);
} // TR930LayerRedraw

void
TR930TrackRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

int			i;

  DrawWidget = lookup_widget (MeasureWindow,"MeasureTR930TrackDrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);



  // Graphic context unref
  gdk_gc_unref (gc);
} // TR930TrackRedraw

void
TR930ColorRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

int			i;

  DrawWidget = lookup_widget (MeasureWindow,"MeasureTR930ColorDrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);



  // Graphic context unref
  gdk_gc_unref (gc);
} // TR930ColorRedraw

void
TR930ColorDistributionRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

int			i;

  DrawWidget = lookup_widget (MeasureWindow,"MeasureTR930ColorDistributionDrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);



  // Graphic context unref
  gdk_gc_unref (gc);
} // TR930ColorDistributionRedraw

extern void
TR930MeasureRedraw (void) {
  TR930LayerRedraw ();
  TR930TrackRedraw ();
  TR930ColorRedraw ();
  TR930ColorDistributionRedraw ();
} // TR930MeasureRedraw

extern void
ServiceRedraw (void) {
#define X0_Service 20
#define Y0_Service 10
GtkWidget	*DrawWidget;
GdkGC		*gc;

int i;
int xAxisSize, yAxisSize;

  DrawWidget = lookup_widget (ServiceWindow,"ServiceDrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);

  xAxisSize = ServiceDrawingAreaWidth - X0_Service - 10;
  yAxisSize = ServiceDrawingAreaHeight - Y0_Service - 10;

  gdk_draw_line (DrawWidget->window, DrawWidget->style->black_gc, X0_Service, ServiceDrawingAreaHeight - Y0_Service, X0_Service + xAxisSize, ServiceDrawingAreaHeight - Y0_Service);
  gdk_draw_line (DrawWidget->window, DrawWidget->style->black_gc, X0_Service, ServiceDrawingAreaHeight - Y0_Service, X0_Service, 10);

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch

  // Graphic context unref
  gdk_gc_unref (gc);
} // ServiceRedraw

void
TR930SpectraRedraw (void) {
GtkWidget	*DrawWidget;
GdkGC		*gc;

int			i;

  DrawWidget = lookup_widget (SpectraWindow,"SpectraTR930DrawingArea");

  // Graphic contest init
  gc = gdk_gc_new (DrawWidget->window);

  // Background
  gdk_window_set_background (DrawWidget->window, &BackgroundColor);
  gdk_window_clear (DrawWidget->window);



  // Graphic context unref
  gdk_gc_unref (gc);
} // TR930SpectraRedraw

extern void
TR541MainClean (GtkWidget *MainWidget) {
GtkWidget *DrawingArea;
GdkGC *gc;

  DrawingArea = lookup_widget (MainWidget, "MainTR541DrawingArea");
  // Graphic context init
  gc = gdk_gc_new (DrawingArea->window);
  // Background
  gdk_window_set_background (DrawingArea->window, &LayerBackgroundColor);
  gdk_window_clear (DrawingArea->window);
  // Color unref
  gdk_gc_unref (gc);

  DrawingArea = lookup_widget (MainWidget, "MainTR541ChromDrawingArea");
  // Graphic context init
  gc = gdk_gc_new (DrawingArea->window);
  // Background
  gdk_window_set_background (DrawingArea->window, &LayerBackgroundColor);
  gdk_window_clear (DrawingArea->window);
  // Color unref
  gdk_gc_unref (gc);
} // TR541MainClean

extern void
TR541RawRedraw (int DataSource, GtkWidget *DrawingArea) {
#define X0 30
#define Y0 30
#define TR541RawFONT "Sans 8"
int i,j, jShift, jEnd, jBeg;
double Diff,zLower,zUpper;
int temp_data;
int TrackPos, TrackWidth, TrackLength;
int NormX, NormY;
int XRangeStart, XRangeEnd;
int STrack;

GdkGC *gc;
GdkColor ActualColor;

PangoLayout *RawLayout;
GdkScreen *RawScreen;
PangoRenderer *RawRenderer;

PangoMatrix RawMatrix = PANGO_MATRIX_INIT;
PangoMatrix RotatedRawMatrix;
PangoContext *RawContext;
PangoFontDescription *RawFontDesc;

int RawWidth;

  STrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(DrawingArea)), "TR541SelectedTrack"));

  RawScreen = gdk_drawable_get_screen (DrawingArea->window);


  // Graphic context init
  gc = gdk_gc_new (DrawingArea->window);

  // Background
  gdk_window_set_background (DrawingArea->window, &LayerBackgroundColor);
  gdk_window_clear (DrawingArea->window);

  zLower = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMin;
  zUpper = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewMax;
  Diff = 65.535 * (zUpper - zLower);
  if (Diff < 1) Diff = 1;
  jShift = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewScanYStart - 1;
  jShift = 0;
//  jEnd = Chrom[DataSource].TR541RawDataArrayRows;
  jEnd = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewScanYStop - \
		 Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewScanYStart + 1;
//  jBeg = Chrom[DataSource].TR541RawDataArrayBeg;
  jBeg = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ViewScanYStart - 1;
	//printf ("zLower = %.3f,   zUpper = %.3f,   Diff = %.3f\n", zLower, zUpper, Diff);
	//printf ("DataSource = %d   jEnd = %d   jShift = %d\n", DataSource, jEnd, jEnd);
  for (j = jBeg; j < jBeg + jEnd; j++) {
	  for (i = 0; i < 1000; i++) {
		  temp_data = (int)(65535*((double)Chrom[DataSource].TR541RawDataArray[j + jShift][i] - 65.535*zLower) / Diff);
		  if (temp_data < 0) temp_data = 0;
		  if (temp_data > 65535) temp_data = 65535;
		  ActualColor.red=temp_data;
		  ActualColor.green=temp_data;
		  ActualColor.blue=temp_data;
		  gdk_color_alloc(DrawColormap,&ActualColor);
		  gdk_gc_set_foreground(gc,&ActualColor);
		  gdk_draw_point(DrawingArea->window,gc,(int) (i*10/25) + X0,2*j + jShift + Y0);
		  gdk_draw_point(DrawingArea->window,gc,(int) (i*10/25) + X0,2*j + jShift + 1 + Y0);
	  } // i
  } // j

  // X-Y axis
  gdk_gc_set_foreground(gc,&LayerRulerColor);
  gdk_draw_line (DrawingArea->window, gc, X0 - 1, Y0 - 6, X0 - 1, Y0 + 400);
  gdk_draw_line (DrawingArea->window, gc, X0 - 6, Y0 + 200 , X0 - 1, Y0 + 200);
  gdk_draw_line (DrawingArea->window, gc, X0 - 6, Y0 + 400 , X0 - 1, Y0 + 400);
  gdk_draw_line (DrawingArea->window, gc, X0 - 6, Y0 - 1, X0 + 400, Y0 - 1);
  gdk_draw_line (DrawingArea->window, gc, X0 + 200, Y0 - 6, X0 + 200, Y0 - 1);
  gdk_draw_line (DrawingArea->window, gc, X0 + 400, Y0 - 6, X0 + 400, Y0 - 1);
  
  for (i = 1; i < 20; i++) {
	  gdk_draw_line (DrawingArea->window, gc, X0 - 3, Y0 + i*20 , X0 - 1, Y0 + i*20);
	  gdk_draw_line (DrawingArea->window, gc, X0 + i*20, Y0 - 3, X0 + i*20, Y0 - 1);
  } // i
  
  // Axis legends

  RawRenderer = gdk_pango_renderer_get_default (RawScreen);
  gdk_pango_renderer_set_gc (GDK_PANGO_RENDERER (RawRenderer), gc);
  RawContext = gdk_pango_context_get_for_screen (RawScreen);
  RawLayout = pango_layout_new (RawContext);
  RawFontDesc = pango_font_description_from_string (TR541RawFONT);
  pango_layout_set_font_description (RawLayout, RawFontDesc);
  pango_font_description_free (RawFontDesc);

  pango_layout_set_text (RawLayout, "0   X->", -1);
  gdk_draw_layout (DrawingArea->window, gc, X0 - 2, 8, RawLayout);

  pango_layout_set_text (RawLayout, "100", -1);
  pango_layout_get_pixel_size (RawLayout, &RawWidth, NULL);
  gdk_draw_layout (DrawingArea->window, gc, X0 + 200 - 1 - (RawWidth / 2), 8, RawLayout);

  pango_layout_set_text (RawLayout, "200 [mm]", -1);
  pango_layout_get_pixel_size (RawLayout, &RawWidth, NULL);
  gdk_draw_layout (DrawingArea->window, gc, X0 + 400 + 1 - RawWidth, 8, RawLayout);

  RotatedRawMatrix = RawMatrix;
  pango_matrix_rotate (&RotatedRawMatrix, 90.0);
  pango_context_set_matrix (RawContext, &RotatedRawMatrix);
  pango_layout_context_changed (RawLayout);

  pango_layout_set_text (RawLayout, "200 [mm]", -1);
  pango_layout_get_pixel_size (RawLayout, &RawWidth, NULL);
  gdk_draw_layout (DrawingArea->window, gc, 8, Y0 + 400 - RawWidth, RawLayout);

  pango_layout_set_text (RawLayout, "100", -1);
  pango_layout_get_pixel_size (RawLayout, &RawWidth, NULL);
  gdk_draw_layout (DrawingArea->window, gc, 8, Y0 + 200 - 1 - (RawWidth / 2), RawLayout);

  pango_layout_set_text (RawLayout, "<-Y   0", -1);
  pango_layout_get_pixel_size (RawLayout, &RawWidth, NULL);
  gdk_draw_layout (DrawingArea->window, gc, 8, Y0 - 2, RawLayout);

  // Clean up default renderer, since it is shared
  gdk_pango_renderer_set_override_color (GDK_PANGO_RENDERER (RawRenderer), \
										 PANGO_RENDER_PART_FOREGROUND, NULL);
  gdk_pango_renderer_set_drawable (GDK_PANGO_RENDERER (RawRenderer), NULL);
  gdk_pango_renderer_set_gc (GDK_PANGO_RENDERER (RawRenderer), NULL);

  // free the objects we created 
  g_object_unref (RawLayout);
  g_object_unref (RawContext);

  // Tracks

  gdk_gc_set_foreground(gc, &LayerTrackColor);
  TrackWidth = Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth;
  TrackLength = 400;
  if (Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540HalfSizeScan)
	  TrackLength = 200;
  for (i = 0; i < Chrom[DataSource].QueueHead.QueueItemNum; i++) {
	  TrackPos = Chrom[DataSource].QueueItemArray[i].TrackPosition;
	  if (i == STrack - 1)
		  gdk_draw_arc (DrawingArea->window, gc, TRUE, X0 + TrackLength - 3, Y0 + TrackPos*2 - 9, 18, 18, 330*64, 60*64);
	  gdk_gc_set_line_attributes (gc, 1, GDK_LINE_ON_OFF_DASH, GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
	  gdk_draw_line (DrawingArea->window, gc, X0 + 1, Y0 + TrackPos*2 , X0 + TrackLength, Y0 + TrackPos*2);
	  gdk_gc_set_line_attributes (gc, 1, GDK_LINE_SOLID, GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
	  gdk_draw_rectangle (DrawingArea->window, gc, FALSE, X0, Y0 + TrackPos*2 - TrackWidth, TrackLength, 2*TrackWidth);
  } // i - TrackNum

  gdk_gc_set_foreground(gc, &LayerNormColor);
  NormX = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.NormX * 2;
  NormY = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.NormY * 2;
  gdk_draw_line (DrawingArea->window, gc, X0 + NormX, Y0 + NormY - 6, X0 + NormX, Y0 + NormY + 7);
  gdk_draw_line (DrawingArea->window, gc, X0 + NormX - 6, Y0 + NormY , X0 + NormX + 7, Y0 + NormY);
  gdk_draw_point (DrawingArea->window, gc, X0 + NormX + 1, Y0 + NormY + 1);
  gdk_draw_point (DrawingArea->window, gc, X0 + NormX - 1, Y0 + NormY - 1);
  gdk_draw_point (DrawingArea->window, gc, X0 + NormX + 1, Y0 + NormY - 1);
  gdk_draw_point (DrawingArea->window, gc, X0 + NormX - 1, Y0 + NormY + 1);

  // Short ViewScan

  gdk_gc_set_foreground(gc, &LayerShortColor);
  if (Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540HalfSizeScan) {
	  gdk_gc_set_fill (gc, GDK_OPAQUE_STIPPLED);
	  gdk_gc_set_function (gc, GDK_XOR);
	  gdk_draw_rectangle (DrawingArea->window, gc, TRUE, X0 + 201, Y0, 200, 400);
	  gdk_gc_set_function (gc, GDK_COPY);
	  gdk_gc_set_fill (gc, GDK_SOLID);
  } // if Short ViewScan

  gdk_gc_set_foreground(gc, &LayerXRangeColor);
  XRangeStart = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ScanStartX * 2;
  XRangeEnd = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ScanStopX * 2;
  gdk_gc_set_line_attributes (gc, 1, GDK_LINE_ON_OFF_DASH, GDK_CAP_NOT_LAST, GDK_JOIN_MITER);
  gdk_draw_line (DrawingArea->window, gc, X0 + XRangeStart, Y0 + 1, X0 + XRangeStart, Y0 + 400);
  gdk_draw_line (DrawingArea->window, gc, X0 + XRangeEnd, Y0 + 1, X0 + XRangeEnd, Y0 + 400);
  gdk_gc_set_line_attributes (gc, 1, GDK_LINE_SOLID, GDK_CAP_NOT_LAST, GDK_JOIN_MITER);

  
  // Color unref
  gdk_gc_unref (gc);
} // TR541RawRedraw

extern void
TR541TrackRedraw (int DataSource, GtkWidget *DrawingArea) {
#define TR541TrackFONT "Sans Bold 7"
GdkGC *gc;
PangoLayout *RawLayout;
GdkScreen *RawScreen;
PangoRenderer *RawRenderer;
PangoContext *RawContext;
PangoFontDescription *RawFontDesc;
int i;
int XRangeStart, XRangeEnd, XRangeDiff;
int DrawX0, DrawY0, DrawX1, DrawY1;
int TrackMin, TrackMax, TrackDiff, TrackVal;
int TrackPos;
int AreaHeight = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(DrawingArea), "AreaHeight"));
int AreaWidth = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(DrawingArea), "AreaWidth"));
int STrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(DrawingArea)), "TR541SelectedTrack"));

  if (STrack < 1)
	  STrack = 1;
  TrackPos = Chrom[DataSource].QueueItemArray[STrack - 1].TrackPosition - 1;

  RawScreen = gdk_drawable_get_screen (DrawingArea->window);

  // Graphic context init
  gc = gdk_gc_new (DrawingArea->window);

  // Background
  gdk_window_set_background (DrawingArea->window, &LayerBackgroundColor);
  gdk_window_clear (DrawingArea->window);

  RawRenderer = gdk_pango_renderer_get_default (RawScreen);
  gdk_pango_renderer_set_gc (GDK_PANGO_RENDERER (RawRenderer), gc);
  RawContext = gdk_pango_context_get_for_screen (RawScreen);
  RawLayout = pango_layout_new (RawContext);
  RawFontDesc = pango_font_description_from_string (TR541TrackFONT);
  pango_layout_set_font_description (RawLayout, RawFontDesc);
  pango_font_description_free (RawFontDesc);

  if (Chrom[DataSource].QueueHead.QueueItemNum > 0) {
	  gdk_gc_set_foreground(gc, &DrawColor);
	  gdk_draw_line (DrawingArea->window, gc, 0, 0, 0, AreaHeight - 1);
	  gdk_draw_line (DrawingArea->window, gc, 0, AreaHeight - 1, AreaWidth, AreaHeight - 1);

	  XRangeStart = (Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ScanStartX - 1) * 5;
	  XRangeEnd = Chrom[DataSource].QueueHead.LQMethod.MeasureParameters.ScanStopX * 5 - 1;
	  if ((Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540HalfSizeScan) && \
		  (XRangeEnd > 500))
		  XRangeEnd = 500;

	  XRangeDiff = XRangeEnd - XRangeStart + 1;
	  if (XRangeDiff < 1)
		  XRangeDiff = 1;

	  gdk_gc_set_foreground(gc, &DrawColor);
	  pango_layout_set_text (RawLayout, "Centerline", -1);
	  gdk_draw_layout (DrawingArea->window, gc, 1, 10, RawLayout);
	  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  if (TrackDiff < 1)
		  TrackDiff = 1;
	  for (i = XRangeStart; i < XRangeEnd; i++) {
		  if (TrackMin > Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  if (TrackMax < Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
	  } // i
	  TrackDiff = TrackMax - TrackMin;
	  for (i = XRangeStart; i < XRangeEnd - 1; i++) {
		  DrawX0 = (int)((double)i/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  DrawX1 = (int)((double)(i + 1)/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  DrawY0 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i + 1];
		  DrawY1 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  gdk_draw_line (DrawingArea->window, gc, DrawX0 + 1, DrawY0 + 1, DrawX1 + 1, DrawY1 + 1);
	  } // i

	  TrackPos -= Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth/2;
	  if (TrackPos < 0)
		  TrackPos = 0;
	  gdk_gc_set_foreground(gc, &LayerTrackUpSideColor);
	  pango_layout_set_text (RawLayout, "Upside", -1);
	  gdk_draw_layout (DrawingArea->window, gc, 1, 0, RawLayout);
	  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  if (TrackDiff < 1)
		  TrackDiff = 1;
	  for (i = XRangeStart; i < XRangeEnd; i++) {
		  if (TrackMin > Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  if (TrackMax < Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
	  } // i
	  TrackDiff = TrackMax - TrackMin;
	  for (i = XRangeStart; i < XRangeEnd - 1; i++) {
		  DrawX0 = (int)((double)(i - XRangeStart)/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  DrawX1 = (int)((double)(i + 1 - XRangeStart)/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  DrawY0 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i + 1];
		  DrawY1 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  gdk_draw_line (DrawingArea->window, gc, DrawX0 + 1, DrawY0 + 1, DrawX1 + 1, DrawY1 + 1);
	  } // i

	  TrackPos += Chrom[DataSource].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth;
	  if (TrackPos > 199)
		  TrackPos = 199;
	  gdk_gc_set_foreground(gc, &LayerTrackDownSideColor);
	  pango_layout_set_text (RawLayout, "Downside", -1);
	  gdk_draw_layout (DrawingArea->window, gc, 1, 20, RawLayout);
	  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][XRangeStart];
	  if (TrackDiff < 1)
		  TrackDiff = 1;
	  for (i = XRangeStart; i < XRangeEnd; i++) {
		  if (TrackMin > Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMin = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  if (TrackMax < Chrom[DataSource].TR541RawDataArray[TrackPos][i])
			  TrackMax = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
	  } // i
	  TrackDiff = TrackMax - TrackMin;
	  for (i = XRangeStart; i < XRangeEnd - 1; i++) {
		  DrawX0 = (int)((double)i/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  DrawX1 = (int)((double)(i + 1)/(double)(XRangeDiff)*(double)(AreaWidth - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i];
		  DrawY0 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  TrackVal = Chrom[DataSource].TR541RawDataArray[TrackPos][i + 1];
		  DrawY1 = (int)((double)(TrackVal - TrackMin)/(double)TrackDiff*(double)(AreaHeight - 2));
		  gdk_draw_line (DrawingArea->window, gc, DrawX0 + 1, DrawY0 + 1, DrawX1 + 1, DrawY1 + 1);
	  } // i
  } // if QueueItemNum

  // Clean up default renderer, since it is shared
  gdk_pango_renderer_set_override_color (GDK_PANGO_RENDERER (RawRenderer), \
										 PANGO_RENDER_PART_FOREGROUND, NULL);
  gdk_pango_renderer_set_drawable (GDK_PANGO_RENDERER (RawRenderer), NULL);
  gdk_pango_renderer_set_gc (GDK_PANGO_RENDERER (RawRenderer), NULL);

  // free the objects we created 
  g_object_unref (RawLayout);
  g_object_unref (RawContext);

  // Color unref
  gdk_gc_unref (gc);
} // TR541TrackRedraw

// ***
// Method drawing functions
// ***
