// Axis functions

/*
	AxisTickLegend.AxisMin = ChrMin;
	AxisTickLegend.AxisMax = ChrMax;
	AxisTickCalculate (&AxisTickLegend, 1);
	printf ("AxisMin = %.3f \n", AxisTickLegend.AxisMin);
	printf ("AxisMax = %.3f \n", AxisTickLegend.AxisMax);
	printf ("SmallTickNum = %d \n", AxisTickLegend.SmallTickNum);
	printf ("BigTickNum = %d \n", AxisTickLegend.BigTickNum);
	printf ("SmallTickStartValue = %.3f \n", AxisTickLegend.SmallTickStartValue);
	printf ("BigTickStartValue = %.3f \n", AxisTickLegend.BigTickStartValue);
	for (i = 0; i < AxisTickLegend.BigTickNum; i++) {
		if (ChrDiff > 0) {
			y1 = (AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff - ChrMin) / ChrDiff * AxisHeight;
			if (y1 < 0) y1 = 0.0;
			gnome_print_newpath (gpc);
			gnome_print_moveto(gpc, AxisX0, AxisY0 + y1);
			gnome_print_lineto(gpc, AxisX0 - 4, AxisY0 + y1);
			gnome_print_lineto(gpc, AxisX0, AxisY0 + y1);
			gnome_print_closepath (gpc);
			gnome_print_stroke (gpc);
			sprintf (PrintString, "%.1f", AxisTickLegend.BigTickStartValue - i*AxisTickLegend.BigTickDiff);
			SetPrintJustify (PrintRightJustify, 0);
			PrintText (gpc, AxisX0 - 5, AxisY0 + y1, PrintString);
			SetPrintJustify (PrintLeftJustify, 0);
		} // if (ChrDiff > 0)
	} // for i
*/

extern void
AxisTickCalculate (struct AxisTickStruct *ATC, int LegendDensity) {
double	AOD;				// Axis Original Diff
double	ADE;				// Axis Diff Exponent
double	ADM;				// Axis Diff Multiplikator
double	AMF;				// Axis Max Floor
int		LD;

	ATC->SmallTickNum = 0;
	ATC->BigTickNum = 0;

	ATC->SmallTickDiff = 0.0;
	ATC->BigTickDiff = 0.0;
	ATC->SmallTickStartValue = ATC->AxisMax;
	ATC->BigTickStartValue = ATC->AxisMax;

	AOD = ATC->AxisMax - ATC->AxisMin;
	ADE = 0;
	ADM = 1;
	LD = LegendDensity;

	if (AOD != 0) {
		while (AOD > 10) {
			AOD /= 10;
			ADE++;
			ADM *= 10;
		} // while AOD > 10
	
		while (AOD < 1) {
			AOD *= 10;
			ADE--;
			ADM /= 10;
		} // while AOD < 1
	}

	AMF = ADM * floor (ATC->AxisMax / ADM);
	printf ("\n\nADM = %.3f,   AMF = %.3f\n", ADM, AMF);
	AOD = ATC->AxisMax - ATC->AxisMin;
	ATC->BigTickNum = (AMF - ATC->AxisMin) / ADM;
	ATC->BigTickStartValue = AMF;
	ATC->BigTickDiff = ADM;
	ATC->DiffMultiplikator = ADE;
} // AxisTickCalculate

/*
GDK_NUM_GLYPHS = 154,
GDK_X_CURSOR = 0,
GDK_ARROW = 2,
GDK_BASED_ARROW_DOWN = 4,
GDK_BASED_ARROW_UP = 6,
GDK_BOAT = 8,
GDK_BOGOSITY = 10,
GDK_BOTTOM_LEFT_CORNER = 12,
GDK_BOTTOM_RIGHT_CORNER = 14,
GDK_BOTTOM_SIDE = 16,
GDK_BOTTOM_TEE = 18,
GDK_BOX_SPIRAL = 20,
GDK_CENTER_PTR = 22,
GDK_CIRCLE = 24,
GDK_CLOCK = 26,
GDK_COFFEE_MUG = 28,
GDK_CROSS = 30,
GDK_CROSS_REVERSE = 32,
GDK_CROSSHAIR = 34,
GDK_DIAMOND_CROSS = 36,
GDK_DOT = 38,
GDK_DOTBOX = 40,
GDK_DOUBLE_ARROW = 42,
GDK_DRAFT_LARGE = 44,
GDK_DRAFT_SMALL = 46,
GDK_DRAPED_BOX = 48,
GDK_EXCHANGE = 50,
GDK_FLEUR = 52,
GDK_GOBBLER = 54,
GDK_GUMBY = 56,
GDK_HAND1 = 58,
GDK_HAND2 = 60,
GDK_HEART = 62,
GDK_ICON = 64,
GDK_IRON_CROSS = 66,
GDK_LEFT_PTR = 68,
GDK_LEFT_SIDE = 70,
GDK_LEFT_TEE = 72,
GDK_LEFTBUTTON = 74,
GDK_LL_ANGLE = 76,
GDK_LR_ANGLE = 78,
GDK_MAN = 80,
GDK_MIDDLEBUTTON = 82,
GDK_MOUSE = 84,
GDK_PENCIL = 86,
GDK_PIRATE = 88,
GDK_PLUS = 90,
GDK_QUESTION_ARROW = 92,
GDK_RIGHT_PTR = 94,
GDK_RIGHT_SIDE = 96,
GDK_RIGHT_TEE = 98,
GDK_RIGHTBUTTON = 100,
GDK_RTL_LOGO = 102,
GDK_SAILBOAT = 104,
GDK_SB_DOWN_ARROW = 106,
GDK_SB_H_DOUBLE_ARROW = 108,
GDK_SB_LEFT_ARROW = 110,
GDK_SB_RIGHT_ARROW = 112,
GDK_SB_UP_ARROW = 114,
GDK_SB_V_DOUBLE_ARROW = 116,
GDK_SHUTTLE = 118,
GDK_SIZING = 120,
GDK_SPIDER = 122,
GDK_SPRAYCAN = 124,
GDK_STAR = 126,
GDK_TARGET = 128,
GDK_TCROSS = 130,
GDK_TOP_LEFT_ARROW = 132,
GDK_TOP_LEFT_CORNER = 134,
GDK_TOP_RIGHT_CORNER = 136,
GDK_TOP_SIDE = 138,
GDK_TOP_TEE = 140,
GDK_TREK = 142,
GDK_UL_ANGLE = 144,
GDK_UMBRELLA = 146,
GDK_UR_ANGLE = 148,
GDK_WATCH = 150,
GDK_XTERM = 152,
*/

extern void
DrawInit (void) {
int i,j;

#define PeakAdd_x_hot 7
#define PeakAdd_y_hot 0

char PeakAdd_bits[] = {
   0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x84, 0x10,
   0x86, 0x30, 0xff, 0x7f, 0x86, 0x30, 0x84, 0x10, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00};

char PeakAdd_mask_bits[] = {
   0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xcc, 0x19, 0xce, 0x39,
   0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xce, 0x39, 0xcc, 0x19, 0xc0, 0x01,
   0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0x00, 0x00};

char demo_cursor_bits[] = {
  0x80, 0x01, 0x40, 0x02, 0x20, 0x04, 0x10, 0x08, 0x08, 0x10, 0x04, 0x20,
  0x82, 0x41, 0x41, 0x82, 0x41, 0x82, 0x82, 0x41, 0x04, 0x20, 0x08, 0x10,
  0x10, 0x08, 0x20, 0x04, 0x40, 0x02, 0x80, 0x01};
 
char demo_cursor_mask_bits[] = {
  0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c, 0x18, 0x18, 0x8c, 0x31,
  0xc6, 0x63, 0x63, 0xc6, 0x63, 0xc6, 0xc6, 0x63, 0x8c, 0x31, 0x18, 0x18,
  0x30, 0x0c, 0x60, 0x06, 0xc0, 0x03, 0x80, 0x01};
 
 

GdkPixbuf *LedON_tmp;
GdkPixbuf *LedOFF_tmp;

GdkPixmap *source, *mask;

GdkColor demo_fg = { 0, 65535, 0, 0 }; /* Red. */
GdkColor demo_bg = { 0, 0, 0, 65535 }; /* Blue. */

GdkColor PeakAdd_fg = { 0, 0, 0, 0 }; /* Red. */
GdkColor PeakAdd_bg = { 0, 65535, 65535, 65535 }; /* Blue. */

// Fonts

  DrawString = calloc (1000, sizeof(char)); // "-dec-terminal-medium-r-normal-*-*-140-*-*-c-*-iso8859-1"
  DrawFont = gdk_font_load ("-*-*-medium-r-normal-*-*-*-*-*-m-*-iso8859-1");
  AxisFont = gdk_font_load ("-*-*-medium-r-normal-*-*-*-*-*-m-*-iso8859-1");
  PeakFont = gdk_font_load ("-*-*-medium-r-normal-*-*-*-*-*-m-*-iso8859-1");
  CalibrAxisFont = gdk_font_load ("-*-*-medium-r-normal-*-*-*-*-*-m-*-iso8859-1");
  CalibrNumberFont = gdk_font_load ("-*-*-medium-r-normal-*-*-*-*-*-m-*-iso8859-1");
  DrawColormap = gdk_colormap_get_system ();

// Cursors

  source = gdk_bitmap_create_from_data (NULL, demo_cursor_bits, CursorWidth, CursorHeight);
  mask = gdk_bitmap_create_from_data (NULL, demo_cursor_mask_bits, CursorWidth, CursorHeight);
  DemoCursor = gdk_cursor_new_from_pixmap (source, mask, &demo_fg, &demo_bg, 8, 8);
  gdk_pixmap_unref (source);
  gdk_pixmap_unref (mask);

  source = gdk_bitmap_create_from_data (NULL, PeakAdd_bits, CursorWidth, CursorHeight);
  mask = gdk_bitmap_create_from_data (NULL, PeakAdd_mask_bits, CursorWidth, CursorHeight);
  PeakAddCursor = gdk_cursor_new_from_pixmap (source, mask, &PeakAdd_fg, &PeakAdd_bg, PeakAdd_x_hot, PeakAdd_y_hot);
  gdk_pixmap_unref (source);
  gdk_pixmap_unref (mask);

  NormalCursor = gdk_cursor_new (GDK_LEFT_PTR);
  ZoomCursor = gdk_cursor_new (GDK_CROSSHAIR);
  BaselineMoveCursor = gdk_cursor_new (GDK_FLEUR);
  BaselineTypeChangeCursor = gdk_cursor_new (GDK_SB_UP_ARROW);
  RetMoveCursor = gdk_cursor_new (GDK_SB_UP_ARROW);
  EventAddCursor = gdk_cursor_new (GDK_SB_UP_ARROW);
  EventDelCursor = gdk_cursor_new (GDK_SB_UP_ARROW);

  MouseMode = MouseIdle;
  for (i = 0; i < MaxInstrument; i++)
	  Options[i].ZoomPermanent = FALSE;

// Setting colors

// Gradient colors

  for (j = 0; j < MaxGradRatio; j++) {
	  GradientColors[j].red = GradientConfigColors[j].red;
	  GradientColors[j].green = GradientConfigColors[j].green;
	  GradientColors[j].blue = GradientConfigColors[j].blue;
	  gdk_colormap_alloc_color (DrawColormap, &GradientColors[j], TRUE, TRUE);
  } // j MaxGradRatio

// Generic chromatogram line draw color
  DrawColor.red = 0;
  DrawColor.green = 0;
  DrawColor.blue = 0;
  gdk_color_alloc (DrawColormap, &DrawColor);

  for (i = 0; i < MaxInstrument; i++) {
	  for (j = 0; j < MaxDetectors; j++) {
		  DetectorColors[i][j].red = 0;
		  DetectorColors[i][j].green = 0;
		  DetectorColors[i][j].blue = 0;
		  gdk_colormap_alloc_color (DrawColormap, &DetectorColors[i][j], TRUE, TRUE);
	  } // j MaxDetectors
  } // i MaxInstrument

  for (j = 0; j < MaxDetectors; j++) {
	  ReprocessDetectorColors[j].red = 0;
	  ReprocessDetectorColors[j].green = 0;
	  ReprocessDetectorColors[j].blue = 0;
	  gdk_colormap_alloc_color (DrawColormap, &ReprocessDetectorColors[j], TRUE, TRUE);
  } // j MaxDetectors

  for (j = 0; j < MaxOverlayedChrom; j++) {
	  OverlayColor[j].red = 0;
	  OverlayColor[j].green = 0;
	  OverlayColor[j].blue = 0;
	  gdk_colormap_alloc_color (DrawColormap, &OverlayColor[j], TRUE, TRUE);
  } // j MaxDetectors

  BackgroundColor.red = 0xFFFF;
  BackgroundColor.green = 0xFFFF;
  BackgroundColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &BackgroundColor);

  BackgroundIOColor.red = 0xFFFF;
  BackgroundIOColor.green = 0xFFFF;
  BackgroundIOColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &BackgroundIOColor);

  Background2IOColor.red = 0x83FF;
  Background2IOColor.green = 0x83FF;
  Background2IOColor.blue = 0x83FF;
  gdk_color_alloc (DrawColormap, &Background2IOColor);

  LayerBackgroundColor.red = 0xFFFF;
  LayerBackgroundColor.green = 0xFFFF;
  LayerBackgroundColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &LayerBackgroundColor);

  LayerTrackColor.red = 0xFFFF;
  LayerTrackColor.green = 0;
  LayerTrackColor.blue = 0;
  gdk_color_alloc (DrawColormap, &LayerTrackColor);

  LayerRulerColor.red = 0;
  LayerRulerColor.green = 0;
  LayerRulerColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &LayerRulerColor);

  LayerShortColor.red = 0x0FFF;
  LayerShortColor.green = 0x0FFF;
  LayerShortColor.blue = 0x0FFF;
  gdk_color_alloc (DrawColormap, &LayerShortColor);

  LayerNormColor.red = 0xAFFF;
  LayerNormColor.green = 0x3FFF;
  LayerNormColor.blue = 0x3FFF;
  gdk_color_alloc (DrawColormap, &LayerNormColor);

  LayerXRangeColor.red = 0x2FFF;
  LayerXRangeColor.green = 0xBFFF;
  LayerXRangeColor.blue = 0x2FFF;
  gdk_color_alloc (DrawColormap, &LayerXRangeColor);

  LayerYRangeColor.red = 0x0FFF;
  LayerYRangeColor.green = 0x0FFF;
  LayerYRangeColor.blue = 0x0FFF;
  gdk_color_alloc (DrawColormap, &LayerYRangeColor);

  LayerTrackUpSideColor.red = 0;
  LayerTrackUpSideColor.green = 0xFFFF;
  LayerTrackUpSideColor.blue = 0;
  gdk_color_alloc (DrawColormap, &LayerTrackUpSideColor);

  LayerTrackDownSideColor.red = 0;
  LayerTrackDownSideColor.green = 0;
  LayerTrackDownSideColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &LayerTrackDownSideColor);

// Measure draw
  MeasureGridlineColor.red = 0xEFFF;
  MeasureGridlineColor.green = 0xEFFF;
  MeasureGridlineColor.blue = 0xEFFF;
  gdk_color_alloc (DrawColormap, &MeasureGridlineColor);

  MeasureGridlineStrongColor.red = 0xCFFF;
  MeasureGridlineStrongColor.green = 0xCFFF;
  MeasureGridlineStrongColor.blue = 0xCFFF;
  gdk_color_alloc (DrawColormap, &MeasureGridlineStrongColor);

  RetColor.red = 0xFFFF;
  RetColor.green = 0x8FFF;
  RetColor.blue = 0x8FFF;
  gdk_color_alloc (DrawColormap, &RetColor);

  MQListLockedFGColor.red = 0xAFFF;
  MQListLockedFGColor.green = 0x6FFF;
  MQListLockedFGColor.blue = 0x6FFF;
  gdk_color_alloc (DrawColormap, &MQListLockedFGColor);

  MQListLockedBGColor.red = 0xDFFF;
  MQListLockedBGColor.green = 0xDFFF;
  MQListLockedBGColor.blue = 0xDFFF;
  gdk_color_alloc (DrawColormap, &MQListLockedBGColor);

  MQListRunningFGColor.red = 0xFFFF;
  MQListRunningFGColor.green = 0;
  MQListRunningFGColor.blue = 0;
  gdk_color_alloc (DrawColormap, &MQListRunningFGColor);

  MQListRunningBGColor.red = 0xEFFF;
  MQListRunningBGColor.green = 0xEFFF;
  MQListRunningBGColor.blue = 0xEFFF;
  gdk_color_alloc (DrawColormap, &MQListRunningBGColor);

// Reprocess colors
  BaselineColor.red = 0xFFFF;
  BaselineColor.green = 0;
  BaselineColor.blue = 0;
  gdk_color_alloc (DrawColormap, &BaselineColor);

  PeakNumberColor.red = 0;
  PeakNumberColor.green = 0;
  PeakNumberColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &PeakNumberColor);

  SelectionColor.red = 0xFFFF;
  SelectionColor.green = 0;
  SelectionColor.blue = 0;
  gdk_color_alloc (DrawColormap, &SelectionColor);

  ReprocessGridlineColor.red = 0xEFFF;
  ReprocessGridlineColor.green = 0xEFFF;
  ReprocessGridlineColor.blue = 0xEFFF;
  gdk_color_alloc (DrawColormap, &ReprocessGridlineColor);

  ReprocessGridlineStrongColor.red = 0xCFFF;
  ReprocessGridlineStrongColor.green = 0xCFFF;
  ReprocessGridlineStrongColor.blue = 0xCFFF;
  gdk_color_alloc (DrawColormap, &ReprocessGridlineStrongColor);

  LockColor.red = 0;
  LockColor.green = 0x1FFF;
  LockColor.blue = 0xCFFF;
  gdk_color_alloc (DrawColormap, &LockColor);

  EventColor.red = 0;
  EventColor.green = 0x8FFF;
  EventColor.blue = 0;
  gdk_color_alloc (DrawColormap, &EventColor);

  CursorLineColor.red = 0;
  CursorLineColor.green = 0;
  CursorLineColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &CursorLineColor);

  PeakAddColor.red = 0;
  PeakAddColor.green = 0xFFFF;
  PeakAddColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &PeakAddColor);

  BaselineMoveColor.red = 0;
  BaselineMoveColor.green = 0xFFFF;
  BaselineMoveColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &BaselineMoveColor);

  ZoomColor.red = 0;
  ZoomColor.green = 0xFFFF;
  ZoomColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &ZoomColor);

  SelectedPeakColor.red = 0;
  SelectedPeakColor.green = 0xFFFF;
  SelectedPeakColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &SelectedPeakColor);

// Calibration colors
  CalibrationGridlineColor.red = 0xDFFF;
  CalibrationGridlineColor.green = 0xFFFF;
  CalibrationGridlineColor.blue = 0xDFFF;
  gdk_color_alloc (DrawColormap, &CalibrationGridlineColor);

  CalibrationGridlineStrongColor.red = 0xCFFF;
  CalibrationGridlineStrongColor.green = 0xEFFF;
  CalibrationGridlineStrongColor.blue = 0xCFFF;
  gdk_color_alloc (DrawColormap, &CalibrationGridlineStrongColor);

  CalibrationBaseColor.red = 0;
  CalibrationBaseColor.green = 0;
  CalibrationBaseColor.blue = 0;
  gdk_color_alloc (DrawColormap, &CalibrationBaseColor);

  CalibrationBackgroundColor.red = 0xFFFF;
  CalibrationBackgroundColor.green = 0xFFFF;
  CalibrationBackgroundColor.blue = 0xFFFF;
  gdk_color_alloc (DrawColormap, &CalibrationBackgroundColor);

  CalibrationNumberColor.red = 0;
  CalibrationNumberColor.green = 0;
  CalibrationNumberColor.blue = 0x7FFF;
  gdk_color_alloc (DrawColormap, &CalibrationNumberColor);

  CalibrationSelectionColor.red = 0x7FFF;
  CalibrationSelectionColor.green = 0;
  CalibrationSelectionColor.blue = 0;
  gdk_color_alloc (DrawColormap, &CalibrationSelectionColor);


// Create drawing pixbufs
  LedON_tmp = create_pixbuf ("LedON.png");
  LedOFF_tmp = create_pixbuf ("LedOFF.png");

  LedOnPixbuf = gdk_pixbuf_scale_simple (LedON_tmp, 24, 24, GDK_INTERP_HYPER);
  LedOffPixbuf = gdk_pixbuf_scale_simple (LedOFF_tmp, 24, 24, GDK_INTERP_HYPER);

  gdk_pixbuf_unref (LedON_tmp);
  gdk_pixbuf_unref (LedOFF_tmp);

  InputPixbuf = create_pixbuf ("INPUT.png");
  OutputPixbuf = create_pixbuf ("OUTPUT.png");

  EventFlagPixbuf = create_pixbuf ("EventFLAG.png");
} // DrawInit

extern void
DrawDone (void) {
  gdk_pixbuf_unref (OutputPixbuf);
  gdk_pixbuf_unref (InputPixbuf);
  gdk_pixbuf_unref (LedOffPixbuf);
  gdk_pixbuf_unref (LedOnPixbuf);

  gdk_cursor_unref (NormalCursor);
  gdk_cursor_unref (ZoomCursor);
  gdk_cursor_unref (PeakAddCursor);
  gdk_cursor_unref (BaselineMoveCursor);

  gdk_font_unref (PeakFont);
  gdk_font_unref (AxisFont);
  gdk_font_unref (DrawFont);
  gdk_font_unref (CalibrAxisFont);
  gdk_font_unref (CalibrNumberFont);
  free (DrawString);
} // DrawDone
