// Calibration drawing routines

extern void
CalibrationRedraw (GtkWidget *CalibrationWindow) {
#define CalX0 10
#define CalY0 10
#define CalW0 (CalX0 + 10)
#define CalH0 (CalY0 + 10)
int i;
// int			x1, x2, y1, y2;
char *TextOutString;
char *AxisString;
double MaxX, MaxY;
double PointX, PointY;
double CurveX0, CurveY0;
double CurveX1, CurveY1;

GtkWidget *CalDrawArea;
GdkGC *gc;

  CalDrawArea = lookup_widget (CalibrationWindow, "CalibrationDrawingArea");
  int CalibrateDrawingAreaHeight = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(CalDrawArea), "CalibrateDrawingAreaHeight"));
  int CalibrateDrawingAreaWidth = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(CalDrawArea), "CalibrateDrawingAreaWidth"));
  DATASOURCE(CalibrationWindow);
  CAL_SELECTEDS(CalibrationWindow);

  // GC init
  gc = gdk_gc_new (CalDrawArea->window);

  // Background
  gdk_window_set_background (CalDrawArea->window, &CalibrationBackgroundColor);
  gdk_window_clear (CalDrawArea->window);

  // Fonts, strings
  AxisString = alloca (100);
  TextOutString = alloca (100);

  // Axis
  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc, \
				CalX0, CalY0, \
				10, CalibrateDrawingAreaHeight-10);
  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc, \
				CalX0,CalibrateDrawingAreaHeight-10, \
				CalibrateDrawingAreaWidth-11,CalibrateDrawingAreaHeight-10);

  // Axis tickmarks
  for (i = 0; i< 100; i++) {
	  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 100)), CalibrateDrawingAreaHeight - 10,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 100)), CalibrateDrawingAreaHeight - 6);
	  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc,\
					CalX0, (int)(CalY0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 100)),\
					6, (int)(CalY0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 100)));
  } // for i

  for (i = 0; i< 20; i++) {
	  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc, (int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 20)), CalibrateDrawingAreaHeight - 10,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 20)), CalibrateDrawingAreaHeight - 4);
	  gdk_draw_line(CalDrawArea->window, CalDrawArea->style->black_gc, 11, (int)(CalX0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 20)),\
					4, (int)(CalX0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 20)));
  } // for i

  printf ("\n### CalibrateDrawingAreaWidth = %d,   CalibrateDrawingAreaHeight= %d\n\n", CalibrateDrawingAreaWidth, CalibrateDrawingAreaHeight);
  // Gridlines
  gdk_gc_set_foreground (gc, &CalibrationGridlineColor);
  for (i = 0; i< 100; i++) {
	  gdk_draw_line(CalDrawArea->window, gc,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 100)), CalY0,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 100)), CalibrateDrawingAreaHeight - (CalY0 + 1));
	  gdk_draw_line(CalDrawArea->window, gc,\
					CalX0 + 1, (int)(CalY0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 100)),\
					CalibrateDrawingAreaWidth - CalX0, (int)(CalY0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 100)));
  } // for i

  gdk_gc_set_foreground (gc, &CalibrationGridlineStrongColor);
  for (i = 0; i< 20; i++) {
	  gdk_draw_line(CalDrawArea->window, gc,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 20)), 10,\
					(int)(CalX0 + (i+1)*(((double)CalibrateDrawingAreaWidth - 20) / 20)), CalibrateDrawingAreaHeight - 11);
	  gdk_draw_line(CalDrawArea->window, gc,\
					11, (int)(CalX0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 20)),\
					CalibrateDrawingAreaWidth - 11, (int)(CalX0 + (i+0)*(((double)CalibrateDrawingAreaHeight - 20) / 20)));
  } // for i

  // Draw
  if ((Chrom[DataSource].FileLoaded[CalFlag]) &&\
	  (SelectedComponent > -1) &&\
	  (Chrom[DataSource].CalibrHead->LevelNum > 0) && \
	  (Chrom[DataSource].CalibrHead->CalibrType == CalibrExtStd)) {
	  gdk_gc_set_foreground (gc, &CalibrationBaseColor);
	  GetConc (SelectedComponent, 0, DataSource);
	  MaxX = Chrom[DataSource].CalibrConc->Concentration * \
			 Chrom[DataSource].CalibrConc->ParameterEndResult;
	  MaxY = Chrom[DataSource].CalibrConc->WorkValue;
	  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum; i++) {
		  GetConc (SelectedComponent, i, DataSource);
		  if (MaxX < Chrom[DataSource].CalibrConc->Concentration * \
			  Chrom[DataSource].CalibrConc->ParameterEndResult)
			  MaxX = Chrom[DataSource].CalibrConc->Concentration * \
					 Chrom[DataSource].CalibrConc->ParameterEndResult;
		  if (MaxY < Chrom[DataSource].CalibrConc->WorkValue)
			  MaxY = Chrom[DataSource].CalibrConc->WorkValue;
	  } // i LevelNum
	  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum; i++) {
		  GetConc (SelectedComponent, i, DataSource);
		  PointX = Chrom[DataSource].CalibrConc->Concentration * \
				   Chrom[DataSource].CalibrConc->ParameterEndResult / \
				   MaxX / 1.1 * (CalibrateDrawingAreaWidth - 20);
		  PointY = Chrom[DataSource].CalibrConc->WorkValue / \
				   MaxY / 1.1 * (CalibrateDrawingAreaHeight - 20);
		// printf ("Level: %d,  MaxX: %.3f,  MaxY: %.3f, PointX: %.1f, PointY: %.1f\n", i + 1, MaxX, MaxY, PointX, PointY);
	  gdk_draw_line(CalDrawArea->window, gc, \
					PointX + CalX0 -5, CalibrateDrawingAreaHeight - PointY - 10 - 5,
					PointX + CalX0 + 5, CalibrateDrawingAreaHeight - PointY - 10 + 5);
	  gdk_draw_line(CalDrawArea->window, gc, \
					PointX + CalX0 - 5, CalibrateDrawingAreaHeight - PointY - 10 + 5,
					PointX + CalX0 + 5, CalibrateDrawingAreaHeight - PointY - 10 - 5);
	  } // i LevelNum
	  GetComponent (SelectedComponent, DataSource);
	  switch (Chrom[DataSource].CalibrHead->CurveType) {
		case CalibrCurve1ParL:
			CurveX0 = 0;
			CurveY0 = 0;
			CurveX1 = MaxX / MaxX / 1.1 * (CalibrateDrawingAreaWidth - 20);
			CurveY1 = MaxX * Chrom[DataSource].CalibrComponent->AParam / \
					  MaxY / 1.1 * (CalibrateDrawingAreaHeight - 20);
			gdk_draw_line (CalDrawArea->window, gc, \
						   CurveX0 + CalX0, CalibrateDrawingAreaHeight - CurveY0 -10, \
						   CurveX1 + CalX0, CalibrateDrawingAreaHeight - CurveY1 -10);
			break; // CalibrCurve1ParL
		case CalibrCurve2ParL:
			break; // CalibrCurve2ParL
		case CalibrCurve2ParE:
			break; // CalibrCurve2ParE
	  } // switch
  } // if CalibrTable, SelectedCalibrComp OK

  // Color unref
  gdk_gc_unref (gc);
} // CalibrationRedraw
