// System constants

// Graphic system constants

#define CursorWidth 16
#define CursorHeight 16

// Hardware constants

// Mode - IN, OUT, etc.
// IN - Wait for signal
// OUT - Put signal to output lines
// GET - Get a data byte from IO Ch#2 of HW
// SET - Set a data byte to IO Ch#2 of HW
// CHK - Get a signal bit, without WAIT
// HOLD - No clear, when signal was put
#define ControlSignalModeIN 0
#define ControlSignalModeOUT 1
#define ControlSignalModeGET 2
#define ControlSignalModeSET 3
#define ControlSignalModeCHK 4
#define ControlSignalModeHOLD 5

// Control signal indexes in array
#define ControlSignalNum 22					// Number of control signals
#define ControlSignalMaxIdx 40			// For array declaration
#define ControlSignal_IN_GenericEnable 0
#define ControlSignal_OUT_Standard 1
#define ControlSignal_IN_Standard 2
#define ControlSignal_OUT_Control 3
#define ControlSignal_IN_Control 4
#define ControlSignal_OUT_RetControl 5
#define ControlSignal_IN_RetControl 6
#define ControlSignal_IN_Sampler 7
#define ControlSignal_OUT_Autozero 8
#define ControlSignal_IN_Ready 9
#define ControlSignal_OUT_Start 10
#define ControlSignal_IN_Run 11
#define ControlSignal_IN_CheckSample 12
#define ControlSignal_IN_CheckStandard 13
#define ControlSignal_IN_CheckControl 14
#define ControlSignal_IN_CheckRetControl 15
#define ControlSignal_IN_Overflow 16
#define ControlSignal_IN_Warning 17
#define ControlSignal_IN_Error 18
#define ControlSignal_IN_CheckStop 19
#define ControlSignal_OUT_Stop 20
#define ControlSignal_IN_Stopped 21
/*
#define ControlSignal
#define ControlSignal
#define ControlSignal
*/

// Control events
#define ControlEvent_START_GenericEnabled 0
#define ControlEvent_START_EmitStandard 1
#define ControlEvent_START_HoldStandard 2
#define ControlEvent_START_WaitStandard 3
#define ControlEvent_START_EmitControl 4
#define ControlEvent_START_HoldControl 5
#define ControlEvent_START_WaitControl 6
#define ControlEvent_START_EmitRetControl 7
#define ControlEvent_START_HoldRetControl 8
#define ControlEvent_START_WaitRetControl 9
#define ControlEvent_START_SendSampler 10
#define ControlEvent_START_WaitSampler 11
#define ControlEvent_START_Autozero 12
#define ControlEvent_START_WaitReady 13
#define ControlEvent_START_EmitStart 14
#define ControlEvent_START_WaitRun 15
#define ControlEvent_START_CheckSample 16
#define ControlEvent_START_CheckStandard 17
#define ControlEvent_START_CheckControl 18
#define ControlEvent_START_CheckRetControl 19
#define ControlEvent_START_Num 20 // Number of control events = LAST + 1
/*
#define ControlEvent_START_
*/

#define ControlEvent_RUN_SignalOverflow 0
#define ControlEvent_RUN_CheckWarning 1
#define ControlEvent_RUN_CheckError 2
#define ControlEvent_RUN_CheckStop 3
#define ControlEvent_RUN_Num 4 // Number of control events = LAST + 1
/*
#define ControlEvent_RUN_
*/

#define ControlEvent_STOP_EmitStopSignal 0
#define ControlEvent_STOP_WaitStopReady 1
#define ControlEvent_STOP_Num 2 // Number of control events = LAST + 1
/*
#define ControlEvent_STOP_
*/

#define SRSInit TRUE
#define SRSWork FALSE

#define SRSStart 0
#define SRSRun 1
#define SRSStop 2
#define SRSNum 3

enum {
  GRAD_COL_EVENTNUM = 0,
  GRAD_COL_TIME,
  GRAD_COL_FLOW,
  GRAD_COL_A,
  GRAD_COL_B,
  GRAD_COL_C,
  GRAD_COL_D,
  GRAD_COL_NUM
};

enum {
  GRAD_COL_SORT_EVENTNUM = 0,
  GRAD_COL_SORT_TIME,
  GRAD_COL_SORT_FLOW,
  GRAD_COL_SORT_A,
  GRAD_COL_SORT_B,
  GRAD_COL_SORT_C,
  GRAD_COL_SORT_D,
  GRAD_COL_SORT_NUM
};

// Data processing

#define SmoothTriangle 0

// Instrument constants

#define MaxInstruments 4						// In the software
#define MaxInstrument 4							// In DataStation
#define MaxDetectors 4
#define MaxMainChannels MaxInstrument
#define MaxSubChannels MaxDetectors
#define MaxGradRatio 4

// Work area index for chromatographic data arrays
#define WorkArea MaxInstrument
#define W_A MaxInstrument
#define WA MaxInstrument

// Overlay draw index
#define MaxOverlayedChrom 6
#define OverlayedChromBase (WorkArea + 1)

#define DevelopSingleFile (WorkArea + MaxOverlayedChrom)

// Chrom data structure size
#define MaxWorkChromData (MaxInstrument + 1)
#define MaxChromData (DevelopSingleFile + 1)

// Data definition constants
#define MaxOnOff 10

#define DetectorModeSingleChrom 0
#define DetectorModeMultiChrom 1
#define DetectorModeFittedResult 2

#define InstrumentNone 0
#define InstrumentWorkstation 1
#define InstrumentDataStation 2
#define InstrumentTR541 3
#define InstrumentTR542 4
#define InstrumentTR930 5

#define InstrumentSamplingInMin 0       // X data in min
#define InstrumentSamplingInSec 1     // X data in sec or mm
#define InstrumentSamplingInMM 2     // X data in sec or mm


#define ChromatographTypeNone 0
#define ChromatographTypeTLCGEL 1
#define ChromatographTypeGC 2
#define ChromatographTypeHPLC 3

#define ADConverterNone 0
#define ADConverterChromBox2 1
#define ADConverterChromBox3 2
#define ADConverterChromBox4 3
#define ADConverterChromBox5 4

#define ChannelDistributionMain 0
#define ChannelDistributionSub 1

#define MaxADSamplingArray 5

#define MaxStartControlEvents 60
#define MaxRunControlEvents 10
#define MaxStopControlEvents 10
#define MaxAllControlEvents 60
// MaxAllControlEvents is the highest value of ControlEvents
#define MaxInstrumentEvents 100

#define MaxSampleType 10
#define ActualSampleType 4
#define SampleTypeSample 0
#define SampleTypeControl 1
#define SampleTypeStandard 2
#define SampleTypeRetControl 3
//#define SampleType
//#define SampleType

// Flags for file operations (not saved, FileID, etc.)
#define FlagMax 18
#define ChrFlag 1
#define CalFlag 2
#define MetFlag 3
#define RepFlag 4
#define OptFlag 5
#define CfgFlag 6
#define DATFlag 7
#define IntFlag 8
#define ProFlag 9
#define LayFlag 10
#define VWSFlag 11
#define KovFlag 12
#define CCrFlag 13
#define TCrFlag 14
#define XXXFlag 15
#define SpeFlag 16
#define ImpFlag 17

// String length definitions
#define IdLength 80
#define DimLength 15
#define CommentLength 250
#define InfoLength 1250
#define FilenameLength 1024
#define BaseFilenameLength 200
#define FontNameLength 200
#define ADTraceStringLength 200

// Integration constants
#define MaxIntegrationLock 10
#define MaxIntegrationEventNum 100

#define PeakDetectStateIdle 0
#define PeakDetectStateUp 1
#define PeakDetectStateApex 2
#define PeakDetectStateDown 3
#define PeakDetectStateDone 4

// List of timed events
#define EventNumbers 42
#define EventResetAllEvents						0
#define EventResetAllBaselineParameterEvent		10
#define EventSampleBaseline						11
#define EventResetBaselineParameters			12
#define EventResetAllSlopeCalculationEvent		20
#define EventSampleBaselineSlopeHere			21
#define EventResetBaselineSlopeValue			22
#define EventResetAllThresholdEvent				30
#define EventIncAreaThreshold					31
#define EventDecAreaThreshold					32
#define EventResetAreaThreshold					33
#define EventIncHeightThreshold					34
#define EventDecHeightThreshold					35
#define EventResetHeightThreshold				36
#define EventIncWidthThreshold					37
#define EventDecWidthThreshold					38
#define EventResetWidthThreshold				39
#define EventIncreaseUpslope					40
#define EventDecreaseUpslope					41
#define EventResetUpslope						42
#define EventIncreaseDownslope					43
#define EventDecreaseDownslope					44
#define EventResetDownslope						45
#define EventSetSlopeCalculationPoints			46
#define EventResetSlopeCalculation				47
#define EventPeakStartsHere						50
#define EventPeakEndsHere						51
#define EventResetBaselineSettingEvents		60
#define EventForceBaseBaseMethod				61
#define EventForcedValleyMethodON				62
#define EventForcedValleyMethodOFF				63
#define EventThisPeakIsTangentMain				64
#define EventNextPeakIsTangentMain				65
#define EventForceTangentMethodInRange			66
#define EventForcedBaselineSTART				70
#define EventForcedBaselineSTOP					71
#define EventForcedBaselineStringMethodENABLE	72
#define EventForcedBaselineStringMethodDISABLE	73
#define EventGluePeaks							80
#define EventGluePeaksON						81
#define EventGluePeaksOFF						82
#define EventSplitPeakHere						83

enum {
  BP_BASE,
  BP_VALLEY,
  BP_TANGENT,
  BP_TANGENT_VALLEY,
  BP_TANGENT_BASE,
  BP_VALLEY_TANGENT
}; // BASEPOINT_TYPE

enum {
  BASEPOINT_TO_BASE,
  BASEPOINT_TO_VALLEY
}; // BASEPOINT_CHANGE

enum {
  PEAK_SIDE_BEGIN,
  PEAK_SIDE_END
}; // PEAK_SIDE

/*
#define Event
*/

// Post measure calculation
#define ConcCalculationAreaPercent 0
#define ConcCalculationScaleFactor 1
#define ConcCalculationInternalStandard 2
#define ConcCalculationExternalStandard 3

// Report constants
#define MaxReportHeadItems 20
#define MaxReportColumns 20
#define ReportPortrait 0
#define ReportLandscape 1

// Regression constants
#define MaxRegrParam 2

// Gauss elimination
#define TNarraySize 3
#define TNNearlyZero 1e-015

// Calibration constants

#define CalibrPeakIdent 0
#define CalibrAreaNorm 1
#define CalibrIntStd 2
#define CalibrExtStd 3
#define CalibrMaxType 3

#define CalibrGPCOn TRUE
#define CalIBRGPCOff FALSE

#define CalibrChromBase 0
#define CalibrLevelBase 1

#define CalibrAreaBase 0
#define CalibrHeightBase 1
#define CalibrMaxBase 1

#define CalibrCurve1ParL 0              // 1 parameter, linear
#define CalibrCurve2ParL 1              // 2 parameters,linear
#define CalibrCurve2ParE 2              // 2 parameter, exponential
#define CalibrCurve1ParQ 3              // 1 parameter, quadratic
#define CalibrMaxCurve 4

#define CalibrRetention 0
#define CalibrRelativeRet 1
#define CalibrRetFactor 2
#define CalibrPeakOrder 3
#define CalibrMaxRet 3

#define CalibrZeroOn TRUE
#define CalibrZeroOff FALSE

#define GroupIdFirst 0
#define GruopIdMean 1

#define CalibrOk 0

// Data definition constants

#define MaxLayerQueueItems 100
#define MaxQueueCollectItems 10
#define MaxTrackCurvePoints 20

// Measure constants

#define ThreadStatusIdle 0
#define ThreadStatusStart 1
#define ThreadStatusStartProcess 2
#define ThreadStatusStartExec 3
#define ThreadStatusRun 4
#define ThreadStatusRunProcess 5
#define ThreadStatusStop 6
#define ThreadStatusStopProcess 7
#define ThreadStatusConvert 8
#define ThreadStatusConvertExec 9
#define ThreadStatusConvertWait 10
#define ThreadStatusPrepareNext 11
#define ThreadStatusPrepareNextWait 12
#define ThreadStatusWait 13
#define ThreadStatusFinish 14
#define ThreadStatusSuspended 15
#define ThreadStatusCancelled 16
#define ThreadStatusUserBreak 17
#define ThreadStatusInTest 97
#define ThreadStatusCloseTest 98
#define ThreadStatusError 99

#define ThreadStatusTLCIdle ThreadStatusIdle
#define ThreadStatusTLCPreset 1001
#define ThreadStatusTLCViewScanPrepare 1002
#define ThreadStatusTLCViewScan 1003
#define ThreadStatusTLCViewScanDone 1004
#define ThreadStatusTLCRun 1005
#define ThreadStatusTLCDone 1006
//#define ThreadStatusTLC

// Instrument specific
//#define ThreadStatusTR541 1000x

#define ThreadCommandNone 0
#define ThreadCommandStart 1
#define ThreadCommandStop 2
#define ThreadCommandConvert 3
#define ThreadCommandFinish 4
#define ThreadCommandSuspend 5
#define ThreadCommandContinue 6
#define ThreadCommandCancel 7
#define ThreadCommandBreak 8
#define ThreadCommandTestIn 9
#define ThreadCommandTestOut 10

#define ThreadCommandErrorNone 0
#define ThreadCommandErrorTimeOut 1

// Measure run mode
#define MeasureRunModeUnique 0
#define MeasureRunModeQueue 1
#define MeasureRunModeContinous 2

// Queue run mode constants
#define QueueRunNone 0
#define QueueRunManual 1
#define QueueRunAuto 2

// Cont mode restart
#define ContinousRestartChrom 0
#define ContinousRestartTime 1

#define ContinousNameModeDT 0
#define ContinousNameModeName 1

// Name defaults
#define NameDefaultDateNone 0
#define NameDefaultDateDay 1
#define NameDefaultDateSec 2

// Instrument sepcific constants

#define RawTypeNone 0
#define RawTypeTR541 1
#define RawTypeTR542 2
#define RawTypeTR930 3

// Common TRx constants
#define TRxNormalZero 0
#define TRxNormalSet 1
#define TRxNormalHalf 2
#define TRxNormalFull 3
#define TRxNormalUp 4
#define TRxNormalDown 5
#define TRxNormalNormalize 6

// TR540 definitions
#define TR540MeasureStatusIdle 0
#define TR540MeasureStatusNew 1
#define TR540MeasureStatusViewScan 2
#define TR540MeasureStatusViewScanReady 3
#define TR540MeasureStatusQueueOk 4
#define TR540MeasureStatusReady 5

#define TR540MeasureStatusError 998
#define TR540MeasureStatusAllInactive 999

#define TR540ReflectionMode 0
#define TR540FluorescentMode 1
#define TR540TransmissionMode 2

#define TR540CommandReflectance 10
#define TR540CommandTransmittance 11
#define TR540CommandSetFilter 20
#define TR540CommandXHome 30
#define TR540CommandXStep 31
#define TR540CommandYHome 40
#define TR540CommandYStep 41
#define TR540CommandMotorOff 50
#define TR540CommandDAZero 60
#define TR540CommandDAHalf 61
#define TR540CommandDAFull 62
#define TR540CommandDAUp 63
#define TR540CommandDADown 64
#define TR540CommandDANormalize 65
#define TR540CommandDASet 66
#define TR540CommandMeasureLine 70
#define TR540CommandMeasureShortLine 71
#define TR540CommandADValue 80
#define TR540CommandDirectPortSET 90
#define TR540CommandDirectPortGET 91
#define TR540CommandDirectPortBitSET 92
#define TR540CommandDirectPortBitGET 93
#define TR540CommandDirectPortBitCLR 94
#define TR540CommandDirectLatchSET 95
#define TR540CommandDirectLatchGET 96
/*
#define TR540Command
#define TR540Command
#define TR540Command
#define TR540Command
#define TR540Command
#define TR540Command
*/

// TR930 Measure constants

#define TR930SpectraLength			560

#define TR930MeasScanModeRefl	0
#define TR930MeasScanModeFluor	1
#define TR930MeasScanModeTransm	2

#define TR930MeasScanGeomLin		0
#define TR930MeasScanGeomZZ1	1
#define TR930MeasScanGeomZZ2	2

#define TR930MeasViewScanNo		0
#define TR930MeasViewScan1		1
#define TR930MeasViewScan2		2

#define TR930MeasNewState			0
#define TR930MeasMethodState		1
#define TR930MeasTrackState		2
#define TR930MeasMeasureState	3
#define TR930MeasDoneState		4
#define TR930MeasRunningState	99

#define TR930MethodSimpleSave	0
#define TR930MethodStartMeas		1

#define TR930SpectraUV				0
#define TR930SpectraVIS				1

#define TR930SpectraRef				0
#define TR930SpectraSample			1

#define TR930CommandXHome				0
#define TR930CommandXStep				1
#define TR930CommandXStepH				2
#define TR930CommandYHome				3
#define TR930CommandYStep				4
#define TR930CommandYStepH				5
#define TR930CommandGotoWL				6
#define TR930CommandDASet				7
#define TR930CommandDA0					8
#define TR930CommandDAFull				9
#define TR930CommandDAHalf				10
#define TR930CommandDAUp					11
#define TR930CommandDADown				12
#define TR930CommandNormalize			13
#define TR930CommandLowResMeas		14
#define TR930CommandLowResAcqOnly	15
#define TR930CommandLowResNullStep	16
#define TR930CommandHiResMeas			17
#define TR930CommandZigZagMeas		18
#define TR930CommandHiVoltRefl			19
#define TR930CommandHiVoltTran			20
#define TR930CommandHiVoltOff				21
/*
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
#define TR930Command
*/

// Drawing definitions
#define MouseIdle 0
#define MouseZoom 1
#define MousePeakAdd 2
#define MouseBaselineMove 3

// template constants
#define MaxTemplateRowLength 400

// Printing definitions
#define PrintTestMode 0
#define PrintChromMode 1
#define PrintPeakDataMode 2
#define PrintTR930SpectraMode 3
#define PrintControlListMode 4
#define PrintSampleQueueMode 5
#define PrintIntParMode 6
/*
#define Print
#define Print
#define Print
*/

// Print justification definitions
#define PrintLeftJustify 0
#define PrintRightJustify 1
#define PrintCenterJustify 2
#define PrintDecimalPointJustify 3
#define PrintLengthJustify 4


// Export settings

#define ExportInternalTemplateLength 2500

enum {
  EXPORT_MODE_FIXED,
  EXPORT_MODE_FILE,
  EXPORT_MODE_INTERNAL
};

enum {
  EXPORT_TABLE_BASE,
  EXPORT_TABLE_EXTENDED
};

enum {
  EXPORT_INPUT_ENC_DEFAULT,
  EXPORT_INPUT_ENC_LOCALE,
  EXPORT_INPUT_ENC_UTF8,
  EXPORT_INPUT_ENC_OTHER
};

enum {
  EXPORT_OUTPUT_ENC_DEFAULT,
  EXPORT_OUTPUT_ENC_LOCALE,
  EXPORT_OUTPUT_ENC_UTF8,
  EXPORT_OUTPUT_ENC_OTHER
};
