// Spectra window callbacks

void
on_SpectraWindow_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *CallerButton;
GtkWidget *OpenedWindow;

  gtk_object_set_data (GTK_OBJECT(gtk_object_get_data (object, "CallerWidget")), "SpectraWindow", NULL);

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenSaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);
}


void
on_SpectraNewButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  NewSpectra (&Spectra);
  SetSpectraWidgets ();
  ActivateSpectraWidgets ();
  TR930SpectraRedraw ();
}


void
on_SpectraOpenButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *OpenedWindow;

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton))), "OpenSaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton))), "OpenSaveFileSelection", OpenSaveFileSelection);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", toolbutton);
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SpectraOpenOkFunction);
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.spectra");
//  if (strlen (LastChromDir) == 0)
//	  strcpy (LastChromDir, gtk_file_selection_get_filename(GTK_FILE_SELECTION(OpenSaveFileSelection)));
//  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), LastChromDir);
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open spectra");
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_SpectraSaveButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_SpectraCopyButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_SpectraExportButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_SpectraPrintButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  PrintFunction (PrintTR930SpectraMode, NULL, NULL, TRUE);
}


void
on_SpectraExitButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


gboolean
on_SpectraTR930DrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  SpectraDrawingAreaHeight = event->height;
  SpectraDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_SpectraTR930DrawingArea_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_SpectraTR930DrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  TR930SpectraRedraw ();

  return FALSE;
}


void
on_SpectraTR930UVRadioButton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930VISRadioButton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930RefExecuteButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930SampleExecuteButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930AutoCheckButton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930AutoExecuteButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930RadioButtonR_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930RadioButton1R_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930RadioButtonLogR_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930RadioButtonKM_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_SpectraTR930FinishButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{

}
