// Reprocess popup menu callback functions


void
on_ReprocessDetectorComboBox_changed   (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
int ZBeg, ZEnd;
double ZMin, ZMax;
int ActDet;
int j;

  ActDet = gtk_combo_box_get_active (combobox);
  if (ActDet < 0) return;

  Chrom[WorkArea].ActualDetector = ActDet;
  ZBeg = Zoom->ZoomBeg;
  ZEnd = Zoom->ZoomEnd;
  ZMin = Zoom->ZoomMin;
  ZMax = Zoom->ZoomMax;
  ZoomReset ();
  Zoom->ZoomBeg = 0;
  Zoom->ZoomEnd = Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1;
  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMin;
  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMax;
  ZoomIn ();
  Zoom->ZoomBeg = ZBeg;
  Zoom->ZoomEnd = ZEnd;
  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMin;
  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMax;

  if (Options[WorkArea].ShowAllDetectors) {
	  for (j = 0; j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors; j++) {
		  if (Zoom->ZoomMin > Chrom[WorkArea].ChromHead->Parameter[j].ChrMin)
			  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[j].ChrMin;
		  if (Zoom->ZoomMax < Chrom[WorkArea].ChromHead->Parameter[j].ChrMax)
			  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[j].ChrMax;
	  } // j
  } // if ShowAll

  CursorLineDone ();
  ReprocessDrawChrom();
  CursorLineInit ();
  CursorLineDraw ();
}


void
on_ReprocessDetectorColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{
  Options[WorkArea].red[Chrom[WorkArea].ActualDetector] = red;
  Options[WorkArea].green[Chrom[WorkArea].ActualDetector] = green;
  Options[WorkArea].blue[Chrom[WorkArea].ActualDetector] = blue;
  ReprocessDetectorColors[Chrom[WorkArea].ActualDetector].red = red;
  ReprocessDetectorColors[Chrom[WorkArea].ActualDetector].green = green;
  ReprocessDetectorColors[Chrom[WorkArea].ActualDetector].blue = blue;
  gdk_colormap_alloc_color (DrawColormap, &ReprocessDetectorColors[Chrom[WorkArea].ActualDetector], TRUE, TRUE);

  CursorLineDone ();
  ReprocessDrawChrom();
  CursorLineInit ();
  CursorLineDraw ();
}


void
on_ReprocessDetectorShowAllCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
int j;
int ZBeg, ZEnd;
double ZMin, ZMax;

  ZBeg = Zoom->ZoomBeg;
  ZEnd = Zoom->ZoomEnd;
  ZMin = Zoom->ZoomMin;
  ZMax = Zoom->ZoomMax;
  ZoomReset ();
  Zoom->ZoomBeg = 0;
  Zoom->ZoomEnd = Chrom[WorkArea].ChromHead->Method.MeasureParameters.Nmp - 1;
  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMin;
  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMax;

  ZoomIn ();
  Zoom->ZoomBeg = ZBeg;
  Zoom->ZoomEnd = ZEnd;
  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMin;
  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].ChrMax;
  if (gtk_toggle_button_get_active (togglebutton)) {
	  for (j = 0; j < Chrom[WorkArea].ChromHead->Method.Instrument.NumDetectors; j++) {
		  if (Zoom->ZoomMin > Chrom[WorkArea].ChromHead->Parameter[j].ChrMin)
			  Zoom->ZoomMin = Chrom[WorkArea].ChromHead->Parameter[j].ChrMin;
		  if (Zoom->ZoomMax < Chrom[WorkArea].ChromHead->Parameter[j].ChrMax)
			  Zoom->ZoomMax = Chrom[WorkArea].ChromHead->Parameter[j].ChrMax;
	  } // j
  } // if ShowAll

  Options[WorkArea].ShowAllDetectors = gtk_toggle_button_get_active (togglebutton);

  CursorLineDone ();
  ReprocessDrawChrom();
  CursorLineInit ();
  CursorLineDraw ();
}


void
on_ReprocessPopupAdd_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (PeakAddInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  PeakAddInit ();
  PeakAddStart = TRUE;
}


void
on_ReprocessPopupDelete_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (SelectedPeak == -1) return;
  DelPeak (SelectedPeak, WorkArea);
  RefreshPeakList ();
  //RefreskPeakInfo
  SelectedPeak = -1;
  RefreshReprocessAppBar ();
}


void
on_ReprocessPopupModify_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPopupType_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPopupSelect_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPopupUnselect_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPopupInfo_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPopupMenu_hide             (GtkWidget       *widget,
                                        gpointer         user_data)
{
}


void
on_ReprocessPopupMenu_destroy          (GtkObject       *object,
                                        gpointer         user_data)
{
}


void
on_ReprocessPopupMenu_selection_done   (GtkMenuShell    *menushell,
                                        gpointer         user_data)
{
  CursorLineOn ();
  ReprocessDrawChrom ();
}

// Baseline type PopUp menu

void
on_BLTypeToBaseItem_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
int ChangeRetVal;

  DATASOURCE(MENU_TOP(menuitem));
  CalculateRetentionFromCursor (DrawCursorX, DrawCursorY);
  ChangeRetVal = ChangePeakBaseline (DataSource, BASEPOINT_TO_BASE);
  if (!ChangeRetVal) printf ("ChangePeakBaseline NOT succesfull.\n\n");
  ReintegrateI (DataSource);
}


void
on_BLTypeToValleyItem_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
int ChangeRetVal;

  DATASOURCE(MENU_TOP(menuitem));
  CalculateRetentionFromCursor (DrawCursorX, DrawCursorY);
  ChangeRetVal = ChangePeakBaseline (DataSource, BASEPOINT_TO_VALLEY);
  if (!ChangeRetVal) printf ("ChangePeakBaseline NOT succesfull.\n\n");
  ReintegrateI (DataSource);
}


void
on_BLTypeChangeMenu_selection_done     (GtkMenuShell    *menushell,
                                        gpointer         user_data)
{
  printf ("on_BLTypeChangeMenu_selection_done\n");
  BaselineTypeChangeInProgress = FALSE;
  BaselineTypeChangeDone ();
  CursorLineInit ();
}


void
on_BLTypeCancelItem_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  printf ("on_BLTypeCancelItem_activate\n");
}


// Reprocess window callback functions

void
on_ReprocessWindow_destroy             (GtkObject       *object,
                                        gpointer         user_data)
{

}


gboolean
on_ReprocessWindow_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide (widget);
  return TRUE;
}


void
on_ReprocessWindow_hide                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  PRINTF ("on_ReprocessWindow_hide\n",0);
}


void
on_ReprocessWindow_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  PRINTF ("on_ReprocessWindow_show\n",0);
}


void
on_ReprocessNew_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessOpen_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessSave_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
  ChromSave (WorkArea);
}


void
on_ReprocessSaveAs_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Save chromatogram");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SaveChromOkFunction);
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.chr");
  if (strlen (LastChromDir) == 0)
	  strcpy (LastChromDir, gtk_file_selection_get_filename(GTK_FILE_SELECTION(OpenSaveFileSelection)));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Chrom[WorkArea].ChrName);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_ReprocessPrintSettings_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  PreferencesWindow = create_PreferencesWindow ();
  gtk_object_set_data (GTK_OBJECT (get_toplevel_of_menuitem (GTK_WIDGET(menuitem))), "PreferencesWindow", PreferencesWindow);
  PresetPreferencesWidgets (PreferencesWindow,
										5,
										get_toplevel_of_menuitem (GTK_WIDGET(menuitem)),
										GTK_WIDGET (menuitem),
										MainPreferencesApplyFunction); // Print Tabs are shown
  SetPreferencesWidgets (PreferencesWindow);
  gtk_window_set_transient_for (GTK_WINDOW(PreferencesWindow), GTK_WINDOW(ReprocessWindow));
  gtk_widget_show (PreferencesWindow);
}


void
on_ReprocessImport_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gpointer *ImportData;
gpointer *ImportSizedData;

  ImportDialog = create_ImportDialog ();

  ImportData = calloc (10000, sizeof(int));
  ImportSizedData = calloc (10000, sizeof(int));

  ImportFileName = calloc (1000, sizeof(char));

  gtk_object_set_data (GTK_OBJECT (ImportDialog), "DataPointerSize", GINT_TO_POINTER (10000)); // buffer size

  gtk_object_set_data (GTK_OBJECT (ImportDialog), "DataPointer", ImportData);
  gtk_object_set_data (GTK_OBJECT (ImportDialog), "DataSize", GINT_TO_POINTER (10000)); // number of data points

  gtk_object_set_data (GTK_OBJECT (ImportDialog), "DataSizedPointer", ImportSizedData);
  gtk_object_set_data (GTK_OBJECT (ImportDialog), "DataSizedSize", GINT_TO_POINTER (10000)); // number of data points

  ActivateWidget (ImportDialog, "ImportDialogOkButton", FALSE);

  gtk_widget_show (GTK_WIDGET (ImportDialog));
  SetImportWidgets (GTK_WIDGET (ImportDialog));
  gnome_file_entry_set_title (GNOME_FILE_ENTRY(lookup_widget (ImportDialog, "ImportDialogFileEntry")), _("Import data stream"));
  gnome_file_entry_set_modal (GNOME_FILE_ENTRY(lookup_widget (ImportDialog, "ImportDialogFileEntry")), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (ImportDialog), GTK_WINDOW (ReprocessWindow));
}


void
on_ReprocessExport_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
GtkWidget *ChromExportDialog;
GtkWidget *Chooser;
gchar *BaseName;
gchar *DirName;

  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  ChromExportDialog = create_ChromExportDialog ();
  gtk_window_set_modal (GTK_WINDOW (ChromExportDialog), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (ChromExportDialog), GTK_WINDOW (MENU_TOP(menuitem)));
  BaseName = g_path_get_basename (Chrom[WorkArea].ChrName);
  DirName = g_path_get_dirname (Chrom[WorkArea].ChrName);
  
  if (strstr (BaseName, ".chr") != NULL) {
	  if (strlen (BaseName) > 4) {
		  if ((strstr (BaseName, ".chr") - BaseName) == (strlen (BaseName) - 4))
			  BaseName[strlen (BaseName) - 4] = 0x00;
	  }
  }

  Chooser = lookup_widget (ChromExportDialog, "ChromExportDialogFileChooserWidget");
  
  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER(Chooser), DirName);
  gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER(Chooser), BaseName);
  
  g_free (BaseName);
  g_free (DirName);

  gtk_widget_show (ChromExportDialog);
}


void
on_ChromExportDialogHelpButton_clicked (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_ChromExportDialogCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (WIDGET_TOP(button));
}


void
on_ChromExportDialogOkButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
struct ExportModeStruct *ExportMode;
gchar *Filename;

  ExportMode = calloc (1, sizeof (struct ExportModeStruct));

  ExportMode->AddExtension = GetCheckBox (WIDGET_TOP(button), "ChromExportDialogExtensionCheckButton");
  strncpy (ExportMode->Extension, GetEntry (WIDGET_TOP(button), "ChromExportDialogExtensionEntry"), 10);
  ExportMode->ParameterMode = 0;
  if (GetCheckBox (WIDGET_TOP(button), "ChromExportDialogParametersInStreamRadioButton")) ExportMode->ParameterMode = 1;
	  else
		  if (GetCheckBox (WIDGET_TOP(button), "ChromExportDialogParametersInFileRadioButton")) ExportMode->ParameterMode = 2;
  strncpy (ExportMode->ParamExtension, GetEntry (WIDGET_TOP(button), "ChromExportDialogParametersEntry"), 10);

  Filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(lookup_widget (WIDGET_TOP(button), "ChromExportDialogFileChooserWidget")));
  ChromExportInRaw (WorkArea, Filename, ExportMode);
  g_free (Filename);
  free (ExportMode);
  gtk_widget_destroy (WIDGET_TOP(button));
}


void
on_ReprocessImportCDF_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
GtkWidget *NetCDFWindow;
	
//  if (NetCDFxml == NULL) {
  	NetCDFxml = glade_xml_new ("/usr/share/labchrom2/netcdf_io.glade", NULL, NULL);
	glade_xml_signal_autoconnect(NetCDFxml);
//	g_object_unref(G_OBJECT(NetCDFxml));

	printf ("glade_xml_new: netcdf_io.glade\n");
//  }

  NetCDFWindow = glade_xml_get_widget (NetCDFxml, "NetCDFWindow");
  gtk_widget_show (NetCDFWindow);
}


void
on_ReprocessExportCDF_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
  strcat (Chrom[WorkArea].Filename, ".cdf");

  NetCDFExport (WorkArea, Chrom[WorkArea].Filename);
  printf ("NetCDFExport: %s\n", Chrom[WorkArea].Filename);
}


void
on_ReprocessExportResultList_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
char *ResultString;
char *TemplateString;

  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  ADSI(MainWindow);
  ResultString = NULL;
  TemplateString = NULL;
  switch (Options[ActualDSInstrument].ExportMode) {
	  case EXPORT_MODE_FIXED:
		  ResultString = GenerateFixExportString (WorkArea);
		  break;
	  case EXPORT_MODE_FILE:
		  TemplateString = LoadExportTemplateString (ActualDSInstrument);
		  ResultString = ProcessTemplateString (TemplateString, WorkArea, ActualDSInstrument, EXPORT_INPUT_ENC_LOCALE, EXPORT_OUTPUT_ENC_LOCALE);
		  if (TemplateString != NULL) free (TemplateString);
		  break;
	  case EXPORT_MODE_INTERNAL:
		  ResultString = ProcessTemplateString (Options[ActualDSInstrument].ExportInternalTemplate, WorkArea, ActualDSInstrument, EXPORT_OUTPUT_ENC_UTF8, EXPORT_OUTPUT_ENC_LOCALE);
		  break;
  } // switch 
  
  if (ResultString != NULL) {
	  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
	  strcat (Chrom[WorkArea].Filename, ".txt");
	  SaveResultList (WorkArea, ResultString);
	  
	  free (ResultString);
  }
}


void
on_ReprocessExportPicture_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
GdkPixbuf *ChromPixbuf;
GtkWidget *DrawWidget;
GError *PixbufError;
char *PixbufName;

  DrawWidget = lookup_widget (ReprocessWindow,"ReprocessDrawingArea");

  gdk_flush ();
  ReprocessDrawChrom ();
  ChromPixbuf = gdk_pixbuf_get_from_drawable (NULL, DrawWidget->window, DrawColormap,
				  0, 0, 0, 0, ReprocessDrawingAreaWidth, ReprocessDrawingAreaHeight);
  if (ChromPixbuf == NULL) return;
  
  PixbufName = calloc (1200, 1);
  strcpy (PixbufName, Chrom[WorkArea].ChrName);
  strcat (PixbufName, ".jpg");
  printf ("PixbufName = %s\n", PixbufName);
  PixbufError = NULL;
  gdk_pixbuf_save (ChromPixbuf, PixbufName, "jpeg", &PixbufError,
                 "quality", "100", NULL);
  free (PixbufName);
  g_object_unref (ChromPixbuf);
  
}


void
on_ReprocessQuit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(menuitem)));
}


void
on_ReprocessCut_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessCopy_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPaste_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessClear_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessProperties_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
GtkWidget *MethodWindow;

  ADSI(MENU_TOP(menuitem));
  MethodWindow = create_MethodWindow ();
  gtk_window_set_transient_for (GTK_WINDOW(MethodWindow), GTK_WINDOW(ReprocessWindow));
  gtk_object_set_data (GTK_OBJECT (get_toplevel_of_menuitem (GTK_WIDGET (menuitem))), "MethodWindow", MethodWindow);
  DATASOURCE_UP (MethodWindow, WorkArea);
  ADSI_UP(MethodWindow, ActualDSInstrument);
  PresetMethodWidgets (MethodWindow,
								&Chrom[WorkArea].ChromHead->Method,
								get_toplevel_of_menuitem (GTK_WIDGET (menuitem)),
								GTK_WIDGET (menuitem),
								MethodReprocessOkFunction);
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "IntParChan", GINT_TO_POINTER(0));
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "Report", &Chrom[WorkArea].Method.Report);

  SetMethodWidgets (MethodWindow);
  ActivateWidget (MethodWindow, "MethodMeasParSetButton", FALSE);
  ActivateWidget (MethodWindow, "MethodMeasParZeroButton", FALSE);
  ActivateWidget (MethodWindow, "MethodDataProcPostRunSampleTypeApplyButton", FALSE);
//  ActivateWidget (MethodWindow, "", FALSE);
//  ActivateWidget (MethodWindow, "", FALSE);
  gtk_widget_show (MethodWindow);
}


void
on_ReprocessPreferences_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessIndex_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
int MenuActive;
int ButtonActive;

  if (ReprocessShowListsReady == FALSE) return;

  ButtonActive = gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON(lookup_widget (ReprocessWindow, "ReprocessIndexToggleButton")));
  MenuActive = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (ButtonActive == MenuActive)
	  return;
  ReprocessShowLists = MenuActive;
  gtk_toggle_tool_button_set_active (GTK_TOGGLE_TOOL_BUTTON(lookup_widget (ReprocessWindow, "ReprocessIndexToggleButton")), ReprocessShowLists);
  if (ReprocessShowLists == FALSE)
	  HideWidget (ReprocessWindow, "ReprocessVBox");
  else
	  ShowWidget (ReprocessWindow, "ReprocessVBox");
}


void
on_ReprocessSampleQueue_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  if (ReprocessShowListsReady == FALSE) return;

  ReprocessShowQueue = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));

  if (ReprocessShowQueue == FALSE) {
	  HideWidget (ReprocessWindow, "ReprocessQueueVBox");
	  HideWidget (ReprocessWindow, "ReprocessHSeparator");
  } else {
	  ShowWidget (ReprocessWindow, "ReprocessQueueVBox");
  } // ReprocessShowQueue

  if ((ReprocessShowOverlay == TRUE) && (ReprocessShowQueue == TRUE))
	  ShowWidget (ReprocessWindow, "ReprocessHSeparator");

}


void
on_ReprocessOverlay_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  if (ReprocessShowListsReady == FALSE) return;

  ReprocessShowOverlay = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));

  if (ReprocessShowOverlay == FALSE) {
	  HideWidget (ReprocessWindow, "ReprocessOverlayVBox");
	  HideWidget (ReprocessWindow, "ReprocessHSeparator");
  } else {
	  ShowWidget (ReprocessWindow, "ReprocessOverlayVBox");
  } // ReprocessShowQueue

  if ((ReprocessShowOverlay == TRUE) && (ReprocessShowQueue == TRUE))
	  ShowWidget (ReprocessWindow, "ReprocessHSeparator");

}


void
on_ReprocessTextOnToolbars_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomIn_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomOut_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomReset_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomReport_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomSwitch_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessZoomByValue_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
GtkWidget *ZoomWindow;

  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  ZoomWindow = create_ZoomWindow ();
  gtk_object_set_data (GTK_OBJECT (MENU_TOP(menuitem)), "ZoomWindow", ZoomWindow);
  PresetZoomWidgets (ZoomWindow,
								MENU_TOP(menuitem),
								GTK_WIDGET (menuitem),
								ZoomReprocessApplyFunction);
  SetZoomWidgets (ZoomWindow);
  gtk_window_set_transient_for (GTK_WINDOW(ZoomWindow), GTK_WINDOW(ReprocessWindow));
  gtk_window_set_modal (GTK_WINDOW(ZoomWindow), TRUE);
  gtk_widget_show (ZoomWindow);
}


void
on_ReprocessTickMarks_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowTickMarks = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessBaselines_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowBaselines = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessFillPeaks_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowFillPeaks = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessPeakNumbers_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowPeakNumbers = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessRetention_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowRetention = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessName_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowName = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessComment_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowComment = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessTime_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReprocessShowTime = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (!ReprocessShowInitStatus)
	  ReprocessDrawChrom ();
}


void
on_ReprocessIntegrationParameters_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakAdd_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakDelete_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakSelect_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakSelectAll_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakDeselectAll_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakSelectVisible_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessPeakRevertSelection_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessBaselineMove_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
//  if (ZoomPermanentCheck())
//	  ZoomPermanentSuspend ();

}


void
on_ReprocessBaselineType_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessBaselineTangent_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessLockSet_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessLockRemove_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessEventSet_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessEventRemove_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_ReprocessReintegrate_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ReintegrateDBI (WorkArea);
  ReprocessDrawChrom ();
}


void
on_ReprocessAbout_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (ReprocessWindow));
  gtk_widget_show (About);
}


void
on_ReprocessIndexToggleButton_toggled  (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{
int MenuActive;
int ButtonActive;

  if (ReprocessShowListsReady == FALSE) return;

  ButtonActive = gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON(toggletoolbutton));
  MenuActive = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessIndex")));
  if (ButtonActive == MenuActive)
	  return;
  ReprocessShowLists = ButtonActive;
  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessIndex")), ReprocessShowLists);
  if (ReprocessShowLists == FALSE)
	  HideWidget (ReprocessWindow, "ReprocessVBox");
  else
	  ShowWidget (ReprocessWindow, "ReprocessVBox");
}


void
on_ReprocessOpenButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(toolbutton));
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open chromatogram");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", OpenChromOkFunction);
  if (strlen (LastChromDir) == 0)
	  strcpy (LastChromDir, Options[ActualDSInstrument].DefaultDataRootDir);
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.chr");
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), LastChromDir);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_ReprocessSaveButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
  ChromSave (WorkArea);
}


void
on_ReprocessPrintButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(toolbutton));
  //PrintFunction (PrintControlListMode, GINT_TO_POINTER(WorkArea), TRUE);
  PrintFunction (PrintChromMode, GINT_TO_POINTER(WorkArea), GINT_TO_POINTER(ActualDSInstrument), TRUE);
}


void
on_ReprocessPeakListButton_clicked     (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
//  gtk_widget_show (PeakListWindow);
  RefreshPeakList ();
  gtk_window_present (GTK_WINDOW (PeakListWindow));
}


void
on_ReprocessPeakDataButton_clicked     (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_show (PeakInfoWindow);
  gtk_window_present (GTK_WINDOW (PeakInfoWindow));
}


void
on_ReprocessIntoCalibrButton_clicked   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
int i;
char *RowData[3];

  RowData[0] = alloca(20);
  RowData[1] = alloca(IdLength);
  RowData[2] = alloca(10);

  strcpy(RowData[0],"");
  strcpy(RowData[1],"");
  strcpy(RowData[2],"");

  DATASOURCE(WIDGET_TOP(toolbutton));
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  ChromToCalibrDialog = create_ChromToCalibrDialog ();

  DATASOURCE_UP(ChromToCalibrDialog, DataSource);
  gtk_object_set_data (GTK_OBJECT (ChromToCalibrDialog), "CallerWidget", WIDGET_TOP(toolbutton));
  gtk_object_set_data (GTK_OBJECT (ChromToCalibrDialog), "CallerButton", toolbutton);
  gtk_object_set_data (GTK_OBJECT (ChromToCalibrDialog), "ChromToCalibrLevel", GINT_TO_POINTER(-1));
  gtk_widget_set_sensitive (lookup_widget(ChromToCalibrDialog, "ChromToCalibrOkButton"), FALSE);
  if (Chrom[WorkArea].FileLoaded[ChrFlag])
	  SetEntry (ChromToCalibrDialog, "ChromToCalibrChromEntry", Chrom[WorkArea].ChrName);
  if (Chrom[DataSource].FileLoaded[CalFlag]) {
	  SetEntry (ChromToCalibrDialog, "ChromToCalibrCalibrEntry", Chrom[DataSource].CalName);
	  for (i = 0; i < Chrom[DataSource].CalibrHead->LevelNum; i++) {
		  GetLevel (i, DataSource);
		  sprintf (RowData[0], "%d", i + 1);
		  sprintf (RowData[1], "%s", Chrom[DataSource].CalibrLevel->LevelName);
	  } // i
  } // FileLoaded[CalFlag]

  gtk_window_set_transient_for (GTK_WINDOW (ChromToCalibrDialog), GTK_WINDOW (ReprocessWindow));
  gtk_widget_show (ChromToCalibrDialog);
}


void
on_ReprocessQuitButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


void
on_ReprocessZoomInButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  if (ZoomInProgress) return;
  ZoomInit ();
  ZoomStart = TRUE;
}


void
on_ReprocessZoomOutButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  ZoomOut ();
  ReprocessDrawChrom ();
}


void
on_ReprocessZoomResetButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  ZoomReset ();
  ReprocessDrawChrom ();
}


void
on_ReprocessZoomReportButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return;

  Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepMin = Zoom->ZoomMin;
  Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepMax = Zoom->ZoomMax;
  Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepBeg = Zoom->ZoomBeg;
  Chrom[WorkArea].ChromHead->Parameter[Chrom[WorkArea].ActualDetector].RepEnd = Zoom->ZoomEnd;
  Chrom[WorkArea].FileSaved[ChrFlag] = FALSE;
}


void
on_ReprocessZoomSwitchButton_clicked   (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{
	printf ("on_ReprocessZoomSwitchButton_clicked\n");
  if (gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON(toggletoolbutton)))
	  ZoomPermanentContinue ();
  else
	  ZoomPermanentSuspend ();
}


void
on_ReprocessIntParButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *IntParWindow;
struct IntegrationParametersStruct *IntPar;

  IntPar = &Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector];
  IntParWindow = create_IntParWindow ();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "IntParWindow", IntParWindow);
  PresetIntParWidgets (IntParWindow,
								IntPar,
								gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)),
								GTK_WIDGET (toolbutton),
								IntParReprocessApplyFunction);
  SetIntParWidgets (IntParWindow);
  gtk_widget_show (IntParWindow);
}


void
on_ReprocessPeakAddButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (PeakAddInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  PeakAddInit ();
  PeakAddStart = TRUE;
}


void
on_ReprocessPeakDelButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (SelectedPeak < 0) return;
  DelPeak (SelectedPeak, WorkArea);
  SelectedPeak = -1;
  ReprocessDrawChrom ();
  RefreshReprocessAppBar ();
}


void
on_ReprocessPeakSelectButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessBLMoveButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector] < 1) return;
  if (BaselineMoveInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  BaselineMoveInit ();
  BaselineMoveStart = TRUE;
}


void
on_ReprocessBLTypeButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector] < 1) return;
  if (BaselineTypeChangeInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  BaselineTypeChangeInit ();
  BaselineTypeChangeStart = TRUE;
}


void
on_ReprocessBLTangentButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessSetEventButton_clicked     (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntPar;

  IntPar = &Chrom[WorkArea].ChromHead->Method.IntegrationParameters[Chrom[WorkArea].ActualDetector];
  if (EventAddInProgress) return;
  if (IntPar->EventNum == MaxIntegrationEventNum) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  EventAddInit ();
  EventAddStart = TRUE;
}


void
on_ReprocessRemoveEventButton_clicked  (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (EventDelInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  EventDelInit ();
  EventDelStart = TRUE;
}


void
on_ReprocessSetLockButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessRemoveLockButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessRetMoveButton_clicked      (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  if (RetMoveInProgress) return;

  if (ZoomPermanentCheck())
	  ZoomPermanentSuspend ();
  RetMoveInit ();
  RetMoveStart = TRUE;
}


gboolean
on_ReprocessQueueCList_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GdkEventButton		*eventButton;
GdkEventMotion		*eventMotion;
char *TmpStr;
int SelectedItem;

	switch (event->type) {
		case GDK_NOTHING:
			break; // GDK_NOTHING
		case GDK_MOTION_NOTIFY:
			break; // GDK_MOTION_NOTIFY
		case GDK_BUTTON_PRESS:
			eventButton = (GdkEventButton *)event;
			if (eventButton->button == 1) {
			//printf ("@ on_MainCList_event GDK_BUTTON_PRESS\n");
			} // eventButton->button == 1
			break; // GDK_BUTTON_PRESS
		case GDK_BUTTON_RELEASE:
			//printf ("@ on_MainCList_event GDK_BUTTON_RELEASE\n");
			break; // GDK_BUTTON_RELEASE
		case GDK_2BUTTON_PRESS:
			eventButton = (GdkEventButton *)event;
			if (eventButton->button == 1) {
			//printf ("@ on_MainCList_event GDK_2BUTTON_PRESS\n");
			  SelectedItem = DATA_DOWN(WIDGET_TOP(widget), "SelectedItem");
			  if (!(SelectedItem < 0)) {
				  GetQueueItem (WorkArea, SelectedItem);
				  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
				  if (ZoomPermanentCheck ())
					  ZoomPermanentSuspend ();
				  CursorLineDone ();
				  ReprocessDrawChromDone ();
				  ChromLoad (WorkArea);
				  ReprocessDrawChromInit ();
				  ReprocessDrawChrom ();
				  CursorLineInit ();
				  CursorLineDraw ();
				  if (ZoomPermanentCheck ())
					  ZoomPermanentContinue ();
				  RefreshPeakList ();
				  TmpStr = alloca (1000);
				  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
				  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
				  ActivateReprocessWidgets ();
			  } // if
			} // eventButton->button == 1
			break; // GDK_2BUTTON_PRESS - AKA Double click
		default: {
		} 
	} // switch event->type

  return FALSE;
}


void
on_ReprocessQueueFirstButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
char *TmpStr;

  if (Chrom[WorkArea].QueueHead.QueueItemNum < 1) return;
  SelectedItem = 0;
  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(toolbutton), "ReprocessQueueCList")),\
						SelectedItem, 0);
  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  if (SelectedItem < 0) return;
  GetQueueItem (WorkArea, SelectedItem);
  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();
  ChromLoad (WorkArea);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
}


void
on_ReprocessQueueBackwardButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
char *TmpStr;

  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  if (SelectedItem < 1) return;
  SelectedItem--;
  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(toolbutton), "ReprocessQueueCList")),\
						SelectedItem, 0);
  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  GetQueueItem (WorkArea, SelectedItem);
  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();
  ChromLoad (WorkArea);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
}


void
on_ReprocessQueueJumpButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
char *TmpStr;

  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  if (SelectedItem < 0) return;
  GetQueueItem (WorkArea, SelectedItem);
  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();
  ChromLoad (WorkArea);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
}


void
on_ReprocessQueueForwardButton_clicked (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
char *TmpStr;

  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  if (SelectedItem >= Chrom[WorkArea].QueueHead.QueueItemNum - 1) return;
  SelectedItem++;
  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(toolbutton), "ReprocessQueueCList")),\
						SelectedItem, 0);
  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  GetQueueItem (WorkArea, SelectedItem);
  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();
  ChromLoad (WorkArea);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
}


void
on_ReprocessQueueLastButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
char *TmpStr;

  if (Chrom[WorkArea].QueueHead.QueueItemNum < 1) return;
  SelectedItem = Chrom[WorkArea].QueueHead.QueueItemNum - 1;
  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(toolbutton), "ReprocessQueueCList")),\
						SelectedItem, 0);
  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  if (SelectedItem < 0) return;
  GetQueueItem (WorkArea, SelectedItem);
  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();
  ReprocessDrawChromDone ();
  ChromLoad (WorkArea);
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshPeakList ();
  TmpStr = alloca (1000);
  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
  ActivateReprocessWidgets ();
}


void
on_ReprocessQueueAscendButton_clicked  (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessQueueDescendButton_clicked (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessQueueRefreshButton_clicked (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  RefreshReprocessQueue (WIDGET_TOP(toolbutton));
}


void
on_ReprocessQueueCList_select_row      (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATA_UP(WIDGET_TOP(clist), "SelectedItem", row);
}


void
on_ReprocessQueueCList_unselect_row    (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATA_UP(WIDGET_TOP(clist), "SelectedItem", -1);
}


void
on_ReprocessQueueCList_click_column    (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayAddButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedItem;
int OverlayIdx;

  SelectedItem = DATA_DOWN(WIDGET_TOP(toolbutton), "SelectedItem");
  ADSI(WIDGET_TOP(toolbutton));
  if (SelectedItem < 0) {
	  OpenSaveFileSelection = create_OpenSaveFileSelection ();
	  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open overlay chromatogram");
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", OpenOverlayChromOkFunction);
	  if (strlen (LastChromDir) == 0)
		  strcpy (LastChromDir, Options[ActualDSInstrument].DefaultDataRootDir);
	  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.chr");
	  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), LastChromDir);
	  gtk_widget_show (OpenSaveFileSelection);
  } else {
	  if (ReprocessOverlayChromNum >= MaxOverlayedChrom) return;
	  GetQueueItem (WorkArea, SelectedItem);
	  strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
	  if (ZoomPermanentCheck ())
		  ZoomPermanentSuspend ();
	  CursorLineDone ();
	  ReprocessDrawChromDone ();
	  OverlayIdx = OverlayedChromBase + ReprocessOverlayChromNum;
	  GetQueueItem (WorkArea, SelectedItem);
	  strcpy (Chrom[OverlayIdx].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
	  ChromLoad (OverlayIdx);
	  if (Chrom[OverlayIdx].FileLoaded[ChrFlag]) ReprocessOverlayChromNum++;
	  ReprocessDrawChromInit ();
	  ReprocessDrawChrom ();
	  CursorLineInit ();
	  CursorLineDraw ();
	  if (ZoomPermanentCheck ())
		  ZoomPermanentContinue ();
	  RefreshOverlayList ();
	  ActivateReprocessWidgets ();
  }
}


void
on_ReprocessOverlayRemoveButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int i;

  if (ReprocessOverlayCListSelected < 0) return;
  if (ReprocessOverlayChromNum < 1) return;

  if (ZoomPermanentCheck ())
	  ZoomPermanentSuspend ();
  CursorLineDone ();

  ReprocessOverlayChromNum--;
  if (ReprocessOverlayChromNum == 0) {
	  ReprocessOverlayCListSelected = -1;
	  ReprocessOverlaySelected = -1;
  } else {
	  for (i = ReprocessOverlayCListSelected; i < ReprocessOverlayChromNum; i++) {
		  
		  strcpy (Chrom[OverlayedChromBase + i].Filename, Chrom[OverlayedChromBase + i + 1].Filename);
		  strcpy (Chrom[OverlayedChromBase + i].ChrName, Chrom[OverlayedChromBase + i + 1].ChrName);
		  ChromLoad (OverlayedChromBase + i);
	  } // i
  }
  ReprocessDrawChrom ();
  CursorLineInit ();
  CursorLineDraw ();
  if (ZoomPermanentCheck ())
	  ZoomPermanentContinue ();
  RefreshOverlayList ();
  ActivateReprocessWidgets ();
  gtk_window_present (GTK_WINDOW (ReprocessWindow));
}


void
on_ReprocessOverlaySelectButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (ReprocessOverlayCListSelected < 0) return;
  ReprocessOverlaySelected = ReprocessOverlayCListSelected;
  ActivateReprocessWidgets ();
}


void
on_ReprocessOverlayColorButton_clicked (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (ReprocessOverlayCListSelected < 0) return;

  ColorSelectionDialog = create_ColorSelectionDialog ();
  gtk_window_set_title (GTK_WINDOW (ColorSelectionDialog), "Select overlay color");
  gtk_object_set_data (GTK_OBJECT (ColorSelectionDialog), "ApplyFunction", OverlayColorOkFunction);
  gtk_object_set_data (GTK_OBJECT (ColorSelectionDialog), "ReprocessOverlayCListSelected", GINT_TO_POINTER(ReprocessOverlayCListSelected));
  gtk_color_selection_set_current_color (GTK_COLOR_SELECTION(lookup_widget(ColorSelectionDialog, "ColorSelection")), &OverlayColor[ReprocessOverlayCListSelected]);
  gtk_widget_show (ColorSelectionDialog);
}


void
on_ReprocessOverlayZoomToFitToggleButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayHideToggleButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayFunctionsToggleButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayEnableToggleButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayCList_select_row    (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  ReprocessOverlayCListSelected = row;
  ActivateReprocessWidgets ();
}


void
on_ReprocessOverlayCList_unselect_row  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  ReprocessOverlayCListSelected = -1;
  ActivateReprocessWidgets ();
}


void
on_ReprocessOverlayCList_click_column  (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlay1DRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlay2DRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlay3DRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayPlusRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayMinusRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayMultiplyRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayDivideRadioButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayRevertOperandToggleButton_toggled
                                        (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayShiftSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  if (ReprocessOverlayCListSelected < 0) return;
  ReprocessOverlayShift[ReprocessOverlayCListSelected] = gtk_spin_button_get_value (spinbutton);
  ReprocessDrawChrom ();
}


void
on_ReprocessOverlayShiftSpinButton_change_value
                                        (GtkSpinButton   *spinbutton,
                                        GtkScrollType    scroll,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayShiftSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayMagnifySpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  if (ReprocessOverlayCListSelected < 0) return;
  ReprocessOverlayZoom[ReprocessOverlayCListSelected] = gtk_spin_button_get_value (spinbutton);
  ReprocessDrawChrom ();
}


void
on_ReprocessOverlayMagnifySpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayMagnifySpinButton_change_value
                                        (GtkSpinButton   *spinbutton,
                                        GtkScrollType    scroll,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayEstimateMagnifyButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_ReprocessOverlayEstimateShiftButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
double EstShift;

  if (ReprocessOverlayCListSelected < 0) return;
  EstShift = ChromData (CRTP(StoreCursorRetention, WorkArea), WorkArea) - \
			 ChromData (CRTP(StoreCursorRetention, OverlayedChromBase + ReprocessOverlayCListSelected),\
						OverlayedChromBase + ReprocessOverlayCListSelected);
  SetSpinButtonValue (WIDGET_TOP(button), "ReprocessOverlayShiftSpinButton", EstShift);
  ReprocessOverlayShift[ReprocessOverlayCListSelected] = EstShift;
  ReprocessDrawChrom ();
}


gboolean
on_ReprocessDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  ReprocessDrawingAreaWidth = event->width;
  ReprocessDrawingAreaHeight = event->height;

  return FALSE;
}


gboolean
on_ReprocessDrawingArea_expose_event   (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
	CursorLineDone ();
	ReprocessDrawChrom();
	CursorLineInit ();
	CursorLineDraw ();
	return FALSE;
}


gboolean
on_ReprocessDrawingArea_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GdkEventButton		*eventButton;
GdkEventMotion		*eventMotion;

  if (!Chrom[WorkArea].FileLoaded[ChrFlag]) return FALSE;

  switch (event->type) {
	case GDK_NOTHING:
		break; // GDK_NOTHING
	case GDK_MOTION_NOTIFY:
		eventMotion = (GdkEventMotion *)event;
		DrawCursorX = (int)(eventMotion->x);
		DrawCursorY = (int)(eventMotion->y);
		CalculateRetentionFromCursor (DrawCursorX, DrawCursorY);
		RefreshReprocessAppBar ();
		if (ZoomInProgress == TRUE) {
			ZoomRectangleDraw ();
			} // ZoomInProgress
		if (PeakAddInProgress == TRUE) {
			PeakAddLineDraw ();
			} // PeakAddInProgress
		if (BaselineMoveInProgress == TRUE) {
			BaselineMoveLineDraw ();
			} // BaselineMoveInProgress
		break; // GDK_MOTION_NOTIFY
	case GDK_BUTTON_PRESS:
		StoreTickedCursorValues ();
		SelectedPeak = CursorPeak;
		RefreshReprocessAppBar ();
		RefreshPeakInfo ();
		eventButton = (GdkEventButton *)event;
		if (eventButton->button == 1) {
			DrawCursorX0 = (int)(eventButton->x);
			DrawCursorY0 = (int)(eventButton->y);
			if (ZoomStart == TRUE) {
				ZoomStart = FALSE;
				ZoomInProgress = TRUE;
				CursorLineDone ();
				ZoomRectangleInit ();
			} // ZoomStart
			else
			if (PeakAddStart == TRUE) {
				PeakAddStart = FALSE;
				PeakAddInProgress = TRUE;
				CursorLineDone ();
				PeakAddLineInit ();
			} // PeakAddStart
			else
			if (BaselineMoveStart == TRUE) {
				BaselineMoveStart = FALSE;
				BaselineMoveInProgress = TRUE;
				CursorLineDone ();
				BaselineMoveLineInit ();
			} // BaselineMoveStart
			else
			if (BaselineTypeChangeStart == TRUE) {
				BaselineTypeChangeStart = FALSE;
				BaselineTypeChangeInProgress = TRUE;
				CursorLineDone ();
				//BaselineMoveLineInit ();
				gtk_menu_popup (GTK_MENU(BLPopupMenu), NULL, NULL, NULL, NULL, eventButton->button, eventButton->time);
				DATASOURCE_UP(MENU_TOP(BLPopupMenu),WorkArea);
			} // BaselineMoveStart
			else
			if (RetMoveStart == TRUE) {
				RetMoveStart = FALSE;
				RetMoveInProgress = TRUE;
				CursorLineDone ();
			} // RetMoveStart
			else
			if (EventAddStart == TRUE) {
				EventAddStart = FALSE;
				EventAddInProgress = TRUE;
				CursorLineDone ();
			} // EventAddStart
			else
			if (EventDelStart == TRUE) {
				EventDelStart = FALSE;
				EventDelInProgress = TRUE;
				CursorLineDone ();
			} // EventDelStart
			else
			{
			CursorLineDraw ();
			} // else
		} // eventButton->button == 1
		break; // GDK_BUTTON_PRESS
	case GDK_BUTTON_RELEASE:
		eventButton = (GdkEventButton *)event;
		if (eventButton->button == 1) {
			if (ZoomInProgress == TRUE) {
				ZoomInProgress = FALSE;
				ZoomDone ();
				CursorLineInit ();
			} // ZoomInProgress
			if (PeakAddInProgress == TRUE) {
				PeakAddInProgress = FALSE;
				PeakAddDone ();
				CursorLineInit ();
			} // PeakAddInProgress
			if (BaselineMoveInProgress == TRUE) {
				BaselineMoveInProgress = FALSE;
				BaselineMoveDone ();
				CursorLineInit ();
			} // BaselineMoveInProgress
			if (BaselineTypeChangeInProgress == TRUE) {
				BaselineTypeChangeInProgress = FALSE;
				printf ("BaselineTypeChangeInProgress = FALSE\n");
				BaselineTypeChangeDone ();
				CursorLineInit ();
			} // BaselineTypeChangeInProgress
			if (RetMoveInProgress == TRUE) {
				RetMoveInProgress = FALSE;
				RetMoveDone ();
				CursorLineInit ();
			} // RetMoveInProgress
			if (EventAddInProgress == TRUE) {
				EventAddInProgress = FALSE;
				EventAddDone ();
				CursorLineInit ();
			} // EventAddInProgress
			if (EventDelInProgress == TRUE) {
				EventDelInProgress = FALSE;
				EventDelDone ();
				CursorLineInit ();
			} // EventDelInProgress
		} // eventButton->button == 1
		else if (eventButton->button == 2) {
		} // eventButton->button == 2
		else if (eventButton->button == 3) {
			CursorLineOff ();
			gtk_menu_popup (GTK_MENU(PopupMenu), NULL, NULL, NULL, NULL, eventButton->button, eventButton->time);
			DATASOURCE_UP(MENU_TOP(PopupMenu), WorkArea);
		} // eventButton->button == 3
		break; // GDK_BUTTON_RELEASE
	case GDK_2BUTTON_PRESS:
		eventButton = (GdkEventButton *)event;
		if (eventButton->button == 1) {
			CursorLineDraw ();
			/*
			if (!Opened (PeakInfoApp)) {
				SelectedPeak = CursorPeak;
				PeakInfoApp = create_PeakInfoApp ();
				RefreshPeakInfo ();
				gtk_widget_show (PeakInfoApp);
			} // !Opened (PeakInfoApp)
			else {
				SelectedPeak = CursorPeak;
				RefreshPeakInfo ();
			} // !Opened (PeakInfoApp)
			*/
		} // eventButton->button == 1
		break; // GDK_2BUTTON_PRESS - AKA Double click
	default: {
	} 
  } // switch event->type

  return FALSE;
}


void
on_ReprocessDrawingArea_hide           (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_ReprocessDrawingArea_show           (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

// ImportDialog callback functions


void
on_ImportDialogFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_ImportDialogComboEntry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportChannels = GetSpinButtonInt (gtk_widget_get_toplevel (GTK_WIDGET(editable)), "ImportDialogChannelsSpinButton");
  ImportChannelsOf = GetSpinButtonInt (gtk_widget_get_toplevel (GTK_WIDGET(editable)), "ImportDialogChannelsOfSpinButton");

  ChromImport (gtk_widget_get_toplevel (GTK_WIDGET(editable)), gtk_entry_get_text (GTK_ENTRY (editable)));

  ActivateWidget (ImportDialog, "ImportDialogOkButton", Chrom[WorkArea].FileLoaded[ImpFlag]);
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(editable)));
}


void
on_ImportResolution1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportResolutionUser = GetSpinButtonInt (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)), "ImportDialogResolutionSpinButton");
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportResolution16bit_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportResolutionUser = GetSpinButtonInt (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)), "ImportDialogResolutionSpinButton");
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportResolution24bit_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportResolutionUser = GetSpinButtonInt (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)), "ImportDialogResolutionSpinButton");
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportResolutionUser_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SetSpinButtonValue (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)), "ImportDialogResolutionSpinButton", ImportResolutionUser);
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportXmin_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportXsec_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportXmm_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ImportRedraw (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_ImportDialogXAxisSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(editable)));
}


void
on_ImportDialogXAxisSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(spinbutton)));
}

void
on_ImportDialogDecimationSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(editable)));
}


void
on_ImportDialogDecimationSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(spinbutton)));
}


void
on_ImportDialogRevertCheckBox_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(togglebutton)));
}


void
on_ImportDialogScaleSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(editable)));
}


void
on_ImportDialogScaleSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(spinbutton)));
}


void
on_ImportDialogScaleEntry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(editable)));
}


void
on_ImportDialogResolutionSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(editable)));
}


gboolean
on_ImportDialogDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(widget))), "ImportDrawingAreaWidth", GINT_TO_POINTER (event->width));
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(widget))), "ImportDrawingAreaHeight", GINT_TO_POINTER (event->height));

  return FALSE;
}


gboolean
on_ImportDialogDrawingArea_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_ImportDialogDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  ImportRedraw (gtk_widget_get_toplevel (GTK_WIDGET(widget)));

  return FALSE;
}


void
on_ImportDialog_close                  (GtkDialog       *dialog,
                                        gpointer         user_data)
{

}


void
on_ImportDialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
gpointer *ImportData;
gpointer *ImportSizedData;

  free (ImportFileName);

  ImportData = gtk_object_get_data (object, "DataPointer");
  free (ImportData);
  ImportSizedData = gtk_object_get_data (object, "DataSizedPointer");
  free (ImportSizedData);
}


void
on_ImportDialogHelpButton_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_ImportDialogCancelButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_ImportDialogOkButton_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  ReprocessDrawChromDone ();
  ConvertImportRawDataToChrom (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ReprocessDrawChromInit ();
  ReprocessDrawChrom ();
  gtk_window_present (GTK_WINDOW (ReprocessWindow));
}


void
on_ImportDialogSaveDefaultsNowButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  GetImportWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ImportConfigSave (ActualInstrument);
}
