// Sample queue window callback functions

void
on_SampleQueueWindow_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *OpenedWindow;
GtkWidget *CallerButton;
DestroyFunctionType *DestroyFunction;

  gtk_object_set_data (GTK_OBJECT(gtk_object_get_data (object, "CallerWidget")), "SampleQueueWindow", NULL);

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenSaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);

  DestroyFunction = gtk_object_get_data (object, "DestroyFunction");
  if (DestroyFunction != NULL)
	  DestroyFunction (object);

}


void
on_SampleQueueNew_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));

  NewSampleQueue (DataSource);
  SetSampleQueueWidgets (MENU_TOP(menuitem));
  SetQueueItemWidgets (MENU_TOP(menuitem));
  RefreshQueueList (MENU_TOP(menuitem));
}


void
on_SampleQueueOpen_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueSave_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueSaveAs_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueQuit_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_destroy (MENU_TOP(menuitem));
}


void
on_SampleQueueCut_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueCopy_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueuePaste_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueClear_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueProperties_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueuePreferences_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueAbout_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_SampleQueueNewButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));

  NewSampleQueue (DataSource);
  SetSampleQueueWidgets (WIDGET_TOP(toolbutton));
  SetQueueItemWidgets (WIDGET_TOP(toolbutton));
  RefreshQueueList (WIDGET_TOP(toolbutton));
}


void
on_SampleQueueOpenButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));

  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open sample queue");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SampleQueueOpenOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", GTK_WIDGET(toolbutton));
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(DataSource));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.que");
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Options[DataSource].MethodDir);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_SampleQueueSaveButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));

  GetSampleQueueWidgets (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  Chrom[DataSource].FileLoaded[LayFlag] = TRUE;
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Save sample queue");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SampleQueueSaveOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerButton", GTK_WIDGET(toolbutton));
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(DataSource));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.que");
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Chrom[DataSource].LayerQueueName);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_SampleQueuePrintButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));
  ADSI(WIDGET_TOP(toolbutton));

  PrintFunction (PrintSampleQueueMode, GINT_TO_POINTER(DataSource), GINT_TO_POINTER(ActualDSInstrument), TRUE);
}


void
on_SampleQueueExitButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_destroy (WIDGET_TOP(toolbutton));
}


void
on_SampleQueueFileNameEntry_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  printf ("on_SampleQueueFileNameEntry_changed\n");
}


void
on_SampleQueueFileNameEntry_editing_done
                                        (GtkCellEditable *celleditable,
                                        gpointer         user_data)
{
  printf ("on_SampleQueueFileNameEntry_editing_done\n");
}


void
on_SampleQueueFileNameEntry_activate   (GtkEntry        *entry,
                                        gpointer         user_data)
{
  printf ("on_SampleQueueFileNameEntry_activate\n");
}


void
on_SampleQueueDataDirFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueDataDirComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_SampleQueueCommonMethodFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueCommonMethodComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_SampleQueueEditMethodButton_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *MethodWindow;

  DATASOURCE(WIDGET_TOP(button));
  ADSI(WIDGET_TOP(button));
  MethodWindow = create_MethodWindow ();
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(button)), "MethodWindow", MethodWindow);
  DATASOURCE_UP (MethodWindow, DataSource);
  strcpy (Chrom[DataSource].MetName, "");
  ADSI_UP(MethodWindow, ActualDSInstrument);
  PresetMethodWidgets (MethodWindow,
								&Chrom[DataSource].QueueHead.LQMethod,
								gtk_widget_get_toplevel (GTK_WIDGET (button)),
								GTK_WIDGET (button),
								MethodInQueueOkFunction);
  ActivateWidget (MethodWindow, "MethodNewButton", FALSE);
  ActivateWidget (MethodWindow, "MethodOpenButton", FALSE);
  ActivateWidget (MethodWindow, "MethodSaveButton", FALSE);
  ActivateWidget (MethodWindow, "MethodPrintButton", FALSE);
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "IntParChan", GINT_TO_POINTER(0));
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "Report", &Chrom[DataSource].QueueHead.LQMethod.Report);

  SetMethodWidgets (MethodWindow);
  gtk_widget_show (MethodWindow);
}


void
on_SampleQueueCalibrationFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueCalibrationComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_SampleQueueGCHPLCGenerateButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int i, NumberOfChrom, StartExt;
GtkWidget *MainQueueWidget;
GtkWidget *MeasureGCTLCNotebook;

  DATASOURCE(WIDGET_TOP(button));
  MainQueueWidget = gtk_widget_get_toplevel (GTK_WIDGET(button));

  NumberOfChrom = GetSpinButtonInt (MainQueueWidget, "SampleQueueGCHPLCNumChromSpinButton");
  StartExt = GetSpinButtonInt (MainQueueWidget, "SampleQueueGCHPLCStartExtensionSpinButton");

  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));

  if (!GetCheckBox (MainQueueWidget, "SampleQueueGCHPLCAppendCheckBox"))
	  Chrom[DataSource].QueueHead.QueueItemNum = 0;

  Chrom[DataSource].QueueItem.SamplerPosition = GetSpinButtonInt (MainQueueWidget, "SampleQueueGCHPLCSamplerPositionSpinButton");
  Chrom[DataSource].QueueItem.MeasureTime = GetSpinButtonFloat (MainQueueWidget, "SampleQueueGCHPLCMeasureTimeSpinButton");
  strcpy (Chrom[DataSource].QueueItem.BaseFileName, GetEntry (MainQueueWidget, "SampleQueueFileNameEntry"));
  if (strlen(Chrom[DataSource].QueueItem.BaseFileName) < 1) {
	  on_SampleQueueGenerateNameButton_clicked (GTK_BUTTON(lookup_widget (MainQueueWidget, "SampleQueueGenerateNameButton")), NULL);
	  strcpy (Chrom[DataSource].QueueItem.BaseFileName, GetEntry (MainQueueWidget, "SampleQueueFileNameEntry"));
  }
  Chrom[DataSource].QueueItem.ExtIdx = StartExt;
  strcpy (Chrom[DataSource].QueueItem.Comment, GetEntry (MainQueueWidget, "SampleQueueCommentEntry"));
  strcpy (Chrom[DataSource].QueueItem.Id, GetEntry (MainQueueWidget, "SampleQueueIDEntry"));
  
  Chrom[DataSource].QueueItem.SampleType = SampleTypeSample;
  if (Chrom[DataSource].QueueItem.SampleType < 0)
	  Chrom[DataSource].QueueItem.SampleType = 0;
  Chrom[DataSource].QueueItem.StandardAutoCalibrate = GetCheckBox (MainQueueWidget, "SampleQueueSampleTypeAutoCalibrCheckButton");
  Chrom[DataSource].QueueItem.StandardLevel = GetSpinButtonInt (MainQueueWidget, "SampleQueueSampleTypeLevelSpinButton");
  Chrom[DataSource].QueueItem.StandardMode = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MainQueueWidget, "SampleQueueSampleTypeLevelModeComboBox")));
  if (Chrom[DataSource].QueueItem.StandardMode < 0)
	  Chrom[DataSource].QueueItem.StandardMode = 0;
  
  Chrom[DataSource].QueueItem.Volume = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiVolumeSpinButton");
  Chrom[DataSource].QueueItem.Amount = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiAmountSpinButton");
  Chrom[DataSource].QueueItem.Factor = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiFactorSpinButton");
  Chrom[DataSource].QueueItem.Pressure = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiPressureSpinButton");
  Chrom[DataSource].QueueItem.Temperature = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiTemperSpinButton");
  Chrom[DataSource].QueueItem.ScaleFactor = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiScaleFactorSpinButton");
  Chrom[DataSource].QueueItem.InjectedVolume = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiInjVolSpinButton");
  Chrom[DataSource].QueueItem.IstConc = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiISTConcSpinButton");

  Chrom[DataSource].QueueItem.ManualStepForward = GetCheckBox (MainQueueWidget, "SampleQueueGCHPLCManualForwardDefaultCheckButton");

  for (i = 0; i < NumberOfChrom; i++) {
	  sprintf (Chrom[DataSource].QueueItem.BaseExtName, "%.3d", Chrom[DataSource].QueueItem.ExtIdx);
	  strcpy (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseFileName);
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".");
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseExtName);
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".chr");
	  AddQueueItem (DataSource, -1);
	  Chrom[DataSource].QueueItem.ExtIdx++;
	  Chrom[DataSource].QueueItem.SamplerPosition++;
  } // i
  RefreshQueueList (MainQueueWidget);
  MeasureGCTLCNotebook = lookup_widget (MainQueueWidget, "SampleQueueNoteBook");
  gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 1);
  ActivateQueueListWidgets (MainQueueWidget);
}


void
on_SampleQueueLayerGenerateButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *MainQueueWidget;
int i, NumberOfTracks;
double StartPos, DiffPos;
GtkWidget *MeasureGCTLCNotebook;

  DATASOURCE(WIDGET_TOP(button));
  MainQueueWidget = gtk_widget_get_toplevel (GTK_WIDGET(button));

  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));

  NumberOfTracks = GetSpinButtonInt (MainQueueWidget, "SampleQueueLayerNumTracksSpinButton");
  StartPos = GetSpinButtonFloat (MainQueueWidget, "SampleQueueLayerStartPointSpinButton");
  DiffPos = GetSpinButtonFloat (MainQueueWidget, "SampleQueueLayerDifferenceSpinButton");

  Chrom[DataSource].QueueHead.QueueItemNum = 0;

  Chrom[DataSource].QueueHead.NumberOfTracks = NumberOfTracks;
//  Chrom[DataSource].QueueItem. = GetSpinButtonFloat (MainQueueWidget, "");
//  Chrom[DataSource].QueueItem. = GetSpinButtonFloat (MainQueueWidget, "");
//  Chrom[DataSource].QueueItem. = GetSpinButtonFloat (MainQueueWidget, "");
  strcpy (Chrom[DataSource].QueueItem.BaseFileName, GetEntry (MainQueueWidget, "SampleQueueFileNameEntry"));
  Chrom[DataSource].QueueItem.ExtIdx = 1;
  strcpy (Chrom[DataSource].QueueItem.Comment, GetEntry (MainQueueWidget, "SampleQueueCommentEntry"));
  strcpy (Chrom[DataSource].QueueItem.Id, GetEntry (MainQueueWidget, "SampleQueueIDEntry"));
  
  Chrom[DataSource].QueueItem.SampleType = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MainQueueWidget, "SampleQueueSampleTypeComboBox")));
  if (Chrom[DataSource].QueueItem.SampleType < 0)
	  Chrom[DataSource].QueueItem.SampleType = 0;
  Chrom[DataSource].QueueItem.StandardAutoCalibrate = GetCheckBox (MainQueueWidget, "SampleQueueSampleTypeAutoCalibrCheckButton");
  Chrom[DataSource].QueueItem.StandardLevel = GetSpinButtonInt (MainQueueWidget, "SampleQueueSampleTypeLevelSpinButton");
  Chrom[DataSource].QueueItem.StandardMode = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (MainQueueWidget, "SampleQueueSampleTypeLevelModeComboBox")));
  if (Chrom[DataSource].QueueItem.StandardMode < 0)
	  Chrom[DataSource].QueueItem.StandardMode = 0;
  
  Chrom[DataSource].QueueItem.Volume = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiVolumeSpinButton");
  Chrom[DataSource].QueueItem.Amount = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiAmountSpinButton");
  Chrom[DataSource].QueueItem.Factor = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiFactorSpinButton");
  Chrom[DataSource].QueueItem.Pressure = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiPressureSpinButton");
  Chrom[DataSource].QueueItem.Temperature = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiTemperSpinButton");
  Chrom[DataSource].QueueItem.ScaleFactor = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiScaleFactorSpinButton");
  Chrom[DataSource].QueueItem.InjectedVolume = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiInjVolSpinButton");
  Chrom[DataSource].QueueItem.IstConc = GetSpinButtonFloat (MainQueueWidget, "SampleQueueQuantiISTConcSpinButton");

  Chrom[DataSource].QueueItem.TrackPosition = StartPos;
  for (i = 0; i < NumberOfTracks; i++) {
	  sprintf (Chrom[DataSource].QueueItem.BaseExtName, "%.3d", Chrom[DataSource].QueueItem.ExtIdx);
	  strcpy (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseFileName);
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".");
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, Chrom[DataSource].QueueItem.BaseExtName);
	  strcat (Chrom[DataSource].QueueItem.FinalFilename, ".chr");
	  AddQueueItem (DataSource, -1);
	  Chrom[DataSource].QueueItem.ExtIdx++;
	  Chrom[DataSource].QueueItem.TrackPosition += DiffPos;
  } // i
  RefreshQueueList (MainQueueWidget);
  MeasureGCTLCNotebook = lookup_widget (MainQueueWidget, "SampleQueueNoteBook");
  gtk_notebook_set_current_page (GTK_NOTEBOOK (MeasureGCTLCNotebook), 1);
  ActivateQueueListWidgets (MainQueueWidget);
}


void
on_SampleQueueGenerateNameButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *MainQueueWidget;
struct tm *ConvLocalTime;
time_t LocalTime;
char *TimedName;

  DATASOURCE(WIDGET_TOP(button));

  ConvLocalTime = alloca (sizeof(struct tm));
  TimedName = alloca (1000);

  MainQueueWidget = gtk_widget_get_toplevel (GTK_WIDGET(button));

  LocalTime = time (NULL);
  localtime_r (&LocalTime, ConvLocalTime);
  sprintf (TimedName, "%d_%.2d_%.2d", ConvLocalTime->tm_year + 1900, ConvLocalTime->tm_mon + 1, ConvLocalTime->tm_mday);
  SetEntry (MainQueueWidget, "SampleQueueFileNameEntry", TimedName);

}


void
on_SampleQueueAddButton_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(button));
  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));

  GetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));

  AddQueueItem (DataSource, -1);
  Chrom[DataSource].QueueHead.NumberOfTracks = Chrom[DataSource].QueueHead.NumberOfChroms;

  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem", GINT_TO_POINTER(-1));
  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueRemoveButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(button));
  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem"));
  if (QueIdx == -1) return;

  DelQueueItem (DataSource, QueIdx);
  Chrom[DataSource].QueueHead.NumberOfTracks = Chrom[DataSource].QueueHead.NumberOfChroms;

  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem", GINT_TO_POINTER(-1));
  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueModifyButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(button));

  GetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));

  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem"));
  if (QueIdx < 0) return;
  SetQueueItem (DataSource, QueIdx);
  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueInsertButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(button));
  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));

  GetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));

  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem"));
  if (QueIdx < 0) return;
  AddQueueItem (DataSource, QueIdx);
  Chrom[DataSource].QueueHead.NumberOfTracks = Chrom[DataSource].QueueHead.NumberOfChroms;

  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem", GINT_TO_POINTER(-1));
  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueDefaultButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
//  bzero (&Chrom[DataSource].QueueItem, sizeof(struct QueueItemStruct));

}


void
on_SampleQueueUpButton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(button));
  GetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));

  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem"));
  if (QueIdx < 0) return;
  UpQueueItem (DataSource, QueIdx);

  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueDownButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(button));
  GetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));

  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "SelectedItem"));
  if (QueIdx < 0) return;
  DownQueueItem (DataSource, QueIdx);

  RefreshQueueList (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueCList_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));

  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(clist))), "SelectedItem", GINT_TO_POINTER(row));
  GetQueueItem (DataSource, row);
  SetQueueItemWidgets (gtk_widget_get_toplevel (GTK_WIDGET(clist)));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(clist)));
}


void
on_SampleQueueCList_unselect_row       (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(clist))), "SelectedItem", GINT_TO_POINTER(-1));
  ActivateQueueListWidgets (gtk_widget_get_toplevel (GTK_WIDGET(clist)));
}


void
on_SampleQueueIDEntry_activate         (GtkEntry        *entry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueCommentEntry_activate    (GtkEntry        *entry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueNameEntry_activate       (GtkEntry        *entry,
                                        gpointer         user_data)
{
int QueIdx;

  DATASOURCE(WIDGET_TOP(entry));

  GetQueueItemWidgets (WIDGET_TOP(entry));

  QueIdx = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(entry)), "SelectedItem"));
  if (QueIdx < 0) return;
  SetQueueItem (DataSource, QueIdx);
  RefreshQueueList (WIDGET_TOP(entry));
  gtk_clist_select_row (GTK_CLIST(lookup_widget(WIDGET_TOP(entry), "SampleQueueCList")), QueIdx, 0);
}


void
on_SampleQueueExtEntry_activate        (GtkEntry        *entry,
                                        gpointer         user_data)
{

}


void
on_SampleQueueOkButton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (gtk_widget_get_toplevel (GTK_WIDGET(button)));
//  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueCancelButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_SampleQueueHelpButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{

}

//***
//*** Select queue item dialog
//***

void
on_SelectQueueItemDialog_destroy       (GtkObject       *object,
                                        gpointer         user_data)
{
DestroyFunctionType *DestroyFunction;

  DestroyFunction = gtk_object_get_data (object, "DestroyFunction");

  if (DestroyFunction != NULL)
	  DestroyFunction (object);
}


void
on_SelectQueueItemDialogHelpButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
}


void
on_SelectQueueItemDialogCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (WIDGET_TOP(button));
}


void
on_SelectQueueItemDialogOkButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (WIDGET_TOP(button));

  gtk_widget_destroy (WIDGET_TOP(button));
}


gboolean
on_SelectQueueItemTreeView_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  //printf ("on_SelectQueueItemTreeView_event\n");
  return FALSE;
}


void
on_SelectQueueItemTreeView_row_activated
                                        (GtkTreeView     *treeview,
                                        GtkTreePath     *path,
                                        GtkTreeViewColumn *column,
                                        gpointer         user_data)
{
  printf ("on_SelectQueueItemTreeView_row_activated\n");
}


gboolean
on_SelectQueueItemTreeView_select_cursor_row
                                        (GtkTreeView     *treeview,
                                        gboolean         start_editing,
                                        gpointer         user_data)
{
  printf ("on_SelectQueueItemTreeView_select_cursor_row\n");
  return FALSE;
}
