// Peak list, info, delete window callback functions

void
on_PeakListWindow_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{

}


gboolean
on_PeakListWindow_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide (widget);
  return TRUE;
}


void
on_PeakListCopyButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakListSaveButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakListPrintButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakListSelectButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakListDeleteButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (SelectedPeak == -1) return;
  DelPeak (SelectedPeak, WorkArea);
  RefreshPeakList ();
  ReprocessDrawChrom ();
  //RefreskPeakInfo
  SelectedPeak = -1;
  RefreshReprocessAppBar ();
}


void
on_PeakListInfoButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (SelectedPeak == -1) return;
  gtk_window_present (GTK_WINDOW (PeakInfoWindow));
  RefreshPeakInfo ();
}


void
on_PeakListExitButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


void
on_PeakListCList_select_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  SelectedPeak = row;
  RefreshPeakInfo ();
  RefreshReprocessAppBar ();
}


void
on_PeakListCList_unselect_row          (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
//  CursorLineDone ();
  SelectedPeak = -1;
//  CursorLineInit ();
//  CursorLineDraw ();
  RefreshReprocessAppBar ();
}

// ***
// Peak Info
// ***

void
on_PeakInfoWindow_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{

}


gboolean
on_PeakInfoWindow_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide (widget);
  return TRUE;
}


void
on_PeakInfoCopyButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakInfoSaveButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakInfoPrintButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(ReprocessWindow);
  PrintFunction (PrintPeakDataMode, GINT_TO_POINTER(SelectedPeak), GINT_TO_POINTER(ActualDSInstrument), TRUE);
}


void
on_PeakInfoSelectButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_PeakInfoDeleteButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DelPeak (SelectedPeak, WorkArea);
  if (SelectedPeak >= Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector])
	  SelectedPeak = Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector] - 1;
  RefreshPeakList ();
  RefreshPeakInfo ();
  ReprocessDrawChrom ();
}


void
on_PeakInfoExitButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


gboolean
on_PeakInfoDrawingArea_configure_event (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  PeakInfoDrawingAreaHeight = event->height;
  PeakInfoDrawingAreaWidth = event->width;
  return FALSE;
}


gboolean
on_PeakInfoDrawingArea_expose_event    (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_PeakInfoDrawingArea_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_PeakInfoFirstButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  SelectedPeak = 0;
  RefreshPeakInfo ();
}


void
on_PeakInfoBackButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (SelectedPeak > 0)
	  SelectedPeak--;
  RefreshPeakInfo ();
}


void
on_PeakInfoForwardButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (SelectedPeak < Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector] - 1)
	  SelectedPeak++;
  RefreshPeakInfo ();
}


void
on_PeakInfoLastButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  SelectedPeak = Chrom[WorkArea].ChromHead->PeakHead.PeakNum[Chrom[WorkArea].ActualDetector];
  RefreshPeakInfo ();
}


void
on_PeakDeleteWindow_destroy            (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_PeakDeleteYesButton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_PeakDeleteNoButton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{

}
