// Measure callbacks function

void
on_MeasureWindow_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{

}


gboolean
on_MeasureWindow_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide (widget);
  gtk_widget_hide (MeasureADTraceWindow);
  return TRUE;
}


gboolean
on_MeasureWindow_destroy_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureWindow_hide                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_timeout_remove (oneSecondTagMeasure);
}


void
on_MeasureWindow_show                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
  oneSecondTagMeasure = gtk_timeout_add(1000, (GtkFunction)oneSecondCallBackMeasure, NULL);
}


void
on_MeasureNew_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureOpen_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureSave_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureSaveAs_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureImportTR540RAW_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ADSI(MENU_TOP(menuitem));
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
	  OpenSaveFileSelection = create_OpenSaveFileSelection ();
	  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open layer");
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", TR541MeasureImportTR540RAWOkFunction);
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "Channel", GINT_TO_POINTER(ActualDSInstrument));
	  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWindow", MENU_TOP(menuitem));
	  gtk_widget_show (OpenSaveFileSelection);
	  break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
}


void
on_MeasureQuit_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(menuitem)));
}


void
on_MeasureCut_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureCopy_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasurePaste_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureClear_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureProperties_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasurePreferences_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureAbout_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (MeasureWindow));
  gtk_widget_show (About);
}


void
on_MeasureNewButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

  DATASOURCE (WIDGET_TOP(toolbutton));
  ADSI (WIDGET_TOP(toolbutton));

  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		  ActivateWidget (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)), "MeasureNewButton", FALSE);
		  ActivateWidget (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)), "MeasureOpenButton", FALSE);
		  NewSampleQueue (ActualDSInstrument);
		  SampleQueueWindow = create_SampleQueueWindow ();
		  gtk_window_set_title (GTK_WINDOW (SampleQueueWindow), "New sample queue");
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "ActualDSInstrument", GINT_TO_POINTER(ActualDSInstrument));
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "CallerWindow", gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)));
		  DATASOURCE_UP(SampleQueueWindow, ActualDSInstrument);
		  ADSI_UP(SampleQueueWindow, ActualDSInstrument);
		  PresetSampleQueueWidgets (SampleQueueWindow,
									LC2.Instruments[ActualInstrument].InstrumentType,
									gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)),
									GTK_WIDGET(toolbutton),
//									WorkstationMeasureNewOkFunction,
									GenericDataAcqStartQueueOkFunction, NULL);
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "SelectedItem", GINT_TO_POINTER(-1));
		  SetSampleQueueWidgets (SampleQueueWindow);
		  RefreshQueueList (SampleQueueWindow);
		  on_SampleQueueGenerateNameButton_clicked (GTK_BUTTON(lookup_widget(SampleQueueWindow, "SampleQueueGenerateNameButton")), NULL);
		  if (Chrom[ActualDSInstrument].QueueHead.QueueItemNum < 1)
			  ActivateWidget (SampleQueueWindow, "SampleQueueOkButton", FALSE);
		  gtk_widget_show (SampleQueueWindow);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "TR541SelectedTrack", GINT_TO_POINTER(1));
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusIdle));
	  SetSpinButtonValue (WIDGET_TOP(toolbutton), "MeasureTR541SelectedTrackSpinButton", 1);
	  strcpy (Chrom[ActualDSInstrument].LayerQueueName, Options[ActualDSInstrument].QueueName);
	  QueueLoad (ActualDSInstrument);
	  if (Chrom[ActualDSInstrument].FileLoaded[LayFlag]) {
		  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = \
			  MethodLoad (&Chrom[ActualDSInstrument].QueueHead.LQMethod, \
						  Chrom[ActualDSInstrument].QueueHead.MethodName);
	  } else {
		  NewSampleQueue (ActualDSInstrument);
		  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = FALSE;
	  } // if LayFlag
	  if (!Chrom[ActualDSInstrument].FileLoaded[MetFlag]) {
		  Chrom[ActualDSInstrument].FileLoaded[MetFlag] = \
			  MethodLoad (&Chrom[ActualDSInstrument].QueueHead.LQMethod, \
						  Options[ActualDSInstrument].MeasureMethod);
		  strcpy (Chrom[ActualDSInstrument].QueueHead.MethodName, Options[ActualDSInstrument].MeasureMethod);
	  } // if !MetFlag
	  if (Chrom[ActualDSInstrument].FileLoaded[MetFlag]) {
		  SampleQueueWindow = create_SampleQueueWindow ();
		  gtk_window_set_title (GTK_WINDOW (SampleQueueWindow), "New layer");
		  DATASOURCE_UP(SampleQueueWindow, ActualDSInstrument);
		  ADSI_UP(SampleQueueWindow, ActualDSInstrument);
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "CallerWindow", gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)));
		  PresetSampleQueueWidgets (SampleQueueWindow,
									LC2.Instruments[ActualInstrument].InstrumentType,
									gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)),
									GTK_WIDGET(toolbutton),
									TR541MeasureNewOkFunction,
									TR541MeasureNewDestroyFunction);
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "SelectedItem", GINT_TO_POINTER(-1));
		  SetSampleQueueWidgets (SampleQueueWindow);
		  RefreshQueueList (SampleQueueWindow);
		  on_SampleQueueGenerateNameButton_clicked (GTK_BUTTON(lookup_widget(SampleQueueWindow, "SampleQueueGenerateNameButton")), NULL);
		  gtk_widget_show (SampleQueueWindow);
	  } // if MetFlag
	  else create_FilenameErrorDialog (MeasureWindow, _("Hiba a megadott METHOD filenévnél!"), _("Filenév hiba"));
	  break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
}


void
on_MeasureOpenButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
}


void
on_MeasureCloseButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int ActualMeasWin;

  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "SelectedQueueItem", GINT_TO_POINTER(-1));
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (MeasureWindow), "ActualMeasWin"));
  ThreadCommandSend (ThreadCommandFinish, 0, 0);
  Chrom[ActualMeasWin].FileLoaded[LayFlag] = FALSE;
  RefreshMeasureQueueList (ActualMeasWin);
  ActivateMeasureWidgets (ActualMeasWin);
}


void
on_MeasureViewScanButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(toolbutton));
  GetTR541Widgets (WIDGET_TOP(toolbutton), &Chrom[ActualDSInstrument].QueueHead.LQMethod);
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusAllInactive));
  ActivateMeasureWidgets (ActualDSInstrument);
  ThreadCommandSend (ThreadCommandStart, 20, 0);
  if (ThreadCommandOk)
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusViewScan));
  else
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "TR541MeasureStatus", GINT_TO_POINTER(TR540MeasureStatusError));
  ActivateMeasureWidgets (ActualDSInstrument);
}


void
on_MeasureQueueButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(toolbutton));
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
		  SampleQueueWindow = create_SampleQueueWindow ();
		  gtk_window_set_title (GTK_WINDOW (SampleQueueWindow), "Running sample queue - restricted");
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "ActualDSInstrument", GINT_TO_POINTER(ActualDSInstrument));
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "CallerWindow", WIDGET_TOP(toolbutton));
		  DATASOURCE_UP(SampleQueueWindow, ActualDSInstrument);
		  PresetSampleQueueWidgets (SampleQueueWindow,
									LC2.Instruments[ActualInstrument].InstrumentType,
									WIDGET_TOP(toolbutton),
									GTK_WIDGET(toolbutton),
									WorkstationMeasureQueueOkFunction, NULL);
		  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "SelectedItem", GINT_TO_POINTER(-1));
		  SetSampleQueueWidgets (SampleQueueWindow);
		  RefreshQueueList (SampleQueueWindow);
		  gtk_widget_show (SampleQueueWindow);
		  ActivateWidget (SampleQueueWindow, "SampleQueueNewButton", FALSE);
		  ActivateWidget (SampleQueueWindow, "SampleQueueOpenButton", FALSE);
		  ActivateWidget (SampleQueueWindow, "SampleQueueSaveButton", FALSE);
		  SetCheckBox (SampleQueueWindow, "SampleQueueGCHPLCAppendCheckBox", TRUE);
		  if (Chrom[ActualDSInstrument].QueueHead.QueueItemNum > 0) {
			  GetQueueItem (ActualDSInstrument, Chrom[ActualDSInstrument].QueueHead.QueueItemNum - 1);
			  SetSpinButtonValue (SampleQueueWindow, "SampleQueueGCHPLCStartExtensionSpinButton", Chrom[ActualDSInstrument].QueueItem.ExtIdx + 1);
		  }
		  ActivateWidget (SampleQueueWindow, "SampleQueueGCHPLCAppendCheckBox", FALSE);
		  ActivateWidget (SampleQueueWindow, "SampleQueueCommonMethodFileEntry", FALSE);
		  ActivateWidget (SampleQueueWindow, "SampleQueueSubDirCheckButton", FALSE);
		  ActivateWidget (SampleQueueWindow, "SampleQueueDataDirFileEntry", FALSE);
		  //ActivateWidget (SampleQueueWindow, "", FALSE);
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
	  SampleQueueWindow = create_SampleQueueWindow ();
	  gtk_window_set_title (GTK_WINDOW (SampleQueueWindow), "Layer");
	  ADSI_UP(SampleQueueWindow, ActualDSInstrument);
	  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "CallerWindow", gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)));
	  PresetSampleQueueWidgets (SampleQueueWindow,
								LC2.Instruments[ActualInstrument].InstrumentType,
								WIDGET_TOP(toolbutton),
								GTK_WIDGET(toolbutton),
								TR541MeasureQueueOkFunction, NULL);
	  gtk_object_set_data (GTK_OBJECT (SampleQueueWindow), "SelectedItem", GINT_TO_POINTER(-1));
	  SetSampleQueueWidgets (SampleQueueWindow);
	  RefreshQueueList (SampleQueueWindow);
	  gtk_widget_show (SampleQueueWindow);
	  break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
}


void
on_MeasureStartButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  StartExec (WIDGET_TOP(toolbutton));
}


void
on_MeasureBreakButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  MeasureBreakMessageBox = create_MeasureBreakMessageBox ();
  gtk_object_set_data (GTK_OBJECT (MeasureBreakMessageBox), "CallerButton", toolbutton);
  gtk_widget_show (MeasureBreakMessageBox);
}


void
on_MeasureBreakMessageBox_destroy      (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *CallerButton;

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);
}


void
on_MeasureBreakNoButton_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_MeasureBreakYesButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  BreakExec (WIDGET_TOP(button));
  gtk_object_set_data (GTK_OBJECT (MeasureBreakMessageBox), "CallerButton", NULL);
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_MeasureFinishButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int ActualChannel;
char *TitleStr;

ActualChannel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "ActualMeasWin"));
  TitleStr = alloca (1400);
  strcpy (TitleStr, "Reprocess: ");

  if (Options[ActualChannel].DataAcqMode == MeasureRunModeUnique) {
          strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
	  ChromSave (WorkArea);
	  gtk_widget_show (ReprocessWindow);
	  ReprocessDrawChromDone ();
	  StopExec (WIDGET_TOP(toolbutton));
	  pthread_mutex_lock (&measure_parameter_mutex);
	  strcpy (Chrom[WorkArea].Filename, Chrom[ActualChannel].LastName);
	  strcat (TitleStr, Chrom[ActualChannel].LastName);
	  pthread_mutex_unlock (&measure_parameter_mutex);
	  ChromLoad (WorkArea);
	  ReprocessDrawChromInit ();
	  ReprocessDrawChrom ();
	  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TitleStr);
	  ActivateReprocessWidgets ();
	  gtk_window_present (GTK_WINDOW (ReprocessWindow));
  } else
  StopExec (WIDGET_TOP(toolbutton));
}


void
on_MeasureShowLastButton_clicked       (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
int ActualChannel;
char *TitleStr;

  ActualChannel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "ActualMeasWin"));
  TitleStr = alloca (1400);
  strcpy (TitleStr, "Reprocess: ");

  if (!Chrom[ActualChannel].QueueOrSeriesActive) {
          strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].ChrName);
	  ChromSave (WorkArea);
	  gtk_widget_show (ReprocessWindow);
	  ReprocessDrawChromDone ();
	  pthread_mutex_lock (&measure_parameter_mutex);
	  strcpy (Chrom[WorkArea].Filename, Chrom[ActualChannel].LastName);
	  strcat (TitleStr, Chrom[ActualChannel].LastName);
	  pthread_mutex_unlock (&measure_parameter_mutex);
	  ChromLoad (WorkArea);
	  ReprocessDrawChromInit ();
	  ReprocessDrawChrom ();
	  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TitleStr);
	  ActivateReprocessWidgets ();
	  gtk_window_present (GTK_WINDOW (ReprocessWindow));
  }
}


void
on_MeasureSpectraButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  SpectraWindow = create_SpectraWindow();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "SpectraWindow", SpectraWindow);
  PresetSpectraWidgets (SpectraWindow,
										gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)),
										GTK_WIDGET (toolbutton));
  SetSpectraWidgets ();
  ActivateSpectraWidgets ();
  gtk_window_set_transient_for (GTK_WINDOW (SpectraWindow), GTK_WINDOW (MeasureWindow));
  gtk_widget_show (SpectraWindow);
}


void
on_MeasureServiceButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ServiceWindow = create_ServiceWindow();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "ServiceWindow", ServiceWindow);
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "TR930ReflTransmSet", GINT_TO_POINTER(FALSE));
  PresetServicesWidgets (ServiceWindow,
										gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)),
										GTK_WIDGET (toolbutton));
  TestModeON (WIDGET_TOP(toolbutton));
  gtk_widget_show (ServiceWindow);
}


void
on_MeasurePreferencesButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  PreferencesWindow = create_PreferencesWindow ();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "PreferencesWindow", PreferencesWindow);
  PresetPreferencesWidgets (PreferencesWindow,
										0,
										gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)),
										GTK_WIDGET (toolbutton),
										MeasurePreferencesApplyFunction); // Measure Tab as default
  SetPreferencesWidgets (PreferencesWindow);
  gtk_widget_show (PreferencesWindow);
}


void
on_MeasureErrorButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ActivateWidget (MeasureWindow, "MeasureErrorButton", FALSE);
  MeasureErrorDialog = create_MeasureErrorDialog ();
  PresetMeasureErrorWidgets ();
  gtk_widget_show (MeasureErrorDialog);
}


void
on_MeasureErrorDialogHelpButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureErrorDialogOKButton_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (MeasureErrorDialog);
}


void
on_MeasureErrorFilenameCloseButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *MethodWin;

  MethodWin = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (button))), "MethodWin");
  gtk_widget_destroy (MethodWin);
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
}


void
on_MeasureExitButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


// ************************************************************

void
on_MeasureQueueCList_select_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *ActiveMeasureWindow;
int ActualMeasWin;

  ActiveMeasureWindow = WIDGET_TOP(clist);
  gtk_object_set_data (GTK_OBJECT(ActiveMeasureWindow), "SelectedQueueItem", GINT_TO_POINTER(row));
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "ActualMeasWin"));
  ActivateMeasureWidgets (ActualMeasWin);
}


void
on_MeasureQueueCList_unselect_row      (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *ActiveMeasureWindow;
int ActualMeasWin;

  ActiveMeasureWindow = WIDGET_TOP(clist);
  gtk_object_set_data (GTK_OBJECT(ActiveMeasureWindow), "SelectedQueueItem", GINT_TO_POINTER(-1));
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "ActualMeasWin"));
  ActivateMeasureWidgets (ActualMeasWin);
}


gboolean
on_MeasureQueueCList_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureQueueRunButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *ActiveMeasureWindow;
int ActualMeasWin;

  ActiveMeasureWindow = WIDGET_TOP(toolbutton);
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "ActualMeasWin"));
  ThreadCommandSend (ThreadCommandContinue, 0, ActualMeasWin);
  ActivateMeasureWidgets (ActualMeasWin);
}


void
on_MeasureQueueStopButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *ActiveMeasureWindow;
int ActualMeasWin;

  ActiveMeasureWindow = WIDGET_TOP(toolbutton);
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "ActualMeasWin"));
//  ThreadSuspendFlag[ActualMeasWin] = TRUE;
  ThreadCommandSend (ThreadCommandSuspend, 0, ActualMeasWin);
  ActivateMeasureWidgets (ActualMeasWin);
}


void
on_MeasureQueueRepeatButton_clicked    (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *ActiveMeasureWindow;
int ActualMeasWin;
int SelectedQueueItem;

  ActiveMeasureWindow = WIDGET_TOP(toolbutton);
  DATASOURCE(ActiveMeasureWindow);
  ADSI(ActiveMeasureWindow);
  SelectedQueueItem = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(ActiveMeasureWindow), "SelectedQueueItem"));
  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ActiveMeasureWindow), "ActualMeasWin"));
  if (SelectedQueueItem < 0) return;
  GetQueueItem (ActualDSInstrument, SelectedQueueItem);
  SelectedQueueItem = Chrom[ActualDSInstrument].QueueHead.QueueItemLocked;
  AddQueueItem (ActualDSInstrument, SelectedQueueItem);
  //
  //
  RefreshMeasureQueueList (ActualMeasWin);
  ActivateMeasureWidgets (ActualMeasWin);
}


void
on_MeasureQueueSettingsButton_clicked  (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int ActualMeasWin;

  ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton))), "ActualMeasWin"));

}


void
on_MeasureQueuePreferencesButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_MeasureQueueCalibrationButton_clicked
                                        (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
DATASOURCE(WIDGET_TOP(toolbutton));
ADSI(WIDGET_TOP(toolbutton));

  CalibrationWindow = create_CalibrationWindow ();
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "IstNumInCombo", GINT_TO_POINTER(1));

  DATASOURCE_UP (CalibrationWindow, ActualDSInstrument);
  ADSI_UP (CalibrationWindow, ActualDSInstrument);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "CallerWidget", WIDGET_TOP (toolbutton));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "CallerButton", GTK_WIDGET (toolbutton));
  gtk_widget_set_sensitive (GTK_WIDGET (toolbutton), FALSE);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "ApplyFunction", CalibrateApplyFunction);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedComponent", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedLevel", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedChrom", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedChromPeak", GINT_TO_POINTER(-1));
  if (Chrom[ActualDSInstrument].FileLoaded[CalFlag]) {
	  SetCalibrateWidgets (ActualDSInstrument, CalibrationWindow);
	  Chrom[ActualDSInstrument].CalibrHead->SaveCalibrAfterMod = TRUE;
  }
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedTemplatePeak", GINT_TO_POINTER(-1));
  gtk_widget_show (CalibrationWindow);
  gtk_window_present (GTK_WINDOW (CalibrationWindow));
  gtk_object_set_data (GTK_OBJECT(CalibrationCheckWindow), "CalibrationWindow", CalibrationWindow);
  RefreshCalibrCheckWindow (CalibrationWindow);
}


void
on_MeasureQueueReprocessButton_clicked (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
char *TmpStr;

  int SelectedQueueItem = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(toolbutton)), "SelectedQueueItem"));
  int ActualMeasWin = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "ActualMeasWin"));
  strcpy (Chrom[WorkArea].Filename, "");
  pthread_mutex_lock (&measure_parameter_mutex);
  GetQueueItem (ActualMeasWin, SelectedQueueItem);
  if (Chrom[ActualMeasWin].QueueItem.QueueItemMeasured)
	  strcpy (Chrom[WorkArea].Filename, Chrom[ActualMeasWin].QueueItem.FinalFilename);
  pthread_mutex_unlock (&measure_parameter_mutex);

  ChromLoad (WorkArea);
  if (Chrom[WorkArea].FileLoaded[ChrFlag]) {
	  gtk_widget_show (ReprocessWindow);
	  ReprocessDrawChromDone ();
	  DATASOURCE(WIDGET_TOP(toolbutton));
	  ShowWidget (ReprocessWindow, "ReprocessIntoCalibrButton");
	  ShowWidget (ReprocessWindow, "ReprocessFileToolbarVSeparator3");
	  gtk_object_set_data (GTK_OBJECT (ReprocessWindow), "MeasureActiv", GINT_TO_POINTER(TRUE));
	  DATASOURCE_UP(ReprocessWindow, DataSource);
	  ActivateWidget (ReprocessWindow, "ReprocessIndexToggleButton", FALSE);
	  ActivateWidget (ReprocessWindow, "ReprocessOpenButton", FALSE);
	  ReprocessShowLists = FALSE;
	  gtk_check_menu_item_set_active  (GTK_CHECK_MENU_ITEM(lookup_widget (ReprocessWindow, "ReprocessIndex")), ReprocessShowLists);
	  if (ReprocessShowLists == FALSE)
		  HideWidget (ReprocessWindow, "ReprocessVBox");
	  else
		  ShowWidget (ReprocessWindow, "ReprocessVBox");
	  ActivateReprocessWidgets ();
	  TmpStr = alloca (1400);
	  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
	  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
	  ReprocessDrawChromInit ();
	  ReprocessDrawChrom ();
	  gtk_window_present (GTK_WINDOW (ReprocessWindow));
  }
}


void
on_MeasureQueueAnalyzeButton_clicked   (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{

}


void
on_MeasureQueuePrintButton_clicked     (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{

}

// **********************************************

void
on_MeasureWorkstationAttenuatorSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureWorkstationAttenuatorSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Options[ActualDSInstrument].MeasureAttenuator[Chrom[ActualDSInstrument].ActualDetector] = \
	  gtk_spin_button_get_value_as_int (spinbutton);
}


void
on_MeasureWorkstationShiftSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureWorkstationShiftSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Options[ActualDSInstrument].MeasureShift[Chrom[ActualDSInstrument].ActualDetector] = \
	  gtk_spin_button_get_value (spinbutton);
}


void
on_MeasureWorkstationTimeSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureWorkstationTimeSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Options[ActualDSInstrument].MeasureAxisTime = gtk_spin_button_get_value (spinbutton);
}


void
on_MeasureWorkstationResetMonitoringButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(button));
  pthread_mutex_lock (&measure_data_mutex);
  MeasureTickCounter[ActualDSInstrument] = 0;

  pthread_mutex_unlock (&measure_data_mutex);
}


void
on_MeasureWorkstationColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(colorpicker));
  Options[ActualDSInstrument].red[Chrom[ActualDSInstrument].ActualDetector] = red;
  Options[ActualDSInstrument].green[Chrom[ActualDSInstrument].ActualDetector] = green;
  Options[ActualDSInstrument].blue[Chrom[ActualDSInstrument].ActualDetector] = blue;
  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].red = red;
  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].green = green;
  DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector].blue = blue;
  gdk_colormap_alloc_color (DrawColormap, &DetectorColors[ActualDSInstrument][Chrom[ActualDSInstrument].ActualDetector], TRUE, TRUE);

}


gboolean
on_MeasureWorkstationDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  MeasureDrawingAreaHeight = event->height;
  MeasureDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_MeasureWorkstationDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureWorkstationDrawingArea_event (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureWorkstationIODrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  MeasureIODrawingAreaHeight = event->height;
  MeasureIODrawingAreaWidth = event->width;
  MeasureIOAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MeasureWorkstationIODrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  MeasureIOAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MeasureWorkstationIODrawingArea_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GdkEventButton		*eventButton;
int					CursorX, CursorY;

  switch (event->type) {
	  case GDK_BUTTON_PRESS:
		  eventButton = (GdkEventButton *)event;
		  if (eventButton->button == 1) {
			  CursorX = (int)(eventButton->x);
			  CursorY = (int)(eventButton->y);
			  WorkstationMeasureIOAreaRecalc (CursorX, CursorY);
		  } // eventButton->button == 1
		  break;
  } // switch event->type

  return FALSE;
}

//
// *** TR541
//

void
on_MeasureTR541TrackAddButton_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedTrack;
int NewTrackPos;

  ADSI(WIDGET_TOP(button));
  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack"));
  NewTrackPos = 15;
  if (Chrom[ActualDSInstrument].QueueHead.QueueItemNum > 0)
	  NewTrackPos = Chrom[ActualDSInstrument].QueueItemArray[Chrom[ActualDSInstrument].QueueHead.QueueItemNum - 1].TrackPosition;
  NewTrackPos += 10;
  if (NewTrackPos > 190)
	  NewTrackPos = 190;
  DefaultQueueItem (ActualDSInstrument);
  Chrom[ActualDSInstrument].QueueItem.TrackPosition = NewTrackPos;
  AddQueueItem (ActualDSInstrument, -1);
  SelectedTrack = Chrom[ActualDSInstrument].QueueHead.QueueItemNum;
  Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].ExtIdx = SelectedTrack;
  strcpy (Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].BaseFileName, \
		  Chrom[ActualDSInstrument].QueueHead.BaseName);
  sprintf (Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].BaseExtName, "%.3d", SelectedTrack);
  Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].StandardLevel = 1;
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack", GINT_TO_POINTER(SelectedTrack));
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541SelectedTrackSpinButton", SelectedTrack);
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition);
  TR541RawRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541LayerDrawingArea"));
  TR541TrackRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541TrackDrawingArea"));
}


void
on_MeasureTR541TrackRemoveButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedTrack;

  ADSI(WIDGET_TOP(button));
  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack"));

  DelQueueItem (ActualDSInstrument, SelectedTrack);
  if (SelectedTrack > Chrom[ActualDSInstrument].QueueHead.QueueItemNum) {
	  SelectedTrack = Chrom[ActualDSInstrument].QueueHead.QueueItemNum;
	  if (SelectedTrack < 1)
		  SelectedTrack = 1;
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack", GINT_TO_POINTER(SelectedTrack));
  }
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541SelectedTrackSpinButton", SelectedTrack);
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition);
  TR541RawRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541LayerDrawingArea"));
  TR541TrackRedraw (ActualDSInstrument, lookup_widget (MeasureWindows[ActualDSInstrument], "MeasureTR541TrackDrawingArea"));
}


void
on_MeasureTR541TrackUpButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedTrack;

  ADSI(WIDGET_TOP(button));
  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack"));
  if (Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition > 1)
	  Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition--;
  else return;
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition);
}


void
on_MeasureTR541TrackDownButton_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedTrack;

  ADSI(WIDGET_TOP(button));
  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "TR541SelectedTrack"));
  if (Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition < 199)
	  Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition++;
  else return;
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition);
}


void
on_MeasureTR541TrackStretchButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(button));
  if (Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth < 50)
	  Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth++;
  else return;
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackWidthSpinButton", Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth);
}


void
on_MeasureTR541TrackShrinkButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(button));
  if (Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth > 2)
	  Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth--;
  else return;
  SetSpinButtonValue (WIDGET_TOP(button), "MeasureTR541TrackWidthSpinButton", Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth);
}


void
on_MeasureTR541SelectedTrackSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541SelectedTrackSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int STrack;
BT_INIT();
ADSI(WIDGET_TOP(spinbutton));

  STrack = gtk_spin_button_get_value_as_int (spinbutton);

  if (STrack < 1) {
	  BUGTRACE("STrack < 1");
	  gtk_spin_button_set_value (spinbutton, 1);
	  return;
  }

  if (STrack > Chrom[ActualDSInstrument].QueueHead.QueueItemNum) {
	  STrack = Chrom[ActualDSInstrument].QueueHead.QueueItemNum;
	  if (STrack < 1) {
		  STrack = 1;
		  BUGTRACE("STrack > Num AND < 1");
	  }
	  gtk_spin_button_set_value (spinbutton, STrack);
	  return;
  }

  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(spinbutton)), "TR541SelectedTrack", GINT_TO_POINTER(STrack));
  SetSpinButtonValue (WIDGET_TOP(spinbutton), "MeasureTR541TrackPositionSpinButton", Chrom[ActualDSInstrument].QueueItemArray[STrack - 1].TrackPosition);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541TrackPositionSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541TrackPositionSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int SelectedTrack;

  ADSI(WIDGET_TOP(spinbutton));
  SelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(spinbutton)), "TR541SelectedTrack"));
  Chrom[ActualDSInstrument].QueueItemArray[SelectedTrack - 1].TrackPosition = \
	  GetSpinButtonInt (WIDGET_TOP(spinbutton), "MeasureTR541TrackPositionSpinButton");
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541TrackWidthSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541TrackWidthSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540TrackWidth = \
	  gtk_spin_button_get_value_as_int (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


gboolean
on_MeasureTR541LayerDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541LayerDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  MeasureLayerDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MeasureTR541LayerDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541TrackDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  LayerTrackDrawingAreaHeight = event->height;
  LayerTrackDrawingAreaWidth = event->width;

  gtk_object_set_data (GTK_OBJECT(widget), "AreaHeight", GINT_TO_POINTER(LayerTrackDrawingAreaHeight));
  gtk_object_set_data (GTK_OBJECT(widget), "AreaWidth", GINT_TO_POINTER(LayerTrackDrawingAreaWidth));

  MeasureLayerDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MeasureTR541TrackDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  MeasureLayerDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MeasureTR541TrackDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  MeasureLayerDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


void
on_MeasureTR541ShortScanCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(togglebutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.TR540Parameters.TR540HalfSizeScan = \
	  gtk_toggle_button_get_active (togglebutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}



void
on_MeasureTR541NormXSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541NormXSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.NormX = \
	  gtk_spin_button_get_value_as_int (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541StartXSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541StartXSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.ScanStartX = \
	  gtk_spin_button_get_value_as_int (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541StartYSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541StartYSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541NormYSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541NormYSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.NormY = \
	  gtk_spin_button_get_value_as_int (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541StopXSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541StopXSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.ScanStopX = \
	  gtk_spin_button_get_value_as_int (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


void
on_MeasureTR541StopYSpinButton_changed (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541StopYSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter1MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter2MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter3MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter4MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter5MenuIten_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter6MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFilter7MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanFluorescenceCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanReflectanceRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ScanTransmittanceRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


gboolean
on_MeasureTR541ColorDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541ColorDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541ColorDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureTR541UpperColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541UpperColorPicker_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541UpperColorSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541UpperColorSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.ViewMax = gtk_spin_button_get_value_as_float (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


gboolean
on_MeasureTR541ColorDistributionDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541ColorDistributionDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR541ColorDistributionDrawingArea_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureTR541ColorAutoscaleButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541ColorRedrawButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(button));
  TR541RawRedraw (ActualDSInstrument, lookup_widget (WIDGET_TOP(button), "MeasureTR541LayerDrawingArea"));
}


void
on_MeasureTR541LowerColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541LowerColorPicker_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541LowerColorSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR541LowerColorSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(spinbutton));
  Chrom[ActualDSInstrument].QueueHead.LQMethod.MeasureParameters.ViewMin = gtk_spin_button_get_value_as_float (spinbutton);
  MeasureLayerDrawingAreaNeedRedraw = TRUE;
}


gboolean
on_MeasureTR930LayerDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  LayerDrawingAreaHeight = event->height;
  LayerDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_MeasureTR930LayerDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR930LayerDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR930TrackDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  LayerTrackDrawingAreaHeight = event->height;
  LayerTrackDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_MeasureTR930TrackDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR930TrackDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureTR930CheckMethodButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


gboolean
on_MeasureTR930ColorDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  LayerColorDrawingAreaHeight = event->height;
  LayerColorDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_MeasureTR930ColorDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR930ColorDrawingArea_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureTR930UpperColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930UpperColorPicker_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930UpperColorSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930UpperColorSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


gboolean
on_MeasureTR930ColorDistributionDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  LayerColorDistributionDrawingAreaHeight = event->height;
  LayerColorDistributionDrawingAreaWidth = event->width;

  return FALSE;
}


gboolean
on_MeasureTR930ColorDistributionDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MeasureTR930ColorDistributionDrawingArea_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MeasureTR930ColorAutoscaleButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930LowerColorPicker_color_set
                                        (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930LowerColorPicker_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930LowerColorSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_MeasureTR930LowerColorSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}

/***
***   AD Trace window
***/


gboolean
on_MeasureADTraceWindow_delete_event   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(MeasureWindow, "MeasureViewTrace")), FALSE);

  return TRUE;
}


void
on_MeasureViewTrace_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem))) {
	  gtk_widget_show (MeasureADTraceWindow);
	  gtk_window_set_transient_for (GTK_WINDOW (MeasureADTraceWindow), GTK_WINDOW (MENU_TOP(menuitem)));
  }
  else
	  gtk_widget_hide (MeasureADTraceWindow);
}


void
on_MeasureADTraceHeartBeatCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceHeartBeat = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceResponseCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceResponse = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceFreshDataCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceFreshData = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceDataCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceData = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceInputCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceInput = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceOutputCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceOutput = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceGradientCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ADTraceGradient = gtk_toggle_button_get_active (togglebutton);
}


void
on_MeasureADTraceRefreshButton_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
  ADTraceStatusGetNow = TRUE;
  usleep (100000);
  pthread_mutex_lock (&ad_trace_mutex);
  SetEntry (WIDGET_TOP(button), "MeasureADTraceStatusEntry", ADTraceString);
  pthread_mutex_unlock (&ad_trace_mutex);
}


void
on_MeasureADTraceGetButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureADTraceClearButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureADTraceHelpButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MeasureADTraceCloseButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(MeasureWindow, "MeasureViewTrace")), FALSE);
}
