// Main window callback functions

gboolean
on_MainWindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  MainExitMessageBox = create_MainExitMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (MainExitMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (MainExitMessageBox), GTK_WINDOW (MainWindow));
  gtk_widget_show (MainExitMessageBox);

  return TRUE;
}


void
on_MainWindow_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_MainNew_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainOpen_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainClose_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainSaveAs_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainPrint_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainQuit_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  MainExitMessageBox = create_MainExitMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (MainExitMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (MainExitMessageBox), GTK_WINDOW (MainWindow));
  gtk_widget_show (MainExitMessageBox);
}


void
on_MainCut_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainCopy_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainPaste_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainClear_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainProperties_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_MainPreferences_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  PreferencesWindow = create_PreferencesWindow ();
  gtk_object_set_data (GTK_OBJECT (get_toplevel_of_menuitem (GTK_WIDGET(menuitem))), "PreferencesWindow", PreferencesWindow);
  PresetPreferencesWidgets (PreferencesWindow,
										-1,
										get_toplevel_of_menuitem (GTK_WIDGET(menuitem)),
										GTK_WIDGET (menuitem),
										MainPreferencesApplyFunction); // All Tabs are shown
  SetPreferencesWidgets (PreferencesWindow);
  gtk_widget_show (PreferencesWindow);
}


void
on_MainAbout_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (MainWindow));
  gtk_widget_show (About);
}


void
on_MainRunningQueueButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  RefreshMainQueue (WIDGET_TOP(toolbutton));
}


void
on_MainOpenButton_clicked              (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

  ADSI(MainWindow);
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open queue");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", MainOpenOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", WIDGET_TOP(toolbutton));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(WorkArea));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.que");
  if (strlen(LastMainOpenDir) > 0)
	  gtk_file_selection_set_filename (GTK_FILE_SELECTION(OpenSaveFileSelection), LastMainOpenDir);
  else
	  gtk_file_selection_set_filename (GTK_FILE_SELECTION(OpenSaveFileSelection), Options[ActualDSInstrument].MeasureDataDir);
  gtk_widget_show (OpenSaveFileSelection);

}


void
on_MainCloseButton_clicked             (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Chrom[WorkArea].FileLoaded[LayFlag] = FALSE;
  Chrom[WorkArea].FileLoaded[CalFlag] = FALSE;
  Chrom[WorkArea].FileLoaded[ChrFlag] = FALSE;
  bzero (&Chrom[WorkArea].QueueHead, sizeof(struct LayerQueueHeadStruct));
  RefreshMainQueue (WIDGET_TOP(toolbutton));
  RefreshMainWidgets (WIDGET_TOP(toolbutton));
  RefreshReprocessQueue (ReprocessWindow);
  ActivateWidget (WIDGET_TOP(toolbutton), "MainCloseButton", FALSE);
  bzero (Chrom[WorkArea].CalibrHead, sizeof (struct CalibrHeadStruct));
  Chrom[WorkArea].CalibrHead->CalibrType = CalibrExtStd;
  OverrideMainWindowShrink = FALSE;
  if ((MainWindowShrink) && (!MainWindowShrinked))
	  ShrinkMainWindow();

  // Opened calibration and other window???
}


void
on_MainMethodButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
GtkWidget *MethodWindow;

  ADSI(WIDGET_TOP(toolbutton));
  MethodWindow = create_MethodWindow ();
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "MethodWindow", MethodWindow);
  Chrom[DevelopSingleFile].Method.ADParameters = WorkAD;
  Chrom[DevelopSingleFile].Method.Instrument = WorkInstrument[ActualDSInstrument];
  DATASOURCE_UP (MethodWindow, DevelopSingleFile);
  strcpy (Chrom[DevelopSingleFile].MetName, "");
  ADSI_UP(MethodWindow, ActualDSInstrument);
printf ("PresetMethodWidgets IN\n");
  PresetMethodWidgets (MethodWindow,
								&Chrom[DevelopSingleFile].Method,
								WIDGET_TOP(toolbutton),
								GTK_WIDGET (toolbutton),
								MethodOkFunction);
printf ("PresetMethodWidgets\n");
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "IntParChan", GINT_TO_POINTER(0));
  gtk_object_set_data (GTK_OBJECT (MethodWindow), "Report", &Chrom[DevelopSingleFile].Method.Report);

  gtk_widget_show (MethodWindow);
printf ("SetMethodWidgets IN\n");
  SetMethodWidgets (MethodWindow);
printf ("SetMethodWidgets\n");
}


void
on_MainSampleQueueButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  ADSI(WIDGET_TOP(toolbutton));
  SampleQueueWindow = create_SampleQueueWindow ();
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(toolbutton)), "SampleQueueWindow", SampleQueueWindow);
  DATASOURCE_UP(SampleQueueWindow, DevelopSingleFile);
  ADSI_UP(SampleQueueWindow, ActualDSInstrument);

  PresetSampleQueueWidgets (SampleQueueWindow,
								LC2.Instruments[ActualInstrument].InstrumentType,
								WIDGET_TOP(toolbutton),
								GTK_WIDGET (toolbutton),
								SampleQueueDevelopOkFunction, NULL);

  SetSampleQueueWidgets (SampleQueueWindow);
  gtk_widget_show (SampleQueueWindow);
}


void
on_MainMeasureButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_show (MeasureWindow);
  gtk_window_present (GTK_WINDOW (MeasureWindow));
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(lookup_widget(MeasureWindow, "MeasureViewTrace")))) {
	  gtk_widget_show (MeasureADTraceWindow);
	  gtk_window_set_transient_for (GTK_WINDOW (MeasureADTraceWindow), GTK_WINDOW (MeasureWindow));
  }
}


void
on_MainReprocessButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
char *TmpStr;

  int TR541Track = DATA_DOWN(MainWindow, "TR541SelectedTrack");
  int MeasureActiv = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (ReprocessWindow), "MeasureActiv"));
  switch (LC2.Instruments[ActualInstrument].InstrumentType) {
	case InstrumentNone :
		break;
	case InstrumentWorkstation :
	  if (MeasureActiv) {
		  DATASOURCE_UP(ReprocessWindow, WorkArea);
		  Chrom[WorkArea].FileLoaded[ChrFlag] = FALSE;
		  gtk_object_set_data (GTK_OBJECT (ReprocessWindow), "MeasureActiv", GINT_TO_POINTER(FALSE));
		  HideWidget (ReprocessWindow, "ReprocessIntoCalibrButton");
		  HideWidget (ReprocessWindow, "ReprocessFileToolbarVSeparator3");
		  ActivateWidget (ReprocessWindow, "ReprocessIndexToggleButton", TRUE);
		  ActivateWidget (ReprocessWindow, "ReprocessOpenButton", TRUE);
		  ActivateReprocessWidgets ();
		  ReprocessDrawChrom ();
	  }
	  gtk_window_present (GTK_WINDOW (ReprocessWindow));
		break;
	case InstrumentDataStation :
		break;
	case InstrumentTR541 :
		gtk_window_present (GTK_WINDOW (ReprocessWindow));
		if (Chrom[WorkArea].FileLoaded[LayFlag]) {
			GetQueueItem (WorkArea, TR541Track - 1);
			strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
			if (ZoomPermanentCheck ())
				ZoomPermanentSuspend ();
			CursorLineDone ();
			ReprocessDrawChromDone ();
			ChromLoad (WorkArea);
			ReprocessDrawChromInit ();
			ReprocessDrawChrom ();
			CursorLineInit ();
			CursorLineDraw ();
			if (ZoomPermanentCheck ())
				ZoomPermanentContinue ();
			RefreshPeakList ();
			TmpStr = alloca (1000);
			sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
			gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
			ActivateReprocessWidgets ();
		} // LayFlag
		break;
	case InstrumentTR542 :
		break;
	case InstrumentTR930 :
		break;
  } // switch
}


void
on_MainCalibrateButton_clicked         (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
char *TitleString;

  ADSI(WIDGET_TOP (toolbutton));
  CalibrationWindow = create_CalibrationWindow ();
  DATA_UP(CalibrationWindow, "QueueMode", Chrom[WorkArea].FileLoaded[LayFlag]);
  DATA_UP(CalibrationWindow, "QueueSource", WorkArea);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "IstNumInCombo", GINT_TO_POINTER(1));
  gtk_object_set_data (GTK_OBJECT(MainWindow), "CalibrationWindow", CalibrationWindow);
  gtk_object_set_data (GTK_OBJECT(CalibrationCheckWindow), "CalibrationWindow", CalibrationWindow);

  DATASOURCE_UP(CalibrationWindow, WorkArea);
  ADSI_UP(CalibrationWindow, ActualDSInstrument);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "CallerWidget", WIDGET_TOP (toolbutton));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "CallerButton", GTK_WIDGET (toolbutton));
  gtk_widget_set_sensitive (GTK_WIDGET (toolbutton), FALSE);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "ApplyFunction", CalibrateApplyFunction);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedComponent", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedLevel", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedChrom", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedChromPeak", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectedTemplatePeak", GINT_TO_POINTER(-1));
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectTemplateDialog", NULL);
  gtk_object_set_data (GTK_OBJECT (CalibrationWindow), "SelectChromDialog", NULL);
  gtk_widget_show (CalibrationWindow);
  TitleString = calloc(FilenameLength + 50, sizeof(char));
  strcpy (TitleString, _("Calibration"));
  if (Chrom[WorkArea].FileLoaded[CalFlag]) {
	  strcat (TitleString, ":");
	  strcat (TitleString, Chrom[WorkArea].CalName);
  }
  gtk_window_set_title (GTK_WINDOW(CalibrationWindow), TitleString);
  free (TitleString);
  SetCalibrateWidgets (WorkArea, CalibrationWindow);

  RefreshCalibrCheckWindow (CalibrationWindow);
}

void
on_MainAnalyzeButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATA_UP(AnalyzeWindow, "QueueMode", Chrom[WorkArea].FileLoaded[LayFlag]);
  DATA_UP(AnalyzeWindow, "QueueSource", WorkArea);
  gtk_object_set_data (GTK_OBJECT (AnalyzeWindow), "DataSource", GINT_TO_POINTER(WorkArea));
  gtk_object_set_data (GTK_OBJECT (AnalyzeWindow), "ApplyFunction", AnalyzeApplyFunction);
  SetAnalyzeWidgets (WorkArea, AnalyzeWindow);
  gtk_widget_show (AnalyzeWindow);
  gtk_window_present (GTK_WINDOW (AnalyzeWindow));
}


void
on_MainReportButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_MainExitButton_clicked              (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  MainExitMessageBox = create_MainExitMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (MainExitMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (MainExitMessageBox), GTK_WINDOW (MainWindow));
  gtk_widget_show (MainExitMessageBox);
}

// ***
// *** Main queue
// ***

void
on_MainCList_select_row                (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATA_UP(WIDGET_TOP(clist), "MainQueueItem", row);
  DATA_UP(WIDGET_TOP(clist), "TR541SelectedTrack", row + 1);
  SetSpinButtonValue (WIDGET_TOP(clist), "MainTR541ChromSelectedTrackSpinButton", row + 1);
  MainDrawingAreaNeedRedraw = TRUE;
}


void
on_MainCList_unselect_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATA_UP(WIDGET_TOP(clist), "MainQueueItem", -1);
  DATA_UP(WIDGET_TOP(clist), "TR541SelectedTrack", 1);
  MainDrawingAreaNeedRedraw = TRUE;
}


gboolean
on_MainCList_event                     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GdkEventButton		*eventButton;
GdkEventMotion		*eventMotion;
int QueueRow;
char *TmpStr;

	if (!Chrom[WorkArea].FileLoaded[LayFlag]) { return FALSE; }

	QueueRow = DATA_DOWN(WIDGET_TOP(widget), "MainQueueItem");
	if (QueueRow < 0) { return FALSE; }

	switch (event->type) {
		case GDK_NOTHING:
			printf ("@ on_MainCList_event GDK_NOTHING\n");
			break; // GDK_NOTHING
		case GDK_MOTION_NOTIFY:
			break; // GDK_MOTION_NOTIFY
		case GDK_BUTTON_PRESS:
			eventButton = (GdkEventButton *)event;
			if (eventButton->button == 1) {
			printf ("@ on_MainCList_event GDK_BUTTON_PRESS\n");
			} // eventButton->button == 1
			break; // GDK_BUTTON_PRESS
		case GDK_BUTTON_RELEASE:
			printf ("@ on_MainCList_event GDK_BUTTON_RELEASE\n");
			break; // GDK_BUTTON_RELEASE
		case GDK_2BUTTON_PRESS:
			eventButton = (GdkEventButton *)event;
			if (eventButton->button == 1) {
			printf ("@ on_MainCList_event GDK_2BUTTON_PRESS\n");
			GetQueueItem (WorkArea, QueueRow);
			gtk_widget_show (ReprocessWindow);
			strcpy (Chrom[WorkArea].Filename, Chrom[WorkArea].QueueItem.FinalFilename);
			  if (ZoomPermanentCheck ())
				  ZoomPermanentSuspend ();
			  CursorLineDone ();
			  ReprocessDrawChromDone ();
			ChromLoad (WorkArea);
			  ReprocessDrawChromInit ();
			  ReprocessDrawChrom ();
			  CursorLineInit ();
			  CursorLineDraw ();
			  if (ZoomPermanentCheck ())
				  ZoomPermanentContinue ();
			  RefreshPeakList ();
			  TmpStr = alloca (1000);
			  sprintf (TmpStr, "Reprocess: %s", Chrom[WorkArea].ChrName);
			  gtk_window_set_title (GTK_WINDOW (ReprocessWindow), TmpStr);
			  ActivateReprocessWidgets ();
			if (Chrom[WorkArea].FileLoaded[ChrFlag])
				gtk_window_present (GTK_WINDOW(ReprocessWindow));
			else
				gtk_widget_hide (ReprocessWindow);
			} // eventButton->button == 1
			break; // GDK_2BUTTON_PRESS - AKA Double click
		default: {
		} 
	} // switch event->type
  return FALSE;
}

// ***
// *** Data station
// ***

void
on_MainDataStationRadioButton1_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MainDataStationRadioButton2_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MainDataStationRadioButton3_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MainDataStationRadioButton4_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_MainDataStationSettingsButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MainDataStationShowButton1_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MainDataStationShowButton2_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MainDataStationShowButton3_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_MainDataStationShowButton4_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetup_destroy  (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_DataStationChromTypeNone_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_DataStationChromTypeTLC_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_DataStationChromTypeGC_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_DataStationChromTypeHPLC_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupDetNumSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupDetNumSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupIconEntry_browse
                                        (GnomeIconEntry  *gnomeiconentry,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupIconEntry_changed
                                        (GnomeIconEntry  *gnomeiconentry,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupOkButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_DataStationInstrumentSetupHelpButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}

// ***
// *** TR541
// ***

gboolean
on_MainTR541DrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT(widget), "AreaHeight", GINT_TO_POINTER(event->height));
  gtk_object_set_data (GTK_OBJECT(widget), "AreaWidth", GINT_TO_POINTER(event->width));

  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MainTR541DrawingArea_expose_event   (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MainTR541DrawingArea_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR541ChromDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT(widget), "AreaHeight", GINT_TO_POINTER(event->height));
  gtk_object_set_data (GTK_OBJECT(widget), "AreaWidth", GINT_TO_POINTER(event->width));

  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MainTR541ChromDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;

  return FALSE;
}


gboolean
on_MainTR541ChromDrawingArea_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_MainTR541ChromSelectedTrackSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int SpinVal;
int PrevTrack;

  SpinVal = gtk_spin_button_get_value_as_int (spinbutton);
  if (SpinVal < 1) return;
  if (SpinVal > Chrom[WorkArea].QueueHead.QueueItemNum) return;
  PrevTrack = DATA_DOWN(MainWindow, "TR541SelectedTrack");
  DATA_UP(MainWindow, "TR541SelectedTrack", SpinVal);
  if (SpinVal != PrevTrack)
	  gtk_clist_select_row (GTK_CLIST(lookup_widget(MainWindow, "MainCList")), SpinVal - 1, 0);
  MainDrawingAreaNeedRedraw = TRUE;
}


void
on_MainTR541ChromUpperValueSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  Chrom[WorkArea].QueueHead.LQMethod.MeasureParameters.ViewMax = \
	  gtk_spin_button_get_value_as_float (spinbutton);
  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;
}


void
on_MainTR541ChromLowerValueSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  Chrom[WorkArea].QueueHead.LQMethod.MeasureParameters.ViewMin = \
	  gtk_spin_button_get_value_as_float (spinbutton);
  gtk_timeout_remove (MainTimeOutID);
  MainTimeOutID = gtk_timeout_add (100, MainTimeoutFunction, NULL);
  MainDrawingAreaNeedRedraw = TRUE;
}


// ***
// *** TR930
// ***

gboolean
on_MainTR930DrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR930DrawingArea_expose_event   (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR930DrawingArea_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR930ChromDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR930ChromDrawingArea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_MainTR930ChromDrawingArea_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}

// ***
// *** Exit
// ***

void
on_MainExitCancelButton_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_MainExitExitButton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  gtk_main_quit ();
}
