// Integration parameters window callback functions

void
on_IntParWindow_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *CallerButton;
struct IntegrationParametersStruct *IntParLocal;

  gtk_object_set_data (GTK_OBJECT(gtk_object_get_data (object, "CallerWidget")), "IntParWindow", NULL);
  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);
  IntParLocal = gtk_object_get_data (object, "IntParLocal");
  free (IntParLocal);
}


void
on_IntParNew_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntParForNew;

  IntParForNew = gtk_object_get_data (GTK_OBJECT (MENU_TOP(menuitem)), "IntParLocal");
  NewIntPar (IntParForNew);
  SetIntParWidgets (MENU_TOP(menuitem));
}


void
on_IntParOpen_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParSave_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParSaveAs_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParQuit_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_destroy (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_IntParCut_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParCopy_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParPaste_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParClear_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParProperties_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParPreferences_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_IntParAbout_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (get_toplevel_of_menuitem (GTK_WIDGET(menuitem))));
  gtk_widget_show (About);
}


void
on_IntParNewButton_clicked             (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntParForNew;

  IntParForNew = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton))), "IntParLocal");
  NewIntPar (IntParForNew);
  SetIntParWidgets (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


void
on_IntParOpenButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntParLocal;

  ADSI(WIDGET_TOP(toolbutton));
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open integration parameters");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", IntParOpenOkFunction);
  IntParLocal = gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(toolbutton)), "IntParLocal");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "IntParLocal", IntParLocal);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "IntParWindow", WIDGET_TOP(toolbutton));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.int");
  if (strlen (Options[ActualDSInstrument].MethodDir) == 0)
	  strcpy (Options[ActualDSInstrument].MethodDir, gtk_file_selection_get_filename(GTK_FILE_SELECTION(OpenSaveFileSelection)));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Options[ActualDSInstrument].MethodDir);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_IntParSaveButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntParLocal;

  ADSI(WIDGET_TOP(toolbutton));
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Save integration parameters");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", IntParSaveOkFunction);
  IntParLocal = gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(toolbutton)), "IntParLocal");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "IntParLocal", IntParLocal);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "IntParWindow", WIDGET_TOP(toolbutton));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.int");
  if (strlen (Options[ActualDSInstrument].MethodDir) == 0)
	  strcpy (Options[ActualDSInstrument].MethodDir, gtk_file_selection_get_filename(GTK_FILE_SELECTION(OpenSaveFileSelection)));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Options[ActualDSInstrument].MethodDir);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_IntParPrintButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
struct IntegrationParametersStruct *IntParLocal;

  IntParLocal = gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(toolbutton)), "IntParLocal");
  PrintFunction (PrintIntParMode, IntParLocal, NULL, TRUE);
}


void
on_IntParExitButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}


void
on_IntParLockCList_select_row          (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
char *TmpStr;

  TmpStr = alloca(20);
  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (clist));
  gtk_object_set_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack", GINT_TO_POINTER(row));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");

  sprintf (TmpStr, "%d", row + 1);
  SetEntry (IntWin, "IntParLockNumEntry", TmpStr);
  SetSpinButtonValue (IntWin, "IntParLockDataONSpinButton", IntPar->LockWindOn[row]);
  SetSpinButtonValue (IntWin, "IntParLockDataOFFSpinButton", IntPar->LockWindOff[row]);

  ActivateIntParWidgets (WIDGET_TOP(clist));
}


void
on_IntParLockCList_unselect_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *IntWin;

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (clist));
  gtk_object_set_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack", GINT_TO_POINTER(-1));

  ActivateIntParWidgets (WIDGET_TOP(clist));
}


void
on_IntParLockAddButton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
char *TmpStr;

  TmpStr = alloca(20);

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");

  if (IntPar->LockNum == MaxIntegrationLock) return;

  IntPar->LockWindOn[IntPar->LockNum] = GetSpinButtonFloat (IntWin, "IntParLockDataONSpinButton");
  IntPar->LockWindOff[IntPar->LockNum] = GetSpinButtonFloat (IntWin, "IntParLockDataOFFSpinButton");
  IntPar->LockNum++;

  sprintf (TmpStr, "%d", IntPar->LockNum);
  SetEntry (IntWin, "IntParLockNumEntry", TmpStr);

  SortLocks (IntPar);
  gtk_object_set_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack", GINT_TO_POINTER(-1));
  RefreshIntParLockCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParLockRemoveButton_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
int LockWindowSelectedTrack;
struct IntegrationParametersStruct *IntPar;

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");
  LockWindowSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack"));

  DeleteLock (IntPar, LockWindowSelectedTrack);

  gtk_object_set_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack", GINT_TO_POINTER(-1));
  RefreshIntParLockCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParLockModifyButton_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
int LockWindowSelectedTrack;
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");

  LockWindowSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack"));
  if (LockWindowSelectedTrack < 0) return;

  IntPar->LockWindOn[LockWindowSelectedTrack] = GetSpinButtonFloat (IntWin, "IntParLockDataONSpinButton");
  IntPar->LockWindOff[LockWindowSelectedTrack] = GetSpinButtonFloat (IntWin, "IntParLockDataOFFSpinButton");

  gtk_object_set_data (GTK_OBJECT (IntWin), "LockWindowSelectedTrack", GINT_TO_POINTER(-1));
  RefreshIntParLockCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParEventCList_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
char *TmpStr;

  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (clist))), "EventSelectedTrack", GINT_TO_POINTER(row));
  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (clist));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");

  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget(IntWin, "IntParSelectEventComboBox")), IntPar->EventType[row]);
  SetSpinButtonValue (IntWin, "IntParEventRetentionSpinButton", IntPar->EventTime[row]);
  SetSpinButtonValue (IntWin, "IntParEventFactorSpinButton", IntPar->EventFactor[row]);
  SetSpinButtonValue (IntWin, "IntParEventParameterSpinButton", IntPar->EventParameter[row]);
  SetSpinButtonValue (IntWin, "IntParEventTimeSpinButton", IntPar->EventActiveTime[row]);

  sprintf (TmpStr, "%d", IntPar->EventNum);
  SetEntry (IntWin, "IntParEventNumEntry", TmpStr);

  ActivateIntParWidgets (WIDGET_TOP(clist));
}


void
on_IntParEventCList_unselect_row       (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (clist))), "EventSelectedTrack", GINT_TO_POINTER(-1));
  ActivateIntParWidgets (WIDGET_TOP(clist));
}


void
on_IntParEventAddButton_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
int EventSelectedTrack;
char *TmpStr;

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");
  EventSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (button))), "EventSelectedTrack"));

  if (IntPar->EventNum == MaxIntegrationEventNum) return;

  IntPar->EventType[IntPar->EventNum] = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget(IntWin, "IntParSelectEventComboBox")));
  IntPar->EventTime[IntPar->EventNum] = GetSpinButtonFloat (IntWin, "IntParEventRetentionSpinButton");
  IntPar->EventFactor[IntPar->EventNum] = GetSpinButtonInt (IntWin, "IntParEventFactorSpinButton");
  IntPar->EventParameter[IntPar->EventNum] = GetSpinButtonFloat (IntWin, "IntParEventParameterSpinButton");
  IntPar->EventActiveTime[IntPar->EventNum] = GetSpinButtonFloat (IntWin, "IntParEventTimeSpinButton");
  IntPar->EventNum++;

  sprintf (TmpStr, "%d", IntPar->EventNum);
  SetEntry (IntWin, "IntParEventNumEntry", TmpStr);

  SortEvents (IntPar);
  RefreshIntParEventCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParEventRemoveButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
int EventSelectedTrack;
char *TmpStr;

  TmpStr = alloca(20);
  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");
  EventSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntWin), "EventSelectedTrack"));
  if (EventSelectedTrack < 0) return;

  DeleteEvent (IntPar, EventSelectedTrack);
  sprintf (TmpStr, "%d", IntPar->EventNum);
  SetEntry (IntWin, "IntParEventNumEntry", TmpStr);

  RefreshIntParEventCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParEventModifyButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *IntWin;
struct IntegrationParametersStruct *IntPar;
int EventSelectedTrack;

  IntWin = gtk_widget_get_toplevel (GTK_WIDGET (button));
  IntPar = gtk_object_get_data (GTK_OBJECT(IntWin), "IntParLocal");
  EventSelectedTrack = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (IntWin), "EventSelectedTrack"));
  if (EventSelectedTrack < 0) return;

  IntPar->EventType[EventSelectedTrack] = gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget(IntWin, "IntParSelectEventComboBox")));
  IntPar->EventTime[EventSelectedTrack] = GetSpinButtonFloat (IntWin, "IntParEventRetentionSpinButton");
  IntPar->EventFactor[EventSelectedTrack] = GetSpinButtonInt (IntWin, "IntParEventFactorSpinButton");
  IntPar->EventParameter[EventSelectedTrack] = GetSpinButtonFloat (IntWin, "IntParEventParameterSpinButton");
  IntPar->EventActiveTime[EventSelectedTrack] = GetSpinButtonFloat (IntWin, "IntParEventTimeSpinButton");

  RefreshIntParEventCList (WIDGET_TOP(button));
  ActivateIntParWidgets (WIDGET_TOP(button));
}


void
on_IntParOkButton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_IntParCancelButton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_IntParHelpButton_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_IntParApplyButton_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


// Event handler window


void
on_EventHandlerHelpButton_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_EventHandlerAddButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *EventAddWindow;
struct IntegrationParametersStruct *IntPar;
int DataSource;

  EventAddWindow = WIDGET_TOP(button);
  IntPar = gtk_object_get_data (GTK_OBJECT (EventAddWindow), "IntPar");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (EventAddWindow), "DataSource"));
  IntPar->EventType[IntPar->EventNum] = EventCode (gtk_combo_box_get_active (GTK_COMBO_BOX(lookup_widget (EventAddWindow, "EventHandlerTypeComboBox"))));
  IntPar->EventTime[IntPar->EventNum] = GetSpinButtonFloat (EventAddWindow, "EventHandlerRetentionSpinButton");
  IntPar->EventFactor[IntPar->EventNum] = GetSpinButtonInt (EventAddWindow, "EventHandlerFactorSpinButton");
  IntPar->EventParameter[IntPar->EventNum] = GetSpinButtonFloat (EventAddWindow, "EventHandlerParameterSpinButton");
  IntPar->EventActiveTime[IntPar->EventNum] = GetSpinButtonFloat (EventAddWindow, "EventHandlerTimeSpinButton");
  IntPar->EventNum++;

  SortEvents (IntPar);
  ReintegrateDBI (DataSource);
  ReprocessDrawChrom ();
  RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
  gtk_widget_destroy (EventAddWindow);
}


void
on_EventHandlerRemoevButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *EventDelWindow;
struct IntegrationParametersStruct *IntPar;
int DataSource;
int SelectedEvent;

  EventDelWindow = WIDGET_TOP(button);
  IntPar = gtk_object_get_data (GTK_OBJECT (EventDelWindow), "IntPar");
  DataSource = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (EventDelWindow), "DataSource"));
  SelectedEvent = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (EventDelWindow), "SelectedEvent"));

  DeleteEvent (IntPar, SelectedEvent);
  ReintegrateDBI (DataSource);
  ReprocessDrawChrom ();
  RefreshPeakList ();
  if (ZoomPermanentCheck())
	  ZoomPermanentContinue ();
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_EventhandlerCancelButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}
