// Central window callback functions

gboolean
on_CentralWindow_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  CentralExitMessageBox = create_CentralExitMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (CentralExitMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (CentralExitMessageBox), GTK_WINDOW (CentralWindow));
  gtk_widget_show (CentralExitMessageBox);

  return TRUE;
}


gboolean
on_CentralWindow_destroy_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_CentralNewButton_clicked            (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  CentralNewMessageBox = create_CentralNewMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (CentralNewMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (CentralNewMessageBox), GTK_WINDOW (CentralWindow));
  gtk_widget_show (CentralNewMessageBox);
}


void
on_CentralPreferencesButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int SelectedPrintFont;

  SelectedPrintFont = -1;
  CentralPreferences = create_CentralPreferences ();
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET (toolbutton))), "CentralPreferences", CentralPreferences);
  gtk_object_set_data (GTK_OBJECT (CentralPreferences), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET (toolbutton)));
  gtk_object_set_data (GTK_OBJECT (CentralPreferences), "CallerButton", toolbutton);
  gtk_object_set_data (GTK_OBJECT (CentralPreferences), "SelectedPrintFont", GINT_TO_POINTER(SelectedPrintFont));
  gtk_widget_set_sensitive (GTK_WIDGET(toolbutton), FALSE);
  SetCentralPreferences ();
  gtk_widget_show (CentralPreferences);
  gtk_window_set_transient_for (GTK_WINDOW (CentralPreferences), GTK_WINDOW (CentralWindow));
}


void
on_CentralAboutButton_clicked          (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (CentralWindow));
  gtk_widget_show (About);
}


void
on_CentralExitButton_clicked           (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  CentralExitMessageBox = create_CentralExitMessageBox ();
  gtk_window_set_modal (GTK_WINDOW (CentralExitMessageBox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (CentralExitMessageBox), GTK_WINDOW (CentralWindow));
  gtk_widget_show (CentralExitMessageBox);
}


void
on_CentralAddInstrument_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  if (LC2.NumberOfInstruments > MaxInstruments - 1) return;
  CentralInstrumentSetup = create_CentralInstrumentSetup ();
  gtk_window_set_transient_for (GTK_WINDOW (CentralInstrumentSetup), GTK_WINDOW (CentralWindow));
  gtk_object_set_data (GTK_OBJECT (CentralInstrumentSetup), "SelectedCentralInstrument", GINT_TO_POINTER (SelectedCentralInstrument ()));
  LC2.NumberOfInstruments++;
  ClearInstrumentDataStructure (LC2.NumberOfInstruments);
  SetCentralInstrumentSetupWidgets (CentralInstrumentSetup);
  ActivateCentralInstrumentSetupWidgets (CentralInstrumentSetup);
  gtk_widget_show (CentralInstrumentSetup);
}


void
on_CentralRemoveInstrument_clicked     (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int		i;

  if (LC2.NumberOfInstruments < 1) return;
  for (i = 1; i < LC2.NumberOfInstruments - 1; i++)
	LC2.Instruments[i] = LC2.Instruments[i+1];
  ClearInstrumentDataStructure (LC2.NumberOfInstruments);
  LC2.NumberOfInstruments--;
  ActivateCentralWidgets ();
  ConfigSave (ActualInstrument);
}


void
on_CentralSetupInstrument_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  CentralInstrumentSetup = create_CentralInstrumentSetup ();
  gtk_window_set_transient_for (GTK_WINDOW (CentralInstrumentSetup), GTK_WINDOW (CentralWindow));
  gtk_object_set_data (GTK_OBJECT (CentralInstrumentSetup), "SelectedCentralInstrument", GINT_TO_POINTER (SelectedCentralInstrument ()));
  SetCentralInstrumentSetupWidgets (CentralInstrumentSetup);
  ActivateCentralInstrumentSetupWidgets (CentralInstrumentSetup);
  gtk_widget_show (CentralInstrumentSetup);
}


void
on_CentralInstrumentRestart_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentRadioButton1_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
//  SelectedCentralInstrument = 1;
}


void
on_CentralInstrumentRadioButton2_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
//  SelectedCentralInstrument = 2;
}


void
on_CentralInstrumentRadioButton3_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
//  SelectedCentralInstrument = 3;
}


void
on_CentralInstrumentRadioButton4_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
//  SelectedCentralInstrument = 4;
}


void
on_CentralStop1_clicked                (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Kill (1);
  ActivateCentralWidgets ();
}


void
on_CentralStart1_clicked               (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Spawn (1);
  ActivateCentralWidgets ();
}


void
on_CentralStop2_clicked                (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Kill (2);
  ActivateCentralWidgets ();
}


void
on_CentralStart2_clicked               (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Spawn (2);
  ActivateCentralWidgets ();
}


void
on_CentralStop3_clicked                (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Kill (3);
  ActivateCentralWidgets ();
}


void
on_CentralStart3_clicked               (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Spawn (3);
  ActivateCentralWidgets ();
}


void
on_CentralStop4_clicked                (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Kill (4);
  ActivateCentralWidgets ();
}


void
on_CentralStart4_clicked               (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  Spawn (4);
  ActivateCentralWidgets ();
}


void
on_CentralPreferences_destroy          (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *OpenedWindow;
GtkWidget *CallerButton;

  gtk_object_set_data (GTK_OBJECT(gtk_object_get_data (object, "CallerWidget")), "CentralPreferences", NULL);

/*
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenSaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
*/

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);
}


void
on_CentralPreferencesCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CentralPreferencesOkButton_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
  GetCentralPreferences ();
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ConfigSave (ActualInstrument);
}


void
on_CentralPreferencesPrintTestButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  PrintFunction (PrintTestMode, NULL, NULL, TRUE);
}


void
on_CentralPreferencesPrintFontsGetButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
char		*TmpFontName;
int SelectedPrintFont;

  SelectedPrintFont = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (CentralPreferences), "SelectedPrintFont"));
  if (SelectedPrintFont < 0) return;

  TmpFontName = alloca (1000);
  bzero (TmpFontName, 200);
  strncpy (TmpFontName, GetSelectedPrintFontName (SelectedPrintFont), 100);
//  printf("### GetSelectedPrintFontName = %s\n", TmpFontName);
  gtk_entry_set_text (GTK_ENTRY(GetSelectedPrintFontEntry ()), TmpFontName);
//  while (1);
}


void
on_CentralPreferencesPrintFontsClearButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  gtk_entry_set_text (GTK_ENTRY(GetSelectedPrintFontEntry ()), "Sans Regular");
}


void
on_CentralPreferencesPrintFontsCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
int SelectedPrintFont;

  SelectedPrintFont = row;
  gtk_object_set_data (GTK_OBJECT (CentralPreferences), "SelectedPrintFont", GINT_TO_POINTER(SelectedPrintFont));
}


void
on_CentralPreferencesPrintFontsCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
int SelectedPrintFont;

  SelectedPrintFont = -1;
  gtk_object_set_data (GTK_OBJECT (CentralPreferences), "SelectedPrintFont", GINT_TO_POINTER(SelectedPrintFont));
}


void
on_CentralPreferencesBugTraceFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_CentralPreferencesBugTraceComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CentralNewMessageOkButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  NewInstrumentDataStructure ();
  ActivateCentralWidgets ();

  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ConfigSave (ActualInstrument);
}


void
on_CentralNewMessageCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CentralExitMessageExitButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit ();
}


void
on_CentralExitMessageCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}

// ---
// CentralInstrumentSetup
// ---

void
on_CentralInstrumentSetup_destroy      (GtkObject       *object,
                                        gpointer         user_data)
{
  ActivateCentralWidgets ();
}


void
on_CentralInstrumentSetupTypeNone_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupTypeWorkstation_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupTypeMultiChannelDataStation_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupTypeTR541Densitometer_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupTypeTR542Densitometer_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupTypeTR931Densitometer_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupChromNone_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupChromTLCScanner_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupChromGC_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupChromHPLC_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInstrumentSetupSamplingMINRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupSamplingSECRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupSamplingMMRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupIconEntry_browse
                                        (GnomeIconEntry  *gnomeiconentry,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupIconEntry_changed
                                        (GnomeIconEntry  *gnomeiconentry,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupOkButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  RetrieveCentralInstrumentSetupWidgets (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  ConfigSave (ActualInstrument);
}


void
on_CentralInstrumentSetupCancelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CentralInstrumentSetupHelpButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupDetectorNumSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupDetectorNumSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}

// ---
// Interface section
// ---

void
on_CentralInterfaceIOPortNone_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceIOPortCom1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceIOPortCom2_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceADNone_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceADChromBox2_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceADChromBox3_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceADChromBox4_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceADChromBox5_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ActivateCentralInstrumentSetupWidgets (get_toplevel_of_menuitem (GTK_WIDGET(menuitem)));
}


void
on_CentralInterfaceChannelMain_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CentralInterfaceChannelSub_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupSignalCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int ActChann;
char *ActTablePointer;
char *ActCellString;
int ActResult;
int ActValue;
int ActLevel;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(clist));
  gtk_object_set_data (GTK_OBJECT(TopWidget), "SelectedRow", GINT_TO_POINTER(-1));

  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit80", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit40", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit20", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit10", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit08", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit04", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit02", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit01", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBitsEntry", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalLevelHighRadioButton", TRUE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalLevelLowRadioButton", TRUE);

  ActChann = GetSpinButtonInt (TopWidget, "CentralInstrumentSetupSignalChannelSpinButton");
  ActCellString = alloca (100);

  ActResult = gtk_clist_get_text (clist, row, ActChann * 2, &ActTablePointer);
  strcpy (ActCellString, ActTablePointer);
  sscanf (ActCellString, "$%X", &ActValue);

  ActResult = gtk_clist_get_text (clist, row, ActChann * 2 + 1, &ActTablePointer);
  strcpy (ActCellString, ActTablePointer);
  sscanf (ActCellString, "%d", &ActLevel);
  //ActLevel = !ActLevel;

  SetCentralSignalBits (TopWidget, ActValue);
  SetCentralSignalEntry (TopWidget, ActValue);
  SetCentralSignalLevel (TopWidget, ActLevel);

  gtk_object_set_data (GTK_OBJECT(TopWidget), "SelectedRow", GINT_TO_POINTER(row));
}


void
on_CentralInstrumentSetupSignalCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(clist));
  gtk_object_set_data (GTK_OBJECT(TopWidget), "SelectedRow", GINT_TO_POINTER(-1));

  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit80", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit40", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit20", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit10", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit08", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit04", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit02", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBit01", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalBitsEntry", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalLevelHighRadioButton", FALSE);
  ActivateWidget (TopWidget, "CentralInstrumentSetupSignalLevelLowRadioButton", FALSE);
}


void
on_CentralInstrumentSetupSignalChannelSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupSignalChannelSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int ActChann;
GtkWidget *SignalCList;
int ActRow;

  ActChann = gtk_spin_button_get_value_as_int (spinbutton);
  SignalCList = lookup_widget (gtk_widget_get_toplevel (GTK_WIDGET(spinbutton)), "CentralInstrumentSetupSignalCList");
  gtk_object_set_data (GTK_OBJECT(gtk_widget_get_toplevel (GTK_WIDGET(spinbutton))), "ActualSignalChannel", GINT_TO_POINTER(ActChann));

  if (ActChann == 1) {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 2, TRUE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 3, TRUE);
  } else {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 2, FALSE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 3, FALSE);
  } // 1

  if (ActChann == 2) {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 4, TRUE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 5, TRUE);
  } else {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 4, FALSE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 5, FALSE);
  } // 2

  if (ActChann == 3) {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 6, TRUE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 7, TRUE);
  } else {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 6, FALSE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 7, FALSE);
  } // 3

  if (ActChann == 4) {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 8, TRUE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 9, TRUE);
  } else {
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 8, FALSE);
	  gtk_clist_set_column_visibility (GTK_CLIST(SignalCList), 9, FALSE);
  } // 4

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(gtk_widget_get_toplevel (GTK_WIDGET(spinbutton))), "SelectedRow"));
  if (ActRow < 0)
	  gtk_clist_select_row (GTK_CLIST(SignalCList), 0, 0);
  else
	  gtk_clist_select_row (GTK_CLIST(SignalCList), ActRow, 0);

}


void
on_CentralInstrumentSetupSignalBit80_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit40_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit20_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit10_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit08_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit04_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit02_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBit01_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalBitsEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CentralInstrumentSetupSignalLevelHighRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}


void
on_CentralInstrumentSetupSignalLevelLowRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
GtkWidget *TopWidget;
int SignalBitValue;
int ActRow;

  TopWidget = gtk_widget_get_toplevel (GTK_WIDGET(togglebutton));

  ActRow = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(TopWidget), "SelectedRow"));
  if (ActRow < 0) return;

  SignalBitValue = GetCentralSignalBits (TopWidget);
  SetCentralSignalRow (TopWidget, SignalBitValue, GetCentralSignalLevel (TopWidget));
  SetCentralSignalEntry (TopWidget, SignalBitValue);
}
