// Calibration window callback functions

void
on_CalibrationWindow_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *OpenedWindow;
GtkWidget *CallerButton;
GtkWidget *CallerWidget;

  int DataSource = GPOINTER_TO_INT(gtk_object_get_data (object, "DataSource"));

  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "OpenSaveFileSelection");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SelectTemplateDialog");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);
  OpenedWindow = gtk_object_get_data (GTK_OBJECT (object), "SelectChromDialog");
  if (OpenedWindow != NULL) gtk_widget_destroy (OpenedWindow);

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);

  CallerWidget = gtk_object_get_data (object, "CallerWidget");
  if (CallerWidget != NULL)
	  gtk_object_set_data (GTK_OBJECT (CallerWidget), "CalibrationWindow", NULL);

  if (Chrom[DataSource].CalibrHead->SaveCalibrAfterMod)
	  CalibrSave (DataSource, Chrom[DataSource].CalName);
}


gboolean
on_CalibrationWindow_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(widget, "CalibrationCheck")), FALSE);
  return FALSE;
}

// ***
// Menu items
// ***

void
on_CalibrationNew_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationOpen_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationSave_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationSaveAs_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationQuit_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_hide (gtk_widget_get_toplevel (GTK_WIDGET(menuitem)));
}


void
on_CalibrationCut_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationCopy_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationPaste_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationClear_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationProperties_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationPreferences_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_CalibrationAbout_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  About = create_About ();
  gtk_window_set_transient_for (GTK_WINDOW (About), GTK_WINDOW (MENU_TOP(menuitem)));
  gtk_widget_show (About);
}

// ***
// Buttons
// ***

void
on_CalibrationNewButton_clicked        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int LastType;

  DATASOURCE(WIDGET_TOP(toolbutton));

  LastType = Chrom[DataSource].CalibrHead->CalibrType;
  bzero (Chrom[DataSource].CalibrHead, sizeof (struct CalibrHeadStruct));
  bzero (Chrom[DataSource].CalibrComponent, sizeof (struct CalibrComponentStruct));
  bzero (Chrom[DataSource].CalibrLevel, sizeof (struct CalibrLevelStruct));
  bzero (Chrom[DataSource].CalibrChrom, sizeof (struct CalibrChromStruct));
  bzero (Chrom[DataSource].CalibrCell, sizeof (struct CalibrCellStruct));
  bzero (Chrom[DataSource].CalibrConc, sizeof (struct CalibrConcStruct));
  Chrom[DataSource].FileLoaded[TCrFlag] = FALSE;
  Chrom[DataSource].CalibrHead->CalibrType = LastType;
  SetCalibrateWidgets (DataSource, WIDGET_TOP(toolbutton));
  CalibrationModified (DataSource);
}


void
on_CalibrationOpenButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));
  ADSI(WIDGET_TOP(toolbutton));

  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Open calibration");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", OpenCalibrOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(DataSource));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.cal");
  if (strlen (Options[ActualDSInstrument].CalibrDir) == 0)
	  strcpy (Options[ActualDSInstrument].CalibrDir, gtk_file_selection_get_filename(GTK_FILE_SELECTION(OpenSaveFileSelection)));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Options[ActualDSInstrument].CalibrDir);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_CalibrationFromTemplateButton_clicked
                                        (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSaveButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
gboolean QueueMode;

  QueueMode = DATA_DOWN(WIDGET_TOP(toolbutton), "QueueMode");
  DATASOURCE(WIDGET_TOP(toolbutton));

  if (QueueMode) {
	  CalibrSave (DataSource, Chrom[DataSource].CalName);
	  return;
  } // QueueMode

  GetCalibrateWidgets (DataSource, gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Save calibration");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SaveCalibrOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(DataSource));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.cal");
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), Chrom[DataSource].CalName);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_CalibrationTemplateButton_clicked   (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
char *TmpName;

  TmpName = alloca(FilenameLength);
  DATASOURCE(WIDGET_TOP(toolbutton));
  strcpy (TmpName, Chrom[DataSource].CalName);
  Chrom[DataSource].FileLoaded[CalFlag] = TRUE;
  if (strlen(TmpName) > 0)
	  CalibrSave (DataSource, TmpName);
  GetCalibrateWidgets (DataSource, gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  MakeTemplateFromCalibr (DataSource);
  OpenSaveFileSelection = create_OpenSaveFileSelection ();
  gtk_window_set_title (GTK_WINDOW (OpenSaveFileSelection), "Save calibration template");
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "ApplyFunction", SaveCalibrOkFunction);
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "CallerWidget", gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
  gtk_object_set_data (GTK_OBJECT (OpenSaveFileSelection), "DataSource", GINT_TO_POINTER(DataSource));
  gtk_file_selection_complete (GTK_FILE_SELECTION(OpenSaveFileSelection), "*.cal");
  strcat (TmpName, ".template");
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(OpenSaveFileSelection), TmpName);
  gtk_widget_show (OpenSaveFileSelection);
}


void
on_CalibrationPrintButton_clicked      (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationRefreshButton_clicked    (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(toolbutton));
  RefreshCalibrCheckWindow (WIDGET_TOP(toolbutton));
  RecalculateCalibr (DataSource);
  CalibrationModified (DataSource);
}


void
on_CalibrationExitButton_clicked       (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
gboolean QueueMode;

  QueueMode = DATA_DOWN(WIDGET_TOP(toolbutton), "QueueMode");
  DATASOURCE(WIDGET_TOP(toolbutton));

  if (QueueMode) {
	  CalibrSave (DataSource, Chrom[DataSource].CalName);
//	  return;
  } // QueueMode

  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(WIDGET_TOP(toolbutton), "CalibrationCheck")), FALSE);
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(toolbutton)));
}

// ***
// Drawing Area
// ***

gboolean
on_CalibrationDrawingArea_configure_event
                                        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT(widget), "CalibrateDrawingAreaHeight", GINT_TO_POINTER(event->height));
  gtk_object_set_data (GTK_OBJECT(widget), "CalibrateDrawingAreaWidth", GINT_TO_POINTER(event->width));

  return FALSE;
}


gboolean
on_CalibrationDrawingArea_expose_event (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  CalibrationRedraw (WIDGET_TOP(widget));
  return FALSE;
}


gboolean
on_CalibrationDrawingArea_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}

// ***
// Option menus
// ***

void
on_CalibrationPeakIdentificationMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ConfigureCalibrateWidgets (CalibrPeakIdent, MENU_TOP(menuitem));
}


void
on_CalibrationAreaNormMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ConfigureCalibrateWidgets (CalibrAreaNorm, MENU_TOP(menuitem));
}


void
on_CalibrationISTMenuItem_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ConfigureCalibrateWidgets (CalibrIntStd, MENU_TOP(menuitem));
}


void
on_CalibrationExternalStdMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ConfigureCalibrateWidgets (CalibrExtStd, MENU_TOP(menuitem));
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationAreaMenuItem_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationHeightMenuItem_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationRetentionMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationRelativeRetentionMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationRetentionFactorMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationElutionOrderMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationLinear1ParamMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrationLinear2ParamsMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrateNonlinear_axnMenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}


void
on_CalibrateNonlinear_ax2MenuItem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  DATASOURCE(MENU_TOP(menuitem));
  RecalculateCalibr (DataSource);
  CalibrationRedraw (MENU_TOP(menuitem));
}

// ***
// Settings widgets
// ***

void
on_CalibrationSettingsForcedSingleLevelCheckButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(togglebutton));

  Chrom[DataSource].CalibrHead->ForcedSingleLevelMode = gtk_toggle_button_get_active (togglebutton);
  if (Chrom[DataSource].CalibrHead->LevelNum < 1) {
	  NewLevel (DataSource);
	  Chrom[DataSource].CalibrLevel->Existing = TRUE;
	  strcpy (Chrom[DataSource].CalibrLevel->LevelName, "Standard");
	  Chrom[DataSource].CalibrLevel->InjectedVolume = 1.0;
	  Chrom[DataSource].CalibrLevel->Volume = 1.0;
	  Chrom[DataSource].CalibrLevel->Amount = 1.0;
	  Chrom[DataSource].CalibrLevel->Factor = 1.0;
	  Chrom[DataSource].CalibrLevel->Pressure = 1.0;
	  Chrom[DataSource].CalibrLevel->Temperature = 1.0;
	  Chrom[DataSource].CalibrLevel->IstConc = 1.0;
	  AddLevel (DataSource);
  }
  if (Chrom[DataSource].CalibrHead->LevelNum > 1)
	  Chrom[DataSource].CalibrHead->ForcedSingleLevelMode = FALSE;
  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(togglebutton), "CalibrationLevelsCList")), 0, 0);
  ConfigureCalibrateWidgets (CalibrExtStd, WIDGET_TOP(togglebutton));
  CalibrationRedraw (WIDGET_TOP(togglebutton));
}


void
on_CalibrationSettingsStaticSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsStaticSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsDynamicSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsDynamicSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsMainComponentCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsForcedZeroCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsBuildInjVolCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsBuildSampleCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsBuildGasParam_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsAnalyzeInjVolCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsAnalyzeSampleCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationSettingsAnalyzeGasCheckBox_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}

// ***
// Component
// ***


void
on_CalibrationComponentsTemplateChromSelectButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *SelectQueueItemDialog;

  DATASOURCE(WIDGET_TOP(button));
  SelectQueueItemDialog = create_SelectQueueItemDialog();
  DATA_UP(SelectQueueItemDialog, "DataSource", DataSource);
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "CalibrationWindow", WIDGET_TOP(button));
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "ApplyFunction", SelectCalibrTemplateDialogApplyFunction);
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "DestroyFunction", SelectCalibrTemplateDialogDestroyFunction);

  MakeQueueDialogTree (SelectQueueItemDialog);
  RefreshQueueDialogWidgets (SelectQueueItemDialog);

  gtk_window_set_transient_for (GTK_WINDOW(SelectQueueItemDialog), GTK_WINDOW(WIDGET_TOP(button)));
  gtk_widget_show (SelectQueueItemDialog);
}


void
on_CalibrationComponentsTemplateChromFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(gnomefileentry));

  printf ("on_CalibrationComponentsTemplateChromFileEntry_browse_clicked\n");
  gtk_object_set_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(gnomefileentry))), "TemplateID", GINT_TO_POINTER(rand ()));
  if (DataSource < MaxInstrument)
	  gnome_file_entry_set_filename (gnomefileentry, Options[DataSource].MeasureDataDir);
  else
	  gnome_file_entry_set_filename (gnomefileentry, Options[DataSource].DefaultDataRootDir);
}


void
on_CalibrationComponentsTemplateChromComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
GtkWidget *CalibrTop;
int TemplateID, TemplatePrevID;
int j;

  CalibrTop = WIDGET_TOP(editable);
  DATASOURCE(CalibrTop);
  printf ("on_CalibrationComponentsTemplateChromComboEntry_changed\n");
  TemplateID = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(CalibrTop), "TemplateID"));
  TemplatePrevID = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(CalibrTop), "TemplatePrevID"));
  if (TemplateID != TemplatePrevID) {
	  gtk_object_set_data (GTK_OBJECT(CalibrTop), "TemplatePrevID", GINT_TO_POINTER(TemplateID));
	  GetGnomeFileEntry (CalibrTop, "CalibrationComponentsTemplateChromFileEntry", Chrom[DataSource].CalibrTemplateChromName);
	  printf ("Filename: %s\n", Chrom[DataSource].CalibrTemplateChromName);
	  CalibrTemplateChromLoad (DataSource);
	  RefreshCalibrTemplateChromList (DataSource, CalibrTop);
	  for (j = 0; j < MaxDetectors; j++)
		  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (CalibrTop, "CalibrationComponentsListDetectorComboBox")), 0);
	  for (j = 0; j < Chrom[DataSource].CalibrTemplateChromHead->Method.Instrument.NumDetectors; j++)
		  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (CalibrTop, "CalibrationComponentsListDetectorComboBox")), \
	  														Chrom[DataSource].CalibrTemplateChromHead->Method.Instrument.Detectors[j].Name);
	  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (CalibrTop, "CalibrationComponentsListDetectorComboBox")), \
	  												Chrom[DataSource].CalibrTemplateActualDetector);
	  if (Chrom[DataSource].CalibrTemplateChromHead->PeakHead.PeakNum[Chrom[DataSource].CalibrTemplateActualDetector] > 0)
		  gtk_clist_select_row (GTK_CLIST(lookup_widget (CalibrTop, "CalibrationComponentsTemplateChromCList")), 0, 0);
	  else
		  gtk_clist_unselect_row (GTK_CLIST(lookup_widget (CalibrTop, "CalibrationComponentsTemplateChromCList")), 0, 0);
  } // TemplateID != TemplatePrevID
  CalibrationModified (DataSource);
}


void
on_CalibrationComponentsGetRetentionButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedTemplatePeak;

  DATASOURCE(WIDGET_TOP(button));
  SelectedTemplatePeak = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(button)), "SelectedTemplatePeak"));
  if (SelectedTemplatePeak == -1) return;

  GetCalibrTemplatePeak (SelectedTemplatePeak, DataSource);
  SetSpinButtonValue (WIDGET_TOP(button), "CalibrationComponentsRetentionSpinButton", Chrom[DataSource].CalibrTemplatePeak->PeakRetention);
  CalibrationModified (DataSource);
}


void
on_CalibrationComponentsAddButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(button));
  NewComponent (DataSource);
  GetCalibrComponentWidgets (DataSource, WIDGET_TOP(button));
  AddComponent (DataSource);
  RefreshCalibrComponentList (DataSource, WIDGET_TOP(button));
  RebuildIstId (DataSource);
  RefreshIstList (DataSource, WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationComponentsRemoveButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedRow;

  DATASOURCE(WIDGET_TOP(button));
  CAL_SELECTEDS(WIDGET_TOP(button));

  if (SelectedComponent < 0) return;
  DelComponent (SelectedComponent, DataSource);
  RefreshCalibrComponentList (DataSource, WIDGET_TOP(button));
  RebuildIstId (DataSource);
  RefreshIstList (DataSource, WIDGET_TOP(button));
  CalibrationModified (DataSource);
  SelectedRow = 0;
  if (SelectedComponent < Chrom[DataSource].CalibrHead->ComponentNum)
	  SelectedRow = SelectedComponent;
  else if (Chrom[DataSource].CalibrHead->ComponentNum > 0)
		  SelectedRow = Chrom[DataSource].CalibrHead->ComponentNum - 1;
  if (Chrom[DataSource].CalibrHead->ComponentNum > 0)
	  gtk_clist_select_row (GTK_CLIST(lookup_widget(WIDGET_TOP(button), "CalibrationComponentsCList")), SelectedRow, 0);
  else {
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(button)), "SelectedComponent", GINT_TO_POINTER(-1));
	  RefreshCellDataField (DataSource, WIDGET_TOP(button));
	  CalibrationRedraw (WIDGET_TOP(button));
  }
  ActivateCalibrateWidgets (WIDGET_TOP(button));
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationComponentsModifyButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedComponent;

  DATASOURCE(WIDGET_TOP(button));
  SelectedComponent = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(button)), "SelectedComponent"));
  if (SelectedComponent < 0) return;
	  printf ("SelectedComponent = %d\n", SelectedComponent);
  GetComponent (SelectedComponent, DataSource);
  GetCalibrComponentWidgets (DataSource, WIDGET_TOP(button));
  SetComponent (SelectedComponent, DataSource);
  RefreshCalibrComponentList (DataSource, WIDGET_TOP(button));
  RecalculateCalibr (DataSource);
  RebuildIstId (DataSource);
  RefreshIstList (DataSource, WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationComponentsClearFieldsButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(button));

  CalibrationModified (DataSource);
}


void
on_CalibrationComponentsGetNextButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(button));

}


void
on_CalibrationComponentsListDetectorComboBox_changed
                                        (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(combobox));
  Chrom[DataSource].CalibrTemplateActualDetector = gtk_combo_box_get_active (combobox);
  if (Chrom[DataSource].CalibrTemplateActualDetector < 0) return;
  RefreshCalibrTemplateChromList (DataSource, WIDGET_TOP(combobox));
  SetEntry (WIDGET_TOP(combobox), "CalibrationComponentsDetectorEntry", Chrom[DataSource].CalibrTemplateChromHead->Method.Instrument.Detectors[Chrom[DataSource].CalibrTemplateActualDetector].Name);
}


void
on_CalibrationComponentsTemplateChromCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedTemplatePeak", GINT_TO_POINTER(row));
}


void
on_CalibrationComponentsTemplateChromCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedTemplatePeak", GINT_TO_POINTER(-1));
}

// ***
// Level
// ***


void
on_CalibrationLevelsChromSelectButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *SelectQueueItemDialog;

  DATASOURCE(WIDGET_TOP(button));
  SelectQueueItemDialog = create_SelectQueueItemDialog();
  DATA_UP(SelectQueueItemDialog, "DataSource", DataSource);
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "CalibrationWindow", WIDGET_TOP(button));
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "ApplyFunction", SelectCalibrChromDialogApplyFunction);
  gtk_object_set_data (GTK_OBJECT (SelectQueueItemDialog), "DestroyFunction", SelectCalibrChromDialogDestroyFunction);

  MakeQueueDialogTree (SelectQueueItemDialog);
  RefreshQueueDialogWidgets (SelectQueueItemDialog);

  gtk_window_set_transient_for (GTK_WINDOW(SelectQueueItemDialog), GTK_WINDOW(WIDGET_TOP(button)));
  gtk_widget_show (SelectQueueItemDialog);
}


void
on_CalibrationLevelsAddLevelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(button));
  gtk_clist_unselect_all (GTK_CLIST(lookup_widget (WIDGET_TOP(button), "CalibrationChromatogramsCList")));
  NewLevel (DataSource);
  GetCalibrLevelWidgets (DataSource, WIDGET_TOP(button));
  AddLevel (DataSource);
//  RecalculateCalibr (DataSource);
  RefreshCalibrLevelList (DataSource, WIDGET_TOP(button));
  ActivateCalibrateWidgets (WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationLevelsRemoveLevelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedRow;

  DATASOURCE(WIDGET_TOP(button));
  CAL_SELECTEDS(WIDGET_TOP(button));

  gtk_clist_unselect_all (GTK_CLIST(lookup_widget (WIDGET_TOP(button), "CalibrationChromatogramsCList")));
  if (SelectedLevel < 0) return;
  DelLevel (SelectedLevel, DataSource);
  RefreshCalibrLevelList (DataSource, WIDGET_TOP(button));
  RecalculateCalibr (DataSource);

  SelectedRow = 0;
  if (SelectedLevel < Chrom[DataSource].CalibrHead->LevelNum)
	  SelectedRow = SelectedLevel;
  else if (Chrom[DataSource].CalibrHead->LevelNum > 0)
		  SelectedRow = Chrom[DataSource].CalibrHead->LevelNum - 1;
  if (Chrom[DataSource].CalibrHead->LevelNum > 0)
	  gtk_clist_select_row (GTK_CLIST(lookup_widget(WIDGET_TOP(button), "CalibrationLevelsCList")), SelectedRow, 0);
  else {
	  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(button)), "SelectedLevel", GINT_TO_POINTER(-1));
	  RefreshCellDataField (DataSource, WIDGET_TOP(button));
	  CalibrationRedraw (WIDGET_TOP(button));
  }
  ActivateCalibrateWidgets (WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationLevelsModifyLevelButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(button));
  CAL_SELECTEDS(WIDGET_TOP(button));

  gtk_clist_unselect_all (GTK_CLIST(lookup_widget (WIDGET_TOP(button), "CalibrationChromatogramsCList")));
  GetCalibrLevelWidgets (DataSource, WIDGET_TOP(button));
  SetLevel (SelectedLevel, DataSource);
  RefreshCalibrLevelList (DataSource, WIDGET_TOP(button));
  RecalculateCalibr (DataSource);

  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationLevelsChromFileEntry_browse_clicked
                                        (GnomeFileEntry  *gnomefileentry,
                                        gpointer         user_data)
{

}


void
on_CalibrationLevelsChromComboEntry_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_CalibrationLevelsChromAddButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
int SelectedLevel;

  DATASOURCE(WIDGET_TOP(button));
  SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "SelectedLevel"));
  NewChrom (DataSource);
  GetCalibrChromWidgets (DataSource, WIDGET_TOP(button));
  AddChrom (SelectedLevel, DataSource);
  RefreshCalibrChromList (DataSource, WIDGET_TOP(button));
  gtk_clist_select_row (GTK_CLIST(lookup_widget(WIDGET_TOP(button), "CalibrationChromatogramsCList")), Chrom[DataSource].CalibrLevelArray[SelectedLevel].ChromNum - 1, 0);
  TransferCalibrChromToLevel (DataSource, WIDGET_TOP(button));
  SetCalibrChromWidgets (DataSource, WIDGET_TOP(button));
  ActivateCalibrateWidgets (WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationLevelsChromRemoveButtons_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(button));

  ActivateCalibrateWidgets (WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationLevelsChromModifyButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(button));

  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}

// ***
// Cell
// ***

void
on_CalibrationCellDataUnfilledDoNothingRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataUnfilledHighlightRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataUnfilledShowOnlyRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataSetToCellButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{
int CellIdx;

  GtkWidget *CalibrTop = WIDGET_TOP(toolbutton);
  DATASOURCE(CalibrTop);
  CAL_SELECTEDS(CalibrTop);

  if (SelectedComponent < 0) return;
  if (SelectedLevel < 0) return;
  if (SelectedChrom < 0) return;
  if (SelectedChromPeak < 0) return;

  GetCalibrPeak (SelectedChromPeak, DataSource);

  CellIdx = GetCell (SelectedComponent, SelectedLevel, SelectedChrom, DataSource);
  Chrom[DataSource].CalibrCell->RetTime = Chrom[DataSource].CalibrPeak->PeakRetention;
  Chrom[DataSource].CalibrCell->Integral = Chrom[DataSource].CalibrPeak->PeakArea;
  Chrom[DataSource].CalibrCell->Height = Chrom[DataSource].CalibrPeak->PeakHeight;
  Chrom[DataSource].CalibrCell->Filled = TRUE;
  SetCell (SelectedComponent, SelectedLevel, SelectedChrom, DataSource);
  RecalculateCalibr (DataSource);
  RefreshCellDataField (DataSource, CalibrTop);
  ActivateCalibrateWidgets (CalibrTop);
  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (CalibrTop);
}


void
on_CalibrationCellDataIdentifyButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(toolbutton));

  CalibrationModified (DataSource);
}


void
on_CalibrationCellDataFindAndSetButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(toolbutton));

  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(toolbutton));
}


void
on_CalibrationCellDataResetButton_clicked
                                        (GtkToolButton       *toolbutton,
                                        gpointer         user_data)
{

  DATASOURCE(WIDGET_TOP(toolbutton));

  CalibrationModified (DataSource);
  RefreshCalibrCheckWindow (WIDGET_TOP(toolbutton));
}


void
on_CalibrationCellDataPeakListCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedChromPeak", GINT_TO_POINTER(row));
  RefreshSelectedPeakDataField (DataSource, WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
}


void
on_CalibrationCellDataPeakListCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedChromPeak", GINT_TO_POINTER(-1));
  RefreshSelectedPeakDataField (DataSource, WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
}


void
on_CalibrationCellDataUnidentifiedDoNothingRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataUnidentifiedHighlightRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataUnidentifiedShowOnlyRadioButton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCellDataChannelComboBox_changed
                                        (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(combobox));
  Chrom[DataSource].CalibrActualDetector = gtk_combo_box_get_active (combobox);
  if (Chrom[DataSource].CalibrActualDetector < 0) return;
  RefreshCellDataPeakList (DataSource, WIDGET_TOP(combobox));
}

// ***
// Concentration
// ***

void
on_CalibrationSetConcSpinButton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(editable));
  GetConcField (WIDGET_TOP(editable));
  CalibrationModified (DataSource);
  RecalculateCalibr (DataSource);
  CalibrationRedraw (WIDGET_TOP(editable));
  RefreshCalibrCheckWindow (WIDGET_TOP(editable));
}


void
on_CalibrationSetConcSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(spinbutton));
  GetConcField (WIDGET_TOP(spinbutton));
  CalibrationModified (DataSource);
  RecalculateCalibr (DataSource);
  CalibrationRedraw (WIDGET_TOP(spinbutton));
  RefreshCalibrCheckWindow (WIDGET_TOP(spinbutton));
}


void
on_CalibrationSetConcButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(button));
  GetConcField (WIDGET_TOP(button));
  CalibrationModified (DataSource);
  RecalculateCalibr (DataSource);
  CalibrationRedraw (WIDGET_TOP(button));
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}


void
on_CalibrationGetConcButton_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
double PrevConc;
int i;

  CAL_SELECTEDS(WIDGET_TOP(button));
  if (SelectedLevel < 1) return;

  DATASOURCE(WIDGET_TOP(button));
  for (i = 0; i < Chrom[DataSource].CalibrHead->ComponentNum; i++) {
	  GetConc (i, SelectedLevel - 1, DataSource);
	  PrevConc = Chrom[DataSource].CalibrConc->Concentration;
	  GetConc (i, SelectedLevel, DataSource);
	  Chrom[DataSource].CalibrConc->Concentration = PrevConc;
	  SetConc (i, SelectedLevel, DataSource);
  } // i
  SetConcField (WIDGET_TOP(button));
  printf ("on_CalibrationGetConcButton_clicked\n");
  CalibrationModified (DataSource);
  RecalculateCalibr (DataSource);
  CalibrationRedraw (WIDGET_TOP(button));
  RefreshCalibrCheckWindow (WIDGET_TOP(button));
}

// ***
// Lists
// ***

void
on_CalibrationComponentsCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedComponent", GINT_TO_POINTER(row));
  GetComponent (row, DataSource);
  SetCalibrComponentWidgets (DataSource, WIDGET_TOP(clist));
  SetConcField (WIDGET_TOP(clist));
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}


void
on_CalibrationComponentsCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedComponent", GINT_TO_POINTER(-1));
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}


void
on_CalibrationLevelsCList_select_row   (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedLevel", GINT_TO_POINTER(row));
  GetLevel (row, DataSource);
  SetCalibrLevelWidgets (DataSource, WIDGET_TOP(clist));
  SetConcField (WIDGET_TOP(clist));
  RefreshCalibrChromList (DataSource, WIDGET_TOP(clist));
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}


void
on_CalibrationLevelsCList_unselect_row (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedLevel", GINT_TO_POINTER(-1));
  gtk_clist_unselect_all (GTK_CLIST(lookup_widget (WIDGET_TOP(clist), "CalibrationChromatogramsCList")));
  RefreshCalibrChromList (DataSource, WIDGET_TOP(clist));
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}


void
on_CalibrationChromatogramsCList_select_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
int SelectedLevel;
int j;

  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedChrom", GINT_TO_POINTER(row));
  SelectedLevel = GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedLevel"));
  if (SelectedLevel < 0) return;
  GetChrom (SelectedLevel, row, DataSource);
  SetCalibrChromWidgets (DataSource, WIDGET_TOP(clist));

  strcpy (Chrom[DataSource].CalibrChromName, Chrom[DataSource].CalibrChrom->ChromName);
  CalibrChromLoad (DataSource);
  RefreshCellDataPeakList (DataSource, WIDGET_TOP(clist));
  for (j = 0; j < MaxDetectors; j++)
	  gtk_combo_box_remove_text (GTK_COMBO_BOX(lookup_widget (WIDGET_TOP(clist), "CalibrationCellDataChannelComboBox")), 0);
  for (j = 0; j < Chrom[DataSource].CalibrChromHead->Method.Instrument.NumDetectors; j++)
	  gtk_combo_box_append_text (GTK_COMBO_BOX(lookup_widget (WIDGET_TOP(clist), "CalibrationCellDataChannelComboBox")), \
														Chrom[DataSource].CalibrChromHead->Method.Instrument.Detectors[j].Name);
  gtk_combo_box_set_active (GTK_COMBO_BOX(lookup_widget (WIDGET_TOP(clist), "CalibrationCellDataChannelComboBox")), \
												Chrom[DataSource].CalibrActualDetector);
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}


void
on_CalibrationChromatogramsCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "SelectedChrom", GINT_TO_POINTER(-1));
  RefreshCellDataField (DataSource, WIDGET_TOP(clist));
  CalibrationRedraw (WIDGET_TOP(clist));
  ActivateCalibrateWidgets (WIDGET_TOP(clist));
  RefreshCalibrCheckWindow (WIDGET_TOP(clist));
}

// Common buttons

void
on_CalibrationOkButton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (gtk_widget_get_toplevel (GTK_WIDGET(button)));
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(WIDGET_TOP(button), "CalibrationCheck")), FALSE);
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CalibrationCancelButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(WIDGET_TOP(button), "CalibrationCheck")), FALSE);
  gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CalibrationApplyButton_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
ApplyFunctionType *ApplyFunction;

  ApplyFunction = gtk_object_get_data (GTK_OBJECT (gtk_widget_get_toplevel (GTK_WIDGET(button))), "ApplyFunction");
  if (ApplyFunction != NULL)
	  ApplyFunction (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_CalibrationHelpButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{

}

// ***
// Calibration check
// ***


void
on_CalibrationCheck_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gboolean ChkActive;

  ChkActive = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(menuitem));
  if (ChkActive)
	  gtk_widget_show (CalibrationCheckWindow);
  else
	  gtk_widget_hide (CalibrationCheckWindow);
}


void
on_CalibrationCheckCloseButton_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *ActualCalibrationWindow;

  ActualCalibrationWindow = gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "CalibrationWindow");
  if (ActualCalibrationWindow != NULL)
	  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(lookup_widget(ActualCalibrationWindow, "CalibrationCheck")), FALSE);
}


void
on_CalibrationCheckRefreshButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
GtkWidget *ActualCalibrationWindow;

  ActualCalibrationWindow = gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(button)), "CalibrationWindow");
  if (ActualCalibrationWindow != NULL)
	  ExecRefreshCalibrCheckWindow (ActualCalibrationWindow);
}


void
on_CalibrationCheckSaveButton_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_CalibrationCheckHelpButton_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_CalibrationCheckLevelSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCheckChromSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}


void
on_CalibrationCheckConcSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int SpinVal;
GtkWidget *CalibrWidget;

  CalibrWidget = gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(spinbutton)), "CalibrationWindow");
  if (CalibrWidget == NULL) return;
  SpinVal = gtk_spin_button_get_value_as_int (spinbutton);
  RefreshCalibrCheckConcByIdx (SpinVal, CalibrWidget);
}


void
on_CalibrationCheckCellSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int SpinVal;
GtkWidget *CalibrWidget;

  CalibrWidget = gtk_object_get_data (GTK_OBJECT(WIDGET_TOP(spinbutton)), "CalibrationWindow");
  if (CalibrWidget == NULL) return;
  SpinVal = gtk_spin_button_get_value_as_int (spinbutton);
  RefreshCalibrCheckCellByIdx (SpinVal, CalibrWidget);
}


void
on_CalibrationCheckCompSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{

}

// ***
// ChromToCalibr
// ***


void
on_ChromToCalibrLevelSpinButton_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
int SpinValue;

  DATASOURCE(WIDGET_TOP(spinbutton));
  if (!Chrom[DataSource].FileLoaded[CalFlag]) return;
  SpinValue = gtk_spin_button_get_value_as_int (spinbutton);
  if (SpinValue >= Chrom[DataSource].CalibrHead->LevelNum) return;
  if (SpinValue == GPOINTER_TO_INT(gtk_object_get_data (GTK_OBJECT (WIDGET_TOP(spinbutton)), "ChromToCalibrLevel"))) return;

  gtk_clist_select_row (GTK_CLIST(lookup_widget (WIDGET_TOP(spinbutton), "ChromToCalibrLevelCList")), \
						SpinValue, 0);
}


void
on_ChromToCalibrLevelCList_select_row  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(clist));
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "ChromToCalibrLevel", GINT_TO_POINTER(row));
  gtk_widget_set_sensitive (lookup_widget(WIDGET_TOP(clist), "ChromToCalibrOkButton"), TRUE);
  SetSpinButtonValue (WIDGET_TOP(clist), "ChromToCalibrLevelSpinButton", row);
}


void
on_ChromToCalibrLevelCList_unselect_row
                                        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_object_set_data (GTK_OBJECT (WIDGET_TOP(clist)), "ChromToCalibrLevel", GINT_TO_POINTER(-1));
  gtk_widget_set_sensitive (lookup_widget(WIDGET_TOP(clist), "ChromToCalibrOkButton"), FALSE);
}


void
on_ChromToCalibrHelpButton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_ChromToCalibrCancelButton_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (WIDGET_TOP(button));
}


void
on_ChromToCalibrOkButton_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  DATASOURCE(WIDGET_TOP(button));
  ImplantChromToCalibr (WorkArea, DataSource, \
						Chrom[DataSource].ChromHead->Method.MeasureParameters.StandardLevel, \
						Chrom[DataSource].ChromHead->Method.MeasureParameters.StandardMode);
  gtk_widget_destroy (WIDGET_TOP(button));
}


void
on_ChromToCalibrDialog_destroy         (GtkObject       *object,
                                        gpointer         user_data)
{
GtkWidget *CallerButton;

  CallerButton = gtk_object_get_data (object, "CallerButton");
  if (CallerButton != NULL)
	  gtk_widget_set_sensitive (CallerButton, TRUE);
}

// Error window


void
on_CalibrChromLevelMismatchHelpButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_CalibrChromLevelMismatchCloseButton_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (WIDGET_TOP(button));
}
