// Generic A/D converter API

void
GetADRawData (void) {
unsigned char	byte0,
						byte1,
						byte2,
						byte3,
						byte4,
						byte5,
						byte6,
						byte7,
						byte8,
						byte9,
						byte10,
						byte11;
int TestInt0, TestInt1;

BT_INIT();

  switch (WorkAD.ADDeviceId) {
	case ADConverterNone:
		break; // ADConverterNone
	case ADConverterChromBox2:
	  dputc ('\x00');
	
	  byte1=readbyte();
	  ADRawTimeOut[0] = timeout_flag;
	  ADRawResponse[0] = byte1;
	  if ((byte1 != 0xFF) && (!timeout_flag)) {
		//  printf ("byte1 = %X\n", byte1);
		  ADRawINPort[0] = byte1;
		  byte2=readbyte();
		  byte3=readbyte();
		  byte4=readbyte();
		  byte5=readbyte();
		  byte6=readbyte();
		  byte7=readbyte();
		  ADRawTimeOut[0] = timeout_flag;
		  pthread_mutex_lock (&measure_data_mutex);
		  ADRawValue[0][0] = 65536*byte2 + 256*byte3 + byte4 - WorkAD.ADZeroPoint;
		  pthread_mutex_unlock (&measure_data_mutex);
		  ADRawFreshData[0] = TRUE;
		  //printf ("ADRawValue[0][0] = %d\n", ADRawValue[0][0]);
	  } // byte1 != 0xFF
		break; // ADConverterChromBox2
	case ADConverterChromBox3:
	  dputc ('\x00');
	
	  byte1=readbyte();
	  ADRawTimeOut[0] = timeout_flag;
	  ADRawResponse[0] = byte1;
	  if ((byte1 != 0xFF) && (!timeout_flag)) {
		  byte2=readbyte();
		  byte3=readbyte();
		  byte4=readbyte();
		  ADRawTimeOut[0] = timeout_flag;
		  pthread_mutex_lock (&measure_data_mutex);
		  ADRawValue[0][0] = 65536*byte2 + 256*byte3 + byte4 - WorkAD.ADZeroPoint;
		  pthread_mutex_unlock (&measure_data_mutex);
	  } // byte1 != 0xFF
		break; // ADConverterChromBox3
	case ADConverterChromBox4:
	  dputc ('\x00');
	
	  byte1=readbyte();
	  ADRawTimeOut[0] = timeout_flag;
	  ADRawResponse[0] = byte1;
	  if ((byte1 != 0xFF) && (!timeout_flag)) {
		  ADRawINPort[0] = byte1;
		  byte2=readbyte();
		  byte3=readbyte();
		  byte4=readbyte();
		  byte5=readbyte();
		  byte6=readbyte();
		  byte7=readbyte();
		  ADRawTimeOut[0] = timeout_flag;
		  ADRawFreshData[0] = TRUE;
		  pthread_mutex_lock (&measure_data_mutex);
		  ADRawValue[0][0] = 65536*byte2 + 256*byte3 + byte4 - WorkAD.ADZeroPoint;
		  if ((byte5 != 0xFF) || (byte6 != 0xFF) || (byte7 != 0xFF))
			  ADRawValue[0][1] = 65536*byte5 + 256*byte6 + byte7 - WorkAD.ADZeroPoint;
		  pthread_mutex_unlock (&measure_data_mutex);
	  } // byte1 != 0xFF
		break; // ADConverterChromBox4
	case ADConverterChromBox5:
					/*
					C0 00			AD DATA R: COUNTER, H1 M1 L1 H2 M2 L2
										IF COUNTER == 0, MEANS NO FRESH DATA
					C1 00			AD DATA + LATCH1 + LATCH2
					C2 00			GET COUNTER
					D0 01 d		LATCH OUT #1, Out data: d
					D1 01 d		LATCH OUT #2, Out data: d
					D8 00			LATCH IN #1, R: value
					D9 00			LATCH IN #2, R: value
					x0 00			Reset ALL DA channels
					x1 02 d1 d2		DA conv. #1
					x2 02 d1 d2		DA conv. #2
					x3 02 d1 d2		DA conv. #3
					x4 02 d1 d2		DA conv. #4
					*/
	  // Get IN Latches
	  dputc ('\xD8');
	  dputc ('\x00');
	  byte8=~readbyte();
	  pthread_mutex_lock (&measure_data_mutex);
	  if (!serial_no_communicate)
		  ADRawINPort[0] = byte8;
	  byte9 = ADRawOUTPort[0];
	  pthread_mutex_unlock (&measure_data_mutex);
	  // Put OUT Latches
	if (ADFreshOUTFlag[0]) {
//		  dputc ('\xD0');
//		  dputc ('\x01');
//		  dputc (byte9);
//		  byte0=readbyte();
		  ADFreshOUTFlag[0] = FALSE;
	} // Fresh OUT Flag
	if (0/*ADFreshDAFlag[0]*/) {
		if (NewGradCheck[0]) {
		  dputc ('\xBF');
		  dputc ('\x00');
		  byte0=readbyte();
		  printf ("BF executed %.2X\n", byte0);
		  NewGradCheck[0] = FALSE;
		  }
		if (NewGradValue[0]) {
		  // printf ("Fresh DA data. A=%.3f, B=%.3f   ", ADRawGradRatio[0][0], ADRawGradRatio[0][1]);
		  byte10 = (int)(ADRawGradRatio[0][0] * 65535);
		  byte11 = (int)(ADRawGradRatio[0][0] * 65535 / 256);
		  TestInt0 = 0;
		  TestInt1 = 0;
		  TestInt0 = byte10;
		  TestInt1 = byte11;
		  // printf ("A Low = %d, A High = %d   ", TestInt0, TestInt1);
		  dputc ('\xB1');
		  dputc ('\x02');
		  dputc (byte10);
		  dputc (byte11);
		  byte0=readbyte();
		  byte10 = (int)(ADRawGradRatio[0][1] * 65535);
		  byte11 = (int)(ADRawGradRatio[0][1] * 65535 / 256);
		  TestInt0 = 0;
		  TestInt1 = 0;
		  TestInt0 = byte10;
		  TestInt1 = byte11;
		  // printf ("B Low = %d, B High = %d\n", TestInt0, TestInt1);
		  dputc ('\xB2');
		  dputc ('\x02');
		  dputc (byte10);
		  dputc (byte11);
		  byte0=readbyte();
  	      NewGradValue[0] = FALSE;
		  }
		  ADFreshDAFlag[0] = FALSE;
	} // Fresh DA Flag
	  // Get AD data
	  dputc ('\xC0');
	  dputc ('\x00');
	  byte1=readbyte();
//byte1 = 0;
	  ADRawTimeOut[0] = timeout_flag;
	  ADRawResponse[0] = byte1;
	  //printf ("Counter = %d\n", byte1);
	  if (serial_no_communicate) byte1 = 0xFF;
	  if ((byte1 != 0x00) && (!timeout_flag)) {
		  byte2=readbyte();
		  byte3=readbyte();
		  byte4=readbyte();
		  byte5=readbyte();
		  byte6=readbyte();
		  byte7=readbyte();
		  // Manage data
		  pthread_mutex_lock (&measure_data_mutex);
		  ADRawValue[0][0] = 65536*byte2 + 256*byte3 + byte4 - WorkAD.ADZeroPoint;
		  if ((byte5 != 0xFF) || (byte6 != 0xFF) || (byte7 != 0xFF))
			  ADRawValue[0][1] = 65536*byte5 + 256*byte6 + byte7 - WorkAD.ADZeroPoint;
		  if (serial_no_communicate) {
			  ADRawValue[0][0] = rand () % 256;
			  ADRawValue[0][1] = rand () % 256;
		  } // 
		  pthread_mutex_unlock (&measure_data_mutex);
		  ADRawTimeOut[0] = timeout_flag;
		  ADRawFreshData[0] = TRUE;
		  //printf ("ADRawValue[0][0] = %d,     ADRawValue[0][1] = %d     ", ADRawValue[0][0], ADRawValue[0][1]);
		  //printf ("ADRawOUTPort[0] = %d     ", ADRawOUTPort[0]);
		  //printf ("ADRawINPort[0] = %d\n", ADRawINPort[0]);
	  } // byte1 != 0x00
	break; // ADConverterChromBox5
  } // switch (Instruments[ActualInstrument].ADParameters.ADDeviceId)

  if ((timeout_flag) && (!ThreadMeasureError)) {
	  // Extend to handle multi-box AD
	  BUGTRACE ("*** Timeout detected.");
	  ThreadMeasureError = TRUE;
  } // if timeout_flag
  if (ADTraceResponse) {
		  printf ("R=%.2X\n", ADRawResponse[ADTraceChannel]);
		  fflush (NULL);
  } // if ADTraceResponse
  if (ADTraceFreshData) {
	  if (ADRawFreshData[ADTraceChannel]) {
		  printf ("o");
		  fflush (NULL);
	  }
  } // if ADRawFreshData[0]
  if (ADTraceData) {
	  if (ADRawFreshData[ADTraceChannel]) {
		  printf ("ADRawValue[%d][0] = %.7d,     ADRawValue[%d][1] = %.7d\n", ADTraceChannel, ADRawValue[ADTraceChannel][0], ADTraceChannel, ADRawValue[ADTraceChannel][1]);
		  fflush (NULL);
	  }
  } // if ADTraceData
  if (ADTraceInput) {
	  if (ADRawFreshData[ADTraceChannel]) {
		  printf ("ADRawINPort[%d] = $%.2X\n", ADTraceChannel, ADRawINPort[ADTraceChannel]);
		  fflush (NULL);
	  }
  } // if ADTraceInput
  if (ADTraceOutput) {
	  if (ADRawFreshData[ADTraceChannel]) {
		  printf ("ADRawOUTPort[%d] = $%.2X\n", ADTraceChannel, ADRawOUTPort[ADTraceChannel]);
		  fflush (NULL);
	  }
  } // if ADTraceOutput
  if (ADTraceGradient) {
	  if (ADRawFreshData[ADTraceChannel]) {
		  printf ("Fresh DA data. A=%.3f, B=%.3f     Channel:%d\n", ADRawGradRatio[ADTraceChannel][0], ADRawGradRatio[ADTraceChannel][1], ADTraceChannel);
		  fflush (NULL);
	  }
  } // if ADTraceGradient
} // GetADRawData

void
CrossbarADRawData () {
int	i,j;

  pthread_mutex_lock (&measure_data_mutex);
  for (i = 0; i < WorkInstruments.NumOfInstrument; i++) {
	  for (j = 0; j < WorkInstrument[i].NumDetectors; j++) {
		  MeasureDataValue[i][j] = ADRawValue[WorkInstrument[i].Detectors[j].BindMainChannel - 1][WorkInstrument[i].Detectors[j].BindSubChannel - 1];
		  MeasureScaleValue[i][j] = WorkAD.ADFullScale * ((double)MeasureDataValue[i][j] / (double)WorkAD.ADResolution);
	  } // j
	  MeasureErrorFlag[i] = ADRawTimeOut[WorkInstrument[i].Detectors[0].BindMainChannel - 1];
	  if (ADRawFreshData[WorkInstrument[i].Detectors[0].BindMainChannel - 1]) {
		  MeasureFreshDataFlag[i] = ADRawFreshData[WorkInstrument[i].Detectors[0].BindMainChannel - 1];
		  ADRawFreshData[WorkInstrument[i].Detectors[0].BindMainChannel - 1] = FALSE;
	  } // ADRawFreshData
  } // i
  pthread_mutex_unlock (&measure_data_mutex);
} // CrossbarADRawData

extern void
SetGradient (int Channel) {
  if (MeasureGradMaxFlow[Channel] < 0.00001)
    MeasureGradMaxFlow[Channel] = 1;
  ADRawGradRatio[Channel][0] = MeasureGradRatio[Channel][0] / 100 * MeasureGradFlow[Channel] / MeasureGradMaxFlow[Channel];
  ADRawGradRatio[Channel][1] = MeasureGradRatio[Channel][1] / 100 * MeasureGradFlow[Channel] / MeasureGradMaxFlow[Channel];
  ADRawGradRatio[Channel][2] = MeasureGradRatio[Channel][2] / 100 * MeasureGradFlow[Channel] / MeasureGradMaxFlow[Channel];
  ADRawGradRatio[Channel][3] = MeasureGradRatio[Channel][3] / 100 * MeasureGradFlow[Channel] / MeasureGradMaxFlow[Channel];
  ADFreshDAFlag[Channel] = TRUE;
} // SetGradient

extern void
SetStandardSignal (int Channel, int SignalCode) {
unsigned char ARO;

  ARO = WorkInstrument[Channel].ControlSignals[SignalCode].Value;
  if (WorkInstrument[Channel].ControlSignals[SignalCode].ActiveLevel)
	  ADRawOUTPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] &= ~ARO;
  else
	  ADRawOUTPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] |= ARO;

  ADFreshOUTFlag[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] = TRUE;
} // SetStandardSignal

extern void
ClrStandardSignal (int Channel, int SignalCode) {
unsigned char ARO;

  ARO = WorkInstrument[Channel].ControlSignals[SignalCode].Value;
  if (WorkInstrument[Channel].ControlSignals[SignalCode].ActiveLevel)
	  ADRawOUTPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] |= ARO;
  else
	  ADRawOUTPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] &= ~ARO;

  ADFreshOUTFlag[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1] = TRUE;
} // ClrStandardSignal

extern int
GetStandardSignal (int Channel, int SignalCode) {
int GSS;
unsigned char ARI;

  GSS = FALSE;
  ARI = WorkInstrument[Channel].ControlSignals[SignalCode].Value;

  if (WorkInstrument[Channel].ControlSignals[SignalCode].ActiveLevel)
	  GSS = ARI & ~ADRawINPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1];
  else
	  GSS = ARI & ADRawINPort[WorkInstrument[Channel].Detectors[0].BindMainChannel - 1];

  return GSS;
} // GetStandardSignal

extern void
ContactAD (void) {
  GetADRawData ();
  CrossbarADRawData ();
  if (ADTraceHeartBeat) {
	  printf (".");
	  fflush (NULL);
  }
} // ContactAD

extern void
ADInit (void) {
char		*serial_dev_name;
BT_INIT();

  serial_dev_name = alloca(100);

	switch (WorkAD.ADIOPortMenuIndex)
	{
		case 0:
		  strcpy (serial_dev_name, "/dev/null");
		break; // 0 - Comm NONE
		case 1:
		  strcpy (serial_dev_name, "/dev/ttyS0");
		break; // 1 - Comm 1
		case 2:
		  strcpy (serial_dev_name, "/dev/ttyS1");
		break; // 2 - Comm 2
		case 3:
		  strcpy (serial_dev_name, "/dev/ttyS2");
		break; // 3 - Comm 3
		case 4:
		  strcpy (serial_dev_name, "/dev/ttyS3");
		break; // 4 - Comm 4
		default:{
		  strcpy (serial_dev_name, "/dev/ttyS0");
		} // default
	} // switch
  sprintf (BugTraceUserString, "Trying to init %s", serial_dev_name);
  BUGTRACE (BugTraceUserString);
  tty_init (serial_dev_name);
  sprintf(BugTraceUserString, "Serial init done at %s", serial_dev_name);
  BUGTRACE (BugTraceUserString);
  srand (1);
} // ADInit

extern void
ADClose (void) {
int	result;

  result = tty_reset ();
  result = tty_close ();
} // ADClose

extern int
ADFreshData (int Channel) {
int FD;

  if (serial_no_communicate) {
	  usleep (10000);
	  return TRUE;
  }

  FD = MeasureFreshDataFlag[Channel];
  MeasureFreshDataFlag[Channel] = FALSE;
  return FD;
} // ADFreshData
